/*PrtElem print chemical composition at start of calculation */
#include "cddefines.h"
#include "prtelem.h"
/* this is number of elements across one line */
#define	NELEM1LINE	9

void PrtElem(
  /* the job to do, the options are "init", "fill", "flus" */
  char *chJob, 
  /* label for the element */
  char *chLabl, 
  /* its abundance */
  double abund)
{
	static char chAllLabels[NELEM1LINE][14]; /* buffer where elements will be stored*/
	long int i, 
	  noffset;
	static long int nelem;  /* counter for number of elements read in*/

#	ifdef DEBUG_FUN
	fputs( "<+>PrtElem()\n", debug_fp );
#	endif

	if( strcmp(chJob,"init") == 0 )
	{
		nelem = 0;
		fprintf( ioQQQ, 
			"                                                         Chemical Composition\n" );
	}
	else if( strcmp(chJob,"fill") == 0 )
	{
		abund = log10( abund );/* print log of abundance to avoid exponential output */
		/* stuff in labels and abundances */
		sprintf( chAllLabels[nelem], "  %2.2s:%8.4f", chLabl, abund );
		if( nelem == NELEM1LINE-1 )
		{
			/* we hit as many as it will hold - print it out and reset*/
			fprintf( ioQQQ, "      " );
			for( i=0; i < NELEM1LINE; i++ )
			{
				fprintf( ioQQQ, "%13.13s", chAllLabels[i] );
			}
			fprintf( ioQQQ, "\n" );
			/* reset counter to zero */
			nelem = 0;
		}
		else
		{
			/* just increment */
			++nelem;
		}
	}
	else if( strcmp(chJob,"flus") == 0 )
	{
		/* flush the stack */
		i = NELEM1LINE - (nelem - 2);
		noffset = i/2-1;
		/* make format pretty */
		fprintf( ioQQQ, "      " );

		for(i=0; i < noffset ; i++)
		{
			/* skip out this many fields */
			fprintf( ioQQQ, "             " );
		}

		/* if nelem is even we need to space out another 8 */
		if( !(nelem%2) && nelem > 0)
			fprintf( ioQQQ,"        ");

		for( i=0; i < nelem; i++ )
		{
			fprintf( ioQQQ, "%13.13s", chAllLabels[i] );
		}

		fprintf( ioQQQ, "\n" );
	}
	else
	{
		fprintf( ioQQQ, " PrtElem does not understand job=%4.4s\n", 
		  chJob );
		puts( "[Stop in prtelem]" );
		cdEXIT(1);
	}

#	ifdef DEBUG_FUN
	fputs( " <->PrtElem()\n", debug_fp );
#	endif
	return;
}

