/*PrtColumns print column densities of all elements */
#include "cddefines.h"
#include "cddrive.h"
#include "abundances.h"
#include "elementnames.h"
#include "prtcolumns.h"

void PrtColumns(
	/* this is stream used for io, is stdout when called by final,
	 * is punch unit when punch output generated */
	 FILE *ioMEAN )
{
	long int i, 
	  nelem;

	double aa;

#	ifdef DEBUG_FUN
	fputs( "<+>PrtColumns()\n", debug_fp );
#	endif

	fprintf( ioMEAN, "\n" );

	/* ionization column densities  */
	for( nelem=0; nelem < LIMELM; nelem++ )
	{
		if( abundances.lgElmtOn[nelem] )
		{
			int lgHIT = FALSE;
			int lgDONE = FALSE;

			fprintf( ioMEAN, " %10.10s", elementnames.chElementName[nelem]  );

			i = 1;
			while( !lgDONE )
			{
				if( cdColm(
				/* return value is zero if all ok, 1 if errors happened */
				/* 4-char + eol string that is first 
				* 4 char of element name as spelled by cloudy */
				elementnames.chElementNameShort[nelem],	

				/* integer stage of ionization, 1 for atom, 0 for CO or H2 */
				i,

				/* the theoretical column density derived by the code */
				&aa ) )
				total_insanity();

				if( aa == 0. && lgHIT )
				{
					/* this means we have printed some column, but have gotten to high
					 * ion state that does not exist */
					lgDONE = TRUE;
					break;
				}
				else if( aa > 0. )
				{
					aa = log10(aa);
					lgHIT = TRUE;
				}

				if( i == 18 )
				{
					fprintf( ioMEAN, "\n" );
				}
				fprintf( ioMEAN, "%7.3f", aa );

				/* increment counter and check if at upper limit */
				++i;
				if( i > nelem+2 )
					lgDONE = TRUE;

				/* print title for this info if we are done with hydrogen */
				if( nelem==ipHYDROGEN && lgDONE )
					fprintf(ioMEAN,"                           Log10 Column density (cm^-2)");
			}

			/* print CII excited level population */
			if( nelem==ipCARBON )
			{
				if( cdColm(
				/* return value is zero if all ok, 1 if errors happened */
				/* 4-char + eol string that is first 
				* 4 char of element name as spelled by cloudy */
				"CII*",	

				/* integer stage of ionization, 1 for atom, 0 for CO, OH, CII*, or H2 */
				0,

				/* the theoretical column density derived by the code */
				&aa ) )
					total_insanity();
				fprintf(ioMEAN," CII*  %7.3f", log10(MAX2(SMALLFLOAT,aa) ));
			}
			fprintf( ioMEAN, "\n" );

		}
	}

#	ifdef DEBUG_FUN
	fputs( " <->PrtColumns()\n", debug_fp );
#	endif
	return;
}
