/*ParseGlobule parse parameters off the globule command */
#include "cddefines.h"
#include "radius.h"
#include "phycon.h"
#include "drmnon.h"
#include "pressure.h"
#include "varypar.h"
#include "input.h"
#include "parse.h"

void ParseGlobule(char *chCard)
{
	int lgEOL;
	long int i;

#	ifdef DEBUG_FUN
	fputs( "<+>ParseGlobule()\n", debug_fp );
#	endif

	/* globule with density increasing inward
	 * parameters are outer density, radius of globule, and density power */
	i = 5;
	radius.glbden = (float)FFmtRead(chCard,&i,LINELENGTH,&lgEOL);
	if( lgEOL )
	{
		radius.glbden = 1.;
		phycon.hden = 0.;
	}

	else
	{
		phycon.hden = radius.glbden;
		radius.glbden = (float)pow(10.f,radius.glbden);
	}

	radius.glbrad = (float)FFmtRead(chCard,&i,LINELENGTH,&lgEOL);
	if( lgEOL )
	{
		radius.glbrad = 3.086e18f;
	}
	else
	{
		radius.glbrad = (float)pow(10.f,radius.glbrad);
	}

	/* this is largest zone thickness, used to set first zone thickness */
	radius.sdrmax = (float)(radius.glbrad/25.);

	/* turn off min dr checking in NEXTDR */
	drmnon.lgDrMnOn = FALSE;
	radius.glbpow = (float)FFmtRead(chCard,&i,LINELENGTH,&lgEOL);
	if( lgEOL )
		radius.glbpow = 1.;
	strcpy( pressure.chCPres, "GLOB" );

	/* this is distance to globule */
	radius.glbdst = radius.glbrad;

	/* vary option */
	if( VaryPar.lgVarOn )
	{
		/* pointer to where to write */
		VaryPar.nvfpnt[VaryPar.nparm] = input.nRead;

		/* this is the number of parameters to feed onto the input line */
		VaryPar.nvarxt[VaryPar.nparm] = 3;
		strcpy( VaryPar.chVarFmt[VaryPar.nparm], "GLOBULE %f %f %f" );

		/* param is log of abundance by number relative to hydrogen */
		VaryPar.vparm[0][VaryPar.nparm] = (float)log10(radius.glbden);
		VaryPar.vparm[1][VaryPar.nparm] = (float)log10(radius.glbrad);
		VaryPar.vparm[2][VaryPar.nparm] = radius.glbpow;
		VaryPar.vincr[VaryPar.nparm] = 0.2f;
		++VaryPar.nparm;
	}


#	ifdef DEBUG_FUN
	fputs( " <->ParseGlobule()\n", debug_fp );
#	endif
	return;
}

