/*ParseCoronal parse parameters off coronal equilibrium command */
#include "cddefines.h"
#include "rfield.h"
#include "thermal.h"
#include "radius.h"
#include "parse.h"

void ParseCoronal(char *chCard,
  long int *nqh, 
  float *ar1)
{
	int lgEOL;
	long int i;
	double a;

#	ifdef DEBUG_FUN
	fputs( "<+>ParseCoronal()\n", debug_fp );
#	endif

	/* coronal equilibrium; set constant temperature to number on line */
	thermal.lgTSetOn = TRUE;
	i = 5;
	a = FFmtRead(chCard,&i,LINELENGTH,&lgEOL);
	if( lgEOL )
	{
		fprintf( ioQQQ, " There should be a temperature on this line.\n" );
		puts( "[Stop in ParseCoronal]" );
		cdEXIT(1);
	}

	/* numbers less than or equal to 10 are the log of the temperature */
	if( a <= 10. && !lgMatch("LINE",chCard) )
	{
		thermal.ForceTemp = (float)pow(10.,a);
	}
	else
	{
		thermal.ForceTemp = (float)a;
	}

	if( thermal.ForceTemp < 3. )
	{
		fprintf( ioQQQ, " TE<3K, reset to 3K.\n" );
		thermal.ForceTemp = 3.;
	}

	/* now simulate a BREMS line */
	rfield.nspec += 1;
	if( rfield.nspec > LIMSPC )
	{
		/* too many continua were entered */
		fprintf( ioQQQ, " Too many continua entered; increase LIMSPC\n" );
		puts( "[Stop in ParseCoronal]" );
		cdEXIT(1);
	}

	strcpy( rfield.chSpType[rfield.nspec-1], "BREMS" );
	rfield.slope[rfield.nspec-1] = 1e8;
	rfield.cutoff[0][rfield.nspec-1] = 0.;
	rfield.cutoff[1][rfield.nspec-1] = 0.;

	/* simulate an ionization parameter line */
	*nqh += 1;
	if( *nqh > LIMSPC )
	{
		/* too many continua were entered */
		fprintf( ioQQQ, " Too many continua entered; increase LIMSPC\n" );
		puts( "[Stop in ParseCoronal]" );
		cdEXIT(1);
	}

	strcpy( rfield.chRSpec[*nqh-1], "SQCM" );
	strcpy( rfield.chSpNorm[*nqh-1], "IONI" );

	/* >>chng 96 jun 17, to stop mole network from crashing */
	rfield.totpow[*nqh-1] = -10.f;

	/* set R to large value if U specified but R is not */
	/* set radius to very large value if not already set */
	/* >>chng 01 jul 24, from Radius == 0 to this, as per PvH comments */
	if( !radius.lgRadiusKnown )
	{
		*ar1 = (float)radius.rdfalt;
		radius.Radius = pow(10.f,*ar1);
	}

#	ifdef DEBUG_FUN
	fputs( " <->ParseCoronal()\n", debug_fp );
#	endif
	return;
}

