/*ParseConstant parse parameters from the 'constant ...' command */
#include "cddefines.h"
#include "varypar.h"
#include "thermal.h"
#include "pressure.h"
#include "phycon.h"
#include "input.h"
#include "parse.h"

void ParseConstant(char *chCard )
{
	int lgEOL;
	long int i;

#	ifdef DEBUG_FUN
	fputs( "<+>ParseConstant()\n", debug_fp );
#	endif

	if( lgMatch("TEMP",chCard) )
	{
		/* force a constant temperature model */
		thermal.lgTSetOn = TRUE;

		i = 5;
		thermal.ForceTemp = (float)FFmtRead(chCard,&i,LINELENGTH,&lgEOL);
		/* if linear option is not on the line, convert to exponent if <= 10 */
		if( !lgMatch("LINE",chCard) )
		{
			if( thermal.ForceTemp <= 10. )
				thermal.ForceTemp = (float)pow(10.f,thermal.ForceTemp);
		}

		if( lgEOL )
		{
			NoNumb(chCard);
		}

		/* check that termperature is not less than 3K */
		if( thermal.ForceTemp < 3. )
		{
			fprintf( ioQQQ, " TE<3K, reset to 3K.\n" );
			thermal.ForceTemp = 3.;
		}

		/* bail if termperature is relativistic */
		if( thermal.ForceTemp > 1e11 )
		{
			fprintf( ioQQQ, " TE>1e11K, cloudy cannot handle this temperature.\n" );
			fprintf( ioQQQ, " Sorry.\n" );
			puts( "[Stop in ParseConstant]" );
			cdEXIT(1);
		}

		/* set the real electron temperature to the forced value */
		phycon.te = thermal.ForceTemp;

		/* vary option */
		if( VaryPar.lgVarOn )
		{
			/*  no luminosity options on vary */
			VaryPar.nvarxt[VaryPar.nparm] = 1;
			strcpy( VaryPar.chVarFmt[VaryPar.nparm], "CONStant TEMP %f" );

			/*  pointer to where to write */
			VaryPar.nvfpnt[VaryPar.nparm] = input.nRead;

			/*  log of temp will be pointer */
			VaryPar.vparm[0][VaryPar.nparm] = (float)log10(phycon.te);
			VaryPar.vincr[VaryPar.nparm] = 0.1f;
			++VaryPar.nparm;
		}
	}

	else if( lgMatch("DENS",chCard) )
	{
		/* constant density */
		strcpy( pressure.chCPres, "CDEN" );
		/* turn off radiation pressure */
		pressure.lgRadPresON = FALSE;
	}

	else if( lgMatch("PRES",chCard) )
	{
		/* constant pressure  */
		strcpy( pressure.chCPres, "CPRE" );
		if( lgMatch(" GAS",chCard) )
		{
			/*  constant gas pressure (no radiation)
			 *  turn off radiation pressure */
			pressure.lgRadPresON = FALSE;

			/*  turn off incident continuum */
			pressure.lgConPres = FALSE;

			/*  optional second number is power law index */
			i = 4;
			pressure.PresPowerlaw = (float)FFmtRead(chCard,&i,LINELENGTH,&lgEOL);
		}

		else
		{
			/*  constant total pressure, gas+rad+incident continuum
			 *  turn on radiation pressure */
			pressure.lgRadPresON = TRUE;

			/*  option to turn off continuum pressure */
			if( lgMatch("O CO",chCard) )
			{
				pressure.lgConPres = FALSE;
			}
			else
			{
				pressure.lgConPres = TRUE;
			}

			/*  option to not abort when too much radiation pressure, no abort */
			if( lgMatch("O AB",chCard) )
			{
				pressure.lgRadPresAbortOK = FALSE;
			}
			else
			{
				pressure.lgRadPresAbortOK = TRUE;
			}
			/*  there is no optional power law option for constant total pressure */
			pressure.PresPowerlaw = 0.;
		}
	}

	else
	{
		/* no keys were recognized */
		fprintf( ioQQQ, " The keyword should be TEMPerature, DENSity, GAS or PRESsure, sorry.\n" );
		puts( "[Stop in ParseConstant]" );
		cdEXIT(1);
	}

#	ifdef DEBUG_FUN
	fputs( " <->ParseConstant()\n", debug_fp );
#	endif
	return;
}

