/*ParseAbundances parse and read in composition as set by abundances command */
#include "cddefines.h"
#include "grainvar.h"
#include "abundances.h"
#include "called.h"
#include "elementnames.h"
#include "readar.h"
#include "strbst.h"
#include "mie.h"
#include "parse.h"

void ParseAbundances(char *chCard,
		     int lgDSet)
{
	int lgEOF, 
	  lgEOL, 
	  lgLog;
	long int i, 
	  j, 
	  k, 
	  nd;
	double absav[LIMELM], 
	  chk;
	GrainPar gp;


#	ifdef DEBUG_FUN
	fputs( "<+>ParseAbundances()\n", debug_fp );
#	endif

	j = 5;
	absav[0] = FFmtRead(chCard,&j,LINELENGTH,&lgEOL);
	/* check whether it scanned off end of line on first try
	 * >>chng 97 jun 8, get rid of go to
	 * if( lgEOL ) go to10 */
	if( !lgEOL )
	{
		absav[1] = FFmtRead(chCard,&j,LINELENGTH,&lgEOL);
		if( lgEOL && lgMatch(" ALL",chCard) )
		{
			/* special option, all abundances will be this number */
			if( absav[0] <= 0. )
			{
				absav[0] = pow(10.,absav[0]);
			}
			for( i=1; i < LIMELM; i++ )
			{
				abundances.solar[i] = (float)absav[0];
			}
			
#			ifdef DEBUG_FUN
			fputs( " <->ParseAbundances()\n", debug_fp );
#			endif
			return;
		}

		/* >>chng 95 jul 14, get rid of go to's */
		if( !lgEOL )
		{
			/* do this is there was a second number */
			for( i=2; i < abundances.npSolar; i++ )
			{
				absav[i] = FFmtRead(chCard,&j,LINELENGTH,&lgEOL);
				if( lgEOL )
				{
					/*   read CONTINUE line if J scanned off end before reading all abund */
					readar(chCard,&lgEOF);
					if( lgEOF )
					{
						fprintf( ioQQQ, " There MUST be%3ld abundances entered, there were only%3ld.  Sorry.\n", 
						  abundances.npSolar, i );
						puts( "[Stop in ParseAbundances]" );
						cdEXIT(1);
					}

					/*   option to ignore all lines starting with #, *, or %. */
					while( (chCard[0] == '#' || chCard[0] == '*') || chCard[0] == '%' )
					{
						if( lgEOF )
						{
							fprintf( ioQQQ, " There MUST be%3ld abundances entered, there were only%3ld.  Sorry.\n", 
							  abundances.npSolar, i );
							puts( "[Stop in ParseAbundances]" );
							cdEXIT(1);
						}
						/* read in another line */
						readar(chCard,&lgEOF);
					}

					/* we have the line image, print it */
					if( called.lgTalk )
					{
						fprintf( ioQQQ, "                       * ");
						k=0;
						while( chCard[k]!='\0' )
						{
							fprintf(ioQQQ,"%c",chCard[k]);
							++k;
						}
						while( k<80 )
						{
							fprintf(ioQQQ,"%c",' ');
							++k;
						}
						fprintf( ioQQQ,"*\n"); 
					}

					/* now convert to caps */
					caps(chCard);
					if( strncmp(chCard,"CONT",4) != 0 )
					{
						fprintf( ioQQQ, " There MUST be%3ld abundances entered, there were only%3ld.  Sorry.\n", 
						  abundances.npSolar, i );
						puts( "[Stop in ParseAbundances]" );
						cdEXIT(1);
					}
					else
					{
						j = 1;
						absav[i] = FFmtRead(chCard,&j,LINELENGTH,&lgEOL);
						if( lgEOF )
						{
							fprintf( ioQQQ, " There MUST be%3ld abundances entered, there were only%3ld.  Sorry.\n", 
							  abundances.npSolar, i);
							puts( "[Stop in ParseAbundances]" );
							cdEXIT(1);
						}
					}
				}
			}

			/* fell through to here after reading in abundances
			 * check that there are no more - could mean typo further upstream */
			chk = FFmtRead(chCard,&j,LINELENGTH,&lgEOL);

			if( !lgEOL || (chk!=0.) )
			{
				/* got another number, not lgEOL, so too many numbers */
				fprintf( ioQQQ, " There were more than %3ld abundances entered\n", 
				  abundances.npSolar );
				fprintf( ioQQQ, " Could there have been a typo somewhere?\n" );
			}

			/* are numbers scale factors, or log of abund rel to H?? */
			lgLog = FALSE;
			for( i=0; i < abundances.npSolar; i++ )
			{
				if( absav[i] < 0. )
					lgLog = TRUE;
			}

			if( lgLog )
			{
				/* entered as log of number rel to hydrogen */
				for( i=0; i < abundances.npSolar; i++ )
				{
					abundances.solar[abundances.ipSolar[i]-1] = (float)pow(10.,absav[i]);
				}
			}
			else
			{
				/* scale factors relative to solar */
				for( i=0; i < abundances.npSolar; i++ )
				{
					abundances.solar[abundances.ipSolar[i]-1] *= (float)absav[i];
				}
			}

			/* check whether the abundances are reasonable */
			if( abundances.solar[1] > 0.2 )
			{
				fprintf( ioQQQ, " Is an abundance of%10.3e for %2.2s reasonable?\n", 
				  abundances.solar[1], elementnames.chElementSym[1] );
			}

			for( i=2; i < LIMELM; i++ )
			{
				if( abundances.solar[i] > 0.1 )
				{
					fprintf( ioQQQ, " Is an abundance of%10.3e for %2.2s reasonable?\n", 
					  abundances.solar[i], elementnames.chElementSym[i] );
				}
			}
			
#			ifdef DEBUG_FUN
			fputs( " <->ParseAbundances()\n", debug_fp );
#			endif
			return;
		}
	}

	/* no numbers on line if it got this far */

	/* enter std abundances for various objects */
	if( lgMatch(" AGB",chCard) || lgMatch("AGB ",chCard) || lgMatch("PLAN",chCard) )
	{
		/* AGB/planetary nebula abundances */
		if( !lgMatch("O GR",chCard) )
		{
			/* turn on grains if not already done */
			if( !lgDSet )
			{
#ifdef INCLUDE_OLD_GRAINS
#ifndef SWITCH_OLD_GRAINS
				/* keyword "new grains" switches on new grains */
				if( !lgMatch("W GR",chCard) )
				{
#else
				/* keyword "old grains" switches on old grains */
				if( lgMatch("D GR",chCard) )
				{
#endif
					gv.lgDustOn = TRUE;
					for( nd=0; nd < gv.nBin; nd++ )
					{
						gv.bin[nd]->dstfactor = 1.;
						/* >>chng 96 nov 29, loop setting false, followed by two set true */
						gv.bin[nd]->lgDustOn1 = FALSE;
					}
					gv.bin[0]->lgDustOn1 = TRUE;
					gv.bin[6]->lgDustOn1 = TRUE;
				}
				else
				{
				/* return bins allocated by previous abundances ... commands */
					for( nd=NDOLD; nd < gv.nBin; nd++ ) 
					{
						if( gv.bin[nd] != NULL ) 
						{
							free( gv.bin[nd] );
						}
						gv.bin[nd] = NULL;
					}
					gv.nBin = NDOLD;
					/* now allocate new grain bins */
					gp.dep = 1.;
					gp.lgAbunVsDepth = FALSE;
					gp.lgRequestQHeating = TRUE;
					gp.lgForbidQHeating = FALSE;
					mie_read_opc("graphite_ism_10.opc",gp);
					mie_read_opc("silicate_ism_10.opc",gp);
				}
#else
				/* return bins allocated by previous abundances ... commands */
				ReturnGrainBins();
				/* now allocate new grain bins */
				gp.dep = 1.;
				gp.lgAbunVsDepth = FALSE;
				gp.lgRequestQHeating = TRUE;
				gp.lgForbidQHeating = FALSE;
				mie_read_opc("graphite_ism_10.opc",gp);
				mie_read_opc("silicate_ism_10.opc",gp);
#endif
			}
		}

		for( i=0; i < LIMELM; i++ )
		{
			abundances.solar[i] = abundances.apn[i];
		}
	}

	else if( lgMatch("HII ",chCard) || lgMatch("H II",chCard) || lgMatch("ORIO",chCard) )
	{
		/* H II region abundances */
		if( !lgMatch("O GR",chCard) )
		{
			/* option to turn on grains */
			if( !lgDSet )
			{
#ifdef INCLUDE_OLD_GRAINS
#ifndef SWITCH_OLD_GRAINS
				/* keyword "new grains" switches on new grains */
				if( !lgMatch("W GR",chCard) )
				{
#else
				/* keyword "old grains" switches on old grains */
				if( lgMatch("D GR",chCard) )
				{
#endif
					gv.lgDustOn = TRUE;
					for( nd=0; nd < gv.nBin; nd++ )
					{
						gv.bin[nd]->dstfactor = 1.;
						/* >>chng 96 nov 29, loop setting false, followed by two set true */
						gv.bin[nd]->lgDustOn1 = FALSE;
					}
					/* orion grains */
					gv.bin[2]->lgDustOn1 = TRUE;
					gv.bin[3]->lgDustOn1 = TRUE;
				}
				else
				{
					/* return bins allocated by previous abundances ... commands */
					for( nd=NDOLD; nd < gv.nBin; nd++ ) {
						if( gv.bin[nd] != NULL ) {
							free( gv.bin[nd] );
						}
						gv.bin[nd] = NULL;
					}
					gv.nBin = NDOLD;
					/* now allocate new grain bins */
					gp.dep = 1.;
					gp.lgAbunVsDepth = FALSE;
					gp.lgRequestQHeating = TRUE;
					gp.lgForbidQHeating = FALSE;
					mie_read_opc("graphite_orion_10.opc",gp);
					mie_read_opc("silicate_orion_10.opc",gp);
				}
#else
				/* return bins allocated by previous abundances ... commands */
				ReturnGrainBins();
				/* now allocate new grain bins */
				gp.dep = 1.;
				gp.lgAbunVsDepth = FALSE;
				gp.lgRequestQHeating = TRUE;
				gp.lgForbidQHeating = FALSE;
				mie_read_opc("graphite_orion_10.opc",gp);
				mie_read_opc("silicate_orion_10.opc",gp);
#endif
			}
		}

		for( i=0; i < LIMELM; i++ )
		{
			abundances.solar[i] = abundances.ahii[i];
		}
	}

	else if( lgMatch("ISM ",chCard) || lgMatch(" ISM",chCard) )
	{
		/* ISM abundances from Cowie and Songaila Ann Rev '86 */
		if( !lgMatch("O GR",chCard) )
		{
			if( !lgDSet )
			{
#ifdef INCLUDE_OLD_GRAINS
#ifndef SWITCH_OLD_GRAINS
				/* keyword "new grains" switches on new grains */
				if( !lgMatch("W GR",chCard) )
				{
#else
				/* keyword "old grains" switches on old grains */
				if( lgMatch("D GR",chCard) )
				{
#endif
					gv.lgDustOn = TRUE;
					for( nd=0; nd < gv.nBin; nd++ )
					{
						gv.bin[nd]->dstfactor = 1.;
						/* >>chng 96 nov 29, loop setting false, followed by two set true */
						gv.bin[nd]->lgDustOn1 = FALSE;
					}
					/* ism grains */
					gv.bin[0]->lgDustOn1 = TRUE;
					gv.bin[1]->lgDustOn1 = TRUE;
				}
				else
				{
					/* return bins allocated by previous abundances ... commands */
					for( nd=NDOLD; nd < gv.nBin; nd++ ) {
						if( gv.bin[nd] != NULL ) {
							free( gv.bin[nd] );
						}
						gv.bin[nd] = NULL;
					}
					gv.nBin = NDOLD;
					/* now allocate new grain bins */
					gp.dep = 1.;
					gp.lgAbunVsDepth = FALSE;
					gp.lgRequestQHeating = TRUE;
					gp.lgForbidQHeating = FALSE;
					mie_read_opc("graphite_ism_10.opc",gp);
					mie_read_opc("silicate_ism_10.opc",gp);
				}
#else
				/* return bins allocated by previous abundances ... commands */
				ReturnGrainBins();
				/* now allocate new grain bins */
				gp.dep = 1.;
				gp.lgAbunVsDepth = FALSE;
				gp.lgRequestQHeating = TRUE;
				gp.lgForbidQHeating = FALSE;
				mie_read_opc("graphite_ism_10.opc",gp);
				mie_read_opc("silicate_ism_10.opc",gp);
#endif
			}
		}

		for( i=0; i < LIMELM; i++ )
		{
			abundances.solar[i] = abundances.aism[i];
		}
	}

	else if( lgMatch("NOVA",chCard) )
	{
		/* Nova Cyg abundances */
		for( i=0; i < LIMELM; i++ )
		{
			abundances.solar[i] = abundances.anova[i];
		}
	}

	else if( lgMatch("STAR",chCard) )
	{
		/* Fred Hamonn's starburst galaxy mixture */
		strbst(chCard);
	}

	else if( lgMatch("PRIM",chCard) )
	{
		/* roughly primordial abundances: He/H=.072 */
		for( i=0; i < LIMELM; i++ )
		{
			abundances.solar[i] = abundances.aprim[i];
		}

		/* now turn off the heavy elements */
		for( i=4; i < LIMELM; i++ )
		{
			/* >>chng 01 dec 17, from setting off to call to ParseElement,
			 * so that H-like and He-like level limits are handled properly */
			char chDUMMY[LIMELM];
			sprintf(chDUMMY,"element %s off ", elementnames.chElementName[i] );
			/* now convert to caps */
			caps(chDUMMY);
			ParseElement( chDUMMY );
			/*abundances.lgElmtOn[i] = FALSE;*/
		}
	}

	else if( lgMatch("CAME",chCard) )
	{
		/* mix from Cameron 1982, "Essays on Nuclear Astrophysics" */
		for( i=0; i < LIMELM; i++ )
		{
			abundances.solar[i] = abundances.camern[i];
		}
	}

	else
	{
		fprintf( ioQQQ, 
			" ABUND must have PLAN, H II, CAMERON, NOVA, NLR, ALL, STARBURST or PRIMORDIAL.  Sorry.\n" );
		puts( "[Stop in ParseAbundances]" );
		cdEXIT(1);
	}

#	ifdef DEBUG_FUN
	fputs( " <->ParseAbundances()\n", debug_fp );
#	endif
	return;
}

