/*ParseAbsMag parse the absolute magnitude command */
#include "cddefines.h"
#include "rfield.h"
#include "called.h"
#include "parse.h"

void ParseAbsMag(char *chCard, 
  long int *nqh)
{
	int lgEOL;
	long int i;

#	ifdef DEBUG_FUN
	fputs( "<+>ParseAbsMag()\n", debug_fp );
#	endif


	/* enter luminosity in absolute magnitudes */
	i = 5;
	*nqh += 1;
	if( *nqh > LIMSPC )
	{
		if( called.lgTalk )
		{
			fprintf( ioQQQ, " Too many continua entered; increase LIMSPC\n" );
		}
		puts( "[Stop in ParseAbsMag]" );
		cdEXIT(1);
	}
	strcpy( rfield.chRSpec[*nqh-1], "4 PI" );
	rfield.totpow[*nqh-1] = FFmtRead(chCard,&i,LINELENGTH,&lgEOL);
	if( lgEOL )
	{
		if( called.lgTalk )
		{
			fprintf( ioQQQ, " There should have been a number on this line.   Sorry.\n" );
		}
		puts( "[Stop in ParseAbsMag]" );
		cdEXIT(1);
	}
	if( lgMatch("BOLO",chCard) )
	{
		strcpy( rfield.chSpNorm[*nqh-1], "LUMI" );
		rfield.range[0][*nqh-1] = rfield.emm;
		rfield.range[1][*nqh-1] = rfield.egamry;
		/* page 197 allen 76 */
		rfield.totpow[*nqh-1] = ((4.75 - rfield.totpow[*nqh-1])/
		  2.5 + 33.5827);
	}
	else if( lgMatch("VISU",chCard) )
	{
		strcpy( rfield.chSpNorm[*nqh-1], "FLUX" );
		/* this is 5550A, the center of the V filter */
		rfield.range[0][*nqh-1] = 0.164f;
		/* totpow(nqh) = (4.79 - totpow(nqh)) / 2.5  + 18.758
		 * page 197, allen 76, 3rd line from bottom */
		rfield.totpow[*nqh-1] = (-rfield.totpow[*nqh-1]/2.5 + 
		  20.65296);
	}
	else
	{
		if( called.lgTalk )
		{
			fprintf( ioQQQ, " Keyword BOLOmetric or VISUal must appear.\n" );
		}
		puts( "[Stop in ParseAbsMag]" );
		cdEXIT(1);
	}

#	ifdef DEBUG_FUN
	fputs( " <->ParseAbsMag()\n", debug_fp );
#	endif
	return;
}

