/*OpacityAddTotal derive total opacity for this position,
 * called by by */
#include "cddefines.h"
#include "physconst.h"
#include "hydrogenic.h"
#include "iso.h"
#include "nhe1lvl.h"
#include "grainvar.h"
#include "mgexc.h"
#include "nitexc.h"
#include "rfield.h"
#include "o3exc.h"
#include "hemase.h"
#include "converge.h"
#include "taulines.h"
#include "recoil.h"
#include "trace.h"
#include "abundances.h"
#include "hmi.h"
#include "phycon.h"
#include "phe1lv.h"
#include "iphmin.h"
#include "hevmolec.h"
#include "heopfr.h"
#include "stimax.h"
#include "he1bn.h"
#include "nhe1.h"
#include "pca2ex.h"
#include "ionfracs.h"
#include "hydrophocs.h"
#include "opacity.h"

void OpacityAddTotal(void)
{
	long int i, 
	  ipZ, 
	  limit, 
	  nelem,
	  n; 
	double DepartCoefInv ,
	  fac, 
	  fac1, 
	  fachmi, 
	  fachmi1, 
	  sum;
	double dfactor ;
	float SaveOxygen1 , 
		SaveCarbon1 , 
		SaveHydrogen1;

#	ifdef DEBUG_FUN
	fputs( "<+>OpacityAddTotal()\n", debug_fp );
#	endif

	/* OpacityZero will zero out scattering and absorption opacities,
	 * and set OldOpacSave to opac to save it */
	OpacityZero();

	/* free electron scattering opacity, Compton recoil energy loss */
	for( i=0; i < (recoil.ipCompRecoil[ipHYDROGEN] - 1); i++ )
	{
		/* scattering part of total opacity */
		opac.scatop[i] += opac.OpacStack[i-1+opac.iopcom]*
		  phycon.eden;
	}

	for( i=recoil.ipCompRecoil[ipHYDROGEN]-1; i < rfield.nflux; i++ )
	{
		/* scattering part of total opacity
		 * at high energies Compton recoil is important, simply loose photons
		 * since code not designed for Compton thick clouds */
		fac = rfield.anu[i]/7.512e4;
		fac /= 1. + fac;
		opac.scatop[i] += (opac.OpacStack[i-1+opac.iopcom]*
		  phycon.eden*(1. - fac));
		opac.opac[i] += (opac.OpacStack[i-1+opac.iopcom]*
		  phycon.eden*fac);
	}

	/* opacity due to compton bound recoil ionization */
	/* >>chng 01 dec 19, rewrite as loop over all elements */
	for( nelem=0; nelem<LIMELM; ++nelem )
	{
		if( abundances.lgElmtOn[nelem] )
		{ 
			for( i=recoil.ipCompRecoil[nelem]-1; i < rfield.nflux; i++ )
			{
				/* add in bound hydrogen electron scattering, treated as absorption */
				opac.opac[i] += opac.OpacStack[i-1+opac.iopcom]*
				  xIonFracs[nelem][1]*recoil.nCompRecoilElec[nelem];
			}
		}
	}

	/* opacity due to pair production */
	sum = phycon.hden + 4.*xIonFracs[ipHELIUM][0];
	OpacityAdd1Subshell(opac.ioppr,opac.ippr,rfield.nflux,(float)sum,'s');

	/* hydrogen, helium, heavy element brems (free-free) opacity,
	 * assuming Hydrogen free-free gaunt factors
	 * logic change June 4 95 to better treat h- absorption
	 * FreeFreeOpacity is evaluated in ff heating routine, then added here
	 * OPSV is missing factor of 1E-20 to avoid underflow */
	/* >>chng 00 jun 05 remove one factor of 1e10 from rescaled ff opacity */
	fac = (phycon.eden/1e20)*((xIonFracs[ipHYDROGEN][2] + xIonFracs[ipHELIUM][2] + 
		4.*xIonFracs[ipHELIUM][3] + phycon.EdenFFSum)/1e10)/phycon.sqrte;
	fac1 = fac*TE1RYD/phycon.te;
	fachmi = (phycon.eden/1e20)*(xIonFracs[ipHYDROGEN][2]*iso.Pop2Ion[ipHYDROGEN][0][ipH1s]/1e10)/phycon.sqrte;
	fachmi1 = fachmi*TE1RYD/phycon.te;

	/* >>chng 00 jun 21, this test prevents failed assert in the pathological case where
	 * ionization is zero, but eden is forced to non-zero value (grainlte.in), PvH */
	if( fac > 0. || fachmi > 0. ) {
		for( i=0; i < rfield.nflux; i++ )
		{
			if( rfield.ContBoltz[i] < 0.995 )
			{
				/* use 1-exp(hn/kT)) only if exp is small
				 * last term is scaled h minus brems free-free absorption */
				dfactor = opac.OpacStack[i-1+opac.ipBrems]*
					(1. - rfield.ContBoltz[i])*rfield.gff[i];
				opac.FreeFreeOpacity[i] = dfactor*fac;
				/* this is the H- part, opac here is ratio of H- to ff */
				opac.FreeFreeOpacity[i] += dfactor*fachmi*opac.OpacStack[i-1+opac.iphmra];
			}
			else
			{
				dfactor = opac.OpacStack[i-1+opac.ipBrems]*rfield.anu[i]*
					rfield.gff[i];
				opac.FreeFreeOpacity[i] = dfactor*fac1;
				/* h- free free absorption */
				opac.FreeFreeOpacity[i] += dfactor*fachmi1*opac.OpacStack[i-1+opac.iphmra];
			}
			assert(opac.FreeFreeOpacity[i] > 0.);
			opac.opac[i] += opac.FreeFreeOpacity[i];
		}
	}

	/* H minus absorption, with correction for stimulated emission */
	if( hmi.hmidep > SMALLFLOAT )
	{
		DepartCoefInv = 1./hmi.hmidep;
	}
	else
	{
		/* the hmidep departure coef can become vastly small in totally
		 * neutral gas (no electrons) */
		DepartCoefInv = 1.;
	}

	limit = MIN2(rfield.nflux,nhe1Com.nhe1[0]);
	for( i=iphminCom.iphmin-1; i < limit; i++ )
	{
		opac.opac[i] += (opac.OpacStack[i-iphminCom.iphmin+opac.iphmop]*
		  hmi.hminus*MAX2(0.,(1. - rfield.ContBoltz[i]*DepartCoefInv)));
	}

	/* H2P h2plus bound free opacity */
	limit = MIN2(rfield.nflux,opac.ih2pnt[1]);
	for( i=opac.ih2pnt[0]-1; i < limit; i++ )
	{
		opac.opac[i] += hmi.h2plus*opac.OpacStack[i-opac.ih2pnt[0]+
		  opac.ih2pof];
	}

	/* get total population of hydrogen ground */
	if( xIonFracs[ipHYDROGEN][2] <= 0. )
	{
		fac = xIonFracs[ipHYDROGEN][1];
	}
	else
	{
		fac = xIonFracs[ipHYDROGEN][2]*iso.Pop2Ion[ipHYDROGEN][0][ipH1s];
	}

	/* Ly a damp wing opac (Rayleigh scattering) */
	limit = MIN2(rfield.nflux, iso.ipIsoLevNIonCon[ipHYDROGEN][0][ipH1s]);
	for( i=0; i < limit; i++ )
	{
		opac.scatop[i] += (fac*opac.OpacStack[i-1+opac.ipRayScat]);
	}

	 /* remember largest correction for stimulated emission */
	if( iso.DepartCoef[ipHYDROGEN][ipHYDROGEN][ipH1s] > 1e-30 && !conv.lgSearch )
	{
		stimaxCom.stimax[0] = 
			MAX2(stimaxCom.stimax[0],
			     (float)(rfield.ContBoltz[iso.ipIsoLevNIonCon[ipHYDROGEN][0][ipH1s]-1]/iso.DepartCoef[ipHYDROGEN][0][ipH1s]));
	}

	if( iso.DepartCoef[ipHYDROGEN][ipHYDROGEN][ipH2p] > 1e-30 && !conv.lgSearch )
	{
		stimaxCom.stimax[1] = 
			MAX2(stimaxCom.stimax[1],
			     (float)(rfield.ContBoltz[iso.ipIsoLevNIonCon[ipHYDROGEN][0][ipH2p]-1]/iso.DepartCoef[ipHYDROGEN][0][ipH2p]));
	}

	/* add dust grain opacity if dust present */
	if( gv.lgDustOn )
	{
		/* generate current grain opacities since may be function of depth */
		/* >>chng 01 may 11, removed code to update grain opacities, already done by GrainChargeTemp */
		for( i=0; i < rfield.nflux; i++ )
		{
			opac.scatop[i] += gv.dstsc[i]*phycon.hden;
			opac.opac[i] += gv.dstab[i]*phycon.hden;
		}
	}

	/* check whether hydrogen or Helium singlets mased, if not in search mode */
	if( !conv.lgSearch )
	{
		if( iso.DepartCoef[ipHYDROGEN][1][ipH1s] > 0. )
		{
			if( rfield.ContBoltz[iso.ipIsoLevNIonCon[ipHYDROGEN][1][ipH1s]-1]/iso.DepartCoef[ipHYDROGEN][1][ipH1s] > 1. )
				hemase.lgHeMase = TRUE;
		}

		if( he1bnCOM.he1bn[0] > 0. )
		{
			if( rfield.ContBoltz[nhe1Com.nhe1[0]-1]/he1bnCOM.he1bn[0] > 1. )
				hemase.lgHeMase = TRUE;
		}

		if( EmisLines[ipHYDROGEN][ipHYDROGEN][ipH2p][ipH1s].PopOpc < 0. )
		{
			hydro.lgHLyaMased = TRUE;
		}
	}

	/* this is set in iso.h, determines which he-like series to use */
#	if 0
		/* helium triplets hei */
		if( conv.lgSearch )
		{
			/* neglect stimulated emission corr if search underway
			 * >>chng 96 feb 15, was 1 */
			depcoe = 0.;
		}
		else
		{
			depcoe = he3bnCom.he3bn[0];
		}

		if( nzone <= 1 )
		{
			oldhe3 = xIonFracs[ipHELIUM][2]*he3nCom.he3n[0];
		}
		oldhe3 = (float)(0.75*oldhe3 + 0.25*xIonFracs[ipHELIUM][2]*he3nCom.he3n[0]);

		/* add helium triplet opacity, this version has stimulated emission */
		OpacityAdd1SubshellInduc(opac.ioptri,he.nhei3,nhe1Com.nhe1[0],oldhe3,depcoe, 'v' );

		/* helium singlets excited states hei, 
		 * these opacities only extend up to 1.8 ryd 
		 * excited states ARE NOT picked up in OpacityAdd1Element */
		for( n=1; n < 4; n++ )
		{
			if( conv.lgSearch )
			{
				/* neglect stimulated emission corr if search underway
				 * >>chng 96 feb 15, was 1 */
				depcoe = 0.;
			}
			else
			{
				depcoe = he1bnCOM.he1bn[n];
			}
			OpacityAdd1SubshellInduc(opac.iophe1[n],nhe1Com.nhe1[n],nhe1Com.nhe1[0],
			  phe1lv.he1n[n]*xIonFracs[ipHELIUM][2],depcoe , 'v');
		}
		for( n=4; n < NHE1LVL; n++ )
		{
			if( conv.lgSearch )
			{
				/* neglect stimulated emission corr if search underway
				 * >>chng 96 feb 15, was 1 */
				depcoe = 0.;
			}
			else
			{
				depcoe = he1bnCOM.he1bn[n];
			}
			OpacityAdd1SubshellInduc(opac.iophe1[n],nhe1Com.nhe1[n],nhe1Com.nhe1[0],
			  phe1lv.he1n[n]*xIonFracs[ipHELIUM][2],depcoe , 's');
		}
#	endif

	/* following loop adds standard opacities for first 30 elements 
	 * most heavy element opacity added here */

	/* add in high-energy opacity of CO using C and O atomic opacities by
	 * creating fake atomic abundance that includes this */
	SaveOxygen1 = xIonFracs[ipOXYGEN][1];
	SaveCarbon1 = xIonFracs[ipCARBON][1];
	SaveHydrogen1 = iso.Pop2Ion[ipHYDROGEN][ipHYDROGEN][ipH1s];

	/* >>chng 02 jan 16, approximate inclusion of H_2 photoelectric opacity */
	/* >>refer	H2	photo cs	Yan, M., Sadeghpour, H.R., & Dalgarno, A., 1998, ApJ, 496, 1044 */
	/* include H_2 in total atomic H */
	iso.Pop2Ion[ipHYDROGEN][ipHYDROGEN][ipH1s] *= 
		(xIonFracs[ipHYDROGEN][1] + hmi.htwo*2.f) / xIonFracs[ipHYDROGEN][1];

	/* include CO */
	xIonFracs[ipOXYGEN][1] += hevmolec.hevmol[ipCO];
	xIonFracs[ipCARBON][1] += hevmolec.hevmol[ipCO];

	/* main opacity add */
	for( nelem=ipHYDROGEN; nelem < LIMELM; nelem++ )
	{
		/* this element may be turned off */
		if( abundances.lgElmtOn[nelem] )
		{ 
			OpacityAdd1Element(nelem);
		}
	}

	/* now reset the abundances */
	xIonFracs[ipOXYGEN][1] = SaveOxygen1;
	xIonFracs[ipCARBON][1] = SaveCarbon1;
	iso.Pop2Ion[ipHYDROGEN][ipHYDROGEN][ipH1s] = SaveHydrogen1;

	/* following are opacities due to specific excited levels */

	/* nitrogen opacity
	 * excited level of N+ */
	OpacityAdd1Subshell(opac.in1[2],opac.in1[0],opac.in1[1],
		xIonFracs[ipNITROGEN][1]*nitexc.p2nit , 'v' );

	/* oxygen opacity
	 * excited level of Oo */
	OpacityAdd1Subshell(opac.ipo1exc[2],opac.ipo1exc[0],opac.ipo1exc[1],
	  xIonFracs[ipOXYGEN][1]*o3exc.poiexc,'v');

	/* O2+ excited states */
	OpacityAdd1Subshell(opac.ipo3exc[2],opac.ipo3exc[0],opac.ipo3exc[1],
	  xIonFracs[ipOXYGEN][3]*o3exc.poiii2,'v');

	OpacityAdd1Subshell(opac.ipo3exc3[2],opac.ipo3exc3[0],opac.ipo3exc3[1],
	  xIonFracs[ipOXYGEN][3]*o3exc.poiii3,'v');

	/* magnesium opacity
	 * excited level of Mg+ */
	OpacityAdd1Subshell(opac.ipOpMgEx,opac.ipmgex,iso.ipIsoLevNIonCon[ipHYDROGEN][0][ipH1s],
		xIonFracs[ipMAGNESIUM][2]* mgexc.popmg2,'v');

	/* calcium opacity
	 * photoionization of excited levels of Ca+ */
	OpacityAdd1Subshell(opac.ica2op,opac.ica2ex[0],opac.ica2ex[1],
	  pca2ex.popca2ex,'v');

	/*******************************************************************
	 *
	 * complete evaluation of total opacity by adding in the static part 
	 *
	 *******************************************************************/

	for( i=0; i < rfield.nflux; i++ )
	{
		/* OpacStatic was zeroed in OpacityZero, incremented in opacityadd1subshell */
		opac.opac[i] += opac.OpacStatic[i];
		/* make sure that opacity is positive */
		assert( opac.opac[i] > 0. );
	}


	/* this loop defines the variable iso.ConOpacRatio[ipHYDROGEN][ipZ][n],
	 * the ratio of not H to Hydrogen opaity.  for grain free environments
	 * at low densities this is nearly zero.  The correction includes 
	 * stimulated emission correction */
	for( ipZ=0; ipZ < LIMELM; ipZ++ )
	{
		/* this element may be turned off */
		if( abundances.lgElmtOn[ipZ] )
		{ 
			if( nzone < 1 )
			{
				for( n=ipH1s; n < iso.nLevels[ipHYDROGEN][ipZ]; n++ )
				{
					if(iso.ipIsoLevNIonCon[ipHYDROGEN][ipZ][n] < rfield.nflux )
					{
						if( opac.opac[iso.ipIsoLevNIonCon[ipHYDROGEN][ipZ][n]-1] > 1e-30 )
						{
							iso.ConOpacRatio[ipHYDROGEN][ipZ][n] = (float)((opac.opac[iso.ipIsoLevNIonCon[ipHYDROGEN][ipZ][n]-1] - 
								iso.Pop2Ion[ipHYDROGEN][ipZ][n]*xIonFracs[ipZ][ipZ+2]*
							  HydroPhoCS.STH[n]/(POW2(ipZ+1.)))/opac.opac[iso.ipIsoLevNIonCon[ipHYDROGEN][ipZ][n]-1]);
						}
						else
						{
							iso.ConOpacRatio[ipHYDROGEN][ipZ][n] = 0.;
						}
					}
				}
			}

			for( n=ipH1s; n < iso.nLevels[ipHYDROGEN][ipZ]; n++ )
			{
				/* ratios of other to total opacity for H continua
				 * same for Lyman, Balmer continua of hydrogen */
				if(iso.ipIsoLevNIonCon[ipHYDROGEN][ipZ][n] < rfield.nflux )
				{
					if( opac.opac[iso.ipIsoLevNIonCon[ipHYDROGEN][ipZ][n]-1] > 0. )
					{
						/* first get departure coef */
						if( iso.DepartCoef[ipHYDROGEN][ipZ][n] > 1e-30 && (!conv.lgSearch ) )
						{
							/* this is the usual case, use inverse of departure coef */
							fac = 1./iso.DepartCoef[ipHYDROGEN][ipZ][n];
						}
						else if( conv.lgSearch )
						{
							/* do not make correction for stim emission during search
							 * for initial temperature solution, since trys are very non-equil */
							fac = 0.;
						}
						else
						{
							fac = 1.;
						}

						/* now get opaicty ratio with correction for stimulated emission */
						if( opac.opac[iso.ipIsoLevNIonCon[ipHYDROGEN][ipZ][n]-1] > 1e-30 )
						{
							iso.ConOpacRatio[ipHYDROGEN][ipZ][n] = (float)(
								iso.ConOpacRatio[ipHYDROGEN][ipZ][n]* 0.75 + 
								0.25*(
								opac.opac[iso.ipIsoLevNIonCon[ipHYDROGEN][ipZ][n]-1] - 
								iso.Pop2Ion[ipHYDROGEN][ipZ][n]*xIonFracs[ipZ][ipZ+2]*
								HydroPhoCS.STH[n]/(POW2(ipZ+1.))*
								(1. - fac*rfield.ContBoltz[iso.ipIsoLevNIonCon[ipHYDROGEN][ipZ][n]-1]))/
								opac.opac[iso.ipIsoLevNIonCon[ipHYDROGEN][ipZ][n]-1]);
						}
						else
						{
							iso.ConOpacRatio[ipHYDROGEN][ipZ][n] = 0.;
						}
						iso.ConOpacRatio[ipHYDROGEN][ipZ][n] = (float)MAX2(0.,iso.ConOpacRatio[ipHYDROGEN][ipZ][n]);
					}
					else
					{
						iso.ConOpacRatio[ipHYDROGEN][ipZ][n] = 0.;
					}
				}
				else
				{
					iso.ConOpacRatio[ipHYDROGEN][ipZ][n] = 0.;
				}
			}
		}
	}
	/* total opacity now defined - now look at some ratios */
	for( n=0; n < NHE1LVL; n++ )
	{
		if( nhe1Com.nhe1[n] < rfield.nflux && 
			opac.opac[nhe1Com.nhe1[n]-1] > 0. )
		{
			if( he1bnCOM.he1bn[n] > 1e-30 && (!conv.lgSearch) )
			{
				fac = 1./he1bnCOM.he1bn[n];
			}
			else if( conv.lgSearch )
			{
				fac = 0.;
			}
			else
			{
				fac = 1.;
			}

			heopfr.ophe1f[n] = (float)(((opac.opac[nhe1Com.nhe1[n]-1] - 
			  xIonFracs[ipHELIUM][2]*phe1lv.he1n[n]*opac.OpacStack[opac.iophe1[n]-
			  1]*(1. - fac*rfield.ContBoltz[nhe1Com.nhe1[n]-1]))/
			  opac.opac[nhe1Com.nhe1[n]-1] + heopfr.ophe1f[n])/
			  2.);
			heopfr.ophe1f[n] = (float)MAX2(0.,heopfr.ophe1f[n]);
		}

		else
		{
			heopfr.ophe1f[n] = 0.;
		}
	}

	/* fixit();set opacity ratio for helium-like species  - put something in !*/
	for( ipZ=1; ipZ < LIMELM; ipZ++ )
	{
		/* this element may be turned off */
		if( abundances.lgElmtOn[ipZ] )
		{ 
			for( n=0; n<iso.nLevels[ipHELIUM][ipZ]; ++n )
			{
				/* ratio of other to total opacities */
				/* 1 says that self abs by this species is not important, so when
				 * optically thick, still counts as recombination since absorbed by something else*/
				iso.ConOpacRatio[ipHELIUM][ipZ][n] = 1.;
			}
		}
	}
	/* copy old helium to here for now */
	iso.ConOpacRatio[ipHELIUM][ipHELIUM][ipHe1s1S] = heopfr.ophe1f[0];
	iso.ConOpacRatio[ipHELIUM][ipHELIUM][ipHe2s1S] = heopfr.ophe1f[1];
	iso.ConOpacRatio[ipHELIUM][ipHELIUM][ipHe2p1P] = heopfr.ophe1f[1];

	/* compute gas albedo here */
	for( i=0; i < rfield.nflux; i++ )
	{
		opac.albedo[i] = opac.scatop[i]/(opac.scatop[i] + 
		  opac.opac[i]);
	}

	/* during search phase set old opacity array to current value */
	if( conv.lgSearch )
		OpacityZeroOld();

	if( trace.lgTrace )
	{
		fprintf( ioQQQ, "     OpacityAddTotal returns; grd rec eff (opac) for Hn=1,4%10.2e%10.2e%10.2e%10.2e HeI,II;%10.2e\n", 
		  iso.ConOpacRatio[ipHYDROGEN][0][ipH1s], iso.ConOpacRatio[ipHYDROGEN][0][ipH2p], iso.ConOpacRatio[ipHYDROGEN][0][3], 
		  iso.ConOpacRatio[ipHYDROGEN][0][4], heopfr.ophe1f[0] );
	}

#	ifdef DEBUG_FUN
	fputs( " <->OpacityAddTotal()\n", debug_fp );
#	endif
	return;
}

