/*main program that reads input and calls cloudy to compute a single model, or
 * try to optimize an observed model.  Routine returns 0 if model is ok, 
 * and 1 if problems occurred. */
#include "cddefines.h"
#include "cddrive.h"
#include "assertresults.h"

/*int main( int argc, char *argv[] )*/
int main( void )
{
	/* these will be used to count number of various problems */
	long int NumberWarnings, 
	  NumberCautions, 
	  NumberNotes, 
	  NumberSurprises, 
	  NumberTempFailures, 
	  NumberPresFailures,
	  NumberIonFailures, 
	  NumberNeFailures ;

	int lgAbort,
		lgBadExit;
	/* number of lines we can still read in */
	int nread=0 ;

	/*************************************************************************
	 * the length of the following vector will be the longest line image     *
	 * the code will be able to read.  Cloudy itself will ignore anything    *
	 * beyond column 80, and checks that no information exists beyond it.    *
	 * comments are generated if the input line is longer than 80 characters.*
	 * If an input line is longer than the following length, then fgets will *
	 * only pull in the first xxx characters, and will receive the remainder *
	 * of the line the next time it is called.  The effect will be to break  *
	 * the very long line at this point.                                     *
	 *************************************************************************/

	char chLine[200];
	/* change following to TRUE to write to debugging file */
	/*@-redef@*/
	enum {FILEIO=FALSE};
	/*@+redef@*/

	/* initialize the code for this run */
	cdInit();

	/* following should be set true to print to file instead of std output */
	if( FILEIO )
	{
		FILE *ioOut;
		/* this is an option to direct code to a file rather than stdout*/
		/* following used for passing output to temp file*/
		ioOut = fopen("c:\\projects\\cloudy\\tests\\CallCloudy.txt", "w" );
		cdOutp(ioOut);
	}

	nread = 1;
	/* keep reading input lines until end of file */
	while( fgets(chLine, (int)sizeof(chLine), stdin)!= NULL )
	{
		/* when running from command prompt, last line can be space or /n,
		 * so check for each here, and break if present,
		 * check on chLine[23] is for case where we are reading cloudy output */
		if(   (chLine[0]=='\n') || 
			( (chLine[0]==' ')&& (chLine[23]!='*') ) 
			) break;

		/* this is trick so that cloudy input can read cloudy output */
		/* are first 25 char of input string equal to output? */
		if( strncmp(chLine,"                       * ",25) == 0 )
		{
			/* reading cloudy output, send in shifted input */
			nread = cdRead( chLine+25 );
		}
		else
		{
			/* stuff the command line into the internal stack */
			nread = cdRead( chLine  );
		}
	}
	if( nread <= 0 )
	{
		fprintf(ioQQQ," Warning: limit to number of lines exceeded, %i\n", nread);
	}

	/* actually call the code.  This routine figures out whether the code will do
	 * a single model or be used to optimize on a spectrum, by looking for the
	 * keyword VARY on command lines.  It will call routine cloudy if no vary commands
	 * occur, and DoOptimize if VARY does occur.  
	 * cdDrive returns 0 if calculation is ok, 1 if problems happened */
	lgBadExit = cdDrive();

	/* the last line of output will contain some interesting information about the model*/
	cdNwcns(
     /* abort status, this better be falase, 0 */
	 &lgAbort,
	 /* the number of warnings, cautions, notes, and surprises */
     &NumberWarnings, 
     &NumberCautions, 
     &NumberNotes, 
     &NumberSurprises, 
     /* the number of temperature convergence failures */
     &NumberTempFailures, 
     /* the number of pressure convergence failures */
     &NumberPresFailures,
     /* the number of ionzation convergence failures */
     &NumberIonFailures, 
     /* the number of electron density convergence failures */
     &NumberNeFailures );

	fprintf( ioQQQ, 
		" Cloudy ends:%4ld zone" ,
		nzone);

	/* put an s in interation if more than one */
	if( nzone > 1 )
	{
		fprintf( ioQQQ,"s");
	}

	fprintf( ioQQQ, 
		", %3ld iteration" ,
		iteration );

	/* put an s in interation if more than one */
	if( iteration > 1 )
	{
		fprintf( ioQQQ,"s");
	}

	if( NumberWarnings > 0 )
	{
		fprintf( ioQQQ, 
			",%3ld warning", 
			NumberWarnings);

		/* put an s in interation if more than one */
		if( NumberWarnings > 1 )
		{
			fprintf( ioQQQ,"s");
		}
		/* this indicates error */
		lgBadExit = 1;
	}

	if( NumberCautions > 0 )
	{
		fprintf( ioQQQ, 
			",%3ld caution", 
			NumberCautions);

		/* put an s in interation if more than one */
		if( NumberCautions > 1 )
		{
			fprintf( ioQQQ,"s");
		}
	}

	/* this flag was set in lgCheckAsserts*/
	if( !lgAssertsOK )
	{
		fprintf(ioQQQ,", BOTCHED ASSERTS!!!");
		/* this indicates error */
		lgBadExit = 1;
	}

	if( NumberTempFailures+NumberPresFailures +NumberIonFailures+NumberNeFailures >0 )
	{
		fprintf( ioQQQ, 
			".  Failures:%3ld temp,%3ld press, %3ld ioniz,%3ld elec den\n", 
			NumberTempFailures, 
			NumberPresFailures ,
			NumberIonFailures, 
			NumberNeFailures);
	}
	fprintf( ioQQQ, ".\n");

	if( lgBadExit )
	{
		fprintf(ioQQQ, " [Stop in maincl, something went wrong]\n" );
	}
	else
	{
		fprintf(ioQQQ, " [Stop in maincl, Cloudy exited OK]\n" );
	}

	/* cdDrive returned 1 if something bad happened, and 0 if everything is ok.  We will
	 * return 0 if everything is ok, and 1 if something bad happened.*/
	return(lgBadExit);
}
