/*lines_molecules put energetics, H, and He lines into line intensity stack */
#include "cddefines.h"
#include "taulines.h"
#include "physconst.h"
#include "coolheavy.h"
#include "cooling.h"
#include "hmi.h"
#include "heat.h"
#include "phycon.h"
#include "ionfracs.h"
#include "co.h"
#include "linadd.h"
#include "radius.h"
#include "putline.h"
#include "lines.h"

void lines_molecules(void)
{
	long int i;

#	ifdef DEBUG_FUN
	fputs( "<+>lines_molecules()\n", debug_fp );
#	endif

	/* molecules */
	i = StuffComment( "molecules" );
	linadd( 0., (float)i , "####", 'i');

	/* H2 rotation lines from 
	 * >>refer	H2	rot	Lepp and Shull ApJ 270, 578,
	 * roughly two microns */
	linadd(CoolHeavy.h2line,20000.,"H2 l",'c');
	/* remember largest fraction of H2 cooling for possible comment */
	hmi.h2line_cool_frac = (float)MAX2( CoolHeavy.h2line/cooling.ctot , hmi.h2line_cool_frac );

	/* H2 dissociation by H atoms (not e) */
	linadd(CoolHeavy.h2dis,0,"H2dC",'c');

	/* molecular hydrogen heating */
	hmi.h2dtot += hmi.HeatH2Dish*(float)radius.dVeff;
	hmi.h2dfrc = (float)MAX2(hmi.HeatH2Dish/heat.htot,hmi.h2dfrc);

	/* heating by H2 dissociation by Lyman continuum */
	linadd(hmi.HeatH2Dish,0,"H2dH",'h');

	/* heating by coll deexcit of vib-excited H2 */
	linadd( MAX2(0.,hmi.HeatH2Dexc),0,"H2vH",'h');

	/* cooling by coll deexcit of vib-excited H2 */
	linadd( MAX2(0.,-hmi.HeatH2Dexc) ,0,"H2vC",'c');

	/* line emission by vib-excited H2 */
	linadd( hmi.htwo_star*2e-7*4.17e-12,0,"H2 v",'c');

	/* neg H ion free-bound emission */
	linadd(CoolHeavy.hmfb,0,"H-FB",'c');

	/* H-alpha produce by H- mutual neutralization */
	linadd(hmi.HalphaHmin*3.032e-12,6563,"H-CT",'i');

	/* H- heating */
	linadd(MAX2(0.,hmi.hmihet),0,"H- H",'h');

	/* induced H- cooling */
	linadd(MAX2(0.,-hmi.hmihet),0,"H-Hc",'c');

	/* H+ + H => H2+ + photon continuum cooling */
	linadd(CoolHeavy.H2PlsCool,0,"H2+ ",'c');

	/* HeH+ formation cooling */
	linadd(MAX2(3.27e-12+phycon.te*BOLTZMANN,0.)*xIonFracs[ipHYDROGEN][2]*xIonFracs[ipHELIUM][1]*1e-20+
	  (1.76e-11+phycon.te*BOLTZMANN)*xIonFracs[ipHYDROGEN][1]*xIonFracs[ipHELIUM][2]*1e-16,0,"HEH+",'i');

	/* carbon monoxide heating */
	co.codtot += co.CODissHeat*(float)radius.dVeff;
	co.codfrc = (float)MAX2(co.CODissHeat/heat.htot,co.codfrc);

	/* carbon monoxide co photodissociation */
	linadd(co.CODissHeat,0,"COdh",'h');

	/* old cooling due to coll of co vib rot levels */
	testcode();/* remove this entry and delete variable once complete */
	linadd(CoolHeavy.COVibCoolOld,0,"CO o",'i');

	/* total c12o16 cooling */
	linadd(CoolHeavy.C12O16Rot,0,"CO12",'c');

	/* total c13o16 cooling */
	linadd(CoolHeavy.C13O16Rot,0,"CO13",'c');

	/* remember most amount of CO cooling */
	co.COCoolBigFrac = MAX2( co.COCoolBigFrac, (CoolHeavy.C12O16Rot+CoolHeavy.C13O16Rot)/cooling.ctot);

	/* add in CO carbon monoxide lines */
	for( i=0; i < nCORotate; i++ )
	{
		PutLine(&C12O16Rotate[i]);
		/* also print destroyed part of line 
		linadd(
			C12O16Rotate[i].PopHi*C12O16Rotate[i].Aul*C12O16Rotate[i].Pdest*C12O16Rotate[i].EnergyErg,
			C12O16Rotate[i].WLAng ,"dest",'i');*/
	}
	for( i=0; i < nCORotate; i++ )
	{
		PutLine(&C13O16Rotate[i]);
	}

#	ifdef DEBUG_FUN
	fputs( " <->lines_molecules()\n", debug_fp );
#	endif
	return;
}

