/*linadd enter lines into the line storage array, called once per zone*/
#include "cddefines.h"
#include "linesave.h"
#include "radius.h"
#include "linadd.h"

/* enter lines into the line storage array, called once per zone for each line*/
void linadd(
	double xInten,	/* xInten - local emissivity per unit vol, no fill fac */
  float wavelength,		/* lam integer wavelength */
  char *chLab,		/* string label for ion */
  char chInfo 		/* character type of entry for line - given below */
					/* 'c' cooling, 'h' heating, 'i' info only, 'r' recom line */)
{

#	ifdef DEBUG_FUN
	fputs( "<+>linadd()\n", debug_fp );
#	endif

	/* main routine to actually enter lines into the line storage array
	 * called at top level within routine lines
	 * called series of times in routine PutLine for lines transferred
	 */

	/* three values, -1 is just counting, 0 if init, 1 for calculation */
	if( LineSave.ipass > 0 )
	{
		/* not first pass, sum lines only
		 * total emission from vol */
		LineSv[LineSave.nsum].sumlin += xInten*radius.dVeff;
		/* local emissivity in line */
		LineSv[LineSave.nsum].emslin = xInten;
	}

	else if( LineSave.ipass == 0 )
	{
		/* first call to suff lines in array, confirm that label is one of
		 * the four correct ones */
		assert( (chInfo == 'c') || (chInfo == 'h') || (chInfo != 'i') || (chInfo != 'r' ) );

		/* then save it into array */
		LineSv[LineSave.nsum].chSumTyp = (char)chInfo;

		/* number of lines ok, set parameters for first pass */
		LineSv[LineSave.nsum].sumlin = 0.;
		LineSv[LineSave.nsum].wavelength = wavelength;
		strcpy( LineSv[LineSave.nsum].chALab, chLab );
	}

	/* increment the line counter */
	++LineSave.nsum;

	/* routince can be called with negative LineSave.ipass, in this case
	 * we are just counting number of lines for current setup */

#	ifdef DEBUG_FUN
	fputs( " <->linadd()\n", debug_fp );
#	endif
	return;
}

