/* iso.h - information for isoelectronic sequences */

/* the number of iso sequences now in the code */
#define	NISO	2

/* set true to use new he opacities, false to use old he atom */
#define	lgHeNew	TRUE

/*IsoCreate create storage space data for hydrogen and helium, 1 one time per coreload */
void IsoCreate(void);

/* do photoionization rates for element nelem on the ipISO isoelectronic sequence */
void iso_Photo( long ipISO , long nelem );

EXTERN struct t_iso 
{

	/* number of lyman lines to include only as opacity sources, in each iso seq,
	 * all now set to 100 in zero.c */
	long int nLyman[NISO];

	/* this is the set of extra lines,
	 * LymanLines[ipISO][ipZ][n]*/
	EmLine ***ExtraLymanLines;

	/* a set of array indices for all atoms on the iso sequences,
	 * ipIsoLevNIonCon[ipISO][ipZ][n] */
	long int ***ipIsoLevNIonCon;

	/* >>chng 01 dec 23, from float to double */
	/* ionization potential of level N in Ryd */
	double ***xIsoLevNIonRyd;

	/* ConBoltz excit to continuum */
	double ***ConBoltz/*ipISO][ipZ][n]*/;

	/* the ratio fully stripped ion to atom for all hydrogenic species
	 * HIonSimple is simple estimate, should agree at low density */
	double xIonSimple[NISO][LIMELM];

	/* option to turn off l-mixing collisions */
	int lgColl_l_mixing[NISO];

	/* option to turn off collisional excitation */
	int lgColl_excite[NISO];

	/* option to turn off collisional ionization */
	int lgColl_ionize[NISO];

	/* option to print departure coefficients */
	int lgPrtDepartCoef[NISO][LIMELM];

	/* option to print level populations */
	int lgPrtLevelPops[NISO][LIMELM];

	/* how the model atoms are topped off.  nHTopOff is the level, H set to 10 in zero */
	long int nTopOff[NISO];

	/*
	* iso.nLevels[ipISO][ipNELEM] is the number of levels in hydrogenic atoms, 
	* 0 is 1s, 1 is 2s, 2 is 2p, etc, going up to n = iso.nLevels[ipHYDROGEN]
	* iso.nLevels[ipHYDROGEN] is set on the fly with hydrogen levels command, and 
	* all loops should be from ipH1s to <= iso.nLevels[ipHYDROGEN]
	* it is initialized in zero.c
	*/
	/* the number of levels in each atom in the iso sequences */
	long int nLevels[NISO][LIMELM];

	/* this is the quantum number n of the highest levels */
	long int nHighest[NISO][LIMELM];

	/* the number of levels to print in each atom in the iso sequences */
	long int nPrintLevels[NISO][LIMELM];

	/* the statistical weights of the levels, stat[ipISO][n] */
	float **stat;

	/* the statistical weights of the ions for each species,
	 * used for Milne relation and recombination */
	float stat_ion[NISO];

	/* radiative recombination rate coefficient, RadRecomb[ipISO][ipZ][n][fcn]
	 * iso.RadRecomb[ipHELIUM][ipZ][ipLo][ipRecEsc] escape prob
	 * iso.RadRecomb[ipISO][ipZ][n][ipRecNetEsc] net escape prob, accounting for absorption 
	 * iso.RadRecomb[ipHELIUM][ipZ][ipLo][ipRecRad] rate coef, cm^3 s^-1 
	 * */
	float ****RadRecomb;

	/* difference between actual case b photons in rtdiffuse, and correct case b */
	float CaseBCheck[NISO][LIMELM];

	/* case b recombination rate coefficient */
	float RadRec_caseB[NISO][LIMELM];

	/* the total effective radiative recombination rate coefficient, 
	 * radiative rate with correction for absorption and ionization */
	float RadRec_effec[NISO][LIMELM];

	/* ipOpac pointers for photoionization cross sections of hydrogen
	 * iso.ipOpac[NISO][LIMELM][NHPLPHOT] */
	long int ***ipOpac;

	/* population of level relative to ion */
	float ***Pop2Ion;

	/* continuum to total opacity factors for each level */
	float ***ConOpacRatio;

	/* departure coefficient */
	double ***DepartCoef;

	/* true is all lte populations positive for Hydrogenic atoms */
	int lgPopLTE_OK[NISO][LIMELM];

	/* hlte is lte population of each level */
	double ***PopLTE;

	/* collisional ionization rate coefficient from each level */
	double ***ColIoniz;

	/* the ratio of ion to recombined species, for H-like and He-like ions of
	 * the heavy elements */
	double xIonRatio[NISO][LIMELM];

	/* photoionization rate, gammnc[iso][nelem][level] */
	double ***gamnc;

	/* RecomInducRate will become induced recombination rate coefficient
	 * when multipled by lte population.  
	 * integral of photorate times exp(-hu/kt) 
	 * for ind rec, produced by gamma routine needs to be mult
	 * by lte pop to become real rate  */
	double ***RecomInducRate;

	/* RecomInducCool becomes rate coef for incuded recombination cooling,
	 * when multipled by lte population. 
	 * this times hnu-hnuo0 to get cooling,
	 * evaluated in gamma routine and saved */
	double ***RecomInducCool;

	/* Boltzmann factor from lower to upper level, [ISO][nelem][up][lo] */
	double ****Boltzmann;

	/* photoelectric heating rate */
	double ***PhotoHeat;

} iso;
