/*ipoint returns pointer to any energy within energy mesh */
/*ipContEnergy generate unique pointer to energy within continuum array
 * continuum energy in Rydbergs */
/*ipLineEnergy generate unique pointer to line energy within energy mesh
 * line energy in Rydbergs */
#include "cddefines.h"
#include "continuum.h"
#include "rfield.h"
#include "ipoint.h"

long ipoint(double freq)
{
	long int i, 
	  ipoint_v;

#	ifdef DEBUG_FUN
	fputs( "<+>ipoint()\n", debug_fp );
#	endif

	if( freq < continuum.filbnd[0] || freq > continuum.filbnd[continuum.nrange] )
	{
		fprintf( ioQQQ, " ipoint:\n" );
		fprintf( ioQQQ, " The freq array is not defined at nu=%11.3e. The bounds are%11.3e%11.3e\n", 
		  freq, continuum.filbnd[0], continuum.filbnd[continuum.nrange] );
		fprintf( ioQQQ, " ipoint is aborting to get trace, to find how this happened\n" );
		ShowMe();
		cdEXIT(1);
	}

	for( i=0; i < continuum.nrange; i++ )
	{
		if( freq >= continuum.filbnd[i] && freq <= continuum.filbnd[i+1] )
		{

			/* ths is on the fortran scale of array index counting, so is one above the
			 * c scale.  later the -1 will appear on any index references */
			ipoint_v = (long int)(log10(freq/continuum.filbnd[i])/continuum.fildel[i] + 
			  1.0 + continuum.ifill0[i]);

			assert( ipoint_v >= 0 );
			/* recall on F scale */
			ipoint_v = MIN2( rfield.nupper , ipoint_v );
			
#			ifdef DEBUG_FUN
			fputs( " <->ipoint()\n", debug_fp );
#			endif
			return( ipoint_v );
		}
	}

	fprintf( ioQQQ, " IPOINT logic error, energy=%10.2e\n", 
	  freq );

	puts( "[Stop in ipoint]" );
	/* ssecond exit not possible, here to shut up some compilers */
	cdEXIT(1);
}

/*ipContEnergy generate unique pointer to energy within continuum array
 * continuum energy in Rydbergs */
long ipContEnergy(double energy, 
  char *chLabel)/* 4 char label for continuum, like those returned by chLineLbl */
{
	long int ipConSafe_v;

#	ifdef DEBUG_FUN
	fputs( "<+>ipContEnergy()\n", debug_fp );
#	endif

	ipConSafe_v = ipoint(energy);

	/* write label in this cell if not anything there yet */
	if( strcmp(rfield.chContLabel[ipConSafe_v-1],"    ") == 0 )
	{
		strcpy( rfield.chContLabel[ipConSafe_v-1], chLabel );
	}

	/* this is a quick way to find all continua that occur within a given cell,
	 * recall the off-by-one aspect of C */
	{
		/*@-redef@*/
		enum {DEBUG=FALSE};
		/*@+redef@*/
		if( DEBUG )
		{
			/* recall the off-by-one aspect of C */
			if( ipConSafe_v == 1296 )
				fprintf(ioQQQ,"%s\n", chLabel );
		}
	}

#	ifdef DEBUG_FUN
	fputs( " <->ipContEnergy()\n", debug_fp );
#	endif
	return( ipConSafe_v );
}

/*ipLineEnergy generate unique pointer to line energy within energy mesh
 * line energy in Rydbergs */
long ipLineEnergy(double energy, 
  /* 4 char label for  line, like those returned by chLineLbl */
  char *chLabel , 
  /* will make sure energy is < this pointer if greater than 0, does nothing if <= 0*/
  long ipIonEnergy )
{
	long int ipLinSafe_v;

#	ifdef DEBUG_FUN
	fputs( "<+>ipLineEnergy()\n", debug_fp );
#	endif

	ipLinSafe_v = ipoint(energy);
	assert( ipLinSafe_v );
	/* make sure pointer is below next higher continuum if positive */
	if( ipIonEnergy > 0 )
	{
		ipLinSafe_v = MIN2( ipLinSafe_v , ipIonEnergy-1 );
	}

	assert( ipLinSafe_v > 0 );
	/* stuff in a label if none there,
	 * note that this is offset one below actual number to be on C scale of arrays */
	if( strcmp(rfield.chLineLabel[ipLinSafe_v-1],"    ")==0 )
	{
		strcpy( rfield.chLineLabel[ipLinSafe_v-1], chLabel );
	}

	/* this is a quick way to find all lines that occur within a given cell,
	 * recall the off-by-one aspect of C */
	{
		/*@-redef@*/
		enum {DEBUG=FALSE};
		/*@+redef@*/
		if( DEBUG )
		{
			/* recall the off-by-one aspect of C */
			if( ipLinSafe_v == 1147 )
				fprintf(ioQQQ,"%s\n", chLabel );
		}
	}

#	ifdef DEBUG_FUN
	fputs( " <->ipLineEnergy()\n", debug_fp );
#	endif
	return( ipLinSafe_v );
}
