/* input.h */

/* limit to number of line images that can be read in */
#define	NKRD	1000

EXTERN struct t_input {

	/*
	 * copy of current line image, set when readar is called,
	 * used by parser when original (not cap'd) line needed
	 */
	char chOrgCard[81];

	/* 
	 * this is cap'd image of command line, for use with patern matches 
	 */
	char chCARDCAPS[81];

	/* 
	 * we will save the original (not caped) image of the line here 
	 */
	char chCardSav[NKRD][81], 

	/* 
	 * title entered with the title command 
	 */
	  chTitle[76];

	long int 
	  /* total number of lines read in with cdRead */
	  nSave,

	  /* this points to the command we are now parsing, within the stack of commands */
	  nRead,		

	  /* number of init commands saved */
	  nSaveIni,	

	  /* +/-1, says whether to increment or decrement nRead, since init commands
		* are at the bottom of the stack and we read backwards */
	  iReadWay,	

	  /* saves current value of nRead, while parsing init commands */
	  nReadSv;	

	}	input;

/* logical variable testing whether any input lines were too long 
 * definition is in cdInit */
EXTERN int lgCardSavTooLong;

