/*HydroT2Low called to do hydrogenic level populations when temp too low for matrix */
#include "cddefines.h"
#include "taulines.h"
#include "hydrogenic.h"
#include "recom.h"
#include "iso.h"
#include "secondaries.h"
#include "trace.h"
#include "phycon.h"
#include "chargtran.h"
#include "ionfracs.h"
#include "thlo.h"
#include "dynamics.h"
#include "hcaseb.h"

void HydroT2Low(long int ipZ, 
  double rfac)
{
	long int iup, 
	  lev, 
	  low;
	double above, 
	  below, 
	  topoff,
	  TotIonize;

#	ifdef DEBUG_FUN
	fputs( "<+>HydroT2Low()\n", debug_fp );
#	endif

	/* check that we were called with valid charge */
	assert( ipZ >= 0);
	assert( ipZ < LIMELM );

	/* changed to EdenHCorr
	 * edhi = eden + hi * 1.7e-4
	 * */
	if( trace.lgHBug && trace.lgTrace )
	{
		if( phycon.te <= thlo.HydTempLimit*(ipZ+1) )
		{
			fprintf( ioQQQ, " H%3ld matrix not used, te too low\n", ipZ );
		}
		if( rfac < 1e-7 )
		{
			fprintf( ioQQQ, " H%3ld matrix not used, H too neutral\n", ipZ );
		}
		if( !iso.lgPopLTE_OK[ipHYDROGEN][ipZ] )
		{
			fprintf( ioQQQ, " H%3ld matrix not used, Hlte not ok\n", ipZ );
		}
	}

	/* following is case b rec coef */
	hcaseb.HRecEffec[ipZ] = 
		iso.RadRecomb[ipHYDROGEN][ipZ][ipH1s][ipRecRad]*
	  iso.RadRecomb[ipHYDROGEN][ipZ][ipH1s][ipRecNetEsc] + iso.RadRec_caseB[ipHYDROGEN][ipZ] + 
	  recom.CotaRate[ipZ];

	/* do radiative only cascades */
	topoff = 0.;
	for( lev=iso.nLevels[ipHYDROGEN][ipZ]-1; lev >= ipH2s; lev-- )
	{
		/* radiative rec plus three body rec */
		above = (iso.RadRecomb[ipHYDROGEN][ipZ][lev][ipRecRad]*
			iso.RadRecomb[ipHYDROGEN][ipZ][lev][ipRecNetEsc] + 
		   iso.ColIoniz[ipHYDROGEN][ipZ][lev]*iso.PopLTE[ipHYDROGEN][ipZ][lev]*phycon.eden)*
	  	   phycon.eden;

		topoff += above;

		for( iup=lev + 1; iup < iso.nLevels[ipHYDROGEN][ipZ]; iup++ )
		{
			double RadDecay;
			RadDecay =
				EmisLines[ipHYDROGEN][ipZ][iup][lev].Aul*
			  (EmisLines[ipHYDROGEN][ipZ][iup][lev].Pesc + 
			  EmisLines[ipHYDROGEN][ipZ][iup][lev].Pdest);

			/* hlev(lev,low) is A * esc prob */
			above += iso.Pop2Ion[ipHYDROGEN][ipZ][iup]*(RadDecay + 
			  EmisLines[ipHYDROGEN][ipZ][iup][lev].ColUL*phycon.eden);
		}

		below = 0.;
		for( low=ipH1s; low <= (lev - 1); low++ )
		{
			double RadDecay;
			RadDecay =
				EmisLines[ipHYDROGEN][ipZ][lev][low].Aul*
			  (EmisLines[ipHYDROGEN][ipZ][lev][low].Pesc + 
			  EmisLines[ipHYDROGEN][ipZ][lev][low].Pdest);

			below += RadDecay + EmisLines[ipHYDROGEN][ipZ][lev][low].ColUL*
			  phycon.eden;
		}
		if( below > 1e-25 )
		{
			iso.Pop2Ion[ipHYDROGEN][ipZ][lev] = (float)(above/below);
		}
		else
		{
			iso.Pop2Ion[ipHYDROGEN][ipZ][lev] = 0.;
		}

		if( iso.PopLTE[ipHYDROGEN][ipZ][lev] > 1e-25 )
		{
			iso.DepartCoef[ipHYDROGEN][ipZ][lev] = 
				iso.Pop2Ion[ipHYDROGEN][ipZ][lev]/(iso.PopLTE[ipHYDROGEN][ipZ][lev]*
			  phycon.eden);
		}
		else
		{
			iso.DepartCoef[ipHYDROGEN][ipZ][lev] = 0.;
		}
	}

	/* total ionization rate */
	TotIonize = iso.gamnc[ipHYDROGEN][ipZ][ipH1s] + Secondaries.csupra + iso.ColIoniz[ipHYDROGEN][ipZ][ipH1s]*
	  phycon.EdenHCorr;

	/* add in advection - these terms normally zero */
	topoff += dynamics.Recomb[ipZ][ipZ];
	TotIonize += dynamics.Photo;

	/* >>chng 01 may 05, add this in */
	/* add on charge transfer ionization of hydrogen */
	if( ipZ == 0 )
	{
		long int nelem , ion;
		/* add on charge transfer ionization of hydrogen,
		 * recombination for other element is ionization of hydrogen */
		ChargTran.HCharExcIonTotal = 0.;
		for( nelem=1; nelem<LIMELM; ++nelem)
		{
			/* this is ion on the abundances scale, 1 is atom, so goes up to nelem+1,
			 * for helium nelem=1, ion must go up to 3 */
			for( ion=2; ion<=nelem+2; ++ion )
			{
				/* charge transfer ionization of H, recombination for other species */
				ChargTran.HCharExcIonTotal += 
					ChargTran.HCharExcRec[nelem][ion-2]*xIonFracs[nelem][ion];
			}
		}
		TotIonize += ChargTran.HCharExcIonTotal;

		/* >>chng 01 may 07,  add this in */
		/* charge transfer recombination of hydrogen,
		 * which is ionization of the heavy element */
		ChargTran.HCharExcRecTotal = 0.;
		for( nelem=1; nelem<LIMELM; ++nelem)
		{
			/* this is ion on the abundances scale, 1 is atom, so goes up to nelem+1,
			 * for helium nelem=1, ion must go up to 3 */
			for( ion=1; ion<=nelem+1; ++ion )
			{
				/* charge transfer ionization of H, recombination for other species */
				ChargTran.HCharExcRecTotal += 
					ChargTran.HCharExcIon[nelem][ion-1]*xIonFracs[nelem][ion];
			}
		}
	}
	topoff += ChargTran.HCharExcRecTotal;

	/* =================================================================== 
	 *
	 * at this point all destruction processes have been established 
	 *
	 * ==================================================================== */

	/* save total ground state destruction rate for possible later use */
	hydro.DestRate[ipZ][ipH1s] = TotIonize;

	/* do simple two level for hydrogen, then fill in HN(i) for rest
	 * above in below is tot rec */
	iso.Pop2Ion[ipHYDROGEN][ipZ][ipH1s] = (float)(topoff/TotIonize);

	if( iso.PopLTE[ipHYDROGEN][ipZ][ipH1s] > 1e-25 )
	{
		iso.DepartCoef[ipHYDROGEN][ipZ][ipH1s] = 
			iso.Pop2Ion[ipHYDROGEN][ipZ][ipH1s]/(iso.PopLTE[ipHYDROGEN][ipZ][ipH1s]*
		  phycon.eden);
	}
	else
	{
		iso.DepartCoef[ipHYDROGEN][ipZ][ipH1s] = 0.;
	}

	iso.Pop2Ion[ipHYDROGEN][ipZ][ipH2s] = 
		(float)((iso.RadRec_caseB[ipHYDROGEN][ipZ]*0.33*phycon.eden + 
	  iso.Pop2Ion[ipHYDROGEN][ipZ][ipH1s]*Secondaries.Hx12[MIN2(ipZ+1,2)-1][ipH2s] + 
	  iso.Pop2Ion[ipHYDROGEN][ipZ][ipH2p]*
	  EmisLines[ipHYDROGEN][ipZ][ipH2p][ipH2s].ColUL*phycon.eden)/
	  (EmisLines[ipHYDROGEN][ipZ][ipH2s][ipH1s].Aul + 
	  EmisLines[ipHYDROGEN][ipZ][ipH2s][ipH1s].ColUL*phycon.EdenHCorr + 
	  EmisLines[ipHYDROGEN][ipZ][ipH2p][ipH2s].ColUL*
	  phycon.eden*6.));

	iso.Pop2Ion[ipHYDROGEN][ipZ][ipH2p] = (float)((iso.RadRec_caseB[ipHYDROGEN][ipZ]*0.67*phycon.eden + 
	  iso.Pop2Ion[ipHYDROGEN][ipZ][ipH1s]*Secondaries.Hx12[MIN2(ipZ+1,2)-1][ipH2p] + 
	  iso.Pop2Ion[ipHYDROGEN][ipZ][ipH2s]*
	  EmisLines[ipHYDROGEN][ipZ][ipH2p][ipH2s].ColUL*phycon.eden*6.)/
	  (
	   EmisLines[ipHYDROGEN][ipZ][ipH2p][ipH1s].Aul*
	  (EmisLines[ipHYDROGEN][ipZ][ipH2p][ipH1s].Pesc + 
	  EmisLines[ipHYDROGEN][ipZ][ipH2p][ipH1s].Pdest)
	  + 
	  EmisLines[ipHYDROGEN][ipZ][ipH2p][ipH1s].ColUL * phycon.eden + 
	  EmisLines[ipHYDROGEN][ipZ][ipH2p][ipH2s].ColUL * phycon.eden));

	/* were upper n levels set? */
	iso.xIonRatio[ipHYDROGEN][ipZ] = 
		1./(iso.Pop2Ion[ipHYDROGEN][ipZ][ipH1s] + 
		iso.Pop2Ion[ipHYDROGEN][ipZ][ipH2p] + 
	  iso.Pop2Ion[ipHYDROGEN][ipZ][ipH2s] + 
	  iso.Pop2Ion[ipHYDROGEN][ipZ][3] + iso.Pop2Ion[ipHYDROGEN][ipZ][4] + 
	  iso.Pop2Ion[ipHYDROGEN][ipZ][5] + iso.Pop2Ion[ipHYDROGEN][ipZ][6]);

	if( trace.lgHBug && trace.lgTrace )
	{
		fprintf( ioQQQ, "       LOW TE,=%10.3e HN(1)=%10.3e rec=%10.3e Hgamnc(1s)=%10.3e\n", 
		  phycon.te, iso.Pop2Ion[ipHYDROGEN][ipZ][ipH1s], hcaseb.HRecEffec[ipZ], 
		  iso.gamnc[ipHYDROGEN][ipZ][ipH1s] );
	}

	if( trace.lgTrace )
	{
		fprintf( ioQQQ, 
			"       HydroT2Low return, LOW TE used, HII/HI=%10.3e simple=%10.3e IonRate=%10.2e RecCo=%10.2e\n", 
		  iso.xIonRatio[ipHYDROGEN][ipZ], iso.xIonRatio[ipHYDROGEN][ipZ], 
		  iso.gamnc[ipHYDROGEN][ipZ][ipH1s] + Secondaries.csupra + iso.ColIoniz[ipHYDROGEN][ipZ][ipH1s]*
		  phycon.eden, topoff );
	}

#	ifdef DEBUG_FUN
	fputs( " <->HydroT2Low()\n", debug_fp );
#	endif
	return;
}

