/*HydroPesc evaluate escape and destruction probabilities for hydrogen lines,
 * called by RTMake */
#include "cddefines.h"
#include "physconst.h"
#include "taulines.h"
#include "iso.h"
#include "hydrogenic.h"
#include "strk.h"
#include "phycon.h"
#include "converge.h"
#include "opacity.h"
#include "twophoton.h"
#include "abscf.h"
#include "trace.h"
#include "rfield.h"
#include "ionfracs.h"
#include "wind.h"
#include "atom_oi.h"
#include "rt.h"
#include "rtescprob.h"
/* needed in excluded debug print statement */
#include "fe2ovr.h"

void HydroPesc(
	/* ipZ is on C scale, 0 for H, 1 for He, etc */
	long int ipZ ,
	/* flag saying whether we should do escape prob  and reevaluate A and opac (TRUE) or
	 * only dest probs (FALSE).  This is called with TRUE one time per zone,
	 * when optical depths are updated.  It is called FALSE many times, within ionzie,
	 * each time the opacity changes */
	int lgDoEsc )
{
	static int lgTOnSave;
	long int i,
	  ipHi, 
	  ipLo, 
	  limit;
	double abund=0., 
	  coloi, 
	  es, 
	  factor, 
	  tout,
	  z4;/* physical scale z to the 4th power, used often below */
	float dest=0.f, 
	  esin;
	float FracNew ;
	/* this will be used to save old vals of destruction prob in case
	 * we need to use mean of old and new, as is necessary when ots oscillations
	 * take place */
	float DespSave[NHYDRO_MAX_LEVEL];
	float ri2s1s;
	float ri1s2s;

#	ifdef DEBUG_FUN
	fputs( "<+>HydroPesc()\n", debug_fp );
#	endif

	/* check that we were called with valid charge */
	assert( ipZ >= 0);
	assert( ipZ < LIMELM );
	for( i=0;i<NHYDRO_MAX_LEVEL; ++i)
	{
		DespSave[i] = -FLT_MAX;
	}

	/* will need this for some scaling laws - physical Z to the 4th power*/
	z4 = POW2(ipZ+1.);
	z4 *= z4;

	if( trace.lgTrace )
	{
		fprintf( ioQQQ, 
			"          HydroPesc ipZ=%ld called\n", 
		  ipZ );
	}

	if( lgDoEsc )
	{
		/* hydrogen lines opacity is function of A's
		 * above 15 just use actual A's for high density limit
		 * only change opacities for levels between 4 and 15 */
		/* NB! must never set opacity for 2s-1s two-photon transition here, since
		 * the "line" can become optically thick if treated as a line.  It is a 
		 * continuum and the opacity is not related to the A by the usual expression */
		limit = MIN2(16,iso.nLevels[ipHYDROGEN][ipZ]);
		/* do Paschen and higher lines first, 
		 * do balmer below since must separate 2s and 2p */
		for( ipHi=4; ipHi < limit; ipHi++ )
		{
			for( ipLo=3; ipLo < ipHi; ipLo++ )
			{
				EmisLines[ipHYDROGEN][ipZ][ipHi][ipLo].Aul = 
					(float)(hydro.HyLife[ipHi]*
					HydroBranch(ipHi,ipLo,ipZ+1)*z4);
				assert(EmisLines[ipHYDROGEN][ipZ][ipHi][ipLo].Aul > 0.);

				/* make self-consistent opacity, convert new As back into opacities */
				EmisLines[ipHYDROGEN][ipZ][ipHi][ipLo].opacity = 
					(float)(EmisLines[ipHYDROGEN][ipZ][ipHi][ipLo].Aul*
				  2.2448e-26*iso.stat[ipHYDROGEN][ipHi]/
				  iso.stat[ipHYDROGEN][ipLo]*
				  POW3(RYDLAM/EmisLines[ipHYDROGEN][ipZ][ipHi][ipLo].EnergyRyd));

				/* check that results are ok */
				assert(EmisLines[ipHYDROGEN][ipZ][ipHi][ipLo].opacity > 0.);
			}
		}

		/* the actual branching ratio from high levels down to
		 * 2s and 2p depend on the density.  the code goes to
		 * the correct low and high density limits - I know of
		 * nothing better than can be done. */
		factor = MAX2( 0.25 , 0.32 - 0.07*phycon.eden/(phycon.eden + 1e7) );

		/* treat 2s = to 2p for HydroBranch, which returns total to 2s+2p */
		for( ipHi=4; ipHi < limit; ipHi++ )
		{
			/* get new effective A for this density and temperature */
			EmisLines[ipHYDROGEN][ipZ][ipHi][ipH2s].Aul = 
				(float)(hydro.HyLife[ipHi]*
				factor*HydroBranch(ipHi,2,ipZ+1)*z4);

				/* check that results are ok */
			assert(EmisLines[ipHYDROGEN][ipZ][ipHi][ipH2s].Aul > 0.);

			/* do 2p by scaling relative to 2s */
			EmisLines[ipHYDROGEN][ipZ][ipHi][ipH2p].Aul = (float)(
				EmisLines[ipHYDROGEN][ipZ][ipHi][ipH2s].Aul / factor *( 1. - factor )); 

				/* check that results are ok */
			assert(EmisLines[ipHYDROGEN][ipZ][ipHi][ipH2p].Aul > 0.);

			/* make self-consistent opaciity for 2s, from A */
			EmisLines[ipHYDROGEN][ipZ][ipHi][ipH2s].opacity = 
				(float)(EmisLines[ipHYDROGEN][ipZ][ipHi][ipH2s].Aul*
			  2.2448e-26*iso.stat[ipHYDROGEN][ipHi]/
			  iso.stat[ipHYDROGEN][ipH2s]*
			  POW3(RYDLAM/EmisLines[ipHYDROGEN][ipZ][ipHi][ipH2s].EnergyRyd));

				/* check that results are ok */
			assert(EmisLines[ipHYDROGEN][ipZ][ipHi][ipH2s].opacity > 0.);

			/* make self-consistent opaciity for 2p, from A */
			EmisLines[ipHYDROGEN][ipZ][ipHi][ipH2p].opacity = 
				(float)(EmisLines[ipHYDROGEN][ipZ][ipHi][ipH2p].Aul*
			  2.2448e-26*iso.stat[ipHYDROGEN][ipHi]/
			  iso.stat[ipHYDROGEN][ipH2p]*
			  POW3(RYDLAM/ EmisLines[ipHYDROGEN][ipZ][ipHi][ipH2p].EnergyRyd));

				/* check that results are ok */
			assert(EmisLines[ipHYDROGEN][ipZ][ipHi][ipH2p].opacity > 0.);
		}

			/* set in abscf.h */
#			if LOWDEN_LYMAN
			/* for fix Lyman lines, in terms of alpha transition */
			for( ipHi=3; ipHi < iso.nLevels[ipHYDROGEN][ipZ]; ipHi++ )
			{
					float Ratio_lyman_alpha_Z1[25]={
						0.,0.,0.,
5.52E-01f,/* this mult by 1.33 since Ha split into two */
3.30E-01f,
2.96E-01f,
2.80E-01f,
2.74E-01f,
2.72E-01f,
2.72E-01f,
2.74E-01f,
2.76E-01f,
2.78E-01f,
2.81E-01f,
2.84E-01f,
2.86E-01f,
2.89E-01f,
2.92E-01f,
2.95E-01f,
2.98E-01f,
3.01E-01f,
3.05E-01f,
3.09E-01f,
3.13E-01f,
3.18E-01f};
					float Ratio_lyman_alpha_Z2[25]={
						0.,0.,0.,
4.52E-01f,
2.38E-01f,
1.98E-01f,
1.80E-01f,
1.71E-01f,
1.66E-01f,
1.64E-01f,
1.63E-01f,
1.63E-01f,
1.64E-01f,
1.65E-01f,
1.66E-01f,
1.68E-01f,
1.69E-01f,
1.71E-01f,
1.72E-01f,
1.73E-01f,
1.75E-01f,
1.76E-01f,
1.78E-01f,
1.79E-01f,
1.80E-01f};

						if( ipZ==0 )
						{
							EmisLines[ipHYDROGEN][ipZ][ipHi][ipH1s].Aul = EmisLines[ipHYDROGEN][ipZ][ipHi][ipHi-1].Aul *
							Ratio_lyman_alpha_Z1[MIN2(23,ipHi) ];testcode();
						}
						else
						{
							EmisLines[ipHYDROGEN][ipZ][ipHi][ipH1s].Aul = EmisLines[ipHYDROGEN][ipZ][ipHi][ipHi-1].Aul *
							Ratio_lyman_alpha_Z2[MIN2(23,ipHi) ];testcode();
						}

						/* derive the abs coef, call to function is gf, wl (A), g_low */
						EmisLines[ipHYDROGEN][ipZ][ipHi][ipH1s].opacity = 
							(float)(abscf(
						  EmisLines[ipHYDROGEN][ipZ][ipHi][ipH1s].gf,
						  EmisLines[ipHYDROGEN][ipZ][ipHi][ipH1s].EnergyWN,
						  iso.stat[ipHYDROGEN][ipH1s]));
			}
#			endif
	}
	/* end test branch lgDoEsc */

	/* now update escape and destruction prob */

	if( xIonFracs[ipZ][ipZ+2] > 1e-30 )
	{
		factor = xIonFracs[ipZ][ipZ+2];
	}
	else
	{
		/* case where almost no parent ion - this will make
		 * very large line opacity, so background dest small */
		factor = 1.;
	}

	/* save destruction probs for Lyman lines in case ots rates oscillate */
	for( ipHi=ipH2p; ipHi< iso.nLevels[ipHYDROGEN][ipZ]; ++ipHi )
	{
		DespSave[ipHi] = EmisLines[ipHYDROGEN][ipZ][ipHi][ipH1s].Pdest;
	}

	/* first will be static solution */
	if( wind.windv == 0. )
	{
		/* hydrogenic lyman lines special since outward optical depths always set,
		 * trick routines for Lyman lines only */
		lgTOnSave = opac.lgTauOutOn;
		opac.lgTauOutOn = TRUE;

		/* first do lyman alpha lya la, but only if optical depths not overrun */
		/* >>chng 01 apr 01, from 0.9 to 0.99 since outer edge better defined */
		tout = EmisLines[ipHYDROGEN][ipZ][ipH2p][ipH1s].TauTot*0.99 - 
			EmisLines[ipHYDROGEN][ipZ][ipH2p][ipH1s].TauIn;

		/* must temporarily make ipLnPopOpc physical */
		EmisLines[ipHYDROGEN][ipZ][ipH2p][ipH1s].PopOpc *= 
			(float)factor;

		/* generate escape prob, pumping rate, destruction prob, 
		 * inward outward fracs  */
		RTMakeStat(&EmisLines[ipHYDROGEN][ipZ][ipH2p][ipH1s] , lgDoEsc );

		/* go back to original units so that final correction ok */
		EmisLines[ipHYDROGEN][ipZ][ipH2p][ipH1s].PopOpc /= 
			(float)factor;

		/* >>>chng 99 dec 18, repair dest prob that got clobbered in call to
		 * RTMakeStat, since will not be evaluated when tout not positive */
		EmisLines[ipHYDROGEN][ipZ][ipH2p][ipH1s].Pdest = DespSave[ipH2p];

		/* only update La dest prob if we have good outward optical depths */
		if( tout > 0. )
		{
			tout = EmisLines[ipHYDROGEN][ipZ][ipH2p][ipH1s].TauTot - 
			  EmisLines[ipHYDROGEN][ipZ][ipH2p][ipH1s].TauIn;

			abund = EmisLines[ipHYDROGEN][ipZ][ipH2p][ipH1s].PopOpc*xIonFracs[ipZ][ipZ+2];

			/* the descruction prob comes back as dest */
			EmisLines[ipHYDROGEN][ipZ][ipH2p][ipH1s].Pesc = 
				(float)(RTesc_lya(&esin, &dest,abund,ipZ));

			/* this is current destruction rate */
			EmisLines[ipHYDROGEN][ipZ][ipH2p][ipH1s].Pdest = dest;

			if( ipZ == 0 )
			{
				/* add on destruction of hydrogen Lya by FeII
				 * now add in FeII deexcitation via overlap,
				 * but only as loss, not photoionization, source
				 * dstfe2lya is Ly-alpha deexcit by FeII overlap - conversion into FeII em */
				/* find FeII overlap destruction rate, 
				 * this does NOTHING when large FeII atom is turned on */
				fe2ovr();

				/* this was introduced in the fort - c conversion, and is a bug since
				 * dest feii added to ots dest */
				/*EmisLines[ipHYDROGEN][ipHYDROGEN][ipH2p][ipH1s].Pdest = MIN2(1.f,
				  EmisLines[ipHYDROGEN][ipHYDROGEN][ipH2p][ipH1s].Pdest + hydro.dstfe2lya);*/
				/* >>chng 00 jan 06, let dest be large than 1 to desaturate the atom */
				/* >>chng 01 apr 01, add test for tout >= 0., 
				 * must not add to Pdest when it has not been refreshed here */
				if( tout >= 0. )
					EmisLines[ipHYDROGEN][ipZ][ipH2p][ipH1s].Pdest += hydro.dstfe2lya;
			}

			/* >>>chng 99 apr 16, average of old and new rates to damp opacity - Lya ots
			 * rates when opacity is large, as in HeI trip opac in Balmer continuum.
			 * the pphheonly.in test case exposes this problem */
			{
				/* Lya debugging */
				/*@-redef@*/
				enum {DEBUG=FALSE};
				/*@+redef@*/
				if( DEBUG && ipZ==0 && nzone > 180)
				{
					fprintf(ioQQQ,
						"z%3li Lya eval Pdest popl\t%g\tconopac\t%g\tPdest\t%g\tPesc\t%g\t tot in\t%g\t%g\n",
						nzone ,
						abund , 
						opac.opac[EmisLines[ipHYDROGEN][ipZ][ipH2p][ipH1s].ipCont-1],
						EmisLines[ipHYDROGEN][ipZ][ipH2p][ipH1s].Pdest, 
						EmisLines[ipHYDROGEN][ipZ][ipH2p][ipH1s].Pesc, 
						EmisLines[ipHYDROGEN][ipZ][ipH2p][ipH1s].TauTot,
						EmisLines[ipHYDROGEN][ipZ][ipH2p][ipH1s].TauIn);
				}
			}

			/*  this is fraction of line which is inward escaping */
			EmisLines[ipHYDROGEN][ipZ][ipH2p][ipH1s].FracInwd = rt.fracin;
			/*if(ipZ==1)
				fprintf(ioQQQ," desp=%g\n", dest );*/
		}

		/* now do remainder of Lyman lines, skipping 2s */
		ipLo=ipH1s;
		for( ipHi=3; ipHi < iso.nLevels[ipHYDROGEN][ipZ]; ipHi++ )
		{
			/* must temporarily make ipLnPopOpc physical */
			EmisLines[ipHYDROGEN][ipZ][ipHi][ipLo].PopOpc *= 
				(float)factor;

			/* generate escape prob, pumping rate, destruction prob, 
			 * inward outward fracs  */
			RTMakeStat(&EmisLines[ipHYDROGEN][ipZ][ipHi][ipLo] , lgDoEsc );

			{
				/* Lyman line debugging */
				/*@-redef@*/
				enum {DEBUG=FALSE};
				/*@+redef@*/
				if( DEBUG && ipZ==0 && iteration == 2)
				{
					fprintf(ioQQQ,
						"z%3li Ly3 eval Pdest popl\t%g\tconopac\t%g\tPdest\t%g\tPesc\t%g\t tot in\t%g\t%g\t ots\t%g\t conv\t%i\n",
						nzone ,
						abund , 
						opac.opac[EmisLines[ipHYDROGEN][ipZ][3][ipH1s].ipCont-1],
						EmisLines[ipHYDROGEN][ipZ][3][ipH1s].Pdest, 
						EmisLines[ipHYDROGEN][ipZ][3][ipH1s].Pesc, 
						EmisLines[ipHYDROGEN][ipZ][3][ipH1s].TauTot,
						EmisLines[ipHYDROGEN][ipZ][3][ipH1s].TauIn,
						EmisLines[ipHYDROGEN][ipZ][3][ipH1s].ots,
						conv.lgSearch
						);
#					if 0
					fprintf(ioQQQ,
						"z%3li \t%g\t%g\t%g\t%g\t%g\t%g\t%g\t%g\n",
						nzone ,
						EmisLines[ipHYDROGEN][ipZ][8][ipH1s].ots, 
						EmisLines[ipHYDROGEN][ipZ][9][ipH1s].ots, 
						EmisLines[ipHYDROGEN][ipZ][10][ipH1s].ots, 
						EmisLines[ipHYDROGEN][ipZ][11][ipH1s].ots, 
						EmisLines[ipHYDROGEN][ipZ][12][ipH1s].ots, 
						EmisLines[ipHYDROGEN][ipZ][13][ipH1s].ots, 
						EmisLines[ipHYDROGEN][ipZ][14][ipH1s].ots, 
						EmisLines[ipHYDROGEN][ipZ][15][ipH1s].ots);
#					endif
				}
			}

			/* go back to original units so that final correction ok */
			EmisLines[ipHYDROGEN][ipZ][ipHi][ipLo].PopOpc /= 
				(float)factor;
		}

		/* reset the flag, so only Lyman lines forced to include outward */
		opac.lgTauOutOn = lgTOnSave;

		/* this loop for Balmer lines which are special,
		 * because must bring 2s and 2p together */
		/* now do 2s and 2p, must bring optical depths together */
		for( ipHi=3; ipHi < iso.nLevels[ipHYDROGEN][ipZ]; ipHi++ )
		{
			/* these are used for saving current state of two lines */
			float tauin2s , tauin2p , tauout2s , tauout2p;
			double opac2s , opac2p;

			/* 2s inward and total optical depths */
			tauin2s =  EmisLines[ipHYDROGEN][ipZ][ipHi][ipH2s].TauIn;
			tauout2s = EmisLines[ipHYDROGEN][ipZ][ipHi][ipH2s].TauTot;

			/* 2p inward and total optical depths */
			tauin2p =  EmisLines[ipHYDROGEN][ipZ][ipHi][ipH2p].TauIn;
			tauout2p = EmisLines[ipHYDROGEN][ipZ][ipHi][ipH2p].TauTot;

			/* add inward optical depths together */
			EmisLines[ipHYDROGEN][ipZ][ipHi][ipH2s].TauIn += 
			EmisLines[ipHYDROGEN][ipZ][ipHi][ipH2p].TauIn;

			EmisLines[ipHYDROGEN][ipZ][ipHi][ipH2p].TauIn = 
			EmisLines[ipHYDROGEN][ipZ][ipHi][ipH2s].TauIn;

			/* add both total optical depths together */
			EmisLines[ipHYDROGEN][ipZ][ipHi][ipH2s].TauTot += 
			EmisLines[ipHYDROGEN][ipZ][ipHi][ipH2p].TauTot;

			EmisLines[ipHYDROGEN][ipZ][ipHi][ipH2p].TauTot = 
			EmisLines[ipHYDROGEN][ipZ][ipHi][ipH2s].TauTot;

			/* current 2s and 2p opacities */
			opac2s = EmisLines[ipHYDROGEN][ipZ][ipHi][ipH2s].PopOpc;
			opac2p = EmisLines[ipHYDROGEN][ipZ][ipHi][ipH2p].PopOpc;

			/* add opacities together */
			EmisLines[ipHYDROGEN][ipZ][ipHi][ipH2s].PopOpc += 
			EmisLines[ipHYDROGEN][ipZ][ipHi][ipH2p].PopOpc;

			EmisLines[ipHYDROGEN][ipZ][ipHi][ipH2p].PopOpc = 
			EmisLines[ipHYDROGEN][ipZ][ipHi][ipH2s].PopOpc;

			/* must temporarily make ipLnPopOpc physical */
			EmisLines[ipHYDROGEN][ipZ][ipHi][ipH2s].PopOpc *= 
				(float)factor;
			EmisLines[ipHYDROGEN][ipZ][ipHi][ipH2p].PopOpc *= 
				(float)factor;

			/* generate escape prob, pumping rate, destruction prob, 
			 * inward outward fracs  */
			RTMakeStat(&EmisLines[ipHYDROGEN][ipZ][ipHi][ipH2s] , lgDoEsc );
			RTMakeStat(&EmisLines[ipHYDROGEN][ipZ][ipHi][ipH2p] , lgDoEsc );

			EmisLines[ipHYDROGEN][ipZ][ipHi][ipH2s].PopOpc =   opac2s;
			EmisLines[ipHYDROGEN][ipZ][ipHi][ipH2s].TauIn =   tauin2s;
			EmisLines[ipHYDROGEN][ipZ][ipHi][ipH2s].TauTot = tauout2s;

			/* 2p inward and total optical depths */
			EmisLines[ipHYDROGEN][ipZ][ipHi][ipH2p].PopOpc =   opac2p;
			EmisLines[ipHYDROGEN][ipZ][ipHi][ipH2p].TauIn =   tauin2p;
			EmisLines[ipHYDROGEN][ipZ][ipHi][ipH2p].TauTot = tauout2p;
		}

		/* now do Paschen and higher lines */
		for( ipLo=3; ipLo < (iso.nLevels[ipHYDROGEN][ipZ] - 1); ipLo++ )
		{
			for( ipHi=ipLo+1; ipHi < iso.nLevels[ipHYDROGEN][ipZ]; ipHi++ )
			{
				/* must temporarily make ipLnPopOpc physical */
				EmisLines[ipHYDROGEN][ipZ][ipHi][ipLo].PopOpc *= 
					(float)factor;

				/* generate escape prob, pumping rate, destruction prob, 
				 * inward outward fracs  */
				RTMakeStat(&EmisLines[ipHYDROGEN][ipZ][ipHi][ipLo] , lgDoEsc );

				/* go back to original units so that final correction ok */
				EmisLines[ipHYDROGEN][ipZ][ipHi][ipLo].PopOpc /= 
					(float)factor;
			}
		}

		/* 666    C90 had the following code and warning about oscillations
		 *  highest level is a mess, set escape prob to one, actually a blend
		 *  if this is removed, then oscillations in totally optically thick
		 *  blr occur, for cases where all lines are optically thick
		 *  see model badbugs/bug0.in */
		EmisLines[ipHYDROGEN][ipZ][iso.nLevels[ipHYDROGEN][ipZ]-1][ipH1s].Pesc = (float)(
			MAX2( EmisLines[ipHYDROGEN][ipZ][iso.nLevels[ipHYDROGEN][ipZ]-1][ipH1s].Pesc , 0.1));

		for( ipLo=ipH2s; ipLo < (iso.nLevels[ipHYDROGEN][ipZ] - 1); ipLo++ )
		{
			EmisLines[ipHYDROGEN][ipZ][iso.nLevels[ipHYDROGEN][ipZ]-1][ipLo].Pesc = 1.;
		}
	}
	else
	{
		/* this is wind solution branch */
		/* hydrogenic lyman lines special since outward optical depths always set,
		 * trick routines for Lyman lines only */
		lgTOnSave = opac.lgTauOutOn;
		opac.lgTauOutOn = TRUE;

		/* say that no outward optical depths, but we are still ok */
		tout = 0.;

		/* windy model */
		for( ipLo=ipH1s; ipLo < (iso.nLevels[ipHYDROGEN][ipZ] - 1); ipLo++ )
		{
			for( ipHi=MAX2((long)ipH2p,ipLo+1); ipHi < iso.nLevels[ipHYDROGEN][ipZ]; ipHi++ )
			{
				/* some lines don't really exist */
				if( EmisLines[ipHYDROGEN][ipZ][ipHi][ipLo].ipCont <1 ) 
					continue;

				/* must temporarily make ipLnPopOpc physical */
				EmisLines[ipHYDROGEN][ipZ][ipHi][ipLo].PopOpc *= 
					(float)factor;

				RTMakeWind(&EmisLines[ipHYDROGEN][ipZ][ipHi][ipLo] , lgDoEsc );

				/* go back to original units so that final correction ok */
				EmisLines[ipHYDROGEN][ipZ][ipHi][ipLo].PopOpc /= 
					(float)factor;
			}
			/* reset the flag, so only Lyman lines forced to include outward */
			opac.lgTauOutOn = lgTOnSave;
		}
	}


	/* this is option to damp out Lyman line dest probs if ots rates oscillating */
	if( conv.lgOscilOTS )
	{
		/* this is damper used to stop oscillations when now present*/
		FracNew = 0.2f;
	}
	else
	{
		/* this is damper used to stop oscillations even when not detected */
		FracNew = 0.5f;
	}
	{
		/* following should be set true to print ots contributors */
		/*@-redef@*/
		enum {DEBUG=FALSE};
		/*@+redef@*/
		if( DEBUG && ipZ==0 )
		{
			fprintf(ioQQQ,"Lya aver DespSave\t%g\tPdest\t%g\n",
				DespSave[ipH2p],
				EmisLines[ipHYDROGEN][ipZ][ipH2p][ipH1s].Pdest);
		}
	}
	/* >>chng 01 apr 01, add test for tout > 0, only in this case will
	 * new solution even be attempted */
	if( tout >= 0. )
	{
		for( ipHi=ipH2p; ipHi< iso.nLevels[ipHYDROGEN][ipZ]; ++ipHi )
		{
			/*lint -e771 DespSave possibly not initialized */
			EmisLines[ipHYDROGEN][ipZ][ipHi][ipH1s].Pdest = (1.f-FracNew)*DespSave[ipHi] +
				FracNew * EmisLines[ipHYDROGEN][ipZ][ipHi][ipH1s].Pdest;
			/*lint +e771 DespSave possibly not initialized */
		}
	}

	{
		/* following should be set true to print ots contributors */
		/*@-redef@*/
		enum {DEBUG=FALSE};
		/*@+redef@*/
		if( DEBUG )
		{
			if( ipZ<0 && iteration == 2)
			{
				fprintf(ioQQQ,
					"z%3li Bala popopc\t%g\tconopac\t%g\tPdest\t%g\tPup\t%g\tPlo\t%g\t%g pesc%g\n",
					nzone ,
					EmisLines[ipHYDROGEN][ipZ][3][4].PopOpc , 
					opac.opac[EmisLines[ipHYDROGEN][ipZ][3][2].ipCont-1],
					EmisLines[ipHYDROGEN][ipZ][3][2].Pdest, 
					EmisLines[ipHYDROGEN][ipZ][3][2].PopHi, 
					EmisLines[ipHYDROGEN][ipZ][3][2].PopLo,
					EmisLines[ipHYDROGEN][ipZ][3][2].TauIn,
					EmisLines[ipHYDROGEN][ipZ][3][2].Pesc
					);
			}
			else if (ipZ==1 && iteration == 2 )
			{
				fprintf(ioQQQ,
					"z%3li he62a popopc\t%g\tconopac\t%g\tPdest\t%g\tPup\t%g\tPlo\t%g\t%g pesc%g\n",
					nzone ,
					EmisLines[ipHYDROGEN][ipZ][5][4].PopOpc , 
					opac.opac[EmisLines[ipHYDROGEN][ipZ][5][4].ipCont-1],
					EmisLines[ipHYDROGEN][ipZ][5][4].Pdest, 
					EmisLines[ipHYDROGEN][ipZ][5][4].PopHi, 
					EmisLines[ipHYDROGEN][ipZ][5][4].PopLo,
					EmisLines[ipHYDROGEN][ipZ][5][4].TauIn,
					EmisLines[ipHYDROGEN][ipZ][5][4].Pesc
					);
			}
		}
	}

	/* reset the flag */
	opac.lgTauOutOn = lgTOnSave;

	/* find the rate of total and induced two photon */
	twopht(ipZ, &ri2s1s , &ri1s2s , ipHYDROGEN );

	EmisLines[ipHYDROGEN][ipZ][ipH2s][ipH1s].pump = ri1s2s;
	/* >>chng 01 jan 18, us derived two-photon, the sum of spontaneous and induced */
	EmisLines[ipHYDROGEN][ipZ][ipH2s][ipH1s].Aul = ri2s1s;

	/* hydrogen-only solutions */
	if( ipZ == 0 )
	{
		/*static long int count=0;
		++count;*/
		/* find Stark escape probabilities */
		strk();
		/* electron scattering escape */
		es = phycon.eden*6.65e-25;
		for( ipLo=ipH1s; ipLo < (iso.nLevels[ipHYDROGEN][ipZ] - 1); ipLo++ )
		{
			for( ipHi=MAX2((long)ipH2p,ipLo+1); ipHi < iso.nLevels[ipHYDROGEN][ipZ]; ipHi++ )
			{
				hydro.esesc[ipZ][ipLo][ipHi] = (float)(MIN2(1.,5.9*es/(es+
				  EmisLines[ipHYDROGEN][ipZ][ipHi][ipLo].PopOpc*
				  EmisLines[ipHYDROGEN][ipZ][ipHi][ipLo].opacity))*
				  xIonFracs[ipZ][ipZ+2]*
				  MAX2(0.,1.-EmisLines[ipHYDROGEN][ipZ][ipHi][ipLo].Pesc-
				  EmisLines[ipHYDROGEN][ipZ][ipHi][ipLo].Pdest));
				hydro.esesc[ipZ][ipLo][ipHi] = 0.;
			}
		}
		hydro.esesc[ipZ][ipH1s][ipH2s] = 0.;
		/*fixit(); in above and in loop, electrons cattering escape set to 0 since got
		           * very large in case b test */

		/* do the 8446 problem */
		atom_oi_calc(&coloi);
		EmisLines[ipHYDROGEN][ipHYDROGEN][3][ipH1s].Pesc = atom_oi.pmph31/
		  EmisLines[ipHYDROGEN][ipHYDROGEN][3][ipH1s].Aul;

		if( trace.lgTrace && trace.lgHBugFull )
		{
			fprintf( ioQQQ, "       HydroPesc calls P8446 who found pmph31=%10.2e\n", 
			  atom_oi.pmph31 );
		}

		{
			/*@-redef@*/
			enum {DEBUG=FALSE};
			/*@+redef@*/
			if( DEBUG )
			{
				fprintf(ioQQQ,"hydropescdebugg\t%li\t%.2e\t%.2e\t%.2e\t%.2e\t%.2e\t%.2e\n", 
					nzone, 
					EmisLines[ipHYDROGEN][ipZ][2][0].pump,
					EmisLines[ipHYDROGEN][ipZ][4][3].TauIn,
					EmisLines[ipHYDROGEN][ipZ][4][3].TauCon,
					EmisLines[ipHYDROGEN][ipZ][4][3].pump,
					rfield.flux[EmisLines[ipHYDROGEN][ipZ][4][3].ipCont-1],
					rfield.OccNumbIncidCont[EmisLines[ipHYDROGEN][ipZ][4][3].ipCont-1]
					);
			}
		}
	}

	{
		/*@-redef@*/
		enum {DEBUG=FALSE};
		/*@+redef@*/
		if( DEBUG )
		{
			if( ipZ==0&& nzone>164 )
			{
				fprintf(ioQQQ,"hydropescdebugg\t%li\t%.2e\t%.2e\t%.2e\t%.2e\t%.2e\n", 
					nzone, 
					EmisLines[ipHYDROGEN][ipZ][2][0].TauIn,
					EmisLines[ipHYDROGEN][ipZ][2][0].TauTot,
					EmisLines[ipHYDROGEN][ipZ][2][0].Pdest,
					EmisLines[ipHYDROGEN][ipZ][2][0].Pesc,
					tout);
			}
		}
	}

	/*fixit(); this was cut out of pesc and pasted here.  this needs to
				 * be added back into the total rates, even though it is not important */
#	if 0
	/* increase escape probability by scattering and stark */
	EmisLines[ipHYDROGEN][ipZ][ipHi][ipLo].Pesc = (float)(MIN2(1.,
	  EmisLines[ipHYDROGEN][ipZ][ipHi][ipLo].Pesc+
	  hydro.pestrk[ipLo][ipHi]+hydro.esesc[ipZ][ipLo][ipHi]));
#	endif

#	ifdef DEBUG_FUN
	fputs( " <->HydroPesc()\n", debug_fp );
#	endif
	return;
}

