/*hpfit state specific photoionization cross sections for model hydrogen atom
 * for any level up through NHYDRO_MAX_LEVEL defined 401L in cddefines.h */
#include "cddefines.h"
#include "hpfit.h"
#include "ph1com.h"
/* NHYDRO_MAX_LEVEL defined 401L in cddefines.h */
static float PHH[NHYDRO_MAX_LEVEL][5];
void hpfitData(void);
void hpfitData1(void);
void hpfitData2(void);
void hpfitData3(void);
void hpfitData4(void);
void hpfitData5(void);
void hpfitData6(void);
void hpfitData7(void);

/* same as hpfit, but energy is relative to threshold */
double hpfit_rel(long int iz, 
	  long int n, 
	  double e)
{
	long m;
	double crs , ex , eth;

	if( n == 0 )
	{
		m = 1;
	}
	else
	{
		if( n == 1 )
		{
			m = 2;
		}
		else
		{
			m = n;
		}
	}

	eth = PH1COM.PH1[0][0][iz-1][0]/POW2((double)m);
	ex = MAX2(1. , e/eth );

	crs = hpfit( iz , n , ex );
	assert( crs > 0. );

	return crs;
}

double hpfit(long int iz, 
	  long int n, 
	  double e)
{
	/* flag saying first call so need to generate data */
	static int lgFIRST=TRUE;
	long int l, 
	  m;
	double cs,
	  eth, 
	  ex, 
	  q, 
	  x;

#	ifdef DEBUG_FUN
	fputs( "<+>hpfit()\n", debug_fp );
#	endif

	/*state specific photoionization cross sections for model hydrogen atom
	 * Version 1, September 23, 1997
	 ******************************************************************************
	 *** This subroutine calculates state-specific photoionization cross sections
	 *** for hydrogen and hydrogen-like ions.
	 *** Input parameters:  iz - atomic number 
	 ***          n  - shell number, from 0 to 400:
	 ***                                    0 - 1s
	 ***                                    1 - 2s
	 ***                                    2 - 2p
	 ***                                    3 - 3 
	 ***                                    ......
	 ***          e  - photon energy, eV
	 *** return value - cross section, cm^(-2)     
	 *******************************************************************************/

	/* on very first call to this routine we need to fill the data arrays
	 * with former contents of the block datas */
	if( lgFIRST )
	{
		lgFIRST = FALSE;
		/* copy the needed data int the arrays */
		hpfitData();
		hpfitData1();
		hpfitData2();
		hpfitData3();
		hpfitData4();
		hpfitData5();
		hpfitData6();
		hpfitData7();
	}

	cs = 0.0;

	assert( iz > 0 && e>0. );
	
	if( n >= NHYDRO_MAX_LEVEL )
	{ 
		fprintf( ioQQQ, " hpfit called with too large n.\n" );
		puts( "[Stop in hpfit]" );
		cdEXIT(1);
	}

	l = 0;
	if( n == 2 )
	{
		l = 1;
	}
	q = 3.5 + l - 0.5*PHH[n][1];

	if( n == 0 )
	{
		m = 1;
	}
	else
	{
		if( n == 1 )
		{
			m = 2;
		}
		else
		{
			m = n;
		}
	}

	eth = PH1COM.PH1[0][0][iz-1][0]/POW2((double)m);
	ex = e/eth;
	if( ex < 1.0 )
	{ 
#		ifdef DEBUG_FUN
		fputs( " <->hpfit()\n", debug_fp );
#		endif
		return(0.);
	}

	x = ex/PHH[n][0];
	cs = (PHH[n][4]*pow(1.0 + ((double)PHH[n][2]/x),(double)PHH[n][3])/
	  pow(x,q)/pow(1.0 + sqrt(x),(double)PHH[n][1])*8.79737e-17/
	  POW2((double)iz));
	
#	ifdef DEBUG_FUN
	fputs( " <->hpfit()\n", debug_fp );
#	endif
	return(cs);
}
static long int I, 
	  _r;

/********************************************* */
void hpfitData(void)
{
		{ static double _itmp0[] = {3.07626e-01,5.60964e00,9.95690e00,
		  2.24237e-01,3.85291e01};
		for( I=1, _r = 0; I <= 5; I++ )
		{
			PHH[0][I-1] = (float)_itmp0[_r++];
			}
		}
		{ static double _itmp1[] = {1.07629e00,6.02640e00,2.38222e00,
		  1.63081e-01,7.69680e00};
		for( I=1, _r = 0; I <= 5; I++ )
		{
			PHH[1][I-1] = (float)_itmp1[_r++];
			}
		}
		{ static double _itmp2[] = {7.59605e-01,7.15690e00,1.36471e00,
		  4.46372e-01,3.42940e01};
		for( I=1, _r = 0; I <= 5; I++ )
		{
			PHH[2][I-1] = (float)_itmp2[_r++];
			}
		}
		{ static double _itmp3[] = {8.03881e00,3.38786e00,8.30480e-01,
		  6.96195e-01,3.81896e-03};
		for( I=1, _r = 0; I <= 5; I++ )
		{
			PHH[3][I-1] = (float)_itmp3[_r++];
			}
		}
		{ static double _itmp4[] = {2.24160e01,2.76959e00,4.91676e-01,
		  5.73670e-01,1.88765e-04};
		for( I=1, _r = 0; I <= 5; I++ )
		{
			PHH[4][I-1] = (float)_itmp4[_r++];
			}
		}
		{ static double _itmp5[] = {4.89715e01,2.40666e00,3.29170e-01,
		  4.83482e-01,1.93150e-05};
		for( I=1, _r = 0; I <= 5; I++ )
		{
			PHH[5][I-1] = (float)_itmp5[_r++];
			}
		}
		{ static double _itmp6[] = {9.00516e01,2.18635e00,2.42373e-01,
		  4.23331e-01,3.33215e-06};
		for( I=1, _r = 0; I <= 5; I++ )
		{
			PHH[6][I-1] = (float)_itmp6[_r++];
			}
		}
		{ static double _itmp7[] = {1.49785e02,2.03097e00,1.87576e-01,
		  3.77563e-01,7.72796e-07};
		for( I=1, _r = 0; I <= 5; I++ )
		{
			PHH[7][I-1] = (float)_itmp7[_r++];
			}
		}
		{ static double _itmp8[] = {2.36282e02,1.90366e00,1.47477e-01,
		  3.36978e-01,2.07509e-07};
		for( I=1, _r = 0; I <= 5; I++ )
		{
			PHH[8][I-1] = (float)_itmp8[_r++];
			}
		}
		{ static double _itmp9[] = {3.51115e02,1.80795e00,1.19663e-01,
		  3.05468e-01,6.65714e-08};
		for( I=1, _r = 0; I <= 5; I++ )
		{
			PHH[9][I-1] = (float)_itmp9[_r++];
			}
		}
		{ static double _itmp10[] = {5.05155e02,1.72688e00,9.81424e-02,
		  2.77588e-01,2.33701e-08};
		for( I=1, _r = 0; I <= 5; I++ )
		{
			PHH[10][I-1] = (float)_itmp10[_r++];
			}
		}
		{ static double _itmp11[] = {6.88866e02,1.66895e00,8.33773e-02,
		  2.57807e-01,9.67881e-09};
		for( I=1, _r = 0; I <= 5; I++ )
		{
			PHH[11][I-1] = (float)_itmp11[_r++];
			}
		}
		{ static double _itmp12[] = {9.24778e02,1.61588e00,7.09266e-02,
		  2.38951e-01,4.17212e-09};
		for( I=1, _r = 0; I <= 5; I++ )
		{
			PHH[12][I-1] = (float)_itmp12[_r++];
			}
		}
		{ static double _itmp13[] = {1.22140e03,1.56826e00,6.05304e-02,
		  2.21567e-01,1.87985e-09};
		for( I=1, _r = 0; I <= 5; I++ )
		{
			PHH[13][I-1] = (float)_itmp13[_r++];
			}
		}
		{ static double _itmp14[] = {1.55181e03,1.53342e00,5.30777e-02,
		  2.09108e-01,9.55475e-10};
		for( I=1, _r = 0; I <= 5; I++ )
		{
			PHH[14][I-1] = (float)_itmp14[_r++];
			}
		}
		{ static double _itmp15[] = {1.91695e03,1.50651e00,4.74662e-02,
		  1.99626e-01,5.29159e-10};
		for( I=1, _r = 0; I <= 5; I++ )
		{
			PHH[15][I-1] = (float)_itmp15[_r++];
			}
		}
		{ static double _itmp16[] = {2.25281e03,1.49288e00,4.42374e-02,
		  1.95646e-01,3.43234e-10};
		for( I=1, _r = 0; I <= 5; I++ )
		{
			PHH[16][I-1] = (float)_itmp16[_r++];
			}
		}
		{ static double _itmp17[] = {2.88811e03,1.45352e00,3.75427e-02,
		  1.79942e-01,1.66104e-10};
		for( I=1, _r = 0; I <= 5; I++ )
		{
			PHH[17][I-1] = (float)_itmp17[_r++];
			}
		}
		{ static double _itmp18[] = {3.36382e03,1.43914e00,3.46821e-02,
		  1.75102e-01,1.09654e-10};
		for( I=1, _r = 0; I <= 5; I++ )
		{
			PHH[18][I-1] = (float)_itmp18[_r++];
			}
		}
		{ static double _itmp19[] = {4.02076e03,1.41813e00,3.11794e-02,
		  1.67104e-01,6.62254e-11};
		for( I=1, _r = 0; I <= 5; I++ )
		{
			PHH[19][I-1] = (float)_itmp19[_r++];
			}
		}
		{ static double _itmp20[] = {4.34720e03,1.41875e00,3.05827e-02,
		  1.68655e-01,5.52354e-11};
		for( I=1, _r = 0; I <= 5; I++ )
		{
			PHH[20][I-1] = (float)_itmp20[_r++];
			}
		}
		{ static double _itmp21[] = {5.10349e03,1.39946e00,2.75666e-02,
		  1.61110e-01,3.50689e-11};
		for( I=1, _r = 0; I <= 5; I++ )
		{
			PHH[21][I-1] = (float)_itmp21[_r++];
			}
		}
		{ static double _itmp22[] = {5.73713e03,1.38962e00,2.58979e-02,
		  1.57673e-01,2.55703e-11};
		for( I=1, _r = 0; I <= 5; I++ )
		{
			PHH[22][I-1] = (float)_itmp22[_r++];
			}
		}
		{ static double _itmp23[] = {6.32447e03,1.38308e00,2.46845e-02,
		  1.55657e-01,1.98061e-11};
		for( I=1, _r = 0; I <= 5; I++ )
		{
			PHH[23][I-1] = (float)_itmp23[_r++];
			}
		}
		{ static double _itmp24[] = {6.75642e03,1.38112e00,2.40425e-02,
		  1.55622e-01,1.69170e-11};
		for( I=1, _r = 0; I <= 5; I++ )
		{
			PHH[24][I-1] = (float)_itmp24[_r++];
			}
		}
		{ static double _itmp25[] = {7.33346e03,1.37528e00,2.30102e-02,
		  1.53756e-01,1.36861e-11};
		for( I=1, _r = 0; I <= 5; I++ )
		{
			PHH[25][I-1] = (float)_itmp25[_r++];
			}
		}
		{ static double _itmp26[] = {7.96918e03,1.36796e00,2.18658e-02,
		  1.51139e-01,1.09935e-11};
		for( I=1, _r = 0; I <= 5; I++ )
		{
			PHH[26][I-1] = (float)_itmp26[_r++];
			}
		}
		{ static double _itmp27[] = {8.38737e03,1.36654e00,2.14220e-02,
		  1.51153e-01,9.77583e-12};
		for( I=1, _r = 0; I <= 5; I++ )
		{
			PHH[27][I-1] = (float)_itmp27[_r++];
			}
		}
		{ static double _itmp28[] = {9.30284e03,1.35578e00,2.00133e-02,
		  1.46881e-01,7.33042e-12};
		for( I=1, _r = 0; I <= 5; I++ )
		{
			PHH[28][I-1] = (float)_itmp28[_r++];
			}
		}
		{ static double _itmp29[] = {1.09155e04,1.33508e00,1.76264e-02,
		  1.38015e-01,4.57661e-12};
		for( I=1, _r = 0; I <= 5; I++ )
		{
			PHH[29][I-1] = (float)_itmp29[_r++];
			}
		}
		{ static double _itmp30[] = {1.24027e04,1.32101e00,1.60384e-02,
		  1.32113e-01,3.16776e-12};
		for( I=1, _r = 0; I <= 5; I++ )
		{
			PHH[30][I-1] = (float)_itmp30[_r++];
			}
		}
		{ static double _itmp31[] = {1.29082e04,1.31991e00,1.57688e-02,
		  1.32097e-01,2.89890e-12};
		for( I=1, _r = 0; I <= 5; I++ )
		{
			PHH[31][I-1] = (float)_itmp31[_r++];
			}
		}
		{ static double _itmp32[] = {1.33691e04,1.31869e00,1.55004e-02,
		  1.31988e-01,2.68842e-12};
		for( I=1, _r = 0; I <= 5; I++ )
		{
			PHH[32][I-1] = (float)_itmp32[_r++];
			}
		}
		{ static double _itmp33[] = {1.39502e04,1.31601e00,1.51099e-02,
		  1.31186e-01,2.43068e-12};
		for( I=1, _r = 0; I <= 5; I++ )
		{
			PHH[33][I-1] = (float)_itmp33[_r++];
			}
		}
		{ static double _itmp34[] = {1.51495e04,1.30713e00,1.41522e-02,
		  1.27516e-01,1.93140e-12};
		for( I=1, _r = 0; I <= 5; I++ )
		{
			PHH[34][I-1] = (float)_itmp34[_r++];
			}
		}
		{ static double _itmp35[] = {1.53501e04,1.30790e00,1.41167e-02,
		  1.28245e-01,1.91250e-12};
		for( I=1, _r = 0; I <= 5; I++ )
		{
			PHH[35][I-1] = (float)_itmp35[_r++];
			}
		}
		{ static double _itmp36[] = {1.61357e04,1.30466e00,1.37357e-02,
		  1.27105e-01,1.68549e-12};
		for( I=1, _r = 0; I <= 5; I++ )
		{
			PHH[36][I-1] = (float)_itmp36[_r++];
			}
		}
		{ static double _itmp37[] = {1.80085e04,1.29316e00,1.26205e-02,
		  1.22162e-01,1.22606e-12};
		for( I=1, _r = 0; I <= 5; I++ )
		{
			PHH[37][I-1] = (float)_itmp37[_r++];
			}
		}
		{ static double _itmp38[] = {1.81497e04,1.29424e00,1.26401e-02,
		  1.22980e-01,1.23130e-12};
		for( I=1, _r = 0; I <= 5; I++ )
		{
			PHH[38][I-1] = (float)_itmp38[_r++];
			}
		}
		{ static double _itmp39[] = {1.85509e04,1.29336e00,1.24952e-02,
		  1.22879e-01,1.18145e-12};
		for( I=1, _r = 0; I <= 5; I++ )
		{
			PHH[39][I-1] = (float)_itmp39[_r++];
			}
		}
		{ static double _itmp40[] = {1.91380e04,1.29059e00,1.22009e-02,
		  1.21878e-01,1.09869e-12};
		for( I=1, _r = 0; I <= 5; I++ )
		{
			PHH[40][I-1] = (float)_itmp40[_r++];
			}
		}
		{ static double _itmp41[] = {1.92786e04,1.29140e00,1.22162e-02,
		  1.22522e-01,1.10236e-12};
		for( I=1, _r = 0; I <= 5; I++ )
		{
			PHH[41][I-1] = (float)_itmp41[_r++];
			}
		}
		{ static double _itmp42[] = {1.92483e04,1.29283e00,1.22967e-02,
		  1.23437e-01,1.13619e-12};
		for( I=1, _r = 0; I <= 5; I++ )
		{
			PHH[42][I-1] = (float)_itmp42[_r++];
			}
		}
		{ static double _itmp43[] = {1.93915e04,1.29339e00,1.22994e-02,
		  1.23948e-01,1.13792e-12};
		for( I=1, _r = 0; I <= 5; I++ )
		{
			PHH[43][I-1] = (float)_itmp43[_r++];
			}
		}
		{ static double _itmp44[] = {1.94684e04,1.29398e00,1.23176e-02,
		  1.24447e-01,1.15087e-12};
		for( I=1, _r = 0; I <= 5; I++ )
		{
			PHH[44][I-1] = (float)_itmp44[_r++];
			}
		}
		{ static double _itmp45[] = {1.96903e04,1.29314e00,1.22120e-02,
		  1.24285e-01,1.13559e-12};
		for( I=1, _r = 0; I <= 5; I++ )
		{
			PHH[45][I-1] = (float)_itmp45[_r++];
			}
		}
		{ static double _itmp46[] = {1.98262e04,1.29341e00,1.22096e-02,
		  1.24622e-01,1.13686e-12};
		for( I=1, _r = 0; I <= 5; I++ )
		{
			PHH[46][I-1] = (float)_itmp46[_r++];
			}
		}
		{ static double _itmp47[] = {2.00316e04,1.29273e00,1.21296e-02,
		  1.24512e-01,1.12439e-12};
		for( I=1, _r = 0; I <= 5; I++ )
		{
			PHH[47][I-1] = (float)_itmp47[_r++];
			}
		}
		{ static double _itmp48[] = {2.03953e04,1.29120e00,1.19684e-02,
		  1.24016e-01,1.08500e-12};
		for( I=1, _r = 0; I <= 5; I++ )
		{
			PHH[48][I-1] = (float)_itmp48[_r++];
			}
		}
		{ static double _itmp49[] = {2.08006e04,1.28917e00,1.17763e-02,
		  1.23269e-01,1.04047e-12};
		for( I=1, _r = 0; I <= 5; I++ )
		{
			PHH[49][I-1] = (float)_itmp49[_r++];
			}
		}
		{ static double _itmp50[] = {2.10323e04,1.28832e00,1.16853e-02,
		  1.23061e-01,1.02511e-12};
		for( I=1, _r = 0; I <= 5; I++ )
		{
			PHH[50][I-1] = (float)_itmp50[_r++];
			}
		}
		{ static double _itmp51[] = {2.11387e04,1.28828e00,1.16787e-02,
		  1.23207e-01,1.02916e-12};
		for( I=1, _r = 0; I <= 5; I++ )
		{
			PHH[51][I-1] = (float)_itmp51[_r++];
			}
		}
		{ static double _itmp52[] = {2.12366e04,1.28823e00,1.16635e-02,
		  1.23350e-01,1.03416e-12};
		for( I=1, _r = 0; I <= 5; I++ )
		{
			PHH[52][I-1] = (float)_itmp52[_r++];
			}
		}
		{ static double _itmp53[] = {2.06752e04,1.29167e00,1.19534e-02,
		  1.25091e-01,1.14697e-12};
		for( I=1, _r = 0; I <= 5; I++ )
		{
			PHH[53][I-1] = (float)_itmp53[_r++];
			}
		}
		{ static double _itmp54[] = {2.05738e04,1.29240e00,1.20104e-02,
		  1.25581e-01,1.18637e-12};
		for( I=1, _r = 0; I <= 5; I++ )
		{
			PHH[54][I-1] = (float)_itmp54[_r++];
			}
		}
}
void hpfitData1(void)
{
		{ static double _itmp55[] = {2.21989e04,1.28392e00,1.12798e-02,
		  1.21830e-01,9.50039e-13};
		for( I=1, _r = 0; I <= 5; I++ )
		{
			PHH[55][I-1] = (float)_itmp55[_r++];
			}
		}
		{ static double _itmp56[] = {2.27207e04,1.28159e00,1.10767e-02,
		  1.20908e-01,8.98683e-13};
		for( I=1, _r = 0; I <= 5; I++ )
		{
			PHH[56][I-1] = (float)_itmp56[_r++];
			}
		}
		{ static double _itmp57[] = {2.37584e04,1.27644e00,1.06472e-02,
		  1.18675e-01,7.93691e-13};
		for( I=1, _r = 0; I <= 5; I++ )
		{
			PHH[57][I-1] = (float)_itmp57[_r++];
			}
		}
		{ static double _itmp58[] = {2.51633e04,1.27083e00,1.01830e-02,
		  1.16227e-01,6.73954e-13};
		for( I=1, _r = 0; I <= 5; I++ )
		{
			PHH[58][I-1] = (float)_itmp58[_r++];
			}
		}
		{ static double _itmp59[] = {2.53424e04,1.27087e00,1.01888e-02,
		  1.16376e-01,6.70823e-13};
		for( I=1, _r = 0; I <= 5; I++ )
		{
			PHH[59][I-1] = (float)_itmp59[_r++];
			}
		}
		{ static double _itmp60[] = {2.54713e04,1.27027e00,1.01408e-02,
		  1.16222e-01,6.70873e-13};
		for( I=1, _r = 0; I <= 5; I++ )
		{
			PHH[60][I-1] = (float)_itmp60[_r++];
			}
		}
		{ static double _itmp61[] = {2.57923e04,1.26934e00,1.00661e-02,
		  1.15921e-01,6.55652e-13};
		for( I=1, _r = 0; I <= 5; I++ )
		{
			PHH[61][I-1] = (float)_itmp61[_r++];
			}
		}
		{ static double _itmp62[] = {2.73005e04,1.26305e00,9.56598e-03,
		  1.13140e-01,5.56481e-13};
		for( I=1, _r = 0; I <= 5; I++ )
		{
			PHH[62][I-1] = (float)_itmp62[_r++];
			}
		}
		{ static double _itmp63[] = {2.76820e04,1.26175e00,9.46526e-03,
		  1.12655e-01,5.41061e-13};
		for( I=1, _r = 0; I <= 5; I++ )
		{
			PHH[63][I-1] = (float)_itmp63[_r++];
			}
		}
		{ static double _itmp64[] = {2.89190e04,1.25739e00,9.12933e-03,
		  1.10756e-01,4.78741e-13};
		for( I=1, _r = 0; I <= 5; I++ )
		{
			PHH[64][I-1] = (float)_itmp64[_r++];
			}
		}
		{ static double _itmp65[] = {2.93302e04,1.25591e00,9.01763e-03,
		  1.10185e-01,4.64756e-13};
		for( I=1, _r = 0; I <= 5; I++ )
		{
			PHH[65][I-1] = (float)_itmp65[_r++];
			}
		}
		{ static double _itmp66[] = {2.96601e04,1.25503e00,8.95437e-03,
		  1.09884e-01,4.55491e-13};
		for( I=1, _r = 0; I <= 5; I++ )
		{
			PHH[66][I-1] = (float)_itmp66[_r++];
			}
		}
		{ static double _itmp67[] = {3.00211e04,1.25411e00,8.88879e-03,
		  1.09562e-01,4.45060e-13};
		for( I=1, _r = 0; I <= 5; I++ )
		{
			PHH[67][I-1] = (float)_itmp67[_r++];
			}
		}
		{ static double _itmp68[] = {3.00215e04,1.25356e00,8.85608e-03,
		  1.09407e-01,4.51017e-13};
		for( I=1, _r = 0; I <= 5; I++ )
		{
			PHH[68][I-1] = (float)_itmp68[_r++];
			}
		}
		{ static double _itmp69[] = {3.04895e04,1.25209e00,8.75018e-03,
		  1.08828e-01,4.35708e-13};
		for( I=1, _r = 0; I <= 5; I++ )
		{
			PHH[69][I-1] = (float)_itmp69[_r++];
			}
		}
		{ static double _itmp70[] = {3.06108e04,1.25067e00,8.65586e-03,
		  1.08259e-01,4.35540e-13};
		for( I=1, _r = 0; I <= 5; I++ )
		{
			PHH[70][I-1] = (float)_itmp70[_r++];
			}
		}
		{ static double _itmp71[] = {3.08893e04,1.24984e00,8.60245e-03,
		  1.07960e-01,4.29142e-13};
		for( I=1, _r = 0; I <= 5; I++ )
		{
			PHH[71][I-1] = (float)_itmp71[_r++];
			}
		}
		{ static double _itmp72[] = {3.12948e04,1.24857e00,8.51112e-03,
		  1.07471e-01,4.17474e-13};
		for( I=1, _r = 0; I <= 5; I++ )
		{
			PHH[72][I-1] = (float)_itmp72[_r++];
			}
		}
		{ static double _itmp73[] = {3.15102e04,1.24770e00,8.45464e-03,
		  1.07156e-01,4.13874e-13};
		for( I=1, _r = 0; I <= 5; I++ )
		{
			PHH[73][I-1] = (float)_itmp73[_r++];
			}
		}
		{ static double _itmp74[] = {3.15318e04,1.24767e00,8.46726e-03,
		  1.07220e-01,4.18426e-13};
		for( I=1, _r = 0; I <= 5; I++ )
		{
			PHH[74][I-1] = (float)_itmp74[_r++];
			}
		}
		{ static double _itmp75[] = {3.25503e04,1.24505e00,8.26816e-03,
		  1.06109e-01,3.83836e-13};
		for( I=1, _r = 0; I <= 5; I++ )
		{
			PHH[75][I-1] = (float)_itmp75[_r++];
			}
		}
		{ static double _itmp76[] = {3.36744e04,1.24043e00,7.95003e-03,
		  1.04027e-01,3.48558e-13};
		for( I=1, _r = 0; I <= 5; I++ )
		{
			PHH[76][I-1] = (float)_itmp76[_r++];
			}
		}
		{ static double _itmp77[] = {3.60942e04,1.23555e00,7.58706e-03,
		  1.01869e-01,2.84588e-13};
		for( I=1, _r = 0; I <= 5; I++ )
		{
			PHH[77][I-1] = (float)_itmp77[_r++];
			}
		}
		{ static double _itmp78[] = {3.67949e04,1.23353e00,7.45286e-03,
		  1.01013e-01,2.71133e-13};
		for( I=1, _r = 0; I <= 5; I++ )
		{
			PHH[78][I-1] = (float)_itmp78[_r++];
			}
		}
		{ static double _itmp79[] = {3.69918e04,1.23311e00,7.43040e-03,
		  1.00895e-01,2.69941e-13};
		for( I=1, _r = 0; I <= 5; I++ )
		{
			PHH[79][I-1] = (float)_itmp79[_r++];
			}
		}
		{ static double _itmp80[] = {3.82903e04,1.22973e00,7.19264e-03,
		  9.94116e-02,2.45070e-13};
		for( I=1, _r = 0; I <= 5; I++ )
		{
			PHH[80][I-1] = (float)_itmp80[_r++];
			}
		}
		{ static double _itmp81[] = {4.04734e04,1.22488e00,6.85977e-03,
		  9.72484e-02,2.08427e-13};
		for( I=1, _r = 0; I <= 5; I++ )
		{
			PHH[81][I-1] = (float)_itmp81[_r++];
			}
		}
		{ static double _itmp82[] = {4.38950e04,1.21802e00,6.39805e-03,
		  9.41438e-02,1.63548e-13};
		for( I=1, _r = 0; I <= 5; I++ )
		{
			PHH[82][I-1] = (float)_itmp82[_r++];
			}
		}
		{ static double _itmp83[] = {4.47467e04,1.21625e00,6.28883e-03,
		  9.33897e-02,1.55748e-13};
		for( I=1, _r = 0; I <= 5; I++ )
		{
			PHH[83][I-1] = (float)_itmp83[_r++];
			}
		}
		{ static double _itmp84[] = {4.53623e04,1.21504e00,6.21636e-03,
		  9.28992e-02,1.50929e-13};
		for( I=1, _r = 0; I <= 5; I++ )
		{
			PHH[84][I-1] = (float)_itmp84[_r++];
			}
		}
		{ static double _itmp85[] = {4.57412e04,1.21425e00,6.17286e-03,
		  9.25980e-02,1.48701e-13};
		for( I=1, _r = 0; I <= 5; I++ )
		{
			PHH[85][I-1] = (float)_itmp85[_r++];
			}
		}
		{ static double _itmp86[] = {4.58669e04,1.21368e00,6.14706e-03,
		  9.23910e-02,1.48998e-13};
		for( I=1, _r = 0; I <= 5; I++ )
		{
			PHH[86][I-1] = (float)_itmp86[_r++];
			}
		}
		{ static double _itmp87[] = {4.64746e04,1.21260e00,6.08280e-03,
		  9.19582e-02,1.44578e-13};
		for( I=1, _r = 0; I <= 5; I++ )
		{
			PHH[87][I-1] = (float)_itmp87[_r++];
			}
		}
		{ static double _itmp88[] = {4.67313e04,1.21198e00,6.05299e-03,
		  9.17324e-02,1.43630e-13};
		for( I=1, _r = 0; I <= 5; I++ )
		{
			PHH[88][I-1] = (float)_itmp88[_r++];
			}
		}
		{ static double _itmp89[] = {4.72504e04,1.21100e00,5.99627e-03,
		  9.13374e-02,1.40241e-13};
		for( I=1, _r = 0; I <= 5; I++ )
		{
			PHH[89][I-1] = (float)_itmp89[_r++];
			}
		}
		{ static double _itmp90[] = {4.75397e04,1.21076e00,5.98892e-03,
		  9.12843e-02,1.39133e-13};
		for( I=1, _r = 0; I <= 5; I++ )
		{
			PHH[90][I-1] = (float)_itmp90[_r++];
			}
		}
		{ static double _itmp91[] = {4.78916e04,1.20989e00,5.94172e-03,
		  9.09401e-02,1.37340e-13};
		for( I=1, _r = 0; I <= 5; I++ )
		{
			PHH[91][I-1] = (float)_itmp91[_r++];
			}
		}
		{ static double _itmp92[] = {4.84595e04,1.20887e00,5.88514e-03,
		  9.05207e-02,1.33742e-13};
		for( I=1, _r = 0; I <= 5; I++ )
		{
			PHH[92][I-1] = (float)_itmp92[_r++];
			}
		}
		{ static double _itmp93[] = {4.98872e04,1.20647e00,5.74072e-03,
		  8.94596e-02,1.23380e-13};
		for( I=1, _r = 0; I <= 5; I++ )
		{
			PHH[93][I-1] = (float)_itmp93[_r++];
			}
		}
		{ static double _itmp94[] = {5.02178e04,1.20578e00,5.70418e-03,
		  8.91986e-02,1.22067e-13};
		for( I=1, _r = 0; I <= 5; I++ )
		{
			PHH[94][I-1] = (float)_itmp94[_r++];
			}
		}
		{ static double _itmp95[] = {5.05910e04,1.20509e00,5.66983e-03,
		  8.89294e-02,1.20466e-13};
		for( I=1, _r = 0; I <= 5; I++ )
		{
			PHH[95][I-1] = (float)_itmp95[_r++];
			}
		}
		{ static double _itmp96[] = {5.08355e04,1.20460e00,5.64584e-03,
		  8.87566e-02,1.19839e-13};
		for( I=1, _r = 0; I <= 5; I++ )
		{
			PHH[96][I-1] = (float)_itmp96[_r++];
			}
		}
		{ static double _itmp97[] = {5.10768e04,1.20412e00,5.62479e-03,
		  8.85841e-02,1.19234e-13};
		for( I=1, _r = 0; I <= 5; I++ )
		{
			PHH[97][I-1] = (float)_itmp97[_r++];
			}
		}
		{ static double _itmp98[] = {5.13650e04,1.20348e00,5.59185e-03,
		  8.83416e-02,1.18272e-13};
		for( I=1, _r = 0; I <= 5; I++ )
		{
			PHH[98][I-1] = (float)_itmp98[_r++];
			}
		}
		{ static double _itmp99[] = {5.15616e04,1.20280e00,5.56150e-03,
		  8.80741e-02,1.17928e-13};
		for( I=1, _r = 0; I <= 5; I++ )
		{
			PHH[99][I-1] = (float)_itmp99[_r++];
			}
		}
		{ static double _itmp100[] = {5.15049e04,1.20288e00,5.57236e-03,
		  8.81638e-02,1.19484e-13};
		for( I=1, _r = 0; I <= 5; I++ )
		{
			PHH[100][I-1] = (float)_itmp100[_r++];
			}
		}
		{ static double _itmp101[] = {5.16203e04,1.20239e00,5.55256e-03,
		  8.79774e-02,1.19718e-13};
		for( I=1, _r = 0; I <= 5; I++ )
		{
			PHH[101][I-1] = (float)_itmp101[_r++];
			}
		}
		{ static double _itmp102[] = {5.20700e04,1.20183e00,5.52369e-03,
		  8.77696e-02,1.17647e-13};
		for( I=1, _r = 0; I <= 5; I++ )
		{
			PHH[102][I-1] = (float)_itmp102[_r++];
			}
		}
		{ static double _itmp103[] = {5.22801e04,1.20111e00,5.48987e-03,
		  8.74815e-02,1.17181e-13};
		for( I=1, _r = 0; I <= 5; I++ )
		{
			PHH[103][I-1] = (float)_itmp103[_r++];
			}
		}
		{ static double _itmp104[] = {5.26918e04,1.20047e00,5.45422e-03,
		  8.72364e-02,1.15403e-13};
		for( I=1, _r = 0; I <= 5; I++ )
		{
			PHH[104][I-1] = (float)_itmp104[_r++];
			}
		}
		{ static double _itmp105[] = {5.30097e04,1.19987e00,5.42558e-03,
		  8.69977e-02,1.14269e-13};
		for( I=1, _r = 0; I <= 5; I++ )
		{
			PHH[105][I-1] = (float)_itmp105[_r++];
			}
		}
		{ static double _itmp106[] = {5.31625e04,1.19949e00,5.40908e-03,
		  8.68723e-02,1.14250e-13};
		for( I=1, _r = 0; I <= 5; I++ )
		{
			PHH[106][I-1] = (float)_itmp106[_r++];
			}
		}
		{ static double _itmp107[] = {5.32084e04,1.19910e00,5.39659e-03,
		  8.67286e-02,1.14906e-13};
		for( I=1, _r = 0; I <= 5; I++ )
		{
			PHH[107][I-1] = (float)_itmp107[_r++];
			}
		}
		{ static double _itmp108[] = {5.39327e04,1.19789e00,5.32780e-03,
		  8.62162e-02,1.11101e-13};
		for( I=1, _r = 0; I <= 5; I++ )
		{
			PHH[108][I-1] = (float)_itmp108[_r++];
			}
		}
}
void hpfitData2(void)
{
		{ static double _itmp109[] = {5.42985e04,1.19747e00,5.31012e-03,
		  8.60574e-02,1.09764e-13};
		for( I=1, _r = 0; I <= 5; I++ )
		{
			PHH[109][I-1] = (float)_itmp109[_r++];
			}
		}
		{ static double _itmp110[] = {5.47482e04,1.19671e00,5.26994e-03,
		  8.57517e-02,1.07888e-13};
		for( I=1, _r = 0; I <= 5; I++ )
		{
			PHH[110][I-1] = (float)_itmp110[_r++];
			}
		}
		{ static double _itmp111[] = {5.53598e04,1.19566e00,5.21107e-03,
		  8.53086e-02,1.05076e-13};
		for( I=1, _r = 0; I <= 5; I++ )
		{
			PHH[111][I-1] = (float)_itmp111[_r++];
			}
		}
		{ static double _itmp112[] = {5.56526e04,1.19515e00,5.19132e-03,
		  8.51014e-02,1.04227e-13};
		for( I=1, _r = 0; I <= 5; I++ )
		{
			PHH[112][I-1] = (float)_itmp112[_r++];
			}
		}
		{ static double _itmp113[] = {5.62626e04,1.19423e00,5.14124e-03,
		  8.47205e-02,1.01584e-13};
		for( I=1, _r = 0; I <= 5; I++ )
		{
			PHH[113][I-1] = (float)_itmp113[_r++];
			}
		}
		{ static double _itmp114[] = {5.64509e04,1.19374e00,5.12138e-03,
		  8.45269e-02,1.01336e-13};
		for( I=1, _r = 0; I <= 5; I++ )
		{
			PHH[114][I-1] = (float)_itmp114[_r++];
			}
		}
		{ static double _itmp115[] = {5.65048e04,1.19347e00,5.11202e-03,
		  8.44478e-02,1.01850e-13};
		for( I=1, _r = 0; I <= 5; I++ )
		{
			PHH[115][I-1] = (float)_itmp115[_r++];
			}
		}
		{ static double _itmp116[] = {5.63001e04,1.19365e00,5.13057e-03,
		  8.45656e-02,1.03855e-13};
		for( I=1, _r = 0; I <= 5; I++ )
		{
			PHH[116][I-1] = (float)_itmp116[_r++];
			}
		}
		{ static double _itmp117[] = {5.62106e04,1.19367e00,5.13907e-03,
		  8.46105e-02,1.05220e-13};
		for( I=1, _r = 0; I <= 5; I++ )
		{
			PHH[117][I-1] = (float)_itmp117[_r++];
			}
		}
		{ static double _itmp118[] = {5.63240e04,1.19328e00,5.12788e-03,
		  8.44597e-02,1.05369e-13};
		for( I=1, _r = 0; I <= 5; I++ )
		{
			PHH[118][I-1] = (float)_itmp118[_r++];
			}
		}
		{ static double _itmp119[] = {5.63976e04,1.19293e00,5.11407e-03,
		  8.43346e-02,1.05744e-13};
		for( I=1, _r = 0; I <= 5; I++ )
		{
			PHH[119][I-1] = (float)_itmp119[_r++];
			}
		}
		{ static double _itmp120[] = {5.59892e04,1.19323e00,5.14229e-03,
		  8.45086e-02,1.08999e-13};
		for( I=1, _r = 0; I <= 5; I++ )
		{
			PHH[120][I-1] = (float)_itmp120[_r++];
			}
		}
		{ static double _itmp121[] = {5.61317e04,1.19317e00,5.14126e-03,
		  8.45229e-02,1.09032e-13};
		for( I=1, _r = 0; I <= 5; I++ )
		{
			PHH[121][I-1] = (float)_itmp121[_r++];
			}
		}
		{ static double _itmp122[] = {5.64118e04,1.19274e00,5.12409e-03,
		  8.43517e-02,1.08190e-13};
		for( I=1, _r = 0; I <= 5; I++ )
		{
			PHH[122][I-1] = (float)_itmp122[_r++];
			}
		}
		{ static double _itmp123[] = {5.63712e04,1.19258e00,5.12406e-03,
		  8.43088e-02,1.09242e-13};
		for( I=1, _r = 0; I <= 5; I++ )
		{
			PHH[123][I-1] = (float)_itmp123[_r++];
			}
		}
		{ static double _itmp124[] = {5.66924e04,1.19188e00,5.09079e-03,
		  8.40173e-02,1.08103e-13};
		for( I=1, _r = 0; I <= 5; I++ )
		{
			PHH[124][I-1] = (float)_itmp124[_r++];
			}
		}
		{ static double _itmp125[] = {5.67500e04,1.19178e00,5.08880e-03,
		  8.40072e-02,1.08594e-13};
		for( I=1, _r = 0; I <= 5; I++ )
		{
			PHH[125][I-1] = (float)_itmp125[_r++];
			}
		}
		{ static double _itmp126[] = {5.71390e04,1.19113e00,5.05839e-03,
		  8.37378e-02,1.07089e-13};
		for( I=1, _r = 0; I <= 5; I++ )
		{
			PHH[126][I-1] = (float)_itmp126[_r++];
			}
		}
		{ static double _itmp127[] = {5.70679e04,1.19104e00,5.06027e-03,
		  8.37273e-02,1.08292e-13};
		for( I=1, _r = 0; I <= 5; I++ )
		{
			PHH[127][I-1] = (float)_itmp127[_r++];
			}
		}
		{ static double _itmp128[] = {5.70957e04,1.19074e00,5.05193e-03,
		  8.36150e-02,1.08889e-13};
		for( I=1, _r = 0; I <= 5; I++ )
		{
			PHH[128][I-1] = (float)_itmp128[_r++];
			}
		}
		{ static double _itmp129[] = {5.72020e04,1.19060e00,5.04686e-03,
		  8.35863e-02,1.09074e-13};
		for( I=1, _r = 0; I <= 5; I++ )
		{
			PHH[129][I-1] = (float)_itmp129[_r++];
			}
		}
		{ static double _itmp130[] = {5.71903e04,1.19039e00,5.04318e-03,
		  8.35158e-02,1.09911e-13};
		for( I=1, _r = 0; I <= 5; I++ )
		{
			PHH[130][I-1] = (float)_itmp130[_r++];
			}
		}
		{ static double _itmp131[] = {5.72388e04,1.19028e00,5.04478e-03,
		  8.34939e-02,1.10422e-13};
		for( I=1, _r = 0; I <= 5; I++ )
		{
			PHH[131][I-1] = (float)_itmp131[_r++];
			}
		}
		{ static double _itmp132[] = {5.71377e04,1.19007e00,5.04055e-03,
		  8.34292e-02,1.11778e-13};
		for( I=1, _r = 0; I <= 5; I++ )
		{
			PHH[132][I-1] = (float)_itmp132[_r++];
			}
		}
		{ static double _itmp133[] = {5.68854e04,1.19047e00,5.07016e-03,
		  8.36427e-02,1.14177e-13};
		for( I=1, _r = 0; I <= 5; I++ )
		{
			PHH[133][I-1] = (float)_itmp133[_r++];
			}
		}
		{ static double _itmp134[] = {5.67902e04,1.19026e00,5.06625e-03,
		  8.35736e-02,1.15534e-13};
		for( I=1, _r = 0; I <= 5; I++ )
		{
			PHH[134][I-1] = (float)_itmp134[_r++];
			}
		}
		{ static double _itmp135[] = {5.66644e04,1.19047e00,5.08405e-03,
		  8.37017e-02,1.17186e-13};
		for( I=1, _r = 0; I <= 5; I++ )
		{
			PHH[135][I-1] = (float)_itmp135[_r++];
			}
		}
		{ static double _itmp136[] = {5.64886e04,1.19041e00,5.09217e-03,
		  8.36938e-02,1.19105e-13};
		for( I=1, _r = 0; I <= 5; I++ )
		{
			PHH[136][I-1] = (float)_itmp136[_r++];
			}
		}
		{ static double _itmp137[] = {5.85530e04,1.18765e00,4.93064e-03,
		  8.24445e-02,1.07198e-13};
		for( I=1, _r = 0; I <= 5; I++ )
		{
			PHH[137][I-1] = (float)_itmp137[_r++];
			}
		}
		{ static double _itmp138[] = {5.86855e04,1.18747e00,4.92364e-03,
		  8.23949e-02,1.07190e-13};
		for( I=1, _r = 0; I <= 5; I++ )
		{
			PHH[138][I-1] = (float)_itmp138[_r++];
			}
		}
		{ static double _itmp139[] = {5.88453e04,1.18691e00,4.90199e-03,
		  8.21526e-02,1.06948e-13};
		for( I=1, _r = 0; I <= 5; I++ )
		{
			PHH[139][I-1] = (float)_itmp139[_r++];
			}
		}
		{ static double _itmp140[] = {5.88638e04,1.18704e00,4.91314e-03,
		  8.22433e-02,1.07616e-13};
		for( I=1, _r = 0; I <= 5; I++ )
		{
			PHH[140][I-1] = (float)_itmp140[_r++];
			}
		}
		{ static double _itmp141[] = {5.87851e04,1.18691e00,4.91251e-03,
		  8.22120e-02,1.08765e-13};
		for( I=1, _r = 0; I <= 5; I++ )
		{
			PHH[141][I-1] = (float)_itmp141[_r++];
			}
		}
		{ static double _itmp142[] = {5.88130e04,1.18659e00,4.90079e-03,
		  8.20866e-02,1.09285e-13};
		for( I=1, _r = 0; I <= 5; I++ )
		{
			PHH[142][I-1] = (float)_itmp142[_r++];
			}
		}
		{ static double _itmp143[] = {5.93471e04,1.18588e00,4.86743e-03,
		  8.17790e-02,1.06950e-13};
		for( I=1, _r = 0; I <= 5; I++ )
		{
			PHH[143][I-1] = (float)_itmp143[_r++];
			}
		}
		{ static double _itmp144[] = {5.95908e04,1.18557e00,4.85105e-03,
		  8.16661e-02,1.06301e-13};
		for( I=1, _r = 0; I <= 5; I++ )
		{
			PHH[144][I-1] = (float)_itmp144[_r++];
			}
		}
		{ static double _itmp145[] = {5.97129e04,1.18536e00,4.84487e-03,
		  8.15949e-02,1.06318e-13};
		for( I=1, _r = 0; I <= 5; I++ )
		{
			PHH[145][I-1] = (float)_itmp145[_r++];
			}
		}
		{ static double _itmp146[] = {5.96874e04,1.18516e00,4.84112e-03,
		  8.15297e-02,1.07120e-13};
		for( I=1, _r = 0; I <= 5; I++ )
		{
			PHH[146][I-1] = (float)_itmp146[_r++];
			}
		}
		{ static double _itmp147[] = {5.98537e04,1.18475e00,4.82531e-03,
		  8.13542e-02,1.06848e-13};
		for( I=1, _r = 0; I <= 5; I++ )
		{
			PHH[147][I-1] = (float)_itmp147[_r++];
			}
		}
		{ static double _itmp148[] = {6.01163e04,1.18433e00,4.80679e-03,
		  8.11877e-02,1.06068e-13};
		for( I=1, _r = 0; I <= 5; I++ )
		{
			PHH[148][I-1] = (float)_itmp148[_r++];
			}
		}
		{ static double _itmp149[] = {6.02535e04,1.18400e00,4.79354e-03,
		  8.10538e-02,1.05967e-13};
		for( I=1, _r = 0; I <= 5; I++ )
		{
			PHH[149][I-1] = (float)_itmp149[_r++];
			}
		}
		{ static double _itmp150[] = {6.12993e04,1.18263e00,4.71801e-03,
		  8.04429e-02,1.01044e-13};
		for( I=1, _r = 0; I <= 5; I++ )
		{
			PHH[150][I-1] = (float)_itmp150[_r++];
			}
		}
		{ static double _itmp151[] = {6.15881e04,1.18211e00,4.69647e-03,
		  8.02230e-02,1.00175e-13};
		for( I=1, _r = 0; I <= 5; I++ )
		{
			PHH[151][I-1] = (float)_itmp151[_r++];
			}
		}
		{ static double _itmp152[] = {6.15834e04,1.18205e00,4.69907e-03,
		  8.02166e-02,1.00826e-13};
		for( I=1, _r = 0; I <= 5; I++ )
		{
			PHH[152][I-1] = (float)_itmp152[_r++];
			}
		}
		{ static double _itmp153[] = {6.21590e04,1.18146e00,4.66635e-03,
		  7.99722e-02,9.85752e-14};
		for( I=1, _r = 0; I <= 5; I++ )
		{
			PHH[153][I-1] = (float)_itmp153[_r++];
			}
		}
		{ static double _itmp154[] = {6.20649e04,1.18144e00,4.67359e-03,
		  7.99807e-02,9.96399e-14};
		for( I=1, _r = 0; I <= 5; I++ )
		{
			PHH[154][I-1] = (float)_itmp154[_r++];
			}
		}
		{ static double _itmp155[] = {6.20998e04,1.18126e00,4.66945e-03,
		  7.99154e-02,1.00061e-13};
		for( I=1, _r = 0; I <= 5; I++ )
		{
			PHH[155][I-1] = (float)_itmp155[_r++];
			}
		}
		{ static double _itmp156[] = {6.21969e04,1.18093e00,4.65326e-03,
		  7.97913e-02,1.00153e-13};
		for( I=1, _r = 0; I <= 5; I++ )
		{
			PHH[156][I-1] = (float)_itmp156[_r++];
			}
		}
		{ static double _itmp157[] = {6.26209e04,1.18051e00,4.63736e-03,
		  7.96109e-02,9.86650e-14};
		for( I=1, _r = 0; I <= 5; I++ )
		{
			PHH[157][I-1] = (float)_itmp157[_r++];
			}
		}
		{ static double _itmp158[] = {6.26851e04,1.18013e00,4.62024e-03,
		  7.94646e-02,9.88984e-14};
		for( I=1, _r = 0; I <= 5; I++ )
		{
			PHH[158][I-1] = (float)_itmp158[_r++];
			}
		}
		{ static double _itmp159[] = {6.27897e04,1.17991e00,4.61297e-03,
		  7.93820e-02,9.89649e-14};
		for( I=1, _r = 0; I <= 5; I++ )
		{
			PHH[159][I-1] = (float)_itmp159[_r++];
			}
		}
		{ static double _itmp160[] = {6.32154e04,1.17946e00,4.59261e-03,
		  7.91949e-02,9.74916e-14};
		for( I=1, _r = 0; I <= 5; I++ )
		{
			PHH[160][I-1] = (float)_itmp160[_r++];
			}
		}
		{ static double _itmp161[] = {6.28296e04,1.17960e00,4.60748e-03,
		  7.92777e-02,9.99157e-14};
		for( I=1, _r = 0; I <= 5; I++ )
		{
			PHH[161][I-1] = (float)_itmp161[_r++];
			}
		}
		{ static double _itmp162[] = {6.27666e04,1.17960e00,4.61281e-03,
		  7.93002e-02,1.00817e-13};
		for( I=1, _r = 0; I <= 5; I++ )
		{
			PHH[162][I-1] = (float)_itmp162[_r++];
			}
		}
}
void hpfitData3(void)
{
		{ static double _itmp163[] = {6.28188e04,1.17926e00,4.60014e-03,
		  7.91606e-02,1.01098e-13};
		for( I=1, _r = 0; I <= 5; I++ )
		{
			PHH[163][I-1] = (float)_itmp163[_r++];
			}
		}
		{ static double _itmp164[] = {6.49777e04,1.17700e00,4.47186e-03,
		  7.81305e-02,9.15301e-14};
		for( I=1, _r = 0; I <= 5; I++ )
		{
			PHH[164][I-1] = (float)_itmp164[_r++];
			}
		}
		{ static double _itmp165[] = {6.49998e04,1.17682e00,4.46764e-03,
		  7.80687e-02,9.19442e-14};
		for( I=1, _r = 0; I <= 5; I++ )
		{
			PHH[165][I-1] = (float)_itmp165[_r++];
			}
		}
		{ static double _itmp166[] = {6.50971e04,1.17673e00,4.46685e-03,
		  7.80477e-02,9.20540e-14};
		for( I=1, _r = 0; I <= 5; I++ )
		{
			PHH[166][I-1] = (float)_itmp166[_r++];
			}
		}
		{ static double _itmp167[] = {6.51001e04,1.17668e00,4.47044e-03,
		  7.80443e-02,9.25666e-14};
		for( I=1, _r = 0; I <= 5; I++ )
		{
			PHH[167][I-1] = (float)_itmp167[_r++];
			}
		}
		{ static double _itmp168[] = {6.53712e04,1.17590e00,4.43566e-03,
		  7.76892e-02,9.18101e-14};
		for( I=1, _r = 0; I <= 5; I++ )
		{
			PHH[168][I-1] = (float)_itmp168[_r++];
			}
		}
		{ static double _itmp169[] = {6.59554e04,1.17541e00,4.40940e-03,
		  7.74885e-02,8.98314e-14};
		for( I=1, _r = 0; I <= 5; I++ )
		{
			PHH[169][I-1] = (float)_itmp169[_r++];
			}
		}
		{ static double _itmp170[] = {6.60573e04,1.17525e00,4.40404e-03,
		  7.74358e-02,8.99013e-14};
		for( I=1, _r = 0; I <= 5; I++ )
		{
			PHH[170][I-1] = (float)_itmp170[_r++];
			}
		}
		{ static double _itmp171[] = {6.61940e04,1.17513e00,4.40154e-03,
		  7.73997e-02,8.98355e-14};
		for( I=1, _r = 0; I <= 5; I++ )
		{
			PHH[171][I-1] = (float)_itmp171[_r++];
			}
		}
		{ static double _itmp172[] = {6.63293e04,1.17456e00,4.37606e-03,
		  7.71503e-02,8.96919e-14};
		for( I=1, _r = 0; I <= 5; I++ )
		{
			PHH[172][I-1] = (float)_itmp172[_r++];
			}
		}
		{ static double _itmp173[] = {6.65814e04,1.17430e00,4.36866e-03,
		  7.70420e-02,8.91325e-14};
		for( I=1, _r = 0; I <= 5; I++ )
		{
			PHH[173][I-1] = (float)_itmp173[_r++];
			}
		}
		{ static double _itmp174[] = {6.65895e04,1.17427e00,4.36925e-03,
		  7.70586e-02,8.95946e-14};
		for( I=1, _r = 0; I <= 5; I++ )
		{
			PHH[174][I-1] = (float)_itmp174[_r++];
			}
		}
		{ static double _itmp175[] = {6.68073e04,1.17394e00,4.35579e-03,
		  7.69209e-02,8.91590e-14};
		for( I=1, _r = 0; I <= 5; I++ )
		{
			PHH[175][I-1] = (float)_itmp175[_r++];
			}
		}
		{ static double _itmp176[] = {6.68303e04,1.17387e00,4.35616e-03,
		  7.69057e-02,8.95459e-14};
		for( I=1, _r = 0; I <= 5; I++ )
		{
			PHH[176][I-1] = (float)_itmp176[_r++];
			}
		}
		{ static double _itmp177[] = {6.74621e04,1.17325e00,4.32576e-03,
		  7.66363e-02,8.74358e-14};
		for( I=1, _r = 0; I <= 5; I++ )
		{
			PHH[177][I-1] = (float)_itmp177[_r++];
			}
		}
		{ static double _itmp178[] = {6.83886e04,1.17218e00,4.26888e-03,
		  7.61559e-02,8.42239e-14};
		for( I=1, _r = 0; I <= 5; I++ )
		{
			PHH[178][I-1] = (float)_itmp178[_r++];
			}
		}
		{ static double _itmp179[] = {6.92863e04,1.17117e00,4.21869e-03,
		  7.57032e-02,8.12833e-14};
		for( I=1, _r = 0; I <= 5; I++ )
		{
			PHH[179][I-1] = (float)_itmp179[_r++];
			}
		}
		{ static double _itmp180[] = {6.93488e04,1.17128e00,4.22583e-03,
		  7.57736e-02,8.15203e-14};
		for( I=1, _r = 0; I <= 5; I++ )
		{
			PHH[180][I-1] = (float)_itmp180[_r++];
			}
		}
		{ static double _itmp181[] = {6.95462e04,1.17057e00,4.19544e-03,
		  7.54550e-02,8.11497e-14};
		for( I=1, _r = 0; I <= 5; I++ )
		{
			PHH[181][I-1] = (float)_itmp181[_r++];
			}
		}
		{ static double _itmp182[] = {7.01551e04,1.16996e00,4.16792e-03,
		  7.51812e-02,7.93871e-14};
		for( I=1, _r = 0; I <= 5; I++ )
		{
			PHH[182][I-1] = (float)_itmp182[_r++];
			}
		}
		{ static double _itmp183[] = {7.11655e04,1.16926e00,4.12696e-03,
		  7.48849e-02,7.63674e-14};
		for( I=1, _r = 0; I <= 5; I++ )
		{
			PHH[183][I-1] = (float)_itmp183[_r++];
			}
		}
		{ static double _itmp184[] = {7.26336e04,1.16728e00,4.02543e-03,
		  7.39746e-02,7.19420e-14};
		for( I=1, _r = 0; I <= 5; I++ )
		{
			PHH[184][I-1] = (float)_itmp184[_r++];
			}
		}
		{ static double _itmp185[] = {7.28369e04,1.16733e00,4.03171e-03,
		  7.40156e-02,7.17252e-14};
		for( I=1, _r = 0; I <= 5; I++ )
		{
			PHH[185][I-1] = (float)_itmp185[_r++];
			}
		}
		{ static double _itmp186[] = {7.33426e04,1.16671e00,4.00143e-03,
		  7.37486e-02,7.05385e-14};
		for( I=1, _r = 0; I <= 5; I++ )
		{
			PHH[186][I-1] = (float)_itmp186[_r++];
			}
		}
		{ static double _itmp187[] = {7.36828e04,1.16643e00,3.99036e-03,
		  7.36310e-02,6.98917e-14};
		for( I=1, _r = 0; I <= 5; I++ )
		{
			PHH[187][I-1] = (float)_itmp187[_r++];
			}
		}
		{ static double _itmp188[] = {7.39666e04,1.16614e00,3.97808e-03,
		  7.35127e-02,6.94100e-14};
		for( I=1, _r = 0; I <= 5; I++ )
		{
			PHH[188][I-1] = (float)_itmp188[_r++];
			}
		}
		{ static double _itmp189[] = {7.40107e04,1.16601e00,3.97690e-03,
		  7.34663e-02,6.96236e-14};
		for( I=1, _r = 0; I <= 5; I++ )
		{
			PHH[189][I-1] = (float)_itmp189[_r++];
			}
		}
		{ static double _itmp190[] = {7.39172e04,1.16586e00,3.97482e-03,
		  7.34083e-02,7.02226e-14};
		for( I=1, _r = 0; I <= 5; I++ )
		{
			PHH[190][I-1] = (float)_itmp190[_r++];
			}
		}
		{ static double _itmp191[] = {7.45995e04,1.16527e00,3.94497e-03,
		  7.31551e-02,6.85885e-14};
		for( I=1, _r = 0; I <= 5; I++ )
		{
			PHH[191][I-1] = (float)_itmp191[_r++];
			}
		}
		{ static double _itmp192[] = {7.50173e04,1.16479e00,3.92397e-03,
		  7.29436e-02,6.77286e-14};
		for( I=1, _r = 0; I <= 5; I++ )
		{
			PHH[192][I-1] = (float)_itmp192[_r++];
			}
		}
		{ static double _itmp193[] = {7.58009e04,1.16410e00,3.88972e-03,
		  7.26377e-02,6.58975e-14};
		for( I=1, _r = 0; I <= 5; I++ )
		{
			PHH[193][I-1] = (float)_itmp193[_r++];
			}
		}
		{ static double _itmp194[] = {7.65273e04,1.16333e00,3.85286e-03,
		  7.22975e-02,6.42674e-14};
		for( I=1, _r = 0; I <= 5; I++ )
		{
			PHH[194][I-1] = (float)_itmp194[_r++];
			}
		}
		{ static double _itmp195[] = {7.67465e04,1.16309e00,3.84380e-03,
		  7.22001e-02,6.40069e-14};
		for( I=1, _r = 0; I <= 5; I++ )
		{
			PHH[195][I-1] = (float)_itmp195[_r++];
			}
		}
		{ static double _itmp196[] = {7.83220e04,1.16165e00,3.76989e-03,
		  7.15471e-02,6.03590e-14};
		for( I=1, _r = 0; I <= 5; I++ )
		{
			PHH[196][I-1] = (float)_itmp196[_r++];
			}
		}
		{ static double _itmp197[] = {7.86456e04,1.16134e00,3.75780e-03,
		  7.14128e-02,5.98753e-14};
		for( I=1, _r = 0; I <= 5; I++ )
		{
			PHH[197][I-1] = (float)_itmp197[_r++];
			}
		}
		{ static double _itmp198[] = {7.88621e04,1.16124e00,3.75643e-03,
		  7.13818e-02,5.96646e-14};
		for( I=1, _r = 0; I <= 5; I++ )
		{
			PHH[198][I-1] = (float)_itmp198[_r++];
			}
		}
		{ static double _itmp199[] = {7.94154e04,1.16056e00,3.72562e-03,
		  7.10786e-02,5.86356e-14};
		for( I=1, _r = 0; I <= 5; I++ )
		{
			PHH[199][I-1] = (float)_itmp199[_r++];
			}
		}
		{ static double _itmp200[] = {7.96269e04,1.16016e00,3.70716e-03,
		  7.09092e-02,5.84067e-14};
		for( I=1, _r = 0; I <= 5; I++ )
		{
			PHH[200][I-1] = (float)_itmp200[_r++];
			}
		}
		{ static double _itmp201[] = {8.00661e04,1.15983e00,3.69397e-03,
		  7.07664e-02,5.76932e-14};
		for( I=1, _r = 0; I <= 5; I++ )
		{
			PHH[201][I-1] = (float)_itmp201[_r++];
			}
		}
		{ static double _itmp202[] = {8.10129e04,1.15905e00,3.65865e-03,
		  7.04134e-02,5.58797e-14};
		for( I=1, _r = 0; I <= 5; I++ )
		{
			PHH[202][I-1] = (float)_itmp202[_r++];
			}
		}
		{ static double _itmp203[] = {8.13573e04,1.15870e00,3.64328e-03,
		  7.02705e-02,5.54012e-14};
		for( I=1, _r = 0; I <= 5; I++ )
		{
			PHH[203][I-1] = (float)_itmp203[_r++];
			}
		}
		{ static double _itmp204[] = {8.15364e04,1.15849e00,3.63595e-03,
		  7.01817e-02,5.52756e-14};
		for( I=1, _r = 0; I <= 5; I++ )
		{
			PHH[204][I-1] = (float)_itmp204[_r++];
			}
		}
		{ static double _itmp205[] = {8.16732e04,1.15816e00,3.62227e-03,
		  7.00475e-02,5.52242e-14};
		for( I=1, _r = 0; I <= 5; I++ )
		{
			PHH[205][I-1] = (float)_itmp205[_r++];
			}
		}
		{ static double _itmp206[] = {8.20184e04,1.15784e00,3.61158e-03,
		  6.99051e-02,5.47526e-14};
		for( I=1, _r = 0; I <= 5; I++ )
		{
			PHH[206][I-1] = (float)_itmp206[_r++];
			}
		}
		{ static double _itmp207[] = {8.23027e04,1.15760e00,3.60165e-03,
		  6.98110e-02,5.44176e-14};
		for( I=1, _r = 0; I <= 5; I++ )
		{
			PHH[207][I-1] = (float)_itmp207[_r++];
			}
		}
		{ static double _itmp208[] = {8.26037e04,1.15719e00,3.58450e-03,
		  6.96305e-02,5.40326e-14};
		for( I=1, _r = 0; I <= 5; I++ )
		{
			PHH[208][I-1] = (float)_itmp208[_r++];
			}
		}
		{ static double _itmp209[] = {8.28891e04,1.15698e00,3.57542e-03,
		  6.95479e-02,5.37045e-14};
		for( I=1, _r = 0; I <= 5; I++ )
		{
			PHH[209][I-1] = (float)_itmp209[_r++];
			}
		}
		{ static double _itmp210[] = {8.31632e04,1.15664e00,3.56328e-03,
		  6.94017e-02,5.33854e-14};
		for( I=1, _r = 0; I <= 5; I++ )
		{
			PHH[210][I-1] = (float)_itmp210[_r++];
			}
		}
		{ static double _itmp211[] = {8.38334e04,1.15620e00,3.54204e-03,
		  6.92124e-02,5.23135e-14};
		for( I=1, _r = 0; I <= 5; I++ )
		{
			PHH[211][I-1] = (float)_itmp211[_r++];
			}
		}
		{ static double _itmp212[] = {8.45296e04,1.15556e00,3.51339e-03,
		  6.89287e-02,5.12031e-14};
		for( I=1, _r = 0; I <= 5; I++ )
		{
			PHH[212][I-1] = (float)_itmp212[_r++];
			}
		}
		{ static double _itmp213[] = {8.51244e04,1.15504e00,3.49037e-03,
		  6.86951e-02,5.03153e-14};
		for( I=1, _r = 0; I <= 5; I++ )
		{
			PHH[213][I-1] = (float)_itmp213[_r++];
			}
		}
		{ static double _itmp214[] = {8.55104e04,1.15472e00,3.47542e-03,
		  6.85645e-02,4.98329e-14};
		for( I=1, _r = 0; I <= 5; I++ )
		{
			PHH[214][I-1] = (float)_itmp214[_r++];
			}
		}
		{ static double _itmp215[] = {8.59027e04,1.15445e00,3.46470e-03,
		  6.84513e-02,4.93502e-14};
		for( I=1, _r = 0; I <= 5; I++ )
		{
			PHH[215][I-1] = (float)_itmp215[_r++];
			}
		}
		{ static double _itmp216[] = {8.63232e04,1.15394e00,3.44238e-03,
		  6.82267e-02,4.88031e-14};
		for( I=1, _r = 0; I <= 5; I++ )
		{
			PHH[216][I-1] = (float)_itmp216[_r++];
			}
		}
}
void hpfitData4(void)
{
		{ static double _itmp217[] = {8.67658e04,1.15358e00,3.42754e-03,
		  6.80725e-02,4.82421e-14};
		for( I=1, _r = 0; I <= 5; I++ )
		{
			PHH[217][I-1] = (float)_itmp217[_r++];
			}
		}
		{ static double _itmp218[] = {8.71436e04,1.15326e00,3.41489e-03,
		  6.79327e-02,4.77995e-14};
		for( I=1, _r = 0; I <= 5; I++ )
		{
			PHH[218][I-1] = (float)_itmp218[_r++];
			}
		}
		{ static double _itmp219[] = {8.75238e04,1.15294e00,3.40150e-03,
		  6.77952e-02,4.73598e-14};
		for( I=1, _r = 0; I <= 5; I++ )
		{
			PHH[219][I-1] = (float)_itmp219[_r++];
			}
		}
		{ static double _itmp220[] = {8.78433e04,1.15270e00,3.39224e-03,
		  6.76996e-02,4.70311e-14};
		for( I=1, _r = 0; I <= 5; I++ )
		{
			PHH[220][I-1] = (float)_itmp220[_r++];
			}
		}
		{ static double _itmp221[] = {8.83514e04,1.15228e00,3.37388e-03,
		  6.75155e-02,4.63900e-14};
		for( I=1, _r = 0; I <= 5; I++ )
		{
			PHH[221][I-1] = (float)_itmp221[_r++];
			}
		}
		{ static double _itmp222[] = {8.87785e04,1.15172e00,3.34931e-03,
		  6.72688e-02,4.58735e-14};
		for( I=1, _r = 0; I <= 5; I++ )
		{
			PHH[222][I-1] = (float)_itmp222[_r++];
			}
		}
		{ static double _itmp223[] = {8.91574e04,1.15145e00,3.33919e-03,
		  6.71508e-02,4.54645e-14};
		for( I=1, _r = 0; I <= 5; I++ )
		{
			PHH[223][I-1] = (float)_itmp223[_r++];
			}
		}
		{ static double _itmp224[] = {8.94967e04,1.15121e00,3.32838e-03,
		  6.70588e-02,4.51244e-14};
		for( I=1, _r = 0; I <= 5; I++ )
		{
			PHH[224][I-1] = (float)_itmp224[_r++];
			}
		}
		{ static double _itmp225[] = {9.12270e04,1.14991e00,3.26653e-03,
		  6.64589e-02,4.26817e-14};
		for( I=1, _r = 0; I <= 5; I++ )
		{
			PHH[225][I-1] = (float)_itmp225[_r++];
			}
		}
		{ static double _itmp226[] = {9.13531e04,1.14982e00,3.26608e-03,
		  6.64247e-02,4.26803e-14};
		for( I=1, _r = 0; I <= 5; I++ )
		{
			PHH[226][I-1] = (float)_itmp226[_r++];
			}
		}
		{ static double _itmp227[] = {9.15646e04,1.14979e00,3.26820e-03,
		  6.64228e-02,4.25650e-14};
		for( I=1, _r = 0; I <= 5; I++ )
		{
			PHH[227][I-1] = (float)_itmp227[_r++];
			}
		}
		{ static double _itmp228[] = {9.17676e04,1.14936e00,3.25112e-03,
		  6.62332e-02,4.24261e-14};
		for( I=1, _r = 0; I <= 5; I++ )
		{
			PHH[228][I-1] = (float)_itmp228[_r++];
			}
		}
		{ static double _itmp229[] = {9.19852e04,1.14917e00,3.24418e-03,
		  6.61558e-02,4.22891e-14};
		for( I=1, _r = 0; I <= 5; I++ )
		{
			PHH[229][I-1] = (float)_itmp229[_r++];
			}
		}
		{ static double _itmp230[] = {9.23665e04,1.14871e00,3.22490e-03,
		  6.59510e-02,4.19049e-14};
		for( I=1, _r = 0; I <= 5; I++ )
		{
			PHH[230][I-1] = (float)_itmp230[_r++];
			}
		}
		{ static double _itmp231[] = {9.27334e04,1.14853e00,3.21863e-03,
		  6.58796e-02,4.15699e-14};
		for( I=1, _r = 0; I <= 5; I++ )
		{
			PHH[231][I-1] = (float)_itmp231[_r++];
			}
		}
		{ static double _itmp232[] = {9.31345e04,1.14835e00,3.21068e-03,
		  6.58105e-02,4.11939e-14};
		for( I=1, _r = 0; I <= 5; I++ )
		{
			PHH[232][I-1] = (float)_itmp232[_r++];
			}
		}
		{ static double _itmp233[] = {9.32638e04,1.14820e00,3.20672e-03,
		  6.57554e-02,4.11821e-14};
		for( I=1, _r = 0; I <= 5; I++ )
		{
			PHH[233][I-1] = (float)_itmp233[_r++];
			}
		}
		{ static double _itmp234[] = {9.34470e04,1.14799e00,3.20042e-03,
		  6.56619e-02,4.10922e-14};
		for( I=1, _r = 0; I <= 5; I++ )
		{
			PHH[234][I-1] = (float)_itmp234[_r++];
			}
		}
		{ static double _itmp235[] = {9.36383e04,1.14773e00,3.19123e-03,
		  6.55532e-02,4.09887e-14};
		for( I=1, _r = 0; I <= 5; I++ )
		{
			PHH[235][I-1] = (float)_itmp235[_r++];
			}
		}
		{ static double _itmp236[] = {9.39122e04,1.14741e00,3.17906e-03,
		  6.54152e-02,4.07725e-14};
		for( I=1, _r = 0; I <= 5; I++ )
		{
			PHH[236][I-1] = (float)_itmp236[_r++];
			}
		}
		{ static double _itmp237[] = {9.46940e04,1.14701e00,3.16010e-03,
		  6.52396e-02,3.99037e-14};
		for( I=1, _r = 0; I <= 5; I++ )
		{
			PHH[237][I-1] = (float)_itmp237[_r++];
			}
		}
		{ static double _itmp238[] = {9.55356e04,1.14632e00,3.12968e-03,
		  6.49305e-02,3.89646e-14};
		for( I=1, _r = 0; I <= 5; I++ )
		{
			PHH[238][I-1] = (float)_itmp238[_r++];
			}
		}
		{ static double _itmp239[] = {9.58083e04,1.14612e00,3.12136e-03,
		  6.48497e-02,3.87748e-14};
		for( I=1, _r = 0; I <= 5; I++ )
		{
			PHH[239][I-1] = (float)_itmp239[_r++];
			}
		}
		{ static double _itmp240[] = {9.59772e04,1.14581e00,3.10892e-03,
		  6.47174e-02,3.87024e-14};
		for( I=1, _r = 0; I <= 5; I++ )
		{
			PHH[240][I-1] = (float)_itmp240[_r++];
			}
		}
		{ static double _itmp241[] = {9.60382e04,1.14590e00,3.11656e-03,
		  6.47660e-02,3.87914e-14};
		for( I=1, _r = 0; I <= 5; I++ )
		{
			PHH[241][I-1] = (float)_itmp241[_r++];
			}
		}
		{ static double _itmp242[] = {9.61351e04,1.14571e00,3.11176e-03,
		  6.46857e-02,3.88142e-14};
		for( I=1, _r = 0; I <= 5; I++ )
		{
			PHH[242][I-1] = (float)_itmp242[_r++];
			}
		}
		{ static double _itmp243[] = {9.62523e04,1.14556e00,3.10646e-03,
		  6.46315e-02,3.88161e-14};
		for( I=1, _r = 0; I <= 5; I++ )
		{
			PHH[243][I-1] = (float)_itmp243[_r++];
			}
		}
		{ static double _itmp244[] = {9.64684e04,1.14534e00,3.09921e-03,
		  6.45360e-02,3.86919e-14};
		for( I=1, _r = 0; I <= 5; I++ )
		{
			PHH[244][I-1] = (float)_itmp244[_r++];
			}
		}
		{ static double _itmp245[] = {9.65454e04,1.14519e00,3.09579e-03,
		  6.44746e-02,3.87404e-14};
		for( I=1, _r = 0; I <= 5; I++ )
		{
			PHH[245][I-1] = (float)_itmp245[_r++];
			}
		}
		{ static double _itmp246[] = {9.66749e04,1.14507e00,3.09092e-03,
		  6.44320e-02,3.87282e-14};
		for( I=1, _r = 0; I <= 5; I++ )
		{
			PHH[246][I-1] = (float)_itmp246[_r++];
			}
		}
		{ static double _itmp247[] = {9.68937e04,1.14485e00,3.08242e-03,
		  6.43444e-02,3.86016e-14};
		for( I=1, _r = 0; I <= 5; I++ )
		{
			PHH[247][I-1] = (float)_itmp247[_r++];
			}
		}
		{ static double _itmp248[] = {9.70653e04,1.14474e00,3.08065e-03,
		  6.42944e-02,3.85386e-14};
		for( I=1, _r = 0; I <= 5; I++ )
		{
			PHH[248][I-1] = (float)_itmp248[_r++];
			}
		}
		{ static double _itmp249[] = {9.71949e04,1.14465e00,3.07937e-03,
		  6.42618e-02,3.85276e-14};
		for( I=1, _r = 0; I <= 5; I++ )
		{
			PHH[249][I-1] = (float)_itmp249[_r++];
			}
		}
		{ static double _itmp250[] = {9.74727e04,1.14443e00,3.07107e-03,
		  6.41735e-02,3.83312e-14};
		for( I=1, _r = 0; I <= 5; I++ )
		{
			PHH[250][I-1] = (float)_itmp250[_r++];
			}
		}
		{ static double _itmp251[] = {9.77813e04,1.14427e00,3.06446e-03,
		  6.41107e-02,3.81055e-14};
		for( I=1, _r = 0; I <= 5; I++ )
		{
			PHH[251][I-1] = (float)_itmp251[_r++];
			}
		}
		{ static double _itmp252[] = {9.80282e04,1.14378e00,3.04592e-03,
		  6.38878e-02,3.79248e-14};
		for( I=1, _r = 0; I <= 5; I++ )
		{
			PHH[252][I-1] = (float)_itmp252[_r++];
			}
		}
		{ static double _itmp253[] = {9.83343e04,1.14363e00,3.04135e-03,
		  6.38269e-02,3.77052e-14};
		for( I=1, _r = 0; I <= 5; I++ )
		{
			PHH[253][I-1] = (float)_itmp253[_r++];
			}
		}
		{ static double _itmp254[] = {9.85896e04,1.14345e00,3.03740e-03,
		  6.37486e-02,3.75425e-14};
		for( I=1, _r = 0; I <= 5; I++ )
		{
			PHH[254][I-1] = (float)_itmp254[_r++];
			}
		}
		{ static double _itmp255[] = {9.87936e04,1.14322e00,3.02670e-03,
		  6.36560e-02,3.74358e-14};
		for( I=1, _r = 0; I <= 5; I++ )
		{
			PHH[255][I-1] = (float)_itmp255[_r++];
			}
		}
		{ static double _itmp256[] = {9.91176e04,1.14305e00,3.02231e-03,
		  6.35790e-02,3.71976e-14};
		for( I=1, _r = 0; I <= 5; I++ )
		{
			PHH[256][I-1] = (float)_itmp256[_r++];
			}
		}
		{ static double _itmp257[] = {9.94444e04,1.14271e00,3.00897e-03,
		  6.34309e-02,3.69463e-14};
		for( I=1, _r = 0; I <= 5; I++ )
		{
			PHH[257][I-1] = (float)_itmp257[_r++];
			}
		}
		{ static double _itmp258[] = {9.96930e04,1.14241e00,2.99691e-03,
		  6.33062e-02,3.67862e-14};
		for( I=1, _r = 0; I <= 5; I++ )
		{
			PHH[258][I-1] = (float)_itmp258[_r++];
			}
		}
		{ static double _itmp259[] = {9.99557e04,1.14230e00,2.99342e-03,
		  6.32636e-02,3.66264e-14};
		for( I=1, _r = 0; I <= 5; I++ )
		{
			PHH[259][I-1] = (float)_itmp259[_r++];
			}
		}
		{ static double _itmp260[] = {1.00226e05,1.14209e00,2.98556e-03,
		  6.31740e-02,3.64523e-14};
		for( I=1, _r = 0; I <= 5; I++ )
		{
			PHH[260][I-1] = (float)_itmp260[_r++];
			}
		}
		{ static double _itmp261[] = {1.00559e05,1.14201e00,2.98204e-03,
		  6.31493e-02,3.62206e-14};
		for( I=1, _r = 0; I <= 5; I++ )
		{
			PHH[261][I-1] = (float)_itmp261[_r++];
			}
		}
		{ static double _itmp262[] = {1.00877e05,1.14176e00,2.97389e-03,
		  6.30401e-02,3.59942e-14};
		for( I=1, _r = 0; I <= 5; I++ )
		{
			PHH[262][I-1] = (float)_itmp262[_r++];
			}
		}
		{ static double _itmp263[] = {1.01298e05,1.14139e00,2.96004e-03,
		  6.28730e-02,3.56510e-14};
		for( I=1, _r = 0; I <= 5; I++ )
		{
			PHH[263][I-1] = (float)_itmp263[_r++];
			}
		}
		{ static double _itmp264[] = {1.01553e05,1.14121e00,2.95435e-03,
		  6.27955e-02,3.55004e-14};
		for( I=1, _r = 0; I <= 5; I++ )
		{
			PHH[264][I-1] = (float)_itmp264[_r++];
			}
		}
		{ static double _itmp265[] = {1.01811e05,1.14107e00,2.95073e-03,
		  6.27426e-02,3.53516e-14};
		for( I=1, _r = 0; I <= 5; I++ )
		{
			PHH[265][I-1] = (float)_itmp265[_r++];
			}
		}
		{ static double _itmp266[] = {1.02152e05,1.14069e00,2.93733e-03,
		  6.25658e-02,3.50987e-14};
		for( I=1, _r = 0; I <= 5; I++ )
		{
			PHH[266][I-1] = (float)_itmp266[_r++];
			}
		}
		{ static double _itmp267[] = {1.02392e05,1.14052e00,2.92838e-03,
		  6.25039e-02,3.49685e-14};
		for( I=1, _r = 0; I <= 5; I++ )
		{
			PHH[267][I-1] = (float)_itmp267[_r++];
			}
		}
		{ static double _itmp268[] = {1.02798e05,1.14020e00,2.91748e-03,
		  6.23580e-02,3.46574e-14};
		for( I=1, _r = 0; I <= 5; I++ )
		{
			PHH[268][I-1] = (float)_itmp268[_r++];
			}
		}
		{ static double _itmp269[] = {1.03037e05,1.13993e00,2.90616e-03,
		  6.22441e-02,3.45226e-14};
		for( I=1, _r = 0; I <= 5; I++ )
		{
			PHH[269][I-1] = (float)_itmp269[_r++];
			}
		}
		{ static double _itmp270[] = {1.03260e05,1.13977e00,2.90035e-03,
		  6.21773e-02,3.44118e-14};
		for( I=1, _r = 0; I <= 5; I++ )
		{
			PHH[270][I-1] = (float)_itmp270[_r++];
			}
		}
}
void hpfitData5(void)
{
		{ static double _itmp271[] = {1.03571e05,1.13972e00,2.90042e-03,
		  6.21642e-02,3.42222e-14};
		for( I=1, _r = 0; I <= 5; I++ )
		{
			PHH[271][I-1] = (float)_itmp271[_r++];
			}
		}
		{ static double _itmp272[] = {1.03788e05,1.13947e00,2.89246e-03,
		  6.20533e-02,3.41121e-14};
		for( I=1, _r = 0; I <= 5; I++ )
		{
			PHH[272][I-1] = (float)_itmp272[_r++];
			}
		}
		{ static double _itmp273[] = {1.04065e05,1.13929e00,2.88545e-03,
		  6.19798e-02,3.39492e-14};
		for( I=1, _r = 0; I <= 5; I++ )
		{
			PHH[273][I-1] = (float)_itmp273[_r++];
			}
		}
		{ static double _itmp274[] = {1.04366e05,1.13882e00,2.86790e-03,
		  6.17639e-02,3.37421e-14};
		for( I=1, _r = 0; I <= 5; I++ )
		{
			PHH[274][I-1] = (float)_itmp274[_r++];
			}
		}
		{ static double _itmp275[] = {1.04670e05,1.13872e00,2.86443e-03,
		  6.17290e-02,3.35615e-14};
		for( I=1, _r = 0; I <= 5; I++ )
		{
			PHH[275][I-1] = (float)_itmp275[_r++];
			}
		}
		{ static double _itmp276[] = {1.04889e05,1.13852e00,2.85746e-03,
		  6.16407e-02,3.34543e-14};
		for( I=1, _r = 0; I <= 5; I++ )
		{
			PHH[276][I-1] = (float)_itmp276[_r++];
			}
		}
		{ static double _itmp277[] = {1.05114e05,1.13832e00,2.84916e-03,
		  6.15632e-02,3.33441e-14};
		for( I=1, _r = 0; I <= 5; I++ )
		{
			PHH[277][I-1] = (float)_itmp277[_r++];
			}
		}
		{ static double _itmp278[] = {1.05329e05,1.13825e00,2.84732e-03,
		  6.15349e-02,3.32519e-14};
		for( I=1, _r = 0; I <= 5; I++ )
		{
			PHH[278][I-1] = (float)_itmp278[_r++];
			}
		}
		{ static double _itmp279[] = {1.05553e05,1.13815e00,2.84555e-03,
		  6.14957e-02,3.31488e-14};
		for( I=1, _r = 0; I <= 5; I++ )
		{
			PHH[279][I-1] = (float)_itmp279[_r++];
			}
		}
		{ static double _itmp280[] = {1.05817e05,1.13778e00,2.83203e-03,
		  6.13320e-02,3.29906e-14};
		for( I=1, _r = 0; I <= 5; I++ )
		{
			PHH[280][I-1] = (float)_itmp280[_r++];
			}
		}
		{ static double _itmp281[] = {1.06043e05,1.13754e00,2.82361e-03,
		  6.12226e-02,3.28763e-14};
		for( I=1, _r = 0; I <= 5; I++ )
		{
			PHH[281][I-1] = (float)_itmp281[_r++];
			}
		}
		{ static double _itmp282[] = {1.06282e05,1.13739e00,2.81893e-03,
		  6.11609e-02,3.27574e-14};
		for( I=1, _r = 0; I <= 5; I++ )
		{
			PHH[282][I-1] = (float)_itmp282[_r++];
			}
		}
		{ static double _itmp283[] = {1.06474e05,1.13727e00,2.81474e-03,
		  6.11173e-02,3.26853e-14};
		for( I=1, _r = 0; I <= 5; I++ )
		{
			PHH[283][I-1] = (float)_itmp283[_r++];
			}
		}
		{ static double _itmp284[] = {1.06596e05,1.13737e00,2.81830e-03,
		  6.11813e-02,3.26931e-14};
		for( I=1, _r = 0; I <= 5; I++ )
		{
			PHH[284][I-1] = (float)_itmp284[_r++];
			}
		}
		{ static double _itmp285[] = {1.06734e05,1.13707e00,2.80941e-03,
		  6.10364e-02,3.26558e-14};
		for( I=1, _r = 0; I <= 5; I++ )
		{
			PHH[285][I-1] = (float)_itmp285[_r++];
			}
		}
		{ static double _itmp286[] = {1.06899e05,1.13691e00,2.80504e-03,
		  6.09718e-02,3.26044e-14};
		for( I=1, _r = 0; I <= 5; I++ )
		{
			PHH[286][I-1] = (float)_itmp286[_r++];
			}
		}
		{ static double _itmp287[] = {1.07094e05,1.13677e00,2.80008e-03,
		  6.09126e-02,3.25265e-14};
		for( I=1, _r = 0; I <= 5; I++ )
		{
			PHH[287][I-1] = (float)_itmp287[_r++];
			}
		}
		{ static double _itmp288[] = {1.07412e05,1.13658e00,2.79417e-03,
		  6.08281e-02,3.23350e-14};
		for( I=1, _r = 0; I <= 5; I++ )
		{
			PHH[288][I-1] = (float)_itmp288[_r++];
			}
		}
		{ static double _itmp289[] = {1.07570e05,1.13636e00,2.78581e-03,
		  6.07358e-02,3.22865e-14};
		for( I=1, _r = 0; I <= 5; I++ )
		{
			PHH[289][I-1] = (float)_itmp289[_r++];
			}
		}
		{ static double _itmp290[] = {1.07682e05,1.13628e00,2.78372e-03,
		  6.07066e-02,3.22886e-14};
		for( I=1, _r = 0; I <= 5; I++ )
		{
			PHH[290][I-1] = (float)_itmp290[_r++];
			}
		}
		{ static double _itmp291[] = {1.07850e05,1.13601e00,2.77566e-03,
		  6.05877e-02,3.22272e-14};
		for( I=1, _r = 0; I <= 5; I++ )
		{
			PHH[291][I-1] = (float)_itmp291[_r++];
			}
		}
		{ static double _itmp292[] = {1.08040e05,1.13590e00,2.77353e-03,
		  6.05401e-02,3.21560e-14};
		for( I=1, _r = 0; I <= 5; I++ )
		{
			PHH[292][I-1] = (float)_itmp292[_r++];
			}
		}
		{ static double _itmp293[] = {1.08222e05,1.13577e00,2.76748e-03,
		  6.04890e-02,3.20926e-14};
		for( I=1, _r = 0; I <= 5; I++ )
		{
			PHH[293][I-1] = (float)_itmp293[_r++];
			}
		}
		{ static double _itmp294[] = {1.08556e05,1.13579e00,2.76898e-03,
		  6.05083e-02,3.19048e-14};
		for( I=1, _r = 0; I <= 5; I++ )
		{
			PHH[294][I-1] = (float)_itmp294[_r++];
			}
		}
		{ static double _itmp295[] = {1.08761e05,1.13541e00,2.75564e-03,
		  6.03343e-02,3.18031e-14};
		for( I=1, _r = 0; I <= 5; I++ )
		{
			PHH[295][I-1] = (float)_itmp295[_r++];
			}
		}
		{ static double _itmp296[] = {1.09056e05,1.13522e00,2.74731e-03,
		  6.02573e-02,3.16373e-14};
		for( I=1, _r = 0; I <= 5; I++ )
		{
			PHH[296][I-1] = (float)_itmp296[_r++];
			}
		}
		{ static double _itmp297[] = {1.09374e05,1.13506e00,2.74255e-03,
		  6.01859e-02,3.14542e-14};
		for( I=1, _r = 0; I <= 5; I++ )
		{
			PHH[297][I-1] = (float)_itmp297[_r++];
			}
		}
		{ static double _itmp298[] = {1.09625e05,1.13502e00,2.74168e-03,
		  6.01773e-02,3.13390e-14};
		for( I=1, _r = 0; I <= 5; I++ )
		{
			PHH[298][I-1] = (float)_itmp298[_r++];
			}
		}
		{ static double _itmp299[] = {1.09865e05,1.13479e00,2.73374e-03,
		  6.00805e-02,3.12204e-14};
		for( I=1, _r = 0; I <= 5; I++ )
		{
			PHH[299][I-1] = (float)_itmp299[_r++];
			}
		}
		{ static double _itmp300[] = {1.10391e05,1.13460e00,2.72669e-03,
		  5.99970e-02,3.08649e-14};
		for( I=1, _r = 0; I <= 5; I++ )
		{
			PHH[300][I-1] = (float)_itmp300[_r++];
			}
		}
		{ static double _itmp301[] = {1.10923e05,1.13432e00,2.71520e-03,
		  5.98730e-02,3.05034e-14};
		for( I=1, _r = 0; I <= 5; I++ )
		{
			PHH[301][I-1] = (float)_itmp301[_r++];
			}
		}
		{ static double _itmp302[] = {1.11443e05,1.13406e00,2.70513e-03,
		  5.97586e-02,3.01597e-14};
		for( I=1, _r = 0; I <= 5; I++ )
		{
			PHH[302][I-1] = (float)_itmp302[_r++];
			}
		}
		{ static double _itmp303[] = {1.11933e05,1.13369e00,2.69023e-03,
		  5.95971e-02,2.98384e-14};
		for( I=1, _r = 0; I <= 5; I++ )
		{
			PHH[303][I-1] = (float)_itmp303[_r++];
			}
		}
		{ static double _itmp304[] = {1.12475e05,1.13364e00,2.68795e-03,
		  5.95804e-02,2.95013e-14};
		for( I=1, _r = 0; I <= 5; I++ )
		{
			PHH[304][I-1] = (float)_itmp304[_r++];
			}
		}
		{ static double _itmp305[] = {1.13043e05,1.13328e00,2.67371e-03,
		  5.94170e-02,2.91297e-14};
		for( I=1, _r = 0; I <= 5; I++ )
		{
			PHH[305][I-1] = (float)_itmp305[_r++];
			}
		}
		{ static double _itmp306[] = {1.13838e05,1.13282e00,2.65121e-03,
		  5.92218e-02,2.85892e-14};
		for( I=1, _r = 0; I <= 5; I++ )
		{
			PHH[306][I-1] = (float)_itmp306[_r++];
			}
		}
		{ static double _itmp307[] = {1.14312e05,1.13236e00,2.63588e-03,
		  5.90055e-02,2.82961e-14};
		for( I=1, _r = 0; I <= 5; I++ )
		{
			PHH[307][I-1] = (float)_itmp307[_r++];
			}
		}
		{ static double _itmp308[] = {1.14794e05,1.13205e00,2.62284e-03,
		  5.88698e-02,2.80115e-14};
		for( I=1, _r = 0; I <= 5; I++ )
		{
			PHH[308][I-1] = (float)_itmp308[_r++];
			}
		}
		{ static double _itmp309[] = {1.15246e05,1.13181e00,2.61594e-03,
		  5.87597e-02,2.77564e-14};
		for( I=1, _r = 0; I <= 5; I++ )
		{
			PHH[309][I-1] = (float)_itmp309[_r++];
			}
		}
		{ static double _itmp310[] = {1.15793e05,1.13141e00,2.60024e-03,
		  5.85782e-02,2.74275e-14};
		for( I=1, _r = 0; I <= 5; I++ )
		{
			PHH[310][I-1] = (float)_itmp310[_r++];
			}
		}
		{ static double _itmp311[] = {1.16300e05,1.13105e00,2.58649e-03,
		  5.84129e-02,2.71347e-14};
		for( I=1, _r = 0; I <= 5; I++ )
		{
			PHH[311][I-1] = (float)_itmp311[_r++];
			}
		}
		{ static double _itmp312[] = {1.16804e05,1.13095e00,2.58321e-03,
		  5.83762e-02,2.68636e-14};
		for( I=1, _r = 0; I <= 5; I++ )
		{
			PHH[312][I-1] = (float)_itmp312[_r++];
			}
		}
		{ static double _itmp313[] = {1.17320e05,1.13056e00,2.56602e-03,
		  5.82069e-02,2.65719e-14};
		for( I=1, _r = 0; I <= 5; I++ )
		{
			PHH[313][I-1] = (float)_itmp313[_r++];
			}
		}
		{ static double _itmp314[] = {1.17636e05,1.13059e00,2.56948e-03,
		  5.82217e-02,2.64415e-14};
		for( I=1, _r = 0; I <= 5; I++ )
		{
			PHH[314][I-1] = (float)_itmp314[_r++];
			}
		}
		{ static double _itmp315[] = {1.18050e05,1.13032e00,2.55894e-03,
		  5.81028e-02,2.62306e-14};
		for( I=1, _r = 0; I <= 5; I++ )
		{
			PHH[315][I-1] = (float)_itmp315[_r++];
			}
		}
		{ static double _itmp316[] = {1.18894e05,1.12981e00,2.53744e-03,
		  5.78760e-02,2.57281e-14};
		for( I=1, _r = 0; I <= 5; I++ )
		{
			PHH[316][I-1] = (float)_itmp316[_r++];
			}
		}
		{ static double _itmp317[] = {1.19150e05,1.12967e00,2.53270e-03,
		  5.78189e-02,2.56337e-14};
		for( I=1, _r = 0; I <= 5; I++ )
		{
			PHH[317][I-1] = (float)_itmp317[_r++];
			}
		}
		{ static double _itmp318[] = {1.19556e05,1.12962e00,2.53230e-03,
		  5.77995e-02,2.54488e-14};
		for( I=1, _r = 0; I <= 5; I++ )
		{
			PHH[318][I-1] = (float)_itmp318[_r++];
			}
		}
		{ static double _itmp319[] = {1.19972e05,1.12914e00,2.51319e-03,
		  5.75804e-02,2.52355e-14};
		for( I=1, _r = 0; I <= 5; I++ )
		{
			PHH[319][I-1] = (float)_itmp319[_r++];
			}
		}
		{ static double _itmp320[] = {1.20318e05,1.12868e00,2.49798e-03,
		  5.73674e-02,2.50694e-14};
		for( I=1, _r = 0; I <= 5; I++ )
		{
			PHH[320][I-1] = (float)_itmp320[_r++];
			}
		}
		{ static double _itmp321[] = {1.20800e05,1.12863e00,2.49572e-03,
		  5.73535e-02,2.48435e-14};
		for( I=1, _r = 0; I <= 5; I++ )
		{
			PHH[321][I-1] = (float)_itmp321[_r++];
			}
		}
		{ static double _itmp322[] = {1.21051e05,1.12890e00,2.50617e-03,
		  5.74894e-02,2.47794e-14};
		for( I=1, _r = 0; I <= 5; I++ )
		{
			PHH[322][I-1] = (float)_itmp322[_r++];
			}
		}
		{ static double _itmp323[] = {1.22186e05,1.12812e00,2.47567e-03,
		  5.71245e-02,2.41275e-14};
		for( I=1, _r = 0; I <= 5; I++ )
		{
			PHH[323][I-1] = (float)_itmp323[_r++];
			}
		}
		{ static double _itmp324[] = {1.22462e05,1.12820e00,2.47849e-03,
		  5.71775e-02,2.40426e-14};
		for( I=1, _r = 0; I <= 5; I++ )
		{
			PHH[324][I-1] = (float)_itmp324[_r++];
			}
		}
}
void hpfitData6(void)
{
		{ static double _itmp325[] = {1.22787e05,1.12778e00,2.46255e-03,
		  5.69852e-02,2.39018e-14};
		for( I=1, _r = 0; I <= 5; I++ )
		{
			PHH[325][I-1] = (float)_itmp325[_r++];
			}
		}
		{ static double _itmp326[] = {1.23194e05,1.12772e00,2.46152e-03,
		  5.69624e-02,2.37334e-14};
		for( I=1, _r = 0; I <= 5; I++ )
		{
			PHH[326][I-1] = (float)_itmp326[_r++];
			}
		}
		{ static double _itmp327[] = {1.23605e05,1.12738e00,2.44892e-03,
		  5.68079e-02,2.35501e-14};
		for( I=1, _r = 0; I <= 5; I++ )
		{
			PHH[327][I-1] = (float)_itmp327[_r++];
			}
		}
		{ static double _itmp328[] = {1.23996e05,1.12716e00,2.44139e-03,
		  5.67088e-02,2.33863e-14};
		for( I=1, _r = 0; I <= 5; I++ )
		{
			PHH[328][I-1] = (float)_itmp328[_r++];
			}
		}
		{ static double _itmp329[] = {1.24428e05,1.12704e00,2.43702e-03,
		  5.66622e-02,2.32064e-14};
		for( I=1, _r = 0; I <= 5; I++ )
		{
			PHH[329][I-1] = (float)_itmp329[_r++];
			}
		}
		{ static double _itmp330[] = {1.24798e05,1.12680e00,2.42883e-03,
		  5.65549e-02,2.30569e-14};
		for( I=1, _r = 0; I <= 5; I++ )
		{
			PHH[330][I-1] = (float)_itmp330[_r++];
			}
		}
		{ static double _itmp331[] = {1.25153e05,1.12656e00,2.42021e-03,
		  5.64523e-02,2.29168e-14};
		for( I=1, _r = 0; I <= 5; I++ )
		{
			PHH[331][I-1] = (float)_itmp331[_r++];
			}
		}
		{ static double _itmp332[] = {1.25678e05,1.12620e00,2.40622e-03,
		  5.62834e-02,2.26796e-14};
		for( I=1, _r = 0; I <= 5; I++ )
		{
			PHH[332][I-1] = (float)_itmp332[_r++];
			}
		}
		{ static double _itmp333[] = {1.26128e05,1.12597e00,2.39694e-03,
		  5.61878e-02,2.24925e-14};
		for( I=1, _r = 0; I <= 5; I++ )
		{
			PHH[333][I-1] = (float)_itmp333[_r++];
			}
		}
		{ static double _itmp334[] = {1.27072e05,1.12567e00,2.38534e-03,
		  5.60563e-02,2.20459e-14};
		for( I=1, _r = 0; I <= 5; I++ )
		{
			PHH[334][I-1] = (float)_itmp334[_r++];
			}
		}
		{ static double _itmp335[] = {1.27564e05,1.12562e00,2.38133e-03,
		  5.60437e-02,2.18532e-14};
		for( I=1, _r = 0; I <= 5; I++ )
		{
			PHH[335][I-1] = (float)_itmp335[_r++];
			}
		}
		{ static double _itmp336[] = {1.28374e05,1.12534e00,2.37096e-03,
		  5.59177e-02,2.14923e-14};
		for( I=1, _r = 0; I <= 5; I++ )
		{
			PHH[336][I-1] = (float)_itmp336[_r++];
			}
		}
		{ static double _itmp337[] = {1.29717e05,1.12455e00,2.34079e-03,
		  5.55498e-02,2.08563e-14};
		for( I=1, _r = 0; I <= 5; I++ )
		{
			PHH[337][I-1] = (float)_itmp337[_r++];
			}
		}
		{ static double _itmp338[] = {1.30155e05,1.12440e00,2.33443e-03,
		  5.54879e-02,2.06993e-14};
		for( I=1, _r = 0; I <= 5; I++ )
		{
			PHH[338][I-1] = (float)_itmp338[_r++];
			}
		}
		{ static double _itmp339[] = {1.30404e05,1.12429e00,2.33039e-03,
		  5.54440e-02,2.06357e-14};
		for( I=1, _r = 0; I <= 5; I++ )
		{
			PHH[339][I-1] = (float)_itmp339[_r++];
			}
		}
		{ static double _itmp340[] = {1.30812e05,1.12419e00,2.32702e-03,
		  5.54081e-02,2.04981e-14};
		for( I=1, _r = 0; I <= 5; I++ )
		{
			PHH[340][I-1] = (float)_itmp340[_r++];
			}
		}
		{ static double _itmp341[] = {1.31503e05,1.12394e00,2.31799e-03,
		  5.52939e-02,2.02235e-14};
		for( I=1, _r = 0; I <= 5; I++ )
		{
			PHH[341][I-1] = (float)_itmp341[_r++];
			}
		}
		{ static double _itmp342[] = {1.34111e05,1.12274e00,2.26943e-03,
		  5.47373e-02,1.90725e-14};
		for( I=1, _r = 0; I <= 5; I++ )
		{
			PHH[342][I-1] = (float)_itmp342[_r++];
			}
		}
		{ static double _itmp343[] = {1.34519e05,1.12263e00,2.26467e-03,
		  5.46931e-02,1.89491e-14};
		for( I=1, _r = 0; I <= 5; I++ )
		{
			PHH[343][I-1] = (float)_itmp343[_r++];
			}
		}
		{ static double _itmp344[] = {1.34850e05,1.12250e00,2.26020e-03,
		  5.46412e-02,1.88579e-14};
		for( I=1, _r = 0; I <= 5; I++ )
		{
			PHH[344][I-1] = (float)_itmp344[_r++];
			}
		}
		{ static double _itmp345[] = {1.35145e05,1.12245e00,2.25984e-03,
		  5.46190e-02,1.87852e-14};
		for( I=1, _r = 0; I <= 5; I++ )
		{
			PHH[345][I-1] = (float)_itmp345[_r++];
			}
		}
		{ static double _itmp346[] = {1.35648e05,1.12207e00,2.24688e-03,
		  5.44442e-02,1.86139e-14};
		for( I=1, _r = 0; I <= 5; I++ )
		{
			PHH[346][I-1] = (float)_itmp346[_r++];
			}
		}
		{ static double _itmp347[] = {1.36053e05,1.12216e00,2.25029e-03,
		  5.44993e-02,1.85041e-14};
		for( I=1, _r = 0; I <= 5; I++ )
		{
			PHH[347][I-1] = (float)_itmp347[_r++];
			}
		}
		{ static double _itmp348[] = {1.36537e05,1.12178e00,2.23575e-03,
		  5.43243e-02,1.83440e-14};
		for( I=1, _r = 0; I <= 5; I++ )
		{
			PHH[348][I-1] = (float)_itmp348[_r++];
			}
		}
		{ static double _itmp349[] = {1.36946e05,1.12172e00,2.23520e-03,
		  5.42987e-02,1.82286e-14};
		for( I=1, _r = 0; I <= 5; I++ )
		{
			PHH[349][I-1] = (float)_itmp349[_r++];
			}
		}
		{ static double _itmp350[] = {1.37256e05,1.12130e00,2.21984e-03,
		  5.41103e-02,1.81388e-14};
		for( I=1, _r = 0; I <= 5; I++ )
		{
			PHH[350][I-1] = (float)_itmp350[_r++];
			}
		}
		{ static double _itmp351[] = {1.37738e05,1.12120e00,2.21614e-03,
		  5.40724e-02,1.79956e-14};
		for( I=1, _r = 0; I <= 5; I++ )
		{
			PHH[351][I-1] = (float)_itmp351[_r++];
			}
		}
		{ static double _itmp352[] = {1.38100e05,1.12094e00,2.20859e-03,
		  5.39509e-02,1.78931e-14};
		for( I=1, _r = 0; I <= 5; I++ )
		{
			PHH[352][I-1] = (float)_itmp352[_r++];
			}
		}
		{ static double _itmp353[] = {1.38570e05,1.12082e00,2.20585e-03,
		  5.38944e-02,1.77558e-14};
		for( I=1, _r = 0; I <= 5; I++ )
		{
			PHH[353][I-1] = (float)_itmp353[_r++];
			}
		}
		{ static double _itmp354[] = {1.39081e05,1.12049e00,2.19167e-03,
		  5.37511e-02,1.75969e-14};
		for( I=1, _r = 0; I <= 5; I++ )
		{
			PHH[354][I-1] = (float)_itmp354[_r++];
			}
		}
		{ static double _itmp355[] = {1.39724e05,1.12050e00,2.19337e-03,
		  5.37621e-02,1.74034e-14};
		for( I=1, _r = 0; I <= 5; I++ )
		{
			PHH[355][I-1] = (float)_itmp355[_r++];
			}
		}
		{ static double _itmp356[] = {1.40171e05,1.12010e00,2.17775e-03,
		  5.35842e-02,1.72697e-14};
		for( I=1, _r = 0; I <= 5; I++ )
		{
			PHH[356][I-1] = (float)_itmp356[_r++];
			}
		}
		{ static double _itmp357[] = {1.40632e05,1.11991e00,2.17210e-03,
		  5.34985e-02,1.71400e-14};
		for( I=1, _r = 0; I <= 5; I++ )
		{
			PHH[357][I-1] = (float)_itmp357[_r++];
			}
		}
		{ static double _itmp358[] = {1.41091e05,1.11980e00,2.16751e-03,
		  5.34529e-02,1.70155e-14};
		for( I=1, _r = 0; I <= 5; I++ )
		{
			PHH[358][I-1] = (float)_itmp358[_r++];
			}
		}
		{ static double _itmp359[] = {1.41495e05,1.11962e00,2.16063e-03,
		  5.33793e-02,1.69096e-14};
		for( I=1, _r = 0; I <= 5; I++ )
		{
			PHH[359][I-1] = (float)_itmp359[_r++];
			}
		}
		{ static double _itmp360[] = {1.41895e05,1.11942e00,2.15418e-03,
		  5.32886e-02,1.68048e-14};
		for( I=1, _r = 0; I <= 5; I++ )
		{
			PHH[360][I-1] = (float)_itmp360[_r++];
			}
		}
		{ static double _itmp361[] = {1.42355e05,1.11912e00,2.14449e-03,
		  5.31519e-02,1.66763e-14};
		for( I=1, _r = 0; I <= 5; I++ )
		{
			PHH[361][I-1] = (float)_itmp361[_r++];
			}
		}
		{ static double _itmp362[] = {1.42738e05,1.11907e00,2.14452e-03,
		  5.31304e-02,1.65852e-14};
		for( I=1, _r = 0; I <= 5; I++ )
		{
			PHH[362][I-1] = (float)_itmp362[_r++];
			}
		}
		{ static double _itmp363[] = {1.43087e05,1.11871e00,2.13168e-03,
		  5.29652e-02,1.64951e-14};
		for( I=1, _r = 0; I <= 5; I++ )
		{
			PHH[363][I-1] = (float)_itmp363[_r++];
			}
		}
		{ static double _itmp364[] = {1.43572e05,1.11863e00,2.12866e-03,
		  5.29320e-02,1.63693e-14};
		for( I=1, _r = 0; I <= 5; I++ )
		{
			PHH[364][I-1] = (float)_itmp364[_r++];
			}
		}
		{ static double _itmp365[] = {1.43948e05,1.11845e00,2.12316e-03,
		  5.28519e-02,1.62782e-14};
		for( I=1, _r = 0; I <= 5; I++ )
		{
			PHH[365][I-1] = (float)_itmp365[_r++];
			}
		}
		{ static double _itmp366[] = {1.44374e05,1.11823e00,2.11590e-03,
		  5.27563e-02,1.61697e-14};
		for( I=1, _r = 0; I <= 5; I++ )
		{
			PHH[366][I-1] = (float)_itmp366[_r++];
			}
		}
		{ static double _itmp367[] = {1.44863e05,1.11800e00,2.10719e-03,
		  5.26528e-02,1.60406e-14};
		for( I=1, _r = 0; I <= 5; I++ )
		{
			PHH[367][I-1] = (float)_itmp367[_r++];
			}
		}
		{ static double _itmp368[] = {1.45510e05,1.11776e00,2.09977e-03,
		  5.25456e-02,1.58617e-14};
		for( I=1, _r = 0; I <= 5; I++ )
		{
			PHH[368][I-1] = (float)_itmp368[_r++];
			}
		}
		{ static double _itmp369[] = {1.45835e05,1.11765e00,2.09649e-03,
		  5.24969e-02,1.57934e-14};
		for( I=1, _r = 0; I <= 5; I++ )
		{
			PHH[369][I-1] = (float)_itmp369[_r++];
			}
		}
		{ static double _itmp370[] = {1.46277e05,1.11749e00,2.09060e-03,
		  5.24318e-02,1.56865e-14};
		for( I=1, _r = 0; I <= 5; I++ )
		{
			PHH[370][I-1] = (float)_itmp370[_r++];
			}
		}
		{ static double _itmp371[] = {1.46650e05,1.11735e00,2.08680e-03,
		  5.23694e-02,1.56032e-14};
		for( I=1, _r = 0; I <= 5; I++ )
		{
			PHH[371][I-1] = (float)_itmp371[_r++];
			}
		}
		{ static double _itmp372[] = {1.46936e05,1.11707e00,2.07555e-03,
		  5.22466e-02,1.55434e-14};
		for( I=1, _r = 0; I <= 5; I++ )
		{
			PHH[372][I-1] = (float)_itmp372[_r++];
			}
		}
}
void hpfitData7(void)
{
		{ static double _itmp373[] = {1.47259e05,1.11709e00,2.07759e-03,
		  5.22580e-02,1.54823e-14};
		for( I=1, _r = 0; I <= 5; I++ )
		{
			PHH[373][I-1] = (float)_itmp373[_r++];
			}
		}
		{ static double _itmp374[] = {1.47727e05,1.11685e00,2.07066e-03,
		  5.21501e-02,1.53672e-14};
		for( I=1, _r = 0; I <= 5; I++ )
		{
			PHH[374][I-1] = (float)_itmp374[_r++];
			}
		}
		{ static double _itmp375[] = {1.47876e05,1.11688e00,2.07234e-03,
		  5.21669e-02,1.53618e-14};
		for( I=1, _r = 0; I <= 5; I++ )
		{
			PHH[375][I-1] = (float)_itmp375[_r++];
			}
		}
		{ static double _itmp376[] = {1.48024e05,1.11674e00,2.06766e-03,
		  5.21101e-02,1.53509e-14};
		for( I=1, _r = 0; I <= 5; I++ )
		{
			PHH[376][I-1] = (float)_itmp376[_r++];
			}
		}
		{ static double _itmp377[] = {1.48008e05,1.11660e00,2.06369e-03,
		  5.20502e-02,1.53905e-14};
		for( I=1, _r = 0; I <= 5; I++ )
		{
			PHH[377][I-1] = (float)_itmp377[_r++];
			}
		}
		{ static double _itmp378[] = {1.48445e05,1.11638e00,2.05683e-03,
		  5.19494e-02,1.52867e-14};
		for( I=1, _r = 0; I <= 5; I++ )
		{
			PHH[378][I-1] = (float)_itmp378[_r++];
			}
		}
		{ static double _itmp379[] = {1.48997e05,1.11631e00,2.05437e-03,
		  5.19214e-02,1.51541e-14};
		for( I=1, _r = 0; I <= 5; I++ )
		{
			PHH[379][I-1] = (float)_itmp379[_r++];
			}
		}
		{ static double _itmp380[] = {1.49371e05,1.11605e00,2.04432e-03,
		  5.18076e-02,1.50704e-14};
		for( I=1, _r = 0; I <= 5; I++ )
		{
			PHH[380][I-1] = (float)_itmp380[_r++];
			}
		}
		{ static double _itmp381[] = {1.49654e05,1.11597e00,2.04379e-03,
		  5.17688e-02,1.50204e-14};
		for( I=1, _r = 0; I <= 5; I++ )
		{
			PHH[381][I-1] = (float)_itmp381[_r++];
			}
		}
		{ static double _itmp382[] = {1.49904e05,1.11588e00,2.03935e-03,
		  5.17409e-02,1.49810e-14};
		for( I=1, _r = 0; I <= 5; I++ )
		{
			PHH[382][I-1] = (float)_itmp382[_r++];
			}
		}
		{ static double _itmp383[] = {1.50161e05,1.11571e00,2.03535e-03,
		  5.16593e-02,1.49361e-14};
		for( I=1, _r = 0; I <= 5; I++ )
		{
			PHH[383][I-1] = (float)_itmp383[_r++];
			}
		}
		{ static double _itmp384[] = {1.50455e05,1.11566e00,2.03475e-03,
		  5.16429e-02,1.48849e-14};
		for( I=1, _r = 0; I <= 5; I++ )
		{
			PHH[384][I-1] = (float)_itmp384[_r++];
			}
		}
		{ static double _itmp385[] = {1.50242e05,1.11567e00,2.03502e-03,
		  5.16517e-02,1.49861e-14};
		for( I=1, _r = 0; I <= 5; I++ )
		{
			PHH[385][I-1] = (float)_itmp385[_r++];
			}
		}
		{ static double _itmp386[] = {1.50182e05,1.11556e00,2.03282e-03,
		  5.16038e-02,1.50379e-14};
		for( I=1, _r = 0; I <= 5; I++ )
		{
			PHH[386][I-1] = (float)_itmp386[_r++];
			}
		}
		{ static double _itmp387[] = {1.50448e05,1.11538e00,2.02829e-03,
		  5.15247e-02,1.49901e-14};
		for( I=1, _r = 0; I <= 5; I++ )
		{
			PHH[387][I-1] = (float)_itmp387[_r++];
			}
		}
		{ static double _itmp388[] = {1.50704e05,1.11536e00,2.02832e-03,
		  5.15188e-02,1.49505e-14};
		for( I=1, _r = 0; I <= 5; I++ )
		{
			PHH[388][I-1] = (float)_itmp388[_r++];
			}
		}
		{ static double _itmp389[] = {1.50917e05,1.11531e00,2.02629e-03,
		  5.15064e-02,1.49232e-14};
		for( I=1, _r = 0; I <= 5; I++ )
		{
			PHH[389][I-1] = (float)_itmp389[_r++];
			}
		}
		{ static double _itmp390[] = {1.51058e05,1.11514e00,2.02148e-03,
		  5.14281e-02,1.49126e-14};
		for( I=1, _r = 0; I <= 5; I++ )
		{
			PHH[390][I-1] = (float)_itmp390[_r++];
			}
		}
		{ static double _itmp391[] = {1.51638e05,1.11496e00,2.01559e-03,
		  5.13484e-02,1.47731e-14};
		for( I=1, _r = 0; I <= 5; I++ )
		{
			PHH[391][I-1] = (float)_itmp391[_r++];
			}
		}
		{ static double _itmp392[] = {1.52054e05,1.11489e00,2.01387e-03,
		  5.13197e-02,1.46865e-14};
		for( I=1, _r = 0; I <= 5; I++ )
		{
			PHH[392][I-1] = (float)_itmp392[_r++];
			}
		}
		{ static double _itmp393[] = {1.52426e05,1.11462e00,2.00420e-03,
		  5.11978e-02,1.46066e-14};
		for( I=1, _r = 0; I <= 5; I++ )
		{
			PHH[393][I-1] = (float)_itmp393[_r++];
			}
		}
		{ static double _itmp394[] = {1.52788e05,1.11463e00,2.00531e-03,
		  5.12052e-02,1.45392e-14};
		for( I=1, _r = 0; I <= 5; I++ )
		{
			PHH[394][I-1] = (float)_itmp394[_r++];
			}
		}
		{ static double _itmp395[] = {1.53097e05,1.11446e00,1.99936e-03,
		  5.11318e-02,1.44815e-14};
		for( I=1, _r = 0; I <= 5; I++ )
		{
			PHH[395][I-1] = (float)_itmp395[_r++];
			}
		}
		{ static double _itmp396[] = {1.53416e05,1.11434e00,1.99526e-03,
		  5.10830e-02,1.44231e-14};
		for( I=1, _r = 0; I <= 5; I++ )
		{
			PHH[396][I-1] = (float)_itmp396[_r++];
			}
		}
		{ static double _itmp397[] = {1.53650e05,1.11430e00,1.99430e-03,
		  5.10689e-02,1.43914e-14};
		for( I=1, _r = 0; I <= 5; I++ )
		{
			PHH[397][I-1] = (float)_itmp397[_r++];
			}
		}
		{ static double _itmp398[] = {1.54003e05,1.11402e00,1.98569e-03,
		  5.09380e-02,1.43181e-14};
		for( I=1, _r = 0; I <= 5; I++ )
		{
			PHH[398][I-1] = (float)_itmp398[_r++];
			}
		}
		{ static double _itmp399[] = {1.54267e05,1.11390e00,1.98162e-03,
		  5.08885e-02,1.42757e-14};
		for( I=1, _r = 0; I <= 5; I++ )
		{
			PHH[399][I-1] = (float)_itmp399[_r++];
			}
		}
		{ static double _itmp400[] = {1.54505e05,1.11395e00,1.98405e-03,
		  5.09196e-02,1.42465e-14};
		for( I=1, _r = 0; I <= 5; I++ )
		{
			PHH[400][I-1] = (float)_itmp400[_r++];
			}
		}

#	ifdef DEBUG_FUN
	fputs( "<+>blkdata0()\n", debug_fp );
#	endif
	/*block data for hydrogen atom photoionization cross sections */

#	ifdef DEBUG_FUN
	fputs( " <->blkdata0()\n", debug_fp );
#	endif
}

