/* hmi.h - parameters dealing with hydrogem molecules */
EXTERN struct t_hmi {

	/* densities (cm-3) of H2, H2+, H-, H3+ */
	float htwo, 
	  h2plus, 
	  hminus, 
	  h3plus;

	/* population of vib-excited H2 */
	float htwo_star;

	/* hminus heating, free bound */
	double hmihet, 
	  hmitot, 
	  hmicol;

	/* mean cross section (cm-2) for H2 Lyman absorption */
	float H2Opacity;

	/* these are departure coef for H-, H2, H2+, and HeH,
	 * defined in hmole */
	double hmidep, 
	  h2dep, 
	  h2pdep, 
	  h3pdep;

	/* the lte population of H2  */
	double ph2lte;

	/* H- photo dissoc rate */
	double HMinus_photo_rate;

	/* HeatH2Dish is heating due to H2 dissociation */
	float HeatH2Dish, 
	  /* HeatH2Dexc is heating due to collisional deexcitation of vib-excited H2 */
	  HeatH2Dexc,
	  /* the largest fraction of total heat anywhere in model */
	  HeatH2DexcMax,
	  h2dfrc, 
	  h2dtot,
	/* fraqction of cooling carried by H2 lines */
	  h2line_cool_frac;

	float hehp;
	long int iheh1, 
	  iheh2;

	/* rate hi dest H_2 */
	float rh2dis;

	/* Ha creation due to H- charge transfer */
	float HalphaHmin;

	}	hmi;

