/* following two macros used to define recombination coef arrays */
/* Max n desired in RRCoef file.	*/
/* >>chng 02 jan 28, from 10 to 20 so large HeI tests are fast */
/* this is the number of levels used with the
 * atom he-like levels large command */
#define HE_RREC_MAXN		20
/* the number of levels that will be done */
#define N_HE_LEV_RECOMB		( ( 1 + HE_RREC_MAXN ) * HE_RREC_MAXN + 1 )

/* He-like main routine to call HeLevel and determine 
 * model he-like species atom level balance	*/
void HeLike(void);

/* create he-like series */
void HeCreate(void);

/* routine to print departure coefficients for he-like species */
void prt_He_like_DeparCoef(long int nelem );

/* routine to print level pops for he-like species */
void prt_He_like_Pops(long int nelem );

/* Calculate "EnergyWN" for 4 autoionizing levels of each
 * "turned-on" element.	*/
void He1Autoionize(void);

/*HelikeCheckRecomb - called by SanityCheck to confirm that recombination coef are ok,
 * return value is relative error between new calculation of recom, and interp value */
double HelikeCheckRecomb(
	/* the chemical element, 1 for He */
	long nelem ,
	/* the level, 0 for ground */
	long level ,
	/* the temperature to be used */
	double temperature );

/* routine to punch table needed for AGN3 - collision strengths of HeI */
void AGN_He1_CS( FILE *ioPun );

/*He_cross_section returns cross section (cm^-2), 
 * given EgammaRyd, the photon energy in Ryd,
 * ipLevel, the index of the level, 0 is ground, 3 within 2 3P,
 * ipZ is charge, equal to 1 for Helium,
 * this is a wrapper for cross_section */
double He_cross_section( double EgammaRyd , long ipLevel , long ipZ );

/* REMOVED he_assign, correct, ritoa,	*/
/* and the definition of type Elevels.	*/ 				

/* all of these are initialized in zero */
EXTERN struct t_helike 
{

	/* ionization fractions
	float HeIonSimple[LIMELM]; */

	/* the designation of the levels, chLevel[n][string] */
	char **chLevel;

	/* flag saying whether to make up collision strenths for
	 * transitions with no calculations - default is 1, set to
	 * zero with ATOM HE-LIKE COLLISIONS FAKE command */
	int lgFakeCS;

	/* number of CS in the above array */
	long int nCS;

	/* ratio of ratio of other to total opacities continuous opacity */
	/* 1 says that self abs by this species is not important, so when
	 * optically thick, still counts as recombination since absorbed by something else
	float **HeOpacRatio;*/

	/* Hy2nu is hydrogen two photon, others He1 and He2 */
	 float *he12nu/*[NC_ELL]*/;

	 /* this is the rate for the Aul given to bogus transitions,
	  * set to 1e-20 in zero */
	 float SmallA;

	 /* flag set by compile he-like command, says to regenerate table of recombination coef */
	 int lgCompileRecomb;

}	helike;
