/* grainvar.h */



/* NB NB NB NB NB NB NB NB NB NB NB NB NB NB NB NB NB
 *
 * removing the next definition will delete all code that only pertains to old style grains
 *
 * NB NB NB NB NB NB NB NB NB NB NB NB NB NB NB NB NB */

#define INCLUDE_OLD_GRAINS 1



/* NB NB NB NB NB NB NB NB NB NB NB NB NB NB NB NB NB
 *
 * uncommenting the following definition will cause the ParseAbundances routine to use new style
 * grains by default. ONLY NEEDED WHEN OLD STYLE GRAINS ARE STILL INCLUDED THROUGH THE OGRAINS COMMAND.
 *
 * NB NB NB NB NB NB NB NB NB NB NB NB NB NB NB NB NB */

/* #define SWITCH_OLD_GRAINS 1 */



#ifdef INCLUDE_OLD_GRAINS
/* limit to numbers of cross sections for OLD STYLE grain opacity arrays */
#define	LIMCRS	260L
/* number of old style grain species */
#define	NDOLD	11L
#endif

/* number of grid points for which grain emissivity is evaluated in InitEmissivities */
#define	NDEMS	200L

/* these are used for setting up grain emissivities in InitEmissivities() */
#define GRAIN_TMIN 1.e-3
#define GRAIN_TMID 5.e3
#define GRAIN_TMAX 1.2e9

/* maximum number of grain bins that can be allocated */
#define	NDUST	500L

/* maximum number of discrete grain charges that can be used in charge distribution */
#define NCHS    5L
/* default number of charge states to be used */
#define NCHRG_DEFAULT 2L

/* maximum size of temperature grid for quantum heating routine */
#define	NQGRID	10000L

/* these two constants define the initial/minimum (natural) logarithmic
 * stepsize for probability density in quantum heating calculations.
 * the current value is kept in GrainVar.qpres[nd], the default is set in StartIter */
#define QHEAT_INIT_RES 1.
#define QHEAT_HIGH_RES 0.075

/* all grains should conserve charge and energy to within this precision */
#define CONSERV_TOL 1.e-3

/* the following constants are used to define the material type for the enthalpy function */
/* carbonaceous materials: graphite, amorphous carbon, PAH's, ... */
#define MAT_CAR 1L
/* silicates: astronomical silicate, olivine, fosterite, ... */
#define MAT_SIL 2L

/* NB NB NB: keep this constant equal to the highest value in the previous definitions */
#define MAT_TOP 2L

/* maximum number of filenames that mie_read_opc can store */
#define MAX_READ_RECORDS 50L
/* NB NB -- keep this equal to DATA_PATH_LENGTH */
#define READ_RECORD_LENGTH 200L

/* NB NB NB NB NB NB
 *
 * this is the data structure for all grain data that depends on grain type
 * (i.e. all data that used to have an [NDUST] dependance in days of old),
 *
 * each data item will be referenced as:   gv.bin[nd]->data_item
 *
 * this structure is allocated for each grain bin at run time.
 *
 * Data items that are generic for all grain types, or are summed over all
 * grain types, should go in gv below !!
 *
 * NB NB NB NB NB NB */

typedef struct {

	/* grain logic */
	int lgDustVary;         /* does grain abundance vary with radius ? */
#ifdef INCLUDE_OLD_GRAINS
	int lgDustOn1;          /* is this particular grain type switched on ? WILL BECOME OBSOLETE */
	int lgOldGrain1;        /* this is an old style grain bin, WILL BECOME OBSOLETE */
#endif

	/* general information on the grains */
	char chDstLab[13];      /* label for the species */
	float dustp[5],         /* 0 = specific weight (g/cm^3), 1 = mol. weight (amu), 2 = default abundance,
				 * 3 = default depletion, 4 = fraction of the mass in this grain bin */
	  AvRadius,             /* average grain radius, <a^3>/<a^2>, in cm */
	  AvArea,               /* average grain surface area, <4pi*a^2>, in cm^2, CURRENTLY NOT USED */
	  AvVol,                /* average grain volume, <4/3pi*a^3>, in cm^3 */
	  IntRadius,            /* integrated grain radius Int(a), normalized per H, in cm/H */
	  IntArea,              /* integrated grain surface area Int(4pi*a^2), normalized per H, in cm^2/H */
	  IntVol,               /* integrated grain volume Int(4/3pi*a^3), normalized per H, in cm^3/H */
	  elmAbund[LIMELM],     /* chemical composition, abundance at default depl, see comment below */ 
	  atomWeight,           /* molecular weight per atom, in amu */
	  Tsublimat,            /* sublimation temperature */
	  DustWorkFcn,          /* work function, in Ryd */
	  BandGap,              /* gap between valence and conduction band, in Ryd */
	  ThermEff,             /* efficiency of thermionic emission, between 0 and 1 */
	  avDGRatio;            /* Integral(D/G*dReff) for average dust to gas ratio, OUTPUT ONLY */
	long matType;           /* material type, determines enthalpy function, 1 = carbonaceous, 2 = silicate */

	/* chemical abundances of grains in elmAbund are defined as follows:
	 * e.g. for MgSiFeO4 the oxygen abundance would be given by
	 *    elmAbund[nd][7] = 4.*dustp[nd][2]*dustp[nd][3]*dustp[nd][4] */
	/* chemical abundances of grains are normalized such that in any given zone
	 * the total fractional abundance of an element Z locked up in grains is given by
	 *    SumFracAbund(ipZ) = Sum_over_nd ( gv.bin[nd]->elmAbund[ipZ]*gv.dstAbund[nd] ) */

	/* grain depletion, normalization conversion factors */
	float dstfactor,        /* grain depletion factor, dep from GRAINS command, dep*GrainMetal */
	  dstAbund;             /* grain abundance in zone, dstfactor*GrnVryDpth(radius) */
	double cnv_H_pGR,       /* grain unit conversion, <unit>/H (default depl) -> <unit>/grain */
	  cnv_H_pCM3,           /* grain unit conversion, <unit>/H (default depl) -> <unit>/cm^3 (actual depl) */
	  cnv_CM3_pGR,          /* grain unit conversion, <unit>/cm^3 (actual depl) -> <unit>/grain */
	  cnv_CM3_pH,           /* grain unit conversion, <unit>/cm^3 (actual depl) -> <unit>/H (default depl) */
	  cnv_GR_pH,            /* grain unit conversion, <unit>/grain -> <unit>/H (default depl) */
	  cnv_GR_pCM3;          /* grain unit conversion, <unit>/grain -> <unit>/cm^3 (actual depl) */

	/* grain opacities */
#ifdef INCLUDE_OLD_GRAINS
	float eev[LIMCRS],      /* energy grid, OLD STYLE COMMON BLOCKS */
	  sab[LIMCRS],          /* absorption cs, OLD STYLE COMMON BLOCKS */
	  sse[LIMCRS];          /* scattering cs, OLD STYLE COMMON BLOCKS */
	long int ndpts;         /* no. of points in grid, OLD STYLE COMMON BLOCKS */
#endif
	float EnergyCheck;      /* save highest energy read in for later check, NEW STYLE GRAINS ONLY */
	long int NFPCheck;      /* save number of grid points read for later check, NEW STYLE GRAINS ONLY */

	double *dstab1/*[NC_ELL]*/, /* absorption cross section per grain species, for default depl */
	  *dstsc1/*[NC_ELL]*/;      /* scattering cross section per grain species, for default depl */

	/* equilibrium temperature */
	double dstems[NDEMS],   /* grain emissivity at dsttmp[], default depl, normalized per H */
	  dstslp[NDEMS],        /* auxiliary array for spline interpolation */
	  dstslp2[NDEMS];       /* auxiliary array for inverse spline interpolation */
	  
	float tedust,           /* equilibrium temperature for this zone */
	  TeGrainMax,           /* highest equilibrium temperature as a function of radius */
	  avdust;               /* Integral(Tdust*dReff) for average equilibrium temperature, OUTPUT ONLY */

	/* grain charging, photoelectric effect, thermionic emissions
	 *
	 * all charge and energy rates will be calculated by resolving the charge distribution into nChrg
	 * integral charge states. To implement this, certain parameters have dimension NCHS, currently
	 * limiting the maximum number of charge states the code can handle. For full details see:
	 * >>refer van Hoof et al., 2001, ASP Conf. Series XXX, p. XXX (astroph/0107183) */
	int lgChrgConverged;    /* did grain charge algorithm converge ? */
	long DustZ[NCHS],       /* grain charge, in e */
	  LowestZg,             /* lowest charge a grain can ever have, in e */
	  nChrg,                /* number of charge states used for this grain bin */
	  ipThresInf[NCHS],     /* pointer to ThresInf in anu array */
	  ipThresInfVal[NCHS];  /* pointer to ThresInfVal in anu array */
	double AveDustZ,        /* average grain charge, in e */
	  Capacity,             /* grain capacity, in Farad/grain */
	  dstpot,               /* grain potential in Ryd */
	  dstpotsav,            /* grain potential at start of iteration */
	  FracPop[NCHS],        /* fractional population for lower and upper charge state */
	  LowestPot,            /* lowest potential a grain can ever have, in Ryd */
	  PotSurf[NCHS],        /* potential difference between grain surface and infinity (phi_g), in Ryd */
	  PotSurfInc[NCHS],     /* same as PotSurf, but for incoming electrons (using Zg instead of Zg+1), in Ryd */
	  RateUp,               /* total charging rate up, used for balance check, in e/cm^2/s */
	  RateDn,               /* total charging rate down, used for balance check, in e/cm^2/s */
	  StickElecNeg,         /* sticking efficiency for electrons on negative or neutral grains */
	  StickElecPos,         /* sticking efficiency for electrons on positive grains */
	  ThresInf[NCHS],       /* threshold for removing electron from grain well to infinity (phi), in Ryd */
	  ThresInfInc[NCHS],    /* same as ThresInf, but for incoming electrons (using Zg instead of Zg+1), in Ryd */
	  ThresInfVal[NCHS],    /* threshold for removing electron from valence band to infinity (phi^v), in Ryd */
	  ThresSurf[NCHS],      /* threshold for removing electron from grain well to surface (phi_s), in Ryd */
	  ThresSurfInc[NCHS],   /* same as ThresSurf, but for incoming electrons (using Zg instead of Zg+1), in Ryd */
	  ThresSurfVal[NCHS];   /* threshold for removing electron from valence band to surface (phi_s^v), in Ryd */
	float avdpot,           /* Integral(Vg*dReff) for average grain potential, OUTPUT ONLY */
	  *y1/*[NC_ELL]*/,      /* size-dependent geometrical yield enhancement */
	  *inv_att_len/*[NC_ELL]*/; /* inverse attenuation length (in cm) */
	double AccomCoef[LIMELM], /* accomodation coefficient, needed for collisional heating of grain */
	  ThermRate[NCHS];      /* thermionic rate, in e/cm^2/s */

	/* heating/cooling balance, all entries are valid for current zone, actual depl, and are in erg/cm^3/s */
	double BolFlux,         /* total photon flux absorbed, used for energy conservation test */
	  GrainCoolTherm,       /* grain cooling due to thermionic emissions, summed over charge states */
	  GasHeatPhotoEl,       /* photoelectric heating of the gas, added in GrGH 0 */
	  GrainHeat,            /* total heating of current grain type */
	  GrainHeatColl,        /* collisional heating of current grain type */
	  ChemEn;               /* net amount of energy donated by recombining ions */

	/* quantum heating physics */
	int lgQHeat,            /* is quantum heating turned on ? */
	  lgUseQHeat,           /* should quantum heating be used for this zone ? */
	  lgEverQHeat;          /* was quantum heating used in any zone ? */
	long QHeatFailures;     /* counter for number of times qheat algorithm failed */
	double
	  *phiTilde/*[NC_ELL]*/, /* continuum corrected for photo-electric effect, in events/H/s/cell, default depl */
	  qtmin,                /* lowest grain temperature used in calculations, set per zone */
	  qtmin_zone1,          /* lowest grain temperature used in calculations, initial zone */
	  qpres;                /* intended logarithmic resolution for probability density */

	/* grain drift */
	float DustDftVel,       /* grain drift velocity for this zone */
	  avdft;                /* Integral(vdrift*dReff) for average drift velocity, OUTPUT ONLY */

	}	 GrainBin;

/* NB NB NB NB NB NB
 *
 * this is the master data structure for grain physics, it is statically allocated
 *
 * !! apart from bin[NDUST], NOTHING in this structure should have dimension NDUST !!
 *
 * all entries that depend on grain type should go in the GrainBin structure above
 *
 * NB NB NB NB NB NB */

EXTERN struct t_GrainVar {

	/* grain logic */
	int lgDustOn,                  /* have any grains been switched on ? */
	  lgBakes;                     /* approximate physics used in Bakes & Tielens (1994) */

	/* test logic */
	int lgDHetOn,                  /* default TRUE, turned off with GRAIN NO HEATING */
	  lgDColOn,                    /* default TRUE, turned off with GRAIN NO COOLING */
	  lgQHeatOn;                   /* default TRUE, turned off with GRAIN NO QHEAT */

	char ReadRecord[MAX_READ_RECORDS][READ_RECORD_LENGTH];
	                               /* record of all the files read by mie_read_opc */
	long ReadPtr;                  /* pointer for the array above */

	/* grain depletion */
	float GrainMetal,              /* grain depletion factor, from METALS xxx GRAINS command, usually 1 */
	  elmSumAbund[LIMELM];         /* number density of elements summed over all grain bins, at actual depl */ 

	/* chemical abundances of grains are normalized such that in any given zone
	 * the total number density of an element ipZ locked up in grains is given by
	 *    elmSumAbund(ipZ) = Sum_over_nd ( elmAbund[nd][ipZ]*dstAbund[nd]*phycon.hden ) */

	/* grain opacities */
	double *dstab/*[NC_ELL]*/,     /* total absorption cross section, current depl is factored in */
	  *dstsc/*[NC_ELL]*/;          /* total scattering cross section, current depl is factored in */

	/* grain charging */
	/* >>chng 02 jan 05, moved to doppvel since needed elsewhere */
	/*double AveVel[LIMELM];          average velocity of atoms/ions in gas, for grain charging and heating */
	double TotalEden;              /* contribution to eden from all grain species, a positive number means
					* that the grains contribute to the free electron pool, in cm^-3 */
	long HighestIon,               /* highest ionization stage with non-zero abundance present in the gas */
	  nChrgRequested;              /* number of charge states requested by user, default value is 2 */
	/* grain surface recombination rate for element ipZ, ionization stage "ion-from" to "ion-to"
	 * already multiplied by grain area, actual depletion, GrainRecom[ipZ][ion-from][ion-to], units s^-1 */
	float GrainRecom[LIMELM][LIMELM+1][LIMELM+1];

	/* heating/cooling balance, all entries are valid for current zone, actual depl, and are in erg/cm^3/s */
	double GasCoolColl,            /* cooling of the gas by collisions with all grains, summed in GrGC 0 */
	  GrainHeatSum,                /* total heating of all grain types, added in GraT 0 */
	  GrainHeatLya,                /* heating of all grains by Lya, added in GraL 1216 */
	  GrainHeatDif,                /* heating of all grains by all diffuse fields (incl Lya), added in GraD 0 */
	  GrainHeatInc,                /* heating of all grains by incident continuum, added in GraI 0 */
	  GrainHeatCollSum,            /* collisional heating of all grains, added in GraC 0 */
	  GrainHeatChem;               /* net amount of energy donated by recombining ions to all grains */

	/* equilibrium temperature */
	double dsttmp[NDEMS];          /* grain temperature grid for dstems (in GrainBin) */
	float reftot;                  /* Integral(dReff), to normalize radial averages (avdust, avdft, avdpot) */

	/* quantum heating physics */
	int lgQHeatAll,                /* use quantum heating for all grains, WILL BECOME DEFAULT */
	  lgQHPunLast;                 /* only punch quantum heating information on last iteration */
	long qnflux;                   /* like rfield.nflux, but may point to higher energy, for phiTilde and Phi */
	FILE *QHPunchFile;             /* file pointer for PUNCH QHEAT command */

	/* grain emission */
	float *GrainEmission/*[NC_ELL]*/, /* total emission from this zone, per unit vol, for add outward in metfic */
	  *GraphiteEmission/*[NC_ELL]*/ , /* graphite emission from the entire model */
	  *SilicateEmission/*[NC_ELL]*/;  /* silicate emission from the entire model */

	/* per grain data */
	long int nBin;                 /* counter for how many bins have been allocated */
	GrainBin *bin[NDUST];          /* pointers to memory allocated for bins */

	}	gv;
