/*GetMaxhLine find the strongest heating line */
#include "cddefines.h"
#include "taulines.h"
#include "heatlmax.h"
#include "getmaxhline.h"

void GetMaxhLine(void)
{
	long int i;
	double strong;

#	ifdef DEBUG_FUN
	fputs( "<+>GetMaxhLine()\n", debug_fp );
#	endif

	/* routine called to find which is the strongest heating line */
	strong = 0.;

	/* possible for levlmax to remain 0 if induced processes turned off */
	heatlmax.levlmax = 0;

	for( i=1; i <= nLevel1; i++ )
	{
		if( TauLines[i].heat > strong )
		{
			strong = TauLines[i].heat;
			heatlmax.levlmax = 1;
			heatlmax.ipHeatlmax = i;
		}
	}
	for( i=0; i < nWindLine; i++ )
	{
		if( TauLine2[i].heat > strong )
		{
			strong = TauLine2[i].heat;
			heatlmax.levlmax = 2;
			heatlmax.ipHeatlmax = i;
		}
	}
	for( i=0; i < nHFLines; i++ )
	{
		if( HFLines[i].heat > strong )
		{
			strong = HFLines[i].heat;
			heatlmax.levlmax = 2;
			heatlmax.ipHeatlmax = i;
		}
	}
	for( i=0; i < nCORotate; i++ )
	{
		if( C12O16Rotate[i].heat > strong )
		{
			strong = C12O16Rotate[i].heat;
			heatlmax.levlmax = 3;
			heatlmax.ipHeatlmax = i;
		}
		if( C13O16Rotate[i].heat > strong )
		{
			strong = C13O16Rotate[i].heat;
			heatlmax.levlmax = 4;
			heatlmax.ipHeatlmax = i;
		}
	}

#	ifdef DEBUG_FUN
	fputs( " <->GetMaxhLine()\n", debug_fp );
#	endif
	return;
}

