/*Fe26cs123 line collision rates for lower levels of hydrogenic iron, n=1,2,3 */
#include "cddefines.h"
#include "phycon.h"
/* prototype is in hydrogenic */

double Fe26cs123(long int i, 
  long int j)
{
	double Fe26cs123_v, 
	  TeUse, 
	  t, 
	  x;
	static double a[3]={-4.238398,-238.2599,-1211.5237};
	static double b[3]={-0.4448177,-27.06869,-136.7659};
	static double c[3]={0.0022861,0.153273,0.7677703};
	static double d[3]={3.303775,191.7165,972.3731};
	static double e[3]={15.82689,878.1333,4468.696};

#	ifdef DEBUG_FUN
	fputs( "<+>Fe26cs123()\n", debug_fp );
#	endif

	/*  These are fits to Table 5 of
	 *  >>refer	fe26	cs	Aggarwal, K.M., & Kingston, A.E. 1993, ApJS, 85, 187
	 *  Fe XXVI collision rates for 1s-3, 2s-3, and 2p-3, 
	 *  principal quantum numbers n and l.
	 *
	 *  i is the lower level and runs from 1 to 3 (1s, 2s, 2p)
	 *  j is the upper level and runs from 2 to 4 (2s, 2p, 3)
	 *  1s-2s,2p is not done here.
	 *  check temperature: fits only good between 5.2 < log Te < 7.2
	 *  */
	/*  arrays for fits of 3 transitions see the code below for key: */

	TeUse = MAX2(phycon.te,1.585e5);
	t = MIN2(TeUse,1.585e7);
	x = log10(t);

	if( i == 1 && j == 2 )
	{
		/* 1s - 2s (first entry) */
		fprintf( ioQQQ, " Fe XXVI 2s-1s not done in Fe26cs123\n" );
		puts( "[Stop in fe26cs123]" );
		cdEXIT(1);
	}

	else if( i == 1 && j == 3 )
	{
		/* 1s - 2p (second entry) */
		fprintf( ioQQQ, " Fe XXVI 2p-1s not done in Fe26cs123\n" );
		puts( "[Stop in fe26cs123]" );
		cdEXIT(1);
	}

	else if( i == 1 && j == 4 )
	{
		/* 1s - 3 (first entry) */
		Fe26cs123_v = a[0] + b[0]*x + c[0]*x*x*sqrt(x) + d[0]*log(x) + 
		  e[0]*log(x)/x/x;
		/*  Fe26Rate123 = cs*8.629e-6/SQRT(te)/18.
		 * */
	}
	else if( i == 2 && j == 4 )
	{
		/* 2s - 3 (second entry)         */
		Fe26cs123_v = a[1] + b[1]*x + c[1]*x*x*sqrt(x) + d[1]*log(x) + 
		  e[1]*log(x)/x/x;
		/*  Fe26Rate123 = cs*8.629e-6/SQRT(te)/18.
		 * */
	}
	else if( i == 3 && j == 4 )
	{
		/* 2p - 3s (third entry) */
		Fe26cs123_v = a[2] + b[2]*x + c[2]*x*x*sqrt(x) + d[2]*log(x) + 
		  e[2]*log(x)/x/x;
		/*  Fe26Rate123 = cs*8.629e-6/SQRT(te)/18.
		 * */
	}
	else
	{

		fprintf( ioQQQ, "  insane levels for Ca XX n=1,2,3 !!!\n" );
		puts( "[Stop in fe26cs123]" );
		cdEXIT(1);
	}

#	ifdef DEBUG_FUN
	fputs( " <->Fe26cs123()\n", debug_fp );
#	endif
	return( Fe26cs123_v );
}

