/*fabden called by dlaw command, returns density for any density law */
#include "cddefines.h"
#include "dlaw.h"
#include "uspher.h"
#include "fabden.h"

double fabden(double radius, 
  double depth)
{
	double fabden_v,powexp;
	const double parsec = 3.085678e18;

#	ifdef DEBUG_FUN
	fputs( "<+>fabden()\n", debug_fp );
#	endif

	/* this routine is called when the DLAW command is given,
	 * and must return the hydrogen density at the current radius or depth
	 * RADIUS is the radius, the distance from the center of symmetry.
	 * DEPTH is the depth into the cloud, from the illuminated face
	 * both are in cm
	 *
	 * radius, depth, and the array DensityLaw are double precision, although
	 * FABDEN itself is not
	 *
	 * this is one way to generate a density
	 * fabden = radius * depth
	 *
	 * this is how to use the parameters on the dlaw command
	 * fabden = DensityLaw(1) + radius * DensityLaw(2)
	 *
	 * following must be removed if this sub is to be used */
	/*fprintf( ioQQQ, " the old version of FABDEN must be deleted, and a new one put in place.  Sorry.\n" );*/

	if( depth > radius )
		total_insanity();

	/* update stromgren radius to most recent value */
	if( uspher.lgUSphON )
		dlaw.DensityLaw[2] = uspher.rstrom/parsec;
	/* this is the density law used in the Wen & O'Dell, 1995, ApJ 438, 784 paper */
	powexp = MIN2((radius/parsec-dlaw.DensityLaw[2])/dlaw.DensityLaw[1],dlaw.DensityLaw[3]);
	fabden_v = pow(10.,dlaw.DensityLaw[0])*exp(powexp);

#	ifdef DEBUG_FUN
	fputs( " <->fabden()\n", debug_fp );
#	endif
	return( fabden_v );

#if 0

	fabden_v = dlaw.DensityLaw[0];
	/* just here to stop compilers from flagging unused vars */
	temp = radius + depth ; 
	if( fabden_v == 0. )
	{
		puts( "[Stop in fabden]" );
		cdEXIT(1);
	}
	else
	{
		/* when this routine is used the following branck is the correct exit */
		
#		ifdef DEBUG_FUN
		fputs( " <->fabden()\n", debug_fp );
#		endif
		/* following should return correct value of the density at this position, 
		 * temp is there to trick lint */
		return( fabden_v*temp );
	}
#endif
}

