/*CrashDo any of several tests to check that the code can crash */
#include "cddefines.h"
#include "physconst.h"
#include "sphere.h"
#include "parse.h"
/* disable warning about undefined vars being used - one of the tests shall do exactly that */
#ifdef _MSC_VER
#pragma warning( disable : 4700 )
#endif
/* disable warning about division by zero */
#ifdef _MSC_VER
#pragma warning( disable : 4756 )
#endif

void CrashDo(char *chCard)
{
	float ar1;
	long int i;

	int lgCrash = FALSE;
	/* div by 0 to get crash as check on FP environment */
	if( lgMatch("ZERO",chCard) )
	{
		fprintf(ioQQQ," I will now div by 0 to get crash.  Hold on.\n");
		fflush(ioQQQ);
		sphere.covgeo = (float)(1. / ZeroNum );
		fprintf(ioQQQ," I am still alive - something is wrong, result is %e\n",
			sphere.covgeo);
		lgCrash = TRUE;
	}

	/* use some undefined numbers */
	else if( lgMatch("UNDE",chCard) )
	{ 
		fprintf(ioQQQ," I will now use the malloced undefined variable.  Hold on.\n");
		fflush(ioQQQ);
		{
			float *aa , a;
			aa = (float*)MALLOC(2*sizeof(float));
			a = aa[1] * 1e-10f;

			fprintf(ioQQQ," the result of the mult of undef by 1e-10 is %e\n",a);
			fflush(ioQQQ);
			free( aa );
		}
		
		fprintf(ioQQQ," Now I will now use an undefined variable off the stack.  Hold on.\n");
		fflush(ioQQQ);
		{
			float a;
			a = ar1 * 1e-10f;

			fprintf(ioQQQ," the result of the mult of undef by 1e-10 is %e\n",a);
			fflush(ioQQQ);
		}
		
		lgCrash = TRUE;
	}

	/* make overflow to get crash as check on FP environment */
	else if( lgMatch("OVER",chCard) )
	{ 
		ar1 = 1e-20f; 
		fprintf(ioQQQ," I will now make overflow to get crash.  Hold on.\n");
		fflush(ioQQQ);
		sphere.covgeo = (float)(DBL_MAX / ar1 );
		fprintf(ioQQQ," I am still alive - something is wrong, the result was %e\n",
			sphere.covgeo);
		lgCrash = TRUE;
	}

	/* assert impossible to get crash as check on environment */
	else if( lgMatch("ASSE",chCard) )
	{ 
		fprintf(ioQQQ," I will now make failed assert to get crash.  Hold on.\n");
		fflush(ioQQQ);
		assert( DBL_MAX <  ZerO );
		fprintf(ioQQQ," I am still alive - something is wrong.\n");
		lgCrash = TRUE;
	}

	/* assert ratios of zeros (NaN) to get crash as check on environment */
	else if( lgMatch(" NAN",chCard) )
	{ 
		ar1 = 0.;
		fprintf(ioQQQ," I will now make invalid operation (div 0 by 0) to get crash.  Hold on.\n");
		fflush(ioQQQ);
		sphere.covgeo = (float)(ar1 / ZeroNum );
		fprintf(ioQQQ," I am still alive - something is wrong, the result was %e\n",
			sphere.covgeo);
		lgCrash = TRUE;
	}

	/* array index out of bounds, two options, low and high */
	else if( lgMatch("BOUN",chCard) )
	{
		/* must turn off pclint detection of logical errors in this block */
		/*lint -e662 out of bounds*/
		/*lint -e661 out of bounds*/
		int * ibound;
		int ilow=-2, ihigh=12;
		if( (ibound = ((int *)MALLOC( 10*sizeof(int) ))) == NULL )
		{
			fprintf(ioQQQ," MALLOC did not allocate ibound\n");
			puts( "[Stop in ParseCommands]" );
			cdEXIT(1);
		}
		/* do low fail first */
		if( lgMatch(" LOW", chCard ) )
		{
			fprintf(ioQQQ," I will access ibound[-2].  Hold on.\n");
			fflush(ioQQQ);
			i = ibound[ilow];
			fprintf(ioQQQ," I am still alive - something is wrong.\n");
			lgCrash = TRUE;
		}
		/* do high fail first */
		else if( lgMatch("HIGH", chCard ) )
		{
			fprintf(ioQQQ," I will access ibound[limit+3].  Hold on.\n");
			fflush(ioQQQ);
			i = ibound[ihigh];
			fprintf(ioQQQ," I am still alive - something is wrong.\n");
			lgCrash = TRUE;
		}
		else
		{
			/* not specified, do low then high */
			fprintf(ioQQQ," I will access ibound[-2].  Hold on.\n");
			fflush(ioQQQ);
			i = ibound[ilow];
			fprintf(ioQQQ," I am still alive - something is wrong.\n");
			lgCrash = TRUE;
			fprintf(ioQQQ," I will access ibound[limit+3].  Hold on.\n");
			fflush(ioQQQ);
			i = ibound[ihigh];
			fprintf(ioQQQ," I am still alive - something is wrong.\n");
			lgCrash = TRUE;
		}
		free(ibound);
		/*lint +e662 out of bounds*/
		/*lint +e661 out of bounds*/
	}

	else
	{
		fprintf(ioQQQ," crash options are ZERO, OVERflow, _NAN, BOUNds, UNDEfined, and ASSErt.\n");
		lgCrash = TRUE;
	}
	if( lgCrash )
	{
		puts( "[Stop in CrashDo]" );
		cdEXIT(1);
	}
}
/* thurn this back on */
#ifdef _MSC_VER
#pragma warning( default : 4700 )/* disable warning that conditional expression*/
#endif
