/*CollidIonize fill in collisional ionization rates, and resulting cooling */
#include "cddefines.h"
#include "physconst.h"
#include "secondaries.h"
#include "phycon.h"
#include "ionrange.h"
#include "rfield.h"
#include "heavy.h"
#include "collionrate.h"
#include "cfit.h"
#include "collidionize.h"

void CollidIonize(
	/* element number on c scale, H is 0 */
	long int nelem )
{
	long int nion,
		limit;
	float DimaRate;
	double crate;

#	ifdef DEBUG_FUN
	fputs( "<+>CollidIonize()\n", debug_fp );
#	endif

	/* compute collisional ionization rate */

	/* CollidRate[0][nelem][ion] is collisional ionization rate, s-1
	 * CollidRate[1][nelem][ion] is collisional ionization cooling, erg/s
	 */

	/* zero out rates below lowest ionization stage we will consider */
	for( nion=0; nion < (IonRange.IonLow[nelem] - 1); nion++ )
	{
		CollIonRate.CollidRate[0][nion][nelem] = 0.;
		CollIonRate.CollidRate[1][nion][nelem] = 0.;
	}

	/* chng logic changed to be precisely same as bidiag */
	limit = MIN2(nelem-2,IonRange.IonHigh[nelem]-1);

	for( nion=IonRange.IonLow[nelem]; nion <= limit; nion++ )
	{
		/* 
		 * collisional ionization by thermal electrons
		 * >>chng 97 mar 19, to Dima's new routine using
		 * >>refer	all	coll_ion	Voronov G.S., 1997, At. Data Nucl. Data Tables 65, 1
		 */
		DimaRate = (float)cfit( nelem+1, nelem+1-nion , phycon.te );

		crate = DimaRate*phycon.eden;

		/* total collisional ionization rate 
		 * with both thermal and suprathermal electrons */
		CollIonRate.CollidRate[0][nion][nelem] = (float)crate + Secondaries.csupra;

		/* cooling due to collisional ionization, which only includes thermal */
		CollIonRate.CollidRate[1][nion][nelem] = (float)(crate*
			rfield.anu[Heavy.ipHeavy[nion][nelem]-1]* EN1RYD);
	}

	for( nion=IonRange.IonHigh[nelem]; nion <= nelem; nion++ )
	{
		CollIonRate.CollidRate[0][nion][nelem] = 0.;
		CollIonRate.CollidRate[1][nion][nelem] = 0.;
	}

	/* check not rates are negative - in release mode this loop will optimize out */
	for( nion=0; nion <= nelem; nion++ )
	{
		/* there can be no negative rates */
		assert( CollIonRate.CollidRate[0][nion][nelem] >= 0. );
	}

#	ifdef DEBUG_FUN
	fputs( " <->CollidIonize()\n", debug_fp );
#	endif
	return;
}
