/*cfit D Verner's routine to compute collisional ionization rate coefficients */
#include "cddefines.h"
#include "cfit.h"
struct t_ADfACF {
	float CF[30][30][5];
	}	ADfACF;
void cfitdata0(void);
void cfitdata1(void);
void cfitdata2(void);
void cfitdata3(void);

double cfit(long int iz, 
	  long int in, 
	  double t)
{
	float te, 
	  u;
	static int lgCalled=FALSE;
	double rate;

#	ifdef DEBUG_FUN
	fputs( "<+>cfit()\n", debug_fp );
#	endif
	/*D Verner's routine to compute collisional ionization rate coefficients
	 * Version 3, April 21, 1997
	 * Cu (Z=29) and Zn (Z=30) are added (fits from Ni, correct thresholds).
	 ******************************************************************************
	 *** This subroutine calculates rates of direct collisional ionization 
	 *** for all ionization stages of all elements from H to Ni (Z=28)
	 *** by use of the fits from
	 *>>refer Voronov, G. S., 1997, At. Data Nucl. Data Tables, 65, 1
	 *** Input parameters:  iz - atomic number on pphysical scale, H is 1
	 ***          in - number of electrons from 1 to iz 
	 ***          t  - temperature, K
	 *** Output parameter:  c  - rate coefficient, cm^3 s^(-1)
	 ****************************************************************************** */
	rate = 0.0;

	/* initialize block data if this is first call */
	if( !lgCalled )
	{
		cfitdata0();
		cfitdata1();
		cfitdata2();
		cfitdata3();
		lgCalled = TRUE;
	}

	if( iz < 1 || iz > 30 )
	{ 
#		ifdef DEBUG_FUN
		fputs( " <->cfit()\n", debug_fp );
#		endif
		return(rate);
	}

	if( in < 1 || in > iz )
	{ 
#		ifdef DEBUG_FUN
		fputs( " <->cfit()\n", debug_fp );
#		endif
		return(rate);
	}

	te = (float)(t*8.617385e-05);
	u = ADfACF.CF[in-1][iz-1][0]/te;
	if( u > 80.0 )
	{ 
#		ifdef DEBUG_FUN
		fputs( " <->cfit()\n", debug_fp );
#		endif
		return(rate);
	}

	rate = (ADfACF.CF[in-1][iz-1][2]*(1.0 + ADfACF.CF[in-1][iz-1][1]*
	  sqrt(u))/(ADfACF.CF[in-1][iz-1][3] + u)*pow(u,ADfACF.CF[in-1][iz-1][4])*
	  exp(-u));
	
#	ifdef DEBUG_FUN
	fputs( " <->cfit()\n", debug_fp );
#	endif

	return(rate);
}
	static long int I, 
	  _r;

/********************************************* */
void cfitdata0()
{
		{ static double _itmp0[] = {13.6,0.,2.91e-08,0.2320,0.39};
		for( I=1, _r = 0; I <= 5; I++ )
		{
			ADfACF.CF[0][0][I-1] = (float)_itmp0[_r++];
			}
		}
		{ static double _itmp1[] = {24.6,0.,1.75e-08,0.1800,0.35};
		for( I=1, _r = 0; I <= 5; I++ )
		{
			ADfACF.CF[1][1][I-1] = (float)_itmp1[_r++];
			}
		}
		{ static double _itmp2[] = {54.4,1.,2.05e-09,0.2650,0.25};
		for( I=1, _r = 0; I <= 5; I++ )
		{
			ADfACF.CF[0][1][I-1] = (float)_itmp2[_r++];
			}
		}
		{ static double _itmp3[] = {5.4,0.,1.39e-07,0.4380,0.41};
		for( I=1, _r = 0; I <= 5; I++ )
		{
			ADfACF.CF[2][2][I-1] = (float)_itmp3[_r++];
			}
		}
		{ static double _itmp4[] = {75.6,1.,2.01e-09,0.2090,0.23};
		for( I=1, _r = 0; I <= 5; I++ )
		{
			ADfACF.CF[1][2][I-1] = (float)_itmp4[_r++];
			}
		}
		{ static double _itmp5[] = {122.4,1.,9.60e-10,0.5820,0.17};
		for( I=1, _r = 0; I <= 5; I++ )
		{
			ADfACF.CF[0][2][I-1] = (float)_itmp5[_r++];
			}
		}
		{ static double _itmp6[] = {9.3,0.,1.02e-07,0.3750,0.27};
		for( I=1, _r = 0; I <= 5; I++ )
		{
			ADfACF.CF[3][3][I-1] = (float)_itmp6[_r++];
			}
		}
		{ static double _itmp7[] = {18.2,1.,2.08e-08,0.4390,0.21};
		for( I=1, _r = 0; I <= 5; I++ )
		{
			ADfACF.CF[2][3][I-1] = (float)_itmp7[_r++];
			}
		}
		{ static double _itmp8[] = {153.9,0.,2.67e-09,0.6120,0.27};
		for( I=1, _r = 0; I <= 5; I++ )
		{
			ADfACF.CF[1][3][I-1] = (float)_itmp8[_r++];
			}
		}
		{ static double _itmp9[] = {217.7,1.,4.27e-10,0.6580,0.15};
		for( I=1, _r = 0; I <= 5; I++ )
		{
			ADfACF.CF[0][3][I-1] = (float)_itmp9[_r++];
			}
		}
		{ static double _itmp10[] = {8.3,0.,6.49e-08,0.2000,0.26};
		for( I=1, _r = 0; I <= 5; I++ )
		{
			ADfACF.CF[4][4][I-1] = (float)_itmp10[_r++];
			}
		}
		{ static double _itmp11[] = {25.2,1.,1.24e-08,0.2670,0.22};
		for( I=1, _r = 0; I <= 5; I++ )
		{
			ADfACF.CF[3][4][I-1] = (float)_itmp11[_r++];
			}
		}
		{ static double _itmp12[] = {37.9,1.,3.27e-09,0.2950,0.23};
		for( I=1, _r = 0; I <= 5; I++ )
		{
			ADfACF.CF[2][4][I-1] = (float)_itmp12[_r++];
			}
		}
		{ static double _itmp13[] = {259.4,1.,4.95e-10,0.4890,0.09};
		for( I=1, _r = 0; I <= 5; I++ )
		{
			ADfACF.CF[1][4][I-1] = (float)_itmp13[_r++];
			}
		}
		{ static double _itmp14[] = {340.2,1.,2.19e-10,0.6570,0.15};
		for( I=1, _r = 0; I <= 5; I++ )
		{
			ADfACF.CF[0][4][I-1] = (float)_itmp14[_r++];
			}
		}
		{ static double _itmp15[] = {11.3,0.,6.85e-08,0.1930,0.25};
		for( I=1, _r = 0; I <= 5; I++ )
		{
			ADfACF.CF[5][5][I-1] = (float)_itmp15[_r++];
			}
		}
		{ static double _itmp16[] = {24.4,1.,1.86e-08,0.2860,0.24};
		for( I=1, _r = 0; I <= 5; I++ )
		{
			ADfACF.CF[4][5][I-1] = (float)_itmp16[_r++];
			}
		}
		{ static double _itmp17[] = {47.9,1.,6.35e-09,0.4270,0.21};
		for( I=1, _r = 0; I <= 5; I++ )
		{
			ADfACF.CF[3][5][I-1] = (float)_itmp17[_r++];
			}
		}
		{ static double _itmp18[] = {64.5,1.,1.50e-09,0.4160,0.13};
		for( I=1, _r = 0; I <= 5; I++ )
		{
			ADfACF.CF[2][5][I-1] = (float)_itmp18[_r++];
			}
		}
		{ static double _itmp19[] = {392.1,1.,2.99e-10,0.6660,0.02};
		for( I=1, _r = 0; I <= 5; I++ )
		{
			ADfACF.CF[1][5][I-1] = (float)_itmp19[_r++];
			}
		}
		{ static double _itmp20[] = {490.0,1.,1.23e-10,0.6200,0.16};
		for( I=1, _r = 0; I <= 5; I++ )
		{
			ADfACF.CF[0][5][I-1] = (float)_itmp20[_r++];
			}
		}
		{ static double _itmp21[] = {14.5,0.,4.82e-08,0.0652,0.42};
		for( I=1, _r = 0; I <= 5; I++ )
		{
			ADfACF.CF[6][6][I-1] = (float)_itmp21[_r++];
			}
		}
		{ static double _itmp22[] = {29.6,0.,2.98e-08,0.3100,0.30};
		for( I=1, _r = 0; I <= 5; I++ )
		{
			ADfACF.CF[5][6][I-1] = (float)_itmp22[_r++];
			}
		}
		{ static double _itmp23[] = {47.5,1.,8.10e-09,0.3500,0.24};
		for( I=1, _r = 0; I <= 5; I++ )
		{
			ADfACF.CF[4][6][I-1] = (float)_itmp23[_r++];
			}
		}
		{ static double _itmp24[] = {77.5,1.,3.71e-09,0.5490,0.18};
		for( I=1, _r = 0; I <= 5; I++ )
		{
			ADfACF.CF[3][6][I-1] = (float)_itmp24[_r++];
			}
		}
		{ static double _itmp25[] = {97.9,0.,1.51e-09,0.0167,0.74};
		for( I=1, _r = 0; I <= 5; I++ )
		{
			ADfACF.CF[2][6][I-1] = (float)_itmp25[_r++];
			}
		}
		{ static double _itmp26[] = {552.1,0.,3.71e-10,0.5460,0.29};
		for( I=1, _r = 0; I <= 5; I++ )
		{
			ADfACF.CF[1][6][I-1] = (float)_itmp26[_r++];
			}
		}
		{ static double _itmp27[] = {667.0,1.,7.77e-11,0.6240,0.16};
		for( I=1, _r = 0; I <= 5; I++ )
		{
			ADfACF.CF[0][6][I-1] = (float)_itmp27[_r++];
			}
		}
		{ static double _itmp28[] = {13.6,0.,3.59e-08,0.0730,0.34};
		for( I=1, _r = 0; I <= 5; I++ )
		{
			ADfACF.CF[7][7][I-1] = (float)_itmp28[_r++];
			}
		}
		{ static double _itmp29[] = {35.1,1.,1.39e-08,0.2120,0.22};
		for( I=1, _r = 0; I <= 5; I++ )
		{
			ADfACF.CF[6][7][I-1] = (float)_itmp29[_r++];
			}
		}
		{ static double _itmp30[] = {54.9,1.,9.31e-09,0.2700,0.27};
		for( I=1, _r = 0; I <= 5; I++ )
		{
			ADfACF.CF[5][7][I-1] = (float)_itmp30[_r++];
			}
		}
		{ static double _itmp31[] = {77.4,0.,1.02e-08,0.6140,0.27};
		for( I=1, _r = 0; I <= 5; I++ )
		{
			ADfACF.CF[4][7][I-1] = (float)_itmp31[_r++];
			}
		}
		{ static double _itmp32[] = {113.9,1.,2.19e-09,0.6300,0.17};
		for( I=1, _r = 0; I <= 5; I++ )
		{
			ADfACF.CF[3][7][I-1] = (float)_itmp32[_r++];
			}
		}
		{ static double _itmp33[] = {138.1,0.,1.95e-09,0.3600,0.54};
		for( I=1, _r = 0; I <= 5; I++ )
		{
			ADfACF.CF[2][7][I-1] = (float)_itmp33[_r++];
			}
		}
		{ static double _itmp34[] = {739.3,0.,2.12e-10,0.3960,0.35};
		for( I=1, _r = 0; I <= 5; I++ )
		{
			ADfACF.CF[1][7][I-1] = (float)_itmp34[_r++];
			}
		}
		{ static double _itmp35[] = {871.4,1.,5.21e-11,0.6290,0.16};
		for( I=1, _r = 0; I <= 5; I++ )
		{
			ADfACF.CF[0][7][I-1] = (float)_itmp35[_r++];
			}
		}
		{ static double _itmp36[] = {17.4,1.,7.00e-08,0.1780,0.29};
		for( I=1, _r = 0; I <= 5; I++ )
		{
			ADfACF.CF[8][8][I-1] = (float)_itmp36[_r++];
			}
		}
		{ static double _itmp37[] = {35.0,0.,5.41e-08,0.5710,0.27};
		for( I=1, _r = 0; I <= 5; I++ )
		{
			ADfACF.CF[7][8][I-1] = (float)_itmp37[_r++];
			}
		}
		{ static double _itmp38[] = {62.7,1.,9.37e-09,0.3190,0.20};
		for( I=1, _r = 0; I <= 5; I++ )
		{
			ADfACF.CF[6][8][I-1] = (float)_itmp38[_r++];
			}
		}
		{ static double _itmp39[] = {87.1,1.,4.92e-09,0.3230,0.24};
		for( I=1, _r = 0; I <= 5; I++ )
		{
			ADfACF.CF[5][8][I-1] = (float)_itmp39[_r++];
			}
		}
		{ static double _itmp40[] = {114.2,0.,7.06e-09,0.6840,0.27};
		for( I=1, _r = 0; I <= 5; I++ )
		{
			ADfACF.CF[4][8][I-1] = (float)_itmp40[_r++];
			}
		}
		{ static double _itmp41[] = {157.2,1.,1.28e-09,0.6480,0.16};
		for( I=1, _r = 0; I <= 5; I++ )
		{
			ADfACF.CF[3][8][I-1] = (float)_itmp41[_r++];
			}
		}
		{ static double _itmp42[] = {185.2,1.,5.61e-10,0.7380,0.16};
		for( I=1, _r = 0; I <= 5; I++ )
		{
			ADfACF.CF[2][8][I-1] = (float)_itmp42[_r++];
			}
		}
		{ static double _itmp43[] = {953.9,0.,1.66e-10,0.5420,0.29};
		for( I=1, _r = 0; I <= 5; I++ )
		{
			ADfACF.CF[1][8][I-1] = (float)_itmp43[_r++];
			}
		}
		{ static double _itmp44[] = {1103.1,1.,3.74e-11,0.6590,0.15};
		for( I=1, _r = 0; I <= 5; I++ )
		{
			ADfACF.CF[0][8][I-1] = (float)_itmp44[_r++];
			}
		}
		{ static double _itmp45[] = {21.6,1.,1.50e-08,0.0329,0.43};
		for( I=1, _r = 0; I <= 5; I++ )
		{
			ADfACF.CF[9][9][I-1] = (float)_itmp45[_r++];
			}
		}
		{ static double _itmp46[] = {41.0,0.,1.98e-08,0.2950,0.20};
		for( I=1, _r = 0; I <= 5; I++ )
		{
			ADfACF.CF[8][9][I-1] = (float)_itmp46[_r++];
			}
		}
		{ static double _itmp47[] = {63.5,1.,7.03e-09,0.0677,0.39};
		for( I=1, _r = 0; I <= 5; I++ )
		{
			ADfACF.CF[7][9][I-1] = (float)_itmp47[_r++];
			}
		}
		{ static double _itmp48[] = {97.1,1.,4.24e-09,0.0482,0.58};
		for( I=1, _r = 0; I <= 5; I++ )
		{
			ADfACF.CF[6][9][I-1] = (float)_itmp48[_r++];
			}
		}
		{ static double _itmp49[] = {126.2,1.,2.79e-09,0.3050,0.25};
		for( I=1, _r = 0; I <= 5; I++ )
		{
			ADfACF.CF[5][9][I-1] = (float)_itmp49[_r++];
			}
		}
		{ static double _itmp50[] = {157.9,0.,3.45e-09,0.5810,0.28};
		for( I=1, _r = 0; I <= 5; I++ )
		{
			ADfACF.CF[4][9][I-1] = (float)_itmp50[_r++];
			}
		}
		{ static double _itmp51[] = {207.3,1.,9.56e-10,0.7490,0.14};
		for( I=1, _r = 0; I <= 5; I++ )
		{
			ADfACF.CF[3][9][I-1] = (float)_itmp51[_r++];
			}
		}
		{ static double _itmp52[] = {239.1,1.,4.73e-10,0.9920,0.04};
		for( I=1, _r = 0; I <= 5; I++ )
		{
			ADfACF.CF[2][9][I-1] = (float)_itmp52[_r++];
			}
		}
		{ static double _itmp53[] = {1196.0,1.,3.92e-11,0.2620,0.20};
		for( I=1, _r = 0; I <= 5; I++ )
		{
			ADfACF.CF[1][9][I-1] = (float)_itmp53[_r++];
			}
		}
		{ static double _itmp54[] = {1360.6,1.,2.77e-11,0.6610,0.13};
		for( I=1, _r = 0; I <= 5; I++ )
		{
			ADfACF.CF[0][9][I-1] = (float)_itmp54[_r++];
			}
		}
		{ static double _itmp55[] = {5.1,1.,1.01e-07,0.2750,0.23};
		for( I=1, _r = 0; I <= 5; I++ )
		{
			ADfACF.CF[10][10][I-1] = (float)_itmp55[_r++];
			}
		}
		{ static double _itmp56[] = {47.3,1.,7.35e-09,0.0560,0.35};
		for( I=1, _r = 0; I <= 5; I++ )
		{
			ADfACF.CF[9][10][I-1] = (float)_itmp56[_r++];
			}
		}
		{ static double _itmp57[] = {71.6,1.,8.10e-09,0.1480,0.32};
		for( I=1, _r = 0; I <= 5; I++ )
		{
			ADfACF.CF[8][10][I-1] = (float)_itmp57[_r++];
			}
		}
		{ static double _itmp58[] = {98.9,0.,1.14e-08,0.5530,0.28};
		for( I=1, _r = 0; I <= 5; I++ )
		{
			ADfACF.CF[7][10][I-1] = (float)_itmp58[_r++];
			}
		}
		{ static double _itmp59[] = {138.4,1.,2.63e-09,0.2300,0.29};
		for( I=1, _r = 0; I <= 5; I++ )
		{
			ADfACF.CF[6][10][I-1] = (float)_itmp59[_r++];
			}
		}
		{ static double _itmp60[] = {172.2,1.,1.85e-09,0.3630,0.22};
		for( I=1, _r = 0; I <= 5; I++ )
		{
			ADfACF.CF[5][10][I-1] = (float)_itmp60[_r++];
			}
		}
		{ static double _itmp61[] = {208.5,0.,2.82e-09,0.6740,0.27};
		for( I=1, _r = 0; I <= 5; I++ )
		{
			ADfACF.CF[4][10][I-1] = (float)_itmp61[_r++];
			}
		}
		{ static double _itmp62[] = {264.2,1.,6.72e-10,0.7520,0.14};
		for( I=1, _r = 0; I <= 5; I++ )
		{
			ADfACF.CF[3][10][I-1] = (float)_itmp62[_r++];
			}
		}
		{ static double _itmp63[] = {299.9,1.,2.80e-10,0.7810,0.15};
		for( I=1, _r = 0; I <= 5; I++ )
		{
			ADfACF.CF[2][10][I-1] = (float)_itmp63[_r++];
			}
		}
		{ static double _itmp64[] = {1465.1,1.,4.63e-11,0.5580,0.16};
		for( I=1, _r = 0; I <= 5; I++ )
		{
			ADfACF.CF[1][10][I-1] = (float)_itmp64[_r++];
			}
		}
		{ static double _itmp65[] = {1648.7,1.,2.16e-11,0.7430,0.13};
		for( I=1, _r = 0; I <= 5; I++ )
		{
			ADfACF.CF[0][10][I-1] = (float)_itmp65[_r++];
			}
		}
		{ static double _itmp66[] = {7.6,0.,6.21e-07,0.5920,0.39};
		for( I=1, _r = 0; I <= 5; I++ )
		{
			ADfACF.CF[11][11][I-1] = (float)_itmp66[_r++];
			}
		}
		{ static double _itmp67[] = {15.2,0.,1.92e-08,0.0027,0.85};
		for( I=1, _r = 0; I <= 5; I++ )
		{
			ADfACF.CF[10][11][I-1] = (float)_itmp67[_r++];
			}
		}
		{ static double _itmp68[] = {80.1,1.,5.56e-09,0.1070,0.30};
		for( I=1, _r = 0; I <= 5; I++ )
		{
			ADfACF.CF[9][11][I-1] = (float)_itmp68[_r++];
			}
		}
		{ static double _itmp69[] = {109.3,1.,4.35e-09,0.1590,0.31};
		for( I=1, _r = 0; I <= 5; I++ )
		{
			ADfACF.CF[8][11][I-1] = (float)_itmp69[_r++];
			}
		}
		{ static double _itmp70[] = {141.3,0.,7.10e-09,0.6580,0.25};
		for( I=1, _r = 0; I <= 5; I++ )
		{
			ADfACF.CF[7][11][I-1] = (float)_itmp70[_r++];
			}
		}
		{ static double _itmp71[] = {186.5,1.,1.70e-09,0.2420,0.28};
		for( I=1, _r = 0; I <= 5; I++ )
		{
			ADfACF.CF[6][11][I-1] = (float)_itmp71[_r++];
			}
		}
		{ static double _itmp72[] = {224.9,1.,1.22e-09,0.3430,0.23};
		for( I=1, _r = 0; I <= 5; I++ )
		{
			ADfACF.CF[5][11][I-1] = (float)_itmp72[_r++];
			}
		}
		{ static double _itmp73[] = {266.0,0.,2.20e-09,0.8970,0.22};
		for( I=1, _r = 0; I <= 5; I++ )
		{
			ADfACF.CF[4][11][I-1] = (float)_itmp73[_r++];
			}
		}
		{ static double _itmp74[] = {328.2,1.,4.86e-10,0.7510,0.14};
		for( I=1, _r = 0; I <= 5; I++ )
		{
			ADfACF.CF[3][11][I-1] = (float)_itmp74[_r++];
			}
		}
		{ static double _itmp75[] = {367.5,1.,2.35e-10,1.0300,0.10};
		for( I=1, _r = 0; I <= 5; I++ )
		{
			ADfACF.CF[2][11][I-1] = (float)_itmp75[_r++];
			}
		}
		{ static double _itmp76[] = {1761.8,1.,2.06e-11,0.1960,0.25};
		for( I=1, _r = 0; I <= 5; I++ )
		{
			ADfACF.CF[1][11][I-1] = (float)_itmp76[_r++];
			}
		}
		{ static double _itmp77[] = {1962.7,1.,1.75e-11,0.8350,0.11};
		for( I=1, _r = 0; I <= 5; I++ )
		{
			ADfACF.CF[0][11][I-1] = (float)_itmp77[_r++];
			}
		}
		{ static double _itmp78[] = {6.0,1.,2.28e-07,0.3870,0.25};
		for( I=1, _r = 0; I <= 5; I++ )
		{
			ADfACF.CF[12][12][I-1] = (float)_itmp78[_r++];
			}
		}
		{ static double _itmp79[] = {18.8,0.,1.18e-07,2.2100,0.25};
		for( I=1, _r = 0; I <= 5; I++ )
		{
			ADfACF.CF[11][12][I-1] = (float)_itmp79[_r++];
			}
		}
		{ static double _itmp80[] = {28.5,1.,4.40e-09,0.1060,0.24};
		for( I=1, _r = 0; I <= 5; I++ )
		{
			ADfACF.CF[10][12][I-1] = (float)_itmp80[_r++];
			}
		}
		{ static double _itmp81[] = {120.0,0.,1.75e-08,0.8720,0.22};
		for( I=1, _r = 0; I <= 5; I++ )
		{
			ADfACF.CF[9][12][I-1] = (float)_itmp81[_r++];
			}
		}
		{ static double _itmp82[] = {153.8,1.,2.61e-09,0.1590,0.31};
		for( I=1, _r = 0; I <= 5; I++ )
		{
			ADfACF.CF[8][12][I-1] = (float)_itmp82[_r++];
			}
		}
		{ static double _itmp83[] = {198.5,1.,1.85e-09,0.1520,0.36};
		for( I=1, _r = 0; I <= 5; I++ )
		{
			ADfACF.CF[7][12][I-1] = (float)_itmp83[_r++];
			}
		}
		{ static double _itmp84[] = {241.4,1.,1.14e-09,0.2280,0.29};
		for( I=1, _r = 0; I <= 5; I++ )
		{
			ADfACF.CF[6][12][I-1] = (float)_itmp84[_r++];
			}
		}
		{ static double _itmp85[] = {284.6,1.,8.00e-10,0.4170,0.16};
		for( I=1, _r = 0; I <= 5; I++ )
		{
			ADfACF.CF[5][12][I-1] = (float)_itmp85[_r++];
			}
		}
		{ static double _itmp86[] = {390.2,1.,5.83e-10,0.4970,0.23};
		for( I=1, _r = 0; I <= 5; I++ )
		{
			ADfACF.CF[4][12][I-1] = (float)_itmp86[_r++];
			}
		}
		{ static double _itmp87[] = {399.4,0.,4.93e-10,0.7060,0.16};
		for( I=1, _r = 0; I <= 5; I++ )
		{
			ADfACF.CF[3][12][I-1] = (float)_itmp87[_r++];
			}
		}
		{ static double _itmp88[] = {442.0,1.,9.77e-11,0.2780,0.17};
		for( I=1, _r = 0; I <= 5; I++ )
		{
			ADfACF.CF[2][12][I-1] = (float)_itmp88[_r++];
			}
		}
		{ static double _itmp89[] = {2086.6,0.,3.94e-11,0.2860,0.36};
		for( I=1, _r = 0; I <= 5; I++ )
		{
			ADfACF.CF[1][12][I-1] = (float)_itmp89[_r++];
			}
		}
		{ static double _itmp90[] = {2304.1,1.,1.38e-11,0.8350,0.11};
		for( I=1, _r = 0; I <= 5; I++ )
		{
			ADfACF.CF[0][12][I-1] = (float)_itmp90[_r++];
			}
		}
		{ static double _itmp91[] = {8.2,1.,1.88e-07,0.3760,0.25};
		for( I=1, _r = 0; I <= 5; I++ )
		{
			ADfACF.CF[13][13][I-1] = (float)_itmp91[_r++];
			}
		}
		{ static double _itmp92[] = {16.4,1.,6.43e-08,0.6320,0.20};
		for( I=1, _r = 0; I <= 5; I++ )
		{
			ADfACF.CF[12][13][I-1] = (float)_itmp92[_r++];
			}
		}
		{ static double _itmp93[] = {33.5,1.,2.01e-08,0.4730,0.22};
		for( I=1, _r = 0; I <= 5; I++ )
		{
			ADfACF.CF[11][13][I-1] = (float)_itmp93[_r++];
			}
		}
		{ static double _itmp94[] = {54.0,1.,4.94e-09,0.1720,0.23};
		for( I=1, _r = 0; I <= 5; I++ )
		{
			ADfACF.CF[10][13][I-1] = (float)_itmp94[_r++];
			}
		}
		{ static double _itmp95[] = {166.8,1.,1.76e-09,0.1020,0.31};
		for( I=1, _r = 0; I <= 5; I++ )
		{
			ADfACF.CF[9][13][I-1] = (float)_itmp95[_r++];
			}
		}
		{ static double _itmp96[] = {205.3,1.,1.74e-09,0.1800,0.29};
		for( I=1, _r = 0; I <= 5; I++ )
		{
			ADfACF.CF[8][13][I-1] = (float)_itmp96[_r++];
			}
		}
		{ static double _itmp97[] = {246.5,1.,1.23e-09,0.5180,0.07};
		for( I=1, _r = 0; I <= 5; I++ )
		{
			ADfACF.CF[7][13][I-1] = (float)_itmp97[_r++];
			}
		}
		{ static double _itmp98[] = {303.5,1.,8.27e-10,0.2390,0.28};
		for( I=1, _r = 0; I <= 5; I++ )
		{
			ADfACF.CF[6][13][I-1] = (float)_itmp98[_r++];
			}
		}
		{ static double _itmp99[] = {351.1,1.,6.01e-10,0.3050,0.25};
		for( I=1, _r = 0; I <= 5; I++ )
		{
			ADfACF.CF[5][13][I-1] = (float)_itmp99[_r++];
			}
		}
		{ static double _itmp100[] = {401.4,1.,4.65e-10,0.6660,0.04};
		for( I=1, _r = 0; I <= 5; I++ )
		{
			ADfACF.CF[4][13][I-1] = (float)_itmp100[_r++];
			}
		}
		{ static double _itmp101[] = {476.4,1.,2.63e-10,0.6660,0.16};
		for( I=1, _r = 0; I <= 5; I++ )
		{
			ADfACF.CF[3][13][I-1] = (float)_itmp101[_r++];
			}
		}
		{ static double _itmp102[] = {523.5,1.,1.18e-10,0.7340,0.16};
		for( I=1, _r = 0; I <= 5; I++ )
		{
			ADfACF.CF[2][13][I-1] = (float)_itmp102[_r++];
			}
		}
		{ static double _itmp103[] = {2437.7,0.,3.36e-11,0.3360,0.37};
		for( I=1, _r = 0; I <= 5; I++ )
		{
			ADfACF.CF[1][13][I-1] = (float)_itmp103[_r++];
			}
		}
		{ static double _itmp104[] = {2673.2,1.,1.19e-11,0.9890,0.08};
		for( I=1, _r = 0; I <= 5; I++ )
		{
			ADfACF.CF[0][13][I-1] = (float)_itmp104[_r++];
			}
		}
		{ static double _itmp105[] = {10.5,1.,1.99e-07,0.5350,0.24};
		for( I=1, _r = 0; I <= 5; I++ )
		{
			ADfACF.CF[14][14][I-1] = (float)_itmp105[_r++];
			}
		}
		{ static double _itmp106[] = {19.8,1.,5.88e-08,0.5370,0.21};
		for( I=1, _r = 0; I <= 5; I++ )
		{
			ADfACF.CF[13][14][I-1] = (float)_itmp106[_r++];
			}
		}
}
void cfitdata1()
{
		{ static double _itmp107[] = {30.2,1.,2.96e-08,0.8650,0.16};
		for( I=1, _r = 0; I <= 5; I++ )
		{
			ADfACF.CF[12][14][I-1] = (float)_itmp107[_r++];
			}
		}
		{ static double _itmp108[] = {51.4,1.,1.01e-08,0.5460,0.20};
		for( I=1, _r = 0; I <= 5; I++ )
		{
			ADfACF.CF[11][14][I-1] = (float)_itmp108[_r++];
			}
		}
		{ static double _itmp109[] = {65.0,1.,2.36e-09,0.1920,0.17};
		for( I=1, _r = 0; I <= 5; I++ )
		{
			ADfACF.CF[10][14][I-1] = (float)_itmp109[_r++];
			}
		}
		{ static double _itmp110[] = {220.4,0.,6.66e-09,1.0000,0.18};
		for( I=1, _r = 0; I <= 5; I++ )
		{
			ADfACF.CF[9][14][I-1] = (float)_itmp110[_r++];
			}
		}
		{ static double _itmp111[] = {263.2,1.,1.24e-09,0.2150,0.26};
		for( I=1, _r = 0; I <= 5; I++ )
		{
			ADfACF.CF[8][14][I-1] = (float)_itmp111[_r++];
			}
		}
		{ static double _itmp112[] = {309.4,0.,2.27e-09,0.7340,0.23};
		for( I=1, _r = 0; I <= 5; I++ )
		{
			ADfACF.CF[7][14][I-1] = (float)_itmp112[_r++];
			}
		}
		{ static double _itmp113[] = {371.7,1.,6.14e-10,0.2560,0.27};
		for( I=1, _r = 0; I <= 5; I++ )
		{
			ADfACF.CF[6][14][I-1] = (float)_itmp113[_r++];
			}
		}
		{ static double _itmp114[] = {424.5,1.,4.69e-10,0.3420,0.23};
		for( I=1, _r = 0; I <= 5; I++ )
		{
			ADfACF.CF[5][14][I-1] = (float)_itmp114[_r++];
			}
		}
		{ static double _itmp115[] = {479.6,0.,6.14e-10,0.3340,0.39};
		for( I=1, _r = 0; I <= 5; I++ )
		{
			ADfACF.CF[4][14][I-1] = (float)_itmp115[_r++];
			}
		}
		{ static double _itmp116[] = {560.4,0.,3.22e-10,0.8500,0.12};
		for( I=1, _r = 0; I <= 5; I++ )
		{
			ADfACF.CF[3][14][I-1] = (float)_itmp116[_r++];
			}
		}
		{ static double _itmp117[] = {611.9,1.,9.32e-11,0.7340,0.16};
		for( I=1, _r = 0; I <= 5; I++ )
		{
			ADfACF.CF[2][14][I-1] = (float)_itmp117[_r++];
			}
		}
		{ static double _itmp118[] = {2816.9,0.,3.79e-11,0.8050,0.22};
		for( I=1, _r = 0; I <= 5; I++ )
		{
			ADfACF.CF[1][14][I-1] = (float)_itmp118[_r++];
			}
		}
		{ static double _itmp119[] = {3069.9,1.,9.73e-12,0.9910,0.08};
		for( I=1, _r = 0; I <= 5; I++ )
		{
			ADfACF.CF[0][14][I-1] = (float)_itmp119[_r++];
			}
		}
		{ static double _itmp120[] = {10.4,1.,5.49e-08,0.1000,0.25};
		for( I=1, _r = 0; I <= 5; I++ )
		{
			ADfACF.CF[15][15][I-1] = (float)_itmp120[_r++];
			}
		}
		{ static double _itmp121[] = {23.3,1.,6.81e-08,0.6930,0.21};
		for( I=1, _r = 0; I <= 5; I++ )
		{
			ADfACF.CF[14][15][I-1] = (float)_itmp121[_r++];
			}
		}
		{ static double _itmp122[] = {34.8,1.,2.14e-08,0.3530,0.24};
		for( I=1, _r = 0; I <= 5; I++ )
		{
			ADfACF.CF[13][15][I-1] = (float)_itmp122[_r++];
			}
		}
		{ static double _itmp123[] = {47.3,1.,1.66e-08,1.0300,0.14};
		for( I=1, _r = 0; I <= 5; I++ )
		{
			ADfACF.CF[12][15][I-1] = (float)_itmp123[_r++];
			}
		}
		{ static double _itmp124[] = {72.6,1.,6.12e-09,0.5800,0.19};
		for( I=1, _r = 0; I <= 5; I++ )
		{
			ADfACF.CF[11][15][I-1] = (float)_itmp124[_r++];
			}
		}
		{ static double _itmp125[] = {88.1,1.,1.33e-09,0.0688,0.35};
		for( I=1, _r = 0; I <= 5; I++ )
		{
			ADfACF.CF[10][15][I-1] = (float)_itmp125[_r++];
			}
		}
		{ static double _itmp126[] = {280.9,0.,4.93e-09,1.1300,0.16};
		for( I=1, _r = 0; I <= 5; I++ )
		{
			ADfACF.CF[9][15][I-1] = (float)_itmp126[_r++];
			}
		}
		{ static double _itmp127[] = {328.2,1.,8.73e-10,0.1930,0.28};
		for( I=1, _r = 0; I <= 5; I++ )
		{
			ADfACF.CF[8][15][I-1] = (float)_itmp127[_r++];
			}
		}
		{ static double _itmp128[] = {379.1,0.,1.35e-09,0.4310,0.32};
		for( I=1, _r = 0; I <= 5; I++ )
		{
			ADfACF.CF[7][15][I-1] = (float)_itmp128[_r++];
			}
		}
		{ static double _itmp129[] = {447.1,1.,4.59e-10,0.2420,0.28};
		for( I=1, _r = 0; I <= 5; I++ )
		{
			ADfACF.CF[6][15][I-1] = (float)_itmp129[_r++];
			}
		}
		{ static double _itmp130[] = {504.8,1.,3.49e-10,0.3050,0.25};
		for( I=1, _r = 0; I <= 5; I++ )
		{
			ADfACF.CF[5][15][I-1] = (float)_itmp130[_r++];
			}
		}
		{ static double _itmp131[] = {564.7,0.,5.23e-10,0.4280,0.35};
		for( I=1, _r = 0; I <= 5; I++ )
		{
			ADfACF.CF[4][15][I-1] = (float)_itmp131[_r++];
			}
		}
		{ static double _itmp132[] = {651.6,0.,2.59e-10,0.8540,0.12};
		for( I=1, _r = 0; I <= 5; I++ )
		{
			ADfACF.CF[3][15][I-1] = (float)_itmp132[_r++];
			}
		}
		{ static double _itmp133[] = {707.2,1.,7.50e-11,0.7340,0.16};
		for( I=1, _r = 0; I <= 5; I++ )
		{
			ADfACF.CF[2][15][I-1] = (float)_itmp133[_r++];
			}
		}
		{ static double _itmp134[] = {3223.9,0.,2.67e-11,0.5720,0.28};
		for( I=1, _r = 0; I <= 5; I++ )
		{
			ADfACF.CF[1][15][I-1] = (float)_itmp134[_r++];
			}
		}
		{ static double _itmp135[] = {3494.2,1.,6.32e-12,0.5850,0.17};
		for( I=1, _r = 0; I <= 5; I++ )
		{
			ADfACF.CF[0][15][I-1] = (float)_itmp135[_r++];
			}
		}
		{ static double _itmp136[] = {13.0,1.,1.69e-07,0.4300,0.24};
		for( I=1, _r = 0; I <= 5; I++ )
		{
			ADfACF.CF[16][16][I-1] = (float)_itmp136[_r++];
			}
		}
		{ static double _itmp137[] = {23.8,1.,6.96e-08,0.6700,0.20};
		for( I=1, _r = 0; I <= 5; I++ )
		{
			ADfACF.CF[15][16][I-1] = (float)_itmp137[_r++];
			}
		}
		{ static double _itmp138[] = {39.6,1.,3.40e-08,0.8650,0.18};
		for( I=1, _r = 0; I <= 5; I++ )
		{
			ADfACF.CF[14][16][I-1] = (float)_itmp138[_r++];
			}
		}
		{ static double _itmp139[] = {53.5,1.,1.10e-08,0.3280,0.25};
		for( I=1, _r = 0; I <= 5; I++ )
		{
			ADfACF.CF[13][16][I-1] = (float)_itmp139[_r++];
			}
		}
		{ static double _itmp140[] = {67.8,1.,1.11e-08,1.3700,0.10};
		for( I=1, _r = 0; I <= 5; I++ )
		{
			ADfACF.CF[12][16][I-1] = (float)_itmp140[_r++];
			}
		}
		{ static double _itmp141[] = {97.0,1.,3.17e-09,0.3300,0.24};
		for( I=1, _r = 0; I <= 5; I++ )
		{
			ADfACF.CF[11][16][I-1] = (float)_itmp141[_r++];
			}
		}
		{ static double _itmp142[] = {114.2,1.,1.01e-09,0.1960,0.16};
		for( I=1, _r = 0; I <= 5; I++ )
		{
			ADfACF.CF[10][16][I-1] = (float)_itmp142[_r++];
			}
		}
		{ static double _itmp143[] = {348.3,0.,2.11e-09,0.3130,0.37};
		for( I=1, _r = 0; I <= 5; I++ )
		{
			ADfACF.CF[9][16][I-1] = (float)_itmp143[_r++];
			}
		}
		{ static double _itmp144[] = {400.1,1.,6.32e-10,0.1730,0.30};
		for( I=1, _r = 0; I <= 5; I++ )
		{
			ADfACF.CF[8][16][I-1] = (float)_itmp144[_r++];
			}
		}
		{ static double _itmp145[] = {455.6,0.,9.48e-10,0.3440,0.36};
		for( I=1, _r = 0; I <= 5; I++ )
		{
			ADfACF.CF[7][16][I-1] = (float)_itmp145[_r++];
			}
		}
		{ static double _itmp146[] = {529.3,1.,3.69e-10,0.2730,0.26};
		for( I=1, _r = 0; I <= 5; I++ )
		{
			ADfACF.CF[6][16][I-1] = (float)_itmp146[_r++];
			}
		}
		{ static double _itmp147[] = {592.0,1.,2.85e-10,0.3430,0.23};
		for( I=1, _r = 0; I <= 5; I++ )
		{
			ADfACF.CF[5][16][I-1] = (float)_itmp147[_r++];
			}
		}
		{ static double _itmp148[] = {656.7,0.,4.81e-10,0.6580,0.27};
		for( I=1, _r = 0; I <= 5; I++ )
		{
			ADfACF.CF[4][16][I-1] = (float)_itmp148[_r++];
			}
		}
		{ static double _itmp149[] = {749.8,1.,1.31e-10,0.6230,0.16};
		for( I=1, _r = 0; I <= 5; I++ )
		{
			ADfACF.CF[3][16][I-1] = (float)_itmp149[_r++];
			}
		}
		{ static double _itmp150[] = {809.4,1.,6.13e-11,0.7360,0.16};
		for( I=1, _r = 0; I <= 5; I++ )
		{
			ADfACF.CF[2][16][I-1] = (float)_itmp150[_r++];
			}
		}
		{ static double _itmp151[] = {3658.4,0.,1.90e-11,0.3790,0.36};
		for( I=1, _r = 0; I <= 5; I++ )
		{
			ADfACF.CF[1][16][I-1] = (float)_itmp151[_r++];
			}
		}
		{ static double _itmp152[] = {3946.3,1.,5.14e-12,0.5530,0.18};
		for( I=1, _r = 0; I <= 5; I++ )
		{
			ADfACF.CF[0][16][I-1] = (float)_itmp152[_r++];
			}
		}
		{ static double _itmp153[] = {15.8,1.,5.99e-08,0.1360,0.26};
		for( I=1, _r = 0; I <= 5; I++ )
		{
			ADfACF.CF[17][17][I-1] = (float)_itmp153[_r++];
			}
		}
		{ static double _itmp154[] = {27.6,1.,6.07e-08,0.5440,0.21};
		for( I=1, _r = 0; I <= 5; I++ )
		{
			ADfACF.CF[16][17][I-1] = (float)_itmp154[_r++];
			}
		}
		{ static double _itmp155[] = {40.9,1.,3.43e-08,0.8340,0.17};
		for( I=1, _r = 0; I <= 5; I++ )
		{
			ADfACF.CF[15][17][I-1] = (float)_itmp155[_r++];
			}
		}
		{ static double _itmp156[] = {52.3,0.,3.00e-08,1.0300,0.25};
		for( I=1, _r = 0; I <= 5; I++ )
		{
			ADfACF.CF[14][17][I-1] = (float)_itmp156[_r++];
			}
		}
		{ static double _itmp157[] = {75.0,1.,8.73e-09,0.3660,0.31};
		for( I=1, _r = 0; I <= 5; I++ )
		{
			ADfACF.CF[13][17][I-1] = (float)_itmp157[_r++];
			}
		}
		{ static double _itmp158[] = {91.0,1.,5.78e-09,0.3140,0.34};
		for( I=1, _r = 0; I <= 5; I++ )
		{
			ADfACF.CF[12][17][I-1] = (float)_itmp158[_r++];
			}
		}
		{ static double _itmp159[] = {124.3,1.,2.98e-09,0.7030,0.16};
		for( I=1, _r = 0; I <= 5; I++ )
		{
			ADfACF.CF[11][17][I-1] = (float)_itmp159[_r++];
			}
		}
		{ static double _itmp160[] = {143.5,1.,7.25e-10,0.2070,0.15};
		for( I=1, _r = 0; I <= 5; I++ )
		{
			ADfACF.CF[10][17][I-1] = (float)_itmp160[_r++];
			}
		}
		{ static double _itmp161[] = {422.4,1.,1.40e-09,0.6960,0.13};
		for( I=1, _r = 0; I <= 5; I++ )
		{
			ADfACF.CF[9][17][I-1] = (float)_itmp161[_r++];
			}
		}
		{ static double _itmp162[] = {478.7,1.,4.78e-10,0.1640,0.31};
		for( I=1, _r = 0; I <= 5; I++ )
		{
			ADfACF.CF[8][17][I-1] = (float)_itmp162[_r++];
			}
		}
		{ static double _itmp163[] = {539.0,0.,8.02e-10,0.4390,0.32};
		for( I=1, _r = 0; I <= 5; I++ )
		{
			ADfACF.CF[7][17][I-1] = (float)_itmp163[_r++];
			}
		}
		{ static double _itmp164[] = {618.3,1.,2.88e-10,0.2590,0.27};
		for( I=1, _r = 0; I <= 5; I++ )
		{
			ADfACF.CF[6][17][I-1] = (float)_itmp164[_r++];
			}
		}
		{ static double _itmp165[] = {686.1,1.,2.32e-10,0.3620,0.22};
		for( I=1, _r = 0; I <= 5; I++ )
		{
			ADfACF.CF[5][17][I-1] = (float)_itmp165[_r++];
			}
		}
		{ static double _itmp166[] = {755.7,0.,3.33e-10,0.4120,0.36};
		for( I=1, _r = 0; I <= 5; I++ )
		{
			ADfACF.CF[4][17][I-1] = (float)_itmp166[_r++];
			}
		}
		{ static double _itmp167[] = {854.8,1.,1.27e-10,0.9100,0.13};
		for( I=1, _r = 0; I <= 5; I++ )
		{
			ADfACF.CF[3][17][I-1] = (float)_itmp167[_r++];
			}
		}
		{ static double _itmp168[] = {918.0,1.,5.21e-11,0.7810,0.15};
		for( I=1, _r = 0; I <= 5; I++ )
		{
			ADfACF.CF[2][17][I-1] = (float)_itmp168[_r++];
			}
		}
		{ static double _itmp169[] = {4120.7,0.,1.66e-11,0.4350,0.33};
		for( I=1, _r = 0; I <= 5; I++ )
		{
			ADfACF.CF[1][17][I-1] = (float)_itmp169[_r++];
			}
		}
		{ static double _itmp170[] = {4426.2,1.,4.32e-12,0.5540,0.18};
		for( I=1, _r = 0; I <= 5; I++ )
		{
			ADfACF.CF[0][17][I-1] = (float)_itmp170[_r++];
			}
		}
		{ static double _itmp171[] = {4.3,1.,2.02e-07,0.2720,0.31};
		for( I=1, _r = 0; I <= 5; I++ )
		{
			ADfACF.CF[18][18][I-1] = (float)_itmp171[_r++];
			}
		}
		{ static double _itmp172[] = {31.6,1.,4.01e-08,0.3710,0.22};
		for( I=1, _r = 0; I <= 5; I++ )
		{
			ADfACF.CF[17][18][I-1] = (float)_itmp172[_r++];
			}
		}
		{ static double _itmp173[] = {45.8,1.,1.50e-08,0.4330,0.21};
		for( I=1, _r = 0; I <= 5; I++ )
		{
			ADfACF.CF[16][18][I-1] = (float)_itmp173[_r++];
			}
		}
		{ static double _itmp174[] = {60.9,1.,1.94e-08,0.8890,0.16};
		for( I=1, _r = 0; I <= 5; I++ )
		{
			ADfACF.CF[15][18][I-1] = (float)_itmp174[_r++];
			}
		}
		{ static double _itmp175[] = {82.7,1.,6.95e-09,0.4940,0.18};
		for( I=1, _r = 0; I <= 5; I++ )
		{
			ADfACF.CF[14][18][I-1] = (float)_itmp175[_r++];
			}
		}
		{ static double _itmp176[] = {99.4,1.,4.11e-09,0.5400,0.17};
		for( I=1, _r = 0; I <= 5; I++ )
		{
			ADfACF.CF[13][18][I-1] = (float)_itmp176[_r++];
			}
		}
		{ static double _itmp177[] = {117.6,1.,2.23e-09,0.5190,0.16};
		for( I=1, _r = 0; I <= 5; I++ )
		{
			ADfACF.CF[12][18][I-1] = (float)_itmp177[_r++];
			}
		}
		{ static double _itmp178[] = {154.7,1.,2.15e-09,0.8280,0.14};
		for( I=1, _r = 0; I <= 5; I++ )
		{
			ADfACF.CF[11][18][I-1] = (float)_itmp178[_r++];
			}
		}
		{ static double _itmp179[] = {175.8,0.,1.61e-09,0.6420,0.13};
		for( I=1, _r = 0; I <= 5; I++ )
		{
			ADfACF.CF[10][18][I-1] = (float)_itmp179[_r++];
			}
		}
		{ static double _itmp180[] = {504.0,1.,1.07e-09,0.6950,0.13};
		for( I=1, _r = 0; I <= 5; I++ )
		{
			ADfACF.CF[9][18][I-1] = (float)_itmp180[_r++];
			}
		}
		{ static double _itmp181[] = {564.7,1.,3.78e-10,0.1730,0.30};
		for( I=1, _r = 0; I <= 5; I++ )
		{
			ADfACF.CF[8][18][I-1] = (float)_itmp181[_r++];
			}
		}
		{ static double _itmp182[] = {629.4,0.,6.24e-10,0.4180,0.33};
		for( I=1, _r = 0; I <= 5; I++ )
		{
			ADfACF.CF[7][18][I-1] = (float)_itmp182[_r++];
			}
		}
		{ static double _itmp183[] = {714.6,1.,2.29e-10,0.2450,0.28};
		for( I=1, _r = 0; I <= 5; I++ )
		{
			ADfACF.CF[6][18][I-1] = (float)_itmp183[_r++];
			}
		}
		{ static double _itmp184[] = {786.6,1.,1.86e-10,0.3440,0.23};
		for( I=1, _r = 0; I <= 5; I++ )
		{
			ADfACF.CF[5][18][I-1] = (float)_itmp184[_r++];
			}
		}
		{ static double _itmp185[] = {861.1,0.,2.69e-10,0.3960,0.37};
		for( I=1, _r = 0; I <= 5; I++ )
		{
			ADfACF.CF[4][18][I-1] = (float)_itmp185[_r++];
			}
		}
		{ static double _itmp186[] = {968.0,1.,1.06e-10,0.9120,0.13};
		for( I=1, _r = 0; I <= 5; I++ )
		{
			ADfACF.CF[3][18][I-1] = (float)_itmp186[_r++];
			}
		}
		{ static double _itmp187[] = {1053.4,1.,4.24e-11,0.7370,0.16};
		for( I=1, _r = 0; I <= 5; I++ )
		{
			ADfACF.CF[2][18][I-1] = (float)_itmp187[_r++];
			}
		}
		{ static double _itmp188[] = {4610.9,0.,1.38e-11,0.4160,0.34};
		for( I=1, _r = 0; I <= 5; I++ )
		{
			ADfACF.CF[1][18][I-1] = (float)_itmp188[_r++];
			}
		}
		{ static double _itmp189[] = {4934.1,1.,3.67e-12,0.5550,0.18};
		for( I=1, _r = 0; I <= 5; I++ )
		{
			ADfACF.CF[0][18][I-1] = (float)_itmp189[_r++];
			}
		}
		{ static double _itmp190[] = {6.1,0.,4.40e-07,0.8480,0.33};
		for( I=1, _r = 0; I <= 5; I++ )
		{
			ADfACF.CF[19][19][I-1] = (float)_itmp190[_r++];
			}
		}
		{ static double _itmp191[] = {11.9,0.,5.22e-08,0.1510,0.34};
		for( I=1, _r = 0; I <= 5; I++ )
		{
			ADfACF.CF[18][19][I-1] = (float)_itmp191[_r++];
			}
		}
		{ static double _itmp192[] = {50.9,1.,2.06e-08,0.4180,0.20};
		for( I=1, _r = 0; I <= 5; I++ )
		{
			ADfACF.CF[17][19][I-1] = (float)_itmp192[_r++];
			}
		}
		{ static double _itmp193[] = {67.3,1.,1.72e-08,0.6380,0.19};
		for( I=1, _r = 0; I <= 5; I++ )
		{
			ADfACF.CF[16][19][I-1] = (float)_itmp193[_r++];
			}
		}
		{ static double _itmp194[] = {84.5,1.,1.26e-08,1.0100,0.14};
		for( I=1, _r = 0; I <= 5; I++ )
		{
			ADfACF.CF[15][19][I-1] = (float)_itmp194[_r++];
			}
		}
		{ static double _itmp195[] = {108.8,1.,4.72e-09,0.5260,0.17};
		for( I=1, _r = 0; I <= 5; I++ )
		{
			ADfACF.CF[14][19][I-1] = (float)_itmp195[_r++];
			}
		}
		{ static double _itmp196[] = {127.2,1.,2.89e-09,0.5480,0.17};
		for( I=1, _r = 0; I <= 5; I++ )
		{
			ADfACF.CF[13][19][I-1] = (float)_itmp196[_r++];
			}
		}
		{ static double _itmp197[] = {147.2,1.,1.64e-09,0.5520,0.15};
		for( I=1, _r = 0; I <= 5; I++ )
		{
			ADfACF.CF[12][19][I-1] = (float)_itmp197[_r++];
			}
		}
		{ static double _itmp198[] = {188.3,1.,1.57e-09,0.7990,0.14};
		for( I=1, _r = 0; I <= 5; I++ )
		{
			ADfACF.CF[11][19][I-1] = (float)_itmp198[_r++];
			}
		}
		{ static double _itmp199[] = {211.3,1.,4.32e-10,0.2320,0.14};
		for( I=1, _r = 0; I <= 5; I++ )
		{
			ADfACF.CF[10][19][I-1] = (float)_itmp199[_r++];
			}
		}
		{ static double _itmp200[] = {591.9,0.,9.47e-10,0.3110,0.38};
		for( I=1, _r = 0; I <= 5; I++ )
		{
			ADfACF.CF[9][19][I-1] = (float)_itmp200[_r++];
			}
		}
		{ static double _itmp201[] = {657.2,1.,2.98e-10,0.1630,0.31};
		for( I=1, _r = 0; I <= 5; I++ )
		{
			ADfACF.CF[8][19][I-1] = (float)_itmp201[_r++];
			}
		}
		{ static double _itmp202[] = {726.6,0.,4.78e-10,0.3590,0.36};
		for( I=1, _r = 0; I <= 5; I++ )
		{
			ADfACF.CF[7][19][I-1] = (float)_itmp202[_r++];
			}
		}
		{ static double _itmp203[] = {817.6,1.,1.86e-10,0.2440,0.28};
		for( I=1, _r = 0; I <= 5; I++ )
		{
			ADfACF.CF[6][19][I-1] = (float)_itmp203[_r++];
			}
		}
		{ static double _itmp204[] = {894.5,1.,1.56e-10,0.3640,0.22};
		for( I=1, _r = 0; I <= 5; I++ )
		{
			ADfACF.CF[5][19][I-1] = (float)_itmp204[_r++];
			}
		}
		{ static double _itmp205[] = {974.0,0.,2.16e-10,0.3570,0.39};
		for( I=1, _r = 0; I <= 5; I++ )
		{
			ADfACF.CF[4][19][I-1] = (float)_itmp205[_r++];
			}
		}
		{ static double _itmp206[] = {1087.0,1.,7.70e-11,0.6550,0.15};
		for( I=1, _r = 0; I <= 5; I++ )
		{
			ADfACF.CF[3][19][I-1] = (float)_itmp206[_r++];
			}
		}
		{ static double _itmp207[] = {1157.0,1.,3.58e-11,0.7360,0.16};
		for( I=1, _r = 0; I <= 5; I++ )
		{
			ADfACF.CF[2][19][I-1] = (float)_itmp207[_r++];
			}
		}
		{ static double _itmp208[] = {5128.9,0.,1.28e-11,0.5200,0.30};
		for( I=1, _r = 0; I <= 5; I++ )
		{
			ADfACF.CF[1][19][I-1] = (float)_itmp208[_r++];
			}
		}
		{ static double _itmp209[] = {5469.9,1.,3.08e-12,0.5280,0.19};
		for( I=1, _r = 0; I <= 5; I++ )
		{
			ADfACF.CF[0][19][I-1] = (float)_itmp209[_r++];
			}
		}
		{ static double _itmp210[] = {6.6,1.,3.16e-07,0.2040,0.28};
		for( I=1, _r = 0; I <= 5; I++ )
		{
			ADfACF.CF[20][20][I-1] = (float)_itmp210[_r++];
			}
		}
		{ static double _itmp211[] = {12.8,1.,8.61e-08,0.1810,0.25};
		for( I=1, _r = 0; I <= 5; I++ )
		{
			ADfACF.CF[19][20][I-1] = (float)_itmp211[_r++];
			}
		}
		{ static double _itmp212[] = {24.8,1.,5.08e-08,0.3570,0.24};
		for( I=1, _r = 0; I <= 5; I++ )
		{
			ADfACF.CF[18][20][I-1] = (float)_itmp212[_r++];
			}
		}
		{ static double _itmp213[] = {73.5,1.,1.00e-08,0.4530,0.15};
		for( I=1, _r = 0; I <= 5; I++ )
		{
			ADfACF.CF[17][20][I-1] = (float)_itmp213[_r++];
			}
		}
		{ static double _itmp214[] = {91.9,1.,6.76e-09,0.4600,0.15};
		for( I=1, _r = 0; I <= 5; I++ )
		{
			ADfACF.CF[16][20][I-1] = (float)_itmp214[_r++];
			}
		}
}
void cfitdata2()
{
		{ static double _itmp215[] = {110.7,1.,5.27e-09,0.5610,0.17};
		for( I=1, _r = 0; I <= 5; I++ )
		{
			ADfACF.CF[15][20][I-1] = (float)_itmp215[_r++];
			}
		}
		{ static double _itmp216[] = {138.0,1.,3.40e-09,0.5600,0.16};
		for( I=1, _r = 0; I <= 5; I++ )
		{
			ADfACF.CF[14][20][I-1] = (float)_itmp216[_r++];
			}
		}
		{ static double _itmp217[] = {158.1,1.,2.18e-09,0.6120,0.15};
		for( I=1, _r = 0; I <= 5; I++ )
		{
			ADfACF.CF[13][20][I-1] = (float)_itmp217[_r++];
			}
		}
		{ static double _itmp218[] = {180.0,1.,1.26e-09,0.6100,0.14};
		for( I=1, _r = 0; I <= 5; I++ )
		{
			ADfACF.CF[12][20][I-1] = (float)_itmp218[_r++];
			}
		}
		{ static double _itmp219[] = {225.1,1.,1.24e-09,0.8520,0.13};
		for( I=1, _r = 0; I <= 5; I++ )
		{
			ADfACF.CF[11][20][I-1] = (float)_itmp219[_r++];
			}
		}
		{ static double _itmp220[] = {249.8,1.,3.62e-10,0.3490,0.05};
		for( I=1, _r = 0; I <= 5; I++ )
		{
			ADfACF.CF[10][20][I-1] = (float)_itmp220[_r++];
			}
		}
		{ static double _itmp221[] = {687.4,1.,5.52e-10,0.3750,0.28};
		for( I=1, _r = 0; I <= 5; I++ )
		{
			ADfACF.CF[9][20][I-1] = (float)_itmp221[_r++];
			}
		}
		{ static double _itmp222[] = {756.7,1.,5.64e-10,0.8730,0.15};
		for( I=1, _r = 0; I <= 5; I++ )
		{
			ADfACF.CF[8][20][I-1] = (float)_itmp222[_r++];
			}
		}
		{ static double _itmp223[] = {830.8,1.,4.50e-10,1.0500,0.13};
		for( I=1, _r = 0; I <= 5; I++ )
		{
			ADfACF.CF[7][20][I-1] = (float)_itmp223[_r++];
			}
		}
		{ static double _itmp224[] = {927.5,1.,2.73e-10,0.8660,0.15};
		for( I=1, _r = 0; I <= 5; I++ )
		{
			ADfACF.CF[6][20][I-1] = (float)_itmp224[_r++];
			}
		}
		{ static double _itmp225[] = {1009.0,1.,1.56e-10,0.7150,0.17};
		for( I=1, _r = 0; I <= 5; I++ )
		{
			ADfACF.CF[5][20][I-1] = (float)_itmp225[_r++];
			}
		}
		{ static double _itmp226[] = {1094.0,0.,1.81e-10,1.1400,0.36};
		for( I=1, _r = 0; I <= 5; I++ )
		{
			ADfACF.CF[4][20][I-1] = (float)_itmp226[_r++];
			}
		}
		{ static double _itmp227[] = {1213.0,1.,4.29e-11,0.7840,0.15};
		for( I=1, _r = 0; I <= 5; I++ )
		{
			ADfACF.CF[3][20][I-1] = (float)_itmp227[_r++];
			}
		}
		{ static double _itmp228[] = {1288.0,0.,2.21e-11,0.0270,0.82};
		for( I=1, _r = 0; I <= 5; I++ )
		{
			ADfACF.CF[2][20][I-1] = (float)_itmp228[_r++];
			}
		}
		{ static double _itmp229[] = {5674.9,1.,4.51e-12,0.9180,0.04};
		for( I=1, _r = 0; I <= 5; I++ )
		{
			ADfACF.CF[1][20][I-1] = (float)_itmp229[_r++];
			}
		}
		{ static double _itmp230[] = {6033.8,0.,2.03e-12,0.0170,0.70};
		for( I=1, _r = 0; I <= 5; I++ )
		{
			ADfACF.CF[0][20][I-1] = (float)_itmp230[_r++];
			}
		}
		{ static double _itmp231[] = {6.8,1.,1.60e-07,0.3600,0.28};
		for( I=1, _r = 0; I <= 5; I++ )
		{
			ADfACF.CF[21][21][I-1] = (float)_itmp231[_r++];
			}
		}
		{ static double _itmp232[] = {13.6,0.,2.14e-07,0.8800,0.28};
		for( I=1, _r = 0; I <= 5; I++ )
		{
			ADfACF.CF[20][21][I-1] = (float)_itmp232[_r++];
			}
		}
		{ static double _itmp233[] = {27.5,1.,2.85e-08,0.2270,0.21};
		for( I=1, _r = 0; I <= 5; I++ )
		{
			ADfACF.CF[19][21][I-1] = (float)_itmp233[_r++];
			}
		}
		{ static double _itmp234[] = {43.3,1.,3.48e-08,0.3900,0.23};
		for( I=1, _r = 0; I <= 5; I++ )
		{
			ADfACF.CF[18][21][I-1] = (float)_itmp234[_r++];
			}
		}
		{ static double _itmp235[] = {99.3,1.,1.00e-08,0.5790,0.18};
		for( I=1, _r = 0; I <= 5; I++ )
		{
			ADfACF.CF[17][21][I-1] = (float)_itmp235[_r++];
			}
		}
		{ static double _itmp236[] = {119.5,1.,7.01e-09,0.6380,0.17};
		for( I=1, _r = 0; I <= 5; I++ )
		{
			ADfACF.CF[16][21][I-1] = (float)_itmp236[_r++];
			}
		}
		{ static double _itmp237[] = {140.8,1.,4.95e-09,0.7170,0.16};
		for( I=1, _r = 0; I <= 5; I++ )
		{
			ADfACF.CF[15][21][I-1] = (float)_itmp237[_r++];
			}
		}
		{ static double _itmp238[] = {170.4,1.,2.99e-09,0.6930,0.17};
		for( I=1, _r = 0; I <= 5; I++ )
		{
			ADfACF.CF[14][21][I-1] = (float)_itmp238[_r++];
			}
		}
		{ static double _itmp239[] = {192.1,1.,2.10e-09,0.7220,0.16};
		for( I=1, _r = 0; I <= 5; I++ )
		{
			ADfACF.CF[13][21][I-1] = (float)_itmp239[_r++];
			}
		}
		{ static double _itmp240[] = {215.9,1.,1.62e-09,0.7650,0.14};
		for( I=1, _r = 0; I <= 5; I++ )
		{
			ADfACF.CF[12][21][I-1] = (float)_itmp240[_r++];
			}
		}
		{ static double _itmp241[] = {265.0,1.,1.11e-09,0.8850,0.12};
		for( I=1, _r = 0; I <= 5; I++ )
		{
			ADfACF.CF[11][21][I-1] = (float)_itmp241[_r++];
			}
		}
		{ static double _itmp242[] = {291.5,0.,9.09e-10,0.9720,0.06};
		for( I=1, _r = 0; I <= 5; I++ )
		{
			ADfACF.CF[10][21][I-1] = (float)_itmp242[_r++];
			}
		}
		{ static double _itmp243[] = {787.8,1.,4.41e-10,0.3590,0.29};
		for( I=1, _r = 0; I <= 5; I++ )
		{
			ADfACF.CF[9][21][I-1] = (float)_itmp243[_r++];
			}
		}
		{ static double _itmp244[] = {863.1,1.,4.39e-10,0.7810,0.17};
		for( I=1, _r = 0; I <= 5; I++ )
		{
			ADfACF.CF[8][21][I-1] = (float)_itmp244[_r++];
			}
		}
		{ static double _itmp245[] = {941.9,1.,3.73e-10,1.0500,0.13};
		for( I=1, _r = 0; I <= 5; I++ )
		{
			ADfACF.CF[7][21][I-1] = (float)_itmp245[_r++];
			}
		}
		{ static double _itmp246[] = {1044.0,1.,2.28e-10,0.8580,0.15};
		for( I=1, _r = 0; I <= 5; I++ )
		{
			ADfACF.CF[6][21][I-1] = (float)_itmp246[_r++];
			}
		}
		{ static double _itmp247[] = {1131.0,1.,1.34e-10,0.7570,0.16};
		for( I=1, _r = 0; I <= 5; I++ )
		{
			ADfACF.CF[5][21][I-1] = (float)_itmp247[_r++];
			}
		}
		{ static double _itmp248[] = {1221.0,0.,1.55e-10,1.1500,0.36};
		for( I=1, _r = 0; I <= 5; I++ )
		{
			ADfACF.CF[4][21][I-1] = (float)_itmp248[_r++];
			}
		}
		{ static double _itmp249[] = {1346.0,1.,3.80e-11,0.8350,0.14};
		for( I=1, _r = 0; I <= 5; I++ )
		{
			ADfACF.CF[3][21][I-1] = (float)_itmp249[_r++];
			}
		}
		{ static double _itmp250[] = {1426.0,0.,1.89e-11,0.0280,0.82};
		for( I=1, _r = 0; I <= 5; I++ )
		{
			ADfACF.CF[2][21][I-1] = (float)_itmp250[_r++];
			}
		}
		{ static double _itmp251[] = {6249.1,1.,4.01e-12,0.9680,0.03};
		for( I=1, _r = 0; I <= 5; I++ )
		{
			ADfACF.CF[1][21][I-1] = (float)_itmp251[_r++];
			}
		}
		{ static double _itmp252[] = {6625.0,1.,1.62e-12,0.6570,0.14};
		for( I=1, _r = 0; I <= 5; I++ )
		{
			ADfACF.CF[0][21][I-1] = (float)_itmp252[_r++];
			}
		}
		{ static double _itmp253[] = {6.7,0.,8.82e-07,0.3590,0.32};
		for( I=1, _r = 0; I <= 5; I++ )
		{
			ADfACF.CF[22][22][I-1] = (float)_itmp253[_r++];
			}
		}
		{ static double _itmp254[] = {14.7,0.,3.11e-07,0.4320,0.29};
		for( I=1, _r = 0; I <= 5; I++ )
		{
			ADfACF.CF[21][22][I-1] = (float)_itmp254[_r++];
			}
		}
		{ static double _itmp255[] = {29.3,1.,3.50e-08,0.2470,0.25};
		for( I=1, _r = 0; I <= 5; I++ )
		{
			ADfACF.CF[20][22][I-1] = (float)_itmp255[_r++];
			}
		}
		{ static double _itmp256[] = {46.7,0.,5.32e-08,1.1100,0.16};
		for( I=1, _r = 0; I <= 5; I++ )
		{
			ADfACF.CF[19][22][I-1] = (float)_itmp256[_r++];
			}
		}
		{ static double _itmp257[] = {65.3,1.,8.98e-09,0.1400,0.37};
		for( I=1, _r = 0; I <= 5; I++ )
		{
			ADfACF.CF[18][22][I-1] = (float)_itmp257[_r++];
			}
		}
		{ static double _itmp258[] = {128.1,1.,5.87e-09,0.5170,0.17};
		for( I=1, _r = 0; I <= 5; I++ )
		{
			ADfACF.CF[17][22][I-1] = (float)_itmp258[_r++];
			}
		}
		{ static double _itmp259[] = {150.6,1.,5.11e-09,0.6790,0.16};
		for( I=1, _r = 0; I <= 5; I++ )
		{
			ADfACF.CF[16][22][I-1] = (float)_itmp259[_r++];
			}
		}
		{ static double _itmp260[] = {173.4,1.,3.71e-09,0.7610,0.15};
		for( I=1, _r = 0; I <= 5; I++ )
		{
			ADfACF.CF[15][22][I-1] = (float)_itmp260[_r++];
			}
		}
		{ static double _itmp261[] = {205.8,1.,2.24e-09,0.7110,0.17};
		for( I=1, _r = 0; I <= 5; I++ )
		{
			ADfACF.CF[14][22][I-1] = (float)_itmp261[_r++];
			}
		}
		{ static double _itmp262[] = {230.5,1.,1.65e-09,0.7640,0.15};
		for( I=1, _r = 0; I <= 5; I++ )
		{
			ADfACF.CF[13][22][I-1] = (float)_itmp262[_r++];
			}
		}
		{ static double _itmp263[] = {256.0,1.,1.26e-09,0.7620,0.14};
		for( I=1, _r = 0; I <= 5; I++ )
		{
			ADfACF.CF[12][22][I-1] = (float)_itmp263[_r++];
			}
		}
		{ static double _itmp264[] = {308.0,1.,8.86e-10,0.8860,0.12};
		for( I=1, _r = 0; I <= 5; I++ )
		{
			ADfACF.CF[11][22][I-1] = (float)_itmp264[_r++];
			}
		}
		{ static double _itmp265[] = {336.3,0.,3.89e-10,0.1420,0.39};
		for( I=1, _r = 0; I <= 5; I++ )
		{
			ADfACF.CF[10][22][I-1] = (float)_itmp265[_r++];
			}
		}
		{ static double _itmp266[] = {896.0,1.,3.80e-10,0.4090,0.27};
		for( I=1, _r = 0; I <= 5; I++ )
		{
			ADfACF.CF[9][22][I-1] = (float)_itmp266[_r++];
			}
		}
		{ static double _itmp267[] = {976.0,0.,4.84e-10,0.1730,0.57};
		for( I=1, _r = 0; I <= 5; I++ )
		{
			ADfACF.CF[8][22][I-1] = (float)_itmp267[_r++];
			}
		}
		{ static double _itmp268[] = {1060.0,1.,2.49e-10,0.6500,0.14};
		for( I=1, _r = 0; I <= 5; I++ )
		{
			ADfACF.CF[7][22][I-1] = (float)_itmp268[_r++];
			}
		}
		{ static double _itmp269[] = {1168.0,0.,5.91e-10,1.6100,0.18};
		for( I=1, _r = 0; I <= 5; I++ )
		{
			ADfACF.CF[6][22][I-1] = (float)_itmp269[_r++];
			}
		}
		{ static double _itmp270[] = {1260.0,0.,5.02e-10,2.1200,0.15};
		for( I=1, _r = 0; I <= 5; I++ )
		{
			ADfACF.CF[5][22][I-1] = (float)_itmp270[_r++];
			}
		}
		{ static double _itmp271[] = {1355.0,1.,5.38e-11,0.1370,0.40};
		for( I=1, _r = 0; I <= 5; I++ )
		{
			ADfACF.CF[4][22][I-1] = (float)_itmp271[_r++];
			}
		}
		{ static double _itmp272[] = {1486.0,1.,5.56e-11,0.7080,0.10};
		for( I=1, _r = 0; I <= 5; I++ )
		{
			ADfACF.CF[3][22][I-1] = (float)_itmp272[_r++];
			}
		}
		{ static double _itmp273[] = {1571.0,0.,2.84e-11,0.0240,0.79};
		for( I=1, _r = 0; I <= 5; I++ )
		{
			ADfACF.CF[2][22][I-1] = (float)_itmp273[_r++];
			}
		}
		{ static double _itmp274[] = {6851.3,0.,2.54e-11,2.9200,0.09};
		for( I=1, _r = 0; I <= 5; I++ )
		{
			ADfACF.CF[1][22][I-1] = (float)_itmp274[_r++];
			}
		}
		{ static double _itmp275[] = {7246.1,0.,1.32e-11,3.5100,0.07};
		for( I=1, _r = 0; I <= 5; I++ )
		{
			ADfACF.CF[0][22][I-1] = (float)_itmp275[_r++];
			}
		}
		{ static double _itmp276[] = {6.8,1.,1.03e-07,0.2170,0.27};
		for( I=1, _r = 0; I <= 5; I++ )
		{
			ADfACF.CF[23][23][I-1] = (float)_itmp276[_r++];
			}
		}
		{ static double _itmp277[] = {16.5,0.,2.45e-07,0.3810,0.32};
		for( I=1, _r = 0; I <= 5; I++ )
		{
			ADfACF.CF[22][23][I-1] = (float)_itmp277[_r++];
			}
		}
		{ static double _itmp278[] = {31.0,0.,1.09e-07,0.5180,0.27};
		for( I=1, _r = 0; I <= 5; I++ )
		{
			ADfACF.CF[21][23][I-1] = (float)_itmp278[_r++];
			}
		}
		{ static double _itmp279[] = {49.1,1.,1.52e-08,0.1820,0.30};
		for( I=1, _r = 0; I <= 5; I++ )
		{
			ADfACF.CF[20][23][I-1] = (float)_itmp279[_r++];
			}
		}
		{ static double _itmp280[] = {69.5,0.,3.25e-08,1.3600,0.13};
		for( I=1, _r = 0; I <= 5; I++ )
		{
			ADfACF.CF[19][23][I-1] = (float)_itmp280[_r++];
			}
		}
		{ static double _itmp281[] = {90.6,1.,5.50e-09,0.1430,0.37};
		for( I=1, _r = 0; I <= 5; I++ )
		{
			ADfACF.CF[18][23][I-1] = (float)_itmp281[_r++];
			}
		}
		{ static double _itmp282[] = {160.2,1.,5.13e-09,0.6570,0.16};
		for( I=1, _r = 0; I <= 5; I++ )
		{
			ADfACF.CF[17][23][I-1] = (float)_itmp282[_r++];
			}
		}
		{ static double _itmp283[] = {184.7,1.,3.85e-09,0.7220,0.15};
		for( I=1, _r = 0; I <= 5; I++ )
		{
			ADfACF.CF[16][23][I-1] = (float)_itmp283[_r++];
			}
		}
		{ static double _itmp284[] = {209.3,1.,2.81e-09,0.7590,0.15};
		for( I=1, _r = 0; I <= 5; I++ )
		{
			ADfACF.CF[15][23][I-1] = (float)_itmp284[_r++];
			}
		}
		{ static double _itmp285[] = {244.4,1.,1.76e-09,0.7320,0.16};
		for( I=1, _r = 0; I <= 5; I++ )
		{
			ADfACF.CF[14][23][I-1] = (float)_itmp285[_r++];
			}
		}
		{ static double _itmp286[] = {271.0,1.,1.30e-09,0.7640,0.15};
		for( I=1, _r = 0; I <= 5; I++ )
		{
			ADfACF.CF[13][23][I-1] = (float)_itmp286[_r++];
			}
		}
		{ static double _itmp287[] = {298.0,1.,1.02e-09,0.8100,0.13};
		for( I=1, _r = 0; I <= 5; I++ )
		{
			ADfACF.CF[12][23][I-1] = (float)_itmp287[_r++];
			}
		}
		{ static double _itmp288[] = {354.8,1.,7.19e-10,0.8870,0.12};
		for( I=1, _r = 0; I <= 5; I++ )
		{
			ADfACF.CF[11][23][I-1] = (float)_itmp288[_r++];
			}
		}
		{ static double _itmp289[] = {384.2,1.,1.61e-10,0.1500,0.22};
		for( I=1, _r = 0; I <= 5; I++ )
		{
			ADfACF.CF[10][23][I-1] = (float)_itmp289[_r++];
			}
		}
		{ static double _itmp290[] = {1011.0,1.,4.64e-10,0.9710,0.12};
		for( I=1, _r = 0; I <= 5; I++ )
		{
			ADfACF.CF[9][23][I-1] = (float)_itmp290[_r++];
			}
		}
		{ static double _itmp291[] = {1097.0,1.,3.31e-10,0.9240,0.14};
		for( I=1, _r = 0; I <= 5; I++ )
		{
			ADfACF.CF[8][23][I-1] = (float)_itmp291[_r++];
			}
		}
		{ static double _itmp292[] = {1185.0,1.,2.49e-10,0.9310,0.15};
		for( I=1, _r = 0; I <= 5; I++ )
		{
			ADfACF.CF[7][23][I-1] = (float)_itmp292[_r++];
			}
		}
		{ static double _itmp293[] = {1299.0,1.,1.68e-10,0.9100,0.14};
		for( I=1, _r = 0; I <= 5; I++ )
		{
			ADfACF.CF[6][23][I-1] = (float)_itmp293[_r++];
			}
		}
		{ static double _itmp294[] = {1396.0,1.,1.01e-10,0.8050,0.15};
		for( I=1, _r = 0; I <= 5; I++ )
		{
			ADfACF.CF[5][23][I-1] = (float)_itmp294[_r++];
			}
		}
		{ static double _itmp295[] = {1496.0,0.,1.17e-10,1.2100,0.35};
		for( I=1, _r = 0; I <= 5; I++ )
		{
			ADfACF.CF[4][23][I-1] = (float)_itmp295[_r++];
			}
		}
		{ static double _itmp296[] = {1634.0,1.,2.91e-11,0.8840,0.13};
		for( I=1, _r = 0; I <= 5; I++ )
		{
			ADfACF.CF[3][23][I-1] = (float)_itmp296[_r++];
			}
		}
		{ static double _itmp297[] = {1721.0,0.,1.45e-11,0.0350,0.80};
		for( I=1, _r = 0; I <= 5; I++ )
		{
			ADfACF.CF[2][23][I-1] = (float)_itmp297[_r++];
			}
		}
		{ static double _itmp298[] = {7482.0,1.,3.07e-12,0.9670,0.03};
		for( I=1, _r = 0; I <= 5; I++ )
		{
			ADfACF.CF[1][23][I-1] = (float)_itmp298[_r++];
			}
		}
		{ static double _itmp299[] = {7894.8,1.,1.46e-12,0.1830,0.39};
		for( I=1, _r = 0; I <= 5; I++ )
		{
			ADfACF.CF[0][23][I-1] = (float)_itmp299[_r++];
			}
		}
		{ static double _itmp300[] = {7.4,1.,8.56e-08,0.1320,0.26};
		for( I=1, _r = 0; I <= 5; I++ )
		{
			ADfACF.CF[24][24][I-1] = (float)_itmp300[_r++];
			}
		}
		{ static double _itmp301[] = {15.6,0.,1.18e-07,0.3590,0.19};
		for( I=1, _r = 0; I <= 5; I++ )
		{
			ADfACF.CF[23][24][I-1] = (float)_itmp301[_r++];
			}
		}
		{ static double _itmp302[] = {33.7,0.,8.54e-08,0.3970,0.32};
		for( I=1, _r = 0; I <= 5; I++ )
		{
			ADfACF.CF[22][24][I-1] = (float)_itmp302[_r++];
			}
		}
		{ static double _itmp303[] = {51.2,1.,1.80e-08,0.2720,0.18};
		for( I=1, _r = 0; I <= 5; I++ )
		{
			ADfACF.CF[21][24][I-1] = (float)_itmp303[_r++];
			}
		}
		{ static double _itmp304[] = {72.4,1.,8.22e-09,0.1610,0.32};
		for( I=1, _r = 0; I <= 5; I++ )
		{
			ADfACF.CF[20][24][I-1] = (float)_itmp304[_r++];
			}
		}
		{ static double _itmp305[] = {95.0,0.,2.15e-08,1.5400,0.11};
		for( I=1, _r = 0; I <= 5; I++ )
		{
			ADfACF.CF[19][24][I-1] = (float)_itmp305[_r++];
			}
		}
		{ static double _itmp306[] = {119.3,1.,3.65e-09,0.1470,0.37};
		for( I=1, _r = 0; I <= 5; I++ )
		{
			ADfACF.CF[18][24][I-1] = (float)_itmp306[_r++];
			}
		}
		{ static double _itmp307[] = {194.5,1.,3.91e-09,0.6990,0.15};
		for( I=1, _r = 0; I <= 5; I++ )
		{
			ADfACF.CF[17][24][I-1] = (float)_itmp307[_r++];
			}
		}
		{ static double _itmp308[] = {221.8,1.,2.92e-09,0.7190,0.15};
		for( I=1, _r = 0; I <= 5; I++ )
		{
			ADfACF.CF[16][24][I-1] = (float)_itmp308[_r++];
			}
		}
		{ static double _itmp309[] = {248.3,1.,2.23e-09,0.8060,0.14};
		for( I=1, _r = 0; I <= 5; I++ )
		{
			ADfACF.CF[15][24][I-1] = (float)_itmp309[_r++];
			}
		}
		{ static double _itmp310[] = {286.0,1.,1.39e-09,0.7350,0.16};
		for( I=1, _r = 0; I <= 5; I++ )
		{
			ADfACF.CF[14][24][I-1] = (float)_itmp310[_r++];
			}
		}
		{ static double _itmp311[] = {314.4,1.,1.04e-09,0.7610,0.15};
		for( I=1, _r = 0; I <= 5; I++ )
		{
			ADfACF.CF[13][24][I-1] = (float)_itmp311[_r++];
			}
		}
		{ static double _itmp312[] = {343.6,1.,8.28e-10,0.8090,0.13};
		for( I=1, _r = 0; I <= 5; I++ )
		{
			ADfACF.CF[12][24][I-1] = (float)_itmp312[_r++];
			}
		}
		{ static double _itmp313[] = {403.0,1.,5.60e-10,0.7870,0.14};
		for( I=1, _r = 0; I <= 5; I++ )
		{
			ADfACF.CF[11][24][I-1] = (float)_itmp313[_r++];
			}
		}
		{ static double _itmp314[] = {435.2,1.,1.52e-10,0.2990,0.08};
		for( I=1, _r = 0; I <= 5; I++ )
		{
			ADfACF.CF[10][24][I-1] = (float)_itmp314[_r++];
			}
		}
		{ static double _itmp315[] = {1133.0,1.,4.03e-10,1.0400,0.11};
		for( I=1, _r = 0; I <= 5; I++ )
		{
			ADfACF.CF[9][24][I-1] = (float)_itmp315[_r++];
			}
		}
		{ static double _itmp316[] = {1244.0,1.,2.74e-10,0.9230,0.14};
		for( I=1, _r = 0; I <= 5; I++ )
		{
			ADfACF.CF[8][24][I-1] = (float)_itmp316[_r++];
			}
		}
		{ static double _itmp317[] = {1317.0,1.,2.18e-10,0.9900,0.14};
		for( I=1, _r = 0; I <= 5; I++ )
		{
			ADfACF.CF[7][24][I-1] = (float)_itmp317[_r++];
			}
		}
		{ static double _itmp318[] = {1437.0,1.,1.49e-10,0.9680,0.13};
		for( I=1, _r = 0; I <= 5; I++ )
		{
			ADfACF.CF[6][24][I-1] = (float)_itmp318[_r++];
			}
		}
		{ static double _itmp319[] = {1539.0,1.,8.70e-11,0.8020,0.15};
		for( I=1, _r = 0; I <= 5; I++ )
		{
			ADfACF.CF[5][24][I-1] = (float)_itmp319[_r++];
			}
		}
		{ static double _itmp320[] = {1644.0,0.,1.02e-10,1.2200,0.35};
		for( I=1, _r = 0; I <= 5; I++ )
		{
			ADfACF.CF[4][24][I-1] = (float)_itmp320[_r++];
			}
		}
		{ static double _itmp321[] = {1788.0,1.,2.54e-11,0.8830,0.13};
		for( I=1, _r = 0; I <= 5; I++ )
		{
			ADfACF.CF[3][24][I-1] = (float)_itmp321[_r++];
			}
		}
		{ static double _itmp322[] = {1880.0,0.,1.28e-11,0.0330,0.81};
		for( I=1, _r = 0; I <= 5; I++ )
		{
			ADfACF.CF[2][24][I-1] = (float)_itmp322[_r++];
			}
		}
}
void cfitdata3()
{
		{ static double _itmp323[] = {8141.0,1.,2.77e-12,1.0100,0.02};
		for( I=1, _r = 0; I <= 5; I++ )
		{
			ADfACF.CF[1][24][I-1] = (float)_itmp323[_r++];
			}
		}
		{ static double _itmp324[] = {8571.9,1.,1.32e-12,0.2190,0.37};
		for( I=1, _r = 0; I <= 5; I++ )
		{
			ADfACF.CF[0][24][I-1] = (float)_itmp324[_r++];
			}
		}
		{ static double _itmp325[] = {7.9,0.,2.52e-07,0.7010,0.25};
		for( I=1, _r = 0; I <= 5; I++ )
		{
			ADfACF.CF[25][25][I-1] = (float)_itmp325[_r++];
			}
		}
		{ static double _itmp326[] = {16.2,1.,2.21e-08,0.0330,0.45};
		for( I=1, _r = 0; I <= 5; I++ )
		{
			ADfACF.CF[24][25][I-1] = (float)_itmp326[_r++];
			}
		}
		{ static double _itmp327[] = {30.6,0.,4.10e-08,0.3660,0.17};
		for( I=1, _r = 0; I <= 5; I++ )
		{
			ADfACF.CF[23][25][I-1] = (float)_itmp327[_r++];
			}
		}
		{ static double _itmp328[] = {54.8,0.,3.53e-08,0.2430,0.39};
		for( I=1, _r = 0; I <= 5; I++ )
		{
			ADfACF.CF[22][25][I-1] = (float)_itmp328[_r++];
			}
		}
		{ static double _itmp329[] = {75.0,1.,1.04e-08,0.2850,0.17};
		for( I=1, _r = 0; I <= 5; I++ )
		{
			ADfACF.CF[21][25][I-1] = (float)_itmp329[_r++];
			}
		}
		{ static double _itmp330[] = {99.0,1.,1.23e-08,0.4110,0.21};
		for( I=1, _r = 0; I <= 5; I++ )
		{
			ADfACF.CF[20][25][I-1] = (float)_itmp330[_r++];
			}
		}
		{ static double _itmp331[] = {125.0,1.,9.47e-09,0.4580,0.21};
		for( I=1, _r = 0; I <= 5; I++ )
		{
			ADfACF.CF[19][25][I-1] = (float)_itmp331[_r++];
			}
		}
		{ static double _itmp332[] = {151.1,1.,4.71e-09,0.2800,0.28};
		for( I=1, _r = 0; I <= 5; I++ )
		{
			ADfACF.CF[18][25][I-1] = (float)_itmp332[_r++];
			}
		}
		{ static double _itmp333[] = {233.6,1.,3.02e-09,0.6970,0.15};
		for( I=1, _r = 0; I <= 5; I++ )
		{
			ADfACF.CF[17][25][I-1] = (float)_itmp333[_r++];
			}
		}
		{ static double _itmp334[] = {262.1,1.,2.34e-09,0.7640,0.14};
		for( I=1, _r = 0; I <= 5; I++ )
		{
			ADfACF.CF[16][25][I-1] = (float)_itmp334[_r++];
			}
		}
		{ static double _itmp335[] = {290.0,1.,1.76e-09,0.8050,0.14};
		for( I=1, _r = 0; I <= 5; I++ )
		{
			ADfACF.CF[15][25][I-1] = (float)_itmp335[_r++];
			}
		}
		{ static double _itmp336[] = {331.0,1.,1.14e-09,0.7730,0.15};
		for( I=1, _r = 0; I <= 5; I++ )
		{
			ADfACF.CF[14][25][I-1] = (float)_itmp336[_r++];
			}
		}
		{ static double _itmp337[] = {361.0,1.,8.66e-10,0.8050,0.14};
		for( I=1, _r = 0; I <= 5; I++ )
		{
			ADfACF.CF[13][25][I-1] = (float)_itmp337[_r++];
			}
		}
		{ static double _itmp338[] = {392.0,1.,6.61e-10,0.7620,0.14};
		for( I=1, _r = 0; I <= 5; I++ )
		{
			ADfACF.CF[12][25][I-1] = (float)_itmp338[_r++];
			}
		}
		{ static double _itmp339[] = {457.0,1.,4.41e-10,0.6980,0.16};
		for( I=1, _r = 0; I <= 5; I++ )
		{
			ADfACF.CF[11][25][I-1] = (float)_itmp339[_r++];
			}
		}
		{ static double _itmp340[] = {489.3,1.,1.18e-10,0.2110,0.15};
		for( I=1, _r = 0; I <= 5; I++ )
		{
			ADfACF.CF[10][25][I-1] = (float)_itmp340[_r++];
			}
		}
		{ static double _itmp341[] = {1262.0,1.,3.61e-10,1.1600,0.09};
		for( I=1, _r = 0; I <= 5; I++ )
		{
			ADfACF.CF[9][25][I-1] = (float)_itmp341[_r++];
			}
		}
		{ static double _itmp342[] = {1360.0,1.,2.45e-10,0.9780,0.13};
		for( I=1, _r = 0; I <= 5; I++ )
		{
			ADfACF.CF[8][25][I-1] = (float)_itmp342[_r++];
			}
		}
		{ static double _itmp343[] = {1470.0,1.,1.87e-10,0.9880,0.14};
		for( I=1, _r = 0; I <= 5; I++ )
		{
			ADfACF.CF[7][25][I-1] = (float)_itmp343[_r++];
			}
		}
		{ static double _itmp344[] = {1582.0,1.,1.33e-10,1.0300,0.12};
		for( I=1, _r = 0; I <= 5; I++ )
		{
			ADfACF.CF[6][25][I-1] = (float)_itmp344[_r++];
			}
		}
		{ static double _itmp345[] = {1690.0,1.,7.84e-11,0.8480,0.14};
		for( I=1, _r = 0; I <= 5; I++ )
		{
			ADfACF.CF[5][25][I-1] = (float)_itmp345[_r++];
			}
		}
		{ static double _itmp346[] = {1800.0,0.,8.90e-11,1.2000,0.35};
		for( I=1, _r = 0; I <= 5; I++ )
		{
			ADfACF.CF[4][25][I-1] = (float)_itmp346[_r++];
			}
		}
		{ static double _itmp347[] = {1960.0,1.,2.29e-11,0.9360,0.12};
		for( I=1, _r = 0; I <= 5; I++ )
		{
			ADfACF.CF[3][25][I-1] = (float)_itmp347[_r++];
			}
		}
		{ static double _itmp348[] = {2046.0,0.,1.12e-11,0.0340,0.81};
		for( I=1, _r = 0; I <= 5; I++ )
		{
			ADfACF.CF[2][25][I-1] = (float)_itmp348[_r++];
			}
		}
		{ static double _itmp349[] = {8828.0,1.,2.46e-12,1.0200,0.02};
		for( I=1, _r = 0; I <= 5; I++ )
		{
			ADfACF.CF[1][25][I-1] = (float)_itmp349[_r++];
			}
		}
		{ static double _itmp350[] = {9277.7,1.,9.79e-13,0.6640,0.14};
		for( I=1, _r = 0; I <= 5; I++ )
		{
			ADfACF.CF[0][25][I-1] = (float)_itmp350[_r++];
			}
		}
		{ static double _itmp351[] = {7.9,1.,8.89e-08,0.1270,0.24};
		for( I=1, _r = 0; I <= 5; I++ )
		{
			ADfACF.CF[26][26][I-1] = (float)_itmp351[_r++];
			}
		}
		{ static double _itmp352[] = {17.1,1.,5.65e-08,0.1940,0.23};
		for( I=1, _r = 0; I <= 5; I++ )
		{
			ADfACF.CF[25][26][I-1] = (float)_itmp352[_r++];
			}
		}
		{ static double _itmp353[] = {33.5,1.,3.06e-08,0.2010,0.22};
		for( I=1, _r = 0; I <= 5; I++ )
		{
			ADfACF.CF[24][26][I-1] = (float)_itmp353[_r++];
			}
		}
		{ static double _itmp354[] = {51.3,0.,2.27e-08,0.5740,0.10};
		for( I=1, _r = 0; I <= 5; I++ )
		{
			ADfACF.CF[23][26][I-1] = (float)_itmp354[_r++];
			}
		}
		{ static double _itmp355[] = {79.5,0.,1.93e-08,0.1950,0.42};
		for( I=1, _r = 0; I <= 5; I++ )
		{
			ADfACF.CF[22][26][I-1] = (float)_itmp355[_r++];
			}
		}
		{ static double _itmp356[] = {102.0,0.,1.27e-08,0.1260,0.47};
		for( I=1, _r = 0; I <= 5; I++ )
		{
			ADfACF.CF[21][26][I-1] = (float)_itmp356[_r++];
			}
		}
		{ static double _itmp357[] = {129.0,1.,3.58e-09,0.1940,0.29};
		for( I=1, _r = 0; I <= 5; I++ )
		{
			ADfACF.CF[20][26][I-1] = (float)_itmp357[_r++];
			}
		}
		{ static double _itmp358[] = {158.0,0.,1.17e-08,1.9800,0.07};
		for( I=1, _r = 0; I <= 5; I++ )
		{
			ADfACF.CF[19][26][I-1] = (float)_itmp358[_r++];
			}
		}
		{ static double _itmp359[] = {186.1,1.,1.78e-09,0.1120,0.42};
		for( I=1, _r = 0; I <= 5; I++ )
		{
			ADfACF.CF[18][26][I-1] = (float)_itmp359[_r++];
			}
		}
		{ static double _itmp360[] = {275.0,1.,2.41e-09,0.7390,0.14};
		for( I=1, _r = 0; I <= 5; I++ )
		{
			ADfACF.CF[17][26][I-1] = (float)_itmp360[_r++];
			}
		}
		{ static double _itmp361[] = {305.0,1.,1.86e-09,0.7620,0.14};
		for( I=1, _r = 0; I <= 5; I++ )
		{
			ADfACF.CF[16][26][I-1] = (float)_itmp361[_r++];
			}
		}
		{ static double _itmp362[] = {336.0,1.,1.41e-09,0.8040,0.14};
		for( I=1, _r = 0; I <= 5; I++ )
		{
			ADfACF.CF[15][26][I-1] = (float)_itmp362[_r++];
			}
		}
		{ static double _itmp363[] = {379.0,1.,9.54e-10,0.8130,0.14};
		for( I=1, _r = 0; I <= 5; I++ )
		{
			ADfACF.CF[14][26][I-1] = (float)_itmp363[_r++];
			}
		}
		{ static double _itmp364[] = {411.0,1.,7.12e-10,0.8030,0.14};
		for( I=1, _r = 0; I <= 5; I++ )
		{
			ADfACF.CF[13][26][I-1] = (float)_itmp364[_r++];
			}
		}
		{ static double _itmp365[] = {444.0,1.,5.34e-10,0.7180,0.15};
		for( I=1, _r = 0; I <= 5; I++ )
		{
			ADfACF.CF[12][26][I-1] = (float)_itmp365[_r++];
			}
		}
		{ static double _itmp366[] = {512.0,1.,3.62e-10,0.6580,0.17};
		for( I=1, _r = 0; I <= 5; I++ )
		{
			ADfACF.CF[11][26][I-1] = (float)_itmp366[_r++];
			}
		}
		{ static double _itmp367[] = {546.6,1.,1.05e-10,0.2520,0.12};
		for( I=1, _r = 0; I <= 5; I++ )
		{
			ADfACF.CF[10][26][I-1] = (float)_itmp367[_r++];
			}
		}
		{ static double _itmp368[] = {1397.0,1.,3.10e-10,1.1700,0.09};
		for( I=1, _r = 0; I <= 5; I++ )
		{
			ADfACF.CF[9][26][I-1] = (float)_itmp368[_r++];
			}
		}
		{ static double _itmp369[] = {1486.0,1.,1.56e-10,0.5720,0.15};
		for( I=1, _r = 0; I <= 5; I++ )
		{
			ADfACF.CF[8][26][I-1] = (float)_itmp369[_r++];
			}
		}
		{ static double _itmp370[] = {1603.0,1.,1.32e-10,0.6820,0.13};
		for( I=1, _r = 0; I <= 5; I++ )
		{
			ADfACF.CF[7][26][I-1] = (float)_itmp370[_r++];
			}
		}
		{ static double _itmp371[] = {1735.0,1.,9.08e-11,0.5110,0.17};
		for( I=1, _r = 0; I <= 5; I++ )
		{
			ADfACF.CF[6][26][I-1] = (float)_itmp371[_r++];
			}
		}
		{ static double _itmp372[] = {1846.0,0.,3.45e-10,2.8400,0.11};
		for( I=1, _r = 0; I <= 5; I++ )
		{
			ADfACF.CF[5][26][I-1] = (float)_itmp372[_r++];
			}
		}
		{ static double _itmp373[] = {1962.0,1.,5.01e-11,0.7140,0.11};
		for( I=1, _r = 0; I <= 5; I++ )
		{
			ADfACF.CF[4][26][I-1] = (float)_itmp373[_r++];
			}
		}
		{ static double _itmp374[] = {2119.0,1.,1.92e-11,0.1170,0.42};
		for( I=1, _r = 0; I <= 5; I++ )
		{
			ADfACF.CF[3][26][I-1] = (float)_itmp374[_r++];
			}
		}
		{ static double _itmp375[] = {2219.0,1.,1.95e-11,1.2000,0.00};
		for( I=1, _r = 0; I <= 5; I++ )
		{
			ADfACF.CF[2][26][I-1] = (float)_itmp375[_r++];
			}
		}
		{ static double _itmp376[] = {9544.0,0.,1.68e-11,3.5200,0.05};
		for( I=1, _r = 0; I <= 5; I++ )
		{
			ADfACF.CF[1][26][I-1] = (float)_itmp376[_r++];
			}
		}
		{ static double _itmp377[] = {10012.1,1.,1.45e-12,0.6350,0.15};
		for( I=1, _r = 0; I <= 5; I++ )
		{
			ADfACF.CF[0][26][I-1] = (float)_itmp377[_r++];
			}
		}
		{ static double _itmp378[] = {7.6,0.,1.65e-07,0.4520,0.28};
		for( I=1, _r = 0; I <= 5; I++ )
		{
			ADfACF.CF[27][27][I-1] = (float)_itmp378[_r++];
			}
		}
		{ static double _itmp379[] = {18.2,0.,8.42e-08,0.6190,0.16};
		for( I=1, _r = 0; I <= 5; I++ )
		{
			ADfACF.CF[26][27][I-1] = (float)_itmp379[_r++];
			}
		}
		{ static double _itmp380[] = {35.3,1.,1.89e-08,0.2200,0.21};
		for( I=1, _r = 0; I <= 5; I++ )
		{
			ADfACF.CF[25][27][I-1] = (float)_itmp380[_r++];
			}
		}
		{ static double _itmp381[] = {54.9,1.,1.48e-08,0.2160,0.21};
		for( I=1, _r = 0; I <= 5; I++ )
		{
			ADfACF.CF[24][27][I-1] = (float)_itmp381[_r++];
			}
		}
		{ static double _itmp382[] = {76.0,0.,1.13e-08,0.5180,0.09};
		for( I=1, _r = 0; I <= 5; I++ )
		{
			ADfACF.CF[23][27][I-1] = (float)_itmp382[_r++];
			}
		}
		{ static double _itmp383[] = {108.0,0.,1.16e-08,0.1850,0.44};
		for( I=1, _r = 0; I <= 5; I++ )
		{
			ADfACF.CF[22][27][I-1] = (float)_itmp383[_r++];
			}
		}
		{ static double _itmp384[] = {133.0,0.,8.68e-09,0.1380,0.46};
		for( I=1, _r = 0; I <= 5; I++ )
		{
			ADfACF.CF[21][27][I-1] = (float)_itmp384[_r++];
			}
		}
		{ static double _itmp385[] = {162.0,1.,2.45e-09,0.1630,0.32};
		for( I=1, _r = 0; I <= 5; I++ )
		{
			ADfACF.CF[20][27][I-1] = (float)_itmp385[_r++];
			}
		}
		{ static double _itmp386[] = {193.0,0.,9.24e-09,2.2500,0.05};
		for( I=1, _r = 0; I <= 5; I++ )
		{
			ADfACF.CF[19][27][I-1] = (float)_itmp386[_r++];
			}
		}
		{ static double _itmp387[] = {225.0,0.,2.41e-09,0.0270,0.79};
		for( I=1, _r = 0; I <= 5; I++ )
		{
			ADfACF.CF[18][27][I-1] = (float)_itmp387[_r++];
			}
		}
		{ static double _itmp388[] = {321.0,1.,1.92e-09,0.7380,0.14};
		for( I=1, _r = 0; I <= 5; I++ )
		{
			ADfACF.CF[17][27][I-1] = (float)_itmp388[_r++];
			}
		}
		{ static double _itmp389[] = {352.0,1.,1.50e-09,0.7610,0.14};
		for( I=1, _r = 0; I <= 5; I++ )
		{
			ADfACF.CF[16][27][I-1] = (float)_itmp389[_r++];
			}
		}
		{ static double _itmp390[] = {384.0,1.,1.16e-09,0.8030,0.14};
		for( I=1, _r = 0; I <= 5; I++ )
		{
			ADfACF.CF[15][27][I-1] = (float)_itmp390[_r++];
			}
		}
		{ static double _itmp391[] = {430.0,1.,8.08e-10,0.8560,0.13};
		for( I=1, _r = 0; I <= 5; I++ )
		{
			ADfACF.CF[14][27][I-1] = (float)_itmp391[_r++];
			}
		}
		{ static double _itmp392[] = {464.0,1.,6.09e-10,0.8500,0.13};
		for( I=1, _r = 0; I <= 5; I++ )
		{
			ADfACF.CF[13][27][I-1] = (float)_itmp392[_r++];
			}
		}
		{ static double _itmp393[] = {499.0,1.,4.48e-10,0.7180,0.15};
		for( I=1, _r = 0; I <= 5; I++ )
		{
			ADfACF.CF[12][27][I-1] = (float)_itmp393[_r++];
			}
		}
		{ static double _itmp394[] = {571.3,1.,3.00e-10,0.6220,0.18};
		for( I=1, _r = 0; I <= 5; I++ )
		{
			ADfACF.CF[11][27][I-1] = (float)_itmp394[_r++];
			}
		}
		{ static double _itmp395[] = {607.0,1.,7.90e-11,0.1600,0.19};
		for( I=1, _r = 0; I <= 5; I++ )
		{
			ADfACF.CF[10][27][I-1] = (float)_itmp395[_r++];
			}
		}
		{ static double _itmp396[] = {1541.0,1.,2.78e-10,1.2500,0.08};
		for( I=1, _r = 0; I <= 5; I++ )
		{
			ADfACF.CF[9][27][I-1] = (float)_itmp396[_r++];
			}
		}
		{ static double _itmp397[] = {1648.0,1.,1.92e-10,1.0400,0.12};
		for( I=1, _r = 0; I <= 5; I++ )
		{
			ADfACF.CF[8][27][I-1] = (float)_itmp397[_r++];
			}
		}
		{ static double _itmp398[] = {1756.0,1.,1.51e-10,1.1100,0.12};
		for( I=1, _r = 0; I <= 5; I++ )
		{
			ADfACF.CF[7][27][I-1] = (float)_itmp398[_r++];
			}
		}
		{ static double _itmp399[] = {1894.0,1.,1.05e-10,1.0900,0.11};
		for( I=1, _r = 0; I <= 5; I++ )
		{
			ADfACF.CF[6][27][I-1] = (float)_itmp399[_r++];
			}
		}
		{ static double _itmp400[] = {2011.0,1.,6.04e-11,0.8490,0.14};
		for( I=1, _r = 0; I <= 5; I++ )
		{
			ADfACF.CF[5][27][I-1] = (float)_itmp400[_r++];
			}
		}
		{ static double _itmp401[] = {2131.0,0.,6.91e-11,1.2100,0.35};
		for( I=1, _r = 0; I <= 5; I++ )
		{
			ADfACF.CF[4][27][I-1] = (float)_itmp401[_r++];
			}
		}
		{ static double _itmp402[] = {2295.0,1.,1.84e-11,0.9910,0.11};
		for( I=1, _r = 0; I <= 5; I++ )
		{
			ADfACF.CF[3][27][I-1] = (float)_itmp402[_r++];
			}
		}
		{ static double _itmp403[] = {2399.0,0.,9.03e-12,0.0420,0.79};
		for( I=1, _r = 0; I <= 5; I++ )
		{
			ADfACF.CF[2][27][I-1] = (float)_itmp403[_r++];
			}
		}
		{ static double _itmp404[] = {10290.0,1.,2.61e-12,0.5680,0.16};
		for( I=1, _r = 0; I <= 5; I++ )
		{
			ADfACF.CF[1][27][I-1] = (float)_itmp404[_r++];
			}
		}
		{ static double _itmp405[] = {10775.3,1.,1.39e-12,0.7290,0.13};
		for( I=1, _r = 0; I <= 5; I++ )
		{
			ADfACF.CF[0][27][I-1] = (float)_itmp405[_r++];
			}
		}
		{ static double _itmp406[] = {7.7,0.,1.65e-07,0.4520,0.28};
		for( I=1, _r = 0; I <= 5; I++ )
		{
			ADfACF.CF[28][28][I-1] = (float)_itmp406[_r++];
			}
		}
		{ static double _itmp407[] = {20.3,0.,8.42e-08,0.6190,0.16};
		for( I=1, _r = 0; I <= 5; I++ )
		{
			ADfACF.CF[27][28][I-1] = (float)_itmp407[_r++];
			}
		}
		{ static double _itmp408[] = {36.8,0.,8.42e-08,0.6190,0.16};
		for( I=1, _r = 0; I <= 5; I++ )
		{
			ADfACF.CF[26][28][I-1] = (float)_itmp408[_r++];
			}
		}
		{ static double _itmp409[] = {57.4,1.,1.89e-08,0.2200,0.21};
		for( I=1, _r = 0; I <= 5; I++ )
		{
			ADfACF.CF[25][28][I-1] = (float)_itmp409[_r++];
			}
		}
		{ static double _itmp410[] = {79.9,1.,1.48e-08,0.2160,0.21};
		for( I=1, _r = 0; I <= 5; I++ )
		{
			ADfACF.CF[24][28][I-1] = (float)_itmp410[_r++];
			}
		}
		{ static double _itmp411[] = {103.0,0.,1.13e-08,0.5180,0.09};
		for( I=1, _r = 0; I <= 5; I++ )
		{
			ADfACF.CF[23][28][I-1] = (float)_itmp411[_r++];
			}
		}
		{ static double _itmp412[] = {139.0,0.,1.16e-08,0.1850,0.44};
		for( I=1, _r = 0; I <= 5; I++ )
		{
			ADfACF.CF[22][28][I-1] = (float)_itmp412[_r++];
			}
		}
		{ static double _itmp413[] = {167.0,0.,8.68e-09,0.1380,0.46};
		for( I=1, _r = 0; I <= 5; I++ )
		{
			ADfACF.CF[21][28][I-1] = (float)_itmp413[_r++];
			}
		}
		{ static double _itmp414[] = {199.0,1.,2.45e-09,0.1630,0.32};
		for( I=1, _r = 0; I <= 5; I++ )
		{
			ADfACF.CF[20][28][I-1] = (float)_itmp414[_r++];
			}
		}
		{ static double _itmp415[] = {232.0,0.,9.24e-09,2.2500,0.05};
		for( I=1, _r = 0; I <= 5; I++ )
		{
			ADfACF.CF[19][28][I-1] = (float)_itmp415[_r++];
			}
		}
		{ static double _itmp416[] = {266.1,0.,2.41e-09,0.0270,0.79};
		for( I=1, _r = 0; I <= 5; I++ )
		{
			ADfACF.CF[18][28][I-1] = (float)_itmp416[_r++];
			}
		}
		{ static double _itmp417[] = {368.8,1.,1.92e-09,0.7380,0.14};
		for( I=1, _r = 0; I <= 5; I++ )
		{
			ADfACF.CF[17][28][I-1] = (float)_itmp417[_r++];
			}
		}
		{ static double _itmp418[] = {401.0,1.,1.50e-09,0.7610,0.14};
		for( I=1, _r = 0; I <= 5; I++ )
		{
			ADfACF.CF[16][28][I-1] = (float)_itmp418[_r++];
			}
		}
		{ static double _itmp419[] = {435.0,1.,1.16e-09,0.8030,0.14};
		for( I=1, _r = 0; I <= 5; I++ )
		{
			ADfACF.CF[15][28][I-1] = (float)_itmp419[_r++];
			}
		}
		{ static double _itmp420[] = {484.0,1.,8.08e-10,0.8560,0.13};
		for( I=1, _r = 0; I <= 5; I++ )
		{
			ADfACF.CF[14][28][I-1] = (float)_itmp420[_r++];
			}
		}
		{ static double _itmp421[] = {520.0,1.,6.09e-10,0.8500,0.13};
		for( I=1, _r = 0; I <= 5; I++ )
		{
			ADfACF.CF[13][28][I-1] = (float)_itmp421[_r++];
			}
		}
		{ static double _itmp422[] = {557.0,1.,4.48e-10,0.7180,0.15};
		for( I=1, _r = 0; I <= 5; I++ )
		{
			ADfACF.CF[12][28][I-1] = (float)_itmp422[_r++];
			}
		}
		{ static double _itmp423[] = {633.0,1.,3.00e-10,0.6220,0.18};
		for( I=1, _r = 0; I <= 5; I++ )
		{
			ADfACF.CF[11][28][I-1] = (float)_itmp423[_r++];
			}
		}
		{ static double _itmp424[] = {670.6,1.,7.90e-11,0.1600,0.19};
		for( I=1, _r = 0; I <= 5; I++ )
		{
			ADfACF.CF[10][28][I-1] = (float)_itmp424[_r++];
			}
		}
		{ static double _itmp425[] = {1690.0,1.,2.78e-10,1.2500,0.08};
		for( I=1, _r = 0; I <= 5; I++ )
		{
			ADfACF.CF[9][28][I-1] = (float)_itmp425[_r++];
			}
		}
		{ static double _itmp426[] = {1793.0,1.,1.92e-10,1.0400,0.12};
		for( I=1, _r = 0; I <= 5; I++ )
		{
			ADfACF.CF[8][28][I-1] = (float)_itmp426[_r++];
			}
		}
		{ static double _itmp427[] = {1905.0,1.,1.51e-10,1.1100,0.12};
		for( I=1, _r = 0; I <= 5; I++ )
		{
			ADfACF.CF[7][28][I-1] = (float)_itmp427[_r++];
			}
		}
		{ static double _itmp428[] = {2045.0,1.,1.05e-10,1.0900,0.11};
		for( I=1, _r = 0; I <= 5; I++ )
		{
			ADfACF.CF[6][28][I-1] = (float)_itmp428[_r++];
			}
		}
		{ static double _itmp429[] = {2173.0,1.,6.04e-11,0.8490,0.14};
		for( I=1, _r = 0; I <= 5; I++ )
		{
			ADfACF.CF[5][28][I-1] = (float)_itmp429[_r++];
			}
		}
		{ static double _itmp430[] = {2298.0,0.,6.91e-11,1.2100,0.35};
		for( I=1, _r = 0; I <= 5; I++ )
		{
			ADfACF.CF[4][28][I-1] = (float)_itmp430[_r++];
			}
		}
		{ static double _itmp431[] = {2459.0,1.,1.84e-11,0.9910,0.11};
		for( I=1, _r = 0; I <= 5; I++ )
		{
			ADfACF.CF[3][28][I-1] = (float)_itmp431[_r++];
			}
		}
		{ static double _itmp432[] = {2585.0,0.,9.03e-12,0.0420,0.79};
		for( I=1, _r = 0; I <= 5; I++ )
		{
			ADfACF.CF[2][28][I-1] = (float)_itmp432[_r++];
			}
		}
		{ static double _itmp433[] = {11060.0,1.,2.61e-12,0.5680,0.16};
		for( I=1, _r = 0; I <= 5; I++ )
		{
			ADfACF.CF[1][28][I-1] = (float)_itmp433[_r++];
			}
		}
		{ static double _itmp434[] = {11570.0,1.,1.39e-12,0.7290,0.13};
		for( I=1, _r = 0; I <= 5; I++ )
		{
			ADfACF.CF[0][28][I-1] = (float)_itmp434[_r++];
			}
		}
		{ static double _itmp435[] = {9.4,0.,1.65e-07,0.4520,0.28};
		for( I=1, _r = 0; I <= 5; I++ )
		{
			ADfACF.CF[29][29][I-1] = (float)_itmp435[_r++];
			}
		}
		{ static double _itmp436[] = {18.0,0.,8.42e-08,0.6190,0.16};
		for( I=1, _r = 0; I <= 5; I++ )
		{
			ADfACF.CF[28][29][I-1] = (float)_itmp436[_r++];
			}
		}
		{ static double _itmp437[] = {39.7,0.,8.42e-08,0.6190,0.16};
		for( I=1, _r = 0; I <= 5; I++ )
		{
			ADfACF.CF[27][29][I-1] = (float)_itmp437[_r++];
			}
		}
		{ static double _itmp438[] = {59.4,0.,8.42e-08,0.6190,0.16};
		for( I=1, _r = 0; I <= 5; I++ )
		{
			ADfACF.CF[26][29][I-1] = (float)_itmp438[_r++];
			}
		}
		{ static double _itmp439[] = {82.6,1.,1.89e-08,0.2200,0.21};
		for( I=1, _r = 0; I <= 5; I++ )
		{
			ADfACF.CF[25][29][I-1] = (float)_itmp439[_r++];
			}
		}
		{ static double _itmp440[] = {108.0,1.,1.48e-08,0.2160,0.21};
		for( I=1, _r = 0; I <= 5; I++ )
		{
			ADfACF.CF[24][29][I-1] = (float)_itmp440[_r++];
			}
		}
		{ static double _itmp441[] = {136.0,0.,1.13e-08,0.5180,0.09};
		for( I=1, _r = 0; I <= 5; I++ )
		{
			ADfACF.CF[23][29][I-1] = (float)_itmp441[_r++];
			}
		}
		{ static double _itmp442[] = {175.0,0.,1.16e-08,0.1850,0.44};
		for( I=1, _r = 0; I <= 5; I++ )
		{
			ADfACF.CF[22][29][I-1] = (float)_itmp442[_r++];
			}
		}
		{ static double _itmp443[] = {203.0,0.,8.68e-09,0.1380,0.46};
		for( I=1, _r = 0; I <= 5; I++ )
		{
			ADfACF.CF[21][29][I-1] = (float)_itmp443[_r++];
			}
		}
		{ static double _itmp444[] = {238.0,1.,2.45e-09,0.1630,0.32};
		for( I=1, _r = 0; I <= 5; I++ )
		{
			ADfACF.CF[20][29][I-1] = (float)_itmp444[_r++];
			}
		}
		{ static double _itmp445[] = {274.0,0.,9.24e-09,2.2500,0.05};
		for( I=1, _r = 0; I <= 5; I++ )
		{
			ADfACF.CF[19][29][I-1] = (float)_itmp445[_r++];
			}
		}
		{ static double _itmp446[] = {310.8,0.,2.41e-09,0.0270,0.79};
		for( I=1, _r = 0; I <= 5; I++ )
		{
			ADfACF.CF[18][29][I-1] = (float)_itmp446[_r++];
			}
		}
		{ static double _itmp447[] = {419.7,1.,1.92e-09,0.7380,0.14};
		for( I=1, _r = 0; I <= 5; I++ )
		{
			ADfACF.CF[17][29][I-1] = (float)_itmp447[_r++];
			}
		}
		{ static double _itmp448[] = {454.0,1.,1.50e-09,0.7610,0.14};
		for( I=1, _r = 0; I <= 5; I++ )
		{
			ADfACF.CF[16][29][I-1] = (float)_itmp448[_r++];
			}
		}
		{ static double _itmp449[] = {490.0,1.,1.16e-09,0.8030,0.14};
		for( I=1, _r = 0; I <= 5; I++ )
		{
			ADfACF.CF[15][29][I-1] = (float)_itmp449[_r++];
			}
		}
		{ static double _itmp450[] = {542.0,1.,8.08e-10,0.8560,0.13};
		for( I=1, _r = 0; I <= 5; I++ )
		{
			ADfACF.CF[14][29][I-1] = (float)_itmp450[_r++];
			}
		}
		{ static double _itmp451[] = {579.0,1.,6.09e-10,0.8500,0.13};
		for( I=1, _r = 0; I <= 5; I++ )
		{
			ADfACF.CF[13][29][I-1] = (float)_itmp451[_r++];
			}
		}
		{ static double _itmp452[] = {619.0,1.,4.48e-10,0.7180,0.15};
		for( I=1, _r = 0; I <= 5; I++ )
		{
			ADfACF.CF[12][29][I-1] = (float)_itmp452[_r++];
			}
		}
		{ static double _itmp453[] = {698.0,1.,3.00e-10,0.6220,0.18};
		for( I=1, _r = 0; I <= 5; I++ )
		{
			ADfACF.CF[11][29][I-1] = (float)_itmp453[_r++];
			}
		}
		{ static double _itmp454[] = {737.4,1.,7.90e-11,0.1600,0.19};
		for( I=1, _r = 0; I <= 5; I++ )
		{
			ADfACF.CF[10][29][I-1] = (float)_itmp454[_r++];
			}
		}
		{ static double _itmp455[] = {1846.0,1.,2.78e-10,1.2500,0.08};
		for( I=1, _r = 0; I <= 5; I++ )
		{
			ADfACF.CF[9][29][I-1] = (float)_itmp455[_r++];
			}
		}
		{ static double _itmp456[] = {1953.0,1.,1.92e-10,1.0400,0.12};
		for( I=1, _r = 0; I <= 5; I++ )
		{
			ADfACF.CF[8][29][I-1] = (float)_itmp456[_r++];
			}
		}
		{ static double _itmp457[] = {2070.0,1.,1.51e-10,1.1100,0.12};
		for( I=1, _r = 0; I <= 5; I++ )
		{
			ADfACF.CF[7][29][I-1] = (float)_itmp457[_r++];
			}
		}
		{ static double _itmp458[] = {2216.0,1.,1.05e-10,1.0900,0.11};
		for( I=1, _r = 0; I <= 5; I++ )
		{
			ADfACF.CF[6][29][I-1] = (float)_itmp458[_r++];
			}
		}
		{ static double _itmp459[] = {2363.0,1.,6.04e-11,0.8490,0.14};
		for( I=1, _r = 0; I <= 5; I++ )
		{
			ADfACF.CF[5][29][I-1] = (float)_itmp459[_r++];
			}
		}
		{ static double _itmp460[] = {2479.0,0.,6.91e-11,1.2100,0.35};
		for( I=1, _r = 0; I <= 5; I++ )
		{
			ADfACF.CF[4][29][I-1] = (float)_itmp460[_r++];
			}
		}
		{ static double _itmp461[] = {2647.0,1.,1.84e-11,0.9910,0.11};
		for( I=1, _r = 0; I <= 5; I++ )
		{
			ADfACF.CF[3][29][I-1] = (float)_itmp461[_r++];
			}
		}
		{ static double _itmp462[] = {2780.0,0.,9.03e-12,0.0420,0.79};
		for( I=1, _r = 0; I <= 5; I++ )
		{
			ADfACF.CF[2][29][I-1] = (float)_itmp462[_r++];
			}
		}
		{ static double _itmp463[] = {11870.0,1.,2.61e-12,0.5680,0.16};
		for( I=1, _r = 0; I <= 5; I++ )
		{
			ADfACF.CF[1][29][I-1] = (float)_itmp463[_r++];
			}
		}
		{ static double _itmp464[] = {12390.0,1.,1.39e-12,0.7290,0.13};
		for( I=1, _r = 0; I <= 5; I++ )
		{
			ADfACF.CF[0][29][I-1] = (float)_itmp464[_r++];
			}
	}

#	ifdef DEBUG_FUN
	fputs( "<+>cfitdata0()\n", debug_fp );
#	endif
	/*block data for all of D Verner's collision ionization data */

#	ifdef DEBUG_FUN
	fputs( " <->cfitdata0()\n", debug_fp );
#	endif
}

