/* these headers are needed by all files */
#include <stdio.h>
#include <stdlib.h>
#include <math.h>
#include <assert.h>
#include <string.h>
#include <float.h>
#include <limits.h>

#ifdef DMALLOC
#include <dmalloc.h>
#endif

/* use special debug version of malloc for debug runs - it includes assert arg is positive */
#if defined(NDEBUG)
#	define MALLOC malloc
#else
#	define MALLOC my_malloc 
#endif

/**************************************************************************
 * all prototypes defined in this file:
 * the following are prototypes for some routines that are part of the
 * debugging process - they come and go in any particular sub.  
 * it is not necessary to declare them when used since they are defined here
 **************************************************************************/

void cdDefines(void);

/* fudge enter fudge factors, or some arbitrary number, with fudge command*/
double fudge(long int ipnt);

/*broken set flag saying that the code is broken */
void broken(void);

/*fixit set flag saying that this code needs attention, but is not broken,
 * code is in broken.c */
void fixit(void);

/*testcde set flag saying that test code is in place */
void testcode(void);

/*csphot returns photoionization cross section from opacity stage using std pointers */
double csphot(
	/* INU is array index pointing to frequency where opacity is to be evaluated
	 * on f not c scale */
	long int inu, 
	/* ITHR is pointer to threshold*/
	long int ithr, 
	/* IOFSET is offset as defined in opac0*/
	long int iofset);

/*my_malloc wrapper for MALLOC().  Returns a good pointer or dies. */
void *my_malloc( 
	size_t size /*use same type as library function MALLOC*/ 
	);

/* announce memory allocation failure and exit - put breakpoint here to find where */
#ifdef _MSC_VER
/* MS compiler directive saying that cdEXIT does not return */
__declspec(noreturn) 
#elif defined(__GNUC__)
 __attribute__ ((noreturn))
#endif
void bad_malloc(void);

/* this is limit to longest line of information that is scanned in,
 * end of line char is actually at this +1, dim of vector is this + 1 */ 
#define LINELENGTH 76

/* this is limit to number of zones that can be remembered, since establishes
 * size of several vectors.  
 * In future this should be removed, and replaced with dynamic allocation 
 * of required space, after limit to number of zones is established */
 /*#define NZLIM 600*/

/*******************************************************************
 *
 * this structure defines the main emission line class.  
 *
 * the integer indices below are counters within the array of level 1 lines
 * and they are set in MakeLevLines.  level 1 pointers occur both in this file
 * (declaration) and in CreateData where the definition occurs
 *
 *********************************************************************/
/*#define	NTA	37*/
/*
 * the definition of the EXTERN structure of the emission lines class
 */
typedef struct 
{
	/* all of these are set to dangerous values by EmLineJunk */

	/* type of redistribution function, 
	-1 complete redis Dopper core only, 
	 0 insanity
	 1 incomplete redistirbution with damping wings, 
	 2 complete redistribution with damping wings,
	*/
	int iRedisFun ;

	/* index for line within continuum array,
	 * this is on the f, not c, scale */
	int ipCont;

	 /* ion stage of element, 1 for atom, 2 ion, etc */
	int IonStg;

	 /* atomic number of element, 1 for H, 2 for He, etc */
	int nelem;

	/* line optical depth to continuum source through illuminated face */
	float TauCon ;

	/* collision rate, upper to lower */
	float ColUL;

	/* inward line optical depth, from illuminated face of cloud to current position */
	float TauIn;

	/* total line optical depth through cloud */
	float TauTot ;

	/* inward fraction of total line emission*/
	float FracInwd;

	/* continuum pumping rate (s-1) from lower to upper level, A*occ num * g_up/g_lo,
	 * this is evaluated in RTMakeStat and RTMakeWind, which are called by HydroPEsc, RTMake */
	float pump ;

	/* line intensity */
	double xIntensity ;

	/* number of photons emitted per sec in the line */
	double phots;

	/* gf value */
	float gf ;

	/* escape and destruction probs */
	float Pesc , Pdest;

	/* damp is damping constant, derived from damprel divided by line width */
	float damp, damprel ;

	/* true total opacity (cm^-1) in transition*/
	float dTau;

	/* cooling and heating due to collisional excitation */
	double cool , heat ;

	/* ratio of collisional to radiative excitation*/
	float ColOvTot ;

	/* collision strength for transition */
	float cs;

	/* wavelentgh, usually in A, used for printout */
	float WLAng;

	/* transition energy in degrees kelvin*/
	float EnergyK;

	/* transition energy in Rydberg */
	float EnergyRyd;

	/* transition energy in ergs */
	float EnergyErg;

	/* transition energy in wavenumbers */
	float EnergyWN;

	/* atomic part of line opacity per atom, divide by line width to get line center opacity per atom,
	 * multiply by PopOpc to get dTau, the true opacity (cm-1) */
	float opacity;

	/* lower and upper statistical weights */
	float gLo , gHi ;

	/* populations of lower and upper levels */
	/* >>chng 01 nov 24, from float to double, need the precision for hyperfine structure lines */
	double PopLo , PopHi;

	/* population that enters net opacity after correction for stimulated emission */
	double PopOpc ;

	/* transition prob, Einstein A upper to lower */
	float Aul ;

	/* ratio A21/(A21+C21) */
	float AovTot ;

	/* type of transition for Mewe collision strength*/
	/* in general first parameter for CS expansion*/
	/* this parameter zero indicates high quality line */
	float cs1;

	/* ots rate */
	float ots;

} EmLine;

/*********************************************************************/

/*DumpLine print various information about an emission line vector, used in debugging */
void DumpLine(EmLine * t);

/* the exit handler */
#ifdef _MSC_VER
/* MS compiler directive saying that cdEXIT does not return */
__declspec(noreturn) 
#elif defined(__GNUC__)
 __attribute__ ((noreturn))
#endif
void cdEXIT(int);

/**************************************************************************
 * these are variables and pointers for output from the code, used everywhere
 * thre is an empty ipqq.h file that used to contain this
 **************************************************************************/

/*
 * ioQQQ is the pointer to the output file itself, 
 * ioQQQ is set to stdout by default in cdInit, 
 * and is reset to anything else by calling cdOutp
 */
extern FILE *ioQQQ;

extern FILE *ioMAP;

/* we shall write errors to this file, it is set
 * to stderr in cdInit */
extern FILE* ioPrnErr; 
/* this is flag saying whether to print errors to 
 * standard error output */
extern int lgPrnErr;

/* nzone is zone counter, incremented in routine cloudy */
extern long int nzone;

/* the iteration counter, set and incremented in routine cloudy,
 * ==1 during first iteration, 2 during second, etc */
extern long int iteration;

/* following three are defined in cddefines */
/* pointers within recombination coefficient array */
/* ipRecEsc is state specific escape probability*/
extern const int ipRecEsc /*= 2*/;
/* the net, including deEXTERN struction by background and optical deepth*/
extern const int ipRecNetEsc /*= 1*/;
/* ipRecRad is state specific radiative recombination rate*/
extern const int ipRecRad /*= 0*/;

/* these specify the form of the line redistribution function */
/* partial redistribution with wings */
extern const int ipPRD; /* = 1 */
/* complete redistribution, core only, no wings, Hummer's K2 function */
extern const int ipCRD; /* = -1 */
/* complete redistribution with wings */
extern const int ipCRDW; /* = 2 */

/* some levels for hydrogenic species, defined in cddefines.c,
 * where set to 0, 1, and 2  */
extern const int ipH1s;
extern const int ipH2s;
extern const int ipH2p;

/* some levels for he-like species, defined in cddefines.c,
 * where set to 0, 1, 2, 3, and 4  */
/* some levels for he-like species, defined in cddefines.c */

/* level 1 */
extern const int ipHe1s1S;

/* level 2 */
extern const int ipHe2s3S;
extern const int ipHe2s1S;
extern const int ipHe2p3P0;
extern const int ipHe2p3P1;
extern const int ipHe2p3P2;
extern const int ipHe2p1P;

/* level 3 */
extern const int ipHe3s3S;
extern const int ipHe3s1S;
extern const int ipHe3p3P;
extern const int ipHe3d3D;
extern const int ipHe3d1D;
extern const int ipHe3p1P;

/* level 4 */
extern const int ipHe4s3S;
extern const int ipHe4s1S;
extern const int ipHe4p3P;
extern const int ipHe4d3D;
extern const int ipHe4d1D;
extern const int ipHe4f3F;
extern const int ipHe4f1F;
extern const int ipHe4p1P;

/* level 5 */
extern const int ipHe5s3S;
extern const int ipHe5s1S;
extern const int ipHe5p3P;
extern const int ipHe5d3D;
extern const int ipHe5d1D;
extern const int ipHe5f3F;
extern const int ipHe5f1F;
extern const int ipHe5g3G;
extern const int ipHe5g1G;
extern const int ipHe5p1P;

/* these are array indices for isoelectronic sequences,
 * same as element but used for array addressing to make
 * context totally clear */
extern const int ipH_LIKE/*=0*/;
extern const int ipHE_LIKE/*=1*/;

/* these are incides to some elements, defined in cddefines.c, on the C scale */
extern const int ipHYDROGEN/*=0*/;
extern const int ipHELIUM/*=1*/;
extern const int ipLITHIUM/*=2*/;
extern const int ipBERYLLIUM/*=3*/;
extern const int ipBORON/*=4*/;
extern const int ipCARBON/*=5*/;
extern const int ipNITROGEN/*=6*/;
extern const int ipOXYGEN/*=7*/;
extern const int ipFLUORINE/*=8*/;
extern const int ipNEON/*=9*/;
extern const int ipSODIUM/*=10*/;
extern const int ipMAGNESIUM/*=11*/;
extern const int ipALUMINIUM/*=12*/;
extern const int ipSILICON/*=13*/;
extern const int ipPHOSPHORUS/*=14*/;
extern const int ipSULPHUR/*=15*/;
extern const int ipCHLORINE/*=16*/;
extern const int ipARGON/*=17*/;
extern const int ipPOTASIUM/*=18*/;
extern const int ipCALCIUM/*=19*/;
extern const int ipSCANDIUM/*=20*/;
extern const int ipTITANIUM/*=21*/;
extern const int ipVANADIUM/*=22*/;
extern const int ipCHROMIUM/*=23*/;
extern const int ipMANGANESE/*=24*/;
extern const int ipIRON/*=25*/;
extern const int ipCOBALT/*=26*/;
extern const int ipNICKEL/*=27*/;
extern const int ipCOPPER/*=28*/;
extern const int ipZINC/*=29*/;

/**************************************************************************
 *
 * these are constants used to dimension several vectors
 *
 **************************************************************************/

/*
 * lmhlvl appears in dimension statements throughout the code, is hardwired
 * limit to number of levels in hydrogenic species
 *
 * since 1s is 0, 2s 1, and 2p 2, n=50 is 50, and this
 * requires 51 cells.  
 * Loops should always be from 0 to <=LMHLVL, to be parallel with iso.nLevels[ipHYDROGEN],
 * the number of levels for this run.  This means that all vectors must
 * be dimensioned LMHLVL+1
 */
/* #define	LMHLVL	50L no longer used - remove */

/* following is real limit to how many levels can be computed for
 * model hydrogen atom - this has the one extra included, so at most
 * iso.nLevels[ipHYDROGEN] can be NHYDRO_MAX_LEVEL-1 and vectors should be dim NHYDRO_MAX_LEVEL*/
#define NHYDRO_MAX_LEVEL 401L

/* This is the number of elements included in the code,
 * is used to set lengths of many vectors */
#define	LIMELM	30L

/* dimension of vector to do with number of iterations stored
 * so, this is the the most that can possibly be performed */
#define	ITRDIM	20L

/* safe, small, numbers for the float and double */
/* set something that is too small to max of quantity and SMALLFLOAT,
 * but then compare with SMALLFLOAT */
#if 0
#define BIGFLOAT 1e+35f
#define SMALLFLOAT 1e-35f
#define BIGDOUBLE 1e+300
#define SMALLDOUBLE 1e-300
#endif

#define BIGFLOAT (FLT_MAX/100.f)
#define SMALLFLOAT (FLT_MIN*100.f)
#define BIGDOUBLE (DBL_MAX/100.)
#define SMALLDOUBLE (DBL_MIN*100.)

/*
 * this is the number zero, used to trick clever compilers when 
 * dividing by it to crash program
 * there is a routine called zero - this name cannot overlap
 * definition is in 
 */
extern const double ZeroNum;

/**************************************************************************
 *
 * disable some bogus errors in the ms c compiler
 *
 **************************************************************************/

/* */
#ifdef _MSC_VER
#	pragma warning( disable : 4127 )/* disable warning that conditional expression*/
                                 /* is constant, TRUE or FALSE in if        */
#	pragma warning( disable : 4056 )/* disable bogus underflow warning in MS VS*/
#	pragma warning( disable : 4514 )/* disable "inline function removed since not used", MS VS*/
#endif
/* */

/**************************************************************************
 *
 * various macros used by the code
 *
 **************************************************************************/

/* file ptr for optional C Debug code,
 * entry and exit of each routine will go here,
 * macros enabled if compiler-set flag DEBUG_FUN is true */
#ifndef debug_fp
	extern FILE *debug_fp;	
#endif
/* */

/* will be redefined as nothing in place where variables are defined */
#define EXTERN extern 

#ifndef TorF
/* TorF(l) returns a 'T' or 'F' depending on the 'logical' expr 'l' */
/* >>chng 01 aug 06, add par, as per pvh comment */
/*#define TorF(l)	( l ? 'T' : 'F' )*/
#define TorF(l) ( (l) ? 'T' : 'F' )
#endif
/* */

#ifndef IS_ODD
/* checks whether argument is odd */
#define IS_ODD(j)	((j) & 1 )
#endif

#ifndef MIN2
/* MIN2 takes two arguments, returns the smaller of the two */
#define MIN2(a,b) (((a)<(b)) ? (a) : (b))
#endif
/* */

#ifndef MIN3
/* MIN3 takes 3 arguments, returns the smallest of the 3 */
#define MIN3(a,b,c) (MIN2(MIN2(a,b),c))
#endif
/* */

#ifndef MIN4
/* MIN2 takes 4 arguments, returns the smallest of the 4 */
#define MIN4(a,b,c,d) (MIN2(MIN2(a,b),MIN2(c,d)))
#endif
/* */

#ifndef MAX2
/* MAX2 takes two arguments, returns the larger of the two */
#define MAX2(a,b) (((a)>(b)) ? (a) : (b))
#endif
/* */

#ifndef MAX3
/* MAX3 takes 3 arguments, returns the largest of the 3 */
#define MAX3(a,b,c) (MAX2(MAX2(a,b),c))
#endif
/* */

#ifndef MAX4
/* MAX2 takes 4 arguments, returns the largest of the 4 */
#define MAX4(a,b,c,d) (MAX2(MAX2(a,b),MAX2(c,d)))
#endif
/* */

#ifndef POW2
/* POW2 takes 1 argument, and squares it */
#define POW2(a) ((a)*(a))
#endif
/* */

#ifndef POW3
/* POW3 takes 1 argument, and cubes it */
#define POW3(a) ((a)*(a)*(a))
#endif
/* */

/* macro to determine size of an array -
 * from p 22, Practice of Programming, 
 * by B.W. Kernighan & Rob Pike, Addison Wesley.
 * use: 
 * double dbug[100];
 for( i=0; i<NELEMS(dbug); i++)
  ....
 */
#ifdef NELEMS
#undef NELEMS
#endif
#define NELEMS(array) (sizeof(array)/sizeof(array[0]))

#ifndef _ERR_
#define _ERR_	-1
#endif
/* */

#ifndef TRUE
#define TRUE	1
#endif
/* */

#ifndef FALSE
#define FALSE	0
#endif
/* */

/* on some UNIX systems only the preprocessor symbol "unix"
 * is predefined (e.g. DEC alpha), on others only "__unix"
 * (e.g. Cray), and on yet others both... This ensures
 * "__unix" is allways defined on all UNIX systems.
 */
#if defined(unix) || defined(__unix__)
#ifndef __unix
#define __unix 1
#endif
#endif

/* all vendors supply predefined preprocessor symbols to
 * help identify their hardware, the following symbols will
 * be used to bracket hardware-specific code:
 *
 * Sun Sparc: __sun
 * DEC Alpha: __alpha
 * SGI Iris:  __sgi
 * HP Unix:   __hpux
 * Cray:      __cray
 * Linux PC:  __linux
 *
 * NOTE: the user should NOT define these symbols at compile time.
 */
#ifdef cray
#ifndef __cray
#define __cray 1
#endif
#endif

/*
 * a series of Cloudy service routines, used throughout code,
 *
 */

/*AnuUnit produce continuum energy in arbitrary units, ip is on C scale */
double AnuUnit(float energy);

/* print comment asking to show output to me */
void ShowMe(void);

/*total_insanity general error handler for something that cannot happen, exits */
#ifdef _MSC_VER
/* MS compiler directive saying that cdEXIT does not return */
__declspec(noreturn) 
#elif defined(__GNUC__)
 __attribute__ ((noreturn))
#endif
void total_insanity(void);

/*cap4 convert first 4 char of input line chLab into chCAP all in caps, null termination */
void cap4(
		char *chCAP ,	/* output string, cap'd first 4 char of chLab, */
	                  /* with null terminating */
		char *chLab);	/* input string ending with eol*/

/*caps convert input command line (through eol) to ALL CAPS */
void caps(char *chCard );

/*e2 second exponential integral */
double e2(double t, 
	  double tln);

/*ee1 first exponential integral */
double ee1(double x);

/* FFmtRead - thre free format reader */
double FFmtRead(char *chCard, 
	  long int *ipnt, 
	  long int last, 
	  int *lgEOL);

/*insane set flag saying that insanity has occurred */
void insane(void);

/*lgMatch determine whether match to a keyword occurs on command line,
 * return value is 0 if no match, and position of match within string if hit */
int lgMatch(char *chKey, 
	  char *chCard);

/*GetElem scans line image, finds element. returns atomic number j, on C scale */
long int GetElem( char *chCard );

/* GetQuote get any name between double quotes off command line
 * return string as chLabel, is null terminated */
void GetQuote(char *chLabel,	/* we will generate a label and stuff it here */
	      char *chCard );	/* local capd line, we will blank this out */	

/*prototype for powi function, which exists in the alpha
 * math library */
/* #ifndef __alpha
 * double powi( double , long int );
 * #endif */
/* want to define this for all cases except alphas with native os */
#if !defined(__alpha) || defined(__linux)
double powi( double , long int );
#endif

long int ipow( long, long );	/* returns:  m^n */

								/* print with 1p,e8.2 format onto stream FILE 
 * all are located in printe82.c */
void PrintE82( FILE*, double );
/* print with 1p,e8.1 format onto stream FILE */
void PrintE71( FILE*, double );
/* print with 1p,e9.3 format onto stream FILE */
void PrintE93( FILE*, double );
/* create string with val and format, to print with %s,
 * much faster than above, totally native on non-MS systems */
char *PrintEfmt(const char *fmt, double val );

/*NoNumb general error handler for no numbers on input line */
#ifdef _MSC_VER
/* MS compiler directive saying that cdEXIT does not return */
__declspec(noreturn) 
#elif defined(__GNUC__)
 __attribute__ ((noreturn))
#endif
void NoNumb(char *chCard);

/*sexp safe exponential function */
double sexp(double x);

/* floating point sign transfer */
double sign(double a,double b );		

/* >>chng 01 mar 08, remove following, and replace with next */
#if 0
#ifndef __HP_CXD_SPP /* MIN and MAX are defined on examplars */ 
#define 	MAX(a,b)	( (a) > (b) ? (a) : (b) )
#endif
#ifndef __HP_CXD_SPP
#define 	MIN(a,b)	( (a) < (b) ? (a) : (b) )
#endif
#endif

#ifndef MAX /* MIN and MAX are defined on some machines */ 
#define 	MAX(a,b)	( (a) > (b) ? (a) : (b) )
#endif
#ifndef MIN
#define 	MIN(a,b)	( (a) < (b) ? (a) : (b) )
#endif

/*long max(long,long);*/
/* Variable no. of arg definitions for max & min functs */
double vfmax( double,... );	/* FLOATING POINT MAXIMUM */
/*long vmax( long, ... );*/ 	/* LONG INTEGER MAXIMUM */
/* short vsmax(short,...);		short INTEGER MAXIMUM */
double vfmin( double,... );	/* FLOATING POINT MINIMUM */
/*long vmin( long, ... );*/ 	/* LONG INTEGER MINIMUM */
/* short vsmin(short,...);		short INTEGER MINIMUM */

/* Variable argument list terminators (used by max & min functs) */
#ifndef INT_MAX
#  include <limits.h>
#endif	/* INT_MAX */
#define IEND	(LONG_MAX-1)
#define FEND	(1.e+38-1.)


/* dbg_printf is a debug print routine that was provided by Peter Teuben,
 * as a component from his NEMO package.  It offers run-time specification
 * of the level of debugging */
void dbg_printf(int debug, const char *fmt, ...);

double qg32(			/* 32 point gaussian quadrature integration */
				double,	/* lower limit to integration */
				double,	/* upper limit to integration */
				double(*)(double)	/* pointer to routine to be integrated, arg is x val */
				);
/* declar of func, the last arg, changed from double(*)() to above,
 * seemed to fix flags that were raised */


/*spsort netlib routine to sort array returning sorted indices */
void spsort(
	  /* input array to be sorted */
	  float x[], 
	  /* number of values in x */
	  long int n, 
	  /* permutation output array */
	  long int iperm[], 
	  /* flag saying what to do - 1 sorts into increasing order, not changing
	   * the original routine */
	  int kflag, 
	  /* error condition, should be 0 */
	  int *ier);

/* generate null terminated line label from contents of line trans array */
void chIonLbl( char*, EmLine * t );

/*chLineLbl use information in line transfer arrays to generate a line label */
/* this label is null terminated */
char* chLineLbl(EmLine * t );

