#!/usr/bin/perl -w
#
# this script looks for problems in the Cloudy test suite
# it looks for botched asserts, warnings and for simulations that did not end.
# all serious errors will be reported in serious.txt
# all lines with PROBLEM will be in minor.txt
# sims that are close to an assert (but OK) are in close.txt
# those with DEBUG print statements or TestCode calls are in debug.txt
#
# execute this script from within the directory where the
# *.out files live.  The command is:
# perl checkall.pl
#

print( "\nThis script checks for problems in the output from the Cloudy test suite.\n");
print( "  It checks for three things in the simulations:\n");
print( "  1) Botched asserts or warnings:  These are serious problems.\n");
print( "  2) Whether the PROBLEM or DEBUG string were printed.\n");
print( "  3) Crashes, in which the code did not end - these are also serious problems.\n");

print( "\nLooking for botched results and warnings:");

# find "BOTCH " and "W-" strings in all the output file and write
# corresponding line into serious.txt file.
system "grep Botched  *.out >serious.txt";
system "grep W-  *.out >> serious.txt";

# if this file has non-zero length, we detected a problem
if( -s "serious.txt")
{
  print "\nWARNING! botchs or warnings were found. This is a serious problem.  \nCheck the file serious.txt for names, serious.asr for botched asserts.\n";      
  system "grep Cloudy < serious.txt ";
  system "grep botch  *.out >serious.asr";
  $lgSeriousProblems = 1;
}
else
{
  print " good, none found.\n";
  $lgSeriousProblems = 0;
}

print( "\nLooking for PROBLEM string in the output files:");
# now look for string PROBLEM, which indicates an internal problem
# during the calculation - this is not a serious problem
system "grep PROBLEM  *.out > minor.txt";
# if this file has non-zero length, we detected a problem
if( -s "minor.txt")
{
  print "\nPROBLEM string was found.  Check minor.txt for a list of names.\n";      
  print "This can occur a few times and is not a serious concern.\n";      
  $lgMinorProblems = 1;
}
else
{
   $lgMinorProblems = 0;
  print " good, none found.\n";
}

system "grep \"ChkAssert ----\" *.out > close.txt";
# if this file has non-zero length, we detected a problem
if( -s "close.txt")
{
  print "\nSome sims are close to an assert.  Check close.txt for a list of names.\n";      
  print "This is for information only, not a problem.\n";      
}

print( "\nLooking for DEBUG string or TestCode call:");
system "grep DEBUG  *.out > debug.txt";
system "grep \"Test code\"  *.out >> debug.txt";
# if this file has non-zero length, we detected a problem
if( -s "debug.txt")
{
  print "\nDEBUG string or TestCode calls were found.  Check debug.txt for names.\n";      
  $lgDebugPrint = 1;
}
else
{
   $lgDebugPrint = 0;
   print " good, none found.\n";
}
    

# ==================================================================
# check all output files to see whether they contain any assert output
# and write corresponding line into checkend.txt file.
# if size of file $o_dir/checkend.txt is zero, then program crashed.  

printf( "\nLooking for sims that crashed, grep error for crashed sims:");

$nMod = 0;
$nCrash = 0;
$lgAllOK = 1;
# loop over all input scripts
while(defined($input= glob("*.in")) )
{
	# count the number of simulations
	++$nMod;

	# form name of output file
	$output = $input;
	$output =~ s/\.in/\.out/gi;
	#check whether proper output is present 
	#system "grep 'Cloudy ends'  $output >checkend.txt";
	system "grep 'ChkAssert'  $output >checkend.txt";
	#printf( "n");

#	if zero length, code did  not end
	if(-z "checkend.txt")
	{
	   ++$nCrash;
	   #printf( STDERR "Cloudy crashed or had no asserts in:%s \n" , $output );      
	   system "echo $output: crash or no asserts >> serious.txt ";
	   $lgSeriousProblems = 1;
	   $lgAllOK = 0;
	}
}
if( $lgAllOK )
{
   print " good, none found.\n";
}
else
{
   print "Cloudy crashed in $nCrash sims.\n";
}

# check whether any sims were skipped because they were renamed *.skip
print "\nLooking for skipped sims:";
system "ls *.skip > skip.txt" ;
# skipfile will have non-zero length if *.skip returned any names
if( -s "skip.txt" )
{
   print STDERR " some skipped by renaming to .skip - list in skip.txt\n" ;
   system "echo some files were skipped by renmaing to .skip - list is in skip.txt >> checkall.txt ";
}
else
{
  print "Good: no sims were skipped.\n";
}

printf( "\n%i sims were checked.\n",$nMod);

if( $lgMinorProblems )
{
	print "Minor problems were found, this is normal, list in minor.txt\n";
}

if( $lgDebugPrint )
{
	print "DEBUG prints or TestCode calls were found, list in debug.txt\n";
}

if( $lgSeriousProblems )
{
	print "Serious problems were found. See serious.txt for summary\n ";
}
else
{
	print "The test suite was successful; you have a valid executable.\n";
}

