/* test case to vary density at constant temperature, to show how line ratios change */
/*#include "c:\projects\cloudy\current\source\cddefines.h"
#include "c:\projects\cloudy\current\source\cddrive.h"*/
#include "cddefines.h"
#include "cddrive.h"
/*int main( int argc, char *argv[] )*/
int main( void )
{
	int lgBAD ;
	double telog ;
	double hden , hdeninc;

	FILE *ioRES ;
	char chLine[100];

	/* this will be limit to the number of command chLines we can still put in */
	long int nleft;

	/* calculation's results */
	if( (ioRES = fopen("varyn.txt","w")) == NULL )
	{
		printf(" could not open collion.txt for writing.\n");
		exit(1);
	}
	fprintf(ioRES,"density\t[OII] 3726\t3729\t2471\t7323\t7332\n");

	/* the first temperature */
	telog = 4.;
	/* the increment in the temperature */
	hdeninc = 0.5;
	/* the hydrogen density that will be used */
	hden = -1.;

	/* this is limit on 32 bit double */
	while( hden < 8. )
	{
		double relint , absint ;
		/* initialize the code for this run */
		cdInit();
		cdTalk(FALSE);
		/*cdNoExec( );*/
		printf("hden %g\n",hden);
		fprintf(ioRES,"%g",hden);

		/* inputs */
		nleft = cdRead( "title vary density at constant temperature"  );

		sprintf(chLine,"hden %f ",hden);
		nleft = cdRead( chLine  );

		nleft = cdRead( "table agn "  );
		nleft = cdRead( "stop zone 1 "  );
		nleft = cdRead( "ionization parameter -3 "  );
		nleft = cdRead( "constant temperature 4 "  );
		nleft = cdRead( "normalize to \"o ii\" 3726 "  );

		sprintf(chLine,"hden %f ",hden);
		nleft = cdRead( chLine  );

		/* actually call the code */
		lgBAD = cdDrive();

		/* now get the lines */
		cdLine( "o ii" , 3726 , &relint , & absint  );
		fprintf(ioRES, "\t%e", relint );
		cdLine( "o ii" , 3729 , &relint , & absint  );
		fprintf(ioRES, "\t%e", relint );
		cdLine( "o ii" , 2471 , &relint , & absint  );
		fprintf(ioRES, "\t%e", relint );
		cdLine( "o ii" , 7323 , &relint , & absint  );
		fprintf(ioRES, "\t%e", relint );
		cdLine( "o ii" , 7332 , &relint , & absint  );
		fprintf(ioRES, "\t%e", relint );
		fprintf(ioRES, "\n");

		hden += hdeninc;
	}

	puts( "[varyn ends OK, output is varyn.txt]" );
	exit(0);
}

