/*
 * test case to show behavior of very high metals environmet going to lte
 * cloud irradiated by STE blackbody, should equilibriate
 * at continuum temperature
 * output hizlte.txt gives input continuum temperature, deduced electron temperature, error 
 */
/*#include "c:\projects\cloudy\current\source\cddefines.h"
#include "c:\projects\cloudy\current\source\cddrive.h"*/
#include "cddefines.h"
#include "cddrive.h"
/*int main( int argc, char *argv[] )*/
int main( void )
{
	int lgBAD ;
	double telog , teinc;
	double hden , te, error,BigError;

	FILE *ioRES ;
	char chLine[100];

	/* this will be limit to the number of command chLines we can still put in */
	long int nleft;

	/* calculation's results */
	ioRES = fopen("hizlte.txt","w");
	if( ioRES == NULL )
	{
		printf(" could not open collion.txt for writing.\n");
		exit(1);
	}
	fprintf(ioRES,"T(BB)\tT(equil)\terror\n");

	/* the first temperature */
	telog = 4.;
	/* the increment in the temperature */
	teinc = 0.5;
	/* the hydrogen density that will be used */
	hden = 10.;

	BigError = 0.;
	/* this is limit on 32 bit double */
	while( telog < 7.99 )
	{
		/* initialize the code for this run */
		cdInit();
		cdTalk(FALSE);
		/*cdNoExec( );*/
		printf("te %g ",telog);

		/* inputs */
		nleft = cdRead( "title high metal clouds into lte"  );

		nleft = cdRead( "iterate"  );
		nleft = cdRead( "set dr 0"  );
		nleft = cdRead( "abundances starburst 10 "  );

		sprintf(chLine,"blackbody lte %f ",telog);
		nleft = cdRead( chLine  );

		sprintf(chLine,"hden %f ",hden);
		nleft = cdRead( chLine  );
		nleft = cdRead( "stop zone 1 "  );
		sprintf(chLine,"hden %f ",hden);
		nleft = cdRead( chLine  );

		/* actually call the code */
		lgBAD = cdDrive();

		te = cdTemp_last();
		error = (pow(10.,telog)-te)/te;
		BigError = MAX2( BigError , fabs(error) );
		/*remember largest error */
		fprintf(ioRES,"%e\t%e\t%e\n", telog , log10(te) ,error);
		printf(" %g %g\n",log10(te),error );
		telog += teinc;
	}
	printf("biggest error was %g\n", BigError );
	fprintf(ioRES,"biggest error was %g\n", BigError );
	puts( "[hizlte ends OK, output is hizlte.txt]" );
	exit(0);
}
