/*main program that calls cloudy with 2 different models, called twice */
#include "cddefines.h"
#include "cddrive.h"
/*
This model runs two sets of models that are identical.  The output and results
should also be identical.  This tests that all variables have been reset within the
code.  If the results of the second calculation differ from the first then the
code has some memory of previous calculations, a bad feature if it is to be
used to compute a grid.

There are two sets of output.  The files comp4a.out and comp4b.out have the main
output from the code.  The files file1.txt and file2.txt have the punched results
files.  These files should be identical if all is well.
*/

/*int main( int argc, char *argv[] )*/
int main( void )
{
	int lgOK ;
	long int i;
	char chCard[200];

	FILE *ioOUT;

	/* this is limit to the number of command chLines we can still put in */
	long int nleft;

	if( (ioOUT = fopen("comp4a.out","w")) == NULL )
	{
		printf(" could not open comp4a.out for writing.\n");
		exit(1);
	}

	for( i=0; i<2; ++i )
	{
		/* initialize the code for this run */
		cdInit();
		cdOutp(ioOUT);
		/*this is a very simple constant temp model */
		nleft = cdRead("test " );
		nleft = cdRead("no times " );
		/* write results to either file1.txt or file2.txt */
		sprintf(chCard , "punch results column \"file%li.txt\" hide ",i+1);
		nleft = cdRead( chCard );
		lgOK = cdDrive();
		/* end of the first model */

		/* start of the second model, fully molecular */
		cdInit();
		cdOutp(ioOUT);
		nleft = cdRead("blackbody 5000 " );
		nleft = cdRead("luminosity total solar linear 2 " );
		nleft = cdRead("brems 6 " );
		nleft = cdRead("luminosity total solar log -2.7 " );
		nleft = cdRead("hden 10 " );
		nleft = cdRead("abundances ism no qheat " );
		nleft = cdRead("stop temperature 10K linear " );
		nleft = cdRead("radius 15.8  " );
		nleft = cdRead("stop zone 1 " );
		nleft = cdRead("no times " );
		/* write results to either file1.txt or file2.txt */
		sprintf(chCard , "punch results column \"file%li.txt\" hide ",i+1);
		lgOK = cdDrive();
		/* end of the second model */

		/* start of the third model */
		cdInit();
		cdOutp(ioOUT);

		/* inputs */
		nleft = cdRead( "ioniz -1 "  );
		nleft = cdRead( "sphere "  );
		nleft = cdRead( "abundances ism "  );
		nleft = cdRead( "table agn "  );
		nleft = cdRead( "hden 11 " );
		nleft = cdRead( "stop column density 19 " );
		nleft = cdRead( "stop zone 2 " );
		nleft = cdRead( "no times " );
		/* write results to either file1.txt or file2.txt */
		sprintf(chCard , "punch results column \"file%li.txt\" hide ",i+1);
		/* actually call the code */
		lgOK = cdDrive();

		/* close ioOUT, and if first time through, open new file */
		fclose(ioOUT );
		if( i==0 )
		{
			if( (ioOUT = fopen("comp4b.out","w")) == NULL )
			{
				printf(" could not open comp4b.out for writing.\n");
				exit(1);
			}
		}
	}

	printf("calculations complete, now compare comp4a.out and comp4b.out\n");

	puts( "[Stop in comp4]" );
	exit(0);
}

