/* This file is part of Cloudy and is copyright (C)1978-2006 by Gary J. Ferland
 * For conditions of distribution and use see copyright notice in license.txt */
/*wcnint initialize stack or warnings, cautions, notes */
/*warnin enter warnings at the end of the calculations into large stack */
/*notein enter a note about calculation into comment array */
/*bangin called by routine comment to enter surprise into comment stack */
/*caunin called by comment to enter caution into comment stack */
#include "cddefines.h"
#include "warnings.h"

void wcnint(void)
{

#	ifdef DEBUG_FUN
	fputs( "<+>wcnint()\n", debug_fp );
#	endif

	/* this sub is called first, to initialize the variables */
	warnings.nwarn = 0;
	warnings.ncaun = 0;
	warnings.nnote = 0;
	warnings.nbang = 0;

#	ifdef DEBUG_FUN
	fputs( " <->wcnint()\n", debug_fp );
#	endif
	return;
}

/*warnin enter warnings at the end of the calculations into large stack */
void warnin(char *chLine)
{

#	ifdef DEBUG_FUN
	fputs( "<+>warnin()\n", debug_fp );
#	endif

	if( warnings.nwarn >= LIMWCN )
	{
		static int lgFirst=TRUE;
		if( lgFirst )
			fprintf( ioQQQ, 
				" Too many warnings have been entered; increase the value of LIMWCN everywhere in the code.\n" );
		lgFirst = FALSE;
	}
	else
	{
		strcpy( warnings.chWarnln[warnings.nwarn], chLine  );
	}

	++warnings.nwarn;

#	ifdef DEBUG_FUN
	fputs( " <->warnin()\n", debug_fp );
#	endif
	return;
}

/*notein enter a note about calculation into comment array */
void notein(char *chLine)
{

#	ifdef DEBUG_FUN
	fputs( "<+>notein()\n", debug_fp );
#	endif

	if( warnings.nnote >= LIMWCN )
	{
		static int lgFirst=TRUE;
		if( lgFirst )
			fprintf( ioQQQ, 
				" Too many notes have been entered; increase the value of LIMWCN everywhere in the code.\n" );
		lgFirst = FALSE;
	}
	else
	{
		strcpy( warnings.chNoteln[warnings.nnote], chLine );
	}

	++warnings.nnote;

#	ifdef DEBUG_FUN
	fputs( " <->notein()\n", debug_fp );
#	endif
	return;
}

/*bangin called by routine comment to enter surprise into comment stack */
void bangin(char *chLine)
{

#	ifdef DEBUG_FUN
	fputs( "<+>bangin()\n", debug_fp );
#	endif

	if( warnings.nbang >= LIMWCN )
	{
		static int lgFirst=TRUE;
		if( lgFirst )
			fprintf( ioQQQ, 
				" Too many surprises have been entered; increase the value of LIMWCN everywhere in the code.\n" );
		lgFirst = FALSE;
	}
	else
	{
		strcpy( warnings.chBangln[warnings.nbang], chLine );
	}

	++warnings.nbang;

#	ifdef DEBUG_FUN
	fputs( " <->bangin()\n", debug_fp );
#	endif
	return;
}

/*caunin called by comment to enter caution into comment stack */
void caunin(char *chLine)
{

#	ifdef DEBUG_FUN
	fputs( "<+>caunin()\n", debug_fp );
#	endif

	if( warnings.ncaun >= LIMWCN )
	{
		static int lgFirst=TRUE;
		if( lgFirst )
			fprintf( ioQQQ, 
				" Too many cautions have been entered; increase the value of LIMWCN everywhere in the code.\n" );
		lgFirst = FALSE;
	}
	else
	{
		strcpy( warnings.chCaunln[warnings.ncaun], chLine );
	}

	++warnings.ncaun;

#	ifdef DEBUG_FUN
	fputs( " <->caunin()\n", debug_fp );
#	endif
	return;
}

