/* This file is part of Cloudy and is copyright (C)1978-2006 by Gary J. Ferland
 * For conditions of distribution and use see copyright notice in license.txt */
/*vary_input sets input lines to feed into cloudy in optimization runs */
#include "cddefines.h"
#include "input.h"
#include "optimize.h"
/* #include "grid.h" */

void vary_input(int *lgLimOK)
{
	long int i, 
	  np;

#	ifdef DEBUG_FUN
	fputs( "<+>vary_input()\n", debug_fp );
#	endif

	/* set up chCardSav(n) array like Gary's input file, using input
	 * variable parameters p(i), and format information held in
	 * the common block /parmv/. Results written to common /kardsv/.
	 */

	fprintf( ioQQQ, " **************************************************\n" );

	/* will be set false if limit to a variable exceeded
	 * this is returned to calling code as problem indication*/
	*lgLimOK = TRUE;

	/* echo the variable input lines for this run */
	for( i=0; i < optimize.nvary; i++ )
	{
		int lgLimitHit = FALSE;

		np = optimize.nvfpnt[i];

		/* write formatted to the character string chCardSav(np),
		 * using the format held in chVarFmt(np) */

		/* >>chng 05 aug 09, by RP, both were == change to > and < */
		/* >>chng 05 oct 28, moved test, use vparm[0][i] instead of vpused[i], PvH */
		if( optimize.vparm[0][i] < optimize.varang[i][0] ||
		    optimize.vparm[0][i] > optimize.varang[i][1] )
		{
			*lgLimOK = FALSE;
			lgLimitHit = TRUE;
		}

		optimize.vpused[i] = (float)MIN2(optimize.vparm[0][i],optimize.varang[i][1]);
		optimize.vpused[i] = (float)MAX2(optimize.vpused[i],optimize.varang[i][0]);

		/* now generate the actual command with parameter,
		 * there will be from 1 to 3 numbers on the line */
		if( optimize.nvarxt[i] == 1 )
		{
			/* case with 1 parameter */
			sprintf( input.chCardSav[np] , optimize.chVarFmt[i], optimize.vparm[0][i] );
		}

		else if( optimize.nvarxt[i] == 2 )
		{
			/* case with 2 parameters */
			sprintf( input.chCardSav[np], optimize.chVarFmt[i], optimize.vparm[0][i],
				 optimize.vparm[1][i] );
		}

		else if( optimize.nvarxt[i] == 3 )
		{
			/* case with 3 parameters */
			sprintf( input.chCardSav[np], optimize.chVarFmt[i], optimize.vparm[0][i],
				 optimize.vparm[1][i], optimize.vparm[2][i] );
		}

		else if( optimize.nvarxt[i] == 4 )
		{
			/* case with 4 parameters */
			sprintf( input.chCardSav[np], optimize.chVarFmt[i], optimize.vparm[0][i],
				 optimize.vparm[1][i], optimize.vparm[2][i], optimize.vparm[3][i] );
		}

		else if( optimize.nvarxt[i] == 5 )
		{
			/* case with 5 parameters */
			sprintf( input.chCardSav[np] , optimize.chVarFmt[i], 
				optimize.vparm[0][i], optimize.vparm[1][i] , optimize.vparm[2][i] , 
				optimize.vparm[3][i] , optimize.vparm[4][i]);
		}

		else
		{
			fprintf(ioQQQ,"The number of variable options on this line makes no sense to me5\n");
			puts( "[Stop in vary_input]" );
			cdEXIT(EXIT_FAILURE);
		}

		fprintf( ioQQQ, " %s\n", input.chCardSav[np] );
		if( lgLimitHit )
			fprintf( ioQQQ, " >>> Limit to variable exceeded.\n" );
	}


#	ifdef DEBUG_FUN
	fputs( " <->vary_input()\n", debug_fp );
#	endif
	return;
}

