/* This file is part of Cloudy and is copyright (C)1978-2006 by Gary J. Ferland
 * For conditions of distribution and use see copyright notice in license.txt */
/*lines_hydro put H-iso seq into line intensity stack */
#include "cddefines.h"
#include "radius.h"
#include "thermal.h"
#include "dense.h"
#include "lines_service.h"
#include "grainvar.h"
#include "lines.h"

void lines_grains(void)
{
	double 
	  dhtot,
	  hold;
	long i,
		nd;

#	ifdef DEBUG_FUN
	fputs( "<+>lines_grains()\n", debug_fp );
#	endif

	if( !gv.lgGrainPhysicsOn )
	{
#		ifdef DEBUG_FUN
		fputs( " <->lines_grains()\n", debug_fp );
#		endif
		return;
	}

	/* here come the grain output */
	i = StuffComment( "grains" );
	linadd( 0., (float)i , "####", 'i');

	/* find total grain heating */
	dhtot = 0.;
	for( nd=0; nd < gv.nBin; nd++ )
	{
		/* add heating due to all grain species that are included */
		dhtot += gv.bin[nd]->GasHeatPhotoEl;
	}

	/* total heating due to dust integrated over model */
	gv.TotalDustHeat += (float)(dhtot*radius.dVeff);
	/* largest fraction of local heating due to grains photo */
	gv.dphmax = MAX2((float)(dhtot/thermal.htot),gv.dphmax);
	/* largest local cooling of gas by collisions with grains */
	gv.dclmax = MAX2(gv.dclmax,(float)(gv.GasCoolColl/thermal.htot));

	/* largest relative number of electrons donated by grains */
	hold = SDIV(dense.EdenTrue);
	gv.GrnElecDonateMax = 
		(float)MAX2( gv.GrnElecDonateMax , gv.TotalEden/hold );

	/* largest relative number of electrons on grain surface */
	gv.GrnElecHoldMax = 
		(float)MAX2( gv.GrnElecHoldMax , -gv.TotalEden/hold );

	/* gas heating by grain photoionization */
	linadd(dhtot,0,"GrGH",'h');

	/* gas heating by thermionic emissions of grains */
	linadd(thermal.heating[0][25],0,"GrTH",'h');

	/* gas cooling by collisions with grains */
	linadd(MAX2(0.,gv.GasCoolColl),0,"GrGC",'c');	

	/* gas heating by collisions with grains */
	linadd(MAX2(0.,-gv.GasCoolColl),0,"GrGC",'c');	

	/* total grain heating by all sources, lines, collisions, incident continuum */
	linadd(gv.GrainHeatSum,0,"GraT",'i');

	/* grain heating by incident continuum */
	linadd(gv.GrainHeatInc,0,"GraI",'i');

	/* grain heating due to destruction of Ly alpha  */
	linadd(gv.GrainHeatLya,1216,"GraL",'i');

	/* grain heating due to collisions with gas */
	linadd(gv.GrainHeatCollSum,0,"GraC",'i');

	/* grain heating due to diffuse fields, may also have grain emission */
	linadd(gv.GrainHeatDif,0,"GraD",'i');

#	ifdef DEBUG_FUN
	fputs( " <->lines_grains()\n", debug_fp );
#	endif
	return;

}
