/* This file is part of Cloudy and is copyright (C)1978-2006 by Gary J. Ferland
 * For conditions of distribution and use see copyright notice in license.txt */
/*PrtZone print out individual zone results */
void PrtZone(void);

/*PrtContinuum print information about continuum if requested with PRINT CONTINUUM command */
void PrtContinuum(void);

/*PrtComment analyze model, generating comments on its features */
void PrtComment(void);

/*PrtFinal create final pages of printout, emission line intensities, etc */
void PrtFinal(void);

/*prt_wl write wavelength to io */
void prt_wl( FILE *io , float wavelength );

/*sprt_wl write wavelength to string - must be kept parallel with prt_wl */
void sprt_wl( char *chString , float wl );

/*PrtHeader print large block of incident continuum numbers at start, just after 
 * echoing input commands */
void PrtHeader(void);

/*prt_LineLabels punch all labels and wavelengths for emission line array */
void prt_LineLabels(FILE * io);

/*prtmet print all line optical depths at end of iteration */
void prtmet(void);

/*prme print heavy element line optical depths at end of calculation */
void prme(
  const char *chDoIt, 
  EmLine * t);

/*PrtMeanIon print mean ionization fractions for all elements,
 * output will go to stream pointed to by arguement  
 * chTyp is either 'i' or 't' for mean ionization or tempeature */
void PrtMeanIon( char chType , 
			/* TRUE include density, FALSE do not */
			int lgDensity,
			FILE *);

/*PrtLineSum parse print line sum command to enter set of lines into sum  */
double PrtLineSum( 
	/* the job to do, either " SUM" or "READ" */
	const char *chDo);

/*PrtLinePres print line radiation pressures for current conditions */
void PrtLinePres(void);

/*PrtColumns print column densities of all elements */
void PrtColumns(
	/* this is stream used for io, is stdout when called by final,
	 * is punch unit when punch output generated */
	 FILE *ioMEAN );

/*PrtAllTau master routine controlling printout of optical depths at end of calculation */
void PrtAllTau(void);

EXTERN struct t_printit {

	/* lgSortLines, option to sort lines by wavelength- print sort command */
	int lgSortLines;

	/* if above is set, then one of the following must also be set,
	 * say whether to sort by wavelength or intensity */
	int lgSortLineWavelength , lgSortLineIntensity;

	/* lower and upper wavelength bounds for printed spectrum,
	 * range option on print sort command */
	float wlSort1 , wlSort2;

	/* print hydrogenic level populations, 
	 * set with print hydrogenic command
	int lgPrintHLevPops; */

	/* print column densities */
	int lgPrintColumns;

	/* should we print execution time?  normally true, but set false
	 * with no times command so that different runs can compare exactly */
	int lgPrintTime;

	/* print ages command tells code to print various timescales */
	int lgPrnAges;

	/* option to print maser lines (true) normally false
	 * print maser turns on */
	int lgPrtMaser;

	/* lgPrtTau tells whether to print line optical depths */
	int lgPrtTau;

	/* lgPrintFluxEarth says to print flux of lines at Earth, 
	 * if luminosity can be predicted */
	int lgPrintFluxEarth;

	/* print line surface brightness command, units either sr or sq arcsec,
	 * default is SR, set to arcsec with arcsec option */
	int lgSurfaceBrightness , lgSurfaceBrightness_SR;

	/* PrtTauFnt is smallest line optical depth to print */
	float PrtTauFnt;

	/* these are various contributors to the line output,
	 * and are changed with the print line or print continuum commands
	 * in prtfinal code uses these to make a final filter over what lines
	 * will be printed */
	int lgPrnPump, 
	  lgPrnHeat, 
	  lgPrnColl, 
	  lgPrnInwd, 
	  lgPrnDiff;

	/* flag set with print continuum command */
	int lgPrtCont;

	/* flags for determining what is included in nFnu */
	int lgSourceReflected;
	int lgSourceTransmitted;
	int lgDiffuseInward;
	int lgDiffuseOutward;

	/* flag set with print departure coefficients */
	int lgPrtBN;

	/* if true then print only last iteration */
	int lgPrtLastIt;

	/* flag set with print short comand */
	int lgPrtShort;

	/* lgOnlyZone set with print only zones */
	int lgOnlyZone;
	/* lgOnlyHead set with print only header */
	int lgOnlyHead;

	/* lgPrtStart is option to start printout at certain zone */
	int lgPrtStart;

	/*nstart is zone number, set with print start command */
	long int nstart;

	/* flag to turn on printout of heat sources */
	int lgPrintHeating;

	/* flag set with print array command to print ionization recombination arrays */
	int lgPrtArry;

	/* logical lgFaintOn normally true, says to not print very faint lines
	 * set false with print faint off command
	 *lines fainter than TooFaint will not be printed.  This is set in zerologic
	 *and reset with print line faint command  */
	float TooFaint;
	int lgFaintOn;

	/* flag set true if print faint command entered,
	 * only used to not overrid it with print short */
	int lgFntSet;

	/* option to print main block of lines as a single colum
	 * instead of the normal array.  if TRUE then usual array */
	int lgPrtLineArray;

	/* printins as a column also has an option to print linear quantity 
	 * in exponential format */
	int lgPrtLineLog;

	/* quantities to do with radiation field and printed in header */
	float qx, 
	  powion, 
	  xpow, 
	  pbal, 
	  q, 
	  qgam, 
	  pradio, 
	  fx1ryd;
	long int ipeak;
	float GammaLumin;

	long int nzdump;

	}	prt;


