/* This file is part of Cloudy and is copyright (C)1978-2006 by Gary J. Ferland
 * For conditions of distribution and use see copyright notice in license.txt */
/*CO_rates calculates all the rates for coupled reactions in the heavy
 * element network. */
#include "cddefines.h"
#include "phycon.h"
#include "mole.h"
/*lint -e778 constant expression evaluatess to 0 in operation '-' */
/*=================================================================*/

/*CO_step fills in matrix for heavy elements molecular routines */
void CO_rates(void )
{

	/* this routine works with the heavy molecules, of which there are NUM_HEAVY_MOLEC,
	 * plus C and O, making a total of NUM_COMOLE_CALC*/
	double 
	P_C_C2H3P ,
	P_C2H_C2H3P ,
	P_CH2_CH3P,
	P_CH4_C3HP,
	P_CH4_HCNP,
	P_CH4P_C2H2 ,
	P_CH5P_C2H2,
	P_CHP_CH4 ,
	P_CP_CH4 ,
	P_H2O_C2H3P ,
	P_HCN_C2H3P ,
	P_HNC_C2H3P ,
	P_NH3_C2H3P,
	P_O_C2H3P ,
	P_CP_C2H,
	P_CHP_C2H,
	P_C2P_C2,
	P_CHP_C2,
	P_CH_C2P,
	P_C_C2HP,
	P_ATC_CH2P,
	P_C_CH3P,
	P_C2_HCNP,
	P_C2_HNOP,
	P_C2H_CNP,
	P_C2H_N2P,
	P_C2HP_HCN,
	P_C2HP_HNC,
	P_C2HP_NO,
	P_C2HP_S,
	P_CH_C2HP,
	P_CH2_C2HP,
	P_CH4_C2P,
	P_CH5P_C2,
	P_CHP_CH2,
	P_CP_CH2,
	P_CP_CH3,
	P_H2O_C2P,
	P_H2OP_C2H,
	P_H3OP_C2,
	P_N_C2HP,
	P_NH_C2P,
	P_NH2_C2HP,
	P_NH2P_C2,
	P_NH3_C2HP,
	P_NP_C2H,
	P_O_C2HP,
	P_OHP_C2H,
	P_C_CH2,
	P_C_H2OP,
	P_C_H3OP,
	P_C_O2P,
	P_C_OH,
	P_C_OHP,
	P_CP_OH,
	P_CP_CH,
	P_CP_H2O,
	P_CP_O,
	P_CP_O2,
	P_O_CH,
	P_O_CHP,
	P_O_CH2,
	P_O_CH2P,
	P_O_CH3P,
	P_O_H2O,
	P_O_H2OP,
	P_O_O,
	P_O_OH,
	P_O_OHP,
	P_O_Si,
	P_O_SiP,
	P_O_SiH,
	P_O_SiH2P,
	P_O_SiOP,
	P_OP_CH,
	P_OP_CH2,
	P_OP_H2O,
	P_OP_O2,
	P_OP_OH,
	P_Si_CHP,
	P_Si_H2OP,
	P_Si_OH,
	P_Si_O2P,
	P_SiP_H2O,
	P_SiP_OH,
	P_SiP_O2,
	P_CH_COP,
	P_CH_H2OP,
	P_CH_H3OP,
	P_CH_O2P,
	P_CH_OHP,
	P_CH_SiOP,
	P_CHP_H2O,
	P_CHP_O2,
	P_CHP_OH,
	P_CH2_COP,
	P_CH2_H2OP,
	P_CH2_H3OP,
	P_CH2_O2P,
	P_CH2_OH,
	P_CH2_OHP,
	P_CH2P_O2,
	P_H2O_COP,
	P_H2OP_H2O,
	P_H2OP_O2,
	P_H3OP_SiH,
	P_H3OP_SiO,
	P_OH_COP,
	P_OH_H2OP,
	P_OH_OH,
	P_OHP_H2O,
	P_OHP_O2,
	P_OHP_OH,
	P_OHP_SiH,
	P_OHP_SiO,
	P_C_CH5P,
	P_O_CH4,
	P_O_CH4P,
	P_O_CH5P,
	P_OP_CH4,
	P_CH4_CH,
	P_CH5P_CH,
	P_CH2_CH2,
	P_CH4_CH2,
	P_OH_CH2,
	P_CH5P_CH2,
	P_OH_CH3,
	P_H2O_CH3,
	P_CH3_CH3,
	P_OH_CH4,
	P_OHP_CH4,
	P_H2OP_CH4,
	P_COP_CH4,
	P_CH4_CH4P,
	P_H2O_CH4P,
	P_O2_CH4P,
	P_H2O_CH5P,
	P_CH5P_OH,
	P_C_NH       ,      
	P_C_N2       ,    
	P_C_NO       ,   
	P_C_HS       ,  
	P_C_NS       ,
	P_C_S2       ,
	P_C_NH3P       ,   
	P_C_HCNP       ,   
	P_C_HNOP       ,   
	P_CH_N       ,     
	P_CH_N2       ,    
	P_CH_NO       ,    
	P_CH_HNO       ,   
	P_CH_S       ,     
	P_N_NH       ,     
	P_N_CH3       ,    
	P_N_OH       ,     
	P_N_CN       ,     
	P_N_SIH       ,    
	P_N_NO       ,     
	P_N_HNO       ,    
	P_N_O2       ,    
	P_N_HS       ,     
	P_N_CS       ,        
	P_N_NS       ,       
	P_N_SO       ,      
	P_N_S2       ,     
	P_CH2_CN       ,  
	P_CH2_NO       , 
	P_CH2_HNO       ,     
	P_NH_NH       ,     
	P_NH_O       ,     
	P_NH_OH       ,   
	P_NH_H2O       , 
	P_NH_CN       , 
	P_NH_NO       ,        
	P_NH_S       ,        
	P_NH_NO2       ,     
	P_CH3_NH3       ,   
	P_CH3_CN       ,   
	P_CH3_HNO       , 
	P_O_NH2       ,      
	P_O_NH3       ,     
	P_O_CN       ,     
	P_O_HCN       ,   
	P_O_N2       ,   
	P_O_NO       ,  
	P_O_HNO       ,
	P_O_HS       ,        
	P_O_OCN       ,      
	P_O_SIN       ,     
	P_O_N2O       ,    
	P_O_CS       ,    
	P_O_NS       ,  
	P_O_SO       , 
	P_O_S2       ,        
	P_NH2_OH       ,     
	P_NH2_NO       ,    
	P_CH4_CN       ,   
	P_OH_NH3       ,  
	P_OH_CN       ,  
	P_OH_HCN       ,       
	P_OH_NO       ,       
	P_OH_S       ,      
	P_OH_N2O       ,   
	P_OH_CS       ,   
	P_NH3_CN       , 
	P_CN_NO       , 
	P_CN_HNO       ,       
	P_CN_S       ,       
	P_N2_O2       ,    
	P_NO_NO       ,   
	P_NO_HNO       , 
	P_NO_S       ,  
	P_O2_S       , 
	P_S_SO       ,        
	P_C_NHP       ,      
	P_CP_NH       ,     
	P_CP_NH2       ,   
	P_C_NH2P       ,  
	P_CP_NH3       , 
	P_CP_HS       , 
	P_C_HSP       ,
	P_CP_OCN       ,       
	P_CP_NS       ,       
	P_CP_SO       ,      
	P_CP_OCS       ,    
	P_CHP_N       ,    
	P_CH_NP       ,   
	P_CH_NHP       , 
	P_CHP_NH       ,
	P_CHP_NH2       ,        
	P_CH_NH2P       ,       
	P_CHP_NH3       ,      
	P_CH_NH3P       ,     
	P_CH_HCNP       ,    
	P_CH_HNOP       ,   
	P_CHP_S       ,    
	P_CH_SP       ,   
	P_CH_HSP       , 
	P_N_CH2P       ,       
	P_NP_NH       ,       
	P_N_NHP       ,      
	P_NP_CH4       ,    
	P_N_OHP       ,    
	P_NP_NH3       ,  
	P_N_H2OP       , 
	P_NP_NO       ,        
	P_NP_O2       ,       
	P_N_O2P       ,      
	P_N_HSP       ,     
	P_N_SIOP       ,   
	P_N_SOP       ,   
	P_NP_OCS       , 
	P_CH2_NHP       ,        
	P_CH2_NH2P       ,      
	P_CH2P_NH3       ,     
	P_CH2_NH3P       ,    
	P_CH2_HCNP       ,   
	P_CH2_HNOP       ,  
	P_CH2P_S       ,   
	P_CH2_SP       ,  
	P_NHP_NH       , 
	P_NHP_O       , 
	P_NH_OP       ,
	P_NHP_NH2       ,        
	P_NH_NH2P       ,       
	P_NHP_OH       ,       
	P_NH_OHP       ,      
	P_NHP_NH3       ,    
	P_NH_NH3P       ,   
	P_NH_CH5P       ,  
	P_NHP_H2O       , 
	P_NH_H2OP       ,
	P_NHP_CN       ,        
	P_NH_HCNP       ,      
	P_NH_COP       ,      
	P_NH_SIP       ,    
	P_NH_HNOP       , 
	P_NHP_O2       , 
	P_NH_O2P       ,
	P_NHP_S       ,
	P_NH_SP       ,        
	P_CH3P_NH3       ,   
	P_CH3P_S       ,    
	P_O_NH2P       ,   
	P_O_NH3P       ,  
	P_OP_CN       ,  
	P_OP_HCN       ,       
	P_OP_N2       ,       
	P_O_N2P       ,      
	P_O_HNOP       ,    
	P_O_HSP       ,    
	P_O_SINP       ,  
	P_OP_N2O       , 
	P_O_CSP       , 
	P_O_HCSP       ,        
	P_OP_NO2       ,       
	P_O_NSP       ,       
	P_NH2P_NH2       ,   
	P_NH2_OHP       ,   
	P_NH2P_OH       ,  
	P_NH2P_NH3       ,        
	P_NH2_NH3P       ,       
	P_NH2_CH5P       ,      
	P_NH2P_H2O       ,     
	P_NH2_H2OP       ,    
	P_NH2_H3OP       ,  
	P_NH2_HCNP       , 
	P_NH2_COP       , 
	P_NH2_HNOP       ,      
	P_NH2P_O2       ,      
	P_NH2P_S       ,      
	P_CH4P_NH3       ,   
	P_CH4_NH3P       ,  
	P_CH4_N2P       ,  
	P_CH4_HNOP       ,
	P_CH4_SP       , 
	P_CH4_CSP       ,        
	P_OHP_NH3       ,       
	P_OH_NH3P       ,      
	P_OHP_CN       ,      
	P_OH_HCNP       ,    
	P_OHP_NO       ,    
	P_OH_HNOP       ,  
	P_OHP_S       ,   
	P_OH_SP       ,  
	P_NH3P_NH3       ,        
	P_NH3_CH5P       ,       
	P_NH3P_H2O       ,      
	P_NH3_H2OP       ,     
	P_NH3_H3OP       ,    
	P_NH3_COP       ,    
	P_NH3_HNOP       , 
	P_NH3_HSP       , 
	P_NH3_HCSP       ,        
	P_CH5P_S       ,        
	P_H2O_CNP       ,       
	P_H2O_HCNP       ,        
	P_H2O_HNOP       ,       
	P_H2OP_S       ,        
	P_H2O_HSP       ,      
	P_H3OP_CS       ,     
	P_CNP_NO       ,     
	P_CN_HNOP       ,   
	P_CNP_O2       ,   
	P_HCNP_S       , 
	P_HNOP_S       ,     
	P_O2_SP       ,     
	P_O2P_S       ,    
	P_O2_CSP       ,  
	P_S_SIOP       , 
	P_C_CNP       ,        
	P_C_N2P       ,       
	P_CP_NO       ,      
	P_CP_SIN       ,    
	P_C_CSP       ,    
	P_CH_CNP       ,       
	P_CH_N2P       ,      
	P_CHP_NO       ,     
	P_NP_NH2       ,   
	P_NP_CN       ,  
	P_NP_HCN       ,
	P_N_N2P       ,        
	P_CH2_CNP       ,  
	P_CH2_N2P       , 
	P_CH2P_NO       ,
	P_NH_CNP       ,   
	P_NH_N2P       , 
	P_NHP_NO       ,
	P_CH3P_NO       ,     
	P_OP_NH2       ,     
	P_OP_NH3       ,    
	P_O_CNP       ,    
	P_O_HCNP       ,  
	P_OP_NO       , 
	P_OP_OCS       ,        
	P_NH2_CNP       ,   
	P_NH2_N2P       , 
	P_NH2P_NO       ,        
	P_NH2_O2P       ,       
	P_CH4P_OCS       ,   
	P_OH_CNP       ,   
	P_OH_N2P       ,  
	P_NH3_HCNP       ,       
	P_NH3_N2P       ,      
	P_NH3P_SI       ,     
	P_NH3_O2P       ,   
	P_NH3_SP       ,   
	P_NH3_SOP       ,
	P_H2O_N2P       ,       
	P_H2OP_NO       ,      
	P_CNP_HCN       ,     
	P_CN_N2P       ,    
	P_CNP_S       ,  
	P_HCN_N2P       ,       
	P_HCNP_NO       ,      
	P_HCNP_O2       ,     
	P_N2P_NO       ,  
	P_N2P_O2       , 
	P_N2P_S       , 
	P_SI_NOP       ,        
	P_SI_HSP       ,       
	P_SI_CSP       ,      
	P_NO_HNOP       ,    
	P_NO_O2P       ,    
	P_NO_SP       ,    
	P_NO_HSP       ,  
	P_NO_SIOP       ,
	P_NO_S2P       ,        
	P_O2P_NO2       ,      
	P_S_HSP       ,       
	P_C_N       ,        
	P_C_S       ,       
	P_CP_S       ,     
	P_NP_N       ,    
	P_NP_CH2       ,      
	P_NP_OH       ,     
	P_NP_H2O       ,   
	P_SI_SP       ,
	P_C_CH,
	P_C_CN,
	P_C_CS,
	P_N_C2,
	P_C2_S,
	P_NHP_C2,
	P_OP_C2,
	P_C2_O2P,
	P_C2_SP,
	P_C_C2P,
	P_NP_C2,
	P_CH2_C2P,
	P_NH2_C2P,
	P_OHP_C2,
	P_OH_C2P,
	P_H2OP_C2,
	P_C2_CNP,
	P_C2_N2P,
	P_C2P_NO,
	P_C2P_S,
	P_C_C,
	P_C_CHP,
	P_CHP_CH,
	P_N_C2P,
	P_O_C2P,
	P_CP_C,
	P_O_CCl,
	P_O_ClO,
	P_CP_HCl,
	P_CH3P_HCl,
	P_H2O_H2ClP,
	P_CP_CCl,
	P_CP_ClO,
	P_O2_ClP,
	P_ATC_NH2     ,
	P_ATN_CH2     ,
	P_CHP_HNC   ,
	P_CH_HCNHP  ,
	P_CH2_HCNHP ,
	P_NHP_HNC   ,
	P_NH2P_HNC  ,
	P_NH2_HCNHP ,
	P_OHP_HNC   ,
	P_NH3_HCNHP ,
	P_CH5P_HNC  ,
	P_H2OP_HNC  ,
	P_H3OP_HNC  ,
	P_HCNP_HNC  ,
	P_HNC_HNOP  ,
	P_HNC_HSP   ,
	P_CHP_HCN   ,
	P_NH_CH3P   ,
	P_NHP_HCN   ,
	P_NH2P_HCN  ,
	P_OHP_HCN   ,
	P_CH5P_HCN  ,
	P_H2OP_HCN  ,
	P_H3OP_HCN  ,
	P_HCNP_HCN  ,
	P_HCN_HNOP  ,
	P_HCN_HSP   ,
	P_OP_C2H ,
	P_C2H_COP ,
	P_C_C2H2P,
	P_C_C2H2,
	P_C2H_HCNP,
	P_C2H2P_NO,
	P_CH_CH3P,
	P_CH3P_C2,
	P_CH4_C2HP,
	P_CH5P_C2H,
	P_CP_C2H2,
	P_H2O_C2H2P,
	P_H2O_C3HP,
	P_H3OP_C3,
	P_N_C2H2P,
	P_NH2P_C2H,
	P_NH3_C2H2P,
	P_NH3_C3HP,
	P_NH3P_C2,
	P_NHP_C2H,
	P_NO_C3HP,
	P_O_C2H2,
	P_O_C2H2P,
	P_OH_C2H2,
	P_OP_C2H2,
	P_C2H2P_HCN,
	P_H2OP_C2H2,
	P_NH2_C2H2P,
	CH, CHP,OH,OHP,O2,COP,H2O,H2OP,O2P,H3OP,CH2P,
	CH2,CH3P,SIH2P,SIH, 
	SIO,SIOP,CH3,CH4,CH4P,CH5P,N2,
	N2P,NO,NOP,S2,S2P,OCN,NH,
	NHP,NH2,NH2P,NH3,NH3P,CN,
	CNP,HCN,HCNP,
	HNO,HNOP,HS,HSP,CS,CSP,NO2,
	NS,NSP,SO,SOP,SIN,SINP,
	N2O,HCSP,OCS,C2,C2P,CP,OP,SIP,NP,SP,ATC,ATO, 
	ATSI,ATN,ATS, 
	ClO,HCl,CCl,H2ClP,ClP, HNC, HCNHP, C2H, C2HP, C2H2,
	C2H2P, C3H, C3HP, C3, C2H3P;
	
	#	ifdef DEBUG_FUN
	fputs( "<+>CO_step()\n", debug_fp );
#	endif


	/* dissociation energies;
	 * CO 11.09, CO+ 8.3eV, CH+ 3.8eV
	 * LTE population of CO+ */


	/* Define the density of each molecule, doing so in this fashion saves memory */
	CH	= co.hevmol[ipCH];
	CHP	= co.hevmol[ipCHP];
	OH	= co.hevmol[ipOH];
	OHP	= co.hevmol[ipOHP];
	O2  = co.hevmol[ipO2];
	COP	= co.hevmol[ipCOP];
	H2O	= co.hevmol[ipH2O];
	H2OP = co.hevmol[ipH2OP];
	O2P	= co.hevmol[ipO2P];
	H3OP = co.hevmol[ipH3OP];
	CH2P = co.hevmol[ipCH2P];
	CH2 = co.hevmol[ipCH2];
	CH3P = co.hevmol[ipCH3P];
	SIH2P = co.hevmol[ipSIH2P];
	SIH   = co.hevmol[ipSIH];
	SIO   = co.hevmol[ipSIO];
	SIOP  = co.hevmol[ipSIOP];
	CH3   = co.hevmol[ipCH3];
	CH4   = co.hevmol[ipCH4];
	CH4P  = co.hevmol[ipCH4P];
	CH5P  = co.hevmol[ipCH5P];
	N2	= co.hevmol[ipN2];
	N2P	= co.hevmol[ipN2P];
	NO	= co.hevmol[ipNO];
	NOP	= co.hevmol[ipNOP];
	S2  = co.hevmol[ipS2];
	S2P	= co.hevmol[ipS2P];
	OCN	= co.hevmol[ipOCN];
	NH	= co.hevmol[ipNH];
	NHP	= co.hevmol[ipNHP];
	NH2	= co.hevmol[ipNH2];
	NH2P = co.hevmol[ipNH2P];
	NH3 = co.hevmol[ipNH3];
	NH3P = co.hevmol[ipNH3P];
	CN  = co.hevmol[ipCN];
	CNP = co.hevmol[ipCNP];
	HCN = co.hevmol[ipHCN];
	HCNP = co.hevmol[ipHCNP];
	HNO = co.hevmol[ipHNO];
	HNOP = co.hevmol[ipHNOP];
	HS  = co.hevmol[ipHS];
	HSP = co.hevmol[ipHSP];
	CS  = co.hevmol[ipCS];
	CSP	= co.hevmol[ipCSP];
	NO2	= co.hevmol[ipNO2];
	NS	= co.hevmol[ipNS];
	NSP = co.hevmol[ipNSP];
	SO	= co.hevmol[ipSO];
	SOP	= co.hevmol[ipSOP];
	SIN	= co.hevmol[ipSIN];
	SINP=	co.hevmol[ipSINP];
	N2O	=co.hevmol[ipN2O];
	HCSP=	co.hevmol[ipHCSP];
	OCS	=co.hevmol[ipOCS];
	C2	= co.hevmol[ipC2];
	C2P	= co.hevmol[ipC2P];
	CP   = co.hevmol[ipCP];
	OP    = co.hevmol[ipOP];
	SIP	= co.hevmol[ipSIP];
	NP  = co.hevmol[ipNP];
	SP  = co.hevmol[ipSP];
	ATC = co.hevmol[ipATC];
	ATO = co.hevmol[ipATO];
	ATSI= co.hevmol[ipATSI];
	ATN = co.hevmol[ipATN];
	ATS = co.hevmol[ipATS];
	CCl = co.hevmol[ipCCl];
	ClO = co.hevmol[ipClO];
	HCl = co.hevmol[ipHCl];
	CCl = co.hevmol[ipCCl];
	H2ClP = co.hevmol[ipH2ClP];
	ClP = co.hevmol[ipClP];
	HNC = co.hevmol[ipHNC];
	HCNHP = co.hevmol[ipHCNHP];
	C2H = co.hevmol[ipC2H];
	C2HP = co.hevmol[ipC2HP];
	C2H2 = co.hevmol[ipC2H2];
	C2H2P = co.hevmol[ipC2H2P];
	C3H = co.hevmol[ipC3H];
	C3HP = co.hevmol[ipC3HP];
	C3 = co.hevmol[ipC3];
	C2H3P = co.hevmol[ipC2H3P];


	/* Products of densities, this is needed to "decouple" the reactions where both parents are
	   unknown densities */
	P_C_C2H3P = ATC*C2H3P;
	P_C2H_C2H3P = C2H*C2H3P;
	P_CH2_CH3P = CH2*CH3P;
	P_CH4_C3HP = CH4*C3HP;
	P_CH4_HCNP = CH4*HCNP;
	P_CH4P_C2H2 = CH4P*C2H2;
	P_CH5P_C2H2 = CH5P*C2H2;
	P_CHP_CH4 = CHP*CH4;
	P_CP_CH4 = CP*CH4;
	P_H2O_C2H3P = H2O*C2H3P;
	P_HCN_C2H3P = HCN*C2H3P;
	P_HNC_C2H3P = HNC*C2H3P;
	P_NH3_C2H3P = NH3*C2H3P;
	P_O_C2H3P = ATO*C2H3P;
	P_C2H2P_HCN = C2H2P*HCN; 
	P_H2OP_C2H2 = H2OP*C2H2;
	P_C_C2H2P = ATC*C2H2P;
	P_C_C2H2 = ATC*C2H2;
	P_C2H_HCNP = C2H*HCNP;
	P_C2H2P_NO = C2H2P*NO;
	P_C2HP_HCN = C2HP*HCN;
	P_CH_C2HP = CH*C2HP;
	P_CH_CH3P = CH*CH3P;
	P_CH2_C2P = CH2*C2P;
	P_CH2_CH2 = CH2*CH2;
	P_CH3P_C2 = CH3P*C2;
	P_CH4_C2HP = CH4*C2HP;
	P_CH4_C2P = CH4*C2P;
	P_CH4P_C2H2 = CH4P*C2H2;
	P_CH5P_C2H = CH5P*C2H;
	P_CHP_CH4 = CHP*CH4;
	P_CP_C2H2 = CP*C2H2;
	P_CP_CH3 = CP*CH3;
	P_CP_CH4 = CP*CH4;
	P_H2O_C2H2P = H2O*C2H2P;
	P_H2O_C3HP = H2O*C3HP;
	P_H2OP_C2H = H2OP*C2H;
	P_H3OP_C3 = H3OP*C3;
	P_N_C2H2P = ATN*C2H2P;
	P_NH2_C2H2P = NH2*C2H2P;
	P_NH2P_C2H = NH2P*C2H;
	P_NH3_C2H2P = NH3*C2H2P;
	P_NH3_C3HP = NH3*C3HP;
	P_NH3P_C2 = NH3P*C2;
	P_NHP_C2H = NHP*C2H;
	P_NO_C3HP = NO*C3HP;
	P_O_C2H2 = ATO*C2H2;
	P_O_C2H2P = ATO*C2H2P;
	P_OH_C2H2 = OH*C2H2;
	P_OHP_C2H = OHP*C2H;
	P_OP_C2H2 = OP*C2H2;

	P_CP_C2H =CP*C2H;
	P_CHP_C2H =CHP*C2H;
	P_C2P_C2 =C2P*C2;
	P_CHP_C2 =CHP*C2;
	P_CH_C2P =CH*C2P;
	P_C_C2HP =ATC*C2HP;
	P_ATC_CH2P = ATC*CH2P;
	P_C_CH3P = ATC*CH3P;
	P_C2_HCNP = C2*HCNP;
	P_C2_HNOP = C2*HNOP;
	P_C2H_CNP = C2H*CNP;
	P_C2H_N2P = C2H*N2P;
	P_C2HP_HCN = C2HP*HCN;
	P_C2HP_HNC = C2HP*HNC;
	P_C2HP_NO = C2HP*NO;
	P_C2HP_S = C2HP*ATS;
	P_CH_C2HP = CH*C2HP;
	P_CH2_C2HP = CH2*C2HP;
	P_CH4_C2P = CH4*C2P;
	P_CH5P_C2 = CH5P*C2;
	P_CHP_CH2 = CHP*CH2;
	P_CP_CH2 = CP*CH2;
	P_CP_CH3 = CP*CH3;
	P_H2O_C2P = H2O*C2P;
	P_H2OP_C2 = H2OP*C2;
	P_H2OP_C2H = H2OP*C2H;
	P_H3OP_C2 = H3OP*C2;
	P_N_C2HP = ATN*C2HP;
	P_NH_C2P = NH*C2P;
	P_NH2_C2HP =NH2*C2HP; 
	P_NH2P_C2 = NH2P*C2;
	P_NH3_C2HP = NH3*C2HP;
	P_NHP_C2 = NHP*C2;
	P_NP_C2H = NP*C2H;
	P_O_C2HP = ATO*C2HP;
	P_OHP_C2 = OHP*C2;
	P_OHP_C2H = OHP*C2H;
	P_OP_C2H = OP*C2H;
	P_C2H_COP = C2H*COP;
	P_C_CH2 = ATC*CH2;
	P_C_H2OP= ATC*H2OP;
	P_C_H3OP= ATC*H3OP;
	P_C_O2P= ATC*O2P;
	P_C_OH= ATC*OH;
	P_C_OHP= ATC*OHP;
	P_CP_OH= CP*OH;
	P_CP_CH = CP*CH;
	P_CP_CH2 = CP*CH2;
	P_CP_H2O = CP*H2O;
	P_CP_O = CP*ATO;
	P_CP_S = CP*ATS;
	P_CP_O2 = CP*O2;
	P_CP_OH = CP*OH;
	P_O_CH = ATO*CH;
	P_O_CHP = ATO*CHP;
	P_O_CH2 = ATO*CH2;
	P_O_CH2P = ATO*CH2P; 
	P_O_CH3P = ATO*CH3P;
	P_O_H2O = ATO*H2O;
	P_O_H2OP = ATO*H2OP;
	P_O_O = ATO*ATO;
	P_O_OH = ATO*OH;
	P_O_OHP = ATO*OHP;
	P_O_Si = ATO*ATSI;
	P_O_SiP = ATO*SIP;
	P_O_SiH = ATO*SIH;
	P_O_SiH2P = ATO*SIH2P;
	P_O_SiOP = ATO*SIOP;
	P_OP_CH = OP*CH;
	P_OP_CH2 = OP*CH2;
	P_OP_H2O = OP*H2O;
	P_OP_O2 = OP*O2;
	P_OP_OH = OP*OH;
	P_Si_CHP = ATSI*CHP;
	P_Si_H2OP = ATSI*H2OP;
	P_Si_OH = ATSI*OH;
	P_Si_O2P = ATSI*O2P;
	P_SiP_H2O = SIP*H2O;
	P_SiP_OH = SIP*OH;
	P_SiP_O2 = SIP*O2;
	P_CH_COP = CH*COP;
	P_CH_H2OP = CH*H2OP;
	P_CH_H3OP = CH*H3OP;
	P_CH_O2P = CH*O2P;
	P_CH_OHP = CH*OHP;
	P_CH_SiOP = CH*SIOP;
	P_CHP_H2O = CHP*H2O;
	P_CHP_OH = CHP*OH;
	P_CHP_O2 = CHP*O2;
	P_CH2_COP = CH2*COP;
	P_CH2_H2OP = CH2*H2OP;
	P_CH2_H3OP = CH2*H3OP;
	P_CH2_O2P = CH2*O2P;
	P_CH2_OH = CH2*OH;
	P_CH2_OHP = CH2*OHP;
	P_CH2P_O2 = CH2P*O2;
	P_H2O_COP = H2O*COP;
	P_H2OP_H2O = H2OP*H2O;
	P_H2OP_O2 = H2OP*O2;
	P_H3OP_SiH = H3OP*SIH;
	P_H3OP_SiO = H3OP*SIO;
	P_OH_COP = OH*COP;
	P_OH_H2OP = OH*H2OP;
	P_OH_OH = OH*OH;
	P_OHP_H2O = OHP*H2O;
	P_OHP_O2 = OHP*O2;
	P_OHP_OH = OHP*OH;
	P_OHP_SiH = OHP*SIH;
	P_OHP_SiO = OHP*SIO;
	P_C_CH = ATC*CH;
	P_C_CN = ATC*CN;
	P_C_CS = ATC*CS;
	P_N_C2 = ATN*C2;
	P_C2_S = C2*ATS;
	P_NHP_C2 = NHP*C2;
	P_OP_C2 = OP*C2;
	P_C2_O2P = C2*O2P;
	P_C2_SP = C2*SP;
	P_C_C2P = ATC*C2P;
	P_CH_C2P = CH*C2P;
	P_NP_C2 = NP*C2;
	P_CH2_C2P = CH2*C2P;
	P_OP_C2 = OP*C2;
	P_NH2_C2P = NH2*C2P;
	P_OHP_C2 = OHP*C2;
	P_OH_C2P = OH*C2P;
	P_H2OP_C2 = H2OP*C2;
	P_C2_CNP = C2*CNP;
	P_C2_N2P = C2*N2P;
	P_C2P_NO = C2P*NO;
	P_C2_O2P = C2*O2P;
	P_C2P_S = C2P*ATS;
	P_C_C = ATC*ATC;
	P_CP_CH = CP*CH;
	P_C_CHP = ATC*CHP;
	P_CHP_CH = CHP*CH;
	P_CH_C2P = CH*C2P;
	P_N_C2P = ATN*C2P;
	P_O_C2P = ATO*C2P;
	P_C2P_S = C2P*ATS;
	P_CP_C = CP*ATC;
	P_C_CH5P = ATC*CH5P;
	P_O_CH4 = ATO*CH4;
	P_O_CH4P = ATO*CH4P;
	P_O_CH5P = ATO*CH5P;
	P_OP_CH4 = OP*CH4;
	P_CH4_CH = CH4*CH;
	P_CH5P_CH = CH5P*CH;
	P_CH2_CH2 = CH2*CH2;
	P_CH4_CH2 = CH4*CH2;
	P_OH_CH2 = OH*CH2;
	P_CH5P_CH2 = CH5P*CH2;
	P_OH_CH3 = OH*CH3;
	P_OH_CH3 = OH*CH3;
	P_H2O_CH3 = H2O*CH3;
	P_CH3_CH3 = CH3*CH3;
	P_OH_CH4 = OH*CH4;
	P_OHP_CH4 = OHP*CH4;
	P_H2OP_CH4 = H2OP*CH4;
	P_COP_CH4 = COP*CH4;
	P_CH4_CH4P = CH4*CH4P;
	P_H2O_CH4P = H2O*CH4P;
	P_O2_CH4P = O2*CH4P;
	P_H2O_CH5P = H2O*CH5P;
	P_CH5P_OH = CH5P*OH;
	P_C_NH = ATC*NH;
	P_C_N2 = ATC*N2;
	P_C_NO = ATC*NO;
	P_C_HS = ATC*HS;
	P_C_NS = ATC*NS;
	P_C_S2 = ATC*S2;
	P_C_NH3P = ATC*NH3P;
	P_C_HCNP = ATC*HCNP;
	P_C_HNOP = ATC*HNOP;
	P_CH_N = CH*ATN;
	P_CH_N2 = CH*N2;
	P_CH_NO = CH*NO;
	P_CH_HNO = CH*HNO;
	P_CH_S = CH*ATS;
	P_N_NH = ATN*NH;
	P_N_CH3 = ATN*CH3;
	P_N_OH = ATN*OH;
	P_N_CN = ATN*CN;
	P_N_SIH = ATN*SIH;
	P_N_NO = ATN*NO;
	P_N_HNO = ATN*HNO;
	P_N_O2 = ATN*O2;
	P_N_HS = ATN*HS;
	P_N_CS = ATN*CS;
	P_N_NS = ATN*NS;
	P_N_SO = ATN*SO;
	P_N_S2 = ATN*S2;
	P_CH2_CN = CH2*CN;
	P_CH2_NO = CH2*NO;
	P_CH2_HNO = CH2*HNO;
	P_NH_NH = NH*NH;
	P_NH_O = NH*ATO;
	P_NH_OH = NH*OH;
	P_NH_H2O = NH*H2O;
	P_NH_CN = NH*CN;
	P_NH_NO = NH*NO;
	P_NH_S = NH*ATS;
	P_NH_NO2 = NH*NO2;
	P_CH3_NH3 = CH3*NH3;
	P_CH3_CN = CH3*CN;
	P_CH3_HNO = CH3*HNO;
	P_O_NH2 = ATO*NH2;
	P_O_NH3 = ATO*NH3;
	P_O_CN = ATO*CN;
	P_O_HCN = ATO*HCN;
	P_O_N2 = ATO*N2;
	P_O_NO = ATO*NO;
	P_O_HNO = ATO*HNO;
	P_O_HS = ATO*HS;
	P_O_OCN = ATO*OCN;
	P_O_SIN = ATO*SIN;
	P_O_N2O = ATO*N2O;
	P_O_CS = ATO*CS;
	P_O_NS = ATO*NS;
	P_O_SO = ATO*SO;
	P_O_S2 = ATO*S2;
	P_NH2_OH = NH2*OH;
	P_NH2_NO = NH2*NO;
	P_CH4_CN = CH4*CN;
	P_OH_NH3 = OH*NH3;
	P_OH_CN = OH*CN;
	P_OH_HCN = OH*HCN;
	P_OH_NO = OH*NO;
	P_OH_S = OH*ATS;
	P_OH_N2O = OH*N2O;
	P_OH_CS = OH*CS;
	P_NH3_CN = NH3*CN;
	P_CN_NO = CN*NO;
	P_CN_HNO = CN*HNO;
	P_CN_S = CN*ATS;
	P_N2_O2 = N2*O2;
	P_NO_NO = NO*NO;
	P_NO_HNO = NO*HNO;
	P_NO_S = NO*ATS;
	P_O2_S = O2*ATS;
	P_S_SO = ATS*SO;
	P_C_NHP = ATC*NHP;
	P_CP_NH = CP*NH;
	P_CP_NH2 = CP*NH2;
	P_C_NH2P = ATC*NH2P;
	P_CP_NH3 = CP*NH3;
	P_CP_HS = CP*HS;
	P_C_HSP = ATC*HSP;
	P_CP_OCN = CP*OCN;
	P_CP_NS = CP*NS;
	P_CP_SO = CP*SO;
	P_CP_OCS = CP*OCS;
	P_CHP_N = CHP*ATN;
	P_CH_NP = CH*NP;
	P_CH_NHP = CH*NHP;
	P_CHP_NH = CHP*NH;
	P_CHP_NH2 = CHP*NH2;
	P_CH_NH2P = CH*NH2P;
	P_CHP_NH3 = CHP*NH3;
	P_CH_NH3P = CH*NH3P;
	P_CH_HCNP = CH*HCNP;
	P_CH_HNOP = CH*HNOP;
	P_CHP_S = CHP*ATS;
	P_CH_SP = CH*SP;
	P_CH_HSP = CH*HSP;
	P_N_CH2P = ATN*CH2P;
	P_NP_NH = NP*NH;
	P_N_NHP = ATN*NHP;
	P_NP_CH4 = NP*CH4;
	P_N_OHP = ATN*OHP;
	P_NP_NH3 = NP*NH3;
	P_N_H2OP = ATN*H2OP;
	P_NP_NO = NP*NO;
	P_NP_O2 = NP*O2;
	P_N_O2P = ATN*O2P;
	P_N_HSP = ATN*HSP;
	P_N_SIOP = ATN*SIOP;
	P_N_SOP = ATN*SOP;
	P_NP_OCS = NP*OCS;
	P_CH2_NHP = CH2*NHP;
	P_CH2_NH2P = CH2*NH2P;
	P_CH2P_NH3 = CH2P*NH3;
	P_CH2_NH3P = CH2*NH3P;
	P_CH2_HCNP = CH2*HCNP;
	P_CH2_HNOP = CH2*HNOP;
	P_CH2P_S = CH2P*ATS;
	P_CH2_SP = CH2*SP;
	P_NHP_NH = NHP*NH;
	P_NHP_O = NHP*ATO;
	P_NH_OP = NH*OP;
	P_NHP_NH2 = NHP*NH2;
	P_NH_NH2P = NH*NH2P;
	P_NHP_OH = NHP*OH;
	P_NH_OHP = NH*OHP;
	P_NHP_NH3 = NHP*NH3;
	P_NH_NH3P = NH*NH3P;
	P_NH_CH5P = NH*CH5P;
	P_NHP_H2O = NHP*H2O;
	P_NH_H2OP = NH*H2OP;
	P_NHP_H2O = NHP*H2O;
	P_NHP_CN = NHP*CN;
	P_NH_HCNP = NH*HCNP;
	P_NH_COP = NH*COP;
	P_NH_SIP = NH*SIP;
	P_NH_HNOP = NH*HNOP;
	P_NHP_O2 = NHP*O2;
	P_NH_O2P = NH*O2P;
	P_NHP_S = NHP*ATS;
	P_NH_SP = NH*SP;
	P_CH3P_NH3 = CH3P*NH3;
	P_CH3P_S = CH3P*ATS;
	P_O_NH2P = ATO*NH2P;
	P_O_NH3P = ATO*NH3P;
	P_OP_CN = OP*CN;
	P_OP_HCN = OP*HCN;
	P_OP_N2 = OP*N2;
	P_O_N2P = ATO*N2P;
	P_O_HNOP = ATO*HNOP;
	P_O_HSP = ATO*HSP;
	P_O_SINP = ATO*SINP;
	P_OP_N2O = OP*N2O;
	P_O_CSP = ATO*CSP;
	P_O_HCSP = ATO*HCSP;
	P_OP_NO2 = OP*NO2;
	P_O_NSP = ATO*NSP;
	P_NH2P_NH2 = NH2P*NH2;
	P_NH2_OHP = NH2*OHP;
	P_NH2P_OH = NH2P*OH;
	P_NH2P_NH3 = NH2P*NH3;
	P_NH2_NH3P = NH2*NH3P;
	P_NH2_CH5P = NH2*CH5P;
	P_NH2P_H2O = NH2P*H2O;
	P_NH2_H2OP = NH2*H2OP;
	P_NH2P_H2O = NH2P*H2O;
	P_NH2_H3OP = NH2*H3OP;
	P_NH2_HCNP = NH2*HCNP;
	P_NH2_COP = NH2*COP;
	P_NH2_HNOP = NH2*HNOP;
	P_NH2P_O2 = NH2P*O2;
	P_NH2P_S = NH2P*ATS;
	P_CH4P_NH3 = CH4P*NH3;
	P_CH4_NH3P = CH4*NH3P;
	P_CH4_N2P = CH4*N2P;
	P_CH4_HNOP = CH4*HNOP;
	P_CH4_SP = CH4*SP;
	P_CH4_CSP = CH4*CSP;
	P_OHP_NH3 = OHP*NH3;
	P_OH_NH3P = OH*NH3P;
	P_OHP_CN = OHP*CN;
	P_OH_HCNP = OH*HCNP;
	P_OHP_NO = OHP*NO;
	P_OH_HNOP = OH*HNOP;
	P_OHP_S = OHP*ATS;
	P_OH_SP = OH*SP;
	P_NH3P_NH3 = NH3P*NH3;
	P_NH3_CH5P = NH3*CH5P;
	P_NH3P_H2O = NH3P*H2O;
	P_NH3_H2OP = NH3*H2OP;
	P_NH3_H3OP = NH3*H3OP;
	P_NH3_COP = NH3*COP;
	P_NH3_HNOP = NH3*HNOP;
	P_NH3_HSP = NH3*HSP;
	P_NH3_HCSP = NH3*HCSP;
	P_CH5P_S = CH5P*ATS;
	P_H2O_CNP = H2O*CNP;
	P_H2O_HCNP = H2O*HCNP;
	P_H2O_HNOP = H2O*HNOP;
	P_H2OP_S = H2OP*ATS;
	P_H2O_HSP = H2O*HSP;
	P_H3OP_CS = H3OP*CS;
	P_CNP_NO = CNP*NO;
	P_CN_HNOP = CN*HNOP;
	P_CNP_O2 = CNP*O2;
	P_HCNP_S = HCNP*ATS;
	P_HNOP_S = HNOP*ATS;
	P_O2_SP = O2*SP;
	P_O2P_S = O2P*ATS;
	P_O2_CSP = O2*CSP;
	P_S_SIOP = ATS*SIOP;
	P_CP_NH3 = CP*NH3;
	P_C_CNP = ATC*CNP;
	P_C_N2P = ATC*N2P;
	P_CP_NO = CP*NO;
	P_CP_SIN = CP*SIN;
	P_C_CSP = ATC*CSP;
	P_CP_NS = CP*NS;
	P_CP_SO = CP*SO;
	P_CP_OCS = CP*OCS;
	P_CH_NH2P = CH*NH2P;
	P_CHP_NH3 = CHP*NH3;
	P_CH_CNP = CH*CNP;
	P_CH_N2P = CH*N2P;
	P_CHP_NO = CHP*NO;
	P_NP_NH = NP*NH;
	P_NP_NH2 = NP*NH2;
	P_NP_NH3 = NP*NH3;
	P_NP_CN = NP*CN;
	P_NP_HCN = NP*HCN;
	P_N_N2P = ATN*N2P;
	P_NP_NO = NP*NO;
	P_NP_OCS = NP*OCS;
	P_CH2_NH2P = CH2*NH2P;
	P_CH2_CNP = CH2*CNP;
	P_CH2_N2P = CH2*N2P;
	P_CH2P_NO = CH2P*NO;
	P_NH_OP = NH*OP;
	P_NH_OHP = NH*OHP;
	P_NHP_NH3 = NHP*NH3;
	P_NHP_H2O = NHP*H2O;
	P_NH_CNP = NH*CNP;
	P_NH_COP = NH*COP;
	P_NH_N2P = NH*N2P;
	P_NHP_NO = NHP*NO;
	P_NHP_O2 = NHP*O2;
	P_NHP_S = NHP*ATS;
	P_CH3P_NO = CH3P*NO;
	P_OP_NH2 = OP*NH2;
	P_OP_NH3 = OP*NH3;
	P_O_CNP = ATO*CNP;
	P_O_HCNP = ATO*HCNP;
	P_O_N2P = ATO*N2P;
	P_OP_NO = OP*NO;
	P_OP_OCS = OP*OCS;
	P_NH2_OHP = NH2*OHP;
	P_NH2P_NH3 = NH2P*NH3;
	P_NH2_H2OP = NH2*H2OP;
	P_NH2_CNP = NH2*CNP;
	P_NH2_COP = NH2*COP;
	P_NH2_N2P = NH2*N2P;
	P_NH2P_NO = NH2P*NO;
	P_NH2_O2P = NH2*O2P;
	P_NH2P_S = NH2P*ATS;
	P_CH4P_NH3 = CH4P*NH3;
	P_CH4P_OCS = CH4P*OCS;
	P_OHP_NH3 = OHP*NH3;
	P_OH_CNP = OH*CNP;
	P_OH_N2P = OH*N2P;
	P_OHP_NO = OHP*NO;
	P_NH3_H2OP = NH3*H2OP;
	P_NH3_HCNP = NH3*HCNP;
	P_NH3_COP = NH3*COP;
	P_NH3_N2P = NH3*N2P;
	P_NH3P_SI = NH3P*ATSI;
	P_NH3_O2P = NH3*O2P;
	P_NH3_SP = NH3*SP;
	P_NH3_HSP = NH3*HSP;
	P_NH3_SOP = NH3*SOP;
	P_H2O_HCNP = H2O*HCNP;
	P_H2O_N2P = H2O*N2P;
	P_H2OP_NO = H2OP*NO;
	P_CNP_HCN = CNP*HCN;
	P_CN_N2P = CN*N2P;
	P_CNP_NO = CNP*NO;
	P_CNP_O2 = CNP*O2;
	P_CNP_S = CNP*ATS;
	P_HCN_N2P = HCN*N2P;
	P_HCNP_NO = HCNP*NO;
	P_HCNP_O2 = HCNP*O2;
	P_HCNP_S = HCNP*ATS;
	P_N2P_NO = N2P*NO;
	P_N2P_O2 = N2P*O2;
	P_N2P_S = N2P*ATS;
	P_SI_NOP = ATSI*NOP;
	P_SI_HSP = ATSI*HSP;
	P_SI_CSP = ATSI*CSP;
	P_NO_HNOP = NO*HNOP;
	P_NO_O2P = NO*O2P;
	P_NO_SP = NO*SP;
	P_NO_HSP = NO*HSP;
	P_NO_SIOP = NO*SIOP;
	P_NO_S2P = NO*S2P;
	P_O2P_NO2 = O2P*NO2;
	P_S_HSP = ATS*HSP;
	P_C_N = ATC*ATN;
	P_C_S = ATC*ATS;
	P_NP_N = NP*ATN;
	P_CHP_S = CHP*ATS;
	P_NP_CH2 = NP*CH2;
	P_NP_CH4 = NP*CH4;
	P_NP_OH = NP*OH;
	P_NP_H2O = NP*H2O;
	P_NP_O2 = NP*O2;
	P_OP_O2 = OP*O2;
	P_OHP_S = OHP*ATS;
	P_H2OP_S = H2OP*ATS;
	P_SI_SP = ATSI*SP;
	P_O2P_S = O2P*ATS;
	P_O_CCl = ATO*CCl;
	P_O_ClO = ATO*ClO;
	P_CP_HCl = CP*HCl;
	P_CH3P_HCl = CH3P*HCl;
	P_H2O_H2ClP = H2O*H2ClP;
	P_CP_CCl = CP*CCl;
	P_CP_ClO = CP*ClO;
	P_O2_ClP = O2*ClP;
	P_ATC_NH2 = ATC*NH2;
	P_ATN_CH2 = ATN*CH2;
	P_CHP_HNC = CHP*HNC;
	P_CH_HCNHP = CH*HCNHP;
	P_CH2_HCNHP = CH2*HCNHP;
	P_NHP_HNC = NHP*HNC;
	P_NH2P_HNC = NH2P*HNC;
	P_NH2_HCNHP = NH2*HCNHP; 
	P_OHP_HNC = OHP*HNC;
	P_NH3_HCNHP = NH3*HCNHP; 
	P_CH5P_HNC = CH5P*HNC;
	P_H2OP_HNC = H2OP*HNC;
	P_H3OP_HNC = H3OP*HNC;
	P_HCNP_HNC = HCNP*HNC;
	P_HNC_HNOP = HNC*HNOP;
	P_HNC_HSP = HNC*HSP;
	P_CHP_HCN = CHP*HCN;
	P_CH_HCNHP = CH*HCNHP;
	P_NP_CH4 = NP*CH4;
	P_CH2_HCNHP = CH2*HCNHP;
	P_NH_CH3P = NH*CH3P;
	P_NHP_HCN = NHP*HCN;
	P_NH2P_HCN = NH2P*HCN;
	P_NH2_HCNHP = NH2*HCNHP;
	P_CH4_HCNP = CH4*HCNP;
	P_OHP_HCN = OHP*HCN;
	P_NH3_HCNP = NH3*HCNP;
	P_NH3_HCNHP = NH3*HCNHP;
	P_CH5P_HCN = CH5P*HCN;
	P_H2OP_HCN = H2OP*HCN;
	P_H3OP_HCN = H3OP*HCN;
	P_HCNP_HCN = HCNP*HCN;
	P_HCN_HNOP = HCN*HNOP;
	P_HCN_HSP = HCN*HSP;


	/* now define all the sources and sinks that come about through the decoupling scheme */
	
	rate_COmole.b_CP_S_C_SP			= HMRATE(1.0e-9,0,0)*P_CP_S;
	rate_COmole.b_C_CH2_CH_CH	    = HMRATE(2.69e-12,0,23550)*P_C_CH2;
	rate_COmole.b_C_H2OP_OH_CHP	    = HMRATE(1.1e-9,0,0)*P_C_H2OP;
	rate_COmole.b_C_H3OP_HCOP_H2     = HMRATE(1.0e-11,0,0)*P_C_H3OP;
	rate_COmole.b_C_O2P_O2_CP	    = HMRATE(5.2e-11,0,0)*P_C_O2P;
	rate_COmole.b_C_O2P_COP_O	    = HMRATE(5.2e-11,0,0)*P_C_O2P;
	rate_COmole.b_C_OH_O_CH		    = HMRATE(2.25e-11,0.5,14800)*P_C_OH;
	rate_COmole.b_C_OHP_O_CHP	    = HMRATE(1.2e-9,0,0)*P_C_OHP;

	rate_COmole.b_CP_CH_CHP_C	    = HMRATE(3.8e-10,0,0)*P_CP_CH;
	rate_COmole.b_CP_CH2_CH2P_C	    = HMRATE(5.2e-10,0,0)*P_CP_CH2;
	rate_COmole.b_CP_H2O_HCOP_H	    = HMRATE(9.0e-10,0,0)*P_CP_H2O;
	rate_COmole.b_CP_O_COP_nu	    = HMRATE(2.5E-18,0,0)*P_CP_O;
	rate_COmole.b_CP_O2_COP_O	    = HMRATE(3.8e-10,0,0)*P_CP_O2;

	rate_COmole.b_O_CH_OH_C		    = HMRATE(2.52e-11,0,2381)*P_O_CH;
	rate_COmole.b_O_CH_HCOP_e	    = HMRATE(2.0e-11,0.44,0)*P_O_CH;
	rate_COmole.b_O_CHP_COP_H	    = HMRATE(3.5e-10,0,0)*P_O_CHP;
	rate_COmole.b_O_CH2_OH_CH	    = HMRATE(4.98e-10,0,6000)*P_O_CH2;
	rate_COmole.b_O_CH2P_HCOP_H	    = HMRATE((1e-10)*7.5,0,0)*P_O_CH2P;
	rate_COmole.b_O_CH3P_HCOP_H2     = HMRATE(4.0e-10,0,0)*P_O_CH3P;
	rate_COmole.b_O_H2O_OH_OH	    = HMRATE((1e-11)*1.85,0.95,8571)*P_O_H2O;
	rate_COmole.b_O_H2OP_O2P_H2	    = HMRATE(4.0e-11,0,0)*P_O_H2OP;
	rate_COmole.b_O_O_O2_nu		    = HMRATE(4.9E-20,1.58,0)*P_O_O;
	rate_COmole.b_O_OH_O2_H		    = HMRATE((1e-11)*4.34,-0.5,30)*P_O_OH;
	rate_COmole.b_O_OHP_O2P_H	    = HMRATE((1e-10)*7.1,0,0)*P_O_OHP;
	rate_COmole.b_O_Si_SiO_nu	    = HMRATE(5.52E-18,0.31,0)*P_O_Si;
	rate_COmole.b_O_SiP_SiOP_nu	    = HMRATE((1e-17)*1.,0,0)*P_O_SiP;
	rate_COmole.b_O_SiH_SiO_H	    = HMRATE(4.0e-11,0.5,0)*P_O_SiH;
	rate_COmole.b_O_SiH2P_SiOHP_H    = HMRATE((1e-10)*6.3,0,0)*P_O_SiH2P;
	rate_COmole.b_O_SiOP_O2_SiP	    = HMRATE(2.0e-10,0,0)*P_O_SiOP;
	rate_COmole.b_OP_CH_O_CHP	    = HMRATE(3.5e-10,0,0)*P_OP_CH;
	rate_COmole.b_OP_CH_COP_H	    = HMRATE(3.5e-10,0,0)*P_OP_CH;
	rate_COmole.b_OP_CH2_O_CH2P	    = HMRATE((1e-10)*9.7,0,0)*P_OP_CH2;
	rate_COmole.b_OP_H2O_H2OP_O	    = HMRATE((1e-9)*3.2,0,0)*P_OP_H2O;
	rate_COmole.b_OP_O2_O2P_O	    = HMRATE((1e-11)*1.9,0,0)*P_OP_O2;
	rate_COmole.b_OP_OH_O2P_H	    = HMRATE((1e-10)*3.6,0,0)*P_OP_OH;
	rate_COmole.b_OP_OH_OHP_O	    = HMRATE((1e-10)*3.6,0,0)*P_OP_OH;
	rate_COmole.b_Si_CHP_SiP_CH	    = HMRATE(2.0e-10,0,0)*P_Si_CHP;
	rate_COmole.b_Si_H2OP_SiP_H2O    = HMRATE(3.0e-9,0,0)*P_Si_H2OP;
	rate_COmole.b_Si_OH_SiO_H	    = HMRATE(2.0e-10,0.5,0)*P_Si_OH;
	rate_COmole.b_Si_O2P_O2_SiP	    = HMRATE((1e-9)*1.6,0,0)*P_Si_O2P;
	rate_COmole.b_SiP_H2O_SiOHP_H    = HMRATE((1e-10)*2.3,0,0)*P_SiP_H2O;
	rate_COmole.b_SiP_OH_SiOP_H	    = HMRATE((1e-10)*6.3,0,0)*P_SiP_OH;
	rate_COmole.b_SiP_O2_SiOP_O	    = HMRATE((1e-13)*1.,0,0)*P_SiP_O2;
	rate_COmole.b_CH_COP_HCOP_C	    = HMRATE((1e-10)*3.2,0,0)*P_CH_COP;
	rate_COmole.b_CH_H2OP_H2O_CHP    = HMRATE((1e-10)*3.4,0,0)*P_CH_H2OP;
	rate_COmole.b_CH_H2OP_OH_CH2P    = HMRATE((1e-10)*3.4,0,0)*P_CH_H2OP;
	rate_COmole.b_CH_H3OP_H2O_CH2P   = HMRATE((1e-10)*6.8,0,0)*P_CH_H3OP;
	rate_COmole.b_CH_O2P_O2_CHP      = HMRATE((1e-10)*3.1,0,0)*P_CH_O2P;
	rate_COmole.b_CH_O2P_HCOP_O      = HMRATE((1e-10)*3.1,0,0)*P_CH_O2P;
	rate_COmole.b_CH_OHP_OH_CHP      = HMRATE(3.5e-10,0,0)*P_CH_OHP;
	rate_COmole.b_CH_OHP_O_CH2P      = HMRATE(3.5e-10,0,0)*P_CH_OHP;
	rate_COmole.b_CH_SiOP_HCOP_Si    = HMRATE((1e-10)*5.9,0,0)*P_CH_SiOP;
	rate_COmole.b_CHP_H2O_H3OP_C     = HMRATE((1e-10)*5.8,0,0)*P_CHP_H2O;
	rate_COmole.b_CHP_H2O_HCOP_H2    = HMRATE((1e-9)*2.9,0,0)*P_CHP_H2O;
	rate_COmole.b_CHP_OH_COP_H2      = HMRATE(7.5e-10,0,0)*P_CHP_OH;	
	rate_COmole.b_CHP_O2_HCOP_O      = HMRATE((1e-10)*9.7,0,0)*P_CHP_O2;
	rate_COmole.b_CHP_O2_COP_OH      = HMRATE(1.0e-11,0,0)*P_CHP_O2;
	rate_COmole.b_CH2_COP_HCOP_CH    = HMRATE((1e-10)*4.3,0,0)*P_CH2_COP;
	rate_COmole.b_CH2_H2OP_H2O_CH2P  = HMRATE((1e-10)*4.7,0,0)*P_CH2_H2OP;
	rate_COmole.b_CH2_H2OP_OH_CH3P   = HMRATE((1e-10)*4.7,0,0)*P_CH2_H2OP;
	rate_COmole.b_CH2_H3OP_H2O_CH3P  = HMRATE((1e-10)*9.4,0,0)*P_CH2_H3OP;
	rate_COmole.b_CH2_O2P_O2_CH2P    = HMRATE((1e-10)*4.3,0,0)*P_CH2_O2P;
	rate_COmole.b_CH2_OH_H2O_CH      = HMRATE((1e-11)*1.44,0.5,3000)*P_CH2_OH;
	rate_COmole.b_CH2_OHP_OH_CH2P    = HMRATE((1e-10)*4.8,0,0)*P_CH2_OHP;
	rate_COmole.b_CH2_OHP_O_CH3P     = HMRATE((1e-10)*4.8,0,0)*P_CH2_OHP;
	rate_COmole.b_CH2P_O2_HCOP_OH    = HMRATE((1e-10)*9.1,0,0)*P_CH2P_O2;
	rate_COmole.b_H2O_COP_HCOP_OH    = HMRATE((1e-10)*8.84,0,0)*P_H2O_COP;
	rate_COmole.b_H2OP_H2O_H3OP_OH   = HMRATE((1e-9)*2.1,0,0)*P_H2OP_H2O;
	rate_COmole.b_H2OP_O2_O2P_H2O    = HMRATE((1e-10)*4.6,0,0)*P_H2OP_O2;
	rate_COmole.b_H3OP_SiH_SiH2P_H2O = HMRATE((1e-10)*9.7,0,0)*P_H3OP_SiH;
	rate_COmole.b_H3OP_SiO_SiOHP_H2O = HMRATE(2.0e-9,0,0)*P_H3OP_SiO;
	rate_COmole.b_OH_COP_HCOP_O      = HMRATE((1e-10)*3.1,0,0)*P_OH_COP;
	rate_COmole.b_OH_H2OP_H3OP_O     = HMRATE((1e-10)*6.9,0,0)*P_OH_H2OP;
	rate_COmole.b_OH_OH_H2O_O        = HMRATE((1e-12)*1.65,1.14,50)*P_OH_OH;
	rate_COmole.b_OHP_H2O_H3OP_O     = HMRATE(1.3e-9,0,0)*P_OHP_H2O;
	rate_COmole.b_OHP_H2O_H2OP_OH    = HMRATE((1e-9)*1.59,0,0)*P_OHP_H2O;
	rate_COmole.b_OHP_O2_O2P_OH      = HMRATE((1e-10)*5.9,0,0)*P_OHP_O2;
	rate_COmole.b_OHP_OH_H2OP_O      = HMRATE(7.0e-10,0,0)*P_OHP_OH;
	rate_COmole.b_OHP_SiH_SiH2P_O    = HMRATE(1.0e-9,0,0)*P_OHP_SiH;
	rate_COmole.b_OHP_SiO_SiOHP_O    = HMRATE((1e-10)*9.4,0,0)*P_OHP_SiO;

	/* new bs */
	rate_COmole.b_C_CH5P_CH4_CHP     = HMRATE(1.2e-9,0,0)*P_C_CH5P;
	rate_COmole.b_O_CH4_OH_CH3       = HMRATE((1e-12)*2.29,2.2,3820)*P_O_CH4;
	rate_COmole.b_O_CH4P_OH_CH3P     = HMRATE(1.0e-9,0,0)*P_O_CH4P;
	rate_COmole.b_O_CH5P_H3OP_CH2    = HMRATE((1e-10)*2.2,0,0)*P_O_CH5P;
	rate_COmole.b_OP_CH4_OH_CH3P     = HMRATE(1.1e-10,0,0)*P_OP_CH4;
	rate_COmole.b_OP_CH4_CH4P_O      = HMRATE((1e-10)*8.9,0,0)*P_OP_CH4;
	rate_COmole.b_CH4_CH_CH3_CH2     = HMRATE((1e-11)*2.28,0.7,3000)*P_CH4_CH;
	rate_COmole.b_CH5P_CH_CH4_CH2P   = HMRATE((1e-10)*6.9,0,0)*P_CH5P_CH;
	rate_COmole.b_CH2_CH2_CH3_CH     = HMRATE(4.0e-10,0,5000)*P_CH2_CH2;
	rate_COmole.b_CH4_CH2_CH3_CH3    = HMRATE((1e-12)*7.13,0,5050)*P_CH4_CH2;
	rate_COmole.b_OH_CH2_O_CH3       = HMRATE((1e-11)*1.44,0.5,3000)*P_OH_CH2;
	rate_COmole.b_CH5P_CH2_CH4_CH3P  = HMRATE((1e-10)*9.6,0,0)*P_CH5P_CH2;
	rate_COmole.b_OH_CH3_CH4_O       = HMRATE((1e-14)*3.27,2.2,2240)*P_OH_CH3;
	rate_COmole.b_OH_CH3_H2O_CH2     = HMRATE((1e-10)*1.2,0,1400)*P_OH_CH3;
	rate_COmole.b_H2O_CH3_OH_CH4     = HMRATE((1e-15)*2.3,3.47,6681)*P_H2O_CH3;
	rate_COmole.b_CH3_CH3_CH4_CH2    = HMRATE((1e-12)*7.13,0,5052)*P_CH3_CH3;
	rate_COmole.b_OH_CH4_H2O_CH3     = HMRATE((1e-13)*3.77,2.42,1162)*P_OH_CH4;
	rate_COmole.b_OHP_CH4_CH5P_O     = HMRATE((1e-10)*1.95,0,0)*P_OHP_CH4;
	rate_COmole.b_OHP_CH4_H3OP_CH2   = HMRATE((1e-9)*1.31,0,0)*P_OHP_CH4;
	rate_COmole.b_H2OP_CH4_H3OP_CH3  = HMRATE((1e-9)*1.4,0,0)*P_H2OP_CH4;
	rate_COmole.b_COP_CH4_HCOP_CH3   = HMRATE((1e-10)*4.55,0,0)*P_COP_CH4;
	rate_COmole.b_CH4_CH4P_CH5P_CH3  = HMRATE((1e-9)*1.5,0,0)*P_CH4_CH4P;
	rate_COmole.b_H2O_CH4P_H3OP_CH3  = HMRATE((1e-9)*2.6,0,0)*P_H2O_CH4P;
	rate_COmole.b_O2_CH4P_O2P_CH4    = HMRATE(4.0e-10,0,0)*P_O2_CH4P;
	rate_COmole.b_H2O_CH5P_H3OP_CH4  = HMRATE((1e-9)*3.7,0,0)*P_H2O_CH5P;
	rate_COmole.b_CH5P_OH_H2OP_CH4   = HMRATE(7.0e-10,0,0)*P_CH5P_OH;
	/*>>chng 05 dec 17 The rate for this reaction comes from Eric Herbst's website */
	rate_COmole.b_C_CH_C2_H = HMRATE((1e-11)*6.59,0,0)*P_C_CH;
	rate_COmole.b_C_CN_C2_N = HMRATE(4.98e-10,0,18116)*P_C_CN;
	rate_COmole.b_C_CS_S_C2 = HMRATE((1e-11)*1.44,0.5,20435)*P_C_CS;
	rate_COmole.b_N_C2_CN_C = HMRATE((1e-11)*5.,0.5,0)*P_N_C2;
	rate_COmole.b_C2_S_CS_C = HMRATE((1e-11)*1.73,0.5,0)*P_C2_S;
	rate_COmole.b_NHP_C2_HCNP_C = HMRATE((1e-10)*4.9,0,0)*P_NHP_C2;
	rate_COmole.b_OP_C2_COP_C = HMRATE((1e-10)*4.8,0,0)*P_OP_C2;
	rate_COmole.b_C2_SP_CSP_C = HMRATE((1e-10)*8.1,0,0)*P_C2_SP;
	rate_COmole.b_C_C2P_C2_CP = HMRATE(1.1e-10,0,0)*P_C_C2P;
	rate_COmole.b_CH_C2P_C2_CHP = HMRATE((1e-10)*3.2,0,0)*P_CH_C2P;
	rate_COmole.b_NP_C2_C2P_N = HMRATE(1.0e-9,0,0)*P_NP_C2;
	rate_COmole.b_CH2_C2P_C2_CH2P = HMRATE((1e-10)*4.5,0,0)*P_CH2_C2P;
	rate_COmole.b_OP_C2_C2P_O = HMRATE((1e-10)*4.8,0,0)*P_OP_C2;
	rate_COmole.b_NH2_C2P_C2_NH2P = HMRATE((1e-10)*4.6,0,0)*P_NH2_C2P;
	rate_COmole.b_OHP_C2_C2P_OH = HMRATE((1e-10)*4.8,0,0)*P_OHP_C2;
	rate_COmole.b_OH_C2P_C2_OHP = HMRATE((1e-10)*6.5,0,0)*P_OH_C2P;
	rate_COmole.b_H2OP_C2_C2P_H2O = HMRATE((1e-10)*4.7,0,0)*P_H2OP_C2;
	rate_COmole.b_C2_CNP_CN_C2P = HMRATE((1e-10)*8.5,0,0)*P_C2_CNP;
	rate_COmole.b_C2_N2P_N2_C2P = HMRATE((1e-10)*8.4,0,0)*P_C2_N2P;
	rate_COmole.b_C2P_NO_NOP_C2 = HMRATE((1e-10)*3.4,0,0)*P_C2P_NO;
	rate_COmole.b_C2_O2P_O2_C2P = HMRATE((1e-10)*4.1,0,0)*P_C2_O2P;
	rate_COmole.b_C2P_S_SP_C2 = HMRATE((1e-10)*5.8,0,0)*P_C2P_S;
	rate_COmole.b_C_C_C2_nu = HMRATE(4.36E-18,0.35,161.3)*P_C_C;
	/*>>chng 05 dec 17 The rate for this reaction comes from Eric Herbst's website */
	rate_COmole.b_CP_CH_C2P_H = HMRATE(27e-9,-0.50,0)*P_CP_CH;
	rate_COmole.b_C_CHP_C2P_H = HMRATE(1.2e-9,0,0)*P_C_CHP;
	rate_COmole.b_CHP_CH_C2P_H2 = HMRATE((1e-10)*7.4,0,0)*P_CHP_CH;
	rate_COmole.b_N_C2P_CN_CP = HMRATE(4.0e-11,0,0)*P_N_C2P;
	rate_COmole.b_O_C2P_COP_C = HMRATE((1e-10)*3.1,0,0)*P_O_C2P;
	rate_COmole.b_C2P_S_CSP_C = HMRATE((1e-10)*5.8,0,0)*P_C2P_S;
	rate_COmole.b_CP_C_C2P_nu = HMRATE(4.01E-18,0.17,101.5)*P_CP_C;
	rate_COmole.b_C_NH_N_CH          = HMRATE((1e-11)*1.73,0.5,4000)*P_C_NH;
	rate_COmole.b_C_NH_CN_H            = HMRATE(1.1e-10,0.5,0)*P_C_NH;
	rate_COmole.b_C_N2_CN_N          = HMRATE((1e-11)*8.69,0,22600)*P_C_N2;
	rate_COmole.b_C_NO_CN_O            = HMRATE((1e-11)*4.8,0,0)*P_C_NO;
	rate_COmole.b_C_HS_S_CH            = HMRATE((1e-11)*1.2,0.58,5880)*P_C_HS;
	rate_COmole.b_C_HS_CS_H            = HMRATE(2.0e-11,0,0)*P_C_HS;
	rate_COmole.b_C_NS_S_CN            = HMRATE(2.0e-11,0.5,0)*P_C_NS;
	rate_COmole.b_C_NS_CS_N          = HMRATE((1e-11)*1.73,0.5,4000)*P_C_NS;
	rate_COmole.b_C_S2_CS_S            = HMRATE((1e-11)*1.73,0.5,0)*P_C_S2;
	rate_COmole.b_CH_N_NH_C          = HMRATE((1e-11)*3.03,0.65,1207)*P_CH_N;
	rate_COmole.b_CH_N_CN_H          = HMRATE((1e-10)*1.66,-0.09,0)*P_CH_N;
	rate_COmole.b_CH_N2_HCN_N        = HMRATE(0.00000000000056,0.88,10128)*P_CH_N2;
	rate_COmole.b_CH_NO_HCN_O          = HMRATE((1e-9)*5.59,0,10814)*P_CH_NO;
	rate_COmole.b_CH_NO_CN_OH          = HMRATE(2.32E-26,0,0)*P_CH_NO;
	rate_COmole.b_CH_NO_OCN_H          = HMRATE(1.13E-25,0,0)*P_CH_NO;
	rate_COmole.b_CH_HNO_NO_CH2        = HMRATE((1e-11)*1.73,0.5,0)*P_CH_HNO;
	rate_COmole.b_CH_S_HS_C          = HMRATE((1e-11)*1.73,0.5,4000)*P_CH_S;
	rate_COmole.b_CH_S_CS_H          = HMRATE((1e-12)*1.1,0,0)*P_CH_S;
	rate_COmole.b_N_NH_N2_H          = HMRATE((1e-11)*4.98,0,0)*P_N_NH;
	rate_COmole.b_N_CH3_HCN_H_H      = HMRATE((1e-13)*3.32,0,0)*P_N_CH3;
	rate_COmole.b_N_CH3_HCN_H2       = HMRATE((1e-11)*1.3,0.5,0)*P_N_CH3;
	rate_COmole.b_N_OH_O_NH          = HMRATE((1e-11)*1.88,0.1,10700)*P_N_OH;
	rate_COmole.b_N_OH_NO_H          = HMRATE((1e-11)*5.32,-0.25,0)*P_N_OH;
	rate_COmole.b_N_CN_N2_C          = HMRATE((1e-10)*3.,0,0)*P_N_CN;
	rate_COmole.b_N_SIH_SIN_H          = HMRATE((1e-11)*5.,0.5,0)*P_N_SIH;
	rate_COmole.b_N_NO_N2_O          = HMRATE((1e-11)*3.75,0,26)*P_N_NO;
	rate_COmole.b_N_HNO_NO_NH          = HMRATE((1e-12)*2.94,0.5,1000)*P_N_HNO;
	rate_COmole.b_N_HNO_N2O_H          = HMRATE((1e-12)*1.43,0.5,1500)*P_N_HNO;
	rate_COmole.b_N_O2_NO_O          = HMRATE((1e-12)*2.26,0.86,3134)*P_N_O2;
	rate_COmole.b_N_HS_NS_H          = HMRATE((1e-11)*1.73,0.5,0)*P_N_HS;
	rate_COmole.b_N_HS_S_NH          = HMRATE((1e-11)*1.73,0.5,9060)*P_N_HS;
	rate_COmole.b_N_CS_S_CN          = HMRATE((1e-11)*3.8,0.5,1160)*P_N_CS;
	rate_COmole.b_N_NS_S_N2          = HMRATE((1e-11)*1.73,0.5,0)*P_N_NS;
	rate_COmole.b_N_SO_NS_O          = HMRATE((1e-11)*4.68,0.5,8254)*P_N_SO;
	rate_COmole.b_N_SO_S_NO          = HMRATE((1e-11)*1.73,0.5,750)*P_N_SO;
	rate_COmole.b_N_S2_NS_S          = HMRATE((1e-11)*1.73,0.5,4000)*P_N_S2;
	rate_COmole.b_CH2_CN_HCN_CH        = HMRATE((1e-12)*5.3,0,2500)*P_CH2_CN;
	rate_COmole.b_CH2_NO_HCN_OH        = HMRATE(0.000000000000832,0,1443)*P_CH2_NO;
	rate_COmole.b_CH2_HNO_NO_CH3       = HMRATE((1e-11)*1.73,0.5,0)*P_CH2_HNO;
	rate_COmole.b_NH_NH_N2_H_H         = HMRATE((1e-9)*1.16,0,0)*P_NH_NH;
	rate_COmole.b_NH_NH_N2_H2          = HMRATE((1e-11)*1.7,0,0)*P_NH_NH;
	rate_COmole.b_NH_O_OH_N          = HMRATE((1e-11)*1.16,0,0)*P_NH_O;
	rate_COmole.b_NH_O_NO_H          = HMRATE((1e-10)*1.16,0,0)*P_NH_O;
	rate_COmole.b_NH_OH_HNO_H          = HMRATE((1e-11)*3.32,0,0)*P_NH_OH;
	rate_COmole.b_NH_OH_NH2_O          = HMRATE((1e-12)*2.93,0.1,5800)*P_NH_OH;
	rate_COmole.b_NH_OH_H2O_N          = HMRATE((1e-12)*3.11,1.2,0)*P_NH_OH;
	rate_COmole.b_NH_H2O_OH_NH2          = HMRATE((1e-12)*1.83,1.6,14090)*P_NH_H2O;
	rate_COmole.b_NH_CN_HCN_N          = HMRATE((1e-12)*2.94,0.5,1000)*P_NH_CN;
	rate_COmole.b_NH_NO_N2O_H          = HMRATE((1e-10)*1.16,-1.03,420)*P_NH_NO;
	rate_COmole.b_NH_NO_N2_O_H         = HMRATE((1e-11)*5.,0,0)*P_NH_NO;
	rate_COmole.b_NH_NO_N2_OH          = HMRATE((1e-11)*1.46,-0.58,37)*P_NH_NO;
	rate_COmole.b_NH_S_HS_N          = HMRATE((1e-11)*1.73,0.5,4000)*P_NH_S;
	rate_COmole.b_NH_S_NS_H          = HMRATE((1e-11)*1.73,0.5,0)*P_NH_S;
	rate_COmole.b_NH_NO2_HNO_NO          = HMRATE((1e-12)*5.72,0.5,2500)*P_NH_NO2;
	rate_COmole.b_NH_NO2_N2O_OH          = HMRATE((1e-13)*1.44,0, 1140)*P_NH_NO2;
	rate_COmole.b_CH3_NH3_CH4_NH2          = HMRATE(0.0000000000000955,0,4890)*P_CH3_NH3;
	rate_COmole.b_CH3_CN_HCN_CH2          = HMRATE((1e-12)*9.21,0.7,1500)*P_CH3_CN;
	rate_COmole.b_CH3_HNO_NO_CH4          = HMRATE((1e-11)*1.44,0.5,0)*P_CH3_HNO;
	rate_COmole.b_O_NH2_OH_NH          = HMRATE((1e-11)*1.39,0,40)*P_O_NH2;
	rate_COmole.b_O_NH2_NO_H2          = HMRATE((1e-12)*8.3,0,0)*P_O_NH2;
	rate_COmole.b_O_NH3_OH_NH2          = HMRATE((1e-11)*1.89,0,4003)*P_O_NH3;
	rate_COmole.b_O_CN_NO_C          = HMRATE((1e-11)*3.81,0.5,14545)*P_O_CN;
	rate_COmole.b_O_HCN_CN_OH          = HMRATE((1e-10)*6.21,0,12439)*P_O_HCN;
	rate_COmole.b_O_HCN_OCN_H          = HMRATE((1e-12)*1.36,1.38,3693)*P_O_HCN;
	rate_COmole.b_O_N2_NO_N          = HMRATE((1e-10)*2.51,0,38602)*P_O_N2;
	rate_COmole.b_O_NO_O2_N          = HMRATE((1e-11)*1.18,0,20413)*P_O_NO;
	rate_COmole.b_O_HNO_NO_OH          = HMRATE((1e-11)*6.,0,0)*P_O_HNO;
	rate_COmole.b_O_HNO_O2_NH          = HMRATE((1e-12)*2.94,0.5,3500)*P_O_HNO;
	rate_COmole.b_O_HNO_NO2_H          = HMRATE((1e-12)*1.44,0.5,0)*P_O_HNO;
	rate_COmole.b_O_HS_S_OH          = HMRATE((1e-11)*1.74,0.67,956)*P_O_HS;
	rate_COmole.b_O_HS_SO_H          = HMRATE((1e-10)*2.32,0,0)*P_O_HS;
	rate_COmole.b_O_OCN_O2_CN          = HMRATE((1e-10)*4.02,-1.43,3501)*P_O_OCN;
	rate_COmole.b_O_SIN_NO_SI          = HMRATE((1e-11)*2.5,0.5,0)*P_O_SIN;
	rate_COmole.b_O_SIN_SIO_N          = HMRATE((1e-11)*5.75,0.1,200)*P_O_SIN;
	rate_COmole.b_O_N2O_NO_NO          = HMRATE((1e-10)*1.15,0,13400)*P_O_N2O;
	rate_COmole.b_O_N2O_O2_N2          = HMRATE((1e-10)*1.66,0,14100)*P_O_N2O;
	rate_COmole.b_O_CS_SO_C          = HMRATE((1e-11)*4.68,0.5,28940)*P_O_CS;
	rate_COmole.b_O_NS_S_NO          = HMRATE((1e-11)*5.,0.5,0)*P_O_NS;
	rate_COmole.b_O_NS_SO_N          = HMRATE((1e-11)*1.73,0.5,4000)*P_O_NS;
	rate_COmole.b_O_SO_S_O2          = HMRATE(0.00000000000066,0,2760)*P_O_SO;
	rate_COmole.b_O_S2_SO_S          = HMRATE((1e-11)*1.73,0.5,0)*P_O_S2;
	rate_COmole.b_NH2_OH_NH3_O          = HMRATE(0.000000000000208,0.76,262)*P_NH2_OH;
	rate_COmole.b_NH2_OH_H2O_NH          = HMRATE((1e-12)*1.5,0,0)*P_NH2_OH;
	rate_COmole.b_NH2_NO_N2_OH_H         = HMRATE((1e-12)*1.49,0,0)*P_NH2_NO;
	rate_COmole.b_NH2_NO_N2_H2O          = HMRATE((1e-11)*4.27,-2.5,331)*P_NH2_NO;
	rate_COmole.b_CH4_CN_HCN_CH3          = HMRATE((1e-12)*3.14,1.53,504)*P_CH4_CN;
	rate_COmole.b_OH_NH3_H2O_NH2          = HMRATE((1e-13)*1.47,2.05,7)*P_OH_NH3;
	rate_COmole.b_OH_CN_HCN_O          = HMRATE(1.0e-11,0,1000)*P_OH_CN;
	rate_COmole.b_OH_CN_OCN_H          = HMRATE((1e-11)*7.,0,0)*P_OH_CN;
	rate_COmole.b_OH_HCN_CN_H2O          = HMRATE((1e-13)*1.87,1.5,3887)*P_OH_HCN;
	rate_COmole.b_OH_NO_NO2_H          = HMRATE((1e-12)*5.2,0,15100)*P_OH_NO;
	rate_COmole.b_OH_S_HS_O          = HMRATE(6.6e-11,0,0)*P_OH_S;
	rate_COmole.b_OH_S_SO_H          = HMRATE(6.6e-11,0,0)*P_OH_S;
	rate_COmole.b_OH_N2O_HNO_NO          = HMRATE(1.04E-17,4.33,12623)*P_OH_N2O;
	rate_COmole.b_OH_CS_OCS_H          = HMRATE(0.0000000000000939,1.12,800)*P_OH_CS;
	rate_COmole.b_NH3_CN_HCN_NH2          = HMRATE((1e-11)*2.6,-1.1,0)*P_NH3_CN;
	rate_COmole.b_CN_NO_OCN_N          = HMRATE((1e-10)*1.62,0,21205)*P_CN_NO;
	rate_COmole.b_CN_HNO_NO_HCN          = HMRATE((1e-11)*1.5,0.5,0)*P_CN_HNO;
	rate_COmole.b_CN_S_NS_C          = HMRATE((1e-11)*5.71,0.5,32010)*P_CN_S;
	rate_COmole.b_CN_S_CS_N          = HMRATE((1e-11)*1.73,0.5,0)*P_CN_S;
	rate_COmole.b_N2_O2_N2O_O          = HMRATE(1.0e-10,0,55200)*P_N2_O2;
	rate_COmole.b_NO_NO_O2_N2          = HMRATE((1e-11)*2.51,0,30653)*P_NO_NO;
	rate_COmole.b_NO_NO_N2O_O          = HMRATE((1e-12)*7.22,0,33155)*P_NO_NO;
	rate_COmole.b_NO_HNO_N2O_OH          = HMRATE((1e-11)*1.41,0,14890)*P_NO_HNO;
	rate_COmole.b_NO_S_NS_O          = HMRATE(2.94e-11,0.5,17465)*P_NO_S;
	rate_COmole.b_NO_S_SO_N          = HMRATE((1e-10)*1.75,0,20200)*P_NO_S;
	rate_COmole.b_O2_S_SO_O          = HMRATE((1e-12)*2.28,0.52,0)*P_O2_S;
	rate_COmole.b_S_SO_S2_O          = HMRATE((1e-11)*1.73,0.5,11500)*P_S_SO;
	rate_COmole.b_C_NHP_N_CHP          = HMRATE((1e-9)*1.6,0,0)*P_C_NHP;
	rate_COmole.b_CP_NH_CNP_H          = HMRATE((1e-10)*7.8,0,0)*P_CP_NH;
	rate_COmole.b_CP_NH2_HCNP_H          = HMRATE(1.1e-9,0,0)*P_CP_NH2;
	rate_COmole.b_C_NH2P_NH_CHP          = HMRATE(1.2e-9,0,0)*P_C_NH2P;
	rate_COmole.b_CP_NH3_HCNP_H2          = HMRATE((1e-11)*7.,0,0)*P_CP_NH3;
	rate_COmole.b_C_NH3P_NH_CH2P          = HMRATE(1.0e-11,0,0)*P_C_NH3P;
	rate_COmole.b_C_HCNP_CN_CHP          = HMRATE(1.1e-9,0,0)*P_C_HCNP;
	rate_COmole.b_C_HNOP_NO_CHP          = HMRATE(1.0e-9,0,0)*P_C_HNOP;
	rate_COmole.b_CP_HS_CSP_H          = HMRATE(1.1e-9,0,0)*P_CP_HS;
	rate_COmole.b_C_HSP_CSP_H          = HMRATE((1e-10)*9.9,0,0)*P_C_HSP;
	rate_COmole.b_CP_OCN_COP_CN          = HMRATE((1e-9)*3.8,0,0)*P_CP_OCN;
	rate_COmole.b_CP_NS_CSP_N          = HMRATE((1e-10)*7.6,0,0)*P_CP_NS;
	rate_COmole.b_CP_SO_S_COP          = HMRATE((1e-10)*2.6,0,0)*P_CP_SO;
	rate_COmole.b_CP_SO_CSP_O          = HMRATE((1e-10)*2.6,0,0)*P_CP_SO;
	rate_COmole.b_CHP_N_CNP_H          = HMRATE((1e-10)*1.9,0,0)*P_CHP_N;
	rate_COmole.b_CH_NP_CNP_H          = HMRATE((1e-10)*3.6,0,0)*P_CH_NP;
	rate_COmole.b_CH_NHP_CH2P_N          = HMRATE((1e-10)*9.9,0,0)*P_CH_NHP;
	rate_COmole.b_CHP_NH_CNP_H2          = HMRATE((1e-10)*7.6,0,0)*P_CHP_NH;
	rate_COmole.b_CHP_NH2_HCNP_H2          = HMRATE(1.1e-9,0,0)*P_CHP_NH2;
	rate_COmole.b_CH_NH2P_NH_CH2P          = HMRATE(3.5e-10,0,0)*P_CH_NH2P;
	rate_COmole.b_CHP_NH3_NH4P_C          = HMRATE((1e-10)*4.05,0,0)*P_CHP_NH3;
	rate_COmole.b_CH_NH3P_NH4P_C          = HMRATE((1e-10)*6.9,0,0)*P_CH_NH3P;
	rate_COmole.b_CH_HCNP_CN_CH2P          = HMRATE((1e-10)*6.3,0,0)*P_CH_HCNP;
	rate_COmole.b_CH_HNOP_NO_CH2P          = HMRATE(6.2e-10,0,0)*P_CH_HNOP;
	rate_COmole.b_CHP_S_HSP_C          = HMRATE((1e-10)*4.7,0,0)*P_CHP_S;
	rate_COmole.b_CHP_S_CSP_H          = HMRATE((1e-10)*4.7,0,0)*P_CHP_S;
	rate_COmole.b_CH_SP_CSP_H          = HMRATE(6.2e-10,0,0)*P_CH_SP;
	rate_COmole.b_CH_HSP_S_CH2P          = HMRATE((1e-10)*5.8,0,0)*P_CH_HSP;
	rate_COmole.b_N_CH2P_HCNP_H          = HMRATE((1e-10)*2.2,0,0)*P_N_CH2P;
	rate_COmole.b_NP_NH_N2P_H          = HMRATE((1e-10)*3.7,0,0)*P_NP_NH;
	rate_COmole.b_N_NHP_N2P_H          = HMRATE(1.3e-9,0,0)*P_N_NHP;
	rate_COmole.b_NP_CH4_HCNP_H2_H          = HMRATE((1e-11)*5.6,0,0)*P_NP_CH4;
	rate_COmole.b_N_OHP_NOP_H          = HMRATE((1e-10)*8.9,0,0)*P_N_OHP;
	rate_COmole.b_NP_NH3_NH2P_NH          = HMRATE((1e-10)*2.16,0,0)*P_NP_NH3;
	rate_COmole.b_N_H2OP_HNOP_H          = HMRATE((1e-10)*1.9,0,0)*P_N_H2OP;
	rate_COmole.b_NP_NO_N2P_O          = HMRATE((1e-11)*7.9,0,0)*P_NP_NO;
	rate_COmole.b_NP_O2_NO_OP          = HMRATE((1e-11)*3.66,0,0)*P_NP_O2;
	rate_COmole.b_NP_O2_NOP_O          = HMRATE((1e-10)*2.63,0,0)*P_NP_O2;
	rate_COmole.b_N_O2P_NOP_O          = HMRATE((1e-10)*1.8,0,0)*P_N_O2P;
	rate_COmole.b_N_HSP_NSP_H          = HMRATE((1e-10)*7.4,0,0)*P_N_HSP;
	rate_COmole.b_N_SIOP_NOP_SI          = HMRATE((1e-11)*9.,0,0)*P_N_SIOP;
	rate_COmole.b_N_SIOP_NO_SIP          = HMRATE((1e-10)*2.1,0,0)*P_N_SIOP;
	rate_COmole.b_N_SOP_NSP_O          = HMRATE((1e-11)*5.,0,0)*P_N_SOP;
	rate_COmole.b_NP_OCS_CSP_NO          = HMRATE((1e-11)*7.,0,0)*P_NP_OCS;
	rate_COmole.b_CH2_NHP_CH3P_N          = HMRATE((1e-9)*1.4,0,0)*P_CH2_NHP;
	rate_COmole.b_CH2_NH2P_CH3P_NH          = HMRATE((1e-10)*4.9,0,0)*P_CH2_NH2P;
	rate_COmole.b_CH2P_NH3_NH4P_CH          = HMRATE((1e-9)*1.26,0,0)*P_CH2P_NH3;
	rate_COmole.b_CH2_NH3P_NH2_CH3P          = HMRATE((1e-10)*9.6,0,0)*P_CH2_NH3P;
	rate_COmole.b_CH2_HCNP_CN_CH3P          = HMRATE((1e-10)*8.7,0,0)*P_CH2_HCNP;
	rate_COmole.b_CH2_HNOP_NO_CH3P          = HMRATE((1e-10)*8.6,0,0)*P_CH2_HNOP;
	rate_COmole.b_CH2P_S_HCSP_H          = HMRATE((1e-9)*1.4,0,0)*P_CH2P_S;
	rate_COmole.b_CH2_SP_HCSP_H          = HMRATE(1.0e-11,0,0)*P_CH2_SP;
	rate_COmole.b_NHP_NH_NH2P_N          = HMRATE(1.0e-9,0,0)*P_NHP_NH;
	rate_COmole.b_NHP_O_OHP_N          = HMRATE(1.0e-9,0,0)*P_NHP_O;
	rate_COmole.b_NH_OP_NOP_H          = HMRATE((1e-10)*3.6,0,0)*P_NH_OP;
	rate_COmole.b_NHP_NH2_NH3P_N          = HMRATE((1e-9)*1.5,0,0)*P_NHP_NH2;
	rate_COmole.b_NH_NH2P_NH3P_N          = HMRATE((1e-10)*7.3,0,0)*P_NH_NH2P;
	rate_COmole.b_NHP_OH_H2OP_N          = HMRATE(1.0e-9,0,0)*P_NHP_OH;
	rate_COmole.b_NH_OHP_NH2P_O          = HMRATE((1e-10)*3.6,0,0)*P_NH_OHP;
	rate_COmole.b_NHP_NH3_NH4P_N          = HMRATE((1e-10)*6.,0,0)*P_NHP_NH3;
	rate_COmole.b_NH_NH3P_NH4P_N          = HMRATE((1e-10)*7.1,0,0)*P_NH_NH3P;
	rate_COmole.b_NH_CH5P_CH4_NH2P          = HMRATE((1e-10)*7.1,0,0)*P_NH_CH5P;
	rate_COmole.b_NHP_H2O_NH3P_O          = HMRATE((1e-10)*1.75,0,0)*P_NHP_H2O;
	rate_COmole.b_NHP_H2O_H3OP_N          = HMRATE((1e-9)*1.05,0,0)*P_NHP_H2O;
	rate_COmole.b_NHP_H2O_HNOP_H2          = HMRATE(3.5e-10,0,0)*P_NHP_H2O;
	rate_COmole.b_NH_H2OP_H3OP_N          = HMRATE((1e-10)*7.1,0,0)*P_NH_H2OP;
	rate_COmole.b_NHP_H2O_OH_NH2P          = HMRATE((1e-10)*8.75,0,0)*P_NHP_H2O;
	rate_COmole.b_NHP_CN_HCNP_N          = HMRATE((1e-9)*1.6,0,0)*P_NHP_CN;
	rate_COmole.b_NH_HCNP_CN_NH2P          = HMRATE((1e-10)*6.5,0,0)*P_NH_HCNP;
	rate_COmole.b_NH_COP_HCOP_N          = HMRATE((1e-10)*3.2,0,0)*P_NH_COP;
	rate_COmole.b_NH_SIP_SINP_H          = HMRATE(1.0e-9,0,0)*P_NH_SIP;
	rate_COmole.b_NH_HNOP_NO_NH2P          = HMRATE((1e-10)*6.3,0,0)*P_NH_HNOP;
	rate_COmole.b_NH_O2P_HNOP_O          = HMRATE((1e-10)*3.2,0,0)*P_NH_O2P;
	rate_COmole.b_NHP_O2_NOP_OH          = HMRATE((1e-10)*2.05,0,0)*P_NHP_O2;
	rate_COmole.b_NH_O2P_NO2P_H          = HMRATE((1e-10)*3.2,0,0)*P_NH_O2P;
	rate_COmole.b_NHP_S_HSP_N          = HMRATE((1e-10)*6.9,0,0)*P_NHP_S;
	rate_COmole.b_NHP_S_NSP_H          = HMRATE((1e-10)*6.9,0,0)*P_NHP_S;
	rate_COmole.b_NH_SP_NSP_H          = HMRATE((1e-10)*6.3,0,0)*P_NH_SP;
	rate_COmole.b_CH3P_NH3_NH4P_CH2          = HMRATE((1e-10)*3.4,0,0)*P_CH3P_NH3;
	rate_COmole.b_CH3P_S_HCSP_H2          = HMRATE((1e-9)*1.4,0,0)*P_CH3P_S;
	rate_COmole.b_O_NH2P_HNOP_H          = HMRATE((1e-11)*7.2,0,0)*P_O_NH2P;
	rate_COmole.b_O_NH3P_HNOP_H2          = HMRATE(1.0e-11,0,0)*P_O_NH3P;
	rate_COmole.b_OP_CN_NOP_C          = HMRATE(1.0e-9,0,0)*P_OP_CN;
	rate_COmole.b_OP_HCN_COP_NH          = HMRATE(1.2e-9,0,0)*P_OP_HCN;
	rate_COmole.b_OP_HCN_NOP_CH          = HMRATE(1.2e-9,0,0)*P_OP_HCN;
	rate_COmole.b_OP_HCN_HCOP_N          = HMRATE(1.2e-9,0,0)*P_OP_HCN;
	rate_COmole.b_OP_N2_NOP_N          = HMRATE((1e-12)*1.2,0,0)*P_OP_N2;
	rate_COmole.b_O_N2P_NOP_N          = HMRATE((1e-10)*1.3,0,0)*P_O_N2P;
	rate_COmole.b_O_HNOP_NO2P_H          = HMRATE((1e-12)*1.,0,0)*P_O_HNOP;
	rate_COmole.b_O_HSP_SP_OH          = HMRATE((1e-10)*2.9,0,0)*P_O_HSP;
	rate_COmole.b_O_HSP_SOP_H          = HMRATE((1e-10)*2.9,0,0)*P_O_HSP;
	rate_COmole.b_O_SINP_SIOP_N          = HMRATE(1.0e-9,0,0)*P_O_SINP;
	rate_COmole.b_OP_N2O_NOP_NO          = HMRATE((1e-10)*6.3,0,0)*P_OP_N2O;
	rate_COmole.b_O_CSP_S_COP          = HMRATE((1e-11)*6.,0,0)*P_O_CSP;
	rate_COmole.b_O_HCSP_S_HCOP          = HMRATE((1e-12)*5.,0,0)*P_O_HCSP;
	rate_COmole.b_O_HCSP_OCSP_H          = HMRATE((1e-12)*5.,0,0)*P_O_HCSP;
	rate_COmole.b_OP_NO2_O2_NOP          = HMRATE((1e-10)*8.3,0,0)*P_OP_NO2;
	rate_COmole.b_O_NSP_S_NOP          = HMRATE((1e-10)*6.1,0,0)*P_O_NSP;
	rate_COmole.b_NH2P_NH2_NH3P_NH          = HMRATE(1.0e-9,0,0)*P_NH2P_NH2;
	rate_COmole.b_NH2_OHP_NH3P_O          = HMRATE(5.0e-10,0,0)*P_NH2_OHP;
	rate_COmole.b_NH2P_OH_H2OP_NH          = HMRATE((1e-10)*7.1,0,0)*P_NH2P_OH;
	rate_COmole.b_NH2P_NH3_NH4P_NH          = HMRATE((1e-9)*1.61,0,0)*P_NH2P_NH3;
	rate_COmole.b_NH2_NH3P_NH4P_NH          = HMRATE(1.0e-11,0,0)*P_NH2_NH3P;
	rate_COmole.b_NH2_CH5P_NH3P_CH4          = HMRATE((1e-10)*9.9,0,0)*P_NH2_CH5P;
	rate_COmole.b_NH2P_H2O_NH3P_OH          = HMRATE(1.0e-10,0,0)*P_NH2P_H2O;
	rate_COmole.b_NH2P_H2O_H3OP_NH          = HMRATE((1e-9)*2.76,0,0)*P_NH2P_H2O;
	rate_COmole.b_NH2_H2OP_NH3P_OH          = HMRATE((1e-10)*4.9,0,0)*P_NH2_H2OP;
	rate_COmole.b_NH2P_H2O_NH4P_O          = HMRATE((1e-10)*1.45,0,0)*P_NH2P_H2O;
	rate_COmole.b_NH2_H3OP_H2O_NH3P          = HMRATE((1e-10)*9.7,0,0)*P_NH2_H3OP;
	rate_COmole.b_NH2_HCNP_CN_NH3P          = HMRATE(9.0e-10,0,0)*P_NH2_HCNP;
	rate_COmole.b_NH2_COP_HCOP_NH          = HMRATE((1e-10)*4.5,0,0)*P_NH2_COP;
	rate_COmole.b_NH2_HNOP_NO_NH3P          = HMRATE((1e-10)*8.8,0,0)*P_NH2_HNOP;
	rate_COmole.b_NH2P_O2_HNOP_OH          = HMRATE((1e-11)*2.1,0,0)*P_NH2P_O2;
	rate_COmole.b_NH2P_S_HSP_NH          = HMRATE((1e-10)*4.4,0,0)*P_NH2P_S;
	rate_COmole.b_CH4P_NH3_NH4P_CH3          = HMRATE((1e-9)*1.15,0,0)*P_CH4P_NH3;
	rate_COmole.b_CH4_NH3P_NH4P_CH3          = HMRATE((1e-10)*4.8,0,0)*P_CH4_NH3P;
	rate_COmole.b_CH4_N2P_N2_CH2P_H2          = HMRATE((1e-11)*7.,0,0)*P_CH4_N2P;
	rate_COmole.b_CH4_N2P_N2_CH3P_H          = HMRATE((1e-10)*9.3,0,0)*P_CH4_N2P;
	rate_COmole.b_CH4_HNOP_NO_CH5P          = HMRATE(1.0e-10,0,0)*P_CH4_HNOP;
	rate_COmole.b_CH4_SP_HCSP_H2_H          = HMRATE(2.0e-11,0,0)*P_CH4_SP;
	rate_COmole.b_CH4_CSP_HCSP_CH3          = HMRATE(5.0e-10,0,0)*P_CH4_CSP;
	rate_COmole.b_OHP_NH3_NH4P_O          = HMRATE(1.2e-9,0,0)*P_OHP_NH3;
	rate_COmole.b_OH_NH3P_NH4P_O          = HMRATE(7.0e-10,0,0)*P_OH_NH3P;
	rate_COmole.b_OHP_CN_HCNP_O          = HMRATE(1.0e-9,0,0)*P_OHP_CN;
	rate_COmole.b_OH_HCNP_CN_H2OP          = HMRATE((1e-10)*6.3,0,0)*P_OH_HCNP;
	rate_COmole.b_OHP_NO_HNOP_O          = HMRATE((1e-10)*6.11,0,0)*P_OHP_NO;
	rate_COmole.b_OH_HNOP_NO_H2OP          = HMRATE(6.2e-10,0,0)*P_OH_HNOP;
	rate_COmole.b_OHP_S_HSP_O          = HMRATE((1e-10)*4.3,0,0)*P_OHP_S;
	rate_COmole.b_OHP_S_SOP_H          = HMRATE((1e-10)*4.3,0,0)*P_OHP_S;
	rate_COmole.b_OH_SP_SOP_H          = HMRATE((1e-10)*6.1,0,0)*P_OH_SP;
	rate_COmole.b_NH3P_NH3_NH4P_NH2          = HMRATE((1e-9)*2.2,0,0)*P_NH3P_NH3;
	rate_COmole.b_NH3_CH5P_NH4P_CH4          = HMRATE((1e-9)*2.5,0,0)*P_NH3_CH5P;
	rate_COmole.b_NH3P_H2O_NH4P_OH          = HMRATE(1.1e-10,0,0)*P_NH3P_H2O;
	rate_COmole.b_NH3_H2OP_NH4P_OH          = HMRATE((1e-10)*9.45,0,0)*P_NH3_H2OP;
	rate_COmole.b_NH3_H3OP_NH4P_H2O          = HMRATE((1e-9)*2.2,0,0)*P_NH3_H3OP;
	rate_COmole.b_NH3_COP_HCOP_NH2          = HMRATE((1e-11)*4.12,0,0)*P_NH3_COP;
	rate_COmole.b_NH3_HNOP_NO_NH4P          = HMRATE(1.1e-9,0,0)*P_NH3_HNOP;
	rate_COmole.b_NH3_HSP_S_NH4P          = HMRATE((1e-10)*9.75,0,0)*P_NH3_HSP;
	rate_COmole.b_NH3_HCSP_CS_NH4P          = HMRATE(2.0e-9,0,0)*P_NH3_HCSP;
	rate_COmole.b_CH5P_S_HSP_CH4          = HMRATE(1.3e-9,0,0)*P_CH5P_S;
	rate_COmole.b_H2O_CNP_HCNP_OH          = HMRATE((1e-9)*1.6,0,0)*P_H2O_CNP;
	rate_COmole.b_H2O_CNP_HCOP_NH          = HMRATE((1e-10)*1.6,0,0)*P_H2O_CNP;
	rate_COmole.b_H2O_HCNP_CN_H3OP          = HMRATE((1e-9)*1.8,0,0)*P_H2O_HCNP;
	rate_COmole.b_H2O_HNOP_NO_H3OP          = HMRATE((1e-9)*2.3,0,0)*P_H2O_HNOP;
	rate_COmole.b_H2OP_S_HSP_OH          = HMRATE((1e-10)*4.3,0,0)*P_H2OP_S;
	rate_COmole.b_H2O_HSP_S_H3OP          = HMRATE((1e-10)*7.8,0,0)*P_H2O_HSP;
	rate_COmole.b_H3OP_CS_HCSP_H2O          = HMRATE(1.0e-9,0,0)*P_H3OP_CS;
	rate_COmole.b_CNP_NO_OCNP_N          = HMRATE((1e-10)*1.9,0,0)*P_CNP_NO;
	rate_COmole.b_CN_HNOP_NO_HCNP          = HMRATE((1e-10)*8.7,0,0)*P_CN_HNOP;
	rate_COmole.b_CNP_O2_OCNP_O          = HMRATE((1e-11)*8.6,0,0)*P_CNP_O2;
	rate_COmole.b_HCNP_S_HSP_CN          = HMRATE((1e-10)*5.7,0,0)*P_HCNP_S;
	rate_COmole.b_HNOP_S_HSP_NO          = HMRATE(1.1e-9,0,0)*P_HNOP_S;
	rate_COmole.b_O2_SP_SOP_O          = HMRATE((1e-11)*1.5,0,0)*P_O2_SP;
	rate_COmole.b_O2P_S_SOP_O          = HMRATE(5.4e-10,0,0)*P_O2P_S;
	rate_COmole.b_O2_CSP_OCSP_O          = HMRATE((1e-10)*1.3,0,0)*P_O2_CSP;
	rate_COmole.b_S_SIOP_SO_SIP          = HMRATE(1.0e-9,0,0)*P_S_SIOP;
	rate_COmole.b_CP_NH3_NH3P_C          = HMRATE((1e-10)*5.06,0,0)*P_CP_NH3;
	rate_COmole.b_C_CNP_CN_CP          = HMRATE(1.1e-10,0,0)*P_C_CNP;
	rate_COmole.b_C_N2P_N2_CP          = HMRATE(1.1e-10,0,0)*P_C_N2P;
	rate_COmole.b_CP_NO_NOP_C          = HMRATE(5.2e-10,0,0)*P_CP_NO;
	rate_COmole.b_CP_SIN_SINP_C          = HMRATE(1.0e-9,0,0)*P_CP_SIN;
	rate_COmole.b_C_CSP_CS_CP          = HMRATE((1e-9)*1.6,0,0)*P_C_CSP;
	rate_COmole.b_CP_NS_NSP_C          = HMRATE((1e-10)*7.6,0,0)*P_CP_NS;
	rate_COmole.b_CP_SO_SOP_C          = HMRATE((1e-10)*2.6,0,0)*P_CP_SO;
	rate_COmole.b_CP_OCS_OCSP_C          = HMRATE(4.0e-10,0,0)*P_CP_OCS;

		/* >>chng 05 mar 20, NA, 
	 * The rate for C+ + OH -> CO+ + H or CO + H+ is a power fit to the
	   data given in Table 1 of 
	>> refer	Dubernet et al. 1992, ApJ, 239, 855 */

	/* >>chng 05 aug 17, NA, need to use UMIST rate for PDR comparison, even though the rate is 
	 * an order of magnitude too small at 50 K 
	 * >> refer	Dubernet et al. 1992, ApJ, 239, 855 */

	if(!co.lgUMISTrates)
	{
		rate_COmole.b_CP_OH_COP_H = HMRATE(7.7e-10,0,0)*P_CP_OH;
	}

	else
	{
		rate_COmole.b_CP_OH_COP_H = HMRATE(2.7e-9,-0.3508,0)*P_CP_OH;
	}

	rate_COmole.b_CH_NH2P_NH2_CHP          = HMRATE(3.5e-10,0,0)*P_CH_NH2P;
	rate_COmole.b_CHP_NH3_NH3P_CH          = HMRATE((1e-10)*4.59,0,0)*P_CHP_NH3;
	rate_COmole.b_CH_CNP_CN_CHP          = HMRATE((1e-10)*6.4,0,0)*P_CH_CNP;
	rate_COmole.b_CH_N2P_N2_CHP          = HMRATE((1e-10)*6.3,0,0)*P_CH_N2P;
	rate_COmole.b_CHP_NO_NOP_CH          = HMRATE((1e-10)*7.6,0,0)*P_CHP_NO;
	rate_COmole.b_NP_NH_NHP_N          = HMRATE((1e-10)*3.7,0,0)*P_NP_NH;
	rate_COmole.b_NP_NH2_NH2P_N          = HMRATE(1.0e-9,0,0)*P_NP_NH2;
	rate_COmole.b_NP_NH3_NH3P_N          = HMRATE((1e-9)*1.97,0,0)*P_NP_NH3;
	rate_COmole.b_NP_CN_CNP_N          = HMRATE(1.1e-9,0,0)*P_NP_CN;
	rate_COmole.b_NP_HCN_HCNP_N          = HMRATE(1.2e-9,0,0)*P_NP_HCN;
	rate_COmole.b_N_N2P_N2_NP          = HMRATE(1.0e-11,0,0)*P_N_N2P;
	rate_COmole.b_NP_NO_NOP_N          = HMRATE((1e-10)*4.51,0,0)*P_NP_NO;
	rate_COmole.b_NP_OCS_OCSP_N          = HMRATE((1e-9)*1.02,0,0)*P_NP_OCS;
	rate_COmole.b_CH2_NH2P_NH2_CH2P          = HMRATE((1e-10)*4.9,0,0)*P_CH2_NH2P;
	rate_COmole.b_CH2_CNP_CN_CH2P          = HMRATE((1e-10)*8.8,0,0)*P_CH2_CNP;
	rate_COmole.b_CH2_N2P_N2_CH2P          = HMRATE((1e-10)*8.7,0,0)*P_CH2_N2P;
	rate_COmole.b_CH2P_NO_NOP_CH2          = HMRATE((1e-10)*4.2,0,0)*P_CH2P_NO;
	rate_COmole.b_NH_OP_O_NHP          = HMRATE((1e-10)*3.6,0,0)*P_NH_OP;
	rate_COmole.b_NH_OHP_OH_NHP          = HMRATE((1e-10)*3.6,0,0)*P_NH_OHP;
	rate_COmole.b_NHP_NH3_NH3P_NH          = HMRATE((1e-9)*1.8,0,0)*P_NHP_NH3;
	rate_COmole.b_NHP_H2O_H2OP_NH          = HMRATE((1e-9)*1.05,0,0)*P_NHP_H2O;
	rate_COmole.b_NH_CNP_CN_NHP          = HMRATE((1e-10)*6.5,0,0)*P_NH_CNP;
	rate_COmole.b_NH_N2P_N2_NHP          = HMRATE((1e-10)*6.5,0,0)*P_NH_N2P;
	rate_COmole.b_NHP_NO_NOP_NH          = HMRATE((1e-10)*7.12,0,0)*P_NHP_NO;
	rate_COmole.b_NHP_O2_O2P_NH          = HMRATE((1e-10)*4.51,0,0)*P_NHP_O2;
	rate_COmole.b_NHP_S_SP_NH          = HMRATE((1e-10)*6.9,0,0)*P_NHP_S;
	rate_COmole.b_CH3P_NO_NOP_CH3          = HMRATE(1.0e-9,0,0)*P_CH3P_NO;
	rate_COmole.b_OP_NH2_NH2P_O          = HMRATE(1.0e-9,0,0)*P_OP_NH2;
	rate_COmole.b_OP_NH3_NH3P_O          = HMRATE(1.2e-9,0,0)*P_OP_NH3;
	rate_COmole.b_O_CNP_CN_OP          = HMRATE((1e-11)*6.5,0,0)*P_O_CNP;
	rate_COmole.b_O_HCNP_HCN_OP          = HMRATE((1e-11)*6.5,0,0)*P_O_HCNP;
	rate_COmole.b_O_N2P_N2_OP          = HMRATE(1.0e-11,0,0)*P_O_N2P;
	rate_COmole.b_OP_NO_NOP_O          = HMRATE((1e-12)*1.7,0,0)*P_OP_NO;
	rate_COmole.b_OP_OCS_OCSP_O          = HMRATE((1e-10)*6.5,0,0)*P_OP_OCS;
	rate_COmole.b_NH2_OHP_OH_NH2P          = HMRATE(5.0e-10,0,0)*P_NH2_OHP;
	rate_COmole.b_NH2P_NH3_NH3P_NH2          = HMRATE((1e-10)*6.9,0,0)*P_NH2P_NH3;
	rate_COmole.b_NH2_H2OP_H2O_NH2P          = HMRATE((1e-10)*4.9,0,0)*P_NH2_H2OP;
	rate_COmole.b_NH2_CNP_CN_NH2P          = HMRATE((1e-10)*9.1,0,0)*P_NH2_CNP;
	rate_COmole.b_NH2_N2P_N2_NH2P          = HMRATE((1e-10)*8.9,0,0)*P_NH2_N2P;
	rate_COmole.b_NH2P_NO_NOP_NH2          = HMRATE(7.0e-10,0,0)*P_NH2P_NO;
	rate_COmole.b_NH2_O2P_O2_NH2P          = HMRATE((1e-10)*8.7,0,0)*P_NH2_O2P;
	rate_COmole.b_NH2P_S_SP_NH2          = HMRATE((1e-10)*4.4,0,0)*P_NH2P_S;
	rate_COmole.b_CH4P_NH3_NH3P_CH4          = HMRATE((1e-9)*1.65,0,0)*P_CH4P_NH3;
	rate_COmole.b_CH4P_OCS_OCSP_CH4          = HMRATE((1e-10)*4.2,0,0)*P_CH4P_OCS;
	rate_COmole.b_OHP_NH3_NH3P_OH          = HMRATE(1.2e-9,0,0)*P_OHP_NH3;
	rate_COmole.b_OH_CNP_CN_OHP          = HMRATE((1e-10)*6.4,0,0)*P_OH_CNP;
	rate_COmole.b_OH_N2P_N2_OHP          = HMRATE((1e-10)*6.3,0,0)*P_OH_N2P;
	rate_COmole.b_OHP_NO_NOP_OH          = HMRATE((1e-10)*3.59,0,0)*P_OHP_NO;
	rate_COmole.b_NH3_H2OP_H2O_NH3P          = HMRATE((1e-9)*2.21,0,0)*P_NH3_H2OP;
	rate_COmole.b_NH3_HCNP_HCN_NH3P          = HMRATE((1e-9)*1.68,0,0)*P_NH3_HCNP;
	rate_COmole.b_NH3_N2P_N2_NH3P          = HMRATE((1e-9)*1.9,0,0)*P_NH3_N2P;
	rate_COmole.b_NH3P_SI_SIP_NH3          = HMRATE((1e-9)*1.9,0,0)*P_NH3P_SI;
	rate_COmole.b_NH3_O2P_O2_NH3P          = HMRATE(2.0e-9,0,0)*P_NH3_O2P;
	rate_COmole.b_NH3_SP_S_NH3P          = HMRATE((1e-9)*1.44,0,0)*P_NH3_SP;
	rate_COmole.b_NH3_HSP_HS_NH3P          = HMRATE((1e-10)*5.25,0,0)*P_NH3_HSP;
	rate_COmole.b_NH3_SOP_SO_NH3P          = HMRATE(1.3e-9,0,0)*P_NH3_SOP;
	rate_COmole.b_H2O_HCNP_HCN_H2OP          = HMRATE((1e-9)*1.8,0,0)*P_H2O_HCNP;
	rate_COmole.b_H2O_N2P_N2_H2OP          = HMRATE((1e-9)*2.3,0,0)*P_H2O_N2P;
	rate_COmole.b_H2OP_NO_NOP_H2O          = HMRATE((1e-10)*2.7,0,0)*P_H2OP_NO;
	rate_COmole.b_CNP_HCN_HCNP_CN          = HMRATE((1e-9)*1.79,0,0)*P_CNP_HCN;
	rate_COmole.b_CN_N2P_N2_CNP          = HMRATE(1.0e-10,0,0)*P_CN_N2P;
	rate_COmole.b_CNP_NO_NOP_CN          = HMRATE((1e-10)*5.7,0,0)*P_CNP_NO;
	rate_COmole.b_CNP_O2_O2P_CN          = HMRATE((1e-10)*2.58,0,0)*P_CNP_O2;
	rate_COmole.b_CNP_S_SP_CN          = HMRATE(1.1e-9,0,0)*P_CNP_S;
	rate_COmole.b_HCN_N2P_N2_HCNP          = HMRATE((1e-10)*3.9,0,0)*P_HCN_N2P;
	rate_COmole.b_HCNP_NO_NOP_HCN          = HMRATE((1e-10)*8.1,0,0)*P_HCNP_NO;
	rate_COmole.b_HCNP_O2_O2P_HCN          = HMRATE((1e-10)*3.2,0,0)*P_HCNP_O2;
	rate_COmole.b_HCNP_S_SP_HCN          = HMRATE((1e-10)*5.7,0,0)*P_HCNP_S;
	rate_COmole.b_N2P_NO_NOP_N2          = HMRATE((1e-10)*4.4,0,0)*P_N2P_NO;
	rate_COmole.b_N2P_O2_O2P_N2          = HMRATE((1e-11)*5.,0,0)*P_N2P_O2;
	rate_COmole.b_N2P_S_SP_N2          = HMRATE(1.1e-9,0,0)*P_N2P_S;
	rate_COmole.b_SI_NOP_NO_SIP          = HMRATE((1e-9)*1.6,0,0)*P_SI_NOP;
	rate_COmole.b_SI_HSP_HS_SIP          = HMRATE((1e-9)*1.4,0,0)*P_SI_HSP;
	rate_COmole.b_SI_CSP_CS_SIP          = HMRATE((1e-10)*1.5,0,0)*P_SI_CSP;
	rate_COmole.b_NO_HNOP_HNO_NOP          = HMRATE(7.0e-10,0,0)*P_NO_HNOP;
	rate_COmole.b_NO_O2P_O2_NOP          = HMRATE((1e-10)*4.5,0,0)*P_NO_O2P;
	rate_COmole.b_NO_SP_S_NOP          = HMRATE((1e-10)*3.7,0,0)*P_NO_SP;
	rate_COmole.b_NO_HSP_HS_NOP          = HMRATE((1e-10)*4.5,0,0)*P_NO_HSP;
	rate_COmole.b_NO_SIOP_SIO_NOP          = HMRATE((1e-10)*7.2,0,0)*P_NO_SIOP;
	rate_COmole.b_NO_S2P_S2_NOP          = HMRATE((1e-10)*5.1,0,0)*P_NO_S2P;
	rate_COmole.b_O2P_NO2_NO2P_O2          = HMRATE((1e-10)*6.6,0,0)*P_O2P_NO2;
	rate_COmole.b_S_HSP_HS_SP          = HMRATE((1e-10)*9.7,0,0)*P_S_HSP;
	rate_COmole.b_C_N_CN_NU          = HMRATE((1e-17)*1.,0,0)*P_C_N;
	rate_COmole.b_C_S_CS_NU          = HMRATE(4.36E-19,0.22,0)*P_C_S;
	rate_COmole.b_CP_S_CSP_NU          = HMRATE(3.07E-19,0.15,0)*P_CP_S;
	rate_COmole.b_NP_N_N2P_NU          = HMRATE(3.71E-18,0.24,26.1)*P_NP_N;
	rate_COmole.b_CH_NP_N_CHP          = HMRATE((1e-10)*3.6,0,0)*P_CH_NP;
	rate_COmole.b_CHP_S_SP_CH          = HMRATE((1e-10)*4.7,0,0)*P_CHP_S;
	rate_COmole.b_NP_CH2_CH2P_N          = HMRATE(1.0e-9,0,0)*P_NP_CH2;
	rate_COmole.b_NP_CH4_CH4P_N          = HMRATE((1e-11)*2.8,0,0)*P_NP_CH4;
	rate_COmole.b_NP_OH_OHP_N          = HMRATE((1e-10)*3.7,0,0)*P_NP_OH;
	rate_COmole.b_NP_H2O_H2OP_N          = HMRATE((1e-9)*2.8,0,0)*P_NP_H2O;
	rate_COmole.b_NP_O2_O2P_N          = HMRATE((1e-10)*3.11,0,0)*P_NP_O2;
	rate_COmole.b_OP_O2_O2P_O          = HMRATE((1e-11)*1.9,0,0)*P_OP_O2;
	rate_COmole.b_OHP_S_SP_OH          = HMRATE((1e-10)*4.3,0,0)*P_OHP_S;
	rate_COmole.b_H2OP_S_SP_H2O          = HMRATE((1e-10)*4.3,0,0)*P_H2OP_S;
	rate_COmole.b_SI_SP_S_SIP          = HMRATE((1e-9)*1.6,0,0)*P_SI_SP;
	rate_COmole.b_O2P_S_SP_O2          = HMRATE(5.4e-10,0,0)*P_O2P_S;
	rate_COmole.b_O_CCl_ClO_C = HMRATE(0.000000000138,0,16050)*P_O_CCl;
	rate_COmole.b_O_ClO_Cl_O2 = HMRATE(0.000000000038,0,0)*P_O_ClO;
	rate_COmole.b_CP_HCl_CClP_H = HMRATE(0.0000000011,0,0)*P_CP_HCl;
	rate_COmole.b_CH3P_HCl_H2CClP_H2 = HMRATE(0.0000000013,0,0)*P_CH3P_HCl;
	rate_COmole.b_H2O_H2ClP_HCl_H3OP = HMRATE(0.000000002,0,0)*P_H2O_H2ClP;
	rate_COmole.b_CP_CCl_CClP_C = HMRATE(0.000000001,0,0)*P_CP_CCl;
	rate_COmole.b_CP_ClO_ClOP_C = HMRATE(0.000000001,0,0)*P_CP_ClO;
	rate_COmole.b_O2_ClP_Cl_O2P = HMRATE(0.00000000046,0,0)*P_O2_ClP;
	rate_COmole.b_CP_NH_CHP_N = 5e-10*P_CP_NH;
	rate_COmole.b_C_NH2_HNC_H = HMRATE(0.0000000000326,-0.1,-9)*P_ATC_NH2;
	rate_COmole.b_N_CH2_HNC_H = HMRATE(0.0000000000789,0.17,0)*P_ATN_CH2;
	rate_COmole.b_CHP_HNC_HCNHP_C = HMRATE(0.0000000018,0,0)*P_CHP_HNC;
	rate_COmole.b_CH_HCNHP_HNC_CH2P = HMRATE(0.000000000315,0,0)*P_CH_HCNHP;
	rate_COmole.b_CH2_HCNHP_HNC_CH3P = HMRATE(0.000000000435,0,0)*P_CH2_HCNHP;
	rate_COmole.b_NHP_HNC_HCNHP_N = HMRATE(0.0000000018,0,0)*P_NHP_HNC;
	rate_COmole.b_NH2P_HNC_HCNHP_NH = HMRATE(0.0000000012,0,0)*P_NH2P_HNC;
	rate_COmole.b_NH2_HCNHP_HNC_NH3P = HMRATE(0.000000000445,0,0)*P_NH2_HCNHP;
	rate_COmole.b_OHP_HNC_HCNHP_O = HMRATE(0.0000000012,0,0)*P_OHP_HNC;
	rate_COmole.b_NH3_HCNHP_HNC_NH4P = HMRATE(0.0000000011,0,0)*P_NH3_HCNHP;
	rate_COmole.b_CH5P_HNC_HCNHP_CH4 = HMRATE(0.0000000012,0,0)*P_CH5P_HNC;
	rate_COmole.b_H2OP_HNC_HCNHP_OH = HMRATE(0.0000000011,0,0)*P_H2OP_HNC;
	rate_COmole.b_H3OP_HNC_HCNHP_H2O = HMRATE(0.000000004,0,0)*P_H3OP_HNC;
	rate_COmole.b_HCNP_HNC_HCNHP_CN = HMRATE(0.000000001,0,0)*P_HCNP_HNC;
	rate_COmole.b_HNC_HNOP_NO_HCNHP = HMRATE(0.00000000099,0,0)*P_HNC_HNOP;
	rate_COmole.b_HNC_HSP_S_HCNHP = HMRATE(0.00000000086,0,0)*P_HNC_HSP;
	rate_COmole.b_CHP_HCN_HCNHP_C = HMRATE(0.0000000018,0,0)*P_CHP_HCN;
	rate_COmole.b_CH_HCNHP_HCN_CH2P = HMRATE(0.000000000315,0,0)*P_CH_HCNHP;
	rate_COmole.b_NP_CH4_HCNHP_H_H = HMRATE(0.00000000038,0,0)*P_NP_CH4;
	rate_COmole.b_CH2_HCNHP_HCN_CH3P = HMRATE(0.000000000435,0,0)*P_CH2_HCNHP;
	rate_COmole.b_NH_CH3P_HCNHP_H2 = HMRATE(0.00000000074,0,0)*P_NH_CH3P;
	rate_COmole.b_NHP_HCN_HCNHP_N    = HMRATE(0.0000000018,0,0)*P_NHP_HCN;
	rate_COmole.b_NH2P_HCN_HCNHP_NH  =	HMRATE(0.0000000012,0,0)*P_NH2P_HCN;
	rate_COmole.b_NH2_HCNHP_HCN_NH3P =	HMRATE(0.000000000445,0,0)*P_NH2_HCNHP;
	rate_COmole.b_CH4_HCNP_HCNHP_CH3 =	HMRATE(0.00000000104,0,0)*P_CH4_HCNP;
	rate_COmole.b_OHP_HCN_HCNHP_O    =	HMRATE(0.0000000012,0,0)*P_OHP_HCN;
	rate_COmole.b_NH3_HCNP_HCNHP_NH2 =	HMRATE(0.00000000084,0,0)*P_NH3_HCNP;
	rate_COmole.b_NH3_HCNHP_HCN_NH4P =	HMRATE(0.0000000011,0,0)*P_NH3_HCNHP;
	rate_COmole.b_CH5P_HCN_HCNHP_CH4 =	HMRATE(0.0000000012,0,0)*P_CH5P_HCN;
	rate_COmole.b_H2OP_HCN_HCNHP_OH  =	HMRATE(0.0000000011,0,0)*P_H2OP_HCN;
	rate_COmole.b_H3OP_HCN_HCNHP_H2O =	HMRATE(0.000000004,0,0)*P_H3OP_HCN;
	rate_COmole.b_HCNP_HCN_HCNHP_CN  =	HMRATE(0.0000000016,0,0)*P_HCNP_HCN;
	rate_COmole.b_HCN_HNOP_NO_HCNHP  =	HMRATE(0.00000000099,0,0)*P_HCN_HNOP;
	rate_COmole.b_HCN_HSP_S_HCNHP    =	HMRATE(0.00000000086,0,0)*P_HCN_HSP;




	 /* ***************************************************************************************************
	  *Here we are defining the reaction rates for all the reactions in the network, the exceptions		  *
	  * will be a few factors such as the CO self shielding term, this will come in later.  Each reaction *
	  * rate is labeled to make the actual reaction self-explanetary.  For example, in the first reaction *
	  * rate:																							  *	
	  *																									  *	
	  *    C_CH2_CH_CH_1																				  *
	  *																									  *
	  *the rate is for the reaction:																	  *
      *																								      *
	  *    C + CH2 -> CH + CH.																			  *
	  *																									  *
	  * All terms that are "coupled" (see below) will have a one or a two at the end.  Any future		  *
	  * reaction (for as long as this system is desired) should be put in this same way.				  *
	  *****************************************************************************************************/



	rate_COmole.C_CH2_CH_CH_1		    = HMRATE(2.69e-12,0,23550)*ATC;
	rate_COmole.C_H2OP_OH_CHP_1		    = HMRATE(1.1e-9,0,0)*ATC;
	rate_COmole.C_H3OP_HCOP_H2_1	    = HMRATE(1.0e-11,0,0)*ATC;
	rate_COmole.C_O2P_O2_CP_1		    = HMRATE(5.2e-11,0,0)*ATC;
	rate_COmole.C_O2P_COP_O_1		    = HMRATE(5.2e-11,0,0)*ATC;
	rate_COmole.C_OH_O_CH_1			    = HMRATE(2.25e-11,0.5,14800)*ATC;
	rate_COmole.C_OHP_O_CHP_1		    = HMRATE(1.2e-9,0,0)*ATC;
	/* >>chng 05 aug 02, NA add following three reactions */
	rate_COmole.CP_S_C_SP_1				= HMRATE(1.0e-9,0,0)*CP;
	rate_COmole.CP_S_C_SP_2				= HMRATE(1.0e-9,0,0)*ATS;
		/* >>chng 05 mar 20, NA, 
	 * The rate for C+ + OH -> CO+ + H or CO + H+ is a power fit to the
	 * data given in Table 1 of 
	>> refer	Dubernet et al. 1992, ApJ, 239, 855 */

	/* >>chng 05 aug 17, NA, need to use UMIST rate for PDR comparison, even though the rate is 
	 * an order of magnitude too small at 50 K 
	 * >> refer	Dubernet et al. 1992, ApJ, 239, 855 */

	if(!co.lgUMISTrates)
	{
		rate_COmole.CP_OH_COP_H_1		    = HMRATE(7.7e-10,0,0)*CP;
	}

	else
	{
		rate_COmole.CP_OH_COP_H_1		    = HMRATE(2.7e-9,-0.3508,0)*CP;
	}



	rate_COmole.CP_CH_CHP_C_1		    = HMRATE(3.8e-10,0,0)*CP;
	rate_COmole.CP_CH2_CH2P_C_1		    = HMRATE(5.2e-10,0,0)*CP;
	rate_COmole.CP_H2O_HCOP_H_1		    = HMRATE(9.0e-10,0,0)*CP;
	rate_COmole.CP_O_COP_nu_1		    = HMRATE(2.5E-18,0,0)*CP;
	rate_COmole.CP_O2_COP_O_1		    = HMRATE(3.8e-10,0,0)*CP;
	rate_COmole.O_CH_OH_C_1			    = HMRATE(2.52e-11,0,2381)*ATO;
	rate_COmole.O_CH_HCOP_e_1		    = HMRATE(2.0e-11,0.44,0)*ATO;
	rate_COmole.O_CHP_COP_H_1		    = HMRATE(3.5e-10,0,0)*ATO;
	rate_COmole.O_CH2_OH_CH_1		    = HMRATE(4.98e-10,0,6000)*ATO;
	rate_COmole.O_CH2P_HCOP_H_1		    = HMRATE((1e-10)*7.5,0,0)*ATO;
	rate_COmole.O_CH3P_HCOP_H2_1	    = HMRATE(4.0e-10,0,0)*ATO;
	rate_COmole.O_H2O_OH_OH_1		    = HMRATE((1e-11)*1.85,0.95,8571)*ATO;
	rate_COmole.O_H2OP_O2P_H2_1		    = HMRATE(4.0e-11,0,0)*ATO;
	rate_COmole.O_O_O2_nu_1			    = HMRATE(4.9E-20,1.58,0)*ATO;
	rate_COmole.O_OH_O2_H_1			    = HMRATE((1e-11)*4.34,-0.5,30)*ATO;
	rate_COmole.O_OHP_O2P_H_1		    = HMRATE((1e-10)*7.1,0,0)*ATO;
	rate_COmole.O_Si_SiO_nu_1		    = HMRATE(5.52E-18,0.31,0)*ATO;
	rate_COmole.O_SiP_SiOP_nu_1		    = HMRATE((1e-17)*1.,0,0)*ATO;
	rate_COmole.O_SiH_SiO_H_1		    = HMRATE(4.0e-11,0.5,0)*ATO;
	rate_COmole.O_SiH2P_SiOHP_H_1	    = HMRATE((1e-10)*6.3,0,0)*ATO;
	rate_COmole.O_SiOP_O2_SiP_1		    = HMRATE(2.0e-10,0,0)*ATO;
	rate_COmole.OP_CH_O_CHP_1		    = HMRATE(3.5e-10,0,0)*OP;
	rate_COmole.OP_CH_COP_H_1		    = HMRATE(3.5e-10,0,0)*OP;
	rate_COmole.OP_CH2_O_CH2P_1		    = HMRATE((1e-10)*9.7,0,0)*OP;
	rate_COmole.OP_H2O_H2OP_O_1		    = HMRATE((1e-9)*3.2,0,0)*OP;
	rate_COmole.OP_O2_O2P_O_1		    = HMRATE((1e-11)*1.9,0,0)*OP;
	rate_COmole.OP_OH_O2P_H_1		    = HMRATE((1e-10)*3.6,0,0)*OP;
	rate_COmole.OP_OH_OHP_O_1		    = HMRATE((1e-10)*3.6,0,0)*OP;
	rate_COmole.Si_CHP_SiP_CH_1		    = HMRATE(2.0e-10,0,0)*ATSI;
	rate_COmole.Si_H2OP_SiP_H2O_1	    = HMRATE(3.0e-9,0,0)*ATSI;
	rate_COmole.Si_OH_SiO_H_1		    = HMRATE(2.0e-10,0.5,0)*ATSI;
	rate_COmole.Si_O2P_O2_SiP_1		    = HMRATE((1e-9)*1.6,0,0)*ATSI;
	rate_COmole.SiP_H2O_SiOHP_H_1	    = HMRATE((1e-10)*2.3,0,0)*SIP;
	rate_COmole.SiP_OH_SiOP_H_1		    = HMRATE((1e-10)*6.3,0,0)*SIP;
	rate_COmole.SiP_O2_SiOP_O_1		    = HMRATE((1e-13)*1.,0,0)*SIP;
	rate_COmole.CH_COP_HCOP_C_1		    = HMRATE((1e-10)*3.2,0,0)*CH;
	rate_COmole.CH_H2OP_H2O_CHP_1	    = HMRATE((1e-10)*3.4,0,0)*CH;
	rate_COmole.CH_H2OP_OH_CH2P_1	    = HMRATE((1e-10)*3.4,0,0)*CH;	
	rate_COmole.CH_H3OP_H2O_CH2P_1	    = HMRATE((1e-10)*6.8,0,0)*CH;
	rate_COmole.CH_O2P_O2_CHP_1		    = HMRATE((1e-10)*3.1,0,0)*CH;
	rate_COmole.CH_O2P_HCOP_O_1		    = HMRATE((1e-10)*3.1,0,0)*CH;
	rate_COmole.CH_OHP_OH_CHP_1		    = HMRATE(3.5e-10,0,0)*CH;
	rate_COmole.CH_OHP_O_CH2P_1		    = HMRATE(3.5e-10,0,0)*CH;
	rate_COmole.CH_SiOP_HCOP_Si_1	    = HMRATE((1e-10)*5.9,0,0)*CH;
	rate_COmole.CHP_H2O_H3OP_C_1	    = HMRATE((1e-10)*5.8,0,0)*CHP;
	rate_COmole.CHP_H2O_HCOP_H2_1	    = HMRATE((1e-9)*2.9,0,0)*CHP;
	rate_COmole.CHP_OH_COP_H2_1	        = HMRATE(7.5e-10,0,0)*CHP;
	rate_COmole.CHP_O2_HCOP_O_1		    = HMRATE((1e-10)*9.7,0,0)*CHP;
	rate_COmole.CHP_O2_COP_OH_1		    = HMRATE(1.0e-11,0,0)*CHP;
	rate_COmole.CH2_COP_HCOP_CH_1	    = HMRATE((1e-10)*4.3,0,0)*CH2;
	rate_COmole.CH2_H2OP_H2O_CH2P_1     = HMRATE((1e-10)*4.7,0,0)*CH2;
	rate_COmole.CH2_H2OP_OH_CH3P_1	    = HMRATE((1e-10)*4.7,0,0)*CH2;
	rate_COmole.CH2_H3OP_H2O_CH3P_1     = HMRATE((1e-10)*9.4,0,0)*CH2;
	rate_COmole.CH2_O2P_O2_CH2P_1	    = HMRATE((1e-10)*4.3,0,0)*CH2;
	rate_COmole.CH2_OH_H2O_CH_1		    = HMRATE((1e-11)*1.44,0.5,3000)*CH2;
	rate_COmole.CH2_OHP_OH_CH2P_1	    = HMRATE((1e-10)*4.8,0,0)*CH2;
	rate_COmole.CH2_OHP_O_CH3P_1	    = HMRATE((1e-10)*4.8,0,0)*CH2;
	rate_COmole.CH2P_O2_HCOP_OH_1	    = HMRATE((1e-10)*9.1,0,0)*CH2P;
	rate_COmole.H2O_COP_HCOP_OH_1	    = HMRATE((1e-10)*8.84,0,0)*H2O;
	rate_COmole.H2OP_H2O_H3OP_OH_1	    = HMRATE((1e-9)*2.1,0,0)*H2OP;
	rate_COmole.H2OP_O2_O2P_H2O_1	    = HMRATE((1e-10)*4.6,0,0)*H2OP;
	rate_COmole.H3OP_SiH_SiH2P_H2O_1    = HMRATE((1e-10)*9.7,0,0)*H3OP;
	rate_COmole.H3OP_SiO_SiOHP_H2O_1    = HMRATE(2.0e-9,0,0)*H3OP;
	rate_COmole.OH_COP_HCOP_O_1		    = HMRATE((1e-10)*3.1,0,0)*OH;
	rate_COmole.OH_H2OP_H3OP_O_1	    = HMRATE((1e-10)*6.9,0,0)*OH;
	rate_COmole.OH_OH_H2O_O_1		    = HMRATE((1e-12)*1.65,1.14,50)*OH;
	rate_COmole.OHP_H2O_H3OP_O_1	    = HMRATE(1.3e-9,0,0)*OHP;
	rate_COmole.OHP_H2O_H2OP_OH_1	    = HMRATE((1e-9)*1.59,0,0)*OHP;
	rate_COmole.OHP_O2_O2P_OH_1		    = HMRATE((1e-10)*5.9,0,0)*OHP;
	rate_COmole.OHP_OH_H2OP_O_1		    = HMRATE(7.0e-10,0,0)*OHP;
	rate_COmole.OHP_SiH_SiH2P_O_1	    = HMRATE(1.0e-9,0,0)*OHP;
	rate_COmole.OHP_SiO_SiOHP_O_1	    = HMRATE((1e-10)*9.4,0,0)*OHP;

	rate_COmole.C_CH2_CH_CH_2		    = HMRATE(2.69e-12,0,23550)*CH2;
	rate_COmole.C_H2OP_OH_CHP_2		    = HMRATE(1.1e-9,0,0)*H2OP;
	rate_COmole.C_H3OP_HCOP_H2_2	    = HMRATE(1.0e-11,0,0)*H3OP;
	rate_COmole.C_O2P_O2_CP_2		    = HMRATE(5.2e-11,0,0)*O2P;
	rate_COmole.C_O2P_COP_O_2		    = HMRATE(5.2e-11,0,0)*O2P;
	rate_COmole.C_OH_O_CH_2			    = HMRATE(2.25e-11,0.5,14800)*OH;
	rate_COmole.C_OHP_O_CHP_2		    = HMRATE(1.2e-9,0,0)*OHP;
	/* >>chng 05 mar 20, NA, 
	* The rate for C+ + OH -> CO+ + H or CO + H+ is a power fit to the
	data given in Table 1 of 
	>> refer	Dubernet et al. 1992, ApJ, 239, 855 */

	/* >>chng 05 aug 17, NA, need to use UMIST rate for PDR comparison, even though the rate is 
	* an order of magnitude too small at 50 K 
	* >> refer	Dubernet et al. 1992, ApJ, 239, 855 */

	if(!co.lgUMISTrates)
	{
		rate_COmole.CP_OH_COP_H_2		    = HMRATE(7.7e-10,0,0)*OH;
	}

	else
	{
		rate_COmole.CP_OH_COP_H_2		    = HMRATE(2.7e-9,-0.3508,0)*OH;
	}


	rate_COmole.CP_CH_CHP_C_2		    = HMRATE(3.8e-10,0,0)*CH;
	rate_COmole.CP_CH2_CH2P_C_2		    = HMRATE(5.2e-10,0,0)*CH2;
	rate_COmole.CP_H2O_HCOP_H_2		    = HMRATE(9.0e-10,0,0)*H2O;
	rate_COmole.CP_O_COP_nu_2		    = HMRATE(2.5E-18,0,0)*ATO;
	rate_COmole.CP_O2_COP_O_2		    = HMRATE(3.8e-10,0,0)*O2;
	rate_COmole.O_CH_OH_C_2			    = HMRATE(2.52e-11,0,2381)*CH;
	rate_COmole.O_CH_HCOP_e_2		    = HMRATE(2.0e-11,0.44,0)*CH;
	rate_COmole.O_CHP_COP_H_2		    = HMRATE(3.5e-10,0,0)*CHP;
	rate_COmole.O_CH2_OH_CH_2		    = HMRATE(4.98e-10,0,6000)*CH2;
	rate_COmole.O_CH2P_HCOP_H_2		    = HMRATE((1e-10)*7.5,0,0)*CH2P;
	rate_COmole.O_CH3P_HCOP_H2_2	    = HMRATE(4.0e-10,0,0)*CH3P;
	rate_COmole.O_H2O_OH_OH_2		    = HMRATE((1e-11)*1.85,0.95,8571)*H2O;
	rate_COmole.O_H2OP_O2P_H2_2		    = HMRATE(4.0e-11,0,0)*H2OP;
	rate_COmole.O_O_O2_nu_2			    = HMRATE(4.9E-20,1.58,0)*ATO;
	rate_COmole.O_OH_O2_H_2			    = HMRATE((1e-11)*4.34,-0.5,30)*OH;
	rate_COmole.O_OHP_O2P_H_2		    = HMRATE((1e-10)*7.1,0,0)*OHP;
	rate_COmole.O_Si_SiO_nu_2		    = HMRATE(5.52E-18,0.31,0)*ATSI;
	rate_COmole.O_SiP_SiOP_nu_2		    = HMRATE((1e-17)*1.,0,0)*SIP;
	rate_COmole.O_SiH_SiO_H_2		    = HMRATE(4.0e-11,0.5,0)*SIH;
	rate_COmole.O_SiH2P_SiOHP_H_2	    = HMRATE((1e-10)*6.3,0,0)*SIH2P;
	rate_COmole.O_SiOP_O2_SiP_2		    = HMRATE(2.0e-10,0,0)*SIOP;
	rate_COmole.OP_CH_O_CHP_2		    = HMRATE(3.5e-10,0,0)*CH;
	rate_COmole.OP_CH_COP_H_2		    = HMRATE(3.5e-10,0,0)*CH;
	rate_COmole.OP_CH2_O_CH2P_2		    = HMRATE((1e-10)*9.7,0,0)*CH2;
	rate_COmole.OP_H2O_H2OP_O_2		    = HMRATE((1e-9)*3.2,0,0)*H2O;
	rate_COmole.OP_O2_O2P_O_2		    = HMRATE((1e-11)*1.9,0,0)*O2;
	rate_COmole.OP_OH_O2P_H_2		    = HMRATE((1e-10)*3.6,0,0)*OH;
	rate_COmole.OP_OH_OHP_O_2		    = HMRATE((1e-10)*3.6,0,0)*OH;
	rate_COmole.Si_CHP_SiP_CH_2		    = HMRATE(2.0e-10,0,0)*CHP;
	rate_COmole.Si_H2OP_SiP_H2O_2	    = HMRATE(3.0e-9,0,0)*H2OP;
	rate_COmole.Si_OH_SiO_H_2		    = HMRATE(2.0e-10,0.5,0)*OH;
	rate_COmole.Si_O2P_O2_SiP_2		    = HMRATE((1e-9)*1.6,0,0)*O2P;
	rate_COmole.SiP_H2O_SiOHP_H_2	    = HMRATE((1e-10)*2.3,0,0)*H2O;
	rate_COmole.SiP_OH_SiOP_H_2		    = HMRATE((1e-10)*6.3,0,0)*OH;
	rate_COmole.SiP_O2_SiOP_O_2		    = HMRATE((1e-13)*1.,0,0)*O2;
	rate_COmole.CH_COP_HCOP_C_2		    = HMRATE((1e-10)*3.2,0,0)*COP;
	rate_COmole.CH_H2OP_H2O_CHP_2	    = HMRATE((1e-10)*3.4,0,0)*H2OP;
	rate_COmole.CH_H2OP_OH_CH2P_2	    = HMRATE((1e-10)*3.4,0,0)*H2OP;
	rate_COmole.CH_H3OP_H2O_CH2P_2	    = HMRATE((1e-10)*6.8,0,0)*H3OP;
	rate_COmole.CH_O2P_O2_CHP_2		    = HMRATE((1e-10)*3.1,0,0)*O2P;
	rate_COmole.CH_O2P_HCOP_O_2		    = HMRATE((1e-10)*3.1,0,0)*O2P;
	rate_COmole.CH_OHP_OH_CHP_2		    = HMRATE(3.5e-10,0,0)*OHP;
	rate_COmole.CH_OHP_O_CH2P_2		    = HMRATE(3.5e-10,0,0)*OHP;
	rate_COmole.CH_SiOP_HCOP_Si_2	    = HMRATE((1e-10)*5.9,0,0)*SIOP;
	rate_COmole.CHP_H2O_H3OP_C_2	    = HMRATE((1e-10)*5.8,0,0)*H2O;
	rate_COmole.CHP_H2O_HCOP_H2_2	    = HMRATE((1e-9)*2.9,0,0)*H2O;
	rate_COmole.CHP_OH_COP_H2_2	        = HMRATE(7.5e-10,0,0)*OH;
	rate_COmole.CHP_O2_HCOP_O_2		    = HMRATE((1e-10)*9.7,0,0)*O2;
	rate_COmole.CHP_O2_COP_OH_2		    = HMRATE(1.0e-11,0,0)*O2;
	rate_COmole.CH2_COP_HCOP_CH_2	    = HMRATE((1e-10)*4.3,0,0)*COP;
	rate_COmole.CH2_H2OP_H2O_CH2P_2     = HMRATE((1e-10)*4.7,0,0)*H2OP;
	rate_COmole.CH2_H2OP_OH_CH3P_2	    = HMRATE((1e-10)*4.7,0,0)*H2OP;
	rate_COmole.CH2_H3OP_H2O_CH3P_2     = HMRATE((1e-10)*9.4,0,0)*H3OP;
	rate_COmole.CH2_O2P_O2_CH2P_2	    = HMRATE((1e-10)*4.3,0,0)*O2P;
	rate_COmole.CH2_OH_H2O_CH_2		    = HMRATE((1e-11)*1.44,0.5,3000)*OH;
	rate_COmole.CH2_OHP_OH_CH2P_2	    = HMRATE((1e-10)*4.8,0,0)*OHP;
	rate_COmole.CH2_OHP_O_CH3P_2	    = HMRATE((1e-10)*4.8,0,0)*OHP;
	rate_COmole.CH2P_O2_HCOP_OH_2	    = HMRATE((1e-10)*9.1,0,0)*O2;
	rate_COmole.H2O_COP_HCOP_OH_2	    = HMRATE((1e-10)*8.84,0,0)*COP;
	rate_COmole.H2OP_H2O_H3OP_OH_2	    = HMRATE((1e-9)*2.1,0,0)*H2O;
	rate_COmole.H2OP_O2_O2P_H2O_2	    = HMRATE((1e-10)*4.6,0,0)*O2;
	rate_COmole.H3OP_SiH_SiH2P_H2O_2    = HMRATE((1e-10)*9.7,0,0)*SIH;
	rate_COmole.H3OP_SiO_SiOHP_H2O_2    = HMRATE(2.0e-9,0,0)*SIO;
	rate_COmole.OH_COP_HCOP_O_2		    = HMRATE((1e-10)*3.1,0,0)*COP;
	rate_COmole.OH_H2OP_H3OP_O_2	    = HMRATE((1e-10)*6.9,0,0)*H2OP;
	rate_COmole.OH_OH_H2O_O_2		    = HMRATE((1e-12)*1.65,1.14,50)*OH;
	rate_COmole.OHP_H2O_H3OP_O_2	    = HMRATE(1.3e-9,0,0)*H2O;
	rate_COmole.OHP_H2O_H2OP_OH_2	    = HMRATE((1e-9)*1.59,0,0)*H2O;
	rate_COmole.OHP_O2_O2P_OH_2		    = HMRATE((1e-10)*5.9,0,0)*O2;
	rate_COmole.OHP_OH_H2OP_O_2		    = HMRATE(7.0e-10,0,0)*OH;
	rate_COmole.OHP_SiH_SiH2P_O_2	    = HMRATE(1.0e-9,0,0)*SIH;
	rate_COmole.OHP_SiO_SiOHP_O_2	    = HMRATE((1e-10)*9.4,0,0)*SIO;
	rate_COmole.C_CH5P_CH4_CHP_1	    = HMRATE(1.2e-9,0,0)*CH5P;
	rate_COmole.C_CH5P_CH4_CHP_2	    = HMRATE(1.2e-9,0,0)*ATC;
	rate_COmole.O_CH4_OH_CH3_1		    = HMRATE((1e-12)*2.29,2.2,3820)*CH4;
	rate_COmole.O_CH4_OH_CH3_2		    = HMRATE((1e-12)*2.29,2.2,3820)*ATO;
	rate_COmole.O_CH4P_OH_CH3P_1	    = HMRATE(1.0e-9,0,0)*CH4P;
	rate_COmole.O_CH4P_OH_CH3P_2	    = HMRATE(1.0e-9,0,0)*ATO;
	rate_COmole.O_CH5P_H3OP_CH2_1	    = HMRATE((1e-10)*2.2,0,0)*CH5P;
	rate_COmole.O_CH5P_H3OP_CH2_2	    = HMRATE((1e-10)*2.2,0,0)*ATO;
	rate_COmole.OP_CH4_OH_CH3P_1	    = HMRATE(1.1e-10,0,0)*CH4;
	rate_COmole.OP_CH4_OH_CH3P_2	    = HMRATE(1.1e-10,0,0)*OP;
	rate_COmole.OP_CH4_CH4P_O_1		    = HMRATE((1e-10)*8.9,0,0)*CH4;
	rate_COmole.OP_CH4_CH4P_O_2		    = HMRATE((1e-10)*8.9,0,0)*OP;
	rate_COmole.CH4_CH_CH3_CH2_1	    = HMRATE((1e-11)*2.28,0.7,3000)*CH;
	rate_COmole.CH4_CH_CH3_CH2_2	    = HMRATE((1e-11)*2.28,0.7,3000)*CH4;
	rate_COmole.CH5P_CH_CH4_CH2P_1      = HMRATE((1e-10)*6.9,0,0)*CH;
	rate_COmole.CH5P_CH_CH4_CH2P_2      = HMRATE((1e-10)*6.9,0,0)*CH5P;
	rate_COmole.CH2_CH2_CH3_CH_1	    = HMRATE(4.0e-10,0,5000)*CH2;
	rate_COmole.CH2_CH2_CH3_CH_2	    = HMRATE(4.0e-10,0,5000)*CH2;
	rate_COmole.CH4_CH2_CH3_CH3_1	    = HMRATE((1e-12)*7.13,0,5050)*CH2;
	rate_COmole.CH4_CH2_CH3_CH3_2	    = HMRATE((1e-12)*7.13,0,5050)*CH4;
	rate_COmole.OH_CH2_O_CH3_1		    = HMRATE((1e-11)*1.44,0.5,3000)*CH2;
	rate_COmole.OH_CH2_O_CH3_2		    = HMRATE((1e-11)*1.44,0.5,3000)*OH;
	rate_COmole.CH5P_CH2_CH4_CH3P_1     = HMRATE((1e-10)*9.6,0,0)*CH2;
	rate_COmole.CH5P_CH2_CH4_CH3P_2     = HMRATE((1e-10)*9.6,0,0)*CH5P;
	rate_COmole.OH_CH3_CH4_O_1		    = HMRATE((1e-14)*3.27,2.2,2240)*CH3;
	rate_COmole.OH_CH3_CH4_O_2		    = HMRATE((1e-14)*3.27,2.2,2240)*OH;
	rate_COmole.OH_CH3_H2O_CH2_1	    = HMRATE((1e-10)*1.2,0,1400)*CH3;
	rate_COmole.OH_CH3_H2O_CH2_2	    = HMRATE((1e-10)*1.2,0,1400)*OH;
	rate_COmole.H2O_CH3_OH_CH4_1	    = HMRATE((1e-15)*2.3,3.47,6681)*CH3;
	rate_COmole.H2O_CH3_OH_CH4_2	    = HMRATE((1e-15)*2.3,3.47,6681)*H2O;
	rate_COmole.CH3_CH3_CH4_CH2_1	    = HMRATE((1e-12)*7.13,0,5052)*CH3;
	rate_COmole.CH3_CH3_CH4_CH2_2	    = HMRATE((1e-12)*7.13,0,5052)*CH3;
	rate_COmole.OH_CH4_H2O_CH3_1	    = HMRATE((1e-13)*3.77,2.42,1162)*CH4;
	rate_COmole.OH_CH4_H2O_CH3_2	    = HMRATE((1e-13)*3.77,2.42,1162)*OH;
	rate_COmole.OHP_CH4_CH5P_O_1        = HMRATE((1e-10)*1.95,0,0)*CH4;
	rate_COmole.OHP_CH4_CH5P_O_2        = HMRATE((1e-10)*1.95,0,0)*OHP;
	rate_COmole.OHP_CH4_H3OP_CH2_1      = HMRATE((1e-9)*1.31,0,0)*CH4;
	rate_COmole.OHP_CH4_H3OP_CH2_2      = HMRATE((1e-9)*1.31,0,0)*OHP;
	rate_COmole.H2OP_CH4_H3OP_CH3_1     = HMRATE((1e-9)*1.4,0,0)*CH4;
	rate_COmole.H2OP_CH4_H3OP_CH3_2     = HMRATE((1e-9)*1.4,0,0)*H2OP;
	rate_COmole.COP_CH4_HCOP_CH3_1      = HMRATE((1e-10)*4.55,0,0)*CH4;
	rate_COmole.COP_CH4_HCOP_CH3_2      = HMRATE((1e-10)*4.55,0,0)*COP;
	rate_COmole.CH4_CH4P_CH5P_CH3_1     = HMRATE((1e-9)*1.5,0,0)*CH4P;
	rate_COmole.CH4_CH4P_CH5P_CH3_2     = HMRATE((1e-9)*1.5,0,0)*CH4;
	rate_COmole.H2O_CH4P_H3OP_CH3_1     = HMRATE((1e-9)*2.6,0,0)*CH4P;
	rate_COmole.H2O_CH4P_H3OP_CH3_2     = HMRATE((1e-9)*2.6,0,0)*H2O;
	rate_COmole.O2_CH4P_O2P_CH4_1	    = HMRATE(4.0e-10,0,0)*CH4P;
	rate_COmole.O2_CH4P_O2P_CH4_2	    = HMRATE(4.0e-10,0,0)*O2;
	rate_COmole.H2O_CH5P_H3OP_CH4_1     = HMRATE((1e-9)*3.7,0,0)*CH5P;
	rate_COmole.H2O_CH5P_H3OP_CH4_2     = HMRATE((1e-9)*3.7,0,0)*H2O;
	rate_COmole.CH5P_OH_H2OP_CH4_1      = HMRATE(7.0e-10,0,0)*OH;
	rate_COmole.CH5P_OH_H2OP_CH4_2      = HMRATE(7.0e-10,0,0)*CH5P;
	/*>>chng 05 dec 17 The rate for this reaction comes from Eric Herbst's website */
	rate_COmole.C_CH_C2_H_1 = HMRATE((1e-11)*6.59,0,0)*CH;
	rate_COmole.C_CN_C2_N_1 = HMRATE(4.98e-10,0,18116)*CN;
	rate_COmole.C_CS_S_C2_1 = HMRATE((1e-11)*1.44,0.5,20435)*CS;
	rate_COmole.N_C2_CN_C_1 = HMRATE((1e-11)*5.,0.5,0)*C2;
	rate_COmole.C2_S_CS_C_1 = HMRATE((1e-11)*1.73,0.5,0)*ATS;
	rate_COmole.NHP_C2_HCNP_C_1 = HMRATE((1e-10)*4.9,0,0)*C2;
	rate_COmole.OP_C2_COP_C_1 = HMRATE((1e-10)*4.8,0,0)*C2;
	rate_COmole.C2_SP_CSP_C_1 = HMRATE((1e-10)*8.1,0,0)*SP;
	rate_COmole.C_C2P_C2_CP_1 = HMRATE(1.1e-10,0,0)*C2P;
	rate_COmole.CH_C2P_C2_CHP_1 = HMRATE((1e-10)*3.2,0,0)*C2P;
	rate_COmole.NP_C2_C2P_N_1 = HMRATE(1.0e-9,0,0)*C2;
	rate_COmole.CH2_C2P_C2_CH2P_1 = HMRATE((1e-10)*4.5,0,0)*C2P;
	rate_COmole.OP_C2_C2P_O_1 = HMRATE((1e-10)*4.8,0,0)*C2;
	rate_COmole.NH2_C2P_C2_NH2P_1 = HMRATE((1e-10)*4.6,0,0)*C2P;
	rate_COmole.OHP_C2_C2P_OH_1 = HMRATE((1e-10)*4.8,0,0)*C2;
	rate_COmole.OH_C2P_C2_OHP_1 = HMRATE((1e-10)*6.5,0,0)*C2P;
	rate_COmole.H2OP_C2_C2P_H2O_1 = HMRATE((1e-10)*4.7,0,0)*C2;
	rate_COmole.C2_CNP_CN_C2P_1 = HMRATE((1e-10)*8.5,0,0)*CNP;
	rate_COmole.C2_N2P_N2_C2P_1 = HMRATE((1e-10)*8.4,0,0)*N2P;
	rate_COmole.C2P_NO_NOP_C2_1 = HMRATE((1e-10)*3.4,0,0)*NO;
	rate_COmole.C2_O2P_O2_C2P_1 = HMRATE((1e-10)*4.1,0,0)*O2P;
	rate_COmole.C2P_S_SP_C2_1 = HMRATE((1e-10)*5.8,0,0)*ATS;
	rate_COmole.C_C_C2_nu_1 = HMRATE(4.36E-18,0.35,161.3)*ATC;
	/*>>chng 05 dec 17 The rate for this reaction comes from Eric Herbst's website */
	rate_COmole.CP_CH_C2P_H_1 = HMRATE(27e-9,-0.5,0)*CH;
	rate_COmole.C_CHP_C2P_H_1 = HMRATE(1.2e-9,0,0)*CHP;
	rate_COmole.CHP_CH_C2P_H2_1 = HMRATE((1e-10)*7.4,0,0)*CH;
	rate_COmole.N_C2P_CN_CP_1 = HMRATE(4.0e-11,0,0)*C2P;
	rate_COmole.O_C2P_COP_C_1 = HMRATE((1e-10)*3.1,0,0)*C2P;
	rate_COmole.C2P_S_CSP_C_1 = HMRATE((1e-10)*5.8,0,0)*ATS;
	rate_COmole.CP_C_C2P_nu_1 = HMRATE(4.01E-18,0.17,101.5)*ATC;
	/*>>chng 05 dec 17 The rate for this reaction comes from Eric Herbst's website */
	rate_COmole.C_CH_C2_H_2 = HMRATE((1e-11)*6.59,0,0)*ATC;
	rate_COmole.C_CN_C2_N_2 = HMRATE(4.98e-10,0,18116)*ATC;
	rate_COmole.C_CS_S_C2_2 = HMRATE((1e-11)*1.44,0.5,20435)*ATC;
	rate_COmole.N_C2_CN_C_2 = HMRATE((1e-11)*5.,0.5,0)*ATN;
	rate_COmole.C2_S_CS_C_2 = HMRATE((1e-11)*1.73,0.5,0)*C2;
	rate_COmole.NHP_C2_HCNP_C_2 = HMRATE((1e-10)*4.9,0,0)*NHP;
	rate_COmole.OP_C2_COP_C_2 = HMRATE((1e-10)*4.8,0,0)*OP;
	rate_COmole.C2_SP_CSP_C_2 = HMRATE((1e-10)*8.1,0,0)*C2;
	rate_COmole.C_C2P_C2_CP_2 = HMRATE(1.1e-10,0,0)*ATC;
	rate_COmole.CH_C2P_C2_CHP_2 = HMRATE((1e-10)*3.2,0,0)*CH;
	rate_COmole.NP_C2_C2P_N_2 = HMRATE(1.0e-9,0,0)*NP;
	rate_COmole.CH2_C2P_C2_CH2P_2 = HMRATE((1e-10)*4.5,0,0)*CH2;
	rate_COmole.OP_C2_C2P_O_2 = HMRATE((1e-10)*4.8,0,0)*OP;
	rate_COmole.NH2_C2P_C2_NH2P_2 = HMRATE((1e-10)*4.6,0,0)*NH2;
	rate_COmole.OHP_C2_C2P_OH_2 = HMRATE((1e-10)*4.8,0,0)*OHP;
	rate_COmole.OH_C2P_C2_OHP_2 = HMRATE((1e-10)*6.5,0,0)*OH;
	rate_COmole.H2OP_C2_C2P_H2O_2 = HMRATE((1e-10)*4.7,0,0)*H2OP;
	rate_COmole.C2_CNP_CN_C2P_2 = HMRATE((1e-10)*8.5,0,0)*C2;
	rate_COmole.C2_N2P_N2_C2P_2 = HMRATE((1e-10)*8.4,0,0)*C2;
	rate_COmole.C2P_NO_NOP_C2_2 = HMRATE((1e-10)*3.4,0,0)*C2P;
	rate_COmole.C2_O2P_O2_C2P_2 = HMRATE((1e-10)*4.1,0,0)*C2;
	rate_COmole.C2P_S_SP_C2_2 = HMRATE((1e-10)*5.8,0,0)*C2P;
	rate_COmole.C_C_C2_nu_2 = HMRATE(4.36E-18,0.35,161.3)*ATC;
	/*>>chng 05 dec 17 The rate for this reaction comes from Eric Herbst's website */
	rate_COmole.CP_CH_C2P_H_2 = HMRATE(27e-9,-0.50,0)*CP;
	rate_COmole.C_CHP_C2P_H_2 = HMRATE(1.2e-9,0,0)*ATC;
	rate_COmole.CHP_CH_C2P_H2_2 = HMRATE((1e-10)*7.4,0,0)*CHP;
	rate_COmole.N_C2P_CN_CP_2 = HMRATE(4.0e-11,0,0)*ATN;
	rate_COmole.O_C2P_COP_C_2 = HMRATE((1e-10)*3.1,0,0)*ATO;
	rate_COmole.C2P_S_CSP_C_2 = HMRATE((1e-10)*5.8,0,0)*C2P;
	rate_COmole.CP_C_C2P_nu_2 = HMRATE(4.01E-18,0.17,101.5)*CP;

	rate_COmole.C_NH_N_CH_1          = HMRATE((1e-11)*1.73,0.5,4000)*ATC;
	rate_COmole.C_NH_CN_H_1          = HMRATE(1.1e-10,0.5,0)*ATC;
	rate_COmole.C_N2_CN_N_1          = HMRATE((1e-11)*8.69,0,22600)*ATC;
	rate_COmole.C_NO_CN_O_1          = HMRATE((1e-11)*4.8,0,0)*ATC;
	rate_COmole.C_HS_S_CH_1          = HMRATE((1e-11)*1.2,0.58,5880)*ATC;
	rate_COmole.C_HS_CS_H_1          = HMRATE(2.0e-11,0,0)*ATC;
	rate_COmole.C_NS_S_CN_1          = HMRATE(2.0e-11,0.5,0)*ATC;
	rate_COmole.C_NS_CS_N_1          = HMRATE((1e-11)*1.73,0.5,4000)*ATC;
	rate_COmole.C_S2_CS_S_1          = HMRATE((1e-11)*1.73,0.5,0)*ATC;
	rate_COmole.CH_N_NH_C_1          = HMRATE((1e-11)*3.03,0.65,1207)*CH;
	rate_COmole.CH_N_CN_H_1          = HMRATE((1e-10)*1.66,-0.09,0)*CH;
	rate_COmole.CH_N2_HCN_N_1        = HMRATE(0.00000000000056,0.88,10128)*CH;
	rate_COmole.CH_NO_HCN_O_1        = HMRATE((1e-9)*5.59,0,10814)*CH;
	rate_COmole.CH_NO_CN_OH_1        = HMRATE(2.32E-26,0,0)*CH;
	rate_COmole.CH_NO_OCN_H_1        = HMRATE(1.13E-25,0,0)*CH;
	rate_COmole.CH_HNO_NO_CH2_1      = HMRATE((1e-11)*1.73,0.5,0)*CH;
	rate_COmole.CH_S_HS_C_1          = HMRATE((1e-11)*1.73,0.5,4000)*CH;
	rate_COmole.CH_S_CS_H_1          = HMRATE((1e-12)*1.1,0,0)*CH;
	rate_COmole.N_NH_N2_H_1          = HMRATE((1e-11)*4.98,0,0)*ATN;
	rate_COmole.N_CH3_HCN_H_H_1      = HMRATE((1e-13)*3.32,0,0)*ATN;
	rate_COmole.N_CH3_HCN_H2_1       = HMRATE((1e-11)*1.3,0.5,0)*ATN;
	rate_COmole.N_OH_O_NH_1          = HMRATE((1e-11)*1.88,0.1,10700)*ATN;
	rate_COmole.N_OH_NO_H_1          = HMRATE((1e-11)*5.32,-0.25,0)*ATN;
	rate_COmole.N_CN_N2_C_1          = HMRATE((1e-10)*3.,0,0)*ATN;
	rate_COmole.N_SIH_SIN_H_1        = HMRATE((1e-11)*5.,0.5,0)*ATN;
	rate_COmole.N_NO_N2_O_1          = HMRATE((1e-11)*3.75,0,26)*ATN;
	rate_COmole.N_HNO_NO_NH_1        = HMRATE((1e-12)*2.94,0.5,1000)*ATN;
	rate_COmole.N_HNO_N2O_H_1        = HMRATE((1e-12)*1.43,0.5,1500)*ATN;
	rate_COmole.N_O2_NO_O_1          = HMRATE((1e-12)*2.26,0.86,3134)*ATN;
	rate_COmole.N_HS_NS_H_1          = HMRATE((1e-11)*1.73,0.5,0)*ATN;
	rate_COmole.N_HS_S_NH_1          = HMRATE((1e-11)*1.73,0.5,9060)*ATN;
	rate_COmole.N_CS_S_CN_1          = HMRATE((1e-11)*3.8,0.5,1160)*ATN;
	rate_COmole.N_NS_S_N2_1          = HMRATE((1e-11)*1.73,0.5,0)*ATN;
	rate_COmole.N_SO_NS_O_1          = HMRATE((1e-11)*4.68,0.5,8254)*ATN;
	rate_COmole.N_SO_S_NO_1          = HMRATE((1e-11)*1.73,0.5,750)*ATN;
	rate_COmole.N_S2_NS_S_1          = HMRATE((1e-11)*1.73,0.5,4000)*ATN;
	rate_COmole.CH2_CN_HCN_CH_1      = HMRATE((1e-12)*5.3,0,2500)*CH2;
	rate_COmole.CH2_NO_HCN_OH_1      = HMRATE(0.000000000000832,0,1443)*CH2;
	rate_COmole.CH2_HNO_NO_CH3_1     = HMRATE((1e-11)*1.73,0.5,0)*CH2;
	rate_COmole.NH_NH_N2_H_H_1       = HMRATE((1e-9)*1.16,0,0)*NH;
	rate_COmole.NH_NH_N2_H2_1        = HMRATE((1e-11)*1.7,0,0)*NH;
	rate_COmole.NH_O_OH_N_1          = HMRATE((1e-11)*1.16,0,0)*NH;
	rate_COmole.NH_O_NO_H_1          = HMRATE((1e-10)*1.16,0,0)*NH;
	rate_COmole.NH_OH_HNO_H_1        = HMRATE((1e-11)*3.32,0,0)*NH;
	rate_COmole.NH_OH_NH2_O_1        = HMRATE((1e-12)*2.93,0.1,5800)*NH;
	rate_COmole.NH_OH_H2O_N_1        = HMRATE((1e-12)*3.11,1.2,0)*NH;
	rate_COmole.NH_H2O_OH_NH2_1      = HMRATE((1e-12)*1.83,1.6,14090)*NH;
	rate_COmole.NH_CN_HCN_N_1        = HMRATE((1e-12)*2.94,0.5,1000)*NH;
	rate_COmole.NH_NO_N2O_H_1        = HMRATE((1e-10)*1.16,-1.03,420)*NH;
	rate_COmole.NH_NO_N2_O_H_1       = HMRATE((1e-11)*5.,0,0)*NH;
	rate_COmole.NH_NO_N2_OH_1        = HMRATE((1e-11)*1.46,-0.58,37)*NH;
	rate_COmole.NH_S_HS_N_1          = HMRATE((1e-11)*1.73,0.5,4000)*NH;
	rate_COmole.NH_S_NS_H_1          = HMRATE((1e-11)*1.73,0.5,0)*NH;
	rate_COmole.NH_NO2_HNO_NO_1      = HMRATE((1e-12)*5.72,0.5,2500)*NH;
	rate_COmole.NH_NO2_N2O_OH_1      = HMRATE((1e-13)*1.44,0, 1140)*NH;
	rate_COmole.CH3_NH3_CH4_NH2_1    = HMRATE(0.0000000000000955,0,4890)*CH3;
	rate_COmole.CH3_CN_HCN_CH2_1     = HMRATE((1e-12)*9.21,0.7,1500)*CH3;
	rate_COmole.CH3_HNO_NO_CH4_1     = HMRATE((1e-11)*1.44,0.5,0)*CH3;
	rate_COmole.O_NH2_OH_NH_1        = HMRATE((1e-11)*1.39,0,40)*ATO;
	rate_COmole.O_NH2_NO_H2_1        = HMRATE((1e-12)*8.3,0,0)*ATO;
	rate_COmole.O_NH3_OH_NH2_1       = HMRATE((1e-11)*1.89,0,4003)*ATO;
	rate_COmole.O_CN_NO_C_1          = HMRATE((1e-11)*3.81,0.5,14545)*ATO;
	rate_COmole.O_HCN_CN_OH_1        = HMRATE((1e-10)*6.21,0,12439)*ATO;
	rate_COmole.O_HCN_OCN_H_1        = HMRATE((1e-12)*1.36,1.38,3693)*ATO;
	rate_COmole.O_N2_NO_N_1          = HMRATE((1e-10)*2.51,0,38602)*ATO;
	rate_COmole.O_NO_O2_N_1          = HMRATE((1e-11)*1.18,0,20413)*ATO;
	rate_COmole.O_HNO_NO_OH_1        = HMRATE((1e-11)*6.,0,0)*ATO;
	rate_COmole.O_HNO_O2_NH_1        = HMRATE((1e-12)*2.94,0.5,3500)*ATO;
	rate_COmole.O_HNO_NO2_H_1        = HMRATE((1e-12)*1.44,0.5,0)*ATO;
	rate_COmole.O_HS_S_OH_1          = HMRATE((1e-11)*1.74,0.67,956)*ATO;
	rate_COmole.O_HS_SO_H_1          = HMRATE((1e-10)*2.32,0,0)*ATO;
	rate_COmole.O_OCN_O2_CN_1        = HMRATE((1e-10)*4.02,-1.43,3501)*ATO;
	rate_COmole.O_SIN_NO_SI_1        = HMRATE((1e-11)*2.5,0.5,0)*ATO;
	rate_COmole.O_SIN_SIO_N_1        = HMRATE((1e-11)*5.75,0.1,200)*ATO;
	rate_COmole.O_N2O_NO_NO_1        = HMRATE((1e-10)*1.15,0,13400)*ATO;
	rate_COmole.O_N2O_O2_N2_1        = HMRATE((1e-10)*1.66,0,14100)*ATO;
	rate_COmole.O_CS_SO_C_1          = HMRATE((1e-11)*4.68,0.5,28940)*ATO;
	rate_COmole.O_NS_S_NO_1          = HMRATE((1e-11)*5.,0.5,0)*ATO;
	rate_COmole.O_NS_SO_N_1          = HMRATE((1e-11)*1.73,0.5,4000)*ATO;
	rate_COmole.O_SO_S_O2_1          = HMRATE(0.00000000000066,0,2760)*ATO;
	rate_COmole.O_S2_SO_S_1          = HMRATE((1e-11)*1.73,0.5,0)*ATO;
	rate_COmole.NH2_OH_NH3_O_1       = HMRATE(0.000000000000208,0.76,262)*NH2;
	rate_COmole.NH2_OH_H2O_NH_1      = HMRATE((1e-12)*1.5,0,0)*NH2;
	rate_COmole.NH2_NO_N2_OH_H_1     = HMRATE((1e-12)*1.49,0,0)*NH2;
	rate_COmole.NH2_NO_N2_H2O_1      = HMRATE((1e-11)*4.27,-2.5,331)*NH2;
	rate_COmole.CH4_CN_HCN_CH3_1     = HMRATE((1e-12)*3.14,1.53,504)*CH4;
	rate_COmole.OH_NH3_H2O_NH2_1     = HMRATE((1e-13)*1.47,2.05,7)*OH;
	rate_COmole.OH_CN_HCN_O_1        = HMRATE(1.0e-11,0,1000)*OH;
	rate_COmole.OH_CN_OCN_H_1        = HMRATE((1e-11)*7.,0,0)*OH;
	rate_COmole.OH_HCN_CN_H2O_1      = HMRATE((1e-13)*1.87,1.5,3887)*OH;
	rate_COmole.OH_NO_NO2_H_1        = HMRATE((1e-12)*5.2,0,15100)*OH;
	rate_COmole.OH_S_HS_O_1          = HMRATE(6.6e-11,0,0)*OH;
	rate_COmole.OH_S_SO_H_1          = HMRATE(6.6e-11,0,0)*OH;
	rate_COmole.OH_N2O_HNO_NO_1      = HMRATE(1.04E-17,4.33,12623)*OH;
	rate_COmole.OH_CS_OCS_H_1        = HMRATE(0.0000000000000939,1.12,800)*OH;
	rate_COmole.NH3_CN_HCN_NH2_1     = HMRATE((1e-11)*2.6,-1.1,0)*NH3;
	rate_COmole.CN_NO_OCN_N_1        = HMRATE((1e-10)*1.62,0,21205)*CN;
	rate_COmole.CN_HNO_NO_HCN_1      = HMRATE((1e-11)*1.5,0.5,0)*CN;
	rate_COmole.CN_S_NS_C_1          = HMRATE((1e-11)*5.71,0.5,32010)*CN;
	rate_COmole.CN_S_CS_N_1          = HMRATE((1e-11)*1.73,0.5,0)*CN;
	rate_COmole.N2_O2_N2O_O_1        = HMRATE(1.0e-10,0,55200)*N2;
	rate_COmole.NO_NO_O2_N2_1        = HMRATE((1e-11)*2.51,0,30653)*NO;
	rate_COmole.NO_NO_N2O_O_1        = HMRATE((1e-12)*7.22,0,33155)*NO;
	rate_COmole.NO_HNO_N2O_OH_1      = HMRATE((1e-11)*1.41,0,14890)*NO;
	rate_COmole.NO_S_NS_O_1          = HMRATE(2.94e-11,0.5,17465)*NO;
	rate_COmole.NO_S_SO_N_1          = HMRATE((1e-10)*1.75,0,20200)*NO;
	rate_COmole.O2_S_SO_O_1          = HMRATE((1e-12)*2.28,0.52,0)*O2;
	rate_COmole.S_SO_S2_O_1          = HMRATE((1e-11)*1.73,0.5,11500)*ATS;
	rate_COmole.C_NHP_N_CHP_1        = HMRATE((1e-9)*1.6,0,0)*ATC;
	rate_COmole.CP_NH_CNP_H_1        = HMRATE((1e-10)*7.8,0,0)*CP;
	rate_COmole.CP_NH2_HCNP_H_1      = HMRATE(1.1e-9,0,0)*CP;
	rate_COmole.C_NH2P_NH_CHP_1      = HMRATE(1.2e-9,0,0)*ATC;
	rate_COmole.CP_NH3_HCNP_H2_1     = HMRATE((1e-11)*7.,0,0)*CP;
	rate_COmole.C_NH3P_NH_CH2P_1     = HMRATE(1.0e-11,0,0)*ATC;
	rate_COmole.C_HCNP_CN_CHP_1      = HMRATE(1.1e-9,0,0)*ATC;
	rate_COmole.C_HNOP_NO_CHP_1      = HMRATE(1.0e-9,0,0)*ATC;
	rate_COmole.CP_HS_CSP_H_1        = HMRATE(1.1e-9,0,0)*CP;
	rate_COmole.C_HSP_CSP_H_1        = HMRATE((1e-10)*9.9,0,0)*ATC;
	rate_COmole.CP_OCN_COP_CN_1      = HMRATE((1e-9)*3.8,0,0)*CP;
	rate_COmole.CP_NS_CSP_N_1        = HMRATE((1e-10)*7.6,0,0)*CP;
	rate_COmole.CP_SO_S_COP_1        = HMRATE((1e-10)*2.6,0,0)*CP;
	rate_COmole.CP_SO_CSP_O_1        = HMRATE((1e-10)*2.6,0,0)*CP;
	rate_COmole.CHP_N_CNP_H_1        = HMRATE((1e-10)*1.9,0,0)*CHP;
	rate_COmole.CH_NP_CNP_H_1        = HMRATE((1e-10)*3.6,0,0)*CH;
	rate_COmole.CH_NHP_CH2P_N_1      = HMRATE((1e-10)*9.9,0,0)*CH;
	rate_COmole.CHP_NH_CNP_H2_1      = HMRATE((1e-10)*7.6,0,0)*CHP;
	rate_COmole.CHP_NH2_HCNP_H2_1    = HMRATE(1.1e-9,0,0)*CHP;
	rate_COmole.CH_NH2P_NH_CH2P_1    = HMRATE(3.5e-10,0,0)*CH;
	rate_COmole.CHP_NH3_NH4P_C_1     = HMRATE((1e-10)*4.05,0,0)*CHP;
	rate_COmole.CH_NH3P_NH4P_C_1     = HMRATE((1e-10)*6.9,0,0)*CH;
	rate_COmole.CH_HCNP_CN_CH2P_1    = HMRATE((1e-10)*6.3,0,0)*CH;
	rate_COmole.CH_HNOP_NO_CH2P_1    = HMRATE(6.2e-10,0,0)*CH;
	rate_COmole.CHP_S_HSP_C_1        = HMRATE((1e-10)*4.7,0,0)*CHP;
	rate_COmole.CHP_S_CSP_H_1        = HMRATE((1e-10)*4.7,0,0)*CHP;
	rate_COmole.CH_SP_CSP_H_1        = HMRATE(6.2e-10,0,0)*CH;
	rate_COmole.CH_HSP_S_CH2P_1      = HMRATE((1e-10)*5.8,0,0)*CH;
	rate_COmole.N_CH2P_HCNP_H_1      = HMRATE((1e-10)*2.2,0,0)*ATN;
	rate_COmole.NP_NH_N2P_H_1        = HMRATE((1e-10)*3.7,0,0)*NP;
	rate_COmole.N_NHP_N2P_H_1        = HMRATE(1.3e-9,0,0)*ATN;
	rate_COmole.NP_CH4_HCNP_H2_H_1   = HMRATE((1e-11)*5.6,0,0)*NP;
	rate_COmole.N_OHP_NOP_H_1        = HMRATE((1e-10)*8.9,0,0)*ATN;
	rate_COmole.NP_NH3_NH2P_NH_1     = HMRATE((1e-10)*2.16,0,0)*NP;
	rate_COmole.N_H2OP_HNOP_H_1      = HMRATE((1e-10)*1.9,0,0)*ATN;
	rate_COmole.NP_NO_N2P_O_1        = HMRATE((1e-11)*7.9,0,0)*NP;
	rate_COmole.NP_O2_NO_OP_1        = HMRATE((1e-11)*3.66,0,0)*NP;
	rate_COmole.NP_O2_NOP_O_1        = HMRATE((1e-10)*2.63,0,0)*NP;
	rate_COmole.N_O2P_NOP_O_1        = HMRATE((1e-10)*1.8,0,0)*ATN;
	rate_COmole.N_HSP_NSP_H_1        = HMRATE((1e-10)*7.4,0,0)*ATN;
	rate_COmole.N_SIOP_NOP_SI_1      = HMRATE((1e-11)*9.,0,0)*ATN;
	rate_COmole.N_SIOP_NO_SIP_1      = HMRATE((1e-10)*2.1,0,0)*ATN;
	rate_COmole.N_SOP_NSP_O_1        = HMRATE((1e-11)*5.,0,0)*ATN;
	rate_COmole.NP_OCS_CSP_NO_1      = HMRATE((1e-11)*7.,0,0)*NP;
	rate_COmole.CH2_NHP_CH3P_N_1     = HMRATE((1e-9)*1.4,0,0)*CH2;
	rate_COmole.CH2_NH2P_CH3P_NH_1   = HMRATE((1e-10)*4.9,0,0)*CH2;
	rate_COmole.CH2P_NH3_NH4P_CH_1   = HMRATE((1e-9)*1.26,0,0)*CH2P;
	rate_COmole.CH2_NH3P_NH2_CH3P_1  = HMRATE((1e-10)*9.6,0,0)*CH2;
	rate_COmole.CH2_HCNP_CN_CH3P_1   = HMRATE((1e-10)*8.7,0,0)*CH2;
	rate_COmole.CH2_HNOP_NO_CH3P_1   = HMRATE((1e-10)*8.6,0,0)*CH2;
	rate_COmole.CH2P_S_HCSP_H_1      = HMRATE((1e-9)*1.4,0,0)*CH2P;
	rate_COmole.CH2_SP_HCSP_H_1      = HMRATE(1.0e-11,0,0)*CH2;
	rate_COmole.NHP_NH_NH2P_N_1      = HMRATE(1.0e-9,0,0)*NHP;
	rate_COmole.NHP_O_OHP_N_1        = HMRATE(1.0e-9,0,0)*NHP;
	rate_COmole.NH_OP_NOP_H_1        = HMRATE((1e-10)*3.6,0,0)*NH;
	rate_COmole.NHP_NH2_NH3P_N_1     = HMRATE((1e-9)*1.5,0,0)*NHP;
	rate_COmole.NH_NH2P_NH3P_N_1     = HMRATE((1e-10)*7.3,0,0)*NH;
	rate_COmole.NHP_OH_H2OP_N_1      = HMRATE(1.0e-9,0,0)*NHP;
	rate_COmole.NH_OHP_NH2P_O_1      = HMRATE((1e-10)*3.6,0,0)*NH;
	rate_COmole.NHP_NH3_NH4P_N_1     = HMRATE((1e-10)*6.,0,0)*NHP;
	rate_COmole.NH_NH3P_NH4P_N_1     = HMRATE((1e-10)*7.1,0,0)*NH;
	rate_COmole.NH_CH5P_CH4_NH2P_1   = HMRATE((1e-10)*7.1,0,0)*NH;
	rate_COmole.NHP_H2O_NH3P_O_1     = HMRATE((1e-10)*1.75,0,0)*NHP;
	rate_COmole.NHP_H2O_H3OP_N_1     = HMRATE((1e-9)*1.05,0,0)*NHP;
	rate_COmole.NHP_H2O_HNOP_H2_1    = HMRATE(3.5e-10,0,0)*NHP;
	rate_COmole.NH_H2OP_H3OP_N_1     = HMRATE((1e-10)*7.1,0,0)*NH;
	rate_COmole.NHP_H2O_OH_NH2P_1    = HMRATE((1e-10)*8.75,0,0)*NHP;
	rate_COmole.NHP_CN_HCNP_N_1      = HMRATE((1e-9)*1.6,0,0)*NHP;
	rate_COmole.NH_HCNP_CN_NH2P_1    = HMRATE((1e-10)*6.5,0,0)*NH;
	rate_COmole.NH_COP_HCOP_N_1      = HMRATE((1e-10)*3.2,0,0)*NH;
	rate_COmole.NH_SIP_SINP_H_1      = HMRATE(1.0e-9,0,0)*NH;
	rate_COmole.NH_HNOP_NO_NH2P_1    = HMRATE((1e-10)*6.3,0,0)*NH;
	rate_COmole.NH_O2P_HNOP_O_1      = HMRATE((1e-10)*3.2,0,0)*NH;
	rate_COmole.NHP_O2_NOP_OH_1      = HMRATE((1e-10)*2.05,0,0)*NHP;
	rate_COmole.NH_O2P_NO2P_H_1      = HMRATE((1e-10)*3.2,0,0)*NH;
	rate_COmole.NHP_S_HSP_N_1        = HMRATE((1e-10)*6.9,0,0)*NHP;
	rate_COmole.NHP_S_NSP_H_1        = HMRATE((1e-10)*6.9,0,0)*NHP;
	rate_COmole.NH_SP_NSP_H_1        = HMRATE((1e-10)*6.3,0,0)*NH;
	rate_COmole.CH3P_NH3_NH4P_CH2_1  = HMRATE((1e-10)*3.4,0,0)*CH3P;
	rate_COmole.CH3P_S_HCSP_H2_1     = HMRATE((1e-9)*1.4,0,0)*CH3P;
	rate_COmole.O_NH2P_HNOP_H_1      = HMRATE((1e-11)*7.2,0,0)*ATO;
	rate_COmole.O_NH3P_HNOP_H2_1     = HMRATE(1.0e-11,0,0)*ATO;
	rate_COmole.OP_CN_NOP_C_1        = HMRATE(1.0e-9,0,0)*OP;
	rate_COmole.OP_HCN_COP_NH_1      = HMRATE(1.2e-9,0,0)*OP;
	rate_COmole.OP_HCN_NOP_CH_1      = HMRATE(1.2e-9,0,0)*OP;
	rate_COmole.OP_HCN_HCOP_N_1      = HMRATE(1.2e-9,0,0)*OP;
	rate_COmole.OP_N2_NOP_N_1        = HMRATE((1e-12)*1.2,0,0)*OP;
	rate_COmole.O_N2P_NOP_N_1        = HMRATE((1e-10)*1.3,0,0)*ATO;
	rate_COmole.O_HNOP_NO2P_H_1      = HMRATE((1e-12)*1.,0,0)*ATO;
	rate_COmole.O_HSP_SP_OH_1        = HMRATE((1e-10)*2.9,0,0)*ATO;
	rate_COmole.O_HSP_SOP_H_1        = HMRATE((1e-10)*2.9,0,0)*ATO;
	rate_COmole.O_SINP_SIOP_N_1      = HMRATE(1.0e-9,0,0)*ATO;
	rate_COmole.OP_N2O_NOP_NO_1      = HMRATE((1e-10)*6.3,0,0)*OP;
	rate_COmole.O_CSP_S_COP_1        = HMRATE((1e-11)*6.,0,0)*ATO;
	rate_COmole.O_HCSP_S_HCOP_1      = HMRATE((1e-12)*5.,0,0)*ATO;
	rate_COmole.O_HCSP_OCSP_H_1      = HMRATE((1e-12)*5.,0,0)*ATO;
	rate_COmole.OP_NO2_O2_NOP_1      = HMRATE((1e-10)*8.3,0,0)*OP;
	rate_COmole.O_NSP_S_NOP_1        = HMRATE((1e-10)*6.1,0,0)*ATO;
	rate_COmole.NH2P_NH2_NH3P_NH_1   = HMRATE(1.0e-9,0,0)*NH2P;
	rate_COmole.NH2_OHP_NH3P_O_1     = HMRATE(5.0e-10,0,0)*NH2;
	rate_COmole.NH2P_OH_H2OP_NH_1    = HMRATE((1e-10)*7.1,0,0)*NH2P;
	rate_COmole.NH2P_NH3_NH4P_NH_1   = HMRATE((1e-9)*1.61,0,0)*NH2P;
	rate_COmole.NH2_NH3P_NH4P_NH_1   = HMRATE(1.0e-11,0,0)*NH2;
	rate_COmole.NH2_CH5P_NH3P_CH4_1  = HMRATE((1e-10)*9.9,0,0)*NH2;
	rate_COmole.NH2P_H2O_NH3P_OH_1   = HMRATE(1.0e-10,0,0)*NH2P;
	rate_COmole.NH2P_H2O_H3OP_NH_1   = HMRATE((1e-9)*2.76,0,0)*NH2P;
	rate_COmole.NH2_H2OP_NH3P_OH_1   = HMRATE((1e-10)*4.9,0,0)*NH2;
	rate_COmole.NH2P_H2O_NH4P_O_1    = HMRATE((1e-10)*1.45,0,0)*NH2P;
	rate_COmole.NH2_H3OP_H2O_NH3P_1  = HMRATE((1e-10)*9.7,0,0)*NH2;
	rate_COmole.NH2_HCNP_CN_NH3P_1   = HMRATE(9.0e-10,0,0)*NH2;
	rate_COmole.NH2_COP_HCOP_NH_1    = HMRATE((1e-10)*4.5,0,0)*NH2;
	rate_COmole.NH2_HNOP_NO_NH3P_1   = HMRATE((1e-10)*8.8,0,0)*NH2;
	rate_COmole.NH2P_O2_HNOP_OH_1    = HMRATE((1e-11)*2.1,0,0)*NH2P;
	rate_COmole.NH2P_S_HSP_NH_1      = HMRATE((1e-10)*4.4,0,0)*NH2P;
	rate_COmole.CH4P_NH3_NH4P_CH3_1  = HMRATE((1e-9)*1.15,0,0)*CH4P;
	rate_COmole.CH4_NH3P_NH4P_CH3_1  = HMRATE((1e-10)*4.8,0,0)*CH4;
	rate_COmole.CH4_N2P_N2_CH2P_H2_1 = HMRATE((1e-11)*7.,0,0)*CH4;
	rate_COmole.CH4_N2P_N2_CH3P_H_1  = HMRATE((1e-10)*9.3,0,0)*CH4;
	rate_COmole.CH4_HNOP_NO_CH5P_1   = HMRATE(1.0e-10,0,0)*CH4;
	rate_COmole.CH4_SP_HCSP_H2_H_1   = HMRATE(2.0e-11,0,0)*CH4;
	rate_COmole.CH4_CSP_HCSP_CH3_1   = HMRATE(5.0e-10,0,0)*CH4;
	rate_COmole.OHP_NH3_NH4P_O_1     = HMRATE(1.2e-9,0,0)*OHP;
	rate_COmole.OH_NH3P_NH4P_O_1     = HMRATE(7.0e-10,0,0)*OH;
	rate_COmole.OHP_CN_HCNP_O_1      = HMRATE(1.0e-9,0,0)*OHP;
	rate_COmole.OH_HCNP_CN_H2OP_1    = HMRATE((1e-10)*6.3,0,0)*OH;
	rate_COmole.OHP_NO_HNOP_O_1      = HMRATE((1e-10)*6.11,0,0)*OHP;
	rate_COmole.OH_HNOP_NO_H2OP_1    = HMRATE(6.2e-10,0,0)*OH;
	rate_COmole.OHP_S_HSP_O_1        = HMRATE((1e-10)*4.3,0,0)*OHP;
	rate_COmole.OHP_S_SOP_H_1        = HMRATE((1e-10)*4.3,0,0)*OHP;
	rate_COmole.OH_SP_SOP_H_1        = HMRATE((1e-10)*6.1,0,0)*OH;
	rate_COmole.NH3P_NH3_NH4P_NH2_1  = HMRATE((1e-9)*2.2,0,0)*NH3P;
	rate_COmole.NH3_CH5P_NH4P_CH4_1  = HMRATE((1e-9)*2.5,0,0)*NH3;
	rate_COmole.NH3P_H2O_NH4P_OH_1   = HMRATE(1.1e-10,0,0)*NH3P;
	rate_COmole.NH3_H2OP_NH4P_OH_1   = HMRATE((1e-10)*9.45,0,0)*NH3;
	rate_COmole.NH3_H3OP_NH4P_H2O_1  = HMRATE((1e-9)*2.2,0,0)*NH3;
	rate_COmole.NH3_COP_HCOP_NH2_1   = HMRATE((1e-11)*4.12,0,0)*NH3;
	rate_COmole.NH3_HNOP_NO_NH4P_1   = HMRATE(1.1e-9,0,0)*NH3;
	rate_COmole.NH3_HSP_S_NH4P_1     = HMRATE((1e-10)*9.75,0,0)*NH3;
	rate_COmole.NH3_HCSP_CS_NH4P_1   = HMRATE(2.0e-9,0,0)*NH3;
	rate_COmole.CH5P_S_HSP_CH4_1     = HMRATE(1.3e-9,0,0)*CH5P;
	rate_COmole.H2O_CNP_HCNP_OH_1    = HMRATE((1e-9)*1.6,0,0)*H2O;
	rate_COmole.H2O_CNP_HCOP_NH_1    = HMRATE((1e-10)*1.6,0,0)*H2O;
	rate_COmole.H2O_HCNP_CN_H3OP_1   = HMRATE((1e-9)*1.8,0,0)*H2O;
	rate_COmole.H2O_HNOP_NO_H3OP_1   = HMRATE((1e-9)*2.3,0,0)*H2O;
	rate_COmole.H2OP_S_HSP_OH_1      = HMRATE((1e-10)*4.3,0,0)*H2OP;
	rate_COmole.H2O_HSP_S_H3OP_1     = HMRATE((1e-10)*7.8,0,0)*H2O;
	rate_COmole.H3OP_CS_HCSP_H2O_1   = HMRATE(1.0e-9,0,0)*H3OP;
	rate_COmole.CNP_NO_OCNP_N_1      = HMRATE((1e-10)*1.9,0,0)*CNP;
	rate_COmole.CN_HNOP_NO_HCNP_1    = HMRATE((1e-10)*8.7,0,0)*CN;
	rate_COmole.CNP_O2_OCNP_O_1      = HMRATE((1e-11)*8.6,0,0)*CNP;
	rate_COmole.HCNP_S_HSP_CN_1      = HMRATE((1e-10)*5.7,0,0)*HCNP;
	rate_COmole.HNOP_S_HSP_NO_1      = HMRATE(1.1e-9,0,0)*HNOP;
	rate_COmole.O2_SP_SOP_O_1        = HMRATE((1e-11)*1.5,0,0)*O2;
	rate_COmole.O2P_S_SOP_O_1        = HMRATE(5.4e-10,0,0)*O2P;
	rate_COmole.O2_CSP_OCSP_O_1      = HMRATE((1e-10)*1.3,0,0)*O2;
	rate_COmole.S_SIOP_SO_SIP_1      = HMRATE(1.0e-9,0,0)*ATS;
	rate_COmole.CP_NH3_NH3P_C_1      = HMRATE((1e-10)*5.06,0,0)*CP;
	rate_COmole.C_CNP_CN_CP_1        = HMRATE(1.1e-10,0,0)*ATC;
	rate_COmole.C_N2P_N2_CP_1        = HMRATE(1.1e-10,0,0)*ATC;
	rate_COmole.CP_NO_NOP_C_1        = HMRATE(5.2e-10,0,0)*CP;
	rate_COmole.CP_SIN_SINP_C_1      = HMRATE(1.0e-9,0,0)*CP;
	rate_COmole.C_CSP_CS_CP_1        = HMRATE((1e-9)*1.6,0,0)*ATC;
	rate_COmole.CP_NS_NSP_C_1        = HMRATE((1e-10)*7.6,0,0)*CP;
	rate_COmole.CP_SO_SOP_C_1        = HMRATE((1e-10)*2.6,0,0)*CP;
	rate_COmole.CP_OCS_OCSP_C_1      = HMRATE(4.0e-10,0,0)*CP;
	rate_COmole.CH_NH2P_NH2_CHP_1    = HMRATE(3.5e-10,0,0)*CH;
	rate_COmole.CHP_NH3_NH3P_CH_1    = HMRATE((1e-10)*4.59,0,0)*CHP;
	rate_COmole.CH_CNP_CN_CHP_1      = HMRATE((1e-10)*6.4,0,0)*CH;
	rate_COmole.CH_N2P_N2_CHP_1      = HMRATE((1e-10)*6.3,0,0)*CH;
	rate_COmole.CHP_NO_NOP_CH_1      = HMRATE((1e-10)*7.6,0,0)*CHP;
	rate_COmole.NP_NH_NHP_N_1        = HMRATE((1e-10)*3.7,0,0)*NP;
	rate_COmole.NP_NH2_NH2P_N_1      = HMRATE(1.0e-9,0,0)*NP;
	rate_COmole.NP_NH3_NH3P_N_1      = HMRATE((1e-9)*1.97,0,0)*NP;
	rate_COmole.NP_CN_CNP_N_1        = HMRATE(1.1e-9,0,0)*NP;
	rate_COmole.NP_HCN_HCNP_N_1      = HMRATE(1.2e-9,0,0)*NP;
	rate_COmole.N_N2P_N2_NP_1        = HMRATE(1.0e-11,0,0)*ATN;
	rate_COmole.NP_NO_NOP_N_1        = HMRATE((1e-10)*4.51,0,0)*NP;
	rate_COmole.NP_OCS_OCSP_N_1      = HMRATE((1e-9)*1.02,0,0)*NP;
	rate_COmole.CH2_NH2P_NH2_CH2P_1  = HMRATE((1e-10)*4.9,0,0)*CH2;
	rate_COmole.CH2_CNP_CN_CH2P_1    = HMRATE((1e-10)*8.8,0,0)*CH2;
	rate_COmole.CH2_N2P_N2_CH2P_1    = HMRATE((1e-10)*8.7,0,0)*CH2;
	rate_COmole.CH2P_NO_NOP_CH2_1    = HMRATE((1e-10)*4.2,0,0)*CH2P;
	rate_COmole.NH_OP_O_NHP_1        = HMRATE((1e-10)*3.6,0,0)*NH;
	rate_COmole.NH_OHP_OH_NHP_1      = HMRATE((1e-10)*3.6,0,0)*NH;
	rate_COmole.NHP_NH3_NH3P_NH_1    = HMRATE((1e-9)*1.8,0,0)*NHP;
	rate_COmole.NHP_H2O_H2OP_NH_1    = HMRATE((1e-9)*1.05,0,0)*NHP;
	rate_COmole.NH_CNP_CN_NHP_1      = HMRATE((1e-10)*6.5,0,0)*NH;
	rate_COmole.NH_N2P_N2_NHP_1      = HMRATE((1e-10)*6.5,0,0)*NH;
	rate_COmole.NHP_NO_NOP_NH_1      = HMRATE((1e-10)*7.12,0,0)*NHP;
	rate_COmole.NHP_O2_O2P_NH_1      = HMRATE((1e-10)*4.51,0,0)*NHP;
	rate_COmole.NHP_S_SP_NH_1        = HMRATE((1e-10)*6.9,0,0)*NHP;
	rate_COmole.CH3P_NO_NOP_CH3_1    = HMRATE(1.0e-9,0,0)*CH3P;
	rate_COmole.OP_NH2_NH2P_O_1      = HMRATE(1.0e-9,0,0)*OP;
	rate_COmole.OP_NH3_NH3P_O_1      = HMRATE(1.2e-9,0,0)*OP;
	rate_COmole.O_CNP_CN_OP_1        = HMRATE((1e-11)*6.5,0,0)*ATO;
	rate_COmole.O_HCNP_HCN_OP_1      = HMRATE((1e-11)*6.5,0,0)*ATO;
	rate_COmole.O_N2P_N2_OP_1        = HMRATE(1.0e-11,0,0)*ATO;
	rate_COmole.OP_NO_NOP_O_1        = HMRATE((1e-12)*1.7,0,0)*OP;
	rate_COmole.OP_OCS_OCSP_O_1      = HMRATE((1e-10)*6.5,0,0)*OP;
	rate_COmole.NH2_OHP_OH_NH2P_1    = HMRATE(5.0e-10,0,0)*NH2;
	rate_COmole.NH2P_NH3_NH3P_NH2_1  = HMRATE((1e-10)*6.9,0,0)*NH2P;
	rate_COmole.NH2_H2OP_H2O_NH2P_1  = HMRATE((1e-10)*4.9,0,0)*NH2;
	rate_COmole.NH2_CNP_CN_NH2P_1    = HMRATE((1e-10)*9.1,0,0)*NH2;
	rate_COmole.NH2_N2P_N2_NH2P_1    = HMRATE((1e-10)*8.9,0,0)*NH2;
	rate_COmole.NH2P_NO_NOP_NH2_1    = HMRATE(7.0e-10,0,0)*NH2P;
	rate_COmole.NH2_O2P_O2_NH2P_1    = HMRATE((1e-10)*8.7,0,0)*NH2;
	rate_COmole.NH2P_S_SP_NH2_1      = HMRATE((1e-10)*4.4,0,0)*NH2P;
	rate_COmole.CH4P_NH3_NH3P_CH4_1  = HMRATE((1e-9)*1.65,0,0)*CH4P;
	rate_COmole.CH4P_OCS_OCSP_CH4_1  = HMRATE((1e-10)*4.2,0,0)*CH4P;
	rate_COmole.OHP_NH3_NH3P_OH_1    = HMRATE(1.2e-9,0,0)*OHP;
	rate_COmole.OH_CNP_CN_OHP_1      = HMRATE((1e-10)*6.4,0,0)*OH;
	rate_COmole.OH_N2P_N2_OHP_1      = HMRATE((1e-10)*6.3,0,0)*OH;
	rate_COmole.OHP_NO_NOP_OH_1      = HMRATE((1e-10)*3.59,0,0)*OHP;
	rate_COmole.NH3_H2OP_H2O_NH3P_1  = HMRATE((1e-9)*2.21,0,0)*NH3;
	rate_COmole.NH3_HCNP_HCN_NH3P_1  = HMRATE((1e-9)*1.68,0,0)*NH3;
	rate_COmole.NH3_N2P_N2_NH3P_1    = HMRATE((1e-9)*1.9,0,0)*NH3;
	rate_COmole.NH3P_SI_SIP_NH3_1    = HMRATE((1e-9)*1.9,0,0)*NH3P;
	rate_COmole.NH3_O2P_O2_NH3P_1    = HMRATE(2.0e-9,0,0)*NH3;
	rate_COmole.NH3_SP_S_NH3P_1      = HMRATE((1e-9)*1.44,0,0)*NH3;
	rate_COmole.NH3_HSP_HS_NH3P_1    = HMRATE((1e-10)*5.25,0,0)*NH3;
	rate_COmole.NH3_SOP_SO_NH3P_1    = HMRATE(1.3e-9,0,0)*NH3;
	rate_COmole.H2O_HCNP_HCN_H2OP_1  = HMRATE((1e-9)*1.8,0,0)*H2O;
	rate_COmole.H2O_N2P_N2_H2OP_1    = HMRATE((1e-9)*2.3,0,0)*H2O;
	rate_COmole.H2OP_NO_NOP_H2O_1    = HMRATE((1e-10)*2.7,0,0)*H2OP;
	rate_COmole.CNP_HCN_HCNP_CN_1    = HMRATE((1e-9)*1.79,0,0)*CNP;
	rate_COmole.CN_N2P_N2_CNP_1      = HMRATE(1.0e-10,0,0)*CN;
	rate_COmole.CNP_NO_NOP_CN_1      = HMRATE((1e-10)*5.7,0,0)*CNP;
	rate_COmole.CNP_O2_O2P_CN_1      = HMRATE((1e-10)*2.58,0,0)*CNP;
	rate_COmole.CNP_S_SP_CN_1        = HMRATE(1.1e-9,0,0)*CNP;
	rate_COmole.HCN_N2P_N2_HCNP_1    = HMRATE((1e-10)*3.9,0,0)*HCN;
	rate_COmole.HCNP_NO_NOP_HCN_1    = HMRATE((1e-10)*8.1,0,0)*HCNP;
	rate_COmole.HCNP_O2_O2P_HCN_1    = HMRATE((1e-10)*3.2,0,0)*HCNP;
	rate_COmole.HCNP_S_SP_HCN_1      = HMRATE((1e-10)*5.7,0,0)*HCNP;
	rate_COmole.N2P_NO_NOP_N2_1      = HMRATE((1e-10)*4.4,0,0)*N2P;
	rate_COmole.N2P_O2_O2P_N2_1      = HMRATE((1e-11)*5.,0,0)*N2P;
	rate_COmole.N2P_S_SP_N2_1        = HMRATE(1.1e-9,0,0)*N2P;
	rate_COmole.SI_NOP_NO_SIP_1      = HMRATE((1e-9)*1.6,0,0)*ATSI;
	rate_COmole.SI_HSP_HS_SIP_1      = HMRATE((1e-9)*1.4,0,0)*ATSI;
	rate_COmole.SI_CSP_CS_SIP_1      = HMRATE((1e-10)*1.5,0,0)*ATSI;
	rate_COmole.NO_HNOP_HNO_NOP_1    = HMRATE(7.0e-10,0,0)*NO;
	rate_COmole.NO_O2P_O2_NOP_1      = HMRATE((1e-10)*4.5,0,0)*NO;
	rate_COmole.NO_SP_S_NOP_1        = HMRATE((1e-10)*3.7,0,0)*NO;
	rate_COmole.NO_HSP_HS_NOP_1      = HMRATE((1e-10)*4.5,0,0)*NO;
	rate_COmole.NO_SIOP_SIO_NOP_1    = HMRATE((1e-10)*7.2,0,0)*NO;
	rate_COmole.NO_S2P_S2_NOP_1      = HMRATE((1e-10)*5.1,0,0)*NO;
	rate_COmole.O2P_NO2_NO2P_O2_1    = HMRATE((1e-10)*6.6,0,0)*O2P;
	rate_COmole.S_HSP_HS_SP_1        = HMRATE((1e-10)*9.7,0,0)*ATS;
	rate_COmole.C_N_CN_NU_1          = HMRATE((1e-17)*1.,0,0)*ATC;
	rate_COmole.C_S_CS_NU_1          = HMRATE(4.36E-19,0.22,0)*ATC;
	rate_COmole.CP_S_CSP_NU_1        = HMRATE(3.07E-19,0.15,0)*CP;
	rate_COmole.NP_N_N2P_NU_1        = HMRATE(3.71E-18,0.24,26.1)*NP;
	rate_COmole.CH_NP_N_CHP_1        = HMRATE((1e-10)*3.6,0,0)*CH;
	rate_COmole.CHP_S_SP_CH_1        = HMRATE((1e-10)*4.7,0,0)*CHP;
	rate_COmole.NP_CH2_CH2P_N_1      = HMRATE(1.0e-9,0,0)*NP;
	rate_COmole.NP_CH4_CH4P_N_1      = HMRATE((1e-11)*2.8,0,0)*NP;
	rate_COmole.NP_OH_OHP_N_1        = HMRATE((1e-10)*3.7,0,0)*NP;
	rate_COmole.NP_H2O_H2OP_N_1      = HMRATE((1e-9)*2.8,0,0)*NP;
	rate_COmole.NP_O2_O2P_N_1        = HMRATE((1e-10)*3.11,0,0)*NP;
	rate_COmole.OP_O2_O2P_O_1        = HMRATE((1e-11)*1.9,0,0)*OP;
	rate_COmole.OHP_S_SP_OH_1        = HMRATE((1e-10)*4.3,0,0)*OHP;
	rate_COmole.H2OP_S_SP_H2O_1      = HMRATE((1e-10)*4.3,0,0)*H2OP;
	rate_COmole.SI_SP_S_SIP_1        = HMRATE((1e-9)*1.6,0,0)*ATSI;
	rate_COmole.O2P_S_SP_O2_1        = HMRATE(5.4e-10,0,0)*O2P;
	rate_COmole.C_NH_N_CH_2        = HMRATE((1e-11)*1.73,0.5,4000)*NH;
	rate_COmole.C_NH_CN_H_2          = HMRATE(1.1e-10,0.5,0)*NH;
	rate_COmole.C_N2_CN_N_2        = HMRATE((1e-11)*8.69,0,22600)*N2;
	rate_COmole.C_NO_CN_O_2          = HMRATE((1e-11)*4.8,0,0)*NO;
	rate_COmole.C_HS_S_CH_2          = HMRATE((1e-11)*1.2,0.58,5880)*HS;
	rate_COmole.C_HS_CS_H_2          = HMRATE(2.0e-11,0,0)*HS;
	rate_COmole.C_NS_S_CN_2          = HMRATE(2.0e-11,0.5,0)*NS;
	rate_COmole.C_NS_CS_N_2        = HMRATE((1e-11)*1.73,0.5,4000)*NS;
	rate_COmole.C_S2_CS_S_2          = HMRATE((1e-11)*1.73,0.5,0)*S2;
	rate_COmole.CH_N_NH_C_2        = HMRATE((1e-11)*3.03,0.65,1207)*ATN;
	rate_COmole.CH_N_CN_H_2        = HMRATE((1e-10)*1.66,-0.09,0)*ATN;
	rate_COmole.CH_N2_HCN_N_2      = HMRATE(0.00000000000056,0.88,10128)*N2;
	rate_COmole.CH_NO_HCN_O_2        = HMRATE((1e-9)*5.59,0,10814)*NO;
	rate_COmole.CH_NO_CN_OH_2        = HMRATE(2.32E-26,0,0)*NO;
	rate_COmole.CH_NO_OCN_H_2        = HMRATE(1.13E-25,0,0)*NO;
	rate_COmole.CH_HNO_NO_CH2_2      = HMRATE((1e-11)*1.73,0.5,0)*HNO;
	rate_COmole.CH_S_HS_C_2          = HMRATE((1e-11)*1.73,0.5,4000)*ATS;
	rate_COmole.CH_S_CS_H_2          = HMRATE((1e-12)*1.1,0,0)*ATS;
	rate_COmole.N_NH_N2_H_2        = HMRATE((1e-11)*4.98,0,0)*NH;
	rate_COmole.N_CH3_HCN_H_H_2    = HMRATE((1e-13)*3.32,0,0)*CH3;
	rate_COmole.N_CH3_HCN_H2_2     = HMRATE((1e-11)*1.3,0.5,0)*CH3;
	rate_COmole.N_OH_O_NH_2          = HMRATE((1e-11)*1.88,0.1,10700)*OH;
	rate_COmole.N_OH_NO_H_2          = HMRATE((1e-11)*5.32,-0.25,0)*OH;
	rate_COmole.N_CN_N2_C_2          = HMRATE((1e-10)*3.,0,0)*CN;
	rate_COmole.N_SIH_SIN_H_2        = HMRATE((1e-11)*5.,0.5,0)*SIH;
	rate_COmole.N_NO_N2_O_2          = HMRATE((1e-11)*3.75,0,26)*NO;
	rate_COmole.N_HNO_NO_NH_2        = HMRATE((1e-12)*2.94,0.5,1000)*HNO;
	rate_COmole.N_HNO_N2O_H_2        = HMRATE((1e-12)*1.43,0.5,1500)*HNO;
	rate_COmole.N_O2_NO_O_2          = HMRATE((1e-12)*2.26,0.86,3134)*O2;
	rate_COmole.N_HS_NS_H_2          = HMRATE((1e-11)*1.73,0.5,0)*HS;
	rate_COmole.N_HS_S_NH_2          = HMRATE((1e-11)*1.73,0.5,9060)*HS;
	rate_COmole.N_CS_S_CN_2          = HMRATE((1e-11)*3.8,0.5,1160)*CS;
	rate_COmole.N_NS_S_N2_2          = HMRATE((1e-11)*1.73,0.5,0)*NS;
	rate_COmole.N_SO_NS_O_2          = HMRATE((1e-11)*4.68,0.5,8254)*SO;
	rate_COmole.N_SO_S_NO_2          = HMRATE((1e-11)*1.73,0.5,750)*SO;
	rate_COmole.N_S2_NS_S_2          = HMRATE((1e-11)*1.73,0.5,4000)*S2;
	rate_COmole.CH2_CN_HCN_CH_2      = HMRATE((1e-12)*5.3,0,2500)*CN;
	rate_COmole.CH2_NO_HCN_OH_2      = HMRATE(0.000000000000832,0,1443)*NO;
	rate_COmole.CH2_HNO_NO_CH3_2     = HMRATE((1e-11)*1.73,0.5,0)*HNO;
	rate_COmole.NH_NH_N2_H_H_2      = HMRATE((1e-9)*1.16,0,0)*NH;
	rate_COmole.NH_NH_N2_H2_2        = HMRATE((1e-11)*1.7,0,0)*NH;
	rate_COmole.NH_O_OH_N_2          = HMRATE((1e-11)*1.16,0,0)*ATO;
	rate_COmole.NH_O_NO_H_2          = HMRATE((1e-10)*1.16,0,0)*ATO;
	rate_COmole.NH_OH_HNO_H_2        = HMRATE((1e-11)*3.32,0,0)*OH;
	rate_COmole.NH_OH_NH2_O_2        = HMRATE((1e-12)*2.93,0.1,5800)*OH;
	rate_COmole.NH_OH_H2O_N_2        = HMRATE((1e-12)*3.11,1.2,0)*OH;
	rate_COmole.NH_H2O_OH_NH2_2      = HMRATE((1e-12)*1.83,1.6,14090)*H2O;
	rate_COmole.NH_CN_HCN_N_2        = HMRATE((1e-12)*2.94,0.5,1000)*CN;
	rate_COmole.NH_NO_N2O_H_2        = HMRATE((1e-10)*1.16,-1.03,420)*NO;
	rate_COmole.NH_NO_N2_O_H_2      = HMRATE((1e-11)*5.,0,0)*NO;
	rate_COmole.NH_NO_N2_OH_2        = HMRATE((1e-11)*1.46,-0.58,37)*NO;
	rate_COmole.NH_S_HS_N_2          = HMRATE((1e-11)*1.73,0.5,4000)*ATS;
	rate_COmole.NH_S_NS_H_2          = HMRATE((1e-11)*1.73,0.5,0)*ATS;
	rate_COmole.NH_NO2_HNO_NO_2      = HMRATE((1e-12)*5.72,0.5,2500)*NO2;
	rate_COmole.NH_NO2_N2O_OH_2      = HMRATE((1e-13)*1.44,0, 1140)*NO2;
	rate_COmole.CH3_NH3_CH4_NH2_2    = HMRATE(0.0000000000000955,0,4890)*NH3;
	rate_COmole.CH3_CN_HCN_CH2_2     = HMRATE((1e-12)*9.21,0.7,1500)*CN;
	rate_COmole.CH3_HNO_NO_CH4_2     = HMRATE((1e-11)*1.44,0.5,0)*HNO;
	rate_COmole.O_NH2_OH_NH_2        = HMRATE((1e-11)*1.39,0,40)*NH2;
	rate_COmole.O_NH2_NO_H2_2        = HMRATE((1e-12)*8.3,0,0)*NH2;
	rate_COmole.O_NH3_OH_NH2_2       = HMRATE((1e-11)*1.89,0,4003)*NH3;
	rate_COmole.O_CN_NO_C_2          = HMRATE((1e-11)*3.81,0.5,14545)*CN;
	rate_COmole.O_HCN_CN_OH_2        = HMRATE((1e-10)*6.21,0,12439)*HCN;
	rate_COmole.O_HCN_OCN_H_2        = HMRATE((1e-12)*1.36,1.38,3693)*HCN;
	rate_COmole.O_N2_NO_N_2          = HMRATE((1e-10)*2.51,0,38602)*N2;
	rate_COmole.O_NO_O2_N_2          = HMRATE((1e-11)*1.18,0,20413)*NO;
	rate_COmole.O_HNO_NO_OH_2        = HMRATE((1e-11)*6.,0,0)*HNO;
	rate_COmole.O_HNO_O2_NH_2        = HMRATE((1e-12)*2.94,0.5,3500)*HNO;
	rate_COmole.O_HNO_NO2_H_2        = HMRATE((1e-12)*1.44,0.5,0)*HNO;
	rate_COmole.O_HS_S_OH_2          = HMRATE((1e-11)*1.74,0.67,956)*HS;
	rate_COmole.O_HS_SO_H_2          = HMRATE((1e-10)*2.32,0,0)*HS;
	rate_COmole.O_OCN_O2_CN_2        = HMRATE((1e-10)*4.02,-1.43,3501)*OCN;
	rate_COmole.O_SIN_NO_SI_2        = HMRATE((1e-11)*2.5,0.5,0)*SIN;
	rate_COmole.O_SIN_SIO_N_2        = HMRATE((1e-11)*5.75,0.1,200)*SIN;
	rate_COmole.O_N2O_NO_NO_2        = HMRATE((1e-10)*1.15,0,13400)*N2O;
	rate_COmole.O_N2O_O2_N2_2        = HMRATE((1e-10)*1.66,0,14100)*N2O;
	rate_COmole.O_CS_SO_C_2          = HMRATE((1e-11)*4.68,0.5,28940)*CS;
	rate_COmole.O_NS_S_NO_2          = HMRATE((1e-11)*5.,0.5,0)*NS;
	rate_COmole.O_NS_SO_N_2          = HMRATE((1e-11)*1.73,0.5,4000)*NS;
	rate_COmole.O_SO_S_O2_2          = HMRATE(0.00000000000066,0,2760)*SO;
	rate_COmole.O_S2_SO_S_2          = HMRATE((1e-11)*1.73,0.5,0)*S2;
	rate_COmole.NH2_OH_NH3_O_2       = HMRATE(0.000000000000208,0.76,262)*OH;
	rate_COmole.NH2_OH_H2O_NH_2      = HMRATE((1e-12)*1.5,0,0)*OH;
	rate_COmole.NH2_NO_N2_OH_H_2    = HMRATE((1e-12)*1.49,0,0)*NO;
	rate_COmole.NH2_NO_N2_H2O_2      = HMRATE((1e-11)*4.27,-2.5,331)*NO;
	rate_COmole.CH4_CN_HCN_CH3_2     = HMRATE((1e-12)*3.14,1.53,504)*CN;
	rate_COmole.OH_NH3_H2O_NH2_2     = HMRATE((1e-13)*1.47,2.05,7)*NH3;
	rate_COmole.OH_CN_HCN_O_2        = HMRATE(1.0e-11,0,1000)*CN;
	rate_COmole.OH_CN_OCN_H_2        = HMRATE((1e-11)*7.,0,0)*CN;
	rate_COmole.OH_HCN_CN_H2O_2      = HMRATE((1e-13)*1.87,1.5,3887)*HCN;
	rate_COmole.OH_NO_NO2_H_2        = HMRATE((1e-12)*5.2,0,15100)*NO;
	rate_COmole.OH_S_HS_O_2          = HMRATE(6.6e-11,0,0)*ATS;
	rate_COmole.OH_S_SO_H_2          = HMRATE(6.6e-11,0,0)*ATS;
	rate_COmole.OH_N2O_HNO_NO_2      = HMRATE(1.04E-17,4.33,12623)*N2O;
	rate_COmole.OH_CS_OCS_H_2        = HMRATE(0.0000000000000939,1.12,800)*CS;
	rate_COmole.NH3_CN_HCN_NH2_2     = HMRATE((1e-11)*2.6,-1.1,0)*CN;
	rate_COmole.CN_NO_OCN_N_2        = HMRATE((1e-10)*1.62,0,21205)*NO;
	rate_COmole.CN_HNO_NO_HCN_2      = HMRATE((1e-11)*1.5,0.5,0)*HNO;
	rate_COmole.CN_S_NS_C_2          = HMRATE((1e-11)*5.71,0.5,32010)*ATS;
	rate_COmole.CN_S_CS_N_2          = HMRATE((1e-11)*1.73,0.5,0)*ATS;
	rate_COmole.N2_O2_N2O_O_2        = HMRATE(1.0e-10,0,55200)*O2;
	rate_COmole.NO_NO_O2_N2_2        = HMRATE((1e-11)*2.51,0,30653)*NO;
	rate_COmole.NO_NO_N2O_O_2        = HMRATE((1e-12)*7.22,0,33155)*NO;
	rate_COmole.NO_HNO_N2O_OH_2      = HMRATE((1e-11)*1.41,0,14890)*HNO;
	rate_COmole.NO_S_NS_O_2          = HMRATE(2.94e-11,0.5,17465)*ATS;
	rate_COmole.NO_S_SO_N_2          = HMRATE((1e-10)*1.75,0,20200)*ATS;
	rate_COmole.O2_S_SO_O_2          = HMRATE((1e-12)*2.28,0.52,0)*ATS;
	rate_COmole.S_SO_S2_O_2          = HMRATE((1e-11)*1.73,0.5,11500)*SO;
	rate_COmole.C_NHP_N_CHP_2        = HMRATE((1e-9)*1.6,0,0)*NHP;
	rate_COmole.CP_NH_CNP_H_2        = HMRATE((1e-10)*7.8,0,0)*NH;
	rate_COmole.CP_NH2_HCNP_H_2      = HMRATE(1.1e-9,0,0)*NH2;
	rate_COmole.C_NH2P_NH_CHP_2      = HMRATE(1.2e-9,0,0)*NH2P;
	rate_COmole.CP_NH3_HCNP_H2_2     = HMRATE((1e-11)*7.,0,0)*NH3;
	rate_COmole.C_NH3P_NH_CH2P_2     = HMRATE(1.0e-11,0,0)*NH3P;
	rate_COmole.C_HCNP_CN_CHP_2      = HMRATE(1.1e-9,0,0)*HCNP;
	rate_COmole.C_HNOP_NO_CHP_2      = HMRATE(1.0e-9,0,0)*HNOP;
	rate_COmole.CP_HS_CSP_H_2        = HMRATE(1.1e-9,0,0)*HS;
	rate_COmole.C_HSP_CSP_H_2        = HMRATE((1e-10)*9.9,0,0)*HSP;
	rate_COmole.CP_OCN_COP_CN_2      = HMRATE((1e-9)*3.8,0,0)*OCN;
	rate_COmole.CP_NS_CSP_N_2        = HMRATE((1e-10)*7.6,0,0)*NS;
	rate_COmole.CP_SO_S_COP_2        = HMRATE((1e-10)*2.6,0,0)*SO;
	rate_COmole.CP_SO_CSP_O_2        = HMRATE((1e-10)*2.6,0,0)*SO;
	rate_COmole.CHP_N_CNP_H_2        = HMRATE((1e-10)*1.9,0,0)*ATN;
	rate_COmole.CH_NP_N_CHP_2        = HMRATE((1e-10)*3.6,0,0)*NP;
	rate_COmole.CH_NP_CNP_H_2        = HMRATE((1e-10)*3.6,0,0)*NP;
	rate_COmole.CH_NHP_CH2P_N_2      = HMRATE((1e-10)*9.9,0,0)*NHP;
	rate_COmole.CHP_NH_CNP_H2_2      = HMRATE((1e-10)*7.6,0,0)*NH;
	rate_COmole.CHP_NH2_HCNP_H2_2    = HMRATE(1.1e-9,0,0)*NH2;
	rate_COmole.CH_NH2P_NH_CH2P_2    = HMRATE(3.5e-10,0,0)*NH2P;
	rate_COmole.CHP_NH3_NH4P_C_2     = HMRATE((1e-10)*4.05,0,0)*NH3;
	rate_COmole.CH_NH3P_NH4P_C_2     = HMRATE((1e-10)*6.9,0,0)*NH3P;
	rate_COmole.CH_HCNP_CN_CH2P_2    = HMRATE((1e-10)*6.3,0,0)*HCNP;
	rate_COmole.CH_HNOP_NO_CH2P_2    = HMRATE(6.2e-10,0,0)*HNOP;
	rate_COmole.CHP_S_HSP_C_2        = HMRATE((1e-10)*4.7,0,0)*ATS;
	rate_COmole.CHP_S_CSP_H_2        = HMRATE((1e-10)*4.7,0,0)*ATS;
	rate_COmole.CH_SP_CSP_H_2        = HMRATE(6.2e-10,0,0)*SP;
	rate_COmole.CH_HSP_S_CH2P_2      = HMRATE((1e-10)*5.8,0,0)*HSP;
	rate_COmole.N_CH2P_HCNP_H_2      = HMRATE((1e-10)*2.2,0,0)*CH2P;
	rate_COmole.NP_NH_N2P_H_2        = HMRATE((1e-10)*3.7,0,0)*NH;
	rate_COmole.N_NHP_N2P_H_2        = HMRATE(1.3e-9,0,0)*NHP;
	rate_COmole.NP_CH4_HCNP_H2_H_2   = HMRATE((1e-11)*5.6,0,0)*CH4;
	rate_COmole.N_OHP_NOP_H_2        = HMRATE((1e-10)*8.9,0,0)*OHP;
	rate_COmole.NP_NH3_NH2P_NH_2     = HMRATE((1e-10)*2.16,0,0)*NH3;
	rate_COmole.N_H2OP_HNOP_H_2      = HMRATE((1e-10)*1.9,0,0)*H2OP;
	rate_COmole.NP_NO_N2P_O_2        = HMRATE((1e-11)*7.9,0,0)*NO;
	rate_COmole.NP_O2_NO_OP_2        = HMRATE((1e-11)*3.66,0,0)*O2;
	rate_COmole.NP_O2_NOP_O_2        = HMRATE((1e-10)*2.63,0,0)*O2;
	rate_COmole.N_O2P_NOP_O_2        = HMRATE((1e-10)*1.8,0,0)*O2P;
	rate_COmole.N_HSP_NSP_H_2        = HMRATE((1e-10)*7.4,0,0)*HSP;
	rate_COmole.N_SIOP_NOP_SI_2      = HMRATE((1e-11)*9.,0,0)*SIOP;
	rate_COmole.N_SIOP_NO_SIP_2      = HMRATE((1e-10)*2.1,0,0)*SIOP;
	rate_COmole.N_SOP_NSP_O_2        = HMRATE((1e-11)*5.,0,0)*SOP;
	rate_COmole.NP_OCS_CSP_NO_2      = HMRATE((1e-11)*7.,0,0)*OCS;
	rate_COmole.CH2_NHP_CH3P_N_2     = HMRATE((1e-9)*1.4,0,0)*NHP;
	rate_COmole.CH2_NH2P_CH3P_NH_2   = HMRATE((1e-10)*4.9,0,0)*NH2P;
	rate_COmole.CH2P_NH3_NH4P_CH_2   = HMRATE((1e-9)*1.26,0,0)*NH3;
	rate_COmole.CH2_NH3P_NH2_CH3P_2  = HMRATE((1e-10)*9.6,0,0)*NH3P;
	rate_COmole.CH2_HCNP_CN_CH3P_2   = HMRATE((1e-10)*8.7,0,0)*HCNP;
	rate_COmole.CH2_HNOP_NO_CH3P_2   = HMRATE((1e-10)*8.6,0,0)*HNOP;
	rate_COmole.CH2P_S_HCSP_H_2      = HMRATE((1e-9)*1.4,0,0)*ATS;
	rate_COmole.CH2_SP_HCSP_H_2      = HMRATE(1.0e-11,0,0)*SP;
	rate_COmole.NHP_NH_NH2P_N_2      = HMRATE(1.0e-9,0,0)*NH;
	rate_COmole.NHP_O_OHP_N_2        = HMRATE(1.0e-9,0,0)*ATO;
	rate_COmole.NH_OP_NOP_H_2        = HMRATE((1e-10)*3.6,0,0)*OP;
	rate_COmole.NHP_NH2_NH3P_N_2     = HMRATE((1e-9)*1.5,0,0)*NH2;
	rate_COmole.NH_NH2P_NH3P_N_2     = HMRATE((1e-10)*7.3,0,0)*NH2P;
	rate_COmole.NHP_OH_H2OP_N_2      = HMRATE(1.0e-9,0,0)*OH;
	rate_COmole.NH_OHP_NH2P_O_2      = HMRATE((1e-10)*3.6,0,0)*OHP;
	rate_COmole.NHP_NH3_NH4P_N_2     = HMRATE((1e-10)*6.,0,0)*NH3;
	rate_COmole.NH_NH3P_NH4P_N_2     = HMRATE((1e-10)*7.1,0,0)*NH3P;
	rate_COmole.NH_CH5P_CH4_NH2P_2   = HMRATE((1e-10)*7.1,0,0)*CH5P;
	rate_COmole.NHP_H2O_NH3P_O_2     = HMRATE((1e-10)*1.75,0,0)*H2O;
	rate_COmole.NHP_H2O_H3OP_N_2     = HMRATE((1e-9)*1.05,0,0)*H2O;
	rate_COmole.NHP_H2O_HNOP_H2_2    = HMRATE(3.5e-10,0,0)*H2O;
	rate_COmole.NH_H2OP_H3OP_N_2     = HMRATE((1e-10)*7.1,0,0)*H2OP;
	rate_COmole.NHP_H2O_OH_NH2P_2    = HMRATE((1e-10)*8.75,0,0)*H2O;
	rate_COmole.NHP_CN_HCNP_N_2      = HMRATE((1e-9)*1.6,0,0)*CN;
	rate_COmole.NH_HCNP_CN_NH2P_2    = HMRATE((1e-10)*6.5,0,0)*HCNP;
	rate_COmole.NH_COP_HCOP_N_2      = HMRATE((1e-10)*3.2,0,0)*COP;
	rate_COmole.NH_SIP_SINP_H_2      = HMRATE(1.0e-9,0,0)*SIP;
	rate_COmole.NH_HNOP_NO_NH2P_2    = HMRATE((1e-10)*6.3,0,0)*HNOP;
	rate_COmole.NH_O2P_HNOP_O_2      = HMRATE((1e-10)*3.2,0,0)*O2P;
	rate_COmole.NHP_O2_NOP_OH_2      = HMRATE((1e-10)*2.05,0,0)*O2;
	rate_COmole.NH_O2P_NO2P_H_2      = HMRATE((1e-10)*3.2,0,0)*O2P;
	rate_COmole.NHP_S_HSP_N_2        = HMRATE((1e-10)*6.9,0,0)*ATS;
	rate_COmole.NHP_S_NSP_H_2        = HMRATE((1e-10)*6.9,0,0)*ATS;
	rate_COmole.NH_SP_NSP_H_2        = HMRATE((1e-10)*6.3,0,0)*SP;
	rate_COmole.CH3P_NH3_NH4P_CH2_2  = HMRATE((1e-10)*3.4,0,0)*NH3;
	rate_COmole.CH3P_S_HCSP_H2_2     = HMRATE((1e-9)*1.4,0,0)*ATS;
	rate_COmole.O_NH2P_HNOP_H_2      = HMRATE((1e-11)*7.2,0,0)*NH2P;
	rate_COmole.O_NH3P_HNOP_H2_2     = HMRATE(1.0e-11,0,0)*NH3P;
	rate_COmole.OP_CN_NOP_C_2        = HMRATE(1.0e-9,0,0)*CN;
	rate_COmole.OP_HCN_COP_NH_2      = HMRATE(1.2e-9,0,0)*HCN;
	rate_COmole.OP_HCN_NOP_CH_2      = HMRATE(1.2e-9,0,0)*HCN;
	rate_COmole.OP_HCN_HCOP_N_2      = HMRATE(1.2e-9,0,0)*HCN;
	rate_COmole.OP_N2_NOP_N_2        = HMRATE((1e-12)*1.2,0,0)*N2;
	rate_COmole.O_N2P_NOP_N_2        = HMRATE((1e-10)*1.3,0,0)*N2P;
	rate_COmole.O_HNOP_NO2P_H_2      = HMRATE((1e-12)*1.,0,0)*HNOP;
	rate_COmole.O_HSP_SP_OH_2        = HMRATE((1e-10)*2.9,0,0)*HSP;
	rate_COmole.O_HSP_SOP_H_2        = HMRATE((1e-10)*2.9,0,0)*HSP;
	rate_COmole.O_SINP_SIOP_N_2      = HMRATE(1.0e-9,0,0)*SINP;
	rate_COmole.OP_N2O_NOP_NO_2      = HMRATE((1e-10)*6.3,0,0)*N2O;
	rate_COmole.O_CSP_S_COP_2        = HMRATE((1e-11)*6.,0,0)*CSP;
	rate_COmole.O_HCSP_S_HCOP_2      = HMRATE((1e-12)*5.,0,0)*HCSP;
	rate_COmole.O_HCSP_OCSP_H_2      = HMRATE((1e-12)*5.,0,0)*HCSP;
	rate_COmole.OP_NO2_O2_NOP_2      = HMRATE((1e-10)*8.3,0,0)*NO2;
	rate_COmole.O_NSP_S_NOP_2        = HMRATE((1e-10)*6.1,0,0)*NSP;
	rate_COmole.NH2P_NH2_NH3P_NH_2   = HMRATE(1.0e-9,0,0)*NH2;
	rate_COmole.NH2_OHP_NH3P_O_2     = HMRATE(5.0e-10,0,0)*OHP;
	rate_COmole.NH2P_OH_H2OP_NH_2    = HMRATE((1e-10)*7.1,0,0)*OH;
	rate_COmole.NH2P_NH3_NH4P_NH_2   = HMRATE((1e-9)*1.61,0,0)*NH3;
	rate_COmole.NH2_NH3P_NH4P_NH_2   = HMRATE(1.0e-11,0,0)*NH3P;
	rate_COmole.NH2_CH5P_NH3P_CH4_2  = HMRATE((1e-10)*9.9,0,0)*CH5P;
	rate_COmole.NH2P_H2O_NH3P_OH_2   = HMRATE(1.0e-10,0,0)*H2O;
	rate_COmole.NH2P_H2O_H3OP_NH_2   = HMRATE((1e-9)*2.76,0,0)*H2O;
	rate_COmole.NH2_H2OP_NH3P_OH_2   = HMRATE((1e-10)*4.9,0,0)*H2OP;
	rate_COmole.NH2P_H2O_NH4P_O_2    = HMRATE((1e-10)*1.45,0,0)*H2O;
	rate_COmole.NH2_H3OP_H2O_NH3P_2  = HMRATE((1e-10)*9.7,0,0)*H3OP;
	rate_COmole.NH2_HCNP_CN_NH3P_2   = HMRATE(9.0e-10,0,0)*HCNP;
	rate_COmole.NH2_COP_HCOP_NH_2    = HMRATE((1e-10)*4.5,0,0)*COP;
	rate_COmole.NH2_HNOP_NO_NH3P_2   = HMRATE((1e-10)*8.8,0,0)*HNOP;
	rate_COmole.NH2P_O2_HNOP_OH_2    = HMRATE((1e-11)*2.1,0,0)*O2;
	rate_COmole.NH2P_S_HSP_NH_2      = HMRATE((1e-10)*4.4,0,0)*ATS;
	rate_COmole.CH4P_NH3_NH4P_CH3_2  = HMRATE((1e-9)*1.15,0,0)*NH3;
	rate_COmole.CH4_NH3P_NH4P_CH3_2  = HMRATE((1e-10)*4.8,0,0)*NH3P;
	rate_COmole.CH4_N2P_N2_CH2P_H2_2 = HMRATE((1e-11)*7.,0,0)*N2P;
	rate_COmole.CH4_N2P_N2_CH3P_H_2  = HMRATE((1e-10)*9.3,0,0)*N2P;
	rate_COmole.CH4_HNOP_NO_CH5P_2   = HMRATE(1.0e-10,0,0)*HNOP;
	rate_COmole.CH4_SP_HCSP_H2_H_2   = HMRATE(2.0e-11,0,0)*SP;
	rate_COmole.CH4_CSP_HCSP_CH3_2   = HMRATE(5.0e-10,0,0)*CSP;
	rate_COmole.OHP_NH3_NH4P_O_2     = HMRATE(1.2e-9,0,0)*NH3;
	rate_COmole.OH_NH3P_NH4P_O_2     = HMRATE(7.0e-10,0,0)*NH3P;
	rate_COmole.OHP_CN_HCNP_O_2      = HMRATE(1.0e-9,0,0)*CN;
	rate_COmole.OH_HCNP_CN_H2OP_2    = HMRATE((1e-10)*6.3,0,0)*HCNP;
	rate_COmole.OHP_NO_HNOP_O_2      = HMRATE((1e-10)*6.11,0,0)*NO;
	rate_COmole.OH_HNOP_NO_H2OP_2    = HMRATE(6.2e-10,0,0)*HNOP;
	rate_COmole.OHP_S_HSP_O_2        = HMRATE((1e-10)*4.3,0,0)*ATS;
	rate_COmole.OHP_S_SOP_H_2        = HMRATE((1e-10)*4.3,0,0)*ATS;
	rate_COmole.OH_SP_SOP_H_2        = HMRATE((1e-10)*6.1,0,0)*SP;
	rate_COmole.NH3P_NH3_NH4P_NH2_2  = HMRATE((1e-9)*2.2,0,0)*NH3;
	rate_COmole.NH3_CH5P_NH4P_CH4_2  = HMRATE((1e-9)*2.5,0,0)*CH5P;
	rate_COmole.NH3P_H2O_NH4P_OH_2   = HMRATE(1.1e-10,0,0)*H2O;
	rate_COmole.NH3_H2OP_NH4P_OH_2   = HMRATE((1e-10)*9.45,0,0)*H2OP;
	rate_COmole.NH3_H3OP_NH4P_H2O_2  = HMRATE((1e-9)*2.2,0,0)*H3OP;
	rate_COmole.NH3_COP_HCOP_NH2_2   = HMRATE((1e-11)*4.12,0,0)*COP;
	rate_COmole.NH3_HNOP_NO_NH4P_2   = HMRATE(1.1e-9,0,0)*HNOP;
	rate_COmole.NH3_HSP_S_NH4P_2     = HMRATE((1e-10)*9.75,0,0)*HSP;
	rate_COmole.NH3_HCSP_CS_NH4P_2   = HMRATE(2.0e-9,0,0)*HCSP;
	rate_COmole.CH5P_S_HSP_CH4_2     = HMRATE(1.3e-9,0,0)*ATS;
	rate_COmole.H2O_CNP_HCNP_OH_2    = HMRATE((1e-9)*1.6,0,0)*CNP;
	rate_COmole.H2O_CNP_HCOP_NH_2    = HMRATE((1e-10)*1.6,0,0)*CNP;
	rate_COmole.H2O_HCNP_CN_H3OP_2   = HMRATE((1e-9)*1.8,0,0)*HCNP;
	rate_COmole.H2O_HNOP_NO_H3OP_2   = HMRATE((1e-9)*2.3,0,0)*HNOP;
	rate_COmole.H2OP_S_HSP_OH_2      = HMRATE((1e-10)*4.3,0,0)*ATS;
	rate_COmole.H2O_HSP_S_H3OP_2     = HMRATE((1e-10)*7.8,0,0)*HSP;
	rate_COmole.H3OP_CS_HCSP_H2O_2   = HMRATE(1.0e-9,0,0)*CS;
	rate_COmole.CNP_NO_OCNP_N_2      = HMRATE((1e-10)*1.9,0,0)*NO;
	rate_COmole.CN_HNOP_NO_HCNP_2    = HMRATE((1e-10)*8.7,0,0)*HNOP;
	rate_COmole.CNP_O2_OCNP_O_2      = HMRATE((1e-11)*8.6,0,0)*O2;
	rate_COmole.HCNP_S_HSP_CN_2      = HMRATE((1e-10)*5.7,0,0)*ATS;
	rate_COmole.HNOP_S_HSP_NO_2      = HMRATE(1.1e-9,0,0)*ATS;
	rate_COmole.O2_SP_SOP_O_2        = HMRATE((1e-11)*1.5,0,0)*SP;
	rate_COmole.O2P_S_SOP_O_2        = HMRATE(5.4e-10,0,0)*ATS;
	rate_COmole.O2_CSP_OCSP_O_2      = HMRATE((1e-10)*1.3,0,0)*CSP;
	rate_COmole.S_SIOP_SO_SIP_2      = HMRATE(1.0e-9,0,0)*SIOP;
	rate_COmole.CP_NH3_NH3P_C_2      = HMRATE((1e-10)*5.06,0,0)*NH3;
	rate_COmole.C_CNP_CN_CP_2        = HMRATE(1.1e-10,0,0)*CNP;
	rate_COmole.C_N2P_N2_CP_2        = HMRATE(1.1e-10,0,0)*N2P;
	rate_COmole.CP_NO_NOP_C_2        = HMRATE(5.2e-10,0,0)*NO;
	rate_COmole.CP_SIN_SINP_C_2      = HMRATE(1.0e-9,0,0)*SIN;
	rate_COmole.C_CSP_CS_CP_2        = HMRATE((1e-9)*1.6,0,0)*CSP;
	rate_COmole.CP_NS_NSP_C_2        = HMRATE((1e-10)*7.6,0,0)*NS;
	rate_COmole.CP_SO_SOP_C_2        = HMRATE((1e-10)*2.6,0,0)*SO;
	rate_COmole.CP_OCS_OCSP_C_2      = HMRATE(4.0e-10,0,0)*OCS;
	rate_COmole.CH_NH2P_NH2_CHP_2    = HMRATE(3.5e-10,0,0)*NH2P;
	rate_COmole.CHP_NH3_NH3P_CH_2    = HMRATE((1e-10)*4.59,0,0)*NH3;
	rate_COmole.CH_CNP_CN_CHP_2      = HMRATE((1e-10)*6.4,0,0)*CNP;
	rate_COmole.CH_N2P_N2_CHP_2      = HMRATE((1e-10)*6.3,0,0)*N2P;
	rate_COmole.CHP_NO_NOP_CH_2      = HMRATE((1e-10)*7.6,0,0)*NO;
	rate_COmole.NP_NH_NHP_N_2        = HMRATE((1e-10)*3.7,0,0)*NH;
	rate_COmole.NP_NH2_NH2P_N_2      = HMRATE(1.0e-9,0,0)*NH2;
	rate_COmole.NP_NH3_NH3P_N_2      = HMRATE((1e-9)*1.97,0,0)*NH3;
	rate_COmole.NP_CN_CNP_N_2        = HMRATE(1.1e-9,0,0)*CN;
	rate_COmole.NP_HCN_HCNP_N_2      = HMRATE(1.2e-9,0,0)*HCN;
	rate_COmole.N_N2P_N2_NP_2        = HMRATE(1.0e-11,0,0)*N2P;
	rate_COmole.NP_NO_NOP_N_2        = HMRATE((1e-10)*4.51,0,0)*NO;
	rate_COmole.NP_OCS_OCSP_N_2      = HMRATE((1e-9)*1.02,0,0)*OCS;
	rate_COmole.CH2_NH2P_NH2_CH2P_2  = HMRATE((1e-10)*4.9,0,0)*NH2P;
	rate_COmole.CH2_CNP_CN_CH2P_2    = HMRATE((1e-10)*8.8,0,0)*CNP;
	rate_COmole.CH2_N2P_N2_CH2P_2    = HMRATE((1e-10)*8.7,0,0)*N2P;
	rate_COmole.CH2P_NO_NOP_CH2_2    = HMRATE((1e-10)*4.2,0,0)*NO;
	rate_COmole.NH_OP_O_NHP_2        = HMRATE((1e-10)*3.6,0,0)*OP;
	rate_COmole.NH_OHP_OH_NHP_2      = HMRATE((1e-10)*3.6,0,0)*OHP;
	rate_COmole.NHP_NH3_NH3P_NH_2    = HMRATE((1e-9)*1.8,0,0)*NH3;
	rate_COmole.NHP_H2O_H2OP_NH_2    = HMRATE((1e-9)*1.05,0,0)*H2O;
	rate_COmole.NH_CNP_CN_NHP_2      = HMRATE((1e-10)*6.5,0,0)*CNP;
	rate_COmole.NH_N2P_N2_NHP_2      = HMRATE((1e-10)*6.5,0,0)*N2P;
	rate_COmole.NHP_NO_NOP_NH_2      = HMRATE((1e-10)*7.12,0,0)*NO;
	rate_COmole.NHP_O2_O2P_NH_2      = HMRATE((1e-10)*4.51,0,0)*O2;
	rate_COmole.NHP_S_SP_NH_2        = HMRATE((1e-10)*6.9,0,0)*ATS;
	rate_COmole.CH3P_NO_NOP_CH3_2    = HMRATE(1.0e-9,0,0)*NO;
	rate_COmole.OP_NH2_NH2P_O_2      = HMRATE(1.0e-9,0,0)*NH2;
	rate_COmole.OP_NH3_NH3P_O_2      = HMRATE(1.2e-9,0,0)*NH3;
	rate_COmole.O_CNP_CN_OP_2        = HMRATE((1e-11)*6.5,0,0)*CNP;
	rate_COmole.O_HCNP_HCN_OP_2      = HMRATE((1e-11)*6.5,0,0)*HCNP;
	rate_COmole.O_N2P_N2_OP_2        = HMRATE(1.0e-11,0,0)*N2P;
	rate_COmole.OP_NO_NOP_O_2        = HMRATE((1e-12)*1.7,0,0)*NO;
	rate_COmole.OP_OCS_OCSP_O_2      = HMRATE((1e-10)*6.5,0,0)*OCS;
	rate_COmole.NH2_OHP_OH_NH2P_2    = HMRATE(5.0e-10,0,0)*OHP;
	rate_COmole.NH2P_NH3_NH3P_NH2_2  = HMRATE((1e-10)*6.9,0,0)*NH3;
	rate_COmole.NH2_H2OP_H2O_NH2P_2  = HMRATE((1e-10)*4.9,0,0)*H2OP;
	rate_COmole.NH2_CNP_CN_NH2P_2    = HMRATE((1e-10)*9.1,0,0)*CNP;
	rate_COmole.NH2_N2P_N2_NH2P_2    = HMRATE((1e-10)*8.9,0,0)*N2P;
	rate_COmole.NH2P_NO_NOP_NH2_2    = HMRATE(7.0e-10,0,0)*NO;
	rate_COmole.NH2_O2P_O2_NH2P_2    = HMRATE((1e-10)*8.7,0,0)*O2P;
	rate_COmole.NH2P_S_SP_NH2_2      = HMRATE((1e-10)*4.4,0,0)*ATS;
	rate_COmole.CH4P_NH3_NH3P_CH4_2  = HMRATE((1e-9)*1.65,0,0)*NH3;
	rate_COmole.CH4P_OCS_OCSP_CH4_2  = HMRATE((1e-10)*4.2,0,0)*OCS;
	rate_COmole.OHP_NH3_NH3P_OH_2    = HMRATE(1.2e-9,0,0)*NH3;
	rate_COmole.OH_CNP_CN_OHP_2      = HMRATE((1e-10)*6.4,0,0)*CNP;
	rate_COmole.OH_N2P_N2_OHP_2      = HMRATE((1e-10)*6.3,0,0)*N2P;
	rate_COmole.OHP_NO_NOP_OH_2      = HMRATE((1e-10)*3.59,0,0)*NO;
	rate_COmole.NH3_H2OP_H2O_NH3P_2  = HMRATE((1e-9)*2.21,0,0)*H2OP;
	rate_COmole.NH3_HCNP_HCN_NH3P_2  = HMRATE((1e-9)*1.68,0,0)*HCNP;
	rate_COmole.NH3_N2P_N2_NH3P_2    = HMRATE((1e-9)*1.9,0,0)*N2P;
	rate_COmole.NH3P_SI_SIP_NH3_2    = HMRATE((1e-9)*1.9,0,0)*ATSI;
	rate_COmole.NH3_O2P_O2_NH3P_2    = HMRATE(2.0e-9,0,0)*O2P;
	rate_COmole.NH3_SP_S_NH3P_2      = HMRATE((1e-9)*1.44,0,0)*SP;
	rate_COmole.NH3_HSP_HS_NH3P_2    = HMRATE((1e-10)*5.25,0,0)*HSP;
	rate_COmole.NH3_SOP_SO_NH3P_2    = HMRATE(1.3e-9,0,0)*SOP;
	rate_COmole.H2O_HCNP_HCN_H2OP_2  = HMRATE((1e-9)*1.8,0,0)*HCNP;
	rate_COmole.H2O_N2P_N2_H2OP_2    = HMRATE((1e-9)*2.3,0,0)*N2P;
	rate_COmole.H2OP_NO_NOP_H2O_2    = HMRATE((1e-10)*2.7,0,0)*NO;
	rate_COmole.CNP_HCN_HCNP_CN_2    = HMRATE((1e-9)*1.79,0,0)*HCN;
	rate_COmole.CN_N2P_N2_CNP_2      = HMRATE(1.0e-10,0,0)*N2P;
	rate_COmole.CNP_NO_NOP_CN_2      = HMRATE((1e-10)*5.7,0,0)*NO;
	rate_COmole.CNP_O2_O2P_CN_2      = HMRATE((1e-10)*2.58,0,0)*O2;
	rate_COmole.CNP_S_SP_CN_2        = HMRATE(1.1e-9,0,0)*ATS;
	rate_COmole.HCN_N2P_N2_HCNP_2    = HMRATE((1e-10)*3.9,0,0)*N2P;
	rate_COmole.HCNP_NO_NOP_HCN_2    = HMRATE((1e-10)*8.1,0,0)*NO;
	rate_COmole.HCNP_O2_O2P_HCN_2    = HMRATE((1e-10)*3.2,0,0)*O2;
	rate_COmole.HCNP_S_SP_HCN_2      = HMRATE((1e-10)*5.7,0,0)*ATS;
	rate_COmole.N2P_NO_NOP_N2_2      = HMRATE((1e-10)*4.4,0,0)*NO;
	rate_COmole.N2P_O2_O2P_N2_2      = HMRATE((1e-11)*5.,0,0)*O2;
	rate_COmole.N2P_S_SP_N2_2        = HMRATE(1.1e-9,0,0)*ATS;
	rate_COmole.SI_NOP_NO_SIP_2      = HMRATE((1e-9)*1.6,0,0)*NOP;
	rate_COmole.SI_HSP_HS_SIP_2      = HMRATE((1e-9)*1.4,0,0)*HSP;
	rate_COmole.SI_CSP_CS_SIP_2      = HMRATE((1e-10)*1.5,0,0)*CSP;
	rate_COmole.NO_HNOP_HNO_NOP_2    = HMRATE(7.0e-10,0,0)*HNOP;
	rate_COmole.NO_O2P_O2_NOP_2      = HMRATE((1e-10)*4.5,0,0)*O2P;
	rate_COmole.NO_SP_S_NOP_2        = HMRATE((1e-10)*3.7,0,0)*SP;
	rate_COmole.NO_HSP_HS_NOP_2      = HMRATE((1e-10)*4.5,0,0)*HSP;
	rate_COmole.NO_SIOP_SIO_NOP_2    = HMRATE((1e-10)*7.2,0,0)*SIOP;
	rate_COmole.NO_S2P_S2_NOP_2      = HMRATE((1e-10)*5.1,0,0)*S2P;
	rate_COmole.O2P_NO2_NO2P_O2_2    = HMRATE((1e-10)*6.6,0,0)*NO2;
	rate_COmole.S_HSP_HS_SP_2        = HMRATE((1e-10)*9.7,0,0)*HSP;
	rate_COmole.C_N_CN_NU_2          = HMRATE((1e-17)*1.,0,0)*ATN;
	rate_COmole.C_S_CS_NU_2          = HMRATE(4.36E-19,0.22,0)*ATS;
	rate_COmole.CP_S_CSP_NU_2        = HMRATE(3.07E-19,0.15,0)*ATS;
	rate_COmole.NP_N_N2P_NU_2        = HMRATE(3.71E-18,0.24,26.1)*ATN;
	rate_COmole.CHP_S_SP_CH_2        = HMRATE((1e-10)*4.7,0,0)*ATS;
	rate_COmole.NP_CH2_CH2P_N_2      = HMRATE(1.0e-9,0,0)*CH2;
	rate_COmole.NP_CH4_CH4P_N_2      = HMRATE((1e-11)*2.8,0,0)*CH4;
	rate_COmole.NP_OH_OHP_N_2        = HMRATE((1e-10)*3.7,0,0)*OH;
	rate_COmole.NP_H2O_H2OP_N_2      = HMRATE((1e-9)*2.8,0,0)*H2O;
	rate_COmole.NP_O2_O2P_N_2        = HMRATE((1e-10)*3.11,0,0)*O2;
	rate_COmole.OP_O2_O2P_O_2        = HMRATE((1e-11)*1.9,0,0)*O2;
	rate_COmole.OHP_S_SP_OH_2        = HMRATE((1e-10)*4.3,0,0)*ATS;
	rate_COmole.H2OP_S_SP_H2O_2      = HMRATE((1e-10)*4.3,0,0)*ATS;
	rate_COmole.SI_SP_S_SIP_2        = HMRATE((1e-9)*1.6,0,0)*SP;
	rate_COmole.O2P_S_SP_O2_2        = HMRATE(5.4e-10,0,0)*ATS;


	rate_COmole.O_CCl_ClO_C_1 = HMRATE(0.000000000138,0,16050)*CCl;
	rate_COmole.O_ClO_Cl_O2_1 = HMRATE(0.000000000038,0,0)*ClO;
	rate_COmole.CP_HCl_CClP_H_1 = HMRATE(0.0000000011,0,0)*HCl;
	rate_COmole.CH3P_HCl_H2CClP_H2_1 = HMRATE(0.0000000013,0,0)*HCl;
	rate_COmole.H2O_H2ClP_HCl_H3OP_1 = HMRATE(0.000000002,0,0)*H2ClP;
	rate_COmole.CP_CCl_CClP_C_1 = HMRATE(0.000000001,0,0)*CCl;
	rate_COmole.CP_ClO_ClOP_C_1 = HMRATE(0.000000001,0,0)*ClO;
	rate_COmole.O2_ClP_Cl_O2P_1 = HMRATE(0.00000000046,0,0)*ClP;
	rate_COmole.O_CCl_ClO_C_2 = HMRATE(0.000000000138,0,16050)*ATO;
	rate_COmole.O_ClO_Cl_O2_2 = HMRATE(0.000000000038,0,0)*ATO;
	rate_COmole.CP_HCl_CClP_H_2 = HMRATE(0.0000000011,0,0)*CP;
	rate_COmole.CH3P_HCl_H2CClP_H2_2 = HMRATE(0.0000000013,0,0)*CH3P;
	rate_COmole.H2O_H2ClP_HCl_H3OP_2 = HMRATE(0.000000002,0,0)*H2O;
	rate_COmole.CP_CCl_CClP_C_2 = HMRATE(0.000000001,0,0)*CP;
	rate_COmole.CP_ClO_ClOP_C_2 = HMRATE(0.000000001,0,0)*CP;
	rate_COmole.O2_ClP_Cl_O2P_2 = HMRATE(0.00000000046,0,0)*O2;

	rate_COmole.C_CH2_C2H_H_1 = HMRATE(0.00000000005,0.5,0)*ATC;
	rate_COmole.OP_C2H_COP_CH_1 = HMRATE(0.00000000046,0,0)*OP;
	rate_COmole.C2H_COP_HCOP_C2_1 = HMRATE(0.00000000039,0,0)*C2H;
	rate_COmole.C_CH2_C2H_H_2 = HMRATE(0.00000000005,0.5,0)*CH2;
	rate_COmole.OP_C2H_COP_CH_2 = HMRATE(0.00000000046,0,0)*C2H;
	rate_COmole.C2H_COP_HCOP_C2_2 = HMRATE(0.00000000039,0,0)*COP;
	rate_COmole.b_C_CH2_C2H_H = HMRATE(0.00000000005,0.5,0)*P_C_CH2;
	rate_COmole.b_OP_C2H_COP_CH = HMRATE(0.00000000046,0,0)*P_OP_C2H;
	rate_COmole.b_C2H_COP_HCOP_C2 = HMRATE(0.00000000039,0,0)*P_C2H_COP;

	/* This reaction was not in UMIST, but is in Zsargo et al. 2003 as an 
	important reaction in the equilibrium chemistry of CH */

	rate_COmole.CP_NH_CHP_N_1 = 5e-10*CP;
	rate_COmole.CP_NH_CHP_N_2 = 5e-10*NH;


	/* This turns on the diffuse cloud chemical rates from Tables 6 & 8 of
	>> refer Federman, S. R. & Zsargo, J. 2003, ApJ, 589, 319
	Without the "set rates federman" command, the default values are
	from UMIST */
	if(co.lgFederman)
	{
		rate_COmole.CP_CH_CHP_C_1 = HMRATE(1.5e-9,0,0)*CP;
		rate_COmole.CP_CH_CHP_C_2 = HMRATE(1.5e-9,0,0)*CH;
		rate_COmole.b_CP_CH_CHP_C = HMRATE(1.5e-9,0,0)*P_CP_CH;
		rate_COmole.CP_CH_C2P_H_2 = HMRATE(5.4e-10,0,0)*CP;
		rate_COmole.CP_CH_C2P_H_1 = HMRATE(5.4e-10,0,0)*CH;
		rate_COmole.b_CP_CH_C2P_H = HMRATE(5.4e-10,0,0)*P_CP_CH;
		rate_COmole.O_CH3P_HCOP_H2_1 = HMRATE(4.4e-10,0,0)*ATO;
		rate_COmole.O_CH3P_HCOP_H2_2 = HMRATE(4.4e-10,0,0)*CH3P;
		rate_COmole.b_O_CH3P_HCOP_H2 = HMRATE(4.4e-10,0,0)*P_O_CH3P;
		rate_COmole.N_C2_CN_C_1 = HMRATE((1e-11)*1.7,0.5,0)*C2;
		rate_COmole.N_C2_CN_C_2 = HMRATE((1e-11)*1.7,0.5,0)*ATN;
		rate_COmole.b_N_C2_CN_C = HMRATE((1e-11)*1.7,0.5,0)*P_N_C2;
		rate_COmole.CH_N_CN_H_1 = HMRATE((2e-11),0.5,0)*CH;
		rate_COmole.CH_N_CN_H_2 = HMRATE((2e-11),0.5,0)*ATN;
		rate_COmole.b_CH_N_CN_H = HMRATE((2e-11),0.5,0)*P_CH_N;
		rate_COmole.CP_NH_CNP_H_1 = HMRATE((1e-10)*5.0,0,0)*CP;
		rate_COmole.CP_NH_CNP_H_2 = HMRATE((1e-10)*5.0,0,0)*NH;
		rate_COmole.b_CP_NH_CNP_H = HMRATE((1e-10)*5.0,0,0)*P_CP_NH;

	}
	/* coupled reactions */
	rate_COmole.C_NH2_HNC_H_1 = HMRATE(0.0000000000326,-0.1,-9)*ATC;
	rate_COmole.C_NH2_HNC_H_2 = HMRATE(0.0000000000326,-0.1,-9)*NH2;
	rate_COmole.N_CH2_HNC_H_1 = HMRATE(0.0000000000789,0.17,0)*ATN;
	rate_COmole.N_CH2_HNC_H_2 = HMRATE(0.0000000000789,0.17,0)*CH2;
	rate_COmole.CHP_HNC_HCNHP_C_1 = HMRATE(0.0000000018,0,0)*CHP;
	rate_COmole.CHP_HNC_HCNHP_C_2 = HMRATE(0.0000000018,0,0)*HNC;
	rate_COmole.CH_HCNHP_HNC_CH2P_1 = HMRATE(0.000000000315,0,0)*CH;
	rate_COmole.CH_HCNHP_HNC_CH2P_2 = HMRATE(0.000000000315,0,0)*HCNHP;
	rate_COmole.CH2_HCNHP_HNC_CH3P_1 = HMRATE(0.000000000435,0,0)*CH2;
	rate_COmole.CH2_HCNHP_HNC_CH3P_2 = HMRATE(0.000000000435,0,0)*HCNHP;
	rate_COmole.NHP_HNC_HCNHP_N_1 = HMRATE(0.0000000018,0,0)*NHP;
	rate_COmole.NHP_HNC_HCNHP_N_2 = HMRATE(0.0000000018,0,0)*HNC;
	rate_COmole.NH2P_HNC_HCNHP_NH_1 = HMRATE(0.0000000012,0,0)*NH2P;
	rate_COmole.NH2P_HNC_HCNHP_NH_2 = HMRATE(0.0000000012,0,0)*HNC;
	rate_COmole.NH2_HCNHP_HNC_NH3P_1 = HMRATE(0.000000000445,0,0)*NH2;
	rate_COmole.NH2_HCNHP_HNC_NH3P_2 = HMRATE(0.000000000445,0,0)*HCNHP;
	rate_COmole.OHP_HNC_HCNHP_O_1 = HMRATE(0.0000000012,0,0)*OHP;
	rate_COmole.OHP_HNC_HCNHP_O_2 = HMRATE(0.0000000012,0,0)*HNC;
	rate_COmole.NH3_HCNHP_HNC_NH4P_1 = HMRATE(0.0000000011,0,0)*NH3;
	rate_COmole.NH3_HCNHP_HNC_NH4P_2 = HMRATE(0.0000000011,0,0)*HCNHP;
	rate_COmole.CH5P_HNC_HCNHP_CH4_1 = HMRATE(0.0000000012,0,0)*CH5P;
	rate_COmole.CH5P_HNC_HCNHP_CH4_2 = HMRATE(0.0000000012,0,0)*HNC;
	rate_COmole.H2OP_HNC_HCNHP_OH_1 = HMRATE(0.0000000011,0,0)*H2OP;
	rate_COmole.H2OP_HNC_HCNHP_OH_2 = HMRATE(0.0000000011,0,0)*HNC;
	rate_COmole.H3OP_HNC_HCNHP_H2O_1 = HMRATE(0.000000004,0,0)*H3OP;
	rate_COmole.H3OP_HNC_HCNHP_H2O_2 = HMRATE(0.000000004,0,0)*HNC;
	rate_COmole.HCNP_HNC_HCNHP_CN_1 = HMRATE(0.000000001,0,0)*HCNP;
	rate_COmole.HCNP_HNC_HCNHP_CN_2 = HMRATE(0.000000001,0,0)*HNC;
	rate_COmole.HNC_HNOP_NO_HCNHP_1 = HMRATE(0.00000000099,0,0)*HNC;
	rate_COmole.HNC_HNOP_NO_HCNHP_2 = HMRATE(0.00000000099,0,0)*HNOP;
	rate_COmole.HNC_HSP_S_HCNHP_1 = HMRATE(0.00000000086,0,0)*HNC;
	rate_COmole.HNC_HSP_S_HCNHP_2 = HMRATE(0.00000000086,0,0)*HSP;
	rate_COmole.CHP_HCN_HCNHP_C_1 = HMRATE(0.0000000018,0,0)*CHP;
	rate_COmole.CHP_HCN_HCNHP_C_2 = HMRATE(0.0000000018,0,0)*HCN;
	rate_COmole.CH_HCNHP_HCN_CH2P_1 = HMRATE(0.000000000315,0,0)*CH;
	rate_COmole.CH_HCNHP_HCN_CH2P_2 = HMRATE(0.000000000315,0,0)*HCNHP;
	rate_COmole.NP_CH4_HCNHP_H_H_1 = HMRATE(0.00000000038,0,0)*NP;
	rate_COmole.NP_CH4_HCNHP_H_H_2 = HMRATE(0.00000000038,0,0)*CH4;
	rate_COmole.CH2_HCNHP_HCN_CH3P_1 = HMRATE(0.000000000435,0,0)*CH2;
	rate_COmole.CH2_HCNHP_HCN_CH3P_2 = HMRATE(0.000000000435,0,0)*HCNHP;
	rate_COmole.NH_CH3P_HCNHP_H2_1 = HMRATE(0.00000000074,0,0)*NH;
	rate_COmole.NH_CH3P_HCNHP_H2_2 = HMRATE(0.00000000074,0,0)*CH3P;
	rate_COmole.NHP_HCN_HCNHP_N_1    = HMRATE(0.0000000018,0,0)*NHP;
	rate_COmole.NHP_HCN_HCNHP_N_2    = HMRATE(0.0000000018,0,0)*HCN;
	rate_COmole.NH2P_HCN_HCNHP_NH_1  =	HMRATE(0.0000000012,0,0)*NH2P;
	rate_COmole.NH2P_HCN_HCNHP_NH_2  =	HMRATE(0.0000000012,0,0)*HCN;
	rate_COmole.NH2_HCNHP_HCN_NH3P_1 =	HMRATE(0.000000000445,0,0)*NH2;
	rate_COmole.NH2_HCNHP_HCN_NH3P_2 =	HMRATE(0.000000000445,0,0)*HCNHP;
	rate_COmole.CH4_HCNP_HCNHP_CH3_1 =	HMRATE(0.00000000104,0,0)*CH4;
	rate_COmole.CH4_HCNP_HCNHP_CH3_2 =	HMRATE(0.00000000104,0,0)*HCNP;
	rate_COmole.OHP_HCN_HCNHP_O_1    =	HMRATE(0.0000000012,0,0)*OHP;
	rate_COmole.OHP_HCN_HCNHP_O_2    =	HMRATE(0.0000000012,0,0)*HCN;
	rate_COmole.NH3_HCNP_HCNHP_NH2_1 =	HMRATE(0.00000000084,0,0)*NH3;
	rate_COmole.NH3_HCNP_HCNHP_NH2_2 =	HMRATE(0.00000000084,0,0)*HCNP;
	rate_COmole.NH3_HCNHP_HCN_NH4P_1 =	HMRATE(0.0000000011,0,0)*NH3;
	rate_COmole.NH3_HCNHP_HCN_NH4P_2 =	HMRATE(0.0000000011,0,0)*HCNHP;
	rate_COmole.CH5P_HCN_HCNHP_CH4_1 =	HMRATE(0.0000000012,0,0)*CH5P;
	rate_COmole.CH5P_HCN_HCNHP_CH4_2 =	HMRATE(0.0000000012,0,0)*HCN;
	rate_COmole.H2OP_HCN_HCNHP_OH_1  =	HMRATE(0.0000000011,0,0)*H2OP;
	rate_COmole.H2OP_HCN_HCNHP_OH_2  =	HMRATE(0.0000000011,0,0)*HCN;
	rate_COmole.H3OP_HCN_HCNHP_H2O_1 =	HMRATE(0.000000004,0,0)*H3OP;
	rate_COmole.H3OP_HCN_HCNHP_H2O_2 =	HMRATE(0.000000004,0,0)*HCN;
	rate_COmole.HCNP_HCN_HCNHP_CN_1  =	HMRATE(0.0000000016,0,0)*HCNP;
	rate_COmole.HCNP_HCN_HCNHP_CN_2  =	HMRATE(0.0000000016,0,0)*HCN;
	rate_COmole.HCN_HNOP_NO_HCNHP_1  =	HMRATE(0.00000000099,0,0)*HCN;
	rate_COmole.HCN_HNOP_NO_HCNHP_2  =	HMRATE(0.00000000099,0,0)*HNOP;
	rate_COmole.HCN_HSP_S_HCNHP_1    =	HMRATE(0.00000000086,0,0)*HCN;
	rate_COmole.HCN_HSP_S_HCNHP_2    =	HMRATE(0.00000000086,0,0)*HSP;
	rate_COmole.C_CH2P_C2HP_H_1 = HMRATE(0.0000000012,0,0)*ATC;
	rate_COmole.C_CH2P_C2HP_H_2 = HMRATE(0.0000000012,0,0)*CH2P;
	rate_COmole.b_C_CH2P_C2HP_H = HMRATE(0.0000000012,0,0)*P_ATC_CH2P;
	rate_COmole.C_CH3P_C2HP_H2_1 = HMRATE(0.0000000012,0,0)*ATC;
	rate_COmole.C_CH3P_C2HP_H2_2 = HMRATE(0.0000000012,0,0)*CH3P;
	rate_COmole.b_C_CH3P_C2HP_H2 = HMRATE(0.0000000012,0,0)*P_C_CH3P;
	rate_COmole.C2_HCNP_CN_C2HP_1 = HMRATE(0.00000000084,0,0)*C2;
	rate_COmole.C2_HCNP_CN_C2HP_2 = HMRATE(0.00000000084,0,0)*HCNP;
	rate_COmole.b_C2_HCNP_CN_C2HP = HMRATE(0.00000000084,0,0)*P_C2_HCNP;
	rate_COmole.C2_HNOP_NO_C2HP_1 = HMRATE(0.00000000082,0,0)*C2;
	rate_COmole.C2_HNOP_NO_C2HP_2 = HMRATE(0.00000000082,0,0)*HNOP;
	rate_COmole.b_C2_HNOP_NO_C2HP = HMRATE(0.00000000082,0,0)*P_C2_HNOP;
	rate_COmole.C2H_CNP_CN_C2HP_1 = HMRATE(0.0000000008,0,0)*C2H;
	rate_COmole.C2H_CNP_CN_C2HP_2 = HMRATE(0.0000000008,0,0)*CNP;
	rate_COmole.b_C2H_CNP_CN_C2HP = HMRATE(0.0000000008,0,0)*P_C2H_CNP;
	rate_COmole.C2H_N2P_N2_C2HP_1 = HMRATE(0.00000000079,0,0)*C2H;
	rate_COmole.C2H_N2P_N2_C2HP_2 = HMRATE(0.00000000079,0,0)*N2P;
	rate_COmole.b_C2H_N2P_N2_C2HP = HMRATE(0.00000000079,0,0)*P_C2H_N2P;
	rate_COmole.C2HP_HCN_HCNHP_C2_1 = HMRATE(0.0000000014,0,0)*C2HP;
	rate_COmole.C2HP_HCN_HCNHP_C2_2 = HMRATE(0.0000000014,0,0)*HCN;
	rate_COmole.b_C2HP_HCN_HCNHP_C2 = HMRATE(0.0000000014,0,0)*P_C2HP_HCN;
	rate_COmole.C2HP_HNC_HCNHP_C2_1 = HMRATE(0.0000000014,0,0)*C2HP;
	rate_COmole.C2HP_HNC_HCNHP_C2_2 = HMRATE(0.0000000014,0,0)*HNC;
	rate_COmole.b_C2HP_HNC_HCNHP_C2 = HMRATE(0.0000000014,0,0)*P_C2HP_HNC;
	rate_COmole.C2HP_NO_NOP_C2H_1 = HMRATE(0.00000000012,0,0)*C2HP;
	rate_COmole.C2HP_NO_NOP_C2H_2 = HMRATE(0.00000000012,0,0)*NO;
	rate_COmole.b_C2HP_NO_NOP_C2H = HMRATE(0.00000000012,0,0)*P_C2HP_NO;
	rate_COmole.C2HP_S_SP_C2H_1 = HMRATE(0.0000000012,0,0)*C2HP;
	rate_COmole.C2HP_S_SP_C2H_2 = HMRATE(0.0000000012,0,0)*ATS;
	rate_COmole.b_C2HP_S_SP_C2H = HMRATE(0.0000000012,0,0)*P_C2HP_S;
	rate_COmole.CH_C2HP_C2_CH2P_1 = HMRATE(0.00000000032,0,0)*CH;
	rate_COmole.CH_C2HP_C2_CH2P_2 = HMRATE(0.00000000032,0,0)*C2HP;
	rate_COmole.b_CH_C2HP_C2_CH2P = HMRATE(0.00000000032,0,0)*P_CH_C2HP;
	rate_COmole.CH2_C2HP_C2_CH3P_1 = HMRATE(0.00000000044,0,0)*CH2;
	rate_COmole.CH2_C2HP_C2_CH3P_2 = HMRATE(0.00000000044,0,0)*C2HP;
	rate_COmole.b_CH2_C2HP_C2_CH3P = HMRATE(0.00000000044,0,0)*P_CH2_C2HP;
	rate_COmole.CH4_C2P_C2HP_CH3_1 = HMRATE(0.000000000238,0,0)*CH4;
	rate_COmole.CH4_C2P_C2HP_CH3_2 = HMRATE(0.000000000238,0,0)*C2P;
	rate_COmole.b_CH4_C2P_C2HP_CH3 = HMRATE(0.000000000238,0,0)*P_CH4_C2P;
	rate_COmole.CH5P_C2_C2HP_CH4_1 = HMRATE(0.00000000095,0,0)*CH5P;
	rate_COmole.CH5P_C2_C2HP_CH4_2 = HMRATE(0.00000000095,0,0)*C2;
	rate_COmole.b_CH5P_C2_C2HP_CH4 = HMRATE(0.00000000095,0,0)*P_CH5P_C2;
	rate_COmole.CHP_CH2_C2HP_H2_1 = HMRATE(0.000000001,0,0)*CHP;
	rate_COmole.CHP_CH2_C2HP_H2_2 = HMRATE(0.000000001,0,0)*CH2;
	rate_COmole.b_CHP_CH2_C2HP_H2 = HMRATE(0.000000001,0,0)*P_CHP_CH2;
	/* The rate for this reaction is taken from Eric Herbst website */
	rate_COmole.CP_CH2_C2HP_H_1 = HMRATE(0.000000000434,-0.5,0)*CP;
	rate_COmole.CP_CH2_C2HP_H_2 = HMRATE(0.000000000434,-0.5,0)*CH2;
	rate_COmole.b_CP_CH2_C2HP_H = HMRATE(0.000000000434,-0.5,0)*P_CP_CH2;
	rate_COmole.CP_CH3_C2HP_H2_1 = HMRATE(0.000000001,0,0)*CP;
	rate_COmole.CP_CH3_C2HP_H2_2 = HMRATE(0.000000001,0,0)*CH3;
	rate_COmole.b_CP_CH3_C2HP_H2 = HMRATE(0.000000001,0,0)*P_CP_CH3;
	rate_COmole.H2O_C2P_C2HP_OH_1 = HMRATE(0.00000000044,0,0)*H2O;
	rate_COmole.H2O_C2P_C2HP_OH_2 = HMRATE(0.00000000044,0,0)*C2P;
	rate_COmole.b_H2O_C2P_C2HP_OH = HMRATE(0.00000000044,0,0)*P_H2O_C2P;
	rate_COmole.H2OP_C2_C2HP_OH_1 = HMRATE(0.00000000047,0,0)*H2OP;
	rate_COmole.H2OP_C2_C2HP_OH_2 = HMRATE(0.00000000047,0,0)*C2;
	rate_COmole.b_H2OP_C2_C2HP_OH = HMRATE(0.00000000047,0,0)*P_H2OP_C2;
	rate_COmole.H2OP_C2H_C2HP_H2O_1 = HMRATE(0.00000000044,0,0)*H2OP;
	rate_COmole.H2OP_C2H_C2HP_H2O_2 = HMRATE(0.00000000044,0,0)*C2H;
	rate_COmole.b_H2OP_C2H_C2HP_H2O = HMRATE(0.00000000044,0,0)*P_H2OP_C2H;
	rate_COmole.H3OP_C2_C2HP_H2O_1 = HMRATE(0.00000000092,0,0)*H3OP;
	rate_COmole.H3OP_C2_C2HP_H2O_2 = HMRATE(0.00000000092,0,0)*C2;
	rate_COmole.b_H3OP_C2_C2HP_H2O = HMRATE(0.00000000092,0,0)*P_H3OP_C2;
	rate_COmole.N_C2HP_CN_CHP_1 = HMRATE(0.00000000009,0,0)*ATN;
	rate_COmole.N_C2HP_CN_CHP_2 = HMRATE(0.00000000009,0,0)*C2HP;
	rate_COmole.b_N_C2HP_CN_CHP = HMRATE(0.00000000009,0,0)*P_N_C2HP;
	rate_COmole.NH_C2P_C2HP_N_1 = HMRATE(0.00000000033,0,0)*NH;
	rate_COmole.NH_C2P_C2HP_N_2 = HMRATE(0.00000000033,0,0)*C2P;
	rate_COmole.b_NH_C2P_C2HP_N = HMRATE(0.00000000033,0,0)*P_NH_C2P;
	rate_COmole.NH2_C2HP_C2_NH3P_1 = HMRATE(0.00000000046,0,0)*NH2;
	rate_COmole.NH2_C2HP_C2_NH3P_2 = HMRATE(0.00000000046,0,0)*C2HP;
	rate_COmole.b_NH2_C2HP_C2_NH3P = HMRATE(0.00000000046,0,0)*P_NH2_C2HP;
	rate_COmole.NH2P_C2_C2HP_NH_1 = HMRATE(0.00000000097,0,0)*NH2P;
	rate_COmole.NH2P_C2_C2HP_NH_2 = HMRATE(0.00000000097,0,0)*C2;
	rate_COmole.b_NH2P_C2_C2HP_NH = HMRATE(0.00000000097,0,0)*P_NH2P_C2;
	rate_COmole.NH3_C2HP_C2_NH4P_1 = HMRATE(0.00000000055,0,0)*NH3;
	rate_COmole.NH3_C2HP_C2_NH4P_2 = HMRATE(0.00000000055,0,0)*C2HP;
	rate_COmole.b_NH3_C2HP_C2_NH4P = HMRATE(0.00000000055,0,0)*P_NH3_C2HP;
	rate_COmole.NHP_C2_C2HP_N_1 = HMRATE(0.00000000049,0,0)*NHP;
	rate_COmole.NHP_C2_C2HP_N_2 = HMRATE(0.00000000049,0,0)*C2;
	rate_COmole.b_NHP_C2_C2HP_N = HMRATE(0.00000000049,0,0)*P_NHP_C2;
	rate_COmole.NP_C2H_C2HP_N_1 = HMRATE(0.00000000095,0,0)*NP;
	rate_COmole.NP_C2H_C2HP_N_2 = HMRATE(0.00000000095,0,0)*C2H;
	rate_COmole.b_NP_C2H_C2HP_N = HMRATE(0.00000000095,0,0)*P_NP_C2H;
	rate_COmole.O_C2HP_HCOP_C_1 = HMRATE(0.00000000033,0,0)*ATO;
	rate_COmole.O_C2HP_HCOP_C_2 = HMRATE(0.00000000033,0,0)*C2HP;
	rate_COmole.b_O_C2HP_HCOP_C = HMRATE(0.00000000033,0,0)*P_O_C2HP;
	rate_COmole.OHP_C2_C2HP_O_1 = HMRATE(0.00000000048,0,0)*OHP;
	rate_COmole.OHP_C2_C2HP_O_2 = HMRATE(0.00000000048,0,0)*C2;
	rate_COmole.b_OHP_C2_C2HP_O = HMRATE(0.00000000048,0,0)*P_OHP_C2;
	rate_COmole.OHP_C2H_C2HP_OH_1 = HMRATE(0.00000000045,0,0)*OHP;
	rate_COmole.OHP_C2H_C2HP_OH_2 = HMRATE(0.00000000045,0,0)*C2H;
	rate_COmole.b_OHP_C2H_C2HP_OH = HMRATE(0.00000000045,0,0)*P_OHP_C2H;
	rate_COmole.OP_C2H_C2HP_O_1 = HMRATE(0.00000000046,0,0)*OP;
	rate_COmole.OP_C2H_C2HP_O_2 = HMRATE(0.00000000046,0,0)*C2H;
	rate_COmole.b_OP_C2H_C2HP_O = HMRATE(0.00000000046,0,0)*P_OP_C2H;
	rate_COmole.CP_C2H_C3P_H_1 = HMRATE(0.000000001,0,0)*CP;
	rate_COmole.CP_C2H_C3P_H_2 = HMRATE(0.000000001,0,0)*C2H;
	rate_COmole.b_CP_C2H_C3P_H = HMRATE(0.000000001,0,0)*P_CP_C2H;
	rate_COmole.CHP_C2H_C3P_H2_1 = HMRATE(0.00000000098,0,0)*CHP;
	rate_COmole.CHP_C2H_C3P_H2_2 = HMRATE(0.00000000098,0,0)*C2H;
	rate_COmole.b_CHP_C2H_C3P_H2 = HMRATE(0.00000000098,0,0)*P_CHP_C2H;
	rate_COmole.C2P_C2_C3P_C_1 = HMRATE(0.00000000087,0,0)*C2P;
	rate_COmole.C2P_C2_C3P_C_2 = HMRATE(0.00000000087,0,0)*C2;
	rate_COmole.b_C2P_C2_C3P_C = HMRATE(0.00000000087,0,0)*P_C2P_C2;
	rate_COmole.CHP_C2_C3P_H_1 = HMRATE(0.000000001,0,0)*CHP;
	rate_COmole.CHP_C2_C3P_H_2 = HMRATE(0.000000001,0,0)*C2;
	rate_COmole.b_CHP_C2_C3P_H = HMRATE(0.000000001,0,0)*P_CHP_C2;
	rate_COmole.CH_C2P_C3P_H_1 = HMRATE(0.00000000032,0,0)*CH;
	rate_COmole.CH_C2P_C3P_H_2 = HMRATE(0.00000000032,0,0)*C2P;
	rate_COmole.b_CH_C2P_C3P_H = HMRATE(0.00000000032,0,0)*P_CH_C2P;
	rate_COmole.C_C2HP_C3P_H_1 = HMRATE(0.0000000011,0,0)*ATC;
	rate_COmole.C_C2HP_C3P_H_2 = HMRATE(0.0000000011,0,0)*C2HP;
	rate_COmole.b_C_C2HP_C3P_H = HMRATE(0.0000000011,0,0)*P_C_C2HP;

	rate_COmole.b_C_C2H2P_C3HP_H = HMRATE(0.0000000011,0,0)*P_C_C2H2P;
	rate_COmole.b_C_C2H2_C3H_H = HMRATE(0.0000000002,0,0)*P_C_C2H2;
	rate_COmole.b_C2H_HCNP_C2H2P_CN = HMRATE(0.00000000079,0,0)*P_C2H_HCNP;
	rate_COmole.b_C2H2P_HCN_HCNHP_C2H = HMRATE(0.00000000023,0,0)*P_C2H2P_HCN;
	rate_COmole.b_C2H2P_NO_NOP_C2H2 = HMRATE(0.00000000012,0,0)*P_C2H2P_NO;
	rate_COmole.b_C2HP_HCN_C2H2P_CN = HMRATE(0.0000000014,0,0)*P_C2HP_HCN;
	rate_COmole.b_CH_C2HP_C3HP_H = HMRATE(0.00000000032,0,0)*P_CH_C2HP;
	rate_COmole.b_CH_CH3P_C2H2P_H2 = HMRATE(0.00000000071,0,0)*P_CH_CH3P;
	rate_COmole.b_CH2_C2P_C3HP_H = HMRATE(0.00000000045,0,0)*P_CH2_C2P;
	rate_COmole.b_CH2_CH2_C2H2_H_H = HMRATE(0.00000000018,0,400)*P_CH2_CH2;
	rate_COmole.b_CH2_CH2_C2H2_H2 = HMRATE(0.00000000263,0,6013)*P_CH2_CH2;
	rate_COmole.b_CH3P_C2_C3HP_H2 = HMRATE(0.00000000099,0,0)*P_CH3P_C2;
	rate_COmole.b_CH4_C2HP_C2H2P_CH3 = HMRATE(0.000000000374,0,0)*P_CH4_C2HP;
	rate_COmole.b_CH4_C2P_C2H2P_CH2 = HMRATE(0.000000000182,0,0)*P_CH4_C2P;
	rate_COmole.b_CH4_C2P_C3HP_H2_H = HMRATE(0.000000000196,0,0)*P_CH4_C2P;
	rate_COmole.b_CH4P_C2H2_C2H2P_CH4 = HMRATE(0.00000000113,0,0)*P_CH4P_C2H2;
	rate_COmole.b_CH5P_C2H_C2H2P_CH4 = HMRATE(0.0000000009,0,0)*P_CH5P_C2H;
	rate_COmole.b_CHP_CH4_C2H2P_H2_H = HMRATE(0.000000000143,0,0)*P_CHP_CH4;
	rate_COmole.b_CP_C2H2_C3HP_H = HMRATE(0.0000000022,0,0)*P_CP_C2H2;
	rate_COmole.b_CP_CH3_C2H2P_H = HMRATE(0.0000000013,0,0)*P_CP_CH3;
	rate_COmole.b_CP_CH4_C2H2P_H2 = HMRATE(0.0000000004,0,0)*P_CP_CH4;
	rate_COmole.b_H2O_C2H2P_C2H_H3OP = HMRATE(0.00000000022,0,0)*P_H2O_C2H2P;
	rate_COmole.b_H2O_C3HP_HCOP_C2H2 = HMRATE(0.00000000027,0,0)*P_H2O_C3HP;
	rate_COmole.b_H2OP_C2H_C2H2P_OH = HMRATE(0.00000000044,0,0)*P_H2OP_C2H;
	rate_COmole.b_H2OP_C2H2_C2H2P_H2O = HMRATE(0.0000000019,0,0)*P_H2OP_C2H2;
	rate_COmole.b_H3OP_C3_C3HP_H2O = HMRATE(0.000000002,0,0)*P_H3OP_C3;
	rate_COmole.b_N_C2H2P_HCN_CHP = HMRATE(0.000000000025,0,0)*P_N_C2H2P;
	rate_COmole.b_NH2_C2H2P_C2H_NH3P = HMRATE(0.00000000045,0,0)*P_NH2_C2H2P;
	rate_COmole.b_NH2P_C2H_C2H2P_NH = HMRATE(0.00000000091,0,0)*P_NH2P_C2H;
	rate_COmole.b_NH3_C2H2P_C2H_NH4P = HMRATE(0.0000000011,0,0)*P_NH3_C2H2P;
	rate_COmole.b_NH3_C2H2P_C2H2_NH3P = HMRATE(0.0000000021,0,0)*P_NH3_C2H2P;
	rate_COmole.b_NH3_C3HP_C3_NH4P = HMRATE(0.0000000008,0,0)*P_NH3_C3HP;
	rate_COmole.b_NH3_C3HP_C3H_NH3P = HMRATE(0.00000000032,0,0)*P_NH3_C3HP;
	rate_COmole.b_NH3P_C2_C2H2P_NH = HMRATE(0.00000000001,0,0)*P_NH3P_C2;
	rate_COmole.b_NHP_C2H_C2H2P_N = HMRATE(0.0000000014,0,0)*P_NHP_C2H;
	rate_COmole.b_NO_C3HP_C3H_NOP = HMRATE(0.00000000013,0,0)*P_NO_C3HP;
	rate_COmole.b_O_C2H2_C2H_OH = HMRATE(0.0000000053,0,8520)*P_O_C2H2;
	rate_COmole.b_O_C2H2P_HCOP_CH = HMRATE(0.000000000085,0,0)*P_O_C2H2P;
	rate_COmole.b_OH_C2H2_C2H_H2O = HMRATE(0.000000000000105,2.68,6060)*P_OH_C2H2;
	rate_COmole.b_OHP_C2H_C2H2P_O = HMRATE(0.00000000045,0,0)*P_OHP_C2H;
	rate_COmole.b_OP_C2H2_C2H2P_O = HMRATE(0.000000000039,0,0)*P_OP_C2H2;
	
	rate_COmole.C_C2H2_C3H_H_1 = HMRATE(0.0000000002,0,0)*ATC;
	rate_COmole.C_C2H2_C3H_H_2 = HMRATE(0.0000000002,0,0)*C2H2;
	rate_COmole.C_C2H2P_C3HP_H_1 = HMRATE(0.0000000011,0,0)*ATC;
	rate_COmole.C_C2H2P_C3HP_H_2 = HMRATE(0.0000000011,0,0)*C2H2P;
	rate_COmole.C2H_HCNP_C2H2P_CN_1 = HMRATE(0.00000000079,0,0)*C2H;
	rate_COmole.C2H_HCNP_C2H2P_CN_2 = HMRATE(0.00000000079,0,0)*HCNP;
	rate_COmole.C2H2P_HCN_HCNHP_C2H_1 = HMRATE(0.00000000023,0,0)*C2H2P;
	rate_COmole.C2H2P_HCN_HCNHP_C2H_2 = HMRATE(0.00000000023,0,0)*HCN;
	rate_COmole.C2H2P_NO_NOP_C2H2_1 = HMRATE(0.00000000012,0,0)*C2H2P;
	rate_COmole.C2H2P_NO_NOP_C2H2_2 = HMRATE(0.00000000012,0,0)*NO;
	rate_COmole.C2HP_HCN_C2H2P_CN_1 = HMRATE(0.0000000014,0,0)*C2HP;
	rate_COmole.C2HP_HCN_C2H2P_CN_2 = HMRATE(0.0000000014,0,0)*HCN;
	rate_COmole.CH_C2HP_C3HP_H_1 = HMRATE(0.00000000032,0,0)*CH;
	rate_COmole.CH_C2HP_C3HP_H_2 = HMRATE(0.00000000032,0,0)*C2HP;
	rate_COmole.CH_CH3P_C2H2P_H2_1 = HMRATE(0.00000000071,0,0)*CH;
	rate_COmole.CH_CH3P_C2H2P_H2_2 = HMRATE(0.00000000071,0,0)*CH3P;
	rate_COmole.CH2_C2P_C3HP_H_1 = HMRATE(0.00000000045,0,0)*CH2;
	rate_COmole.CH2_C2P_C3HP_H_2 = HMRATE(0.00000000045,0,0)*C2P;
	rate_COmole.CH2_CH2_C2H2_H_H_1 = HMRATE(0.00000000018,0,400)*CH2;
	rate_COmole.CH2_CH2_C2H2_H_H_2 = HMRATE(0.00000000018,0,400)*CH2;
	rate_COmole.CH2_CH2_C2H2_H2_1 = HMRATE(0.00000000263,0,6013)*CH2;
	rate_COmole.CH2_CH2_C2H2_H2_2 = HMRATE(0.00000000263,0,6013)*CH2;
	rate_COmole.CH3P_C2_C3HP_H2_1 = HMRATE(0.00000000099,0,0)*CH3P;
	rate_COmole.CH3P_C2_C3HP_H2_2 = HMRATE(0.00000000099,0,0)*C2;
	rate_COmole.CH4_C2HP_C2H2P_CH3_1 = HMRATE(0.000000000374,0,0)*CH4;
	rate_COmole.CH4_C2HP_C2H2P_CH3_2 = HMRATE(0.000000000374,0,0)*C2HP;
	rate_COmole.CH4_C2P_C2H2P_CH2_1 = HMRATE(0.000000000182,0,0)*CH4;
	rate_COmole.CH4_C2P_C2H2P_CH2_2 = HMRATE(0.000000000182,0,0)*C2P;
	rate_COmole.CH4_C2P_C3HP_H2_H_1 = HMRATE(0.000000000196,0,0)*CH4;
	rate_COmole.CH4_C2P_C3HP_H2_H_2 = HMRATE(0.000000000196,0,0)*C2P;
	rate_COmole.CH4P_C2H2_C2H2P_CH4_1 = HMRATE(0.00000000113,0,0)*CH4P;
	rate_COmole.CH4P_C2H2_C2H2P_CH4_2 = HMRATE(0.00000000113,0,0)*C2H2;
	rate_COmole.CH5P_C2H_C2H2P_CH4_1 = HMRATE(0.0000000009,0,0)*CH5P;
	rate_COmole.CH5P_C2H_C2H2P_CH4_2 = HMRATE(0.0000000009,0,0)*C2H;
	rate_COmole.CHP_CH4_C2H2P_H2_H_1 = HMRATE(0.000000000143,0,0)*CHP;
	rate_COmole.CHP_CH4_C2H2P_H2_H_2 = HMRATE(0.000000000143,0,0)*CH4;
	rate_COmole.CP_C2H2_C3HP_H_1 = HMRATE(0.0000000022,0,0)*CP;
	rate_COmole.CP_C2H2_C3HP_H_2 = HMRATE(0.0000000022,0,0)*C2H2;
	rate_COmole.CP_CH3_C2H2P_H_1 = HMRATE(0.0000000013,0,0)*CP;
	rate_COmole.CP_CH3_C2H2P_H_2 = HMRATE(0.0000000013,0,0)*CH3;
	rate_COmole.CP_CH4_C2H2P_H2_1 = HMRATE(0.0000000004,0,0)*CP;
	rate_COmole.CP_CH4_C2H2P_H2_2 = HMRATE(0.0000000004,0,0)*CH4;
	rate_COmole.H2O_C2H2P_C2H_H3OP_1 = HMRATE(0.00000000022,0,0)*H2O;
	rate_COmole.H2O_C2H2P_C2H_H3OP_2 = HMRATE(0.00000000022,0,0)*C2H2P;
	rate_COmole.H2O_C3HP_HCOP_C2H2_1 = HMRATE(0.00000000027,0,0)*H2O;
	rate_COmole.H2O_C3HP_HCOP_C2H2_2 = HMRATE(0.00000000027,0,0)*C3HP;
	rate_COmole.H2OP_C2H_C2H2P_OH_1 = HMRATE(0.00000000044,0,0)*H2OP;
	rate_COmole.H2OP_C2H_C2H2P_OH_2 = HMRATE(0.00000000044,0,0)*C2H;
	rate_COmole.H2OP_C2H2_C2H2P_H2O_1 = HMRATE(0.0000000019,0,0)*H2OP;
	rate_COmole.H2OP_C2H2_C2H2P_H2O_2 = HMRATE(0.0000000019,0,0)*C2H2;
	rate_COmole.H3OP_C3_C3HP_H2O_1 = HMRATE(0.000000002,0,0)*H3OP;
	rate_COmole.H3OP_C3_C3HP_H2O_2 = HMRATE(0.000000002,0,0)*C3;
	rate_COmole.N_C2H2P_HCN_CHP_1 = HMRATE(0.000000000025,0,0)*ATN;
	rate_COmole.N_C2H2P_HCN_CHP_2 = HMRATE(0.000000000025,0,0)*C2H2P;
	rate_COmole.NH2_C2H2P_C2H_NH3P_1 = HMRATE(0.00000000045,0,0)*NH2;
	rate_COmole.NH2_C2H2P_C2H_NH3P_2 = HMRATE(0.00000000045,0,0)*C2H2P;
	rate_COmole.NH2P_C2H_C2H2P_NH_1 = HMRATE(0.00000000091,0,0)*NH2P;
	rate_COmole.NH2P_C2H_C2H2P_NH_2 = HMRATE(0.00000000091,0,0)*C2H;
	rate_COmole.NH3_C2H2P_C2H_NH4P_1 = HMRATE(0.0000000011,0,0)*NH3;
	rate_COmole.NH3_C2H2P_C2H_NH4P_2 = HMRATE(0.0000000011,0,0)*C2H2P;
	rate_COmole.NH3_C2H2P_C2H2_NH3P_1 = HMRATE(0.0000000021,0,0)*NH3;
	rate_COmole.NH3_C2H2P_C2H2_NH3P_2 = HMRATE(0.0000000021,0,0)*C2H2P;
	rate_COmole.NH3_C3HP_C3_NH4P_1 = HMRATE(0.0000000008,0,0)*NH3;
	rate_COmole.NH3_C3HP_C3_NH4P_2 = HMRATE(0.0000000008,0,0)*C3HP;
	rate_COmole.NH3_C3HP_C3H_NH3P_1 = HMRATE(0.00000000032,0,0)*NH3;
	rate_COmole.NH3_C3HP_C3H_NH3P_2 = HMRATE(0.00000000032,0,0)*C3HP;
	rate_COmole.NH3P_C2_C2H2P_NH_1 = HMRATE(0.00000000001,0,0)*NH3P;
	rate_COmole.NH3P_C2_C2H2P_NH_2 = HMRATE(0.00000000001,0,0)*C2;
	rate_COmole.NHP_C2H_C2H2P_N_1 = HMRATE(0.0000000014,0,0)*NHP;
	rate_COmole.NHP_C2H_C2H2P_N_2 = HMRATE(0.0000000014,0,0)*C2H;
	rate_COmole.NO_C3HP_C3H_NOP_1 = HMRATE(0.00000000013,0,0)*NO;
	rate_COmole.NO_C3HP_C3H_NOP_2 = HMRATE(0.00000000013,0,0)*C3HP;
	rate_COmole.O_C2H2_C2H_OH_1 = HMRATE(0.0000000053,0,8520)*ATO;
	rate_COmole.O_C2H2_C2H_OH_2 = HMRATE(0.0000000053,0,8520)*C2H2;
	rate_COmole.O_C2H2P_HCOP_CH_1 = HMRATE(0.000000000085,0,0)*ATO;
	rate_COmole.O_C2H2P_HCOP_CH_2 = HMRATE(0.000000000085,0,0)*C2H2P;
	rate_COmole.OH_C2H2_C2H_H2O_1 = HMRATE(0.000000000000105,2.68,6060)*OH;
	rate_COmole.OH_C2H2_C2H_H2O_2 = HMRATE(0.000000000000105,2.68,6060)*C2H2;
	rate_COmole.OHP_C2H_C2H2P_O_1 = HMRATE(0.00000000045,0,0)*OHP;
	rate_COmole.OHP_C2H_C2H2P_O_2 = HMRATE(0.00000000045,0,0)*C2H;
	rate_COmole.OP_C2H2_C2H2P_O_1 = HMRATE(0.000000000039,0,0)*OP;
	rate_COmole.OP_C2H2_C2H2P_O_2 = HMRATE(0.000000000039,0,0)*C2H2;
	rate_COmole.b_C_C2H3P_C3HP_H2 = HMRATE(0.000000001,0,0)*P_C_C2H3P;
	rate_COmole.b_C2H_C2H3P_C2H2P_C2H2 = HMRATE(0.00000000033,0,0)*P_C2H_C2H3P;
	rate_COmole.b_CH2_CH3P_C2H3P_H2 = HMRATE(0.00000000099,0,0)*P_CH2_CH3P;
	rate_COmole.b_CH4_C3HP_C2H3P_C2H2 = HMRATE(0.000000000612,0,0)*P_CH4_C3HP;
	rate_COmole.b_CH4_HCNP_C2H3P_NH2 = HMRATE(0.00000000026,0,0)*P_CH4_HCNP;
	rate_COmole.b_CH4P_C2H2_C2H3P_CH3 = HMRATE(0.00000000125,0,0)*P_CH4P_C2H2;
	rate_COmole.b_CH5P_C2H2_C2H3P_CH4 = HMRATE(0.0000000016,0,0)*P_CH5P_C2H2;
	rate_COmole.b_CHP_CH4_C2H3P_H2 = HMRATE(0.00000000109,0,0)*P_CHP_CH4;
	rate_COmole.b_CP_CH4_C2H3P_H = HMRATE(0.0000000011,0,0)*P_CP_CH4;
	rate_COmole.b_H2O_C2H3P_C2H2_H3OP = HMRATE(0.00000000111,0,0)*P_H2O_C2H3P;
	rate_COmole.b_HCN_C2H3P_HCNHP_C2H2 = HMRATE(0.0000000029,0,0)*P_HCN_C2H3P;
	rate_COmole.b_HNC_C2H3P_HCNHP_C2H2 = HMRATE(0.0000000029,0,0)*P_HNC_C2H3P;
	rate_COmole.b_NH3_C2H3P_C2H2_NH4P = HMRATE(0.0000000025,0,0)*P_NH3_C2H3P;
	rate_COmole.b_O_C2H3P_HCOP_CH2 = HMRATE(0.0000000001,0,0)*P_O_C2H3P;
	rate_COmole.C_C2H3P_C3HP_H2_1 = HMRATE(0.000000001,0,0)*ATC;
	rate_COmole.C_C2H3P_C3HP_H2_2 = HMRATE(0.000000001,0,0)*C2H3P;
	rate_COmole.C2H_C2H3P_C2H2P_C2H2_1 = HMRATE(0.00000000033,0,0)*C2H;
	rate_COmole.C2H_C2H3P_C2H2P_C2H2_2 = HMRATE(0.00000000033,0,0)*C2H3P;
	rate_COmole.CH2_CH3P_C2H3P_H2_1 = HMRATE(0.00000000099,0,0)*CH2;
	rate_COmole.CH2_CH3P_C2H3P_H2_2 = HMRATE(0.00000000099,0,0)*CH3P;
	rate_COmole.CH4_C3HP_C2H3P_C2H2_1 = HMRATE(0.000000000612,0,0)*CH4;
	rate_COmole.CH4_C3HP_C2H3P_C2H2_2 = HMRATE(0.000000000612,0,0)*C3HP;
	rate_COmole.CH4_HCNP_C2H3P_NH2_1 = HMRATE(0.00000000026,0,0)*CH4;
	rate_COmole.CH4_HCNP_C2H3P_NH2_2 = HMRATE(0.00000000026,0,0)*HCNP;
	rate_COmole.CH4P_C2H2_C2H3P_CH3_1 = HMRATE(0.00000000125,0,0)*CH4P;
	rate_COmole.CH4P_C2H2_C2H3P_CH3_2 = HMRATE(0.00000000125,0,0)*C2H2;
	rate_COmole.CH5P_C2H2_C2H3P_CH4_1 = HMRATE(0.0000000016,0,0)*CH5P;
	rate_COmole.CH5P_C2H2_C2H3P_CH4_2 = HMRATE(0.0000000016,0,0)*C2H2;
	rate_COmole.CHP_CH4_C2H3P_H2_1 = HMRATE(0.00000000109,0,0)*CHP;
	rate_COmole.CHP_CH4_C2H3P_H2_2 = HMRATE(0.00000000109,0,0)*CH4;
	rate_COmole.CP_CH4_C2H3P_H_1 = HMRATE(0.0000000011,0,0)*CP;
	rate_COmole.CP_CH4_C2H3P_H_2 = HMRATE(0.0000000011,0,0)*CH4;
	rate_COmole.H2O_C2H3P_C2H2_H3OP_1 = HMRATE(0.00000000111,0,0)*H2O;
	rate_COmole.H2O_C2H3P_C2H2_H3OP_2 = HMRATE(0.00000000111,0,0)*C2H3P;
	rate_COmole.HCN_C2H3P_HCNHP_C2H2_1 = HMRATE(0.0000000029,0,0)*HCN;
	rate_COmole.HCN_C2H3P_HCNHP_C2H2_2 = HMRATE(0.0000000029,0,0)*C2H3P;
	rate_COmole.HNC_C2H3P_HCNHP_C2H2_1 = HMRATE(0.0000000029,0,0)*HNC;
	rate_COmole.HNC_C2H3P_HCNHP_C2H2_2 = HMRATE(0.0000000029,0,0)*C2H3P;
	rate_COmole.NH3_C2H3P_C2H2_NH4P_1 = HMRATE(0.0000000025,0,0)*NH3;
	rate_COmole.NH3_C2H3P_C2H2_NH4P_2 = HMRATE(0.0000000025,0,0)*C2H3P;
	rate_COmole.O_C2H3P_HCOP_CH2_1 = HMRATE(0.0000000001,0,0)*ATO;
	rate_COmole.O_C2H3P_HCOP_CH2_2 = HMRATE(0.0000000001,0,0)*C2H3P;

}

