/* This file is part of Cloudy and is copyright (C)1978-2006 by Gary J. Ferland
 * For conditions of distribution and use see copyright notice in license.txt */
/*CO_Init called from cdInit to initialized co routines */
/*CO_update_chem_rates update rate coefficients, only temp part - in mole_co_etc.c */
#include "cddefines.h"
#include "phycon.h"
#include "mole.h"
/*lint -e778 constant expression evaluatess to 0 in operation '-' */
/*lint -e777 test floats for equal */

/*CO_update_chem_rates update rate coefficients, only temp part - in mole_co_etc.c 
 * called in conv_base before any chemistry or ionization is done */
void CO_update_chem_rates( void )
{

	static int lgMustInit=TRUE;
	static double TeEval=-1;

#	ifdef DEBUG_FUN
	fputs( "<+>CO_Init()\n", debug_fp );
#	endif

	/* this branch only evaluated one time */
	if( lgMustInit )
	{
		lgMustInit = FALSE;
		/* all constant rate coefficients go here */
		/* >>chng 06 Feb 28 -- NPA.  Charge transfer between S+, Si+, and C+ and Mg/Fe is 
		 * sometimes important in molecular abundance determinations.  We therefore include them here.  Someday, we may need to 
		 * include Mg and Fe in the molecular network, but for now include the reaction in the existing heavy element
		 * network */

		/* define rates */

		rate_COmole.SP_MG_S_MGP = 2.8e-10;
		rate_COmole.SIP_MG_SI_MGP =2.9e-10; 
		rate_COmole.CP_MG_C_MGP = 1.1e-9;
		rate_COmole.SP_FE_S_FEP = 1.8e-10;
		rate_COmole.SIP_FE_SI_FEP =1.9e-10; 
		rate_COmole.CP_FE_C_FEP = 2.6e-9;
	}

	/* this is the temperature dependent branch */
	if( TeEval != phycon.te )
	{
		TeEval = phycon.te;
		/* all temp dependent rate coefficients go here */

		/* >>chng 06 Feb 27 -- NPA  TH85 has a temperature barrier for this reaction, and
		 * the Meudon PDR code datafile does as well.  Use the temperature barrier of 2200 K
		rate_COmole.H_CH_C_H2			    = HMRATE((1e-11)*2.7,0.38,0)*HI;*/
		rate_COmole.H_CH_C_H2			    = HMRATE((1e-11)*2.7,0.38,2200);
		/* >>chng 06 Feb 27 -- NPA  TH85 has a temperature barrier for this reaction, and
		 * the Meudon PDR code datafile does as well.  Use the temperature barrier of 370 K*/
		/*rate_COmole.H_CH2_CH_H2			    = HMRATE((1e-11)*6.64,0,0)*HI;*/
		rate_COmole.H_CH2_CH_H2			    = HMRATE((1e-11)*6.64,0,370);

		if(co.lgFederman)
		{
			/* >>chng 06 Feb 28 -- NPA.  Federman rate has no temperature barrier. However, both
			* TH85 and the Meudon groud use a temperature barrier of ~2300 K.  Keep the a and b
			* in HMRATE(a,b,c) but add the temperature barrier  
				rate_COmole.H_CH_C_H2 = HMRATE((1e-11)*5.0,0.5,0)*HI; */
			rate_COmole.H_CH_C_H2 = HMRATE((1e-11)*5.0,0.5,2200);
		}
	}

#	ifdef DEBUG_FUN
	fputs( " <->CO_Init()\n", debug_fp );
#	endif

	return;
}

/*=================================================================*/
/*CO_Init called from cdInit to initialized co routines */
void CO_Init(void)
{
	long int i,
		nelem;

#	ifdef DEBUG_FUN
	fputs( "<+>CO_Init()\n", debug_fp );
#	endif

	/* these tell the molecular solver what zone and iteration it has
	 * been evaluated on */
	co.co_nzone = -2;
	co.iteration_co = -2;

	/* atomic number of element that limits each molecule */
	co.nelem_hevmol[ipCH] = ipCARBON;
	co.nelem_hevmol[ipCHP] = ipCARBON;
	co.nelem_hevmol[ipOH] = ipOXYGEN;
	co.nelem_hevmol[ipOHP] = ipOXYGEN;
	co.nelem_hevmol[ipO2] = ipOXYGEN;
	co.nelem_hevmol[ipCO] = ipCARBON;
	co.nelem_hevmol[ipCOP] = ipCARBON;
	co.nelem_hevmol[ipH2O] = ipOXYGEN;
	co.nelem_hevmol[ipH2OP] = ipOXYGEN;
	co.nelem_hevmol[ipO2P] = ipOXYGEN;
	co.nelem_hevmol[ipH3OP] = ipOXYGEN;
	co.nelem_hevmol[ipCH2P] = ipCARBON;
	co.nelem_hevmol[ipCH2] = ipCARBON;
	co.nelem_hevmol[ipHCOP] = ipCARBON;
	co.nelem_hevmol[ipCH3P] = ipCARBON;
	co.nelem_hevmol[ipCH3] = ipCARBON;
	co.nelem_hevmol[ipCH4] = ipCARBON;
	co.nelem_hevmol[ipCH4P] = ipCARBON;
	co.nelem_hevmol[ipCH5P] = ipCARBON;
	co.nelem_hevmol[ipSIH2P] = ipSILICON;
	co.nelem_hevmol[ipSIH] = ipSILICON;
	co.nelem_hevmol[ipHOSIP] = ipSILICON;
	co.nelem_hevmol[ipSIO] = ipSILICON;
	co.nelem_hevmol[ipSIOP] = ipSILICON;
	co.nelem_hevmol[ipCP] = ipCARBON;
	co.nelem_hevmol[ipOP] = ipOXYGEN;
	co.nelem_hevmol[ipSIP] = ipSILICON;
	co.nelem_hevmol[ipATC] = ipCARBON;
	co.nelem_hevmol[ipATO] = ipOXYGEN;
	co.nelem_hevmol[ipATSI] = ipSILICON;
	co.nelem_hevmol[ipN2] = ipNITROGEN;
	co.nelem_hevmol[ipN2P] = ipNITROGEN;
	co.nelem_hevmol[ipNO] = ipNITROGEN;
	co.nelem_hevmol[ipNOP] = ipNITROGEN;
	co.nelem_hevmol[ipS2] = ipSULPHUR;
	co.nelem_hevmol[ipS2P] = ipSULPHUR;
	co.nelem_hevmol[ipOCN] = ipNITROGEN;
	co.nelem_hevmol[ipOCNP] = ipNITROGEN;
	co.nelem_hevmol[ipNH] = ipNITROGEN;
	co.nelem_hevmol[ipNHP] = ipNITROGEN;
	co.nelem_hevmol[ipNH2] = ipNITROGEN;
	co.nelem_hevmol[ipNH2P] = ipNITROGEN;
	co.nelem_hevmol[ipNH3] = ipNITROGEN;
	co.nelem_hevmol[ipNH3P] = ipNITROGEN;
	co.nelem_hevmol[ipNH4P] = ipNITROGEN;
	co.nelem_hevmol[ipCN] = ipNITROGEN;
	co.nelem_hevmol[ipCNP] = ipNITROGEN;
	co.nelem_hevmol[ipHCN] = ipNITROGEN;
	co.nelem_hevmol[ipHCNP] = ipNITROGEN;
	co.nelem_hevmol[ipHNO] = ipNITROGEN;
	co.nelem_hevmol[ipHNOP] = ipNITROGEN;
	co.nelem_hevmol[ipHS] = ipSULPHUR;
	co.nelem_hevmol[ipHSP] = ipSULPHUR;
	co.nelem_hevmol[ipCS] = ipSULPHUR;
	co.nelem_hevmol[ipCSP] = ipSULPHUR;
	co.nelem_hevmol[ipNO2] = ipNITROGEN;
	co.nelem_hevmol[ipNO2P] = ipNITROGEN;
	co.nelem_hevmol[ipNS] = ipSULPHUR;
	co.nelem_hevmol[ipNSP] = ipSULPHUR;
	co.nelem_hevmol[ipSO] = ipSULPHUR;
	co.nelem_hevmol[ipSOP] = ipSULPHUR;
	co.nelem_hevmol[ipSIN] = ipSILICON;
	co.nelem_hevmol[ipSINP] = ipSILICON;
	co.nelem_hevmol[ipN2O] = ipNITROGEN;
	co.nelem_hevmol[ipHCSP] = ipSULPHUR;
	co.nelem_hevmol[ipOCS] = ipSULPHUR;
	co.nelem_hevmol[ipOCSP] = ipSULPHUR;
	co.nelem_hevmol[ipC2] = ipCARBON;
	co.nelem_hevmol[ipC2P] = ipCARBON;
	co.nelem_hevmol[ipNP] = ipNITROGEN;
	co.nelem_hevmol[ipSP] = ipSULPHUR;
	co.nelem_hevmol[ipATN] = ipNITROGEN;
	co.nelem_hevmol[ipATS] = ipSULPHUR;
	co.nelem_hevmol[ipClO] = ipCHLORINE;
	co.nelem_hevmol[ipHClP] = ipCHLORINE;
	co.nelem_hevmol[ipHCl] = ipCHLORINE;
	co.nelem_hevmol[ipCCl] = ipCHLORINE;
	co.nelem_hevmol[ipH2ClP] = ipCHLORINE;
	co.nelem_hevmol[ipCClP] = ipCHLORINE;
	co.nelem_hevmol[ipH2CClP] = ipCHLORINE;
	co.nelem_hevmol[ipClOP] = ipCHLORINE;
	co.nelem_hevmol[ipClP] = ipCHLORINE;
	co.nelem_hevmol[ipATCl] = ipCHLORINE;
	co.nelem_hevmol[ipCOGR] = ipCARBON;
	co.nelem_hevmol[ipH2OGR] = ipOXYGEN;
	co.nelem_hevmol[ipOHGR] = ipOXYGEN;
	co.nelem_hevmol[ipHNC] = ipNITROGEN;
	co.nelem_hevmol[ipHCNHP] = ipNITROGEN;
	co.nelem_hevmol[ipC2H] = ipCARBON;
	co.nelem_hevmol[ipC2HP] = ipCARBON;
	co.nelem_hevmol[ipC3] = ipCARBON;
	co.nelem_hevmol[ipC3P] = ipCARBON;
	co.nelem_hevmol[ipC3H] = ipCARBON;
	co.nelem_hevmol[ipC3HP] = ipCARBON;
	co.nelem_hevmol[ipC2H2] = ipCARBON;
	co.nelem_hevmol[ipC2H2P] = ipCARBON;
	co.nelem_hevmol[ipC2H3P] = ipCARBON;

	/* number of H, O, C, Si,  and e- in each molecule */
	for( i=0; i< NUM_COMOLE_CALC; ++i )
	{
		co.nOxyg[i] = 0;
		co.nCarb[i] = 0;
		co.nElec[i] = 0;
		co.nHydr[i] = 0;
		co.nSulp[i] = 0;
		co.nNitr[i] = 0;
		co.nElec[i] = 0;
		/* >>chng 05 Jun 05, tell Cloudy if molecule is in gas phase or part of a solid *
		 *  This will naturally be set to 1, if grain then species is zero */	 
		co.lgGas_Phase[i] = TRUE;

		co.co_save[i] = 0.;
	}
	/* set up array indices  */
	strcpy( co.chLab[ipCH],   "CH    " );
	co.nCarb[ipCH] = 1;
	co.nHydr[ipCH] = 1;

	strcpy( co.chLab[ipCHP],  "CH+   " );
	co.nCarb[ipCHP] = 1;
	co.nHydr[ipCHP] = 1;
	co.nElec[ipCHP] = 1;

	strcpy( co.chLab[ipOH],   "OH    " );
	co.nOxyg[ipOH] = 1;
	co.nHydr[ipOH] = 1;

	strcpy( co.chLab[ipOHP],  "OH+   " );
	co.nOxyg[ipOHP] = 1;
	co.nElec[ipOHP] = 1;
	co.nHydr[ipOHP] = 1;

	strcpy( co.chLab[ipO2],   "O2    " );
	co.nOxyg[ipO2] = 2;
	
	strcpy( co.chLab[ipCO],   "CO    " );
	co.nOxyg[ipCO] = 1;
	co.nCarb[ipCO] = 1;
	
	strcpy( co.chLab[ipCOP],  "CO+   " );
	co.nOxyg[ipCOP] = 1;
	co.nCarb[ipCOP] = 1;
	co.nElec[ipCOP] = 1;
	
	strcpy( co.chLab[ipH2O],  "H2O   " );
	co.nOxyg[ipH2O] = 1;
	co.nHydr[ipH2O] = 2;

	strcpy( co.chLab[ipH2OP], "H2O+  " );
	co.nOxyg[ipH2OP] = 1;
	co.nElec[ipH2OP] = 1;
	co.nHydr[ipH2OP] = 2;

	strcpy( co.chLab[ipO2P],  "O2+   " );
	co.nOxyg[ipO2P] = 2;
	co.nElec[ipO2P] = 1;
	
	strcpy( co.chLab[ipH3OP], "H3O+  " );
	co.nOxyg[ipH3OP] = 1;
	co.nElec[ipH3OP] = 1;
	co.nHydr[ipH3OP] = 3;

	strcpy( co.chLab[ipCH2P], "CH2+  " );
	co.nCarb[ipCH2P] = 1;
	co.nElec[ipCH2P] = 1;
	co.nHydr[ipCH2P] = 2;

	strcpy( co.chLab[ipCH2],  "CH2   " );
	co.nCarb[ipCH2] = 1;
	co.nHydr[ipCH2] = 2;

	strcpy( co.chLab[ipHCOP], "HCO+  " );
	co.nOxyg[ipHCOP] = 1;
	co.nCarb[ipHCOP] = 1;
	co.nElec[ipHCOP] = 1;
	co.nHydr[ipHCOP] = 1;

	strcpy( co.chLab[ipCH3P], "CH3+  " );
	co.nHydr[ipCH3P] = 3;
	co.nCarb[ipCH3P] = 1;
	co.nElec[ipCH3P] = 1;

	strcpy( co.chLab[ipCH3],  "CH3   " );
	co.nHydr[ipCH3] = 3;
	co.nCarb[ipCH3] = 1;
	
	strcpy( co.chLab[ipCH4],  "CH4   " );
	co.nHydr[ipCH4] = 4;
	co.nCarb[ipCH4] = 1;
	
	strcpy( co.chLab[ipCH4P], "CH4+  " );
	co.nHydr[ipCH4P] = 4;
	co.nCarb[ipCH4P] = 1;
	co.nElec[ipCH4P] = 1;

	strcpy( co.chLab[ipCH5P], "CH5+  " );
	co.nHydr[ipCH5P] = 5;
	co.nCarb[ipCH5P] = 1;
	co.nElec[ipCH5P] = 1;
	
	strcpy( co.chLab[ipSIH2P],"SiH2+ " );
	co.nHydr[ipSIH2P] = 2;
	co.nSili[ipSIH2P] = 1;
	co.nElec[ipSIH2P] = 1;
	
	strcpy( co.chLab[ipSIH],  "SiH   " );
	co.nHydr[ipSIH] = 1;
	co.nSili[ipSIH] = 1;

	strcpy( co.chLab[ipHOSIP],"HOSi+ " );
	co.nOxyg[ipHOSIP] = 1;
	co.nElec[ipHOSIP] = 1;
	co.nHydr[ipHOSIP] = 1;
	co.nSili[ipHOSIP] = 1;

	strcpy( co.chLab[ipSIO],  "SiO   " );
	co.nOxyg[ipSIO] = 1;
	co.nSili[ipSIO] = 1;

	strcpy( co.chLab[ipSIOP], "SiO+  " );
	co.nOxyg[ipSIOP] = 1;
	co.nSili[ipSIOP] = 1;
	co.nElec[ipSIOP] = 1;

	strcpy( co.chLab[ipN2],   "N2    " );
	
	co.nNitr[ipN2] = 2;

	strcpy( co.chLab[ipN2P],  "N2+   " );
	
	co.nNitr[ipN2P] = 2;
	co.nElec[ipN2P] = 1;

	strcpy( co.chLab[ipNO],   "NO    " );

	co.nOxyg[ipNO] = 1;
	co.nNitr[ipNO] = 1;

	strcpy( co.chLab[ipNOP],  "NO+   " );

	co.nOxyg[ipNOP] = 1;
	co.nElec[ipNOP] = 1;
	co.nNitr[ipNOP] = 1;

	strcpy( co.chLab[ipS2],   "S2    " );
	
	co.nSulp[ipS2] = 2;
 
	strcpy( co.chLab[ipS2P],  "S2+   " );
	
	co.nSulp[ipS2P] = 2;
	co.nElec[ipS2P] = 1;

	strcpy( co.chLab[ipOCN],  "OCN   " );

	co.nOxyg[ipOCN] = 1;
	co.nCarb[ipOCN] = 1;
	co.nNitr[ipOCN] = 1;

	strcpy( co.chLab[ipOCNP], "OCN+  " );
	
	co.nOxyg[ipOCNP] = 1;
	co.nCarb[ipOCNP] = 1;
	co.nElec[ipOCNP] = 1;
	co.nNitr[ipOCNP] = 1;

	strcpy( co.chLab[ipNH],   "NH    " );
	
	co.nNitr[ipNH] = 1;
	co.nHydr[ipNH] = 1;

	strcpy( co.chLab[ipNHP],  "NH+   " );
	
	co.nNitr[ipNHP] = 1;
	co.nElec[ipNHP] = 1;
	co.nHydr[ipNHP] = 1;

	strcpy( co.chLab[ipNH2],  "NH2   " );
	
	co.nNitr[ipNH2] = 1;
	co.nHydr[ipNH2] = 2;

	strcpy( co.chLab[ipNH2P], "NH2+  " );
	
	co.nNitr[ipNH2P] = 1;
	co.nElec[ipNH2P] = 1;
	co.nHydr[ipNH2P] = 2;

	strcpy( co.chLab[ipNH3],  "NH3   " );
	
	co.nNitr[ipNH3] = 1;
	co.nHydr[ipNH3] = 3;

	strcpy( co.chLab[ipNH3P], "NH3+  " );
	
	co.nNitr[ipNH3P] = 1;
	co.nElec[ipNH3P] = 1;
	co.nHydr[ipNH3P] = 3;

	strcpy( co.chLab[ipNH4P], "NH4+  " );
	
	co.nNitr[ipNH4P] = 1;
	co.nElec[ipNH4P] = 1;
	co.nHydr[ipNH4P] = 4;

	strcpy( co.chLab[ipCN],   "CN    " );
	
	co.nCarb[ipCN] = 1;
	co.nNitr[ipCN] = 1;

	strcpy( co.chLab[ipCNP],  "CN+   " );
	
	co.nCarb[ipCNP] = 1;
	co.nElec[ipCNP] = 1;
	co.nNitr[ipCNP] = 1;

	strcpy( co.chLab[ipHCN],  "HCN   " );
	
	co.nCarb[ipHCN] = 1;
	co.nNitr[ipHCN] = 1;
	co.nHydr[ipHCN] = 1;

	strcpy( co.chLab[ipHCNP], "HCN+  " );
	
	co.nNitr[ipHCNP] = 1;
	co.nCarb[ipHCNP] = 1;
	co.nElec[ipHCNP] = 1;
	co.nHydr[ipHCNP] = 1;

	strcpy( co.chLab[ipHNO],  "HNO   " );

	co.nOxyg[ipHNO] = 1;
	co.nNitr[ipHNO] = 1;
	co.nHydr[ipHNO] = 1;

	strcpy( co.chLab[ipHNOP], "HNO+  " );

	co.nOxyg[ipHNOP] = 1;
	co.nNitr[ipHNOP] = 1;
	co.nElec[ipHNOP] = 1;
	co.nHydr[ipHNOP] = 1;

	strcpy( co.chLab[ipHS],   "HS    " );
	
	co.nHydr[ipHS] = 1;
	co.nSulp[ipHS] = 1;

	strcpy( co.chLab[ipHSP],  "HS+   " );
	
	co.nSulp[ipHSP] = 1;
	co.nElec[ipHSP] = 1;
	co.nHydr[ipHSP] = 1;

	strcpy( co.chLab[ipCS],   "CS    " );
	
	co.nCarb[ipCS] = 1;
	co.nSulp[ipCS] = 1;

	strcpy( co.chLab[ipCSP],  "CS+   " );
	
	co.nCarb[ipCSP] = 1;
	co.nElec[ipCSP] = 1;
	co.nSulp[ipCSP] = 1;

	strcpy( co.chLab[ipNO2],  "NO2   " );

	co.nOxyg[ipNO2] = 2;
	co.nNitr[ipNO2] = 1;

	strcpy( co.chLab[ipNO2P], "NO2+  " );

	co.nOxyg[ipNO2P] = 2;
	co.nNitr[ipNO2P] = 1;
	co.nElec[ipNO2P] = 1;

	strcpy( co.chLab[ipNS],   "NS    " );
	
	co.nNitr[ipNS] = 1;
	co.nSulp[ipNS] = 1;

	strcpy( co.chLab[ipNSP],  "NS+   " );
	
	co.nNitr[ipNSP] = 1;
	co.nElec[ipNSP] = 1;
	co.nSulp[ipNSP] = 1;

	strcpy( co.chLab[ipSO],   "SO    " );
	co.nOxyg[ipSO] = 1;
	co.nSulp[ipSO] = 1;

	strcpy( co.chLab[ipSOP],  "SO+   " );

	co.nOxyg[ipSOP] = 1;
	co.nElec[ipSOP] = 1;
	co.nSulp[ipSOP] = 1;

	strcpy( co.chLab[ipSIN],  "SiN   " );
	
	co.nSili[ipSIN] = 1;
	co.nNitr[ipSIN] = 1;

	strcpy( co.chLab[ipSINP], "SiN+  " );
	
	co.nSili[ipSINP] = 1;
	co.nElec[ipSINP] = 1;
	co.nNitr[ipSINP] = 1;

	strcpy( co.chLab[ipN2O],  "N2O   " );

	co.nOxyg[ipN2O] = 1;
	co.nNitr[ipN2O] = 2;

	strcpy( co.chLab[ipHCSP], "HCS+  " );
	
	co.nCarb[ipHCSP] = 1;
	co.nSulp[ipHCSP] = 1;
	co.nElec[ipHCSP] = 1;
	co.nHydr[ipHCSP] = 1;

	strcpy( co.chLab[ipOCS],  "OCS   " );

	co.nOxyg[ipOCS] = 1;
	co.nCarb[ipOCS] = 1;
	co.nSulp[ipOCS] = 1;

	strcpy( co.chLab[ipOCSP], "OCS+  " );

	co.nOxyg[ipOCSP] = 1;
	co.nCarb[ipOCSP] = 1;
	co.nElec[ipOCSP] = 1;
	co.nSulp[ipOCSP] = 1;

	strcpy( co.chLab[ipHNC],  "HNC   " );

	co.nHydr[ipHNC] = 1;
	co.nCarb[ipHNC] = 1;
	co.nNitr[ipHNC] = 1;

	strcpy( co.chLab[ipHCNHP], "HCNH+ " );

	co.nHydr[ipHCNHP] = 2;
	co.nCarb[ipHCNHP] = 1;
	co.nElec[ipHCNHP] = 1;
	co.nNitr[ipHCNHP] = 1;

	strcpy( co.chLab[ipC2],   "C2    " );

	co.nCarb[ipC2] = 2;

	strcpy( co.chLab[ipC2P],  "C2+   " );

	co.nCarb[ipC2P] = 2;
	co.nElec[ipC2P] = 1;

	strcpy( co.chLab[ipCP],   "C+    " );
	co.nCarb[ipCP] = 1;
	
	strcpy( co.chLab[ipOP],   "O+    " );
	co.nOxyg[ipOP] = 1;

	strcpy( co.chLab[ipSIP],  "Si+   " );
	co.nSili[ipSIP] = 1;

	strcpy( co.chLab[ipATC],  "C     " );
	co.nCarb[ipATC] = 1;
	
	strcpy( co.chLab[ipATO],  "O     " );
	co.nOxyg[ipATO] = 1;		

	strcpy( co.chLab[ipATSI], "Si    " );
	co.nSili[ipATSI] = 1;

	strcpy( co.chLab[ipNP],   "N+    " );
	co.nNitr[ipNP] = 1;

	strcpy( co.chLab[ipATN],  "N     " );
	co.nNitr[ipATN] = 1;
	
	strcpy( co.chLab[ipATS],  "S     " );
	co.nSulp[ipATS] = 1;

	strcpy( co.chLab[ipSP],   "S+    " );
	co.nSulp[ipSP] = 1;		

	strcpy( co.chLab[ipCCl],  "CCl   " );

	co.nChlo[ipCCl] = 1;
	co.nCarb[ipCCl] = 1;

	strcpy( co.chLab[ipClO],  "ClO   " );
	co.nChlo[ipClO] = 1;
	co.nOxyg[ipClO] = 1;
	
	strcpy( co.chLab[ipHClP], "HCl+  " );
	co.nChlo[ipHClP] = 1;
	co.nHydr[ipHClP] = 1;
	co.nElec[ipHClP] = 1;

	strcpy( co.chLab[ipHCl],  "HCl   " );
	co.nChlo[ipHCl] = 1;
	co.nHydr[ipHCl] = 1;

	strcpy( co.chLab[ipH2ClP],"H2Cl+ " );
	co.nChlo[ipH2ClP] = 1;
	co.nHydr[ipH2ClP] = 2;
	co.nElec[ipH2ClP] = 1;

	strcpy( co.chLab[ipCClP], "CCl+  " );

	co.nChlo[ipCClP] = 1;
	co.nCarb[ipCClP] = 1;
	co.nElec[ipCClP] = 1;

	strcpy(co.chLab[ipH2CClP],"H2CCl+" );

	co.nChlo[ipH2CClP] = 1;
	co.nHydr[ipH2CClP] = 2;
	co.nElec[ipH2CClP] = 1;
	co.nCarb[ipH2CClP] = 1;

	strcpy( co.chLab[ipClOP], "ClO+  " );
	co.nChlo[ipClOP] = 1;
	co.nOxyg[ipClOP] = 1;
	co.nElec[ipClOP] = 1;

	/* >>chng make GR lower case grn */
	strcpy( co.chLab[ipCOGR], "COgrn " );
	co.nCarb[ipCOGR] = 1;
	co.nOxyg[ipCOGR] = 1;
	co.lgGas_Phase[ipCOGR] = FALSE;

	strcpy( co.chLab[ipH2OGR], "H2Ogrn" );
	co.nHydr[ipH2OGR] = 2;
	co.nOxyg[ipH2OGR] = 1;
	co.lgGas_Phase[ipH2OGR] = FALSE;

	strcpy( co.chLab[ipOHGR], "OHgrn " );
	co.nHydr[ipOHGR] = 1;
	co.nOxyg[ipOHGR] = 1;
	co.lgGas_Phase[ipOHGR] = FALSE;

	strcpy( co.chLab[ipATCl], "Cl    " );
	co.nChlo[ipATCl] = 1;

	strcpy( co.chLab[ipClP],  "Cl+   " );
	co.nChlo[ipClP] = 1;

	strcpy( co.chLab[ipC2H], "C2H   ");
	co.nCarb[ipC2H] = 2;
	co.nHydr[ipC2H] = 1;

	strcpy( co.chLab[ipC2HP],"C2H+  ");
	co.nElec[ipC2HP] = 1;
	co.nCarb[ipC2HP] = 2;
	co.nHydr[ipC2HP] = 1;

	strcpy( co.chLab[ipC3],  "C3    ");
	co.nCarb[ipC3] = 3;

	strcpy( co.chLab[ipC3P], "C3+   ");
	co.nCarb[ipC3P] = 3;
	co.nElec[ipC3P] = 1;

	strcpy( co.chLab[ipC3HP],"C3H+  ");
	co.nCarb[ipC3HP] = 3;
	co.nHydr[ipC3HP] = 1;
	co.nElec[ipC3HP] = 1;

	strcpy( co.chLab[ipC3H],   "C3H   ");
	co.nCarb[ipC3H] = 3;
	co.nHydr[ipC3H] = 1;

	strcpy( co.chLab[ipC2H2],  "C2H2  ");
	co.nCarb[ipC2H2] = 2;
	co.nHydr[ipC2H2] = 2;
	
	strcpy( co.chLab[ipC2H2P], "C2H2+ ");
	co.nCarb[ipC2H2P] = 2;
	co.nHydr[ipC2H2P] = 2;
	co.nElec[ipC2H2P] = 1;
	
	strcpy( co.chLab[ipC2H3P], "C2H3+ ");
	co.nCarb[ipC2H3P] = 2;
	co.nElec[ipC2H3P] = 1;
	co.nHydr[ipC2H3P] = 3;

	/* rate for He+ + CO -> He + O + C+ */
	co.rate_co_hep_o_cp_he = 0.;

	/* set flag saying whether elem is in chem net */
	for(nelem=ipHYDROGEN; nelem<LIMELM; ++nelem )
	{
		mole.lgElem_in_chemistry[nelem] = FALSE;
	}
	/* last NUM_HEAVY_MOLEC+NUM_ELEMENTS through NUM_COMOLE_CALC
	 * species are atoms included in the network.  Set flag saying
	 * so, so that easy to check if part of chemistry */
	for( i=NUM_HEAVY_MOLEC+NUM_ELEMENTS; i<NUM_COMOLE_CALC; ++i )
	{
		mole.lgElem_in_chemistry[co.nelem_hevmol[i]] = TRUE;
	}

#	ifdef DEBUG_FUN
	fputs( " <->CO_Init()\n", debug_fp );
#	endif

	return;

}
/*lint +e778 constant expression evaluatess to 0 in operation '-' */
/*lint +e777 test floats for equal */

