/* This file is part of Cloudy and is copyright (C)1978-2006 by Gary J. Ferland
 * For conditions of distribution and use see copyright notice in license.txt */
/*CO_ele_recomb() contains all heavy element reactions with electrons 
 * */
#include "cddefines.h"
#include "dense.h"
#include "ionbal.h"
#include "grainvar.h"
#include "phycon.h"
#include "mole.h"
/*lint -e778 constant expression evaluatess to 0 in operation '-' */
/*=================================================================*/


/*CO_step fills in matrix for heavy elements molecular routines */
void CO_ele_recomb(void )
{
	double 
	C2H3P_e_C2H2_H,
	C2H2P_e_C2_H_H,
	C2H2P_e_CH_CH,
	C2H2P_e_C2H_H,
	C3HP_e_C2H_C,
	C3HP_e_C3_H,
	C3P_e_C2_C,
	C2HP_e_CH_C,
	C2HP_e_C2_H,
	e_CHP_C_H,
	e_CH2P_CH_H,
	e_CH2P_C_H_H,
	e_CH2P_C_H2,
	e_CH3P_C_H2_H,
	e_CH3P_CH2_H,
	e_CH3P_CH_H_H,
	e_CH3P_CH_H2,
	e_CH3P_CH3_nu,
	e_COP_O_C,
	e_H2OP_OH_H,
	e_H2OP_O_H_H,
	e_H2OP_O_H2,
	e_H3OP_H2O_H,
	e_H3OP_OH_H_H,
	e_H3OP_OH_H2,
	e_H3OP_O_H2_H,
	e_O2P_O_O,
	e_OHP_O_H,
	e_SiH2P_SiH_H,
	e_SiH2P_Si_H_H,
	e_SiH2P_Si_H2,
	e_SiOP_Si_O,
	e_SiOHP_SiO_H,
	e_SiOHP_Si_OH,
	e_CH5P_CH3_H2,
	e_CH5P_CH4_H,
	e_CH4P_CH3_H,
	e_CH4P_CH2_H_H,
	NHP_e_N_H ,
	NH2P_e_N_H_H  ,
	NH2P_e_NH_H   ,
	NH3P_e_NH_H_H ,
	NH3P_e_NH2_H  ,
	NH4P_e_NH2_H_H,
	NH4P_e_NH2_H2 ,
	NH4P_e_NH3_H  ,
	CNP_e_N_C ,
	HCNP_e_CN_H   ,
	N2P_e_N_N ,
	NOP_e_O_N ,
	HNOP_e_NO_H   ,
	HSP_e_S_H ,
	SINP_e_SI_N   ,
	CSP_e_S_C ,
	HCSP_e_CS_H   ,
	NO2P_e_NO_O   ,
	NSP_e_S_N ,
	SOP_e_S_O ,
	OCSP_e_CS_O   ,
	S2P_e_S_S ,
	C2P_e_C_C,
	HClP_e_Cl_H,
	H2ClP_e_Cl_H_H,
	H2ClP_e_HCl_H,
	CClP_e_Cl_C,
	H2CClP_e_CCl_H_H,
	ClOP_e_Cl_O,
	HCNHP_e_CN_H_H   , 
	HCNHP_e_HCN_H     ,
	HCNHP_e_HNC_H     ,

	/* the current electron density */
	ele = dense.eden;

	/* reaction rates */
	C3P_e_C2_C = HMRATE(0.0000003,-0.5,0)*ele;
	C2HP_e_CH_C = HMRATE(0.000000135,-0.5,0)*ele;
	/* The rate for this reaction comes from Eric Herbst's website */
	C2HP_e_C2_H = HMRATE(0.000000116,-0.76,0)*ele;
	e_CH5P_CH3_H2           = HMRATE(0.00000055,-0.3,0)*ele;
	e_CH5P_CH4_H            = HMRATE(0.00000055,-0.3,0)*ele;
	e_CH4P_CH3_H            = HMRATE(0.000000175,-0.5,0)*ele;
	e_CH4P_CH2_H_H			= HMRATE(0.000000175,-0.5,0)*ele;
	e_CHP_C_H               = HMRATE(0.00000015,-0.42,0)*ele;
	e_CH2P_CH_H             = HMRATE(0.00000016,-0.6,0)*ele;
	e_CH2P_C_H_H            = HMRATE(0.000000403,-0.6,0)*ele;
	e_CH2P_C_H2             = HMRATE(0.0000000768,-0.6,0)*ele;
	e_CH3P_C_H2_H           = HMRATE(0.000000105,-0.5,0)*ele;
	e_CH3P_CH2_H            = HMRATE(0.00000014,-0.5,0)*ele;
	e_CH3P_CH_H_H           = HMRATE(0.000000056,-0.5,0)*ele;
	e_CH3P_CH_H2            = HMRATE(0.000000049,-0.5,0)*ele;
	e_CH3P_CH3_nu           = HMRATE(1.1e-10,-0.5,0)*ele;
	e_COP_O_C               = HMRATE(0.0000002,-0.48,0)*ele;
	e_H2OP_OH_H             = HMRATE(0.0000000792,-0.5,0)*ele;
	e_H2OP_O_H_H            = HMRATE(0.000000245,-0.5,0)*ele;
	e_H2OP_O_H2             = HMRATE(0.000000036,-0.5,0)*ele;
	e_H3OP_H2O_H            = HMRATE(0.000000108,-0.5,0)*ele;
	e_H3OP_OH_H_H           = HMRATE(0.000000258,-0.5,0)*ele;
	e_H3OP_OH_H2            = HMRATE(0.0000000645,-0.5,0)*ele;
	e_H3OP_O_H2_H           = HMRATE((1e-9)*5.59,-0.5,0)*ele;
	e_O2P_O_O               = HMRATE(0.000000195,-0.7,0)*ele;
	e_OHP_O_H               = HMRATE(0.0000000375,-0.5,0)*ele;
	e_SiH2P_SiH_H           = HMRATE(0.00000015,-0.5,0)*ele;
	e_SiH2P_Si_H_H          = HMRATE(0.0000002,-0.5,0)*ele;
	e_SiH2P_Si_H2           = HMRATE(0.00000015,-0.5,0)*ele;
	e_SiOP_Si_O             = HMRATE(0.0000002,-0.5,0)*ele;
	e_SiOHP_SiO_H           = HMRATE(0.00000015,-0.5,0)*ele;
	e_SiOHP_Si_OH           = HMRATE(0.00000015,-0.5,0)*ele;
	C2P_e_C_C = HMRATE(0.0000003,-0.5,0)*ele;
	NHP_e_N_H         = HMRATE(0.000000043,-0.5,0)*ele;
	NH2P_e_N_H_H      = HMRATE(0.000000198,-0.5,0)*ele;
	NH2P_e_NH_H       = HMRATE(0.000000102,-0.5,0)*ele;
	NH3P_e_NH_H_H     = HMRATE(0.000000155,-0.5,0)*ele;
	NH3P_e_NH2_H      = HMRATE(0.000000155,-0.5,0)*ele;
	NH4P_e_NH2_H_H    = HMRATE(0.000000286,-0.5,0)*ele;
	NH4P_e_NH2_H2     = HMRATE(0.000000137,-0.5,0)*ele;
	NH4P_e_NH3_H      = HMRATE(0.000000938,-0.5,0)*ele;
	CNP_e_N_C         = HMRATE(0.00000018,-0.5,0)*ele;
	HCNP_e_CN_H       = HMRATE(0.0000002,-0.5,0)*ele;
	N2P_e_N_N         = HMRATE(0.000000036,-0.42,0)*ele;
	NOP_e_O_N         = HMRATE(0.00000043,-0.37,0)*ele;
	HNOP_e_NO_H       = HMRATE(0.0000003,-0.5,0)*ele;
	HSP_e_S_H         = HMRATE(0.0000002,-0.5,0)*ele;
	SINP_e_SI_N       = HMRATE(0.0000002,-0.5,0)*ele;
	CSP_e_S_C         = HMRATE(0.0000002,-0.5,0)*ele;
	HCSP_e_CS_H       = HMRATE(0.00000005,-0.75,0)*ele;
	NO2P_e_NO_O       = HMRATE(0.0000003,-0.5,0)*ele;
	NSP_e_S_N         = HMRATE(0.0000002,-0.5,0)*ele;
	SOP_e_S_O         = HMRATE(0.0000002,-0.5,0)*ele;
	OCSP_e_CS_O       = HMRATE(0.00000015,-0.5,0)*ele;
	S2P_e_S_S         = HMRATE(0.0000002,-0.5,0)*ele;
	HClP_e_Cl_H = HMRATE(0.0000003,-0.5,0)*ele;
	H2ClP_e_Cl_H_H = HMRATE(0.00000027,-0.5,0)*ele;
	H2ClP_e_HCl_H = HMRATE(0.00000003,-0.5,0)*ele;
	CClP_e_Cl_C = HMRATE(0.0000003,-0.5,0)*ele;
	H2CClP_e_CCl_H_H = HMRATE(0.0000003,-0.5,0)*ele;
	ClOP_e_Cl_O = HMRATE(0.0000002,-0.5,0)*ele;

	/* This turns on the diffuse cloud chemical rates from Tables 6 & 8 of
	>> refer Federman, S. R. & Zsargo, J. 2003, ApJ, 589, 319
	Without the "set rates federman" command, the default values are
	from UMIST */
	if(co.lgFederman)
	{
		e_COP_O_C = HMRATE(1.0e-7,-0.46,0)*ele;
		e_CH2P_CH_H  = HMRATE(1.25e-7,-0.5,0)*ele;
		e_CH3P_CH_H2 = HMRATE(2.45e-7,-0.5,0)*ele;
		e_CH2P_C_H2 = HMRATE(1.25e-7,-0.5,0)*ele;
		e_CH3P_CH2_H = HMRATE(7.0e-8,-0.5,0)*ele;
		e_CH3P_C_H2_H = HMRATE(3.5e-8,-0.5,0)*ele;
	}

	HCNHP_e_HNC_H = HMRATE(0.00000009,-0.5,0)*ele;
	HCNHP_e_CN_H_H = HMRATE(0.00000018,-0.5,0)*ele;
	HCNHP_e_HCN_H = HMRATE(0.00000009,-0.5,0)*ele;
	C2H2P_e_C2_H_H = HMRATE(0.00000009,-0.5,0)*ele;
	C2H2P_e_CH_CH = HMRATE(0.00000009,-0.5,0)*ele;
	/* The rate for this reaction comes from Eric Herbst's website */
	C2H2P_e_C2H_H = HMRATE(0.00000029,-0.5,0)*ele;
	C3HP_e_C2H_C = HMRATE(0.00000015,-0.5,0)*ele;
	C3HP_e_C3_H = HMRATE(0.00000015,-0.5,0)*ele;
	C2H3P_e_C2H2_H = HMRATE(0.00000045,-0.5,0)*ele;
		
	/* Put in the dissociative recombination reactions into Cloudy */

	/* >>refer	mol	e	CH+	=>	C	H	UMIST	*/
	
	mole.c[ipCHP][ipCHP] -= e_CHP_C_H;
	mole.c[ipCHP][ipATC] += e_CHP_C_H;
	
	/* >>refer	mol	e	CH2+	=>	CH	H	UMIST	*/
		
	mole.c[ipCH2P][ipCH2P] -= e_CH2P_CH_H;
	mole.c[ipCH2P][ipCH] += e_CH2P_CH_H;
	
	/* >>refer	mol	e	CH2+	=>	C	H	H	UMIST	*/
		
	mole.c[ipCH2P][ipCH2P] -= e_CH2P_C_H_H;
	mole.c[ipCH2P][ipATC] += e_CH2P_C_H_H;

	/* >>refer	mol	e	CH2+	=>	C	H2	UMIST	*/
		
	mole.c[ipCH2P][ipCH2P] -= e_CH2P_C_H2;
	mole.c[ipCH2P][ipATC] += e_CH2P_C_H2;
	
	/* >>refer	mol	e	CH3+	=>	C	H2	H	UMIST	*/
		
	mole.c[ipCH3P][ipCH3P] -= e_CH3P_C_H2_H;
	mole.c[ipCH3P][ipATC] += e_CH3P_C_H2_H;
	
	/* >>refer	mol	e	CH3+	=>	CH2	H	UMIST	*/
	
	mole.c[ipCH3P][ipCH3P] -= e_CH3P_CH2_H;
	mole.c[ipCH3P][ipCH2] += e_CH3P_CH2_H;
	
	/* >>refer	mol	e	CH3+	=>	CH	H	H	UMIST	*/
		
	mole.c[ipCH3P][ipCH3P] -= e_CH3P_CH_H_H;
	mole.c[ipCH3P][ipCH] += e_CH3P_CH_H_H;
	
	/* >>refer	mol	e	CH3+	=>	CH	H2	UMIST	*/
		
	mole.c[ipCH3P][ipCH3P] -= e_CH3P_CH_H2;
	mole.c[ipCH3P][ipCH] += e_CH3P_CH_H2;
	
	/* >>refer	mol	e	CH3+	=>	CH3	PHOTON	UMIST	*/
		
	mole.c[ipCH3P][ipCH3P] -= e_CH3P_CH3_nu;
	mole.c[ipCH3P][ipCH3]   += e_CH3P_CH3_nu;

	/* >>refer	mol	e	CO+	=>	C	O	UMIST	*/
	
	mole.c[ipCOP][ipCOP] -= e_COP_O_C;
	mole.c[ipCOP][ipATC] += e_COP_O_C;
	mole.c[ipCOP][ipATO] += e_COP_O_C;
		
	/* >>refer	mol	e	H2O+	=>	OH	H	UMIST	*/
		
	mole.c[ipH2OP][ipH2OP] -= e_H2OP_OH_H;
	mole.c[ipH2OP][ipOH] += e_H2OP_OH_H;
	
	/* >>refer	mol	e	H2O+	=>	O	H	H	UMIST	*/
		
	mole.c[ipH2OP][ipH2OP] -= e_H2OP_O_H_H;
	mole.c[ipH2OP][ipATO] += e_H2OP_O_H_H;
	
	/* >>refer	mol	e	H2O+	=>	O	H2	UMIST	*/
		
	mole.c[ipH2OP][ipH2OP] -= e_H2OP_O_H2;
	mole.c[ipH2OP][ipATO] += e_H2OP_O_H2;
	
	/* >>refer	mol	e	H3O+	=>	H2O	H	UMIST	*/
		
	mole.c[ipH3OP][ipH3OP] -= e_H3OP_H2O_H;
	mole.c[ipH3OP][ipH2O] += e_H3OP_H2O_H;
	
	/* >>refer	mol	e	H3O+	=>	OH	H	H	UMIST	*/
		
	mole.c[ipH3OP][ipH3OP] -= e_H3OP_OH_H_H;
	mole.c[ipH3OP][ipOH] += e_H3OP_OH_H_H;
	
	/* >>refer	mol	e	H3O+	=>	OH	H2	UMIST	*/
		
	mole.c[ipH3OP][ipH3OP] -= e_H3OP_OH_H2;
	mole.c[ipH3OP][ipOH] += e_H3OP_OH_H2;
	
	/* >>refer	mol	e	H3O+	=>	O	H2	H	UMIST	*/
		
	mole.c[ipH3OP][ipH3OP] -= e_H3OP_O_H2_H;
	mole.c[ipH3OP][ipATO] += e_H3OP_O_H2_H;
	
	/* >>refer	mol	e	O2+	=>	O	O	UMIST	*/
	
	mole.c[ipO2P][ipO2P] -= e_O2P_O_O;
	mole.c[ipO2P][ipATO] += 2*e_O2P_O_O;
	
	/* >>refer	mol	e	OH+	=>	O	H	UMIST	*/
	
	mole.c[ipOHP][ipOHP] -= e_OHP_O_H;
	mole.c[ipOHP][ipATO] += e_OHP_O_H;
	
	/* >>refer	mol	e	SiH2+	=>	SiH	H	UMIST	*/
		
	mole.c[ipSIH2P][ipSIH2P] -= e_SiH2P_SiH_H;
	mole.c[ipSIH2P][ipSIH] += e_SiH2P_SiH_H;
	
	/* >>refer	mol	e	SiH2+	=>	Si	H	H	UMIST	*/
		
	mole.c[ipSIH2P][ipSIH2P] -= e_SiH2P_Si_H_H;
	mole.c[ipSIH2P][ipATSI] += e_SiH2P_Si_H_H;
	
	/* >>refer	mol	e	SiH2+	=>	Si	H2	UMIST	*/
		
	mole.c[ipSIH2P][ipSIH2P] -= e_SiH2P_Si_H2;
	mole.c[ipSIH2P][ipATSI] += e_SiH2P_Si_H2;
	
	/* >>refer	mol	e	SiO+	=>	Si	O	UMIST	*/
		
	mole.c[ipSIOP][ipSIOP] -= e_SiOP_Si_O;
	mole.c[ipSIOP][ipATSI] += e_SiOP_Si_O;
	mole.c[ipSIOP][ipATO] += e_SiOP_Si_O;
	
	/* >>refer	mol	e	SiOH+	=>	SiO	H	UMIST	*/
		
	mole.c[ipHOSIP][ipHOSIP] -= e_SiOHP_SiO_H;
	mole.c[ipHOSIP][ipSIO] += e_SiOHP_SiO_H;
	
	/* >>refer	mol	e	SiOH+	=>	Si	OH	UMIST	*/
		
	mole.c[ipHOSIP][ipHOSIP] -= e_SiOHP_Si_OH;
	mole.c[ipHOSIP][ipOH] += e_SiOHP_Si_OH;
	mole.c[ipHOSIP][ipATSI] += e_SiOHP_Si_OH;

		/* >>refer mol   e CH5P  =>  CH3 H2   UMIST    */
	mole.c[ipCH5P][ipCH5P]  -=  e_CH5P_CH3_H2;
	mole.c[ipCH5P][ipCH3]  +=  e_CH5P_CH3_H2;
	
	/* >>refer mol   e CH5P  =>  CH4 H   UMIST    */
	mole.c[ipCH5P][ipCH5P]  -=  e_CH5P_CH4_H;
	mole.c[ipCH5P][ipCH4]  +=  e_CH5P_CH4_H;
	
	/* >>refer mol   e CH4P  =>  CH3 H   UMIST    */
	mole.c[ipCH4P][ipCH4P]  -=  e_CH4P_CH3_H;
	mole.c[ipCH4P][ipCH3]  +=  e_CH4P_CH3_H;

	/* >>refer mol   e CH4P  =>  CH2 H	H   UMIST    */
	mole.c[ipCH4P][ipCH4P]  -=  e_CH4P_CH2_H_H;
	mole.c[ipCH4P][ipCH2]   +=  e_CH4P_CH2_H_H;


	/* >>refer	mol	C2+		e	=>		C		C		UMIST	*/
	
	mole.c[ipC2P][ipC2P] -= C2P_e_C_C;
	mole.c[ipC2P][ipATC]  += C2P_e_C_C;
	mole.c[ipC2P][ipATC]  += C2P_e_C_C;

	/*  >>refer   mol  NH+    +  e     =>   N     +     H     UMIST  */

	mole.c[ipNHP][ipNHP] -= NHP_e_N_H;
	mole.c[ipNHP][ipATN] += NHP_e_N_H;

	/*  >>refer   mol  NH2+   +  e     =>   N     +     H  +  H      UMIST  */

	mole.c[ipNH2P][ipNH2P] -= NH2P_e_N_H_H;
	mole.c[ipNH2P][ipATN] += NH2P_e_N_H_H;

	/*  >>refer   mol  NH2+   +  e     =>   NH    +     H     UMIST  */

	mole.c[ipNH2P][ipNH2P] -= NH2P_e_NH_H;
	mole.c[ipNH2P][ipNH] += NH2P_e_NH_H;

	/*  >>refer   mol  NH3+   +  e     =>   NH    +     H  +  H      UMIST  */

	mole.c[ipNH3P][ipNH3P] -= NH3P_e_NH_H_H;
	mole.c[ipNH3P][ipNH] += NH3P_e_NH_H_H;

	/*  >>refer   mol  NH3+   +  e     =>   NH2   +     H     UMIST  */

	mole.c[ipNH3P][ipNH3P] -= NH3P_e_NH2_H;
	mole.c[ipNH3P][ipNH2] += NH3P_e_NH2_H;

	/*  >>refer   mol  NH4+   +  e     =>   NH2   +     H  +  H      UMIST  */

	mole.c[ipNH4P][ipNH4P] -= NH4P_e_NH2_H_H;
	mole.c[ipNH4P][ipNH2] += NH4P_e_NH2_H_H;

	/*  >>refer   mol  NH4+   +  e     =>   NH2   +     H2    UMIST  */

	mole.c[ipNH4P][ipNH4P] -= NH4P_e_NH2_H2;
	mole.c[ipNH4P][ipNH2] += NH4P_e_NH2_H2;

	/*  >>refer   mol  NH4+   +  e     =>   NH3   +     H     UMIST  */

	mole.c[ipNH4P][ipNH4P] -= NH4P_e_NH3_H;
	mole.c[ipNH4P][ipNH3] += NH4P_e_NH3_H;

	/*  >>refer   mol  CN+    +  e     =>   N     +     C     UMIST  */

	mole.c[ipCNP][ipCNP] -= CNP_e_N_C;
	mole.c[ipCNP][ipATN] += CNP_e_N_C;
	mole.c[ipCNP][ipATO] += CNP_e_N_C;

	/*  >>refer   mol  HCN+   +  e     =>   CN    +     H     UMIST  */

	mole.c[ipHCNP][ipHCNP] -= HCNP_e_CN_H;
	mole.c[ipHCNP][ipCN] += HCNP_e_CN_H;

	/*  >>refer   mol  N2+    +  e     =>   N     +     N     UMIST  */

	mole.c[ipN2P][ipN2P] -= N2P_e_N_N;
	mole.c[ipN2P][ipATN] += 2*N2P_e_N_N;

	/*  >>refer   mol  NO+    +  e     =>   O     +     N     UMIST  */

	mole.c[ipNOP][ipNOP] -= NOP_e_O_N;
	mole.c[ipNOP][ipATO] += NOP_e_O_N;
	mole.c[ipNOP][ipATN] += NOP_e_O_N;

	/*  >>refer   mol  HNO+   +  e     =>   NO    +     H     UMIST  */

	mole.c[ipHNOP][ipHNOP] -= HNOP_e_NO_H;
	mole.c[ipHNOP][ipNO] += HNOP_e_NO_H;

	/*  >>refer   mol  HS+    +  e     =>   S     +     H     UMIST  */

	mole.c[ipHSP][ipHSP] -= HSP_e_S_H;
	mole.c[ipHSP][ipATS] += HSP_e_S_H;

	/*  >>refer   mol  SIN+   +  e     =>   SI    +     N     UMIST  */

	mole.c[ipSINP][ipSINP] -= SINP_e_SI_N;
	mole.c[ipSINP][ipATSI] += SINP_e_SI_N;
	mole.c[ipSINP][ipATN] += SINP_e_SI_N;

	/*  >>refer   mol  CS+    +  e     =>   S     +     C     UMIST  */

	mole.c[ipCSP][ipCSP] -= CSP_e_S_C;
	mole.c[ipCSP][ipATS] += CSP_e_S_C;
	mole.c[ipCSP][ipATC] += CSP_e_S_C;

	/*  >>refer   mol  HCS+   +  e     =>   CS    +     H     UMIST  */

	mole.c[ipHCSP][ipHCSP] -= HCSP_e_CS_H;
	mole.c[ipHCSP][ipCS] += HCSP_e_CS_H;

	/*  >>refer   mol  NO2+   +  e     =>   NO    +     O     UMIST  */

	mole.c[ipNO2P][ipNO2P] -= NO2P_e_NO_O;
	mole.c[ipNO2P][ipNO] += NO2P_e_NO_O;
	mole.c[ipNO2P][ipATO] += NO2P_e_NO_O;

	/*  >>refer   mol  NS+    +  e     =>   S     +     N     UMIST  */

	mole.c[ipNSP][ipNSP] -= NSP_e_S_N;
	mole.c[ipNSP][ipATO] += NSP_e_S_N;
	mole.c[ipNSP][ipATS] += NSP_e_S_N;

	/*  >>refer   mol  SO+    +  e     =>   S     +     O     UMIST  */

	mole.c[ipSOP][ipSOP] -= SOP_e_S_O;
	mole.c[ipSOP][ipATO] += SOP_e_S_O;
	mole.c[ipSOP][ipATS] += SOP_e_S_O;

	/*  >>refer   mol  OCS+   +  e     =>   CS    +     O     UMIST  */

	mole.c[ipOCSP][ipOCSP] -= OCSP_e_CS_O;
	mole.c[ipOCSP][ipCS] += OCSP_e_CS_O;
	mole.c[ipOCSP][ipATO] += OCSP_e_CS_O;

	/*  >>refer   mol  S2+    +  e     =>   S     +     S     UMIST  */

	mole.c[ipS2P][ipS2P] -= S2P_e_S_S;
	mole.c[ipS2P][ipATS] += 2*S2P_e_S_S;

	/*  >>refer   mol  HCl+    +  e     =>   Cl    +     H    UMIST  */

	mole.c[ipHClP][ipHClP] -= HClP_e_Cl_H;
	mole.c[ipHClP][ipATCl] += HClP_e_Cl_H;

	/*  >>refer   mol  H2Cl+    +  e     =>   Cl    +     2H     UMIST  */

	mole.c[ipH2ClP][ipH2ClP] -= H2ClP_e_Cl_H_H;
	mole.c[ipH2ClP][ipATCl] += H2ClP_e_Cl_H_H;

	/*  >>refer   mol  H2Cl+    +  e     =>   HCl    +     H    UMIST  */

	mole.c[ipH2ClP][ipH2ClP] -= H2ClP_e_HCl_H;
	mole.c[ipH2ClP][ipHCl] += H2ClP_e_HCl_H;

	/*  >>refer   mol  CCl+    +  e     =>   Cl    +     C     UMIST  */

	mole.c[ipCClP][ipCClP] -= CClP_e_Cl_C;
	mole.c[ipCClP][ipATCl] += CClP_e_Cl_C;
	mole.c[ipCClP][ipATC] += CClP_e_Cl_C;

	/*  >>refer   mol  H2CCl+    +  e     =>   CCl    +     2H     UMIST  */

	mole.c[ipH2CClP][ipH2CClP] -= H2CClP_e_CCl_H_H;
	mole.c[ipH2CClP][ipCCl] += H2CClP_e_CCl_H_H;

	/*  >>refer   mol  ClO+    +  e     =>   Cl    +     O    UMIST  */

	mole.c[ipClOP][ipClOP] -= ClOP_e_Cl_O;
	mole.c[ipClOP][ipATCl] += ClOP_e_Cl_O;
	mole.c[ipClOP][ipATO] += ClOP_e_Cl_O;

	/*  >>refer  mol  HCNHP   +   e   =   HNC   +   H   */

	mole.c[ipHCNHP][ipHCNHP] -= HCNHP_e_HCN_H; 
	mole.c[ipHCNHP][ipHNC] += HCNHP_e_HCN_H;
		
	/*  >>refer  mol  HCNHP   +   e   =   CN   +   H   +   H */

	mole.c[ipHCNHP][ipHCNHP] -= HCNHP_e_CN_H_H; 
	mole.c[ipHCNHP][ipCN] += HCNHP_e_CN_H_H; 

	/*  >>refer  mol  HCNHP   +   e   =   HCN   +   H   */

	mole.c[ipHCNHP][ipHCNHP] -= HCNHP_e_HNC_H; 
	mole.c[ipHCNHP][ipHNC] += HCNHP_e_HNC_H; 


	/* >>refer	mol	N+ + e => N	 Done internally by Cloudy*/
	/* Recombination of N+ */
	mole.c[ipNP][ipNP] -= (ionbal.RateRecomTot[ipNITROGEN][0]+gv.GrainChTrRate[ipNITROGEN][1][0]);
	mole.c[ipNP][ipATN] += (ionbal.RateRecomTot[ipNITROGEN][0]+gv.GrainChTrRate[ipNITROGEN][1][0]);

	
	/* >>refer	mol	S+ + e => S	 Done internally by Cloudy*/

	/* Recombination of S+ */
	mole.c[ipSP][ipSP] -= (ionbal.RateRecomTot[ipSULPHUR][0]+gv.GrainChTrRate[ipSULPHUR][1][0]);
	mole.c[ipSP][ipATS] += (ionbal.RateRecomTot[ipSULPHUR][0]+gv.GrainChTrRate[ipSULPHUR][1][0]);


	/* >>refer	mol	Cl+ + e => Cl	 Done internally by Cloudy*/

	/* Recombination of S+ */
	mole.c[ipClP][ipClP] -= (ionbal.RateRecomTot[ipCHLORINE][0]+gv.GrainChTrRate[ipCHLORINE][1][0]);
	mole.c[ipClP][ipATCl] += (ionbal.RateRecomTot[ipCHLORINE][0]+gv.GrainChTrRate[ipCHLORINE][1][0]);

	
	/* >>refer	mol	C+ + e => C	 Done internally by Cloudy*/
	/* Recombination of C+ */
	mole.c[ipCP][ipCP] -= (ionbal.RateRecomTot[ipCARBON][0]+gv.GrainChTrRate[ipCARBON][1][0]);
	mole.c[ipCP][ipATC] += (ionbal.RateRecomTot[ipCARBON][0]+gv.GrainChTrRate[ipCARBON][1][0]);


	/* >>refer	mol	O+ + e => O	 Done internally by Cloudy*/

	/* Recombination of O+ */
	mole.c[ipOP][ipOP] -= (ionbal.RateRecomTot[ipOXYGEN][0]+gv.GrainChTrRate[ipOXYGEN][1][0]);
	mole.c[ipOP][ipATO] += (ionbal.RateRecomTot[ipOXYGEN][0]+gv.GrainChTrRate[ipOXYGEN][1][0]);

	/* >>refer	mol	Si+ + e => Si	 Done internally by Cloudy*/

	/* Recombination of Si+ */
	mole.c[ipSIP][ipSIP] -= (ionbal.RateRecomTot[ipSILICON][0]+gv.GrainChTrRate[ipSILICON][1][0]);
	mole.c[ipSIP][ipATSI] += (ionbal.RateRecomTot[ipSILICON][0]+gv.GrainChTrRate[ipSILICON][1][0]);

	/* >>refer  mole   C2H+   e-   -->   CH   C        */

	mole.c[ipC2HP][ipC2HP] -= C2HP_e_CH_C;
	mole.c[ipC2HP][ipCH] += C2HP_e_CH_C;
	mole.c[ipC2HP][ipATC] += C2HP_e_CH_C;

	/* >>refer  mole   C2H+   e-   -->   C2   H        */

	mole.c[ipC2HP][ipC2HP] -= C2HP_e_C2_H;
	mole.c[ipC2HP][ipC2] += C2HP_e_C2_H;
	
	/* >>refer  mole   C3+   e-   -->   C2   C        */

	mole.c[ipC3P][ipC3P] -= C3P_e_C2_C;
	mole.c[ipC3P][ipC2] += C3P_e_C2_C;
	mole.c[ipC3P][ipATC] += C3P_e_C2_C;


	/* >>refer  mole   C2H2+   e-   -->   C2   H   H     */

	mole.c[ipC2H2P][ipC2H2P] -= C2H2P_e_C2_H_H;
	mole.c[ipC2H2P][ipC2] += C2H2P_e_C2_H_H;

	/* >>refer  mole   C2H2+   e-   -->   CH   CH        */

	mole.c[ipC2H2P][ipC2H2P] -= C2H2P_e_CH_CH;
	mole.c[ipC2H2P][ipCH] +=  2*C2H2P_e_CH_CH;

	/* >>refer  mole   C2H2+   e-   -->   C2H   H        */

	mole.c[ipC2H2P][ipC2H2P] -=  C2H2P_e_C2H_H;
	mole.c[ipC2H2P][ipC2H] +=  C2H2P_e_C2H_H;
	
	/* >>refer  mole   C3H+   e-   -->   C2H   C        */

	mole.c[ipC3HP][ipC3HP] -= C3HP_e_C2H_C;
	mole.c[ipC3HP][ipC2H] += C3HP_e_C2H_C;
	mole.c[ipC3HP][ipATC] += C3HP_e_C2H_C;

	/* >>refer  mole   C3H+   e-   -->   C3   H        */
	
	mole.c[ipC3HP][ipC3HP] -= C3HP_e_C3_H;
	mole.c[ipC3HP][ipC3] += C3HP_e_C3_H;

	/* >>refer  mole   C2H3+   e-   -->   C2H2   H        */

	mole.c[ipC2H3P][ipC2H3P] -= C2H3P_e_C2H2_H;
	mole.c[ipC2H3P][ipC2H2] += C2H3P_e_C2H2_H;
	

}

