/* This file is part of Cloudy and is copyright (C)1978-2006 by Gary J. Ferland
 * For conditions of distribution and use see copyright notice in license.txt */
/* magnetic.h */

/*ParseMagnet parse magnetic field command  */
void ParseMagnet(char *chCard );

/* Magnetic_init initialize magnetic field parameters */
void Magnetic_init(void);

/*Magnetic_reinit - reinitialized magnetic field at start of new iteration */
void Magnetic_reinit(void);

/*Magnetic_evaluate evaluate some parameters to do with magnetic field */
void Magnetic_evaluate(void);

EXTERN struct t_nagnet {

	/* this says mag fields are turned on */
	int lgB;

	/* enthalpy density associated with field */
	double EnthalpyDensity;

	/* this is magnetic pressure at current location - this can be negative for ordered field */
	double pressure;

	/* energy density at current location, this is positive */
	double energydensity;

	}	magnetic;

