/* This file is part of Cloudy and is copyright (C)1978-2006 by Gary J. Ferland
 * For conditions of distribution and use see copyright notice in license.txt */
/*IonVanad do ionization balance for vanadium */
#include "cddefines.h"
#ifdef NDIM
#	undef NDIM
#endif
#ifdef NELEM
#	undef NELEM
#endif
#define	NDIM	24
#define	NELEM	23
#include "dense.h"
#include "ionbal.h"

void IonVanad(void)
{
	long int i, 
	  _r;
	static double dicoef[2][NDIM - 1], 
	  dite[2][NDIM - 1];
	static double ditcrt[NDIM - 1]={6e3,2e4,4e4,5e4,7e4,8e4,8e4,3e4,
	  3e4,3e4,3e4,9e4,4e4,5e4,3e4,9e5,2e5,2e5,2e5,2e5,1e5,7e4,1e20};
	static double aa[NDIM - 1]={0.,0.,0.,0.,0.,0.,0.,0.,0.,0.,0.,0.,
	  0.,0.,0.,0.,0.,0.,0.,0.,0.,0.,0.};
	static double bb[NDIM - 1]={0.,0.,0.,0.,0.,0.,0.,0.,0.,0.,0.,0.,
	  0.,0.,0.,0.,0.,0.,0.,0.,0.,0.,0.};
	static double cc[NDIM - 1]={0.,0.,0.,0.,0.,0.,0.,0.,0.,0.,0.,0.,
	  0.,0.,0.,0.,0.,0.,0.,0.,0.,0.,0.};
	static double dd[NDIM - 1]={0.,0.,0.,0.,0.,0.,0.,0.,0.,0.,0.,0.,
	  0.,0.,0.,0.,0.,0.,0.,0.,0.,0.,0.};
	static double ff[NDIM - 1]={0.,0.,0.,0.,0.,0.,0.,0.,0.,0.,0.,0.,
	  0.,0.,0.,0.,0.,0.,0.,0.,0.,0.,0.};
	static int _aini = 1;
	if( _aini ){ /* Do 1 TIME INITIALIZATIONS! */
		{ static double _itmp2[] = {1.58e-3,8.38e-3,1.54e-2,3.75e-2,
		  0.117,0.254,0.291,0.150,0.140,0.100,0.200,0.240,0.260,0.190,
		  0.120,0.350,0.066,0.10,0.13,0.23,0.14,0.11,0.};
		for( i=1, _r = 0; i <= (NDIM - 1); i++ )
		{
			dicoef[0][i-1] = _itmp2[_r++];
			}
		}
		{ static double _itmp3[] = {.456,.323,.310,.411,.359,.0975,
		  .229,4.20,3.30,5.30,1.50,0.700,.600,.5,1.,0.,7.8,6.3,5.5,
		  3.6,4.9,1.6,0.};
		for( i=1, _r = 0; i <= (NDIM - 1); i++ )
		{
			dicoef[1][i-1] = _itmp3[_r++];
			}
		}
		{ static double _itmp4[] = {6.00e4,1.94e5,3.31e5,4.32e5,6.28e5,
		  7.50e5,7.73e5,2.62e5,2.50e5,2.57e5,2.84e5,8.69e5,4.21e5,
		  4.57e5,2.85e5,8.18e5,1.51e6,1.30e6,1.19e6,1.09e6,9.62e5,
		  7.23e5,0.};
		for( i=1, _r = 0; i <= (NDIM - 1); i++ )
		{
			dite[0][i-1] = _itmp4[_r++];
			}
		}
		{ static double _itmp5[] = {8.97e4,1.71e5,2.73e5,3.49e5,5.29e5,
		  4.69e5,6.54e5,1.32e6,1.33e6,1.41e6,1.52e6,1.51e6,1.82e6,
		  1.84e6,2.31e6,0.,9.98e6,9.98e6,1.00e7,1.10e7,8.34e6,1.01e7,
		  0.};
		for( i=1, _r = 0; i <= (NDIM - 1); i++ )
		{
			dite[1][i-1] = _itmp5[_r++];
			}
		}
		_aini = 0;
	}

#	ifdef DEBUG_FUN
	fputs( "<+>IonVanad()\n", debug_fp );
#	endif

	/* chromium nelem=23
	 * based on iron
	 *
	 * Fe rates from Woods et al. Ap.J. 249, 399.
	 * rec from +23, 24 25 from Arnauld et al 85 */

	/* Pequignot and Aldrovandi Ast Ap 161, 169. */

	if( !dense.lgElmtOn[NELEM-1] )
	{
		
#		ifdef DEBUG_FUN
		fputs( " <->IonVanad()\n", debug_fp );
#		endif
		return;
	}

	ion_zero(NELEM-1);

	ion_photo(NELEM-1,FALSE);

	/* find collisional ionization rates */
	ion_collis(NELEM-1);

	/* get recombination coefficients */
	ion_recomb(FALSE,(double*)dicoef,(double*)dite,ditcrt,aa,bb,cc,
	  dd,ff,NELEM-1);

	/* solve for ionization balance */
	ion_solver(NELEM-1,FALSE);

#	ifdef DEBUG_FUN
	fputs( " <->IonVanad()\n", debug_fp );
#	endif
	return;
}

