/* This file is part of Cloudy and is copyright (C)1978-2006 by Gary J. Ferland
 * For conditions of distribution and use see copyright notice in license.txt */
/*IonHelium solve ionization balance for helium */
#include "cddefines.h"
#include "dense.h"
#include "trace.h"
#include "iso.h"
#include "ionbal.h"

void IonHelium( void )
{
	int lgDebugPrint=FALSE;

#	ifdef DEBUG_FUN
	fputs( "<+>IonHelium()\n", debug_fp );
#	endif

	/* option to "turn off" helium */
	if( !dense.lgElmtOn[ipHELIUM] )
	{
		dense.xIonDense[ipHELIUM][0] = 0.;
		dense.xIonDense[ipHELIUM][1] = 0.;
		dense.xIonDense[ipHELIUM][2] = 0.;
		
#		ifdef DEBUG_FUN
		fputs( " <->IonHelium()\n", debug_fp );
#		endif
		return;
	}

	/* populations */
	/* >>chng 01 may 09, add option to set ionization with element name ioniz cmnd */
	if( dense.lgSetIoniz[ipHELIUM] )
	{
		dense.xIonDense[ipHELIUM][2] = dense.SetIoniz[ipHELIUM][2]*dense.gas_phase[ipHELIUM];
		dense.xIonDense[ipHELIUM][1] = dense.SetIoniz[ipHELIUM][1]*dense.gas_phase[ipHELIUM];
		dense.xIonDense[ipHELIUM][0] = dense.SetIoniz[ipHELIUM][0]*dense.gas_phase[ipHELIUM];
		
#		ifdef DEBUG_FUN
		fputs( " <->IonHelium()\n", debug_fp );
#		endif
		return;
	}

	lgDebugPrint = FALSE;
#	if 0
	if( nzone > 197 )
		lgDebugPrint = TRUE;
#	endif

	/* find ionization balance */
	ion_solver( ipHELIUM , lgDebugPrint );

	if( trace.lgHeBug )
	{
		fprintf( ioQQQ, "     IonHelium returns;  He0:%.4e He+:%.4e He+2:%.4e",
			dense.xIonDense[ipHELIUM][0]/dense.gas_phase[ipHELIUM] ,
			dense.xIonDense[ipHELIUM][1]/dense.gas_phase[ipHELIUM] ,
			dense.xIonDense[ipHELIUM][2]/dense.gas_phase[ipHELIUM] );

		fprintf( ioQQQ, "     He+/0:%s %.2e smp:%.2e rec:%.2e ion:%.2e ",
			iso.chTypeAtomUsed[ipHE_LIKE][ipHELIUM],
			iso.pop_ion_ov_neut[ipHE_LIKE][ipHELIUM] ,
			iso.xIonSimple[ipHE_LIKE][ipHELIUM],
			ionbal.RateRecomTot[ipHELIUM][0],
			iso.RateLevel2Cont[ipHE_LIKE][ipHELIUM][ipH1s] );

		fprintf( ioQQQ, " He+/+2:%s %.4e smp:%.4e rec:%.4e ion:%.4e rad rec:%.4e",
			iso.chTypeAtomUsed[ipH_LIKE][ipHELIUM],
			iso.pop_ion_ov_neut[ipH_LIKE][ipHELIUM] ,
			iso.xIonSimple[ipH_LIKE][ipHELIUM] ,
			ionbal.RateRecomTot[ipHELIUM][1],
			iso.RateLevel2Cont[ipH_LIKE][ipHELIUM][ipH1s] ,
			ionbal.RR_rate_coef_used[ipHELIUM][1] );

		fprintf( ioQQQ, "\n" );
	}

#	ifdef DEBUG_FUN
	fputs( " <->IonHelium()\n", debug_fp );
#	endif

	return;
}

