/* This file is part of Cloudy and is copyright (C)1978-2006 by Gary J. Ferland
 * For conditions of distribution and use see copyright notice in license.txt */
/*IonFluor compute ionization balance for fluorine */
#include "cddefines.h"
#ifdef NDIM
#	undef NDIM
#endif
#ifdef NELEM
#	undef NELEM
#endif
#define	NDIM	10
#define	NELEM	9
#include "dense.h"
#include "ionbal.h"

void IonFluor(void)
{
	long int i, 
	  _r;
	static double dicoef[2][NDIM - 1], 
	  dite[2][NDIM - 1];
	static double aa[NDIM - 1]={0.,0.0129,3.6781,-0.0254,-0.0141,19.9280,
	  0.,0.,0.};
	static double bb[NDIM - 1]={0.,-0.1779,14.1481,5.5365,33.8479,235.0536,
	  0.,0.,0.};
	static double cc[NDIM - 1]={0.,0.9353,17.1175,17.0727,43.1608,152.5096,
	  0.,0.,0.};
	static double dd[NDIM - 1]={0.,-0.0682,-0.5017,-0.7225,-1.6072,
	  9.1413,0.,0.,0.};
	static double ff[NDIM - 1]={0.,0.4516,0.2313,0.1702,0.1942,0.1282,
	  0.,0.,0.};
	static double ditcrt[NDIM - 1]={3.0e4,3.3e4,3.3e4,3.5e4,3.6e4,3.6e4,
	  2.9e4,1.5e6,1e20};
	static int _aini = 1;
	if( _aini ){ /* Do 1 TIME INITIALIZATIONS! */
		{ static double _itmp2[] = {9.77e-4,2.65e-3,3.69e-3,1.12e-2,
		  2.44e-2,3.02e-2,6.10e-3,2.52e-1,0.};
		for( i=1, _r = 0; i <= (NDIM - 1); i++ )
		{
			dicoef[0][i-1] = _itmp2[_r++];
			}
		}
		{ static double _itmp3[] = {.073,.242,1.01,.391,2.52,.445,.254,
		  .304,0.};
		for( i=1, _r = 0; i <= (NDIM - 1); i++ )
		{
			dicoef[1][i-1] = _itmp3[_r++];
			}
		}
		{ static double _itmp4[] = {3.11e5,2.84e5,2.24e5,2.7e5,3.09e5,
		  2.83e5,1.68e5,1.4e7,0.};
		for( i=1, _r = 0; i <= (NDIM - 1); i++ )
		{
			dite[0][i-1] = _itmp4[_r++];
			}
		}
		{ static double _itmp5[] = {2.06e5,3.07e5,2.94e5,5.50e5,9.91e5,
		  1.73e6,6.13e5,1.80e6,0.};
		for( i=1, _r = 0; i <= (NDIM - 1); i++ )
		{
			dite[1][i-1] = _itmp5[_r++];
			}
		}
		_aini = 0;
	}

#	ifdef DEBUG_FUN
	fputs( "<+>IonFluor()\n", debug_fp );
#	endif

	/* fluorine, nelem=9
	 * rec data from neon
	 *
	 * rates from Shull and van Steenberg, Ap.J. Sup 48, 95. */

	/* rec from +7, +8 fro Arnaud et al 85 */
	/* Pequignot and Aldrovandi Ast Ap 161, 169. */

	/* fluorine, atomic number 9 */
	if( !dense.lgElmtOn[NELEM-1] )
	{
		
#		ifdef DEBUG_FUN
		fputs( " <->IonFluor()\n", debug_fp );
#		endif
		return;
	}

	ion_zero(NELEM-1);

	ion_photo(NELEM-1,FALSE);

	/* find collisional ionization rates */
	ion_collis(NELEM-1);

	/* get recombination coefficients */
	ion_recomb(FALSE,(double*)dicoef,(double*)dite,ditcrt,aa,bb,cc,
	  dd,ff,NELEM-1);

	/* solve for ionization balance */
	ion_solver(NELEM-1,FALSE);

#	ifdef DEBUG_FUN
	fputs( " <->IonFluor()\n", debug_fp );
#	endif
	return;
}

