/* This file is part of Cloudy and is copyright (C)1978-2006 by Gary J. Ferland
 * For conditions of distribution and use see copyright notice in license.txt */
/* HyperfineCS - returns interpolated collision strength for element nelem and ion ion */
/* HyperfineCreate - read in data files and create space for hyperfine lines,
 * called by atmdat_readin at start of calculation */
/*H21cm_H_atom computes rate for H 21 cm from upper to lower excitation by atomic hydrogen 
 * from */
/*H21cm_electron computes rate for H 21 cm from upper to lower excitation by electrons */
/* H21_cm_pops - fine level populations for 21 cm with Lya pumping included */

/* HyperfineCreate - read in data files and create space for hyperfine lines,
 * called by atmdat_readin at start of calculation */
void HyperfineCreate(void);

/* HyperfineCS - returns interpolated collision strength for element nelem and ion ion */
/*double HyperfineCS( long nelem , long ion );*/
double HyperfineCS(  long i  );

/* H21_cm_pops - fine level populations for 21 cm with Lya pumping included */
void H21_cm_pops( void );

/*H21cm_H_atom computes rate for H 21 cm from upper to lower excitation by atomic hydrogen 
 * from 
 * >>refer	H1	cs	Allison, A.C. & Dalgarno, A., 1969, ApJ 158, 423 */
double H21cm_H_atom( double temp );

/*H21cm_electron computes rate for H 21 cm from upper to lower excitation by electrons 
 * >>refer	H1	cs	Smith, F.J., 1966, Planet. Space Sci 14, 929 */
double H21cm_electron( double temp );

EXTERN struct t_hyperfine {

	/* the isotope abundances relative to main species abundances, as read in from the hyperfine.dat file */
	float *HFLabundance;

	/* this is the computed 21cm spin temperature */
	double Tspin21cm;

	/* option to turn off Lya pumping of 21 cm */
	int lgLya_pump_21cm;

	/* total cooling due to all hyperfine lines */
	double cooling_total;

	/* largest relative cooling due to hyperfine structure lines */
	float cooling_max;

	}	hyperfine;
