/* This file is part of Cloudy and is copyright (C)1978-2006 by Gary J. Ferland
 * For conditions of distribution and use see copyright notice in license.txt */
/* doppvel.h */
EXTERN struct t_DoppVel {
	/*
	 *doppler width for each element, cm/sec including turbulent,
	 *as set in routine velset, extra elements are 12CO, 13CO, and H2 
	 */
	float doppler[LIMELM+3];

	/* average velocity of atoms/ions in gas, for grain charging and heating */
	double AveVel[LIMELM+3];

	/* this is the turbulent velocity in cm/s, normally zero, set with
	 * turbulence command */
	float TurbVel;

	/* equipartition option on turbulence command, to set turbulence from B 
	 * if true then TurbVel set from B */
	int lgTurbEquiMag;

	/* The scale in cm over which the turbulence is dissipated.  Normally 0,
	 * only set if dissipate keyword appears on turbulence command, 
	 * entered as log of scale */
	float DispScale;

	}	DoppVel;


