/* This file is part of Cloudy and is copyright (C)1978-2006 by Gary J. Ferland
 * For conditions of distribution and use see copyright notice in license.txt */
/*ContNegative sanity check for negative continuum intensities */
#include "cddefines.h"
#include "rfield.h"
#include "dense.h"
#include "phycon.h"
#include "continuum.h"

void ContNegative(void)
{
	int lgFNeg;
	long int i;

#	ifdef DEBUG_FUN
	fputs( "<+>ContNegative()\n", debug_fp );
#	endif

	/* look for negative continuum points */
	lgFNeg = FALSE;
	for( i=0; i < rfield.nflux; i++ )
	{
		if( rfield.flux[i] < 0. )
		{
			fprintf( ioQQQ, " FLUX negative, value, freq, pointer=%10.2e%10.2e%5ld %4.4s %4.4s\n", 
			  rfield.flux[i], rfield.anu[i], i, rfield.chLineLabel[i]
			  , rfield.chContLabel[i] );
			lgFNeg = TRUE;
		}
		else if( rfield.otslin[i] < 0. )
		{
			fprintf( ioQQQ, " OTSLIN negative, value, freq, pointer=%10.2e%10.2e%5ld\n", 
			  rfield.otslin[i], rfield.anu[i], i );
			lgFNeg = TRUE;
		}
		else if( rfield.otscon[i] < 0. )
		{
			fprintf( ioQQQ, " OTSCON negative, value, freq, pointer=%10.2e%10.2e%5ld\n", 
			  rfield.otscon[i], rfield.anu[i], i );
			lgFNeg = TRUE;
		}
		else if( rfield.SummedCon[i] < 0. )
		{
			fprintf( ioQQQ, " OUTCON negative, value, freq, pointer=%10.2e%10.2e%5ld\n", 
			  rfield.ConInterOut[i], rfield.anu[i], i );
			lgFNeg = TRUE;
		}
		else if( rfield.ConInterOut[i] < 0. )
		{
			fprintf( ioQQQ, " OUTCON negative, value, freq, pointer=%10.2e%10.2e%5ld\n", 
			  rfield.ConInterOut[i], rfield.anu[i], i );
			lgFNeg = TRUE;
		}
		else if( rfield.outlin[i] < 0. )
		{
			fprintf( ioQQQ, " OUTLIN negative, value, freq, pointer=%10.2e%10.2e%5ld\n", 
			  rfield.outlin[i], rfield.anu[i], i );
			lgFNeg = TRUE;
		}
	}

	if( !lgFNeg )
	{
		fprintf( ioQQQ, " No parts of the continuum were negative, the electron density was%10.2e te=%10.2e\n", 
		  dense.eden, phycon.te );
		fprintf( ioQQQ, " This is zone number%4ld\n", nzone );
	}

#	ifdef DEBUG_FUN
	fputs( " <->ContNegative()\n", debug_fp );
#	endif
	return;
}

