/* This file is part of Cloudy and is copyright (C)1978-2006 by Gary J. Ferland
 * For conditions of distribution and use see copyright notice in license.txt */
double BevFunctn( 
	  double x[], 
	  long i, 
	  double a[] );

double BevFctn(
	  double x[], 
	  long i, 
	  long j, 
	  long m[] );

double agauss(double x, 
	  double averag, 
	  double sigma);

double area(double x[], 
	  double y[], 
	  long int npts, 
	  long int nterms);


void chifit(double X[], 
	  double Y[], 
	  double SIGMAY[], 
	  long int NPTS, 
	  long int NTERMS, 
	  long int MODE, 
	  double A[], 
	  double DELTAA[], 
	  double SIGMAA[], 
	  double YFIT[], 
	  double *CHISQR);

void curfit(double X[], 
	  double Y[], 
	  double SIGMAY[], 
	  long int NPTS, 
	  long int NTERMS, 
	  long int MODE, 
	  double A[], 
	  double DELTAA[], 
	  double SIGMAA[], 
	  double *FLAMDA, 
	  double YFIT[], 
	  double *CHISQR);

double determ(double ARRAY[][10], 
	  long int NORDER);

double factor(long int n);

double fchisq(double Y[], 
	  double SIGMAY[], 
	  long int NPTS, 
	  long int NFREE, 
	  long int MODE, 
	  double YFIT[]);

void fderiv(double x[], 
	  long int i, 
	  double a[], 
	  double deltaa[], 
	  long int nterms, 
	  double deriv[]);

double bev_gamma(double x);

void gradls(double X[], 
	  double Y[], 
	  double SIGMAY[], 
	  long int NPTS, 
	  long int NTERMS, 
	  long int MODE, 
	  double A[], 
	  double DELTAA[], 
	  double YFIT[], 
	  double *CHISQR);

void gridls(double X[], 
	  double Y[], 
	  double SIGMAY[], 
	  long int NPTS, 
	  long int NTERMS, 
	  long int MODE, 
	  double A[], 
	  double DELTAA[], 
	  double SIGMAA[], 
	  double YFIT[], 
	  double *CHISQR);

void integ(double x[], 
	  double y[], 
	  long int nterms, 
	  long int i1, 
	  double x1, 
	  double x2, 
	  double *sum);

void interp(double X[], 
	  double Y[], 
	  long int NPTS, 
	  long int *NTERMS, 
	  double XIN, 
	  double *YOUT);

void legfit(double theta[], 
	  double y[], 
	  double sigmay[], 
	  long int npts, 
	  long int norder, 
	  long int neven, 
	  long int mode, 
	  double ftest[], 
	  double yfit[], 
	  double a[], 
	  double sigmaa[], 
	  double b[], 
	  double sigmab[], 
	  double *chisqr);

/*linfit linear least squares - ret 0 if ok, 1 if disaster */
int linfit(double x[], 
	  double y[], 
	  double sigmay[], 
	  long int npts, 
	  long int mode, 
	  double *a, 
	  double *sigmaa, 
	  double *b, 
	  double *sigmab, 
	  double *r);

void matinv(double ARRAY[][10], 
	  long int NORDER, 
	  double *DET);

double pbinom(long int nobs, 
	  long int ntotal, 
	  double prob);

double pchisq(double chisqr, 
	  long int nfree);

double pcorre(double r, 
	  long int npts);

double pgauss(double x, 
	  double averag, 
	  double sigma);

double ploren(double x, 
	  double averag, 
	  double width);

void polfit(double X[], 
	  double Y[], 
	  double SIGMAY[], 
	  long int NPTS, 
	  long int NTERMS, 
	  long int MODE, 
	  double A[], 
	  double *CHISQR);

double ppoiss(long int nobs, 
	  double averag);

void regres(double x[], 
	  double y[], 
	  double sigmay[], 
	  long int npts, 
	  long int nterms, 
	  long int m[], 
	  long int mode, 
	  double yfit[], 
	  double *a0, 
	  double a[], 
	  double *sigma0, 
	  double sigmaa[], 
	  double r[], 
	  double *rmul, 
	  double *chisqr, 
	  double *ftest);

void smooth(double y[], 
	  long int npts);

void xfit(double x[], 
	  double sigmax[], 
	  long int npts, 
	  long int mode, 
	  double *xmean, 
	  double *sigmam, 
	  double *sigma);
