/* This file is part of Cloudy and is copyright (C)1978-2006 by Gary J. Ferland
 * For conditions of distribution and use see copyright notice in license.txt */

/*AtomSeqBeryllium compute level populations and emissivity for Be-sequence ions */
void AtomSeqBeryllium(double cs12, 
  double cs13, 
  double cs23, 
  EmLine * t, 
  double a30);

/*AtomSeqBoron compute cooling from 5-level boron sequence model atom */
void AtomSeqBoron(
  EmLine * t21, 
  EmLine * t31, 
  EmLine * t41, 
  EmLine * t32, 
  EmLine * t42, 
  EmLine * t52, 
  double cs51,
  double cs43,
  double cs53,
  double cd54,
  /* pump rate due to UV permitted lines */
  double pump_rate ,
  /* string used to identify calling program in case of error */
  const char *chLabel
);

/*atom_level2 do level population and cooling for two level atom */
void atom_level2(EmLine * t );

/*atom_level3 compute three level atom, 10, 21, and 20 are line */
void atom_level3(EmLine * t10, 
  EmLine * t21, 
  EmLine * t20);

/*atom_pop2 do level population for simple two level atom, no radiative transfer */
double atom_pop2(double omega, 
  double g1, 
  double g2, 
  double a21, 
  double bltz, 
  double abund);

/*atom_pop3 return value is population for 3-level atom, cm^-3 */
double atom_pop3(
	/* statictical weights of levels 1, 2, and 3 */
	double g1, double g2, double g3, 

	/* collision strengths between three levels */
	double o12, double o13, double o23, 

	/* transition probabilities between three levels */
	double a21, double a31, double a32, 

	/* excitation energy in Kelvin */
	double Tex12, double Tex23, 

	/* returned population of level 2, cm^-3 */
	float *pop2, 

	/* incoming total abundance of ion */
	double abund, 

	/* possible photodestruction of level 2, normally 0 */
	double gam2,
	
	/* excitation rates (s-1) due to "other" processes */
	double r12, 
	double r13 );

/*atom_pop5 do populations and cooling for five level atom */
void atom_pop5(double g[], 
  double ex[], 
  double cs12, 
  double cs13, 
  double cs14, 
  double cs15, 
  double cs23, 
  double cs24, 
  double cs25, 
  double cs34, 
  double cs35, 
  double cs45, 
  double a21, 
  double a31, 
  double a41, 
  double a51, 
  double a32, 
  double a42, 
  double a52, 
  double a43, 
  double a53, 
  double a54, 
  double p[], 
  float abund);

/*atom_levelN - compute populations of arbitrary n-level atom */
void atom_levelN(
	/* nlev is the number of levels to compute*/ 
	long int nlev, 
	/* ABUND is total abundance of species, used for nth equation */
	float abund, 
	/* G(ndim) is stat weight of levels */
	double g[], 
	/* EX(ndim) is excitation potential of levels, either wn or deg K
	 * 0 for first one, NOT d(ENER), but energy rel to ground */
	double ex[], 
	/* this is 'K' for above ex[] as Kelvin deg, is 'w' for wavenumbers */
	char chExUnits,
	/* populations of each level as deduced here */
	double pops[], 
	/* departure coefficient derived here */
	double depart[],
	/* net transition rate, A * esc prob, s-1 */
	double ***AulEscp, 
	/* col str rom up to low */
	double ***col_str, 
	/* AulDest(ilo,ihi) is destruction rate, from up to low, A * dest prob, [s-1],
	 * asserts confirm that ihi,lo is zero */
	double ***AulDest, 
	/* AulPump(lo, hi) is pumping rate, A * occ num, (hi,lo) must be zero, [s-1]  */
	double ***AulPump, 
	/* collision rates, evaluated here and returned for cooling by calling function,
	 * unless following flag is true.  If true then calling function has already filled
	 * in these rates.  CollRate[i][j] is rate from i to j */
	double ***CollRate,
	/* this is an additional creation rate, normally zero, units cm-3 s-1 */
	double create[] ,
	/* flag saying whether CollRate already done, or we need to do it here */
	/* this is an additional destruction rate to continuum, normally zero, units s-1 */
	double destroy[] ,
	int lgCollRateDone,
	/* 2D array of integer indices for line energy in continuum array, used
	 * for setting ots rates.  ignored if zero, indices are [low][high]
	long int ***ipdest, */
	/* total cooling and its derivative, set here but nothing done with it*/
	double *cooltl, 
	double *coolder, 
	/* string used to identify calling program in case of error */
	const char *chLabel, 
	/* lgNegPop flag indicating what we have done
	 * positive if negative populations occurred
	 * zero if normal calculation done
	 * negative if too cold (for some atoms other routine will be called in this case) */
	int *lgNegPop,
	/* true if populations are zero, either due to zero abundance of very low temperature */
	int *lgZeroPop ,
	/* option to print matrices for debugging */
	int lgDeBug);
	/* side-effects of this routine:
	 * atoms.PopLevels[n], atoms.DepLTELevels[n] are set
	 * lines added to ots array 
	 */

/*atom_oi drive the solution of OI level populations, Ly-beta pumping */
void atom_oi_calc(double *coloi);

/* number of levels in OI atom */
#define N_OI_LEVELS	6

EXTERN struct t_atom_oi {

	/* photo excitation of excited state of NI */
	float p2nit,
		d5200r;

	/* collisional rates */
	double c12,
		c13;

	/* array indices for level energies for OI bowen problem,
	 * used to generate Boltzmann factors */
	long int ipoiex[5];

	/* number of negative OI level populations in current calculation */
	long int nNegOI;

	/* populations from OI fluorescense problem */
	float popoi[N_OI_LEVELS];

	double pmph31,
		esch31;

	float pmpo51, 
		pmpo15;

	/* excited state of Mg+ */
	float xMg2Max,
		/* its population */
		popmg2;

#define	LIMLEVELN	20L
	/*
	 * this stores most recently evaluated level populations
	 * resulting from the leven family of routines
	 * PopLevels is population (cm^-3) of the levels
	 * DepLevels is lte departure coef
	 */
	double PopLevels[LIMLEVELN+1], 
	  DepLTELevels[LIMLEVELN+1] ;

	}	atoms;
