/* This file is part of Cloudy and is copyright (C)1978-2006 by Gary J. Ferland
 * For conditions of distribution and use see copyright notice in license.txt */
/* yield.h */
/* there are fewer lines than this in the mewe fluores file */
#define	MEWE_FLUOR	12000
EXTERN struct t_yield {
	/* block data of yields from Mewe paper
	 * frac_elec_eject( nelem, nstage, nshell, nelec )
	 * nelem is element number, 6 for carbon
	 * nstage is stage of ionization, 1 for atom
	 * nshell is shell number in dima notation
	 * nelec is fraction that yield that number of electrons
	 * n_elec_eject is number of electrons at most */
	float frac_elec_eject[30][30][7][10];
	long int n_elec_eject[30][30][7];

	/* there are fewer than MEWE_FLUOR different lines in the fluores file,
	 * remember the atomic number, ionization stage */
	int nfl_nelem[MEWE_FLUOR] , 
		nfl_ion[MEWE_FLUOR] ,
		nfl_nshell[MEWE_FLUOR] ,
		nfl_ion_emit[MEWE_FLUOR] ,
		nfl_nLine[MEWE_FLUOR];
	float fl_energy[MEWE_FLUOR],
		/* fluorescense yield */
		fl_yield[MEWE_FLUOR];
	long int nfl_ipoint[MEWE_FLUOR];

	/* this is the total number of fluorescent lines */
	long int nfl_lines;

	/* this is set true with the "no auger" command, formally false */
	int lgKillAuger;
	}	yield;

