/* This file is part of Cloudy and is copyright (C)1978-2006 by Gary J. Ferland
 * For conditions of distribution and use see copyright notice in license.txt */
/* timesc.h */
EXTERN struct t_timesc {
	/* timescales tracked by the code, some set in checkage, some in radinc */

	/* compton equilibrium timescale */
	double tcmptn;

	/* thermal timescale */
	double ttherm;

	/* hydrogen recombination timescale */
	double threc; 

	/* sound is sound travel time (sec) updated in radinc */
	double sound;

	/* age of cloud set with age command */
	float CloudAgeSet;

	/* local and longest timescales for CO and H2 molecules to form */
	double 
	  AgeCOMoleDest, 
	  time_H2_Dest_longest, 
	  time_H2_Form_longest, 
	  time_H2_Dest_here, 
	  time_H2_Form_here, 
	  BigCOMoleForm;

	/* isothermal sound speed */
	double sound_speed_isothermal;

	/* adiabatic sound speed assuming monatomic gas - gamnma is 5/3*/
	double sound_speed_adiabatic;

	/* timescale for photoerosion of iron due to gamma rays */
	float TimeErode;

	/* H 21 cm line to come into equilibrium */
	double TimeH21cm;

	}	timesc;

