/* This file is part of Cloudy and is copyright (C)1978-2006 by Gary J. Ferland
 * For conditions of distribution and use see copyright notice in license.txt */
/* thermal.h */

#define	NCOLNT	10000L

/*tfidle update some temperature dependent variables */
void tfidle(
	/* option to force update of all variables */
	int lgForceUpdate);

EXTERN struct t_thermal {

	/* change in temperature */
	double dTemper;

	/* flag saying whether to use temperature predictor for next zone, 
	 * in constant density models */
	int lgPredNextTe;

	/* this variable is normally false, and is set true
	 * in ParseConstant if a constant temperture model is to be computed */
	int lgTSetOn;

	/* initial temperature to try to force soln, set with force command
	 * also set with other constant temper commands */
	float ConstTemp;

	/* constant grain temperature */
	float ConstGrainTemp;

	/* keep track of possibly thermall unstagle models
	 * nUnstable is number of zones that were possibly thermall unstable
	 * lgUnstable is set in ionte and says that current consitions possibly unstable */
	long int nUnstable;
	int lgUnstable;

	/* remember the highest and lowest temperature that occurs in the model */
	float thist, 
	  tlowst;

	/* flag set if temperature map is from hot to cool, set with high command */
	int lgTeHigh;

	/* flag set if energy density of rad field greater tha
	* compton temp - this is unphysical but could be set
	* by users */
	int lgEdnGTcm;

	/* flag saying that temperature law has been specified with tlaw command */
	int lgTLaw;

	/* flag to do Berltodi & Draine simple temperature law,
	 * set with tlaw bd96 */
	int lgTeBD96;
	/* the initial temperature in their equation */
	float T0BD96,
		/* the coefficient on column density for temp dropoff */
		SigmaBD96;

	/* these incorporate the Sternberg & Neufeld density/temperature relationship */
	float T0SN99;
	int lgTeSN99;

	/* remember strongest coolants
	 * these save arrays of line heating and cooling
	 * CoolAdd is called by n level cooling routines, and CoolAdd
	 * fills in cooling (cooling) or heating (heatnt)
	 * heatnt is always positive, although it is negative cooling */
	float collam[NCOLNT];
	double cooling[NCOLNT], 
	  heatnt[NCOLNT];
	long int ncltot;
	char chClntLab[NCOLNT][5];

	/* set false during during search for equilibrium temp
	 * check whether to complain about negative cooling */
	int lgColNeg;

	/* flag set true during cooling map, saying to keep cool even
	 * if cooling is negative */
	int lgCNegChk;

	/* max of negative coolants, and a pointer to it */
	float CoolHeatMax;
	float wlCoolHeatMax;
	char chCoolHeatMax[5];

	/* integrated cooling over model */
	double totcol, 

	  /* cooling in this zone */
	  ctot, 

	  /* heatl is total line heating, t(ipLnHeat) */
	  heatl,  

	  /*coolheat is other coolants that were heat sources */
	  coolheat;

	/* derivative of cooling wrt temperature */
	double dCooldT;

	/* derivative of cooling, 1/te^2, .5/T */
	float tsq1, 
	  halfte;

	/* this is set to phycon.te in tfidle, is used to insure that all temp
	 * vars are properly updated when conv_ionizeopacitydo is called 
	 * NB must be same type as phycon.te */
	double te_update;

	/* info about 'extra' cooling, lgCextOn says it is on */
	int lgCExtraOn;
	float CoolExtra, 
	  cextpw;

	/* this flag indicates (TRUE) that we are between when cooling was set to
	 * zero with call to CoolZero, and when final sum was used.  Any call
	 * after final summation in CoolSum, where set (FALSE), would be 
	 * ignored and so is fatal error */
	int lgCoolEvalOK;

	/* value of, and pointer to, strongest g-bar cooling line */
	float GBarMax;
	long int ipMaxExtra;

	/* heating - cooling due to charge transfer ionization / recombination */
	double char_tran_heat , char_tran_cool;
	
	/*HeatNet is heating due to individual species */
	double HeatNet, 

		/* this is the part of the heating that cannot do secondary ionizations */
		HeatLowEnr ,

		/* this is the part of the heating that does secondaries, but without efficiency */
		HeatHiEnr ,

		/* total heat input to this zone */
		htot, 

		/* total energy input over calculated structure, updated in lines */
		power, 

		/* derivative of total heating in this zone, evaluated in SumHeat*/
		dHeatdT;

		/* heating per unit vol, erg cm^-3 s^-1, heating[nelem][ion]  */
		double heating[LIMELM][LIMELM];

		/* total free free heating integrated over model */
		double FreeFreeTotHeat;

	/* HeatLineMax is largest fractional heating due to lines */
	float HeatLineMax;
	long int levlmax, 
	  ipHeatlmax;

	/* grid to remember heating cooling history */
#	define	NGRID	100

	float TeGrid[NGRID], 
	  HtGrid[NGRID], 
	  ClGrid[NGRID];

	long int ipGrid, 
	  nZonGrid[NGRID];
	  
}	thermal;
